package io.dcloud.feature.gg.dcloud;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import com.dcloud.android.downloader.DownloadService;
import com.dcloud.android.downloader.callback.DCDownloadManager;
import com.dcloud.android.downloader.callback.DownloadListener;
import com.dcloud.android.downloader.domain.DownloadInfo;
import com.dcloud.android.downloader.exception.DownloadException;
import io.dcloud.common.DHInterface.ILoadCallBack;
import io.dcloud.common.DHInterface.IWebview;
import io.dcloud.common.adapter.util.DeviceInfo;
import io.dcloud.common.util.ADUtils;
import io.dcloud.common.util.NetTool;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.common.util.ThreadPool;
import io.dcloud.feature.gg.dcloud.ADHandler;
import java.io.File;
import java.util.HashMap;
import org.json.JSONObject;

public class ADSim {
    public static final int INTISPLSH = 10000;
    ADHandler.AdData mAdData = null;
    private Context mContext;
    JSONObject mData;
    Handler mHandler = null;

    public ADSim(Context context, JSONObject jSONObject) {
        this.mData = jSONObject;
        this.mContext = context;
        this.mHandler = new Handler(context.getMainLooper()) {
            /* class io.dcloud.feature.gg.dcloud.ADSim.AnonymousClass1 */

            public void handleMessage(Message message) {
                super.handleMessage(message);
                if (message.what == 10000) {
                    ADSim.this.initSimSplsh();
                }
            }
        };
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void click() {
        ADHandler.log("shutao", "ADSim---click");
        Context context = this.mContext;
        ADHandler.click(context, this.mAdData, ADHandler.get(context, "adid"));
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private ADHandler.AdData crateAdData(JSONObject jSONObject) {
        ADHandler.AdData adData = new ADHandler.AdData();
        JSONObject optJSONObject = jSONObject.optJSONObject("data");
        if (optJSONObject != null) {
            adData.mProvider = jSONObject.optString("provider");
            adData.mJsonData = jSONObject;
            adData.mEShow = jSONObject.optInt("es", 0);
            adData.mEClick = jSONObject.optInt("ec", 0);
            adData.mImgSrc = optJSONObject.optString("src");
            adData.mImgData = "000";
            adData.mOriginalAppid = ADHandler.get("appid");
        }
        return adData;
    }

    public static void dwApp(final Context context, final String str, final String str2, final String str3, String str4, String str5, ILoadCallBack iLoadCallBack, final String str6) {
        ADUtils.downloadCommit(context, str, str2, str3, 29, null, null, str6);
        final DCDownloadManager downloadManager = DownloadService.getDownloadManager(context.getApplicationContext());
        String str7 = DeviceInfo.sDeviceRootDir + "/Download/" + "ADSIM-INFO.io";
        File file = new File(str7);
        if (file.exists()) {
            file.delete();
        }
        for (DownloadInfo downloadInfo : downloadManager.findAllDownloading()) {
            if (downloadInfo.getUri().equals(str4)) {
                downloadManager.remove(downloadInfo);
            }
        }
        DownloadInfo build = new DownloadInfo.Builder().setUrl(str4).setPath(str7).build(context);
        if (iLoadCallBack != null) {
            build.setTag(iLoadCallBack);
        }
        build.setDownloadListener(new DownloadListener() {
            /* class io.dcloud.feature.gg.dcloud.ADSim.AnonymousClass5 */

            @Override // com.dcloud.android.downloader.callback.DownloadListener
            public void onDownloadFailed(DownloadInfo downloadInfo, DownloadException downloadException) {
                ADUtils.downloadCommit(context, str, str2, str3, 32, null, null, str6);
                File file = new File(downloadInfo.getPath());
                if (file.exists()) {
                    file.delete();
                }
                downloadManager.remove(downloadInfo);
            }

            @Override // com.dcloud.android.downloader.callback.DownloadListener
            public void onDownloadSuccess(DownloadInfo downloadInfo) {
                if (downloadInfo.getTag() != null && (downloadInfo.getTag() instanceof ILoadCallBack)) {
                    ((ILoadCallBack) downloadInfo.getTag()).onCallBack(0, downloadInfo.getContext(), null);
                }
                ADUtils.downloadCommit(context, str, str2, str3, 30, null, null, str6);
                File file = new File(downloadInfo.getPath());
                if (file.exists()) {
                    file.delete();
                }
                downloadManager.remove(downloadInfo);
            }

            @Override // com.dcloud.android.downloader.callback.DownloadListener
            public void onDownloading(long j, long j2) {
            }

            @Override // com.dcloud.android.downloader.callback.DownloadListener
            public void onPaused() {
            }

            @Override // com.dcloud.android.downloader.callback.DownloadListener
            public void onRemoved() {
            }

            @Override // com.dcloud.android.downloader.callback.DownloadListener
            public void onStart() {
            }

            @Override // com.dcloud.android.downloader.callback.DownloadListener
            public void onWaited() {
            }
        });
        downloadManager.download(build);
    }

    public static int getRandomInt(int i, int i2) {
        double d = (double) i;
        double random = Math.random();
        double d2 = (double) ((i2 - i) + 1);
        Double.isNaN(d2);
        Double.isNaN(d);
        return (int) (d + (random * d2));
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void initAdImg(final String str, final String str2) {
        ThreadPool.self().addThreadTask(new Runnable() {
            /* class io.dcloud.feature.gg.dcloud.ADSim.AnonymousClass3 */

            public void run() {
                HashMap hashMap = new HashMap();
                if (!PdrUtil.isEmpty(str2) && str2.equalsIgnoreCase("webview")) {
                    hashMap.put(IWebview.USER_AGENT, ADHandler.get("ua-webview"));
                }
                try {
                    if (NetTool.httpGet(str, (HashMap<String, String>) hashMap, true) != null) {
                        ADSim.this.mHandler.sendEmptyMessage(ADSim.INTISPLSH);
                    }
                } catch (Exception unused) {
                }
            }
        });
    }

    private void initClick() {
        if (this.mAdData.isEClick()) {
            this.mHandler.postDelayed(new Runnable() {
                /* class io.dcloud.feature.gg.dcloud.ADSim.AnonymousClass4 */

                public void run() {
                    ADSim.this.click();
                }
            }, (long) getRandomInt(800, 2000));
        }
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void initSimSplsh() {
        ADHandler.log("shutao", "ADSim---view");
        Context context = this.mContext;
        ADHandler.view(context, this.mAdData, ADHandler.get(context, "adid"));
        initClick();
    }

    public static void openUrl(Context context, String str) {
        ADHandler.log("shutao", "ADSim---openUrl");
        new AolWebView(context).loadUrl(str);
    }

    public void start() {
        this.mHandler.postDelayed(new Runnable() {
            /* class io.dcloud.feature.gg.dcloud.ADSim.AnonymousClass2 */

            public void run() {
                ADSim aDSim = ADSim.this;
                aDSim.mAdData = aDSim.crateAdData(aDSim.mData);
                ADHandler.AdData adData = ADSim.this.mAdData;
                if (adData != null) {
                    String optString = adData.full() != null ? ADSim.this.mAdData.full().optString("ua") : "";
                    ADSim aDSim2 = ADSim.this;
                    aDSim2.initAdImg(aDSim2.mAdData.mImgSrc, optString);
                }
            }
        }, (long) getRandomInt(250, 350));
    }
}
