package io.dcloud.feature.gg.dcloud;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Base64;
import android.view.MotionEvent;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.dcloud.android.widget.dialog.DCloudAlertDialog;
import com.facebook.common.callercontext.ContextChain;
import com.taobao.weex.common.Constants;
import com.taobao.weex.common.WXConfig;
import com.taobao.weex.el.parse.Operators;
import com.taobao.weex.performance.WXInstanceApm;
import com.taobao.weex.ui.component.WXBasicComponentType;
import com.taobao.weex.ui.component.WXComponent;
import io.dcloud.application.DCLoudApplicationImpl;
import io.dcloud.common.DHInterface.DAI;
import io.dcloud.common.DHInterface.IWebview;
import io.dcloud.common.adapter.io.DHFile;
import io.dcloud.common.adapter.util.Logger;
import io.dcloud.common.adapter.util.PlatformUtil;
import io.dcloud.common.adapter.util.SP;
import io.dcloud.common.constant.AbsoluteConst;
import io.dcloud.common.util.ADUtils;
import io.dcloud.common.util.AESUtil;
import io.dcloud.common.util.AppRuntime;
import io.dcloud.common.util.BaseInfo;
import io.dcloud.common.util.CreateShortResultReceiver;
import io.dcloud.common.util.JSUtil;
import io.dcloud.common.util.NetTool;
import io.dcloud.common.util.NetworkTypeUtil;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.common.util.TelephonyUtil;
import io.dcloud.common.util.TestUtil;
import io.dcloud.common.util.ThreadPool;
import io.dcloud.common.util.ZipUtils;
import io.dcloud.common.util.hostpicker.HostPicker;
import io.dcloud.e.c.g;
import io.dcloud.e.c.h.c;
import io.dcloud.feature.gg.AolSplashUtil;
import io.dcloud.feature.gg.dcloud.ADResult;
import io.dcloud.feature.uniapp.adapter.AbsURIAdapter;
import io.dcloud.h.c.a;
import io.dcloud.h.c.c.b.b.d;
import io.dcloud.h.c.c.c.b;
import io.dcloud.sdk.core.DCloudAOLManager;
import io.dcloud.sdk.core.util.Const;
import io.dcloud.sdk.poly.base.utils.PrivacyManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ADHandler {
    public static final String AdTag = "_adio.dcloud.feature.ad.dcloud.ADHandler";
    private static final String File_Data = "data.json";
    private static final String File_Gif = "img.gif";
    private static final String File_Img = "img.png";
    private static final String File_S = "s.txt";
    private static final String File_Tid = "tid.txt";
    private static LinkedList<File> expiresFileList = null;
    private static d handler = null;
    static boolean isPullFor360 = false;
    static boolean sNeedShowSkipView = false;
    static long sPullBeginTime;

    public static class ADReceiver implements IAolReceiver {
        Context mContext = null;
        long mStartTime = System.currentTimeMillis();

        public ADReceiver(Context context) {
            this.mContext = context;
        }

        private void broadcastADReceive() {
            Intent intent = new Intent();
            intent.setAction("ad_receive");
            intent.putExtra("begin", this.mStartTime);
            intent.putExtra("end", System.currentTimeMillis());
            this.mContext.sendBroadcast(intent);
            ADHandler.log("ADReceive", "broadcastADReceive");
        }

        private void pap(JSONObject jSONObject) {
            if (jSONObject != null && Boolean.valueOf(jSONObject.has("pap")).booleanValue()) {
                Context context = this.mContext;
                boolean z = true;
                if (jSONObject.optInt("pap") != 1) {
                    z = false;
                }
                ADHandler.handleSplashAdEnable(context, Boolean.valueOf(z));
            }
        }

        @Override // io.dcloud.feature.gg.dcloud.IAolReceiver
        public void onError(String str, String str2) {
            broadcastADReceive();
        }

        @Override // io.dcloud.feature.gg.dcloud.IAolReceiver
        public void onReceiver(JSONObject jSONObject) {
            JSONArray optJSONArray = jSONObject.optJSONArray("psas");
            boolean z = true;
            if (jSONObject.optInt("pap", 0) != 1) {
                z = false;
            }
            SP.setBundleData(this.mContext, ADHandler.AdTag, "dpap", jSONObject.optString("dpap", WXInstanceApm.VALUE_ERROR_CODE_DEFAULT));
            if (optJSONArray == null || !z) {
                ADHandler.log("ADReceiver", "onReceiver no data = " + jSONObject);
            } else {
                long currentTimeMillis = System.currentTimeMillis();
                int length = optJSONArray.length();
                ADHandler.log("ADReceiver", "onReceiver psas.length = " + length + "; data=" + jSONObject);
                for (int i = 0; i < length; i++) {
                    ADHandler.handleAdData(this.mContext, optJSONArray.optJSONObject(i), currentTimeMillis);
                }
            }
            if (!ADHandler.isPullFor360) {
                broadcastADReceive();
            }
        }
    }

    public static class AdData {
        int mEClick = 0;
        int mEShow = 0;
        public Object mImgData;
        String mImgPath;
        String mImgSrc;
        JSONObject mJsonData;
        MotionEvent mMotionEvent_down;
        MotionEvent mMotionEvent_up;
        String mOriginalAppid;
        String mProvider;

        /* access modifiers changed from: package-private */
        public boolean check() {
            return (this.mJsonData == null || this.mImgData == null) ? false : true;
        }

        /* access modifiers changed from: package-private */
        public JSONObject data() {
            return this.mJsonData.optJSONObject("data");
        }

        /* access modifiers changed from: package-private */
        public JSONObject full() {
            return this.mJsonData;
        }

        /* access modifiers changed from: package-private */
        public boolean isEClick() {
            return this.mEClick == 1;
        }

        /* access modifiers changed from: package-private */
        public boolean isEShow() {
            return this.mEShow == 1;
        }

        /* access modifiers changed from: package-private */
        public void listenADReceive(Context context, final IAolReceiver iAolReceiver) {
            if (iAolReceiver != null) {
                AnonymousClass1 r0 = new BroadcastReceiver() {
                    /* class io.dcloud.feature.gg.dcloud.ADHandler.AdData.AnonymousClass1 */

                    public void onReceive(Context context, Intent intent) {
                        try {
                            long longExtra = intent.getLongExtra("end", 0) - intent.getLongExtra("begin", 0);
                            ADHandler.log("ADReceive", "useTime=" + longExtra);
                            if (longExtra <= 3000) {
                                iAolReceiver.onReceiver(null);
                            }
                            ADHandler.log("ADReceive", "unregisterReceiver");
                            context.unregisterReceiver(this);
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                };
                try {
                    IntentFilter intentFilter = new IntentFilter();
                    intentFilter.addAction("ad_receive");
                    LocalBroadcastManager.getInstance(context).registerReceiver(r0, intentFilter);
                    ADHandler.log("ADReceive", "registerReceiver");
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        /* access modifiers changed from: package-private */
        public JSONObject report() {
            return this.mJsonData.optJSONObject("report");
        }
    }

    /* access modifiers changed from: package-private */
    public interface AdDataWatcher<E> {
        boolean find();

        void operate(E e);
    }

    /* access modifiers changed from: package-private */
    public interface ThreadTask {
        void execute();
    }

    public static Boolean SplashAdIsEnable(Context context) {
        if (g.b()) {
            return Boolean.FALSE;
        }
        if (handler == null) {
            handler = (d) a.d().a();
        }
        return Boolean.valueOf(handler.a(context));
    }

    private static void addThreadTask(final ThreadTask threadTask) {
        if (threadTask == null) {
            return;
        }
        if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
            ThreadPool.self().addThreadTask(new Runnable() {
                /* class io.dcloud.feature.gg.dcloud.ADHandler.AnonymousClass3 */

                public void run() {
                    ThreadTask.this.execute();
                }
            });
        } else {
            threadTask.execute();
        }
    }

    public static boolean allReady(Context context) {
        return !TextUtils.isEmpty(get(context, "appid"));
    }

    /* access modifiers changed from: private */
    /* JADX WARNING: Failed to process nested try/catch */
    /* JADX WARNING: Missing exception handler attribute for start block: B:10:0x0042 */
    public static void analysisPullData(byte[] bArr, String str, IAolReceiver... iAolReceiverArr) throws JSONException {
        d dVar;
        if (bArr != null) {
            JSONObject jSONObject = new JSONObject(new String(bArr));
            int optInt = jSONObject.optInt("ret", -1);
            int i = 0;
            if (optInt == 0) {
                if (jSONObject.has("data")) {
                    String decrypt = AESUtil.decrypt(io.dcloud.f.a.c(), io.dcloud.f.a.b(), Base64.decode(jSONObject.optString("data"), 2));
                    if (decrypt != null) {
                        JSONObject jSONObject2 = new JSONObject(decrypt);
                        AolSplashUtil.decodeChannel(jSONObject2);
                        jSONObject.put("data", jSONObject2);
                        try {
                            jSONObject.put("data", new JSONArray(decrypt));
                        } catch (Exception unused) {
                        }
                    }
                }
                int length = iAolReceiverArr.length;
                while (i < length) {
                    iAolReceiverArr[i].onReceiver(jSONObject);
                    i++;
                }
                if ((str.equals("ThirdConfig") || str.equals("Splash")) && (dVar = handler) != null) {
                    dVar.a(jSONObject);
                    return;
                }
                return;
            }
            int length2 = iAolReceiverArr.length;
            while (i < length2) {
                iAolReceiverArr[i].onError(String.valueOf(optInt), jSONObject.optString("desc"));
                i++;
            }
            d dVar2 = handler;
            if (dVar2 != null) {
                dVar2.a(-5007, jSONObject.optString("desc"));
            }
        }
    }

    static String appid(Context context) {
        return get(context, "appid");
    }

    static int bg(Context context) {
        int stringToColor = PdrUtil.stringToColor(get(context, "bg"));
        if (stringToColor != -1) {
            return stringToColor;
        }
        return -1;
    }

    static void click(final Context context, final AdData adData, final String str) {
        final String optString = adData.data().optString("tid");
        ThreadPool.self().addThreadTask(new Runnable() {
            /* class io.dcloud.feature.gg.dcloud.ADHandler.AnonymousClass9 */

            public void run() {
                JSONObject jSONObject;
                int i;
                if (!AdData.this.isEClick()) {
                    jSONObject = ADHandler.getClickData(AdData.this);
                    i = 41;
                } else {
                    jSONObject = null;
                    i = 46;
                }
                JSONObject full = AdData.this.full();
                c.a(context, AdData.this.mOriginalAppid, optString, str, i, null, null, jSONObject, null, null, AolSplashUtil.getSplashAdpId("_adpid_", "UNIAD_SPLASH_ADPID"), (full == null || !full.has("ua")) ? "" : full.optString("ua"), null);
            }
        });
        if ("wanka".equals(adData.mProvider)) {
            ADHandler_wanka.click_wanka(context, adData, str);
        } else if ("youdao".equals(adData.mProvider)) {
            ADHandler_youdao.click_youdao(context, adData, str);
        } else if ("common".equals(adData.mProvider)) {
            Aolhandler_common.click_common(context, adData, str);
        } else {
            click_base(context, adData, str);
        }
    }

    static void click_base(final Context context, final AdData adData, final String str) {
        JSONObject data = adData.data();
        final String optString = adData.data().optString("tid");
        if (!data.has("dplk") || !ADUtils.openDeepLink(context, data.optString("dplk"))) {
            String optString2 = data.optString("action");
            if (TextUtils.equals("url", optString2)) {
                if (adData.isEClick()) {
                    ADSim.openUrl(context, data.optString("url"));
                } else {
                    ADUtils.openUrl(context, data.optString("url"));
                }
            } else if (TextUtils.equals(AbsoluteConst.SPNAME_DOWNLOAD, optString2)) {
                if (data.has("expires")) {
                    try {
                        new SimpleDateFormat("yy-MM-dd HH:mm:ss", Locale.ENGLISH).parse(data.optString("expires")).getTime();
                    } catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
                String optString3 = adData.full() != null ? adData.full().optString("ua") : "";
                if (adData.isEClick()) {
                    ADSim.dwApp(context, adData.mOriginalAppid, optString, str, data.optString("url"), data.optString(AbsURIAdapter.BUNDLE), null, optString3);
                }
            } else if (!TextUtils.equals(AbsoluteConst.XML_STREAMAPP, optString2) || !data.has("appid")) {
                if (TextUtils.equals("browser", optString2) && !adData.isEClick()) {
                    ADUtils.openBrowser(context, data.optString("url"));
                }
            } else if (!adData.isEClick()) {
                ADUtils.openStreamApp(context, data.optString("appid"), data.optJSONObject("parameters"), -1, data.optString("streamapps"));
            }
        } else if (!adData.isEClick()) {
            ThreadPool.self().addThreadTask(new Runnable() {
                /* class io.dcloud.feature.gg.dcloud.ADHandler.AnonymousClass8 */

                public void run() {
                    JSONObject full = AdData.this.full();
                    TestUtil.PointTime.commitTid(context, AdData.this.mOriginalAppid, optString, str, 50, AolSplashUtil.getSplashAdpId("_adpid_", "UNIAD_SPLASH_ADPID"), false, (full == null || !full.has("ua")) ? "" : full.optString("ua"));
                }
            });
            if ("wanka".equals(adData.mProvider)) {
                ADHandler_wanka.dplk_wanka(context, adData, str);
            } else if ("youdao".equals(adData.mProvider)) {
                ADHandler_youdao.dplk_youdao(context, adData, str);
            } else if ("common".equals(adData.mProvider)) {
                Aolhandler_common.handletask_common(context, adData, str, "dptracker");
            }
        }
    }

    private static Boolean defAdConfig(Context context) {
        try {
            return Boolean.valueOf(context.getPackageManager().getApplicationInfo(context.getPackageName(), 128).metaData.getBoolean("DCLOUD_AD_SPLASH", false));
        } catch (Exception e) {
            e.printStackTrace();
            return Boolean.FALSE;
        }
    }

    private static void exec5Plus(final List<HostPicker.Host> list, String str, final IAolReceiver[] iAolReceiverArr) {
        String str2;
        try {
            str2 = URLEncoder.encode(Base64.encodeToString(AESUtil.encrypt(io.dcloud.f.a.c(), io.dcloud.f.a.b(), ZipUtils.zipString(str)), 2), "utf-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            str2 = null;
        }
        final String str3 = "edata=" + str2;
        final boolean z = !hasOtherAd();
        addThreadTask(new ThreadTask() {
            /* class io.dcloud.feature.gg.dcloud.ADHandler.AnonymousClass2 */

            @Override // io.dcloud.feature.gg.dcloud.ADHandler.ThreadTask
            public void execute() {
                List list = list;
                if (list != null) {
                    ADHandler.pull(list, "ThirdConfig", str3, z, iAolReceiverArr);
                    return;
                }
                ArrayList arrayList = new ArrayList();
                for (String str : b.b.keySet()) {
                    HostPicker.Host.PriorityEnum priorityEnum = HostPicker.Host.PriorityEnum.BACKUP;
                    int intValue = b.b.get(str).intValue();
                    if (intValue != -1) {
                        if (intValue == 0) {
                            priorityEnum = HostPicker.Host.PriorityEnum.NORMAL;
                        } else if (intValue == 1) {
                            priorityEnum = HostPicker.Host.PriorityEnum.FIRST;
                        }
                    }
                    arrayList.add(new HostPicker.Host(str, priorityEnum));
                }
                ADHandler.pull(arrayList, "Splash", str3, z, iAolReceiverArr);
            }
        });
    }

    /* access modifiers changed from: private */
    public static void fileAdData(Context context, File file, AdData adData) {
        try {
            JSONObject jSONObject = new JSONObject(new String(DHFile.readAll(file.getAbsolutePath() + "/" + File_Data)));
            JSONObject optJSONObject = jSONObject.optJSONObject("data");
            if (optJSONObject != null) {
                adData.mProvider = jSONObject.optString("provider");
                adData.mJsonData = jSONObject;
                adData.mEShow = jSONObject.optInt("es", 0);
                adData.mEClick = jSONObject.optInt("ec", 0);
                String optString = optJSONObject.optString("src");
                adData.mImgSrc = optString;
                boolean endsWith = optString.toLowerCase(Locale.ENGLISH).endsWith(".gif");
                StringBuilder sb = new StringBuilder();
                sb.append(file.getAbsolutePath());
                sb.append("/");
                sb.append(endsWith ? File_Gif : File_Img);
                String sb2 = sb.toString();
                String str = file.getAbsolutePath() + "/" + File_S;
                if (new File(sb2).exists() && !new File(str).exists()) {
                    if (endsWith) {
                        adData.mImgData = PlatformUtil.newInstance("pl.droidsonroids.gif.GifDrawable", new Class[]{String.class}, new Object[]{jSONObject.optString("srcPath")});
                    } else {
                        Bitmap decodeFile = BitmapFactory.decodeFile(sb2);
                        if (decodeFile != null) {
                            adData.mImgData = decodeFile;
                        }
                    }
                    adData.mImgPath = sb2;
                    new File(str).createNewFile();
                    DHFile.delete(file.getAbsolutePath());
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    static String formatUrl(String str, JSONObject jSONObject) {
        try {
            return str.replace("${User-Agent}", URLEncoder.encode(jSONObject.optString("u-a"), "utf-8")).replace("${click_id}", jSONObject.optString("click_id")).replace("${down_x}", String.valueOf(jSONObject.optInt("down_x", DCloudAlertDialog.DARK_THEME))).replace("${down_y}", String.valueOf(jSONObject.optInt("down_y", DCloudAlertDialog.DARK_THEME))).replace("${up_x}", String.valueOf(jSONObject.optInt("up_x", DCloudAlertDialog.DARK_THEME))).replace("${up_y}", String.valueOf(jSONObject.optInt("up_y", DCloudAlertDialog.DARK_THEME))).replace("${relative_down_x}", String.valueOf(jSONObject.optInt("relative_down_x", DCloudAlertDialog.DARK_THEME))).replace("${relative_down_y}", String.valueOf(jSONObject.optInt("relative_down_y", DCloudAlertDialog.DARK_THEME))).replace("${relative_up_x}", String.valueOf(jSONObject.optInt("relative_up_x", DCloudAlertDialog.DARK_THEME))).replace("${relative_up_y}", String.valueOf(jSONObject.optInt("relative_up_y", DCloudAlertDialog.DARK_THEME)));
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return str;
        }
    }

    private static void get(StringBuilder sb, String str, String str2) {
        try {
            Class.forName(io.dcloud.f.a.b(str));
            sb.append(",");
            sb.append(str2);
        } catch (Exception unused) {
        }
    }

    static JSONObject getArgsJsonData(JSONObject jSONObject) {
        JSONObject jSONObject2 = new JSONObject();
        try {
            jSONObject2.put("ua", jSONObject.optString("ua"));
            jSONObject2.put("down_x", jSONObject.optInt("down_x"));
            jSONObject2.put("down_y", jSONObject.optInt("down_y"));
            jSONObject2.put("up_x", jSONObject.optInt("up_x"));
            jSONObject2.put("up_y", jSONObject.optInt("up_y"));
            jSONObject2.put("relative_down_x", jSONObject.optInt("relative_down_x"));
            jSONObject2.put("relative_down_y", jSONObject.optInt("relative_down_y"));
            jSONObject2.put("relative_up_x", jSONObject.optInt("relative_up_x"));
            jSONObject2.put("relative_up_y", jSONObject.optInt("relative_up_y"));
        } catch (Exception e) {
            e.printStackTrace();
        }
        return jSONObject2;
    }

    private static String getBId() {
        try {
            File file = new File("/proc/sys/kernel/random/boot_id");
            if (file.exists()) {
                FileInputStream fileInputStream = new FileInputStream(file);
                byte[] bArr = new byte[37];
                fileInputStream.read(bArr);
                String str = new String(bArr);
                try {
                    fileInputStream.close();
                    return str;
                } catch (Exception unused) {
                    return str;
                }
            }
        } catch (Exception unused2) {
        }
        return "";
    }

    public static AdData getBestAdData(Context context, String str) {
        return getBestAdData(context, str, new AdData());
    }

    /* access modifiers changed from: private */
    public static JSONObject getClickData(AdData adData) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put(WXBasicComponentType.IMG, adData.mImgSrc);
            JSONObject full = adData.full();
            jSONObject.put("dw", full.optInt("dw"));
            jSONObject.put("dh", full.optInt("dh"));
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("dx", full.optInt("down_x"));
            jSONObject2.put(Constants.Name.DISTANCE_Y, full.optInt("down_y"));
            jSONObject2.put("ux", full.optInt("up_x"));
            jSONObject2.put("uy", full.optInt("up_y"));
            jSONObject2.put("rdx", full.optInt("relative_down_x"));
            jSONObject2.put("rdy", full.optInt("relative_down_y"));
            jSONObject2.put("rux", full.optInt("relative_up_x"));
            jSONObject2.put("ruy", full.optInt("relative_up_y"));
            jSONObject.put("click_coord", jSONObject2);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return jSONObject;
    }

    private static String getRootPath(Context context) {
        File externalCacheDir = context.getExternalCacheDir();
        if (externalCacheDir == null) {
            return "/sdcard/Android/data/" + context.getPackageName() + "/cache/ad/";
        }
        return externalCacheDir.getAbsolutePath() + "/ad/";
    }

    private static String getUT() {
        try {
            Process exec = Runtime.getRuntime().exec("stat -c \"%x\" /data/data");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(exec.getInputStream()));
            StringBuffer stringBuffer = new StringBuffer();
            char[] cArr = new char[256];
            while (true) {
                int read = bufferedReader.read(cArr);
                if (read <= 0) {
                    break;
                }
                stringBuffer.append(cArr, 0, read);
            }
            bufferedReader.close();
            exec.waitFor();
            String[] split = stringBuffer.toString().replace(JSUtil.QUOTE, "").split("\\.");
            long time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(split[0]).getTime();
            String str = split[1];
            if (str.contains(Operators.PLUS)) {
                str = str.substring(0, str.indexOf(Operators.PLUS));
            }
            long parseLong = Long.parseLong(str.trim());
            return (time / 1000) + Operators.DOT_STR + parseLong;
        } catch (Exception unused) {
            return Operators.DOT_STR;
        }
    }

    private static void handleAdBaseData(final Context context, final JSONObject jSONObject, String str, final String str2, String str3) throws Exception {
        if (jSONObject == null || !jSONObject.has("es") || jSONObject.getInt("es") != 1) {
            System.currentTimeMillis();
            byte[] bytes = str.getBytes();
            DHFile.writeFile(bytes, 0, str3 + File_Tid);
            StringBuilder sb = new StringBuilder();
            sb.append(str3);
            sb.append(str2.endsWith(".gif") ? File_Gif : File_Img);
            final String sb2 = sb.toString();
            jSONObject.put("srcPath", sb2);
            byte[] bytes2 = jSONObject.toString().getBytes();
            DHFile.writeFile(bytes2, 0, str3 + File_Data);
            addThreadTask(new ThreadTask() {
                /* class io.dcloud.feature.gg.dcloud.ADHandler.AnonymousClass12 */

                @Override // io.dcloud.feature.gg.dcloud.ADHandler.ThreadTask
                public void execute() {
                    HashMap hashMap;
                    byte[] bArr = null;
                    if (!jSONObject.has("ua") || !jSONObject.optString("ua").equalsIgnoreCase("webview")) {
                        hashMap = null;
                    } else {
                        hashMap = new HashMap();
                        hashMap.put(IWebview.USER_AGENT, ADHandler.get("ua-webview"));
                    }
                    boolean z = true;
                    try {
                        bArr = NetTool.httpGet(str2, (HashMap<String, String>) hashMap, true);
                    } catch (Exception unused) {
                    }
                    StringBuilder sb = new StringBuilder();
                    sb.append("download file is nulll");
                    sb.append(bArr == null);
                    sb.append("src=");
                    sb.append(str2);
                    ADHandler.log("shutao", sb.toString());
                    if (bArr != null) {
                        DHFile.writeFile(bArr, 0, sb2);
                    }
                    if (!ADHandler.isPullFor360) {
                        Intent intent = new Intent();
                        intent.setAction("ad_img_downlaod_receive");
                        if (bArr == null) {
                            z = false;
                        }
                        intent.putExtra("downloadImage", z);
                        intent.putExtra("src", str2);
                        LocalBroadcastManager.getInstance(context).sendBroadcast(intent);
                        ADHandler.log("shutao", "handleAdBaseData--downloadC");
                    }
                }
            });
            return;
        }
        new ADSim(context, jSONObject).start();
    }

    /* access modifiers changed from: private */
    public static void handleAdData(Context context, JSONObject jSONObject, long j) {
        try {
            String optString = jSONObject.optString("provider");
            if ("dcloud".equals(optString)) {
                handleAdData_dcloud(context, jSONObject, j);
            } else if ("wanka".equals(optString)) {
                ADHandler_wanka.handleAdData_wanka(context, jSONObject, j);
            } else if ("youdao".equals(optString)) {
                ADHandler_youdao.handleAdData_youdao(context, jSONObject, j);
            } else if ("common".equals(optString)) {
                Aolhandler_common.handleAdData_common(context, jSONObject, j);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void handleAdData_dcloud(Context context, JSONObject jSONObject, long j) throws Exception {
        String rootPath = getRootPath(context);
        JSONObject optJSONObject = jSONObject.optJSONObject("data");
        Date parse = new SimpleDateFormat("yy-MM-dd HH:mm:ss", Locale.ENGLISH).parse(optJSONObject.optString("expires"));
        if (parse.getTime() > System.currentTimeMillis()) {
            String optString = optJSONObject.optString("src");
            String encode = URLEncoder.encode(optString, "utf-8");
            handleAdBaseData(context, jSONObject, optJSONObject.optString("tid"), optString, rootPath + j + "/" + parse.getTime() + "/" + encode.hashCode() + "/");
        }
    }

    public static void handleSplashAdEnable(Context context, Boolean bool) {
        d dVar = handler;
        if (dVar != null) {
            dVar.a(context, bool.booleanValue() ? "1" : WXInstanceApm.VALUE_ERROR_CODE_DEFAULT);
        }
    }

    private static boolean hasOtherAd() {
        String bundleData = SP.getBundleData(AdTag, "pspType");
        if (!TextUtils.isEmpty(bundleData)) {
            return bundleData.contains("360") || bundleData.contains(Const.TYPE_GDT) || bundleData.contains(Const.TYPE_CSJ);
        }
        return false;
    }

    /* JADX WARNING: Removed duplicated region for block: B:10:0x0030  */
    /* JADX WARNING: Removed duplicated region for block: B:12:0x0036 A[RETURN] */
    static Drawable img(Context context) {
        Bitmap bitmap;
        String str = get(context, WXBasicComponentType.IMG);
        if (!TextUtils.isEmpty(str)) {
            if (!PdrUtil.isDeviceRootDir(str)) {
                bitmap = BitmapFactory.decodeStream(PlatformUtil.getInputStream(str, 0));
            } else if (new File(str).exists()) {
                bitmap = BitmapFactory.decodeFile(str);
            }
            if (bitmap == null) {
                return new BitmapDrawable(bitmap);
            }
            return null;
        }
        bitmap = null;
        if (bitmap == null) {
        }
    }

    private static void listExpiresAdData(Context context, AdDataWatcher<File> adDataWatcher) {
        File[] listFiles;
        File file = new File(getRootPath(context));
        if (!file.exists()) {
            file.mkdirs();
        }
        File[] listFiles2 = file.listFiles();
        if (listFiles2 != null) {
            sortDesc(listFiles2);
            for (File file2 : listFiles2) {
                if (!adDataWatcher.find()) {
                    File[] listFiles3 = file2.listFiles();
                    for (File file3 : listFiles3) {
                        if (Long.parseLong(file3.getName()) <= System.currentTimeMillis()) {
                            DHFile.delete(file3);
                        } else if (!adDataWatcher.find()) {
                            for (File file4 : file3.listFiles()) {
                                adDataWatcher.operate(file4);
                                if (adDataWatcher.find()) {
                                    break;
                                }
                            }
                        }
                    }
                } else {
                    DHFile.delete(file2);
                }
            }
        }
    }

    static void log(String str, String str2) {
    }

    static String mc(Context context) {
        if (TextUtils.isEmpty(BaseInfo.sChannel) || TextUtils.equals("default", BaseInfo.sChannel)) {
            try {
                return context.getPackageManager().getApplicationInfo(context.getPackageName(), 128).metaData.getString("DCLOUD_STREAMAPP_CHANNEL", BaseInfo.sChannel);
            } catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }
        }
        return BaseInfo.sChannel;
    }

    static String name(Context context) {
        return get(context, "name");
    }

    public static String papEnable(Context context) {
        String str = getRootPath(context).replaceAll("/ad/", "/") + "AdEnable.dat";
        try {
            if (DHFile.isExist(str)) {
                return new String(DHFile.readAll(str));
            }
            return null;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static void postSplashError(Context context, String str, String str2, JSONArray jSONArray) {
        String str3;
        HashMap hashMap = new HashMap();
        hashMap.put(ContextChain.TAG_PRODUCT, "a");
        hashMap.put(CreateShortResultReceiver.KEY_VERSIONNAME, get(CreateShortResultReceiver.KEY_VERSIONNAME));
        hashMap.put("appid", get("appid"));
        hashMap.put("name", get(context, "name"));
        hashMap.put("pn", context.getPackageName());
        try {
            str3 = context.getPackageManager().getPackageInfo(context.getPackageName(), 1).versionName;
        } catch (Exception unused) {
            str3 = null;
        }
        hashMap.put("pv", str3);
        hashMap.put(ContextChain.TAG_INFRA, Base64.encodeToString(AESUtil.encrypt(io.dcloud.f.a.c(), io.dcloud.f.a.b(), ZipUtils.zipString(TelephonyUtil.getIMEI(context, true, true))), 2));
        hashMap.put("md", Build.MODEL);
        hashMap.put("vd", Build.MANUFACTURER);
        hashMap.put(WXConfig.os, Integer.valueOf(Build.VERSION.SDK_INT));
        String str4 = "1.9.9.81993";
        if (PdrUtil.isEmpty(str4)) {
            str4 = "";
        }
        hashMap.put("vb", str4);
        hashMap.put("net", Integer.valueOf(NetworkTypeUtil.getNetworkType(context)));
        hashMap.put("mc", mc(context));
        hashMap.put("paid", get(context, "adid"));
        hashMap.put("dw", Integer.valueOf(AolSplashUtil.dw(context)));
        hashMap.put("dh", Integer.valueOf(AolSplashUtil.dh(context)));
        hashMap.put(io.dcloud.feature.ui.nativeui.c.a, str);
        hashMap.put(WXComponent.PROP_FS_MATCH_PARENT, str2);
        if (jSONArray != null) {
            hashMap.put("d", jSONArray);
        }
        final String jSONObject = new JSONObject(hashMap).toString();
        addThreadTask(new ThreadTask() {
            /* class io.dcloud.feature.gg.dcloud.ADHandler.AnonymousClass6 */

            @Override // io.dcloud.feature.gg.dcloud.ADHandler.ThreadTask
            public void execute() {
                NetTool.httpPost(PdrUtil.checkIntl() ? "https://er.dcloud.io/sc" : "https://er.dcloud.net.cn/sc", jSONObject, new HashMap());
            }
        });
    }

    public static void pr(Context context, Map<String, Object> map) {
        String str;
        map.put("name", get(context, "name"));
        try {
            str = context.getPackageManager().getPackageInfo(context.getPackageName(), 1).versionName;
        } catch (Exception unused) {
            str = null;
        }
        map.put("pv", str);
        map.put(WXConfig.os, Integer.valueOf(Build.VERSION.SDK_INT));
        String str2 = "1.9.9.81993";
        if (PdrUtil.isEmpty(str2)) {
            str2 = "";
        }
        map.put("vb", str2);
        pullRad(context, map, new ADReceiver(context), new ADResult.CADReceiver(context));
    }

    private static String psas(Context context) {
        final StringBuffer stringBuffer = new StringBuffer();
        listExpiresAdData(context, new AdDataWatcher<File>() {
            /* class io.dcloud.feature.gg.dcloud.ADHandler.AnonymousClass10 */

            @Override // io.dcloud.feature.gg.dcloud.ADHandler.AdDataWatcher
            public boolean find() {
                return false;
            }

            public void operate(File file) {
                byte[] readAll = DHFile.readAll(file.getAbsolutePath() + "/" + ADHandler.File_Tid);
                if (readAll != null) {
                    String str = new String(readAll);
                    StringBuffer stringBuffer = stringBuffer;
                    stringBuffer.append(str);
                    stringBuffer.append(",");
                }
            }
        });
        return stringBuffer.length() > 0 ? stringBuffer.substring(0, stringBuffer.length() - 1) : stringBuffer.toString();
    }

    public static void pull(final Context context, String str, boolean z, List<HostPicker.Host> list, IAolReceiver... iAolReceiverArr) {
        if (TextUtils.isEmpty(BaseInfo.sDefaultBootApp)) {
            BaseInfo.parseControl();
        }
        boolean z2 = false;
        boolean startsWith = !TextUtils.isEmpty(BaseInfo.sDefaultBootApp) ? BaseInfo.sDefaultBootApp.startsWith("__UNI__") : false;
        String[] split = mc(context).split("\\|");
        String str2 = (split == null || split.length <= 2) ? "" : split[2];
        DCloudAOLManager.InitConfig initConfig = new DCloudAOLManager.InitConfig();
        initConfig.setAdId(str2).setAppId(BaseInfo.sDefaultBootApp);
        io.dcloud.sdk.core.a.a.a(context, initConfig, new d());
        DCloudAOLManager.setPrivacyConfig(new PrivacyManager.a() {
            /* class io.dcloud.feature.gg.dcloud.ADHandler.AnonymousClass1 */

            @Override // io.dcloud.sdk.poly.base.utils.PrivacyManager.a
            public String getAndroidId() {
                return TelephonyUtil.getAId(context);
            }

            @Override // io.dcloud.sdk.poly.base.utils.PrivacyManager.a
            public String[] getImeis() {
                return TelephonyUtil.getMultiIMEI(context);
            }

            @Override // io.dcloud.sdk.poly.base.utils.PrivacyManager.a
            public String getImsi() {
                return TelephonyUtil.getIMSI(context);
            }

            @Override // io.dcloud.sdk.poly.base.utils.PrivacyManager.a
            public boolean isAllowPrivacy() {
                return !AppRuntime.hasPrivacyForNotShown(context);
            }
        });
        d dVar = (d) a.d().a();
        handler = dVar;
        HashMap<String, Object> b = dVar.b(context);
        b.put(CreateShortResultReceiver.KEY_VERSIONNAME, get(context, CreateShortResultReceiver.KEY_VERSIONNAME));
        b.put("name", get(context, "name"));
        b.put("psas", psas(context));
        b.put("ps", Integer.valueOf(BaseInfo.existsStreamEnv() ? 1 : 0));
        b.put("psd", Integer.valueOf(BaseInfo.ISDEBUG ? 1 : 0));
        Boolean SplashAdIsEnable = SplashAdIsEnable(context);
        Boolean defAdConfig = defAdConfig(context);
        String str3 = "1";
        b.put("pap", SplashAdIsEnable.booleanValue() ? str3 : WXInstanceApm.VALUE_ERROR_CODE_DEFAULT);
        b.put("papi", defAdConfig.booleanValue() ? str3 : WXInstanceApm.VALUE_ERROR_CODE_DEFAULT);
        b.put("psaf", allReady(context) ? WXInstanceApm.VALUE_ERROR_CODE_DEFAULT : str3);
        String str4 = get("cad");
        if (!TextUtils.isEmpty(str4)) {
            b.put("rad", str4);
        }
        String a = SP.getsOrCreateBundle(context, io.dcloud.f.a.b("IlKgfnao")).a(io.dcloud.f.a.b("[xdi{`IlMfijdm"), AbsoluteConst.TRUE);
        if (a != null && a.equalsIgnoreCase(AbsoluteConst.FALSE)) {
            str3 = WXInstanceApm.VALUE_ERROR_CODE_DEFAULT;
        }
        b.put("mpap", str3);
        b.put("lia", AolSplashUtil.getAL(context));
        String jSONObject = new JSONObject(b).toString();
        if (!startsWith) {
            try {
                Class.forName("io.dcloud.common.cs.DA");
                startsWith = true;
            } catch (ClassNotFoundException unused) {
            }
        }
        if (startsWith) {
            try {
                Object invokeMethod = PlatformUtil.invokeMethod("io.dcloud.common.cs.DA", "getInstance", null);
                if (invokeMethod != null && (invokeMethod instanceof DAI)) {
                    if (list != null) {
                        ((DAI) invokeMethod).act(jSONObject, new ADResult(iAolReceiverArr));
                    } else {
                        ((DAI) invokeMethod).ar(jSONObject, new ADResult(iAolReceiverArr));
                    }
                    z2 = true;
                }
            } catch (Exception e) {
                Logger.e("ADHANDLER", e.toString());
            }
        }
        if (!z2) {
            exec5Plus(list, jSONObject, iAolReceiverArr);
        }
    }

    static void pullRad(Context context, Map<String, Object> map, final IAolReceiver... iAolReceiverArr) {
        if (TextUtils.isEmpty(BaseInfo.sDefaultBootApp)) {
            BaseInfo.parseControl();
        }
        HashMap hashMap = new HashMap();
        hashMap.put(ContextChain.TAG_PRODUCT, "a");
        hashMap.put(CreateShortResultReceiver.KEY_VERSIONNAME, get(CreateShortResultReceiver.KEY_VERSIONNAME));
        hashMap.put("appid", BaseInfo.sDefaultBootApp);
        String str = "1.9.9.81993";
        if (PdrUtil.isEmpty(str)) {
            str = "";
        }
        hashMap.put("vb", str);
        hashMap.put("imei", TelephonyUtil.getIMEI(context, true, true));
        if (map != null && map.containsKey("rad") && !PdrUtil.isEmpty(map.get("rad"))) {
            hashMap.put("pn", context.getPackageName());
            hashMap.put("mc", mc(context));
            hashMap.put("paid", get(context, "adid"));
            hashMap.put("psdk", 0);
            hashMap.putAll(map);
            String str2 = null;
            try {
                str2 = URLEncoder.encode(Base64.encodeToString(AESUtil.encrypt(io.dcloud.f.a.c(), io.dcloud.f.a.b(), ZipUtils.zipString(new JSONObject(hashMap).toString())), 2), "utf-8");
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            final String str3 = "edata=" + str2;
            final boolean z = !hasOtherAd();
            addThreadTask(new ThreadTask() {
                /* class io.dcloud.feature.gg.dcloud.ADHandler.AnonymousClass5 */

                @Override // io.dcloud.feature.gg.dcloud.ADHandler.ThreadTask
                public void execute() {
                    ArrayList arrayList = new ArrayList();
                    if (PdrUtil.checkIntl()) {
                        arrayList.add(new HostPicker.Host("YHx8eHsyJydvazkmbGtkZ31sJmFnJ2tnZGRta3wneGR9e2l4eCdraWw=", HostPicker.Host.PriorityEnum.FIRST));
                    } else if (TextUtils.isEmpty(io.dcloud.h.c.c.b.d.b.b()) || "CN".equalsIgnoreCase(io.dcloud.h.c.c.b.d.b.b())) {
                        arrayList.add(new HostPicker.Host("YHx8eHsyJydrOSZsa2RnfWwmZm18JmtmJ2tnZGRta3wneGR9e2l4eCdraWw=", HostPicker.Host.PriorityEnum.FIRST));
                    } else {
                        arrayList.add(new HostPicker.Host("YHx8eHsyJydvazkmbGtkZ31sJmZtfCZrZidrZ2RkbWt8J3hkfXtpeHgna2ls", HostPicker.Host.PriorityEnum.FIRST));
                    }
                    ADHandler.pull(arrayList, "CAD", str3, z, iAolReceiverArr);
                }
            });
        }
    }

    public static void setSplashAd(Context context, boolean z, IAolReceiver... iAolReceiverArr) {
        String str;
        HashMap hashMap = new HashMap();
        hashMap.put(ContextChain.TAG_PRODUCT, "a");
        hashMap.put(CreateShortResultReceiver.KEY_VERSIONNAME, get(context, CreateShortResultReceiver.KEY_VERSIONNAME));
        hashMap.put("appid", BaseInfo.sDefaultBootApp);
        hashMap.put("name", get(context, "name"));
        try {
            hashMap.put("pname", context.getApplicationInfo().loadLabel(context.getPackageManager()));
        } catch (Exception unused) {
        }
        hashMap.put("pn", context.getPackageName());
        try {
            str = context.getPackageManager().getPackageInfo(context.getPackageName(), 1).versionName;
        } catch (Exception e) {
            e.printStackTrace();
            str = null;
        }
        hashMap.put("pv", str);
        hashMap.put(WXConfig.os, Integer.valueOf(Build.VERSION.SDK_INT));
        String str2 = "1.9.9.81993";
        if (PdrUtil.isEmpty(str2)) {
            str2 = "";
        }
        hashMap.put("vb", str2);
        hashMap.put("mc", mc(context));
        hashMap.put("psdk", 0);
        hashMap.put("mpap", z ? "1" : WXInstanceApm.VALUE_ERROR_CODE_DEFAULT);
        hashMap.put("smpap", "1");
        exec5Plus(null, new JSONObject(hashMap).toString(), iAolReceiverArr);
    }

    private static void sortDesc(File[] fileArr) {
        if (fileArr != null) {
            for (int i = 0; i < fileArr.length - 1; i++) {
                int i2 = 0;
                while (i2 < (fileArr.length - 1) - i) {
                    int i3 = i2 + 1;
                    if (Long.parseLong(fileArr[i2].getName()) < Long.parseLong(fileArr[i3].getName())) {
                        File file = fileArr[i2];
                        fileArr[i2] = fileArr[i3];
                        fileArr[i3] = file;
                    }
                    i2 = i3;
                }
            }
        }
    }

    static void view(final Context context, final AdData adData, final String str) {
        final String optString = adData.data().optString("tid");
        ThreadPool.self().addThreadTask(new Runnable() {
            /* class io.dcloud.feature.gg.dcloud.ADHandler.AnonymousClass7 */

            public void run() {
                int i = AdData.this.isEShow() ? 45 : 40;
                JSONObject full = AdData.this.full();
                TestUtil.PointTime.commitTid(context, AdData.this.mOriginalAppid, optString, str, i, AolSplashUtil.getSplashAdpId("_adpid_", "UNIAD_SPLASH_ADPID"), false, (full == null || !full.has("ua")) ? "" : full.optString("ua"));
            }
        });
        if ("wanka".equals(adData.mProvider)) {
            ADHandler_wanka.view_wanka(context, adData, str);
        } else if ("youdao".equals(adData.mProvider)) {
            ADHandler_youdao.view_youdao(context, adData, str);
        } else if ("common".equals(adData.mProvider)) {
            Aolhandler_common.handletask_common(context, adData, str, "imptracker");
        }
    }

    static String get(Context context, String str) {
        return SP.getBundleData(context, AdTag, str);
    }

    static AdData getBestAdData(final Context context, String str, final AdData adData) {
        adData.mOriginalAppid = str;
        expiresFileList = new LinkedList<>();
        listExpiresAdData(context, new AdDataWatcher<File>() {
            /* class io.dcloud.feature.gg.dcloud.ADHandler.AnonymousClass11 */

            @Override // io.dcloud.feature.gg.dcloud.ADHandler.AdDataWatcher
            public boolean find() {
                return AdData.this.check();
            }

            public void operate(File file) {
                ADHandler.expiresFileList.add(file);
                ADHandler.fileAdData(context, file, AdData.this);
            }
        });
        if (!adData.check() && expiresFileList.size() != 0) {
            for (int i = 0; i < expiresFileList.size(); i++) {
                new File(expiresFileList.get(i).getAbsolutePath() + "/" + File_S).delete();
                if (i == 0) {
                    fileAdData(context, expiresFileList.get(i), adData);
                }
            }
        }
        return adData;
    }

    public static String get(String str) {
        return SP.getBundleData(AdTag, str);
    }

    public static void pull(Context context, String str) {
        ArrayList arrayList = new ArrayList();
        for (String str2 : b.c.keySet()) {
            HostPicker.Host.PriorityEnum priorityEnum = HostPicker.Host.PriorityEnum.BACKUP;
            int intValue = b.c.get(str2).intValue();
            if (intValue != -1) {
                if (intValue == 0) {
                    priorityEnum = HostPicker.Host.PriorityEnum.NORMAL;
                } else if (intValue == 1) {
                    priorityEnum = HostPicker.Host.PriorityEnum.FIRST;
                }
            }
            arrayList.add(new HostPicker.Host(str2, priorityEnum));
        }
        pull(context, str, false, (List<HostPicker.Host>) arrayList, new ADReceiver(context));
    }

    /* access modifiers changed from: private */
    public static void pull(List<HostPicker.Host> list, final String str, final String str2, final boolean z, final IAolReceiver... iAolReceiverArr) {
        HostPicker.getInstance().pickSuitHost(DCLoudApplicationImpl.self().getContext(), list, str, new HostPicker.HostPickCallback() {
            /* class io.dcloud.feature.gg.dcloud.ADHandler.AnonymousClass4 */
            String[] message = new String[1];

            @Override // io.dcloud.common.util.hostpicker.HostPicker.HostPickCallback
            public boolean doRequest(HostPicker.Host host) {
                byte[] httpPost = NetTool.httpPost(host.getRealHost(), str2, new HashMap(), false, z, this.message);
                if (httpPost == null) {
                    return false;
                }
                try {
                    ADHandler.analysisPullData(httpPost, str, iAolReceiverArr);
                    return true;
                } catch (Exception e) {
                    for (IAolReceiver iAolReceiver : iAolReceiverArr) {
                        iAolReceiver.onError("Exception", e.getMessage());
                    }
                    if (ADHandler.handler == null) {
                        return true;
                    }
                    ADHandler.handler.a(-5007, e.getMessage());
                    return true;
                }
            }

            @Override // io.dcloud.common.util.hostpicker.HostPicker.HostPickCallback
            public void onNoOnePicked() {
                String str;
                IAolReceiver[] iAolReceiverArr = iAolReceiverArr;
                int length = iAolReceiverArr.length;
                int i = 0;
                while (true) {
                    str = "data invalid";
                    if (i >= length) {
                        break;
                    }
                    IAolReceiver iAolReceiver = iAolReceiverArr[i];
                    String[] strArr = this.message;
                    if (strArr[0] != null) {
                        str = strArr[0];
                    }
                    iAolReceiver.onError("NotFountDataError", str);
                    i++;
                }
                if (ADHandler.handler != null) {
                    d dVar = ADHandler.handler;
                    String[] strArr2 = this.message;
                    if (strArr2[0] != null) {
                        str = strArr2[0];
                    }
                    dVar.a(-5007, str);
                }
            }

            @Override // io.dcloud.common.util.hostpicker.HostPicker.HostPickCallback
            public void onOneSelected(HostPicker.Host host) {
            }
        });
    }
}
