package io.dcloud.feature.device;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.media.AudioManager;
import android.media.ToneGenerator;
import android.net.Uri;
import android.os.PowerManager;
import android.os.Vibrator;
import android.provider.Settings;
import android.text.TextUtils;
import android.view.Window;
import android.view.WindowManager;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.el.parse.Operators;
import io.dcloud.common.DHInterface.AbsMgr;
import io.dcloud.common.DHInterface.IApp;
import io.dcloud.common.DHInterface.IFeature;
import io.dcloud.common.DHInterface.ISysEventListener;
import io.dcloud.common.DHInterface.IWebview;
import io.dcloud.common.adapter.util.DeviceInfo;
import io.dcloud.common.adapter.util.PermissionUtil;
import io.dcloud.common.constant.DOMException;
import io.dcloud.common.util.AppRuntime;
import io.dcloud.common.util.Deprecated_JSUtil;
import io.dcloud.common.util.JSUtil;
import io.dcloud.common.util.NetworkTypeUtil;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.common.util.StringUtil;
import io.dcloud.common.util.TelephonyUtil;
import io.dcloud.e.d.a;
import io.dcloud.feature.internal.sdk.SDK;
import java.lang.reflect.Method;
import org.json.JSONException;
import org.json.JSONObject;

public class DeviceFeatureImpl implements IFeature, ISysEventListener {
    static int a = 255;
    private PowerManager.WakeLock b = null;
    private boolean c = false;
    private Context d;
    int e = -1;

    class a extends PermissionUtil.StreamPermissionRequest {
        final /* synthetic */ IWebview a;
        final /* synthetic */ String[] b;
        final /* synthetic */ boolean c;

        /* JADX INFO: super call moved to the top of the method (can break code semantics) */
        a(IApp iApp, IWebview iWebview, String[] strArr, boolean z) {
            super(iApp);
            this.a = iWebview;
            this.b = strArr;
            this.c = z;
        }

        @Override // io.dcloud.common.adapter.util.PermissionUtil.Request
        public void onDenied(String str) {
        }

        @Override // io.dcloud.common.adapter.util.PermissionUtil.Request
        public void onGranted(String str) {
            DeviceFeatureImpl.this.a(this.a, this.b[0], this.c);
        }
    }

    class b extends PermissionUtil.Request {
        final /* synthetic */ IWebview a;
        final /* synthetic */ String b;

        b(IWebview iWebview, String str) {
            this.a = iWebview;
            this.b = str;
        }

        @Override // io.dcloud.common.adapter.util.PermissionUtil.Request
        public void onDenied(String str) {
            Deprecated_JSUtil.execCallback(this.a, this.b, "{'imei':'','imsi':[],'uuid':'" + TelephonyUtil.getIMEI(this.a.getContext(), false) + "'}", JSUtil.ERROR, true, false);
        }

        @Override // io.dcloud.common.adapter.util.PermissionUtil.Request
        public void onGranted(String str) {
            DeviceInfo.updateIMEI();
            DeviceInfo.getUpdateIMSI();
            Deprecated_JSUtil.execCallback(this.a, this.b, StringUtil.format("{'imei':'%s','imsi':['%s'],'uuid':'%s'}", DeviceInfo.sIMEI, DeviceInfo.sIMSI, TelephonyUtil.getIMEI(this.a.getContext(), false)), JSUtil.OK, true, false);
        }
    }

    class c implements a.b {
        final /* synthetic */ IWebview a;
        final /* synthetic */ String b;
        final /* synthetic */ String c;

        c(IWebview iWebview, String str, String str2) {
            this.a = iWebview;
            this.b = str;
            this.c = str2;
        }

        @Override // io.dcloud.e.d.a.b
        public void a(String str, boolean z) {
            if (z) {
                DeviceFeatureImpl.this.a(this.a, this.b, this.c, str);
            } else {
                Deprecated_JSUtil.execCallback(this.a, this.c, DOMException.toJSON(401, "not support"), JSUtil.ERROR, true, false);
            }
        }
    }

    /* access modifiers changed from: package-private */
    public class d implements Runnable {
        final /* synthetic */ IWebview a;
        final /* synthetic */ float b;

        d(IWebview iWebview, float f) {
            this.a = iWebview;
            this.b = f;
        }

        public void run() {
            DeviceFeatureImpl.this.a((DeviceFeatureImpl) this.a, (IWebview) this.b);
        }
    }

    static {
        try {
            Resources system = Resources.getSystem();
            int identifier = system.getIdentifier("config_screenBrightnessSettingMaximum", "integer", WXEnvironment.OS);
            if (identifier != 0) {
                a = system.getInteger(identifier);
            }
        } catch (Exception unused) {
            a = 255;
        }
    }

    private void b(IWebview iWebview, float f) {
        iWebview.obtainWindowView().post(new d(iWebview, f));
    }

    @Override // io.dcloud.common.DHInterface.IFeature
    public void dispose(String str) {
    }

    /* JADX INFO: Can't fix incorrect switch cases order, some code will duplicate */
    /* JADX WARNING: Code restructure failed: missing block: B:98:0x0226, code lost:
        if (r0 <= 0) goto L_0x022d;
     */
    @Override // io.dcloud.common.DHInterface.IFeature
    public String execute(IWebview iWebview, String str, String[] strArr) {
        char c2;
        long j;
        str.hashCode();
        int i = 1;
        switch (str.hashCode()) {
            case -2016181423:
                if (str.equals("setWakelock")) {
                    c2 = 0;
                    break;
                }
                c2 = 65535;
                break;
            case -1768495376:
                if (str.equals("d.resolutionWidth")) {
                    c2 = 1;
                    break;
                }
                c2 = 65535;
                break;
            case -1498445182:
                if (str.equals("getDCloudID")) {
                    c2 = 2;
                    break;
                }
                c2 = 65535;
                break;
            case -1492959986:
                if (str.equals("s.resolutionHeight")) {
                    c2 = 3;
                    break;
                }
                c2 = 65535;
                break;
            case -1386751524:
                if (str.equals("getCurrentAPN")) {
                    c2 = 4;
                    break;
                }
                c2 = 65535;
                break;
            case -1107875961:
                if (str.equals("getDeviceId")) {
                    c2 = 5;
                    break;
                }
                c2 = 65535;
                break;
            case -503804903:
                if (str.equals("isWakelock")) {
                    c2 = 6;
                    break;
                }
                c2 = 65535;
                break;
            case -75727471:
                if (str.equals("getAAID")) {
                    c2 = 7;
                    break;
                }
                c2 = 65535;
                break;
            case -75444956:
                if (str.equals("getInfo")) {
                    c2 = '\b';
                    break;
                }
                c2 = 65535;
                break;
            case -75310397:
                if (str.equals("getOAID")) {
                    c2 = '\t';
                    break;
                }
                c2 = 65535;
                break;
            case -75101860:
                if (str.equals("getVAID")) {
                    c2 = '\n';
                    break;
                }
                c2 = 65535;
                break;
            case -39062556:
                if (str.equals("getCurrentSize")) {
                    c2 = 11;
                    break;
                }
                c2 = 65535;
                break;
            case -39017699:
                if (str.equals("getCurrentType")) {
                    c2 = '\f';
                    break;
                }
                c2 = 65535;
                break;
            case 3019822:
                if (str.equals("beep")) {
                    c2 = '\r';
                    break;
                }
                c2 = 65535;
                break;
            case 3083120:
                if (str.equals("dial")) {
                    c2 = 14;
                    break;
                }
                c2 = 65535;
                break;
            case 350413895:
                if (str.equals("getBrightness")) {
                    c2 = 15;
                    break;
                }
                c2 = 65535;
                break;
            case 376261968:
                if (str.equals("__isWakelockNative__")) {
                    c2 = 16;
                    break;
                }
                c2 = 65535;
                break;
            case 451310959:
                if (str.equals("vibrate")) {
                    c2 = 17;
                    break;
                }
                c2 = 65535;
                break;
            case 578223421:
                if (str.equals("d.resolutionHeight")) {
                    c2 = 18;
                    break;
                }
                c2 = 65535;
                break;
            case 596855788:
                if (str.equals("unlockOrientation")) {
                    c2 = 19;
                    break;
                }
                c2 = 65535;
                break;
            case 608383606:
                if (str.equals("isSetProxy")) {
                    c2 = 20;
                    break;
                }
                c2 = 65535;
                break;
            case 670514716:
                if (str.equals("setVolume")) {
                    c2 = 21;
                    break;
                }
                c2 = 65535;
                break;
            case 885131792:
                if (str.equals("getVolume")) {
                    c2 = 22;
                    break;
                }
                c2 = 65535;
                break;
            case 1124545107:
                if (str.equals("setBrightness")) {
                    c2 = 23;
                    break;
                }
                c2 = 65535;
                break;
            case 1351280895:
                if (str.equals("s.resolutionWidth")) {
                    c2 = 24;
                    break;
                }
                c2 = 65535;
                break;
            case 1497595813:
                if (str.equals("lockOrientation")) {
                    c2 = 25;
                    break;
                }
                c2 = 65535;
                break;
            default:
                c2 = 65535;
                break;
        }
        switch (c2) {
            case 0:
                if (PdrUtil.parseBoolean(strArr[0], false, false)) {
                    this.b.acquire();
                    break;
                } else {
                    this.b.release();
                    break;
                }
            case 1:
                IApp obtainApp = iWebview.obtainApp();
                return Deprecated_JSUtil.wrapJsVar(String.valueOf(((float) obtainApp.getInt(0)) / iWebview.getScale()), false);
            case 2:
            case 5:
                Context context = iWebview.getContext();
                AppRuntime.checkPrivacyComplianceAndPrompt(context, "Device-" + str);
                return JSUtil.wrapJsVar(AppRuntime.getDCloudDeviceID(iWebview.getContext()));
            case 3:
                IApp obtainApp2 = iWebview.obtainApp();
                return Deprecated_JSUtil.wrapJsVar(String.valueOf(((float) obtainApp2.getInt(2)) / iWebview.getScale()), false);
            case 4:
                String currentAPN = DeviceInfo.getCurrentAPN();
                if (TextUtils.isEmpty(currentAPN)) {
                    return null;
                }
                try {
                    return JSUtil.wrapJsVar(new JSONObject("{name:" + currentAPN + Operators.BLOCK_END_STR));
                } catch (JSONException e2) {
                    e2.printStackTrace();
                    return null;
                }
            case 6:
                return Deprecated_JSUtil.wrapJsVar(String.valueOf(this.b.isHeld()), false);
            case 7:
            case '\t':
            case '\n':
                Context context2 = iWebview.getContext();
                AppRuntime.checkPrivacyComplianceAndPrompt(context2, "Device-" + str);
                String str2 = strArr[0];
                if (!SDK.isUniMPSDK() || TextUtils.isEmpty(SDK.customOAID)) {
                    String str3 = DeviceInfo.oaids;
                    if (str3 != null && !str3.equalsIgnoreCase(Operators.OR)) {
                        a(iWebview, str, str2, DeviceInfo.oaids);
                        break;
                    } else {
                        try {
                            Method declaredMethod = Class.forName("com.bun.miitmdid.core.JLibrary").getDeclaredMethod("InitEntry", Context.class);
                            if (declaredMethod != null) {
                                declaredMethod.setAccessible(true);
                                declaredMethod.invoke(null, iWebview.getContext());
                            }
                        } catch (Exception unused) {
                        }
                        if (!new io.dcloud.e.d.a(new c(iWebview, str, str2)).b(iWebview.getActivity())) {
                            Deprecated_JSUtil.execCallback(iWebview, str2, DOMException.toJSON(401, "not support"), JSUtil.ERROR, true, false);
                            break;
                        }
                    }
                } else {
                    Deprecated_JSUtil.execCallback(iWebview, str2, DOMException.toJSON(401, "not support"), JSUtil.ERROR, true, false);
                    break;
                }
                break;
            case '\b':
                String str4 = strArr[0];
                Context context3 = iWebview.getContext();
                AppRuntime.checkPrivacyComplianceAndPrompt(context3, "Device-" + str);
                PermissionUtil.usePermission(iWebview.getActivity(), IFeature.F_DEVICE, "android.permission.READ_PHONE_STATE", 2, new b(iWebview, str4));
                break;
            case 11:
                return Deprecated_JSUtil.wrapJsVar(a(iWebview.obtainApp(), iWebview.getScale()), false);
            case '\f':
                return DeviceInfo.getNetWorkType(iWebview.getContext());
            case '\r':
                ToneGenerator toneGenerator = new ToneGenerator(5, 100);
                try {
                    int parseInt = Integer.parseInt(strArr[0]);
                    if (parseInt > 0) {
                        i = parseInt;
                    }
                } catch (NumberFormatException e3) {
                    e3.printStackTrace();
                }
                for (int i2 = 0; i2 < i; i2++) {
                    toneGenerator.startTone(88);
                    try {
                        Thread.sleep(500);
                    } catch (InterruptedException e4) {
                        e4.printStackTrace();
                    }
                }
                break;
            case 14:
                Context context4 = iWebview.getContext();
                AppRuntime.checkPrivacyComplianceAndPrompt(context4, "Device-" + str);
                PermissionUtil.usePermission(iWebview.getActivity(), IFeature.F_DEVICE, PermissionUtil.PMS_PHONE, 2, new a(iWebview.obtainApp(), iWebview, strArr, PdrUtil.parseBoolean(strArr[1], true, false)));
                break;
            case 15:
                return Deprecated_JSUtil.wrapJsVar(String.valueOf(((float) a(iWebview.getActivity())) / ((float) a)), false);
            case 16:
                return this.b.isHeld() + "";
            case 17:
                try {
                    j = Long.parseLong(strArr[0]);
                    break;
                } catch (NumberFormatException e5) {
                    e5.printStackTrace();
                    break;
                }
            case 18:
                IApp obtainApp3 = iWebview.obtainApp();
                return Deprecated_JSUtil.wrapJsVar(String.valueOf(((float) obtainApp3.getInt(1)) / iWebview.getScale()), false);
            case 19:
                iWebview.obtainApp().setRequestedOrientation((String) null);
                break;
            case 20:
                return JSUtil.wrapJsVar(NetworkTypeUtil.isWifiProxy(iWebview.getContext()));
            case 21:
                float parseFloat = Float.parseFloat(strArr[0]);
                AudioManager audioManager = (AudioManager) iWebview.getContext().getSystemService("audio");
                int a2 = a(parseFloat);
                audioManager.setStreamVolume(4, a2, 8);
                audioManager.setStreamVolume(8, a2, 8);
                audioManager.setStreamVolume(3, a2, 8);
                audioManager.setStreamVolume(5, a2, 8);
                audioManager.setStreamVolume(2, a2, 8);
                audioManager.setStreamVolume(1, a2, 8);
                audioManager.setStreamVolume(0, a2, 8);
                break;
            case 22:
                return Deprecated_JSUtil.wrapJsVar(String.valueOf(((float) ((AudioManager) iWebview.getContext().getSystemService("audio")).getStreamVolume(3)) / ((float) this.e)), false);
            case 23:
                b(iWebview, Float.parseFloat(strArr[0]));
                break;
            case 24:
                IApp obtainApp4 = iWebview.obtainApp();
                return Deprecated_JSUtil.wrapJsVar(String.valueOf(((float) obtainApp4.getInt(0)) / iWebview.getScale()), false);
            case 25:
                iWebview.obtainApp().setRequestedOrientation(strArr[0]);
                break;
        }
        return null;
        j = 500;
        ((Vibrator) this.d.getSystemService("vibrator")).vibrate(j);
        return null;
    }

    @Override // io.dcloud.common.DHInterface.IFeature
    public void init(AbsMgr absMgr, String str) {
        Context context = absMgr.getContext();
        this.d = context;
        PowerManager.WakeLock newWakeLock = ((PowerManager) context.getSystemService("power")).newWakeLock(10, "My Lock");
        this.b = newWakeLock;
        newWakeLock.setReferenceCounted(false);
        this.e = ((AudioManager) absMgr.getContext().getSystemService("audio")).getStreamMaxVolume(3);
    }

    @Override // io.dcloud.common.DHInterface.ISysEventListener
    public boolean onExecute(ISysEventListener.SysEventType sysEventType, Object obj) {
        return false;
    }

    private String a(IApp iApp, float f) {
        int i = iApp.getInt(0);
        int i2 = iApp.getInt(2);
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("width", i);
            jSONObject.put("height", i2);
            jSONObject.put("resolutionWidth", (double) (((float) i) / f));
            jSONObject.put("resolutionHeight", (double) (((float) i2) / f));
        } catch (JSONException e2) {
            e2.printStackTrace();
        }
        return jSONObject.toString();
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    /* JADX WARNING: Removed duplicated region for block: B:21:0x0042  */
    /* JADX WARNING: Removed duplicated region for block: B:31:0x0092  */
    private void a(IWebview iWebview, String str, String str2, String str3) {
        char c2;
        String[] split = str3.split("\\|");
        try {
            int hashCode = str.hashCode();
            if (hashCode != -75727471) {
                if (hashCode != -75310397) {
                    if (hashCode == -75101860) {
                        if (str.equals("getVAID")) {
                            c2 = 1;
                            String str4 = "";
                            if (c2 != 0) {
                                if (split.length > 0) {
                                    str4 = split[0];
                                }
                                JSUtil.execCallback(iWebview, str2, new JSONObject("{'oaid':'" + str4 + "'}"), JSUtil.OK, false);
                                return;
                            } else if (c2 == 1) {
                                if (split.length > 1) {
                                    str4 = split[1];
                                }
                                JSUtil.execCallback(iWebview, str2, new JSONObject("{'vaid':'" + str4 + "'}"), JSUtil.OK, false);
                                return;
                            } else if (c2 == 2) {
                                if (split.length > 2) {
                                    str4 = split[2];
                                }
                                JSUtil.execCallback(iWebview, str2, new JSONObject("{'aaid':'" + str4 + "'}"), JSUtil.OK, false);
                                return;
                            } else {
                                return;
                            }
                        }
                    }
                } else if (str.equals("getOAID")) {
                    c2 = 0;
                    String str42 = "";
                    if (c2 != 0) {
                    }
                }
            } else if (str.equals("getAAID")) {
                c2 = 2;
                String str422 = "";
                if (c2 != 0) {
                }
            }
            c2 = 65535;
            String str4222 = "";
            if (c2 != 0) {
            }
        } catch (Exception e2) {
            Deprecated_JSUtil.execCallback(iWebview, str2, DOMException.toJSON(401, e2.getMessage()), JSUtil.ERROR, true, false);
        }
    }

    private int a(Activity activity) {
        int i;
        float f = activity.getWindow().getAttributes().screenBrightness;
        if (f < 0.0f) {
            ContentResolver contentResolver = activity.getContentResolver();
            try {
                int integer = activity.getResources().getInteger(activity.getResources().getIdentifier("config_screenBrightnessSettingMaximum", "integer", WXEnvironment.OS));
                int i2 = Settings.System.getInt(contentResolver, "screen_brightness", 125);
                if (integer > 255) {
                    f = ((float) i2) / ((float) integer);
                    if (f <= 0.0f) {
                        return 125;
                    }
                    i = a;
                } else if (i2 >= 0) {
                    return i2;
                } else {
                    return 125;
                }
            } catch (Exception e2) {
                e2.printStackTrace();
                return 125;
            }
        } else {
            i = a;
        }
        return (int) (f * ((float) i));
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void a(IWebview iWebview, float f) {
        Window window = iWebview.getActivity().getWindow();
        WindowManager.LayoutParams attributes = window.getAttributes();
        int i = (f > 1.0f ? 1 : (f == 1.0f ? 0 : -1));
        if (i > 0 || f <= 0.0f) {
            attributes.screenBrightness = -1.0f;
        } else {
            attributes.screenBrightness = f;
        }
        if (f == -1.0f) {
            attributes.screenBrightness = -1.0f;
            window.setAttributes(attributes);
        } else if (i <= 0 && f > 0.0f) {
            attributes.screenBrightness = f;
            window.setAttributes(attributes);
        }
    }

    private int a(float f) {
        if (f > 1.0f || f < 0.0f) {
            return 0;
        }
        return (int) (f * ((float) this.e));
    }

    /* access modifiers changed from: protected */
    public void a(IWebview iWebview, String str, boolean z) {
        iWebview.getActivity().startActivity(new Intent(!z ? "android.intent.action.CALL" : "android.intent.action.DIAL", Uri.parse("tel:" + str)));
    }
}
