package io.dcloud.feature.barcode2.camera;

import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.os.Build;
import android.os.Handler;
import io.dcloud.feature.barcode2.decoding.IBarHandler;
import io.dcloud.feature.barcode2.view.DetectorViewConfig;
import io.dcloud.feature.gg.dcloud.ADSim;
import java.io.IOException;

public final class CameraManager {
    private static final int MAX_FRAME_HEIGHT = 640;
    private static final int MAX_FRAME_WIDTH = 640;
    private static final int MIN_FRAME_HEIGHT = 240;
    private static final int MIN_FRAME_WIDTH = 240;
    static final int SDK_INT;
    private static final String TAG = "CameraManager";
    private static CameraManager cameraManager;
    private static boolean mIsVerticalScreen = true;
    private static Camera.Parameters parameters = null;
    public static int sScreenAllHeight;
    public static int sScreenWidth;
    private final AutoFocusCallback autoFocusCallback;
    private Camera camera;
    private final CameraConfigurationManager configManager;
    private final Context context;
    private Rect framingRect;
    private boolean horizontalOrientation = false;
    private boolean initialized;
    private final PreviewCallback previewCallback;
    private boolean previewing;
    private boolean useOneShotPreviewCallback;

    static {
        int i;
        try {
            i = Integer.parseInt(Build.VERSION.SDK);
        } catch (NumberFormatException unused) {
            i = ADSim.INTISPLSH;
        }
        SDK_INT = i;
    }

    private CameraManager(Context context2) {
        this.context = context2;
        CameraConfigurationManager cameraConfigurationManager = new CameraConfigurationManager(context2);
        this.configManager = cameraConfigurationManager;
        this.useOneShotPreviewCallback = Integer.parseInt(Build.VERSION.SDK) > 3;
        this.previewCallback = new PreviewCallback(cameraConfigurationManager, this.useOneShotPreviewCallback);
        this.useOneShotPreviewCallback = false;
        this.autoFocusCallback = new AutoFocusCallback();
    }

    public static CameraManager get() {
        return cameraManager;
    }

    /* JADX WARNING: Removed duplicated region for block: B:18:0x0032  */
    /* JADX WARNING: Removed duplicated region for block: B:19:0x0038  */
    /* JADX WARNING: Removed duplicated region for block: B:25:0x004b  */
    public static Point getCR(int i, int i2) {
        Point point;
        Exception e;
        Camera camera2;
        Camera.Parameters parameters2;
        Camera camera3 = null;
        try {
            camera2 = Camera.open();
            try {
                if (parameters == null) {
                    parameters = camera2.getParameters();
                }
                Point cameraResolution = CameraConfigurationManager.getCameraResolution(parameters, new Point(i, i2));
                try {
                    camera2.release();
                    return cameraResolution;
                } catch (Exception e2) {
                    point = cameraResolution;
                    e = e2;
                }
            } catch (Exception e3) {
                e = e3;
                point = null;
                Point point2 = new Point(i, i2);
                parameters2 = parameters;
                if (parameters2 == null) {
                }
                camera3 = camera2;
                if (camera3 != null) {
                }
                e.printStackTrace();
                return point;
            }
        } catch (Exception e4) {
            e = e4;
            camera2 = null;
            point = null;
            Point point22 = new Point(i, i2);
            parameters2 = parameters;
            if (parameters2 == null) {
                point = CameraConfigurationManager.getCameraResolution(parameters2, point22);
            } else if (camera2 != null) {
                try {
                    Camera.Parameters parameters3 = camera2.getParameters();
                    parameters = parameters3;
                    point = CameraConfigurationManager.getCameraResolution(parameters3, point22);
                    camera2.release();
                } catch (Exception unused) {
                }
                if (camera3 != null) {
                    camera3.release();
                }
                e.printStackTrace();
                return point;
            }
            camera3 = camera2;
            if (camera3 != null) {
            }
            e.printStackTrace();
            return point;
        }
    }

    public static void init(Context context2) {
        if (cameraManager == null) {
            cameraManager = new CameraManager(context2);
        }
    }

    public PlanarYUVLuminanceSource buildLuminanceSource(byte[] bArr, int i, int i2) {
        Rect framingRectInPreview = getFramingRectInPreview();
        int previewFormat = this.configManager.getPreviewFormat();
        String previewFormatString = this.configManager.getPreviewFormatString();
        if (previewFormat == 16 || previewFormat == 17) {
            return new PlanarYUVLuminanceSource(bArr, i, i2, framingRectInPreview.left, framingRectInPreview.top, framingRectInPreview.width(), framingRectInPreview.height());
        }
        if ("yuv420p".equals(previewFormatString)) {
            return new PlanarYUVLuminanceSource(bArr, i, i2, framingRectInPreview.left, framingRectInPreview.top, framingRectInPreview.width(), framingRectInPreview.height());
        }
        throw new IllegalArgumentException("Unsupported picture format: " + previewFormat + '/' + previewFormatString);
    }

    public void clearLastBitmapData() {
        PreviewCallback previewCallback2 = this.previewCallback;
        if (previewCallback2 != null) {
            previewCallback2.setLastBitmapData(null);
        }
    }

    public void closeDriver() {
        if (this.camera != null) {
            FlashlightManager.disableFlashlight();
            this.camera.setPreviewCallback(null);
            this.camera.release();
            this.camera = null;
        }
    }

    public AutoFocusCallback getAutoFocusCallback() {
        return this.autoFocusCallback;
    }

    public Camera getCameraHandler() {
        return this.camera;
    }

    public Rect getFramingRectInPreview() {
        if (mIsVerticalScreen) {
            return getPortraitFramingRectInPreview();
        }
        return getLandscapeFramingRectInPreview();
    }

    public Rect getLandscapeFramingRectInPreview() {
        Point cameraResolution = this.configManager.getCameraResolution();
        Rect detectorRect = DetectorViewConfig.getInstance().getDetectorRect();
        Rect rect = DetectorViewConfig.getInstance().surfaceViewRect;
        int width = rect.width() / cameraResolution.y;
        int width2 = ((detectorRect.left - DetectorViewConfig.detectorRectOffestLeft) * cameraResolution.x) / rect.width();
        int height = ((rect.bottom - detectorRect.bottom) * cameraResolution.y) / rect.height();
        return new Rect(width2, height, ((detectorRect.height() * cameraResolution.y) / rect.height()) + width2, ((detectorRect.width() * cameraResolution.y) / rect.height()) + height);
    }

    public byte[] getLastBitmapData() {
        PreviewCallback previewCallback2 = this.previewCallback;
        if (previewCallback2 == null) {
            return null;
        }
        return previewCallback2.getLastBitmapData();
    }

    public Rect getPortraitFramingRectInPreview() {
        Point cameraResolution = this.configManager.getCameraResolution();
        Rect detectorRect = DetectorViewConfig.getInstance().getDetectorRect();
        Rect rect = DetectorViewConfig.getInstance().surfaceViewRect;
        int width = rect.width() / cameraResolution.y;
        int height = ((detectorRect.top - DetectorViewConfig.detectorRectOffestTop) * cameraResolution.x) / rect.height();
        int width2 = ((rect.right - detectorRect.right) * cameraResolution.y) / rect.width();
        return new Rect(height, width2, ((detectorRect.height() * cameraResolution.x) / rect.height()) + height, ((detectorRect.width() * cameraResolution.x) / rect.height()) + width2);
    }

    public void openDriver(SurfaceTexture surfaceTexture) throws IOException, RuntimeException {
        if (this.camera == null) {
            try {
                Camera open = Camera.open();
                this.camera = open;
                if (open != null) {
                    open.setPreviewTexture(surfaceTexture);
                    if (mIsVerticalScreen) {
                        this.camera.setDisplayOrientation(90);
                    } else {
                        this.camera.setDisplayOrientation(this.horizontalOrientation ? 180 : 0);
                    }
                    this.configManager.initFromCameraParameters(this.camera);
                    this.configManager.setDesiredCameraParameters(this.camera);
                    return;
                }
                throw new IOException();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void removeAutoFocus() {
        Camera camera2 = this.camera;
        if (camera2 != null) {
            camera2.cancelAutoFocus();
        }
    }

    public void requestAutoFocus(Handler handler, int i) {
        if (this.camera != null && this.previewing) {
            this.autoFocusCallback.setHandler(handler, i);
            try {
                this.camera.autoFocus(this.autoFocusCallback);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void requestPreviewFrame(IBarHandler iBarHandler, Handler handler, int i) {
        if (this.camera != null && this.previewing) {
            this.previewCallback.setHandler(iBarHandler, handler, i, mIsVerticalScreen);
            if (this.useOneShotPreviewCallback) {
                this.camera.setOneShotPreviewCallback(this.previewCallback);
            } else {
                this.camera.setPreviewCallback(this.previewCallback);
            }
        }
    }

    public void setFlashlight(boolean z) {
        if (z) {
            FlashlightManager.enableFlashlight();
        } else {
            FlashlightManager.disableFlashlight();
        }
    }

    public void setHorizontalOrientation(boolean z) {
        this.horizontalOrientation = z;
    }

    public void startPreview() {
        try {
            Camera camera2 = this.camera;
            if (camera2 != null && !this.previewing) {
                camera2.startPreview();
                this.previewing = true;
            }
        } catch (Exception unused) {
        }
    }

    public void stopPreview() {
        try {
            Camera camera2 = this.camera;
            if (camera2 != null && this.previewing) {
                if (!this.useOneShotPreviewCallback) {
                    camera2.setPreviewCallback(null);
                }
                this.camera.stopPreview();
                this.previewCallback.setHandler(null, null, 0, mIsVerticalScreen);
                this.autoFocusCallback.setHandler(null, 0);
                this.previewing = false;
            }
        } catch (Exception unused) {
        }
    }

    public static void init(Context context2, boolean z) {
        mIsVerticalScreen = z;
        init(context2);
    }
}
