package io.dcloud.feature.barcode2;

import android.content.Context;
import android.text.TextUtils;
import io.dcloud.common.DHInterface.AbsMgr;
import io.dcloud.common.DHInterface.IMgr;
import io.dcloud.common.DHInterface.IWebview;
import io.dcloud.common.adapter.ui.AdaFrameView;
import io.dcloud.common.constant.AbsoluteConst;
import io.dcloud.common.util.AppRuntime;
import io.dcloud.common.util.JSUtil;
import java.util.LinkedHashMap;

public class BarcodeProxyMgr {
    private static BarcodeProxyMgr mInstance;
    private LinkedHashMap<String, BarcodeProxy> mBProxyCaches = new LinkedHashMap<>();
    private AbsMgr mFeatureMgr;

    public static BarcodeProxyMgr getBarcodeProxyMgr() {
        if (mInstance == null) {
            mInstance = new BarcodeProxyMgr();
        }
        return mInstance;
    }

    public Object doForFeature(String str, Object obj) {
        if (!str.equals("appendToFrameView")) {
            return null;
        }
        Object[] objArr = (Object[]) obj;
        AdaFrameView adaFrameView = (AdaFrameView) objArr[0];
        adaFrameView.obtainApp().obtainAppId();
        BarcodeProxy barcodeProxyByUuid = getBarcodeProxyByUuid((String) objArr[1]);
        if (barcodeProxyByUuid == null) {
            return null;
        }
        barcodeProxyByUuid.appendToFrameView(adaFrameView);
        return null;
    }

    public String execute(IWebview iWebview, String str, String[] strArr) {
        BarcodeProxy barcodeProxy;
        if (str.equals("getBarcodeById")) {
            Context context = iWebview.getContext();
            AppRuntime.checkPrivacyComplianceAndPrompt(context, "Barcode-" + str);
            BarcodeProxy barcodeProxyById = getBarcodeProxyById(strArr[0]);
            if (barcodeProxyById != null) {
                return JSUtil.wrapJsVar(barcodeProxyById.getJsBarcode());
            }
        } else {
            String str2 = strArr[0];
            if (!this.mBProxyCaches.containsKey(str2)) {
                barcodeProxy = new BarcodeProxy();
                this.mBProxyCaches.put(str2, barcodeProxy);
            } else {
                barcodeProxy = this.mBProxyCaches.get(str2);
            }
            barcodeProxy.execute(iWebview, str, strArr);
        }
        return null;
    }

    public IWebview findWebviewByUuid(IWebview iWebview, String str) {
        Object processEvent;
        AbsMgr absMgr = this.mFeatureMgr;
        if (absMgr == null || (processEvent = absMgr.processEvent(IMgr.MgrType.FeatureMgr, 10, new Object[]{iWebview, AbsoluteConst.F_UI, "findWebview", new String[]{iWebview.obtainApp().obtainAppId(), str}})) == null) {
            return null;
        }
        return (IWebview) processEvent;
    }

    public BarcodeProxy getBarcodeProxyById(String str) {
        for (String str2 : this.mBProxyCaches.keySet()) {
            BarcodeProxy barcodeProxy = this.mBProxyCaches.get(str2);
            if (!TextUtils.isEmpty(barcodeProxy.mId) && barcodeProxy.mId.equals(str)) {
                return barcodeProxy;
            }
        }
        return null;
    }

    public BarcodeProxy getBarcodeProxyByUuid(String str) {
        if (this.mBProxyCaches.containsKey(str)) {
            return this.mBProxyCaches.get(str);
        }
        return null;
    }

    public void onDestroy() {
        for (String str : this.mBProxyCaches.keySet()) {
            BarcodeProxy remove = this.mBProxyCaches.remove(str);
            if (remove != null) {
                remove.onDestroy();
            }
        }
        this.mBProxyCaches.clear();
    }

    public void removeBarcodeProxy(String str) {
        BarcodeProxy remove = this.mBProxyCaches.remove(str);
        if (remove != null) {
            remove.onDestroy();
        }
    }

    public void setFeatureMgr(AbsMgr absMgr) {
        this.mFeatureMgr = absMgr;
    }
}
