package io.dcloud.feature.audio;

import android.content.Context;
import android.media.AudioManager;
import android.text.TextUtils;
import com.taobao.weex.common.Constants;
import io.dcloud.common.DHInterface.AbsMgr;
import io.dcloud.common.DHInterface.IApp;
import io.dcloud.common.DHInterface.IFeature;
import io.dcloud.common.DHInterface.IWebview;
import io.dcloud.common.adapter.util.Logger;
import io.dcloud.common.adapter.util.MessageHandler;
import io.dcloud.common.constant.AbsoluteConst;
import io.dcloud.common.constant.DOMException;
import io.dcloud.common.util.AppRuntime;
import io.dcloud.common.util.BaseInfo;
import io.dcloud.common.util.JSONUtil;
import io.dcloud.common.util.JSUtil;
import io.dcloud.feature.audio.recorder.RecordOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.json.JSONArray;

public class AudioFeatureImpl implements IFeature, MessageHandler.IMessages {
    static final String TAG = "AudioFeatureImpl";
    HashMap<String, ArrayList> mAppsAudioObj = null;

    private Object findAppObj(String str, String str2) {
        ArrayList appObjList = getAppObjList(str);
        if (!appObjList.isEmpty()) {
            Iterator it = appObjList.iterator();
            while (it.hasNext()) {
                Object next = it.next();
                if ((next instanceof AbsAudio) && ((AbsAudio) next).mUuid.equals(str2)) {
                    return next;
                }
            }
        }
        return null;
    }

    private ArrayList getAppObjList(String str) {
        ArrayList arrayList = this.mAppsAudioObj.get(str);
        if (arrayList != null) {
            return arrayList;
        }
        ArrayList arrayList2 = new ArrayList(2);
        this.mAppsAudioObj.put(str, arrayList2);
        return arrayList2;
    }

    private void putAppObjList(String str, Object obj) {
        getAppObjList(str).add(obj);
    }

    private void removeAppObjFromList(String str, Object obj) {
        ArrayList appObjList = getAppObjList(str);
        if (appObjList != null) {
            appObjList.remove(obj);
        }
    }

    private void setCanPlay(String str, String str2, boolean z) {
        Iterator it = getAppObjList(str).iterator();
        while (it.hasNext()) {
            Object next = it.next();
            if (next instanceof AudioPlayer) {
                AudioPlayer audioPlayer = (AudioPlayer) next;
                if (!audioPlayer.mUuid.equals(str2) && !z) {
                    audioPlayer.pause();
                }
                audioPlayer.setCanMix(z);
            }
        }
    }

    private void setSpeakerphoneOn(AudioManager audioManager, boolean z) {
        if (z) {
            audioManager.setSpeakerphoneOn(true);
            audioManager.setMode(1);
            return;
        }
        audioManager.setSpeakerphoneOn(false);
        audioManager.setRouting(0, 1, -1);
        audioManager.setMode(3);
    }

    @Override // io.dcloud.common.DHInterface.IFeature
    public void dispose(String str) {
    }

    /* JADX INFO: Can't fix incorrect switch cases order, some code will duplicate */
    /* JADX WARNING: Code restructure failed: missing block: B:15:0x0070, code lost:
        if (r10.equals("getBuffered") == false) goto L_0x0047;
     */
    @Override // io.dcloud.common.DHInterface.IFeature
    public String execute(IWebview iWebview, String str, String[] strArr) {
        String obtainAppId = iWebview.obtainFrameView().obtainApp().obtainAppId();
        Logger.d(TAG, "execute pJsArgs[0]=" + strArr[0]);
        char c = 2;
        String str2 = null;
        if ("AudioSyncExecMethod".equals(str)) {
            String str3 = strArr[0];
            JSONArray createJSONArray = JSONUtil.createJSONArray(strArr[1]);
            str3.hashCode();
            str3.hashCode();
            switch (str3.hashCode()) {
                case -1469262177:
                    if (str3.equals("getPosition")) {
                        c = 0;
                        break;
                    }
                    c = 65535;
                    break;
                case 85887754:
                    if (str3.equals("getDuration")) {
                        c = 1;
                        break;
                    }
                    c = 65535;
                    break;
                case 555863637:
                    break;
                case 700693540:
                    if (str3.equals("getPaused")) {
                        c = 3;
                        break;
                    }
                    c = 65535;
                    break;
                case 804240344:
                    if (str3.equals("getStyles")) {
                        c = 4;
                        break;
                    }
                    c = 65535;
                    break;
                case 1606340381:
                    if (str3.equals("CreatePlayer")) {
                        c = 5;
                        break;
                    }
                    c = 65535;
                    break;
                default:
                    c = 65535;
                    break;
            }
            switch (c) {
                case 0:
                    return String.valueOf(((AudioPlayer) findAppObj(obtainAppId, JSONUtil.getString(createJSONArray, 0))).getPosition());
                case 1:
                    return String.valueOf(((AudioPlayer) findAppObj(obtainAppId, JSONUtil.getString(createJSONArray, 0))).getDuration());
                case 2:
                    return ((AudioPlayer) findAppObj(obtainAppId, JSONUtil.getString(createJSONArray, 0))).getBuffer();
                case 3:
                    return ((AudioPlayer) findAppObj(obtainAppId, JSONUtil.getString(createJSONArray, 0))).isPause();
                case 4:
                    AudioPlayer audioPlayer = (AudioPlayer) findAppObj(obtainAppId, JSONUtil.getString(createJSONArray, 0));
                    if (createJSONArray.length() > 1) {
                        str2 = JSONUtil.getString(createJSONArray, 1);
                    }
                    return audioPlayer.getStyles(str2);
                case 5:
                    String string = JSONUtil.getString(createJSONArray, 0);
                    AudioPlayer createAudioPlayer = AudioPlayer.createAudioPlayer(JSONUtil.getJSONObject(createJSONArray, 1), iWebview);
                    createAudioPlayer.mUuid = string;
                    putAppObjList(iWebview.obtainFrameView().obtainApp().obtainAppId(), createAudioPlayer);
                    return null;
                default:
                    return null;
            }
        } else {
            MessageHandler.sendMessage(this, new Object[]{iWebview, str, strArr});
            return null;
        }
    }

    @Override // io.dcloud.common.DHInterface.IFeature
    public void init(AbsMgr absMgr, String str) {
        this.mAppsAudioObj = new HashMap<>(2);
    }

    /* JADX WARNING: Removed duplicated region for block: B:110:0x0244  */
    /* JADX WARNING: Removed duplicated region for block: B:139:? A[RETURN, SYNTHETIC] */
    @Override // io.dcloud.common.adapter.util.MessageHandler.IMessages
    public void execute(Object obj) {
        Exception e;
        char c;
        Object[] objArr = (Object[]) obj;
        IWebview iWebview = (IWebview) objArr[0];
        String valueOf = String.valueOf(objArr[1]);
        String[] strArr = (String[]) objArr[2];
        IApp obtainApp = iWebview.obtainFrameView().obtainApp();
        String obtainAppId = obtainApp.obtainAppId();
        String str = strArr[0];
        JSONArray createJSONArray = JSONUtil.createJSONArray(strArr[1]);
        String string = JSONUtil.getString(createJSONArray, 0);
        if ("RecorderExecMethod".equals(valueOf)) {
            Context context = iWebview.getContext();
            AppRuntime.checkPrivacyComplianceAndPrompt(context, "Audio-" + valueOf);
            try {
                if ("record".equals(str)) {
                    String string2 = JSONUtil.getString(createJSONArray, 1);
                    RecordOption recordOption = new RecordOption(iWebview, JSONUtil.getJSONObject(createJSONArray, 2));
                    if (!JSUtil.checkOperateDirErrorAndCallback(iWebview, string2, recordOption.mFileName)) {
                        AudioRecorderMgr startRecorder = AudioRecorderMgr.startRecorder(recordOption, string2);
                        startRecorder.mUuid = string;
                        putAppObjList(obtainAppId, startRecorder);
                    }
                } else if ("pause".equals(str)) {
                    ((AudioRecorderMgr) findAppObj(obtainAppId, string)).pause();
                } else if (Constants.Value.STOP.equals(str)) {
                    AudioRecorderMgr audioRecorderMgr = (AudioRecorderMgr) findAppObj(obtainAppId, string);
                    audioRecorderMgr.stop();
                    audioRecorderMgr.successCallback();
                    removeAppObjFromList(obtainAppId, audioRecorderMgr);
                } else if (AbsoluteConst.EVENTS_RESUME.equals(str)) {
                    ((AudioRecorderMgr) findAppObj(obtainAppId, string)).resume();
                }
            } catch (Exception e2) {
                e2.printStackTrace();
                Logger.e("RecorderExecMethod _methodName=" + str + "; e =" + e2);
            }
        } else if ("AudioExecMethod".equals(valueOf)) {
            AudioPlayer audioPlayer = null;
            String str2 = null;
            try {
                AudioPlayer audioPlayer2 = (AudioPlayer) findAppObj(obtainAppId, string);
                try {
                    switch (str.hashCode()) {
                        case -934426579:
                            if (str.equals(AbsoluteConst.EVENTS_RESUME)) {
                                c = 2;
                                break;
                            }
                            c = 65535;
                            break;
                        case -906224877:
                            if (str.equals("seekTo")) {
                                c = 5;
                                break;
                            }
                            c = 65535;
                            break;
                        case -625809843:
                            if (str.equals("addEventListener")) {
                                c = 7;
                                break;
                            }
                            c = 65535;
                            break;
                        case -541487286:
                            if (str.equals("removeEventListener")) {
                                c = '\b';
                                break;
                            }
                            c = 65535;
                            break;
                        case -388163342:
                            if (str.equals("setSessionCategory")) {
                                c = '\n';
                                break;
                            }
                            c = 65535;
                            break;
                        case 3443508:
                            if (str.equals(Constants.Value.PLAY)) {
                                c = 0;
                                break;
                            }
                            c = 65535;
                            break;
                        case 3540994:
                            if (str.equals(Constants.Value.STOP)) {
                                c = 3;
                                break;
                            }
                            c = 65535;
                            break;
                        case 94756344:
                            if (str.equals(AbsoluteConst.EVENTS_CLOSE)) {
                                c = 4;
                                break;
                            }
                            c = 65535;
                            break;
                        case 106440182:
                            if (str.equals("pause")) {
                                c = 1;
                                break;
                            }
                            c = 65535;
                            break;
                        case 589623268:
                            if (str.equals("setStyles")) {
                                c = '\t';
                                break;
                            }
                            c = 65535;
                            break;
                        case 1355420059:
                            if (str.equals("playbackRate")) {
                                c = 11;
                                break;
                            }
                            c = 65535;
                            break;
                        case 1403417351:
                            if (str.equals("setRoute")) {
                                c = 6;
                                break;
                            }
                            c = 65535;
                            break;
                        default:
                            c = 65535;
                            break;
                    }
                    switch (c) {
                        case 0:
                            setCanPlay(obtainAppId, string, audioPlayer2.isCanMix());
                            audioPlayer2.mFunId = JSONUtil.getString(createJSONArray, 1);
                            audioPlayer2.play();
                            return;
                        case 1:
                            audioPlayer2.pause();
                            return;
                        case 2:
                            setCanPlay(obtainAppId, string, audioPlayer2.isCanMix());
                            if (BaseInfo.isUniAppAppid(obtainApp)) {
                                audioPlayer2.mFunId = "";
                                audioPlayer2.play();
                                return;
                            }
                            audioPlayer2.resume();
                            return;
                        case 3:
                            audioPlayer2.stop();
                            return;
                        case 4:
                            audioPlayer2.destory();
                            removeAppObjFromList(obtainAppId, audioPlayer2);
                            return;
                        case 5:
                            try {
                                int parseInt = Integer.parseInt(JSONUtil.getString(createJSONArray, 1));
                                if (parseInt >= 0) {
                                    audioPlayer2.seekTo(parseInt * 1000);
                                    return;
                                }
                                return;
                            } catch (Exception unused) {
                                int parseDouble = (int) (Double.parseDouble(JSONUtil.getString(createJSONArray, 1)) * 1000.0d);
                                if (parseDouble >= 0) {
                                    audioPlayer2.seekTo(parseDouble);
                                    return;
                                }
                                return;
                            }
                        case 6:
                            AudioManager audioManager = (AudioManager) iWebview.getContext().getSystemService("audio");
                            if (Integer.parseInt(createJSONArray.optString(1)) == 1) {
                                setSpeakerphoneOn(audioManager, false);
                                return;
                            } else {
                                setSpeakerphoneOn(audioManager, true);
                                return;
                            }
                        case 7:
                            audioPlayer2.addEventListener(createJSONArray.optString(1), createJSONArray.optString(2));
                            return;
                        case '\b':
                            audioPlayer2.removeEventListener(createJSONArray.optString(1));
                            return;
                        case '\t':
                            audioPlayer2.setStyle(createJSONArray.optJSONObject(1));
                            return;
                        case '\n':
                            if (createJSONArray.length() > 1) {
                                str2 = JSONUtil.getString(createJSONArray, 1);
                            }
                            audioPlayer2.setSessionCategory(str2);
                            return;
                        case 11:
                            if (createJSONArray.length() > 1) {
                                String string3 = JSONUtil.getString(createJSONArray, 1);
                                try {
                                    if (!TextUtils.isEmpty(string3)) {
                                        float parseFloat = Float.parseFloat(string3);
                                        if (parseFloat > 0.0f) {
                                            audioPlayer2.playbackRate(parseFloat);
                                            return;
                                        }
                                        return;
                                    }
                                    return;
                                } catch (Exception unused2) {
                                    return;
                                }
                            } else {
                                return;
                            }
                        default:
                            return;
                    }
                } catch (Exception e3) {
                    e = e3;
                    audioPlayer = audioPlayer2;
                    e.printStackTrace();
                    if (audioPlayer == null) {
                    }
                }
            } catch (Exception e4) {
                e = e4;
                e.printStackTrace();
                if (audioPlayer == null) {
                    String str3 = DOMException.MSG_PARAMETER_ERROR;
                    audioPlayer.failCallback(-1, str3);
                    audioPlayer.execEvents("onError", DOMException.toJSON(-1, str3));
                }
            }
        }
    }
}
