package io.dcloud.common.util.net;

import io.dcloud.common.util.ThreadPool;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedList;

public class NetWorkLoop {
    private final int MAX_EXE_REQUESTDATA = 5;
    private LoopComparator mComparator = new LoopComparator();
    protected LinkedList<NetWork> mExeTask = new LinkedList<>();
    protected LinkedList<NetWork> mQuestTask = new LinkedList<>();
    protected Thread mSyncThread;

    /* access modifiers changed from: package-private */
    public class LoopComparator implements Comparator<NetWork> {
        LoopComparator() {
        }

        public int compare(NetWork netWork, NetWork netWork2) {
            return netWork.mPriority - netWork2.mPriority;
        }
    }

    public synchronized void addNetWork(NetWork netWork) {
        this.mQuestTask.add(netWork);
        Collections.sort(this.mQuestTask, this.mComparator);
    }

    public void dispose() {
        this.mSyncThread = null;
        try {
            LinkedList<NetWork> linkedList = this.mExeTask;
            if (linkedList != null && linkedList.size() > 0) {
                Iterator<NetWork> it = this.mExeTask.iterator();
                while (it.hasNext()) {
                    it.next().dispose();
                }
                this.mExeTask.clear();
                this.mExeTask = null;
            }
            LinkedList<NetWork> linkedList2 = this.mQuestTask;
            if (linkedList2 != null && linkedList2.size() > 0) {
                Iterator<NetWork> it2 = this.mQuestTask.iterator();
                while (it2.hasNext()) {
                    it2.next().dispose();
                }
                this.mQuestTask.clear();
                this.mQuestTask = null;
            }
        } catch (ConcurrentModificationException e) {
            e.printStackTrace();
        }
    }

    /* access modifiers changed from: protected */
    public void execSyncTask(NetWork netWork) {
        netWork.mNetWorkLoop = this;
        netWork.startWork();
    }

    public synchronized void removeNetWork(final NetWork netWork) {
        try {
            if (this.mQuestTask.contains(netWork)) {
                this.mQuestTask.remove(netWork);
            }
            if (this.mExeTask.contains(netWork)) {
                this.mExeTask.remove(netWork);
            }
            ThreadPool.self().addThreadTask(new Runnable() {
                /* class io.dcloud.common.util.net.NetWorkLoop.AnonymousClass2 */

                public void run() {
                    netWork.cancelWork();
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
        return;
    }

    public void startThreadPool() {
        AnonymousClass1 r0 = new Thread() {
            /* class io.dcloud.common.util.net.NetWorkLoop.AnonymousClass1 */

            public void run() {
                while (true) {
                    try {
                        NetWorkLoop netWorkLoop = NetWorkLoop.this;
                        if (netWorkLoop.mSyncThread != null) {
                            if (netWorkLoop.mQuestTask.isEmpty()) {
                                Thread.sleep(100);
                            } else {
                                synchronized (NetWorkLoop.this.mExeTask) {
                                    if (NetWorkLoop.this.mExeTask.size() < 5) {
                                        synchronized (NetWorkLoop.this.mQuestTask) {
                                            NetWork netWork = NetWorkLoop.this.mQuestTask.get(0);
                                            NetWorkLoop.this.mExeTask.add(netWork);
                                            NetWorkLoop.this.mQuestTask.remove(netWork);
                                            NetWorkLoop.this.execSyncTask(netWork);
                                        }
                                    }
                                }
                            }
                        } else {
                            return;
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        this.mSyncThread = r0;
        r0.start();
    }
}
