package io.dcloud.common.util.net;

import android.app.Activity;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import io.dcloud.common.DHInterface.AbsMgr;
import io.dcloud.common.DHInterface.ICore;
import io.dcloud.common.DHInterface.IMgr;
import io.dcloud.common.DHInterface.ISysEventListener;
import io.dcloud.common.adapter.io.DHFile;
import io.dcloud.common.adapter.util.Logger;
import io.dcloud.common.adapter.util.PlatformUtil;
import io.dcloud.common.util.BaseInfo;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.common.util.net.http.IServer;
import io.dcloud.feature.internal.sdk.SDK;
import java.io.File;
import java.util.ArrayList;
import tv.danmaku.ijk.media.player.IjkMediaPlayer;

public class NetMgr extends AbsMgr implements IMgr.NetEvent {
    DownloadMgr mDownloadMgr;
    IServer mLocalServer = null;
    NetCheckReceiver mNetCheckReceiver = null;
    UploadMgr mUploadMgr;

    public NetMgr(ICore iCore) {
        super(iCore, "netmgr", IMgr.MgrType.NetMgr);
        startMiniServer();
        this.mUploadMgr = UploadMgr.getUploadMgr();
        this.mDownloadMgr = DownloadMgr.getDownloadMgr();
        this.mNetCheckReceiver = new NetCheckReceiver(this);
        IntentFilter intentFilter = new IntentFilter(NetCheckReceiver.netACTION);
        intentFilter.addAction(NetCheckReceiver.simACTION);
        getContext().registerReceiver(this.mNetCheckReceiver, intentFilter);
    }

    private IServer initLocalServer() {
        Object newInstance;
        Object newInstance2;
        final ArrayList arrayList = new ArrayList();
        if (BaseInfo.SyncDebug && (newInstance2 = PlatformUtil.newInstance("io.dcloud.common.util.net.http.LocalServer", new Class[]{AbsMgr.class, Integer.TYPE}, new Object[]{this, 13131})) != null && (newInstance2 instanceof IServer)) {
            arrayList.add((IServer) newInstance2);
        }
        if (Build.VERSION.SDK_INT >= 21 && BaseInfo.SyncDebug) {
            Activity activity = (Activity) this.mCore.obtainActivityContext();
            Intent intent = activity.getIntent();
            String stringExtra = intent.getStringExtra(IjkMediaPlayer.OnNativeInvokeListener.ARG_IP);
            String stringExtra2 = intent.getStringExtra(IjkMediaPlayer.OnNativeInvokeListener.ARG_PORT);
            if (PdrUtil.isEmpty(stringExtra) || PdrUtil.isEmpty(stringExtra2)) {
                byte[] readAll = DHFile.readAll(activity.getExternalCacheDir().getPath() + File.separator + "debug_info");
                if (readAll != null) {
                    JSONObject parseObject = JSON.parseObject(new String(readAll));
                    stringExtra = (String) parseObject.get(IjkMediaPlayer.OnNativeInvokeListener.ARG_IP);
                    stringExtra2 = (String) parseObject.get(IjkMediaPlayer.OnNativeInvokeListener.ARG_PORT);
                }
            }
            if (!PdrUtil.isEmpty(stringExtra) && !PdrUtil.isEmpty(stringExtra2) && (newInstance = PlatformUtil.newInstance("io.dcloud.common.util.net.http.LocalServer2", new Class[]{AbsMgr.class, Activity.class, String.class, String.class}, new Object[]{this, activity, stringExtra, stringExtra2})) != null && (newInstance instanceof IServer)) {
                arrayList.add((IServer) newInstance);
            }
        }
        return new IServer() {
            /* class io.dcloud.common.util.net.NetMgr.AnonymousClass1 */

            @Override // io.dcloud.common.util.net.http.IServer
            public void start() {
                for (IServer iServer : arrayList) {
                    iServer.start();
                }
            }

            @Override // io.dcloud.common.util.net.http.IServer
            public void stop() {
                for (IServer iServer : arrayList) {
                    iServer.stop();
                }
            }
        };
    }

    @Override // io.dcloud.common.DHInterface.AbsMgr
    public void dispose() {
        IServer iServer = this.mLocalServer;
        if (iServer != null) {
            iServer.stop();
        }
        UploadMgr uploadMgr = this.mUploadMgr;
        if (uploadMgr != null) {
            uploadMgr.dispose();
        }
        getContext().unregisterReceiver(this.mNetCheckReceiver);
    }

    @Override // io.dcloud.common.DHInterface.AbsMgr
    public void onExecute(ISysEventListener.SysEventType sysEventType, Object obj) {
        if (sysEventType == ISysEventListener.SysEventType.onStop) {
            IServer iServer = this.mLocalServer;
            if (iServer != null) {
                iServer.stop();
                this.mLocalServer = null;
            }
        } else if ((sysEventType == ISysEventListener.SysEventType.onResume || sysEventType == ISysEventListener.SysEventType.onNewIntent) && this.mLocalServer == null) {
            startMiniServer();
        }
    }

    @Override // io.dcloud.common.DHInterface.IMgr
    public Object processEvent(IMgr.MgrType mgrType, int i, Object obj) {
        try {
            if (!checkMgrId(mgrType)) {
                return this.mCore.dispatchEvent(mgrType, i, obj);
            }
        } catch (Throwable th) {
            Logger.w("NetMgr.processEvent", th);
        }
        return null;
    }

    /* access modifiers changed from: protected */
    public void startMiniServer() {
        if (BaseInfo.ISDEBUG && !SDK.isUniMPSDK()) {
            IServer initLocalServer = initLocalServer();
            this.mLocalServer = initLocalServer;
            initLocalServer.start();
        }
    }
}
