package io.dcloud.common.util.language;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import android.os.LocaleList;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.el.parse.Operators;
import io.dcloud.common.adapter.util.DeviceInfo;
import io.dcloud.common.util.PdrUtil;
import java.util.Locale;

public class LanguageUtil {
    public static final String LanguageBroadCastIntent = "language_uni_broad_cast_intent";
    public static final String LanguageConfigKey = "language_uni_current_key";
    public static final String LanguageConfigSPFile = "language_uni_sp_file";
    private static String deviceDefCountry = "";
    private static String deviceDefLocalLanguage = "";
    private static String sCurrentLocalLanguage = "";

    public static Locale getCurrentLocal(Context context, boolean z) {
        if (context == null) {
            return null;
        }
        if (Build.VERSION.SDK_INT >= 24) {
            LocaleList locales = context.getResources().getConfiguration().getLocales();
            if (z) {
                context.getResources();
                locales = Resources.getSystem().getConfiguration().getLocales();
            }
            if (locales == null || locales.size() <= 0) {
                return context.getResources().getConfiguration().locale;
            }
            return locales.get(0);
        } else if (!z) {
            return context.getResources().getConfiguration().locale;
        } else {
            context.getResources();
            return Resources.getSystem().getConfiguration().locale;
        }
    }

    /* JADX INFO: Can't fix incorrect switch cases order, some code will duplicate */
    /* JADX WARNING: Code restructure failed: missing block: B:19:0x006b, code lost:
        if (r7.equals("es") == false) goto L_0x0050;
     */
    public static String getCurrentLocaleLanguage(Context context) {
        if (!TextUtils.isEmpty(sCurrentLocalLanguage)) {
            return sCurrentLocalLanguage;
        }
        char c = 1;
        Locale currentLocal = getCurrentLocal(context, true);
        if (currentLocal == null) {
            return deviceDefLocalLanguage;
        }
        String str = currentLocal.getLanguage() + Operators.SUB + currentLocal.getCountry();
        if (Build.VERSION.SDK_INT > 21) {
            str = currentLocal.toLanguageTag();
        }
        String language = currentLocal.getLanguage();
        language.hashCode();
        language.hashCode();
        switch (language.hashCode()) {
            case 3241:
                if (language.equals("en")) {
                    c = 0;
                    break;
                }
                c = 65535;
                break;
            case 3246:
                break;
            case 3276:
                if (language.equals("fr")) {
                    c = 2;
                    break;
                }
                c = 65535;
                break;
            case 3886:
                if (language.equals("zh")) {
                    c = 3;
                    break;
                }
                c = 65535;
                break;
            default:
                c = 65535;
                break;
        }
        switch (c) {
            case 0:
                return "en";
            case 1:
                return "es";
            case 2:
                return "fr";
            case 3:
                if (str.equalsIgnoreCase("zh-CN")) {
                    return "zh-Hans";
                }
                if (str.equalsIgnoreCase("zh-HK")) {
                    return "zh-Hant-HK";
                }
                return str.equalsIgnoreCase("zh-TW") ? "zh-Hant-TW" : str;
            default:
                return str;
        }
    }

    public static String getDeviceDefCountry() {
        return deviceDefCountry;
    }

    public static String getDeviceDefLocalLanguage() {
        return deviceDefLocalLanguage;
    }

    /* JADX WARNING: Removed duplicated region for block: B:30:0x00b6  */
    /* JADX WARNING: Removed duplicated region for block: B:32:? A[RETURN, SYNTHETIC] */
    public static String getString(JSONObject jSONObject, String str) {
        String str2;
        if (jSONObject != null) {
            String currentLocaleLanguage = getCurrentLocaleLanguage(DeviceInfo.sApplicationContext);
            if (!TextUtils.isEmpty(currentLocaleLanguage)) {
                str2 = getString(currentLocaleLanguage, jSONObject);
                if (TextUtils.isEmpty(str2)) {
                    if (currentLocaleLanguage.equalsIgnoreCase("zh-CN")) {
                        str2 = getString("zh-Hans", jSONObject);
                    } else if (currentLocaleLanguage.equalsIgnoreCase("zh-HK")) {
                        str2 = getString("zh-Hant-HK", jSONObject);
                    } else if (currentLocaleLanguage.equalsIgnoreCase("zh-TW")) {
                        str2 = getString("zh-Hant-TW", jSONObject);
                    }
                    if (TextUtils.isEmpty(str2)) {
                        String[] split = currentLocaleLanguage.split(Operators.SUB);
                        int length = split.length;
                        if (length == 2) {
                            str2 = getString(split[0], jSONObject);
                        } else if (length == 3) {
                            str2 = getString(split[0] + Operators.SUB + split[2], jSONObject);
                            if (TextUtils.isEmpty(str2)) {
                                str2 = getString(split[0] + Operators.SUB + split[1], jSONObject);
                            }
                            if (TextUtils.isEmpty(str2)) {
                                str2 = getString(split[0], jSONObject);
                            }
                        }
                    }
                }
                return !PdrUtil.isEmpty(str2) ? str : str2;
            }
        }
        str2 = str;
        if (!PdrUtil.isEmpty(str2)) {
        }
    }

    public static void initAppLanguageForAppBeforeO(Context context) {
        updateAppBootLanguage(context);
        updateSystemLanguage(context);
    }

    private static void updateAppBootLanguage(Context context) {
        String str;
        String str2 = "";
        String string = context.getSharedPreferences(LanguageConfigSPFile, 0).getString(LanguageConfigKey, str2);
        try {
            str = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128).metaData.getString("DCLOUD_APP_DEFAULT_LANGUAGE");
        } catch (Exception e) {
            e.printStackTrace();
            str = str2;
        }
        if (TextUtils.isEmpty(string) && !TextUtils.isEmpty(str)) {
            string = str;
        }
        if (!"auto".equalsIgnoreCase(string)) {
            str2 = string;
        }
        sCurrentLocalLanguage = str2;
        updateDeviceDefLocalLanguage(context);
    }

    public static Context updateContextLanguageAfterO(Context context, boolean z) {
        return updateContextLanguageAfterO(context, z, true);
    }

    public static void updateDeviceDefLocalLanguage(Locale locale) {
        if (locale != null) {
            deviceDefLocalLanguage = locale.getLanguage() + Operators.SUB + locale.getCountry();
            deviceDefCountry = locale.getCountry();
            DeviceInfo.sLanguage = deviceDefLocalLanguage;
        }
    }

    public static void updateLanguage(Context context, String str) {
        if (context != null) {
            SharedPreferences.Editor edit = context.getSharedPreferences(LanguageConfigSPFile, 0).edit();
            edit.putString(LanguageConfigKey, str);
            edit.commit();
            sCurrentLocalLanguage = str;
            updateSystemLanguage(context);
        }
    }

    public static void updateSystemLanguage(Context context) {
        if (context != null) {
            String str = sCurrentLocalLanguage;
            if ("zh-Hant-TW".equals(str) || "zh-Hant".equals(str)) {
                str = "zh-TW";
            } else if ("zh-Hant-HK".equals(str)) {
                str = "zh-HK";
            }
            int i = Build.VERSION.SDK_INT;
            if (i >= 24) {
                Resources resources = context.getResources();
                DisplayMetrics displayMetrics = resources.getDisplayMetrics();
                Configuration configuration = resources.getConfiguration();
                if (TextUtils.isEmpty(str)) {
                    str = deviceDefLocalLanguage;
                }
                LocaleList localeList = new LocaleList(Locale.forLanguageTag(str));
                LocaleList.setDefault(localeList);
                configuration.setLocales(localeList);
                resources.updateConfiguration(configuration, displayMetrics);
            } else if (i >= 21) {
                Resources resources2 = context.getResources();
                if (TextUtils.isEmpty(str)) {
                    str = deviceDefLocalLanguage;
                }
                Locale forLanguageTag = Locale.forLanguageTag(str);
                Locale.setDefault(forLanguageTag);
                Configuration configuration2 = resources2.getConfiguration();
                configuration2.setLocale(forLanguageTag);
                resources2.updateConfiguration(configuration2, resources2.getDisplayMetrics());
            }
        }
    }

    public static Context wrapContextConfigurationAfterO(Context context, String str) {
        return wrapContextConfigurationAfterO(context, str, true);
    }

    public static Context updateContextLanguageAfterO(Context context, boolean z, boolean z2) {
        if (z) {
            updateAppBootLanguage(context);
        }
        if (TextUtils.isEmpty(sCurrentLocalLanguage)) {
            return context;
        }
        return wrapContextConfigurationAfterO(context, sCurrentLocalLanguage, z2);
    }

    public static Context wrapContextConfigurationAfterO(Context context, String str, boolean z) {
        if (Build.VERSION.SDK_INT < 24) {
            return context;
        }
        Resources resources = context.getResources();
        DisplayMetrics displayMetrics = resources.getDisplayMetrics();
        Configuration configuration = resources.getConfiguration();
        LocaleList localeList = new LocaleList(Locale.forLanguageTag(str));
        LocaleList.setDefault(localeList);
        configuration.setLocales(localeList);
        resources.updateConfiguration(configuration, displayMetrics);
        return z ? context.createConfigurationContext(configuration) : context;
    }

    public static void updateDeviceDefLocalLanguage(Context context) {
        updateDeviceDefLocalLanguage(getCurrentLocal(context, true));
    }

    private static String getString(String str, JSONObject jSONObject) {
        if (jSONObject == null || !jSONObject.containsKey(str)) {
            return null;
        }
        return jSONObject.getString(str);
    }
}
