package io.dcloud.common.util.db;

import android.content.ContentValues;
import android.content.Context;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteFullException;
import android.database.sqlite.SQLiteStatement;
import android.text.TextUtils;
import io.dcloud.application.DCLoudApplicationImpl;
import io.dcloud.base.R;
import io.dcloud.common.DHInterface.IApp;
import io.dcloud.common.adapter.util.SP;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.feature.internal.sdk.SDK;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class DCStorage {
    public static final int ERROR_DEF = -1;
    public static final int ERROR_FULL = -2;
    public static final int ERROR_NO_KEY = -3;
    public static final int SUCCESS = 1;
    private static DCStorage mInstance;
    private String DBFILE_NAME = "_dbfile";
    private String DCDBFILE_START = "DCDBFile_";
    private String ERROR_TAG = "__ERROR__";
    private String TABLET_TAG = "_storage";
    private DCSQLiteOpenHelper mDatabaseSupplier;
    private ExecutorService mExecutorService;

    public class StorageInfo {
        public int code;
        public String meg;
        public Object v;

        public StorageInfo() {
        }
    }

    private DCStorage(Context context) {
        this.mDatabaseSupplier = DCSQLiteOpenHelper.getSQLiteOpenHelper(context);
    }

    private void clearDBFile(Context context, String str) {
        File file = new File(getBaseDBFilePath(context, str));
        if (file.exists()) {
            file.delete();
        }
    }

    private String getBaseDBFilePath(Context context, String str) {
        return context.getFilesDir().getAbsolutePath() + "/apps/" + str + "/dbfile/";
    }

    private String getCurrentTableName(String str) {
        return "DC_" + Math.abs(str.hashCode()) + this.TABLET_TAG;
    }

    /* JADX WARNING: Code restructure failed: missing block: B:31:0x0059, code lost:
        if (r2 != null) goto L_0x005b;
     */
    /* JADX WARNING: Removed duplicated region for block: B:28:0x0054 A[Catch:{ FileNotFoundException -> 0x0055, IOException -> 0x004e, all -> 0x004c }] */
    /* JADX WARNING: Removed duplicated region for block: B:34:0x0061 A[SYNTHETIC, Splitter:B:34:0x0061] */
    private String getDBFileValue(String str) {
        Throwable th;
        FileNotFoundException e;
        IOException e2;
        String str2 = "";
        if (!PdrUtil.isEmpty(str)) {
            if (str.startsWith(this.DCDBFILE_START)) {
                str = str.substring(9);
            }
            BufferedReader bufferedReader = null;
            if (new File(str).exists()) {
                StringBuffer stringBuffer = new StringBuffer();
                try {
                    BufferedReader bufferedReader2 = new BufferedReader(new FileReader(str));
                    while (true) {
                        try {
                            String readLine = bufferedReader2.readLine();
                            if (readLine == null) {
                                break;
                            }
                            stringBuffer.append(readLine);
                        } catch (FileNotFoundException e3) {
                            e = e3;
                            bufferedReader = bufferedReader2;
                            e.printStackTrace();
                        } catch (IOException e4) {
                            e2 = e4;
                            bufferedReader = bufferedReader2;
                            e2.printStackTrace();
                            if (bufferedReader != null) {
                            }
                            return str2;
                        } catch (Throwable th2) {
                            th = th2;
                            bufferedReader = bufferedReader2;
                            if (bufferedReader != null) {
                            }
                            throw th;
                        }
                    }
                    str2 = stringBuffer.toString();
                    try {
                        bufferedReader2.close();
                    } catch (IOException unused) {
                    }
                } catch (FileNotFoundException e5) {
                    e = e5;
                    e.printStackTrace();
                } catch (IOException e6) {
                    e2 = e6;
                    e2.printStackTrace();
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                    return str2;
                } catch (Throwable th3) {
                    th = th3;
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        } catch (IOException unused2) {
                        }
                    }
                    throw th;
                }
            }
        }
        return str2;
    }

    public static DCStorage getDCStorage(Context context) {
        if (mInstance == null && context != null) {
            mInstance = new DCStorage(context);
        }
        return mInstance;
    }

    private String getMsgForCode(Context context, int i) {
        if (i == -3) {
            return context.getString(R.string.dcloud_storage_not_find_error);
        }
        if (i != -2) {
            return i != 1 ? "" : context.getString(R.string.dcloud_storage_success);
        }
        return context.getString(R.string.dcloud_storage_ceiling_error);
    }

    private void removeDBFile(Context context, String str, String str2) {
        removeDBFile(getBaseDBFilePath(context, str) + str2 + this.DBFILE_NAME);
    }

    private String saveDBFileValue(Context context, String str, String str2, String str3) {
        String baseDBFilePath = getBaseDBFilePath(context, str);
        File file = new File(baseDBFilePath);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (file.isFile()) {
            file.delete();
            file.mkdirs();
        }
        String str4 = baseDBFilePath + str2.hashCode() + this.DBFILE_NAME;
        File file2 = new File(str4);
        if (file2.exists()) {
            file2.delete();
        }
        try {
            file2.createNewFile();
            FileOutputStream fileOutputStream = new FileOutputStream(str4);
            fileOutputStream.write(str3.getBytes());
            fileOutputStream.close();
            return this.DCDBFILE_START + str4;
        } catch (IOException e) {
            e.printStackTrace();
            return this.ERROR_TAG + e.getMessage() + str4;
        }
    }

    public synchronized void checkSPstorageToDB(Context context, String str) {
        SharedPreferences orCreateBundle = SP.getOrCreateBundle(context, str + "_storages");
        SharedPreferences.Editor edit = orCreateBundle.edit();
        Map<String, ?> all = orCreateBundle.getAll();
        if (all != null && all.size() > 0) {
            for (String str2 : all.keySet()) {
                if (performSetItem(context, str, str2, (String) all.get(str2)).code == 1) {
                    edit.remove(str2);
                }
            }
        }
        edit.commit();
    }

    public void close() {
        execute(new Runnable() {
            /* class io.dcloud.common.util.db.DCStorage.AnonymousClass1 */

            public void run() {
                try {
                    if (DCStorage.this.mDatabaseSupplier != null) {
                        DCStorage.this.mDatabaseSupplier.closeDatabase();
                    }
                    if (DCStorage.this.mExecutorService != null) {
                        DCStorage.this.mExecutorService.shutdown();
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
                DCStorage.this.mExecutorService = null;
            }
        });
    }

    public void execute(Runnable runnable) {
        if (this.mExecutorService == null) {
            this.mExecutorService = Executors.newSingleThreadExecutor();
        }
        if (runnable != null && !this.mExecutorService.isShutdown() && !this.mExecutorService.isTerminated()) {
            this.mExecutorService.execute(runnable);
        }
    }

    public synchronized Long getDBCurrentLength(String str) {
        SQLiteDatabase database = this.mDatabaseSupplier.getDatabase(getCurrentTableName(str));
        if (database == null) {
            return 0L;
        }
        File file = new File(database.getPath());
        if (!file.exists()) {
            return 0L;
        }
        return Long.valueOf(file.length());
    }

    public synchronized Long getDBMaxLength(String str) {
        SQLiteDatabase database = this.mDatabaseSupplier.getDatabase(getCurrentTableName(str));
        if (database == null) {
            return 0L;
        }
        return Long.valueOf(database.getMaximumSize());
    }

    public synchronized StorageInfo performClear(Context context, String str) {
        SQLiteDatabase database = this.mDatabaseSupplier.getDatabase(getCurrentTableName(str));
        StorageInfo storageInfo = new StorageInfo();
        if (database == null) {
            storageInfo.code = -1;
            storageInfo.meg = context.getString(R.string.dcloud_storage_no_db_error);
            return storageInfo;
        }
        storageInfo.code = 1;
        try {
            database.execSQL("delete from " + getCurrentTableName(str));
            if (!SDK.isUniMPSDK()) {
                this.mDatabaseSupplier.ensureDatabase(getCurrentTableName(str));
            }
            clearDBFile(context, str);
        } catch (Exception e) {
            storageInfo.code = -1;
            storageInfo.meg = context.getString(R.string.dcloud_storage_native_error) + e.getMessage();
        }
        return storageInfo;
    }

    public synchronized StorageInfo performGetAllKeys(String str) {
        SQLiteDatabase database = this.mDatabaseSupplier.getDatabase(getCurrentTableName(str));
        StorageInfo storageInfo = new StorageInfo();
        Context context = DCLoudApplicationImpl.self().getContext();
        if (database == null) {
            storageInfo.code = -1;
            storageInfo.meg = context.getString(R.string.dcloud_storage_no_db_error);
            return storageInfo;
        }
        ArrayList arrayList = new ArrayList();
        Cursor query = database.query(getCurrentTableName(str), new String[]{IApp.ConfigProperty.CONFIG_KEY}, null, null, null, null, null);
        while (query.moveToNext()) {
            try {
                arrayList.add(query.getString(query.getColumnIndex(IApp.ConfigProperty.CONFIG_KEY)));
            } catch (Exception e) {
                storageInfo.code = -1;
                storageInfo.meg = context.getString(R.string.dcloud_storage_native_error) + e.getMessage();
            } catch (Throwable th) {
                query.close();
                throw th;
            }
        }
        storageInfo.code = 1;
        storageInfo.v = arrayList;
        query.close();
        return storageInfo;
    }

    public synchronized StorageInfo performGetItem(String str, String str2) {
        SQLiteDatabase database = this.mDatabaseSupplier.getDatabase(getCurrentTableName(str));
        StorageInfo storageInfo = new StorageInfo();
        Context context = DCLoudApplicationImpl.self().getContext();
        if (database == null) {
            storageInfo.code = -1;
            storageInfo.meg = context.getString(R.string.dcloud_storage_no_db_error);
            return storageInfo;
        }
        Cursor query = database.query(getCurrentTableName(str), new String[]{"value"}, "key=?", new String[]{str2}, null, null, null);
        try {
            if (query.moveToNext()) {
                ContentValues contentValues = new ContentValues();
                contentValues.put("timestamp", DCSQLiteOpenHelper.sDateFormatter.format(new Date()));
                this.mDatabaseSupplier.getDatabase(getCurrentTableName(str)).update(getCurrentTableName(str), contentValues, "key= ?", new String[]{str2});
                String string = query.getString(query.getColumnIndex("value"));
                if (TextUtils.isEmpty(string) || !string.startsWith(this.DCDBFILE_START)) {
                    storageInfo.v = string;
                } else {
                    String dBFileValue = getDBFileValue(string);
                    if (PdrUtil.isEmpty(dBFileValue)) {
                        storageInfo.v = string;
                    } else {
                        storageInfo.v = dBFileValue;
                    }
                }
                storageInfo.code = 1;
                return storageInfo;
            }
            storageInfo.code = -3;
            storageInfo.meg = getMsgForCode(context, -3);
            query.close();
            return storageInfo;
        } catch (Exception e) {
            storageInfo.code = -1;
            storageInfo.meg = context.getString(R.string.dcloud_storage_native_error) + e.getMessage();
            return storageInfo;
        } finally {
            query.close();
        }
    }

    public synchronized StorageInfo performGetLength(String str) {
        SQLiteDatabase database = this.mDatabaseSupplier.getDatabase(getCurrentTableName(str));
        StorageInfo storageInfo = new StorageInfo();
        Context context = DCLoudApplicationImpl.self().getContext();
        if (database == null) {
            storageInfo.code = -1;
            storageInfo.meg = context.getString(R.string.dcloud_storage_no_db_error);
            return storageInfo;
        }
        SQLiteStatement sQLiteStatement = null;
        try {
            sQLiteStatement = database.compileStatement("SELECT count(key) FROM " + getCurrentTableName(str));
            storageInfo.v = Long.valueOf(sQLiteStatement.simpleQueryForLong());
            storageInfo.code = 1;
            sQLiteStatement.close();
            return storageInfo;
        } catch (Exception e) {
            storageInfo.code = -1;
            storageInfo.meg = context.getString(R.string.dcloud_storage_native_error) + e.getMessage();
            if (sQLiteStatement != null) {
                sQLiteStatement.close();
            }
            return storageInfo;
        } catch (Throwable unused) {
            if (sQLiteStatement != null) {
                sQLiteStatement.close();
            }
            return storageInfo;
        }
    }

    public synchronized StorageInfo performRemoveItem(Context context, String str, String str2) {
        SQLiteDatabase database = this.mDatabaseSupplier.getDatabase(getCurrentTableName(str));
        StorageInfo storageInfo = new StorageInfo();
        if (database == null) {
            storageInfo.code = -1;
            storageInfo.meg = context.getString(R.string.dcloud_storage_no_db_error);
            return storageInfo;
        }
        try {
            int delete = database.delete(getCurrentTableName(str), "key=?", new String[]{str2});
            if (delete > 0) {
                removeDBFile(context, str, str2);
            }
            if (delete == 1) {
                storageInfo.code = 1;
            } else {
                storageInfo.code = -3;
                storageInfo.meg = getMsgForCode(context, -3);
            }
        } catch (Exception e) {
            storageInfo.code = -1;
            storageInfo.meg = context.getString(R.string.dcloud_storage_native_error) + e.getMessage();
        }
        return storageInfo;
    }

    public synchronized StorageInfo performSetItem(Context context, String str, String str2, String str3) {
        SQLiteDatabase database = this.mDatabaseSupplier.getDatabase(getCurrentTableName(str));
        StorageInfo storageInfo = new StorageInfo();
        if (database == null) {
            storageInfo.code = -1;
            storageInfo.meg = context.getString(R.string.dcloud_storage_no_db_error);
            return storageInfo;
        } else if (PdrUtil.isEmpty(str2)) {
            storageInfo.code = -1;
            storageInfo.meg = context.getString(R.string.dcloud_storage_key_error);
            return storageInfo;
        } else {
            String str4 = "INSERT OR REPLACE INTO " + getCurrentTableName(str) + " VALUES (?,?,?);";
            SQLiteStatement sQLiteStatement = null;
            String format = DCSQLiteOpenHelper.sDateFormatter.format(new Date());
            try {
                if (str3.getBytes().length >= 1800000) {
                    str3 = saveDBFileValue(context, str, str2, str3);
                    if (TextUtils.isEmpty(str3) || str3.startsWith(this.ERROR_TAG)) {
                        storageInfo.code = -1;
                        storageInfo.meg = context.getString(R.string.dcloud_storage_write_big_error);
                        if (!TextUtils.isEmpty(str3) && str3.startsWith(this.ERROR_TAG)) {
                            storageInfo.meg += " error " + str3.replace(this.ERROR_TAG, "");
                        }
                        return storageInfo;
                    }
                }
                SQLiteStatement compileStatement = database.compileStatement(str4);
                compileStatement.clearBindings();
                compileStatement.bindString(1, str2);
                compileStatement.bindString(2, str3);
                compileStatement.bindString(3, format);
                compileStatement.execute();
                storageInfo.code = 1;
                compileStatement.close();
                return storageInfo;
            } catch (Exception e) {
                if (e instanceof SQLiteFullException) {
                    storageInfo.code = -2;
                    storageInfo.meg = getMsgForCode(context, -2);
                    if (0 != 0) {
                        sQLiteStatement.close();
                    }
                    return storageInfo;
                }
                storageInfo.code = -1;
                storageInfo.meg = context.getString(R.string.dcloud_storage_native_error) + e.getMessage();
                if (0 != 0) {
                    sQLiteStatement.close();
                }
                return storageInfo;
            } catch (Throwable th) {
                if (0 != 0) {
                    sQLiteStatement.close();
                }
                throw th;
            }
        }
    }

    private void removeDBFile(String str) {
        if (!PdrUtil.isEmpty(str)) {
            if (str.startsWith(this.DCDBFILE_START)) {
                str = str.substring(9);
            }
            File file = new File(str);
            if (file.exists()) {
                file.delete();
            }
        }
    }
}
