package io.dcloud.common.util;

import android.graphics.Color;
import android.text.TextUtils;
import com.taobao.weex.common.Constants;
import com.taobao.weex.el.parse.Operators;
import com.taobao.weex.performance.WXInstanceApm;
import io.dcloud.common.DHInterface.AbsMgr;
import io.dcloud.common.DHInterface.IFrameView;
import io.dcloud.common.DHInterface.IMgr;
import io.dcloud.common.DHInterface.ITitleNView;
import io.dcloud.common.DHInterface.IWebview;
import io.dcloud.common.adapter.ui.AdaFrameItem;
import io.dcloud.common.adapter.ui.AdaFrameView;
import io.dcloud.common.constant.AbsoluteConst;
import io.dcloud.common.core.ui.l;
import org.json.JSONArray;
import org.json.JSONObject;

public class TitleNViewUtil {
    public static final String TRANSPARENT_BUTTON_BACKGROUND_COLOR = "#7F333333";
    public static final String TRANSPARENT_BUTTON_TEXT_COLOR = "#FFFFFF";

    /* JADX WARNING: Removed duplicated region for block: B:75:0x00cb A[RETURN] */
    public static boolean backButtonIsChanged(JSONObject jSONObject, JSONObject jSONObject2) {
        if (jSONObject != null || jSONObject2 == null) {
            if (!(jSONObject == null || jSONObject2 == null)) {
                if (jSONObject2.has("titleColor")) {
                    return true;
                }
                if (jSONObject.has("autoBackButton") || jSONObject.has("backButton")) {
                    if (jSONObject.has("autoBackButton")) {
                        boolean optBoolean = jSONObject.optBoolean("autoBackButton");
                        if (!jSONObject2.has("autoBackButton")) {
                            return jSONObject2.has("backButton") && ((optBoolean && (jSONObject2.optJSONObject("backButton") == null || Constants.Name.UNDEFINED == jSONObject2.optString("backButton"))) || jSONObject2.optJSONObject("backButton") != null);
                        }
                        if (optBoolean != jSONObject2.optBoolean("autoBackButton")) {
                            return true;
                        }
                    } else if (jSONObject.has("backButton")) {
                        boolean z = jSONObject.optJSONObject("backButton") != null;
                        if (jSONObject2.has("autoBackButton")) {
                            if (z != jSONObject2.optBoolean("autoBackButton")) {
                                return true;
                            }
                        } else if (jSONObject2.has("backButton") && ((z && (jSONObject2.optJSONObject("backButton") == null || Constants.Name.UNDEFINED == jSONObject2.optString("backButton"))) || jSONObject2.optJSONObject("backButton") != null)) {
                            return true;
                        }
                    }
                } else if (jSONObject2.has("autoBackButton") && jSONObject2.optBoolean("autoBackButton")) {
                    return true;
                } else {
                    if (jSONObject2.has("backButton") && jSONObject2.optJSONObject("backButton") != null) {
                        return true;
                    }
                }
            }
        } else if (jSONObject2.has("autoBackButton")) {
            return true;
        } else {
            if ((jSONObject2.has("backButton") && (jSONObject2.optJSONObject("backButton") != null || Constants.Name.UNDEFINED != jSONObject2.optString("backButton"))) || jSONObject2.has("titleColor")) {
                return true;
            }
        }
    }

    public static boolean backgroundImageIsChanged(JSONObject jSONObject, JSONObject jSONObject2) {
        if (jSONObject2 == null || !jSONObject2.has(Constants.Name.BACKGROUND_IMAGE)) {
            return false;
        }
        if (jSONObject == null) {
            return jSONObject2.has(Constants.Name.BACKGROUND_IMAGE);
        }
        String optString = jSONObject.optString(Constants.Name.BACKGROUND_IMAGE);
        String optString2 = jSONObject2.optString(Constants.Name.BACKGROUND_IMAGE);
        if (!jSONObject.has(Constants.Name.BACKGROUND_IMAGE) && jSONObject2.has(Constants.Name.BACKGROUND_IMAGE)) {
            return true;
        }
        if (!jSONObject.has(Constants.Name.BACKGROUND_IMAGE) || !jSONObject2.has(Constants.Name.BACKGROUND_IMAGE) || optString.equals(optString2)) {
            return false;
        }
        return true;
    }

    public static boolean backgroundIsChanged(JSONObject jSONObject, JSONObject jSONObject2) {
        if (jSONObject2 != null && jSONObject2.has("backgroundColor")) {
            if (jSONObject == null) {
                if (!TextUtils.isEmpty(jSONObject2.optString("backgroundColor"))) {
                    return true;
                }
            } else if (jSONObject != null) {
                String optString = jSONObject.optString("backgroundColor");
                String optString2 = jSONObject2.optString("backgroundColor");
                if (!TextUtils.isEmpty(optString) || TextUtils.isEmpty(optString2)) {
                    return !TextUtils.isEmpty(optString) && !TextUtils.isEmpty(optString2) && !optString.equals(optString2);
                }
                return true;
            }
        }
    }

    public static int changeColorAlpha(int i, float f) {
        if (0.0f > f || f > 1.0f) {
            return -1;
        }
        return Color.argb((int) (f * 255.0f), Color.red(i), Color.green(i), Color.blue(i));
    }

    private static boolean checkKeyValueIsModify(String str, JSONObject jSONObject, JSONObject jSONObject2) {
        if (!jSONObject2.has(str)) {
            return false;
        }
        if (jSONObject == null || !jSONObject.has(str)) {
            return true;
        }
        return !jSONObject.optString(str).equals(jSONObject2.optString(str));
    }

    public static String color2Color(String str, String str2, float f) {
        try {
            if (TextUtils.isEmpty(str) || TextUtils.isEmpty(str2) || 0.0f > f || f > 1.0f) {
                return null;
            }
            if (str.startsWith("#") && str2.startsWith("#")) {
                String substring = str.substring(1, str.length());
                String substring2 = str2.substring(1, str2.length());
                if (substring.length() == 3) {
                    str = "#" + substring.charAt(0) + substring.charAt(0) + substring.charAt(1) + substring.charAt(1) + substring.charAt(2) + substring.charAt(2);
                }
                if (substring2.length() == 3) {
                    str2 = "#" + substring2.charAt(0) + substring2.charAt(0) + substring2.charAt(1) + substring2.charAt(1) + substring2.charAt(2) + substring2.charAt(2);
                }
                int parseColor = Color.parseColor(str);
                int red = Color.red(parseColor);
                int green = Color.green(parseColor);
                int blue = Color.blue(parseColor);
                int parseColor2 = Color.parseColor(str2);
                int red2 = Color.red(parseColor2);
                int green2 = Color.green(parseColor2);
                int blue2 = Color.blue(parseColor2);
                String hexString = Integer.toHexString(Color.alpha(parseColor));
                if (1 == hexString.length()) {
                    hexString = WXInstanceApm.VALUE_ERROR_CODE_DEFAULT + hexString;
                }
                float f2 = (float) red;
                if (red != red2) {
                    f2 = red > red2 ? f2 - (((float) (red - red2)) * f) : f2 + (((float) (red - red2)) * f);
                }
                String hexString2 = Integer.toHexString((int) f2);
                if (1 == hexString2.length()) {
                    hexString2 = WXInstanceApm.VALUE_ERROR_CODE_DEFAULT + hexString2;
                }
                float f3 = (float) green;
                if (green != green2) {
                    f3 = green > green2 ? f3 - (((float) (green - green2)) * f) : f3 + (((float) (green2 - green)) * f);
                }
                String hexString3 = Integer.toHexString((int) f3);
                if (1 == hexString3.length()) {
                    hexString3 = WXInstanceApm.VALUE_ERROR_CODE_DEFAULT + hexString3;
                }
                float f4 = (float) blue;
                if (blue != blue2) {
                    f4 = blue > blue2 ? f4 - (((float) (blue - blue2)) * f) : f4 + (((float) (blue2 - blue)) * f);
                }
                String hexString4 = Integer.toHexString((int) f4);
                if (1 == hexString4.length()) {
                    hexString4 = WXInstanceApm.VALUE_ERROR_CODE_DEFAULT + hexString4;
                }
                return "#" + hexString + hexString2 + hexString3 + hexString4;
            } else if (!str.startsWith("rgba") || !str.contains(Operators.BRACKET_START_STR) || !str.contains(Operators.BRACKET_END_STR) || !str.contains(",") || !str2.startsWith("rgba") || !str2.contains(Operators.BRACKET_START_STR) || !str2.contains(Operators.BRACKET_END_STR) || !str2.contains(",")) {
                return null;
            } else {
                String substring3 = str.substring(str.indexOf(Operators.BRACKET_START_STR) + 1, str.indexOf(Operators.BRACKET_END_STR));
                String substring4 = str2.substring(str2.indexOf(Operators.BRACKET_START_STR) + 1, str2.indexOf(Operators.BRACKET_END_STR));
                String[] stringSplit = PdrUtil.stringSplit(substring3, ",");
                String[] stringSplit2 = PdrUtil.stringSplit(substring4, ",");
                if (stringSplit == null || 4 != stringSplit.length || stringSplit2 == null || 4 != stringSplit2.length) {
                    return null;
                }
                int intValue = Integer.valueOf(stringSplit[0]).intValue();
                int intValue2 = Integer.valueOf(stringSplit[1]).intValue();
                int intValue3 = Integer.valueOf(stringSplit[2]).intValue();
                int intValue4 = Integer.valueOf(stringSplit2[0]).intValue();
                int intValue5 = Integer.valueOf(stringSplit2[1]).intValue();
                int intValue6 = Integer.valueOf(stringSplit2[2]).intValue();
                String str3 = stringSplit[3];
                float f5 = (float) intValue;
                if (intValue != intValue4) {
                    f5 = intValue > intValue4 ? f5 - (((float) (intValue - intValue4)) * f) : f5 + (((float) (intValue - intValue4)) * f);
                }
                float f6 = (float) intValue2;
                if (intValue2 != intValue5) {
                    f6 = intValue2 > intValue5 ? f6 - (((float) (intValue2 - intValue5)) * f) : f6 + (((float) (intValue5 - intValue2)) * f);
                }
                float f7 = (float) intValue3;
                if (intValue3 != intValue6) {
                    f7 = intValue3 > intValue6 ? f7 - (((float) (intValue3 - intValue6)) * f) : f7 + (((float) (intValue6 - intValue3)) * f);
                }
                return "rgba(" + ((int) f5) + "," + ((int) f6) + "," + ((int) f7) + "," + str3 + Operators.BRACKET_END_STR;
            }
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean compareColor(String str, String str2) {
        try {
            if (!TextUtils.isEmpty(str) && !TextUtils.isEmpty(str2)) {
                if (str.startsWith("#") && str2.startsWith("#")) {
                    String substring = str.substring(1, str.length());
                    String substring2 = str2.substring(1, str2.length());
                    if (substring.length() == 3) {
                        str = "#" + substring.charAt(0) + substring.charAt(0) + substring.charAt(1) + substring.charAt(1) + substring.charAt(2) + substring.charAt(2);
                    }
                    if (substring2.length() == 3) {
                        str2 = "#" + substring2.charAt(0) + substring2.charAt(0) + substring2.charAt(1) + substring2.charAt(1) + substring2.charAt(2) + substring2.charAt(2);
                    }
                    int parseColor = Color.parseColor(str);
                    int parseColor2 = Color.parseColor(str2);
                    if (Color.rgb(Color.red(parseColor), Color.green(parseColor), Color.blue(parseColor)) == Color.rgb(Color.red(parseColor2), Color.green(parseColor2), Color.blue(parseColor2))) {
                        return true;
                    }
                    return false;
                } else if (str.startsWith("rgba") && str.contains(Operators.BRACKET_START_STR) && str.contains(Operators.BRACKET_END_STR) && str.contains(",") && str2.startsWith("rgba") && str2.contains(Operators.BRACKET_START_STR) && str2.contains(Operators.BRACKET_END_STR) && str2.contains(",")) {
                    String substring3 = str.substring(str.indexOf(Operators.BRACKET_START_STR) + 1, str.indexOf(Operators.BRACKET_END_STR));
                    String substring4 = str2.substring(str2.indexOf(Operators.BRACKET_START_STR) + 1, str2.indexOf(Operators.BRACKET_END_STR));
                    String[] stringSplit = PdrUtil.stringSplit(substring3, ",");
                    String[] stringSplit2 = PdrUtil.stringSplit(substring4, ",");
                    if (stringSplit != null && 4 == stringSplit.length && stringSplit2 != null && 4 == stringSplit2.length && Color.rgb(Integer.valueOf(stringSplit[0]).intValue(), Integer.valueOf(stringSplit[1]).intValue(), Integer.valueOf(stringSplit[2]).intValue()) == Color.rgb(Integer.valueOf(stringSplit2[0]).intValue(), Integer.valueOf(stringSplit2[1]).intValue(), Integer.valueOf(stringSplit2[2]).intValue())) {
                        return true;
                    }
                    return false;
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static void drawTitle(IFrameView iFrameView, final ITitleNView iTitleNView, final String str, final String str2, final String str3, final String str4, final String str5, final String str6, final String str7, final String str8, final String str9, final String str10, final String str11, final String str12) {
        if (iFrameView != null && iTitleNView != null) {
            if (!BaseInfo.sDoingAnimation) {
                iTitleNView.setTitle(str, str2, str3, str4, str5, str6, str7, str8, str9, str10, str11, str12);
            } else if (iFrameView.obtainWebView().obtainFrameView() instanceof AdaFrameView) {
                ((AdaFrameView) iFrameView.obtainWebView().obtainFrameView()).obtainWindowMgr().processEvent(IMgr.MgrType.WindowMgr, 71, new l.m() {
                    /* class io.dcloud.common.util.TitleNViewUtil.AnonymousClass1 */

                    @Override // io.dcloud.common.core.ui.l.m
                    public void onAnimationEnd() {
                        ITitleNView.this.setTitle(str, str2, str3, str4, str5, str6, str7, str8, str9, str10, str11, str12);
                    }
                });
            }
        }
    }

    private static int getColorAlpha(String str) {
        int i;
        try {
            i = Color.parseColor(str);
        } catch (Exception unused) {
            i = PdrUtil.stringToColor(str);
        }
        return Color.alpha(i);
    }

    public static Object getTitleNView(AbsMgr absMgr, IWebview iWebview, IFrameView iFrameView, String str) {
        if (absMgr == null || iWebview == null || iFrameView == null || TextUtils.isEmpty(str)) {
            return null;
        }
        return absMgr.processEvent(IMgr.MgrType.FeatureMgr, 10, new Object[]{iWebview, "nativeobj", "getNativeView", new Object[]{iFrameView, str}});
    }

    public static String getTitleNViewId(IFrameView iFrameView) {
        if (iFrameView == null || iFrameView.obtainWebView() == null || iFrameView.obtainWebView().obtainWindowView() == null) {
            return null;
        }
        if (2 == iFrameView.getFrameType() || 4 == iFrameView.getFrameType() || 5 == iFrameView.getFrameType()) {
            return String.valueOf(iFrameView.obtainWebView().obtainWindowView().hashCode());
        }
        return iFrameView.obtainWebView().getWebviewUUID();
    }

    public static String getTitleNViewSearchInputText(ITitleNView iTitleNView) {
        return iTitleNView.getTitleNViewSearchInputText();
    }

    public static String intColor2String(int i, boolean z) {
        StringBuilder sb = new StringBuilder();
        String hexString = Integer.toHexString(Color.alpha(i));
        String hexString2 = Integer.toHexString(Color.red(i));
        String hexString3 = Integer.toHexString(Color.green(i));
        String hexString4 = Integer.toHexString(Color.blue(i));
        if (hexString.length() == 1) {
            hexString = WXInstanceApm.VALUE_ERROR_CODE_DEFAULT + hexString;
        }
        if (hexString2.length() == 1) {
            hexString2 = WXInstanceApm.VALUE_ERROR_CODE_DEFAULT + hexString2;
        }
        if (hexString3.length() == 1) {
            hexString3 = WXInstanceApm.VALUE_ERROR_CODE_DEFAULT + hexString3;
        }
        if (hexString4.length() == 1) {
            hexString4 = WXInstanceApm.VALUE_ERROR_CODE_DEFAULT + hexString4;
        }
        sb.append("#");
        if (z) {
            sb.append(hexString);
        }
        sb.append(hexString2);
        sb.append(hexString3);
        sb.append(hexString4);
        return sb.toString();
    }

    public static boolean isButtonsIsChanged(JSONObject jSONObject, JSONObject jSONObject2) {
        return jSONObject2.has("buttons");
    }

    public static boolean isSearchInputChange(JSONObject jSONObject, JSONObject jSONObject2) {
        if (jSONObject2 != null && jSONObject2.has("searchInput")) {
            JSONObject jSONObject3 = null;
            if (jSONObject != null) {
                jSONObject3 = jSONObject.optJSONObject("searchInput");
            }
            JSONObject optJSONObject = jSONObject2.optJSONObject("searchInput");
            if (jSONObject3 == null && optJSONObject != null) {
                return true;
            }
            if (jSONObject3 != null && optJSONObject == null) {
                return true;
            }
            if (jSONObject3 == null || optJSONObject.length() <= 0 || (jSONObject3.optString(AbsoluteConst.JSON_KEY_ALIGN).equalsIgnoreCase(optJSONObject.optString(AbsoluteConst.JSON_KEY_ALIGN)) && jSONObject3.optString("backgroundColor").equalsIgnoreCase(optJSONObject.optString("backgroundColor")) && jSONObject3.optString(Constants.Name.BORDER_RADIUS).equalsIgnoreCase(optJSONObject.optString(Constants.Name.BORDER_RADIUS)) && jSONObject3.optString(Constants.Name.PLACEHOLDER).equalsIgnoreCase(optJSONObject.optString(Constants.Name.PLACEHOLDER)) && jSONObject3.optString(Constants.Name.PLACEHOLDER_COLOR).equalsIgnoreCase(optJSONObject.optString(Constants.Name.PLACEHOLDER_COLOR)) && jSONObject3.optString("color").equalsIgnoreCase(optJSONObject.optString("color")) && jSONObject3.optBoolean(Constants.Name.DISABLED) != optJSONObject.optBoolean(Constants.Name.DISABLED) && jSONObject3.optBoolean("autoFocus") != optJSONObject.optBoolean("autoFocus"))) {
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isShadowChanged(JSONObject jSONObject, JSONObject jSONObject2) {
        JSONObject optJSONObject;
        if (jSONObject2 == null || !jSONObject2.has("shadow")) {
            return false;
        }
        JSONObject optJSONObject2 = jSONObject2.optJSONObject("shadow");
        if (jSONObject == null && optJSONObject2 != null && optJSONObject2.has("color")) {
            return true;
        }
        if (jSONObject == null) {
            return false;
        }
        if (!jSONObject.has("shadow")) {
            if (optJSONObject2 != null) {
                return !TextUtils.isEmpty(optJSONObject2.optString("color"));
            }
            return false;
        } else if (!jSONObject.has("shadow") || (optJSONObject = jSONObject.optJSONObject("shadow")) == null || optJSONObject2 == null || optJSONObject2.optString("color").equals(optJSONObject.optString("color"))) {
            return false;
        } else {
            return true;
        }
    }

    public static boolean isTitleTypeForDef(JSONObject jSONObject) {
        if (jSONObject != null) {
            return !jSONObject.has("type") || "default".equals(jSONObject.opt("type"));
        }
        return false;
    }

    private void jsonCompare(JSONObject jSONObject, JSONObject jSONObject2) {
        jSONObject.keys();
    }

    public static boolean paddingIsChanged(JSONObject jSONObject, JSONObject jSONObject2) {
        if (jSONObject2.has("padding")) {
            return checkKeyValueIsModify("padding", jSONObject, jSONObject2);
        }
        if (jSONObject2.has(Constants.Name.PADDING_RIGHT)) {
            return checkKeyValueIsModify(Constants.Name.PADDING_RIGHT, jSONObject, jSONObject2);
        }
        if (jSONObject2.has(Constants.Name.PADDING_LEFT)) {
            return checkKeyValueIsModify(Constants.Name.PADDING_LEFT, jSONObject, jSONObject2);
        }
        if (jSONObject2.has(AbsoluteConst.JSON_KEY_PADDING_LEFT)) {
            return checkKeyValueIsModify(AbsoluteConst.JSON_KEY_PADDING_LEFT, jSONObject, jSONObject2);
        }
        if (jSONObject2.has(AbsoluteConst.JSON_KEY_PADDING_RIGHT)) {
            return checkKeyValueIsModify(AbsoluteConst.JSON_KEY_PADDING_RIGHT, jSONObject, jSONObject2);
        }
        return false;
    }

    public static boolean progressIsChanged(JSONObject jSONObject, JSONObject jSONObject2) {
        if (!(jSONObject2 == null || !jSONObject2.has("progress") || jSONObject == null)) {
            if (jSONObject.has("progress") || !jSONObject2.has("progress")) {
                if (jSONObject.has("progress") && jSONObject2.has("progress")) {
                    if ((jSONObject.optJSONObject("progress") == null || Constants.Name.UNDEFINED.equals(jSONObject.optString("progress"))) && jSONObject2.optJSONObject("progress") != null && !Constants.Name.UNDEFINED.equals(jSONObject2.optString("progress"))) {
                        return true;
                    }
                    if (jSONObject.optJSONObject("progress") != null && !Constants.Name.UNDEFINED.equals(jSONObject.optString("progress")) && (jSONObject2.optJSONObject("progress") == null || Constants.Name.UNDEFINED.equals(jSONObject2.optString("progress")))) {
                        return true;
                    }
                    if (jSONObject.optJSONObject("progress") != null && !Constants.Name.UNDEFINED.equals(jSONObject.optString("progress"))) {
                        if ((!Constants.Name.UNDEFINED.equals(jSONObject2.optString("progress"))) && (jSONObject2.optJSONObject("progress") != null)) {
                            String optString = jSONObject.optString("height");
                            String optString2 = jSONObject.optString("color");
                            String optString3 = jSONObject2.optString("height");
                            String optString4 = jSONObject2.optString("color");
                            if (!optString.equals(optString3) || !optString2.equals(optString4)) {
                                return true;
                            }
                        }
                    }
                }
            } else if (jSONObject2.optJSONObject("progress") == null || !Constants.Name.UNDEFINED.equals(jSONObject2.optString("progress"))) {
                return false;
            } else {
                return true;
            }
        }
        return false;
    }

    public static boolean redDotChange(JSONObject jSONObject, JSONObject jSONObject2) {
        if (jSONObject2 != null && jSONObject2.has("redDotColor")) {
            if (jSONObject == null) {
                if (!TextUtils.isEmpty(jSONObject2.optString("redDotColor"))) {
                    return true;
                }
            } else if (jSONObject != null) {
                String optString = jSONObject.optString("redDotColor");
                String optString2 = jSONObject2.optString("redDotColor");
                if (!TextUtils.isEmpty(optString) || TextUtils.isEmpty(optString2)) {
                    return !TextUtils.isEmpty(optString) && !TextUtils.isEmpty(optString2) && !optString.equals(optString2);
                }
                return true;
            }
        }
    }

    public static void setBackButton(ITitleNView iTitleNView, JSONObject jSONObject, int i) {
        String str;
        if (iTitleNView != null) {
            JSONObject jSONObject2 = null;
            if (!jSONObject.has("autoBackButton")) {
                iTitleNView.removeBackButton();
            } else if (jSONObject.optBoolean("autoBackButton")) {
                if (jSONObject.has("backButton") && jSONObject.optJSONObject("backButton") != null && !Constants.Name.UNDEFINED.equalsIgnoreCase(jSONObject.optString("backButton"))) {
                    jSONObject2 = jSONObject.optJSONObject("backButton");
                }
                String optString = jSONObject.optString("titlecolor");
                if (jSONObject2 == null || !jSONObject2.has("color")) {
                    if (TextUtils.isEmpty(optString)) {
                        optString = jSONObject.optString("titleColor");
                    }
                    if (!TextUtils.isEmpty(optString) && optString.startsWith("#") && optString.length() == 9) {
                        optString = "#" + optString.substring(3, optString.length());
                    }
                } else {
                    optString = jSONObject2.optString("color");
                }
                if (!TextUtils.isEmpty(optString) || optString.startsWith("#")) {
                    if (jSONObject2 == null || !jSONObject2.has("colorPressed")) {
                        str = changeColorAlpha(optString, 0.3f);
                    } else {
                        str = jSONObject2.optString("colorPressed");
                    }
                    iTitleNView.addBackButton(optString, str, jSONObject.optString("type"), jSONObject2);
                }
            } else {
                iTitleNView.removeBackButton();
            }
        }
    }

    public static void setBackgroundImage(ITitleNView iTitleNView, JSONObject jSONObject) {
        if (jSONObject != null) {
            iTitleNView.setBackgroundImage(jSONObject.optString(Constants.Name.BACKGROUND_IMAGE));
        }
    }

    /* JADX WARNING: Removed duplicated region for block: B:25:0x0091  */
    /* JADX WARNING: Removed duplicated region for block: B:26:0x00a3  */
    /* JADX WARNING: Removed duplicated region for block: B:36:0x00e9  */
    /* JADX WARNING: Removed duplicated region for block: B:41:0x0134  */
    public static void setButtons(ITitleNView iTitleNView, JSONObject jSONObject, IWebview iWebview) {
        String str;
        String str2;
        String str3;
        String str4;
        String str5;
        boolean z;
        String str6;
        boolean z2;
        String optString;
        if (iTitleNView != null && jSONObject.has("buttons")) {
            String optString2 = jSONObject.optString("titleColor");
            if (TextUtils.isEmpty(optString2)) {
                optString2 = jSONObject.optString("titlecolor");
            }
            String changeColorAlpha = changeColorAlpha(optString2, 1.0f);
            JSONArray optJSONArray = jSONObject.optJSONArray("buttons");
            String str7 = "type";
            String optString3 = jSONObject.optString(str7);
            if (optJSONArray != null) {
                int i = 0;
                while (i < optJSONArray.length()) {
                    JSONObject optJSONObject = optJSONArray.optJSONObject(i);
                    String optString4 = optJSONObject.optString(str7, "none");
                    String optString5 = optJSONObject.optString("color");
                    String optString6 = optJSONObject.optString("colorPressed");
                    String optString7 = optJSONObject.optString("width");
                    String optString8 = optJSONObject.optString("background", TRANSPARENT_BUTTON_BACKGROUND_COLOR);
                    if ("transparent".equals(optString3)) {
                        optString5 = TRANSPARENT_BUTTON_TEXT_COLOR;
                        optString6 = changeColorAlpha(optString5, 0.3f);
                    } else if (TextUtils.isEmpty(optString5)) {
                        str = changeColorAlpha(changeColorAlpha, 0.3f);
                        str2 = changeColorAlpha;
                        if (!optJSONObject.has("__cb__")) {
                            JSONObject optJSONObject2 = optJSONObject.optJSONObject("__cb__");
                            String optString9 = optJSONObject2.optString("id");
                            optJSONObject2.optString("htmlId");
                            str3 = optString9;
                        } else {
                            if (optJSONObject.has("onClick")) {
                                optString = optJSONObject.optString("onClick");
                            } else if (optJSONObject.has("onclick")) {
                                optString = optJSONObject.optString("onclick");
                            } else {
                                str3 = null;
                            }
                            str3 = optString;
                        }
                        if (!"left".equals(optJSONObject.optString("float"))) {
                            String optString10 = optJSONObject.optString("text");
                            String optString11 = optJSONObject.optString(AbsoluteConst.JSON_KEY_TITLE);
                            String optString12 = optJSONObject.optString(Constants.Name.FONT_WEIGHT);
                            String optString13 = optJSONObject.optString(Constants.Name.FONT_SIZE);
                            String optString14 = optJSONObject.optString("fontSrc");
                            boolean optBoolean = optJSONObject.optBoolean("redDot");
                            if (optJSONObject.has("badgeText")) {
                                str6 = optJSONObject.optString("badgeText");
                                z2 = false;
                            } else {
                                z2 = false;
                                str6 = null;
                            }
                            str4 = changeColorAlpha;
                            iTitleNView.addLeftButton(optString10, optString11, str2, str, optString12, optString13, optString14, optString4, optString7, str3, iWebview, optString3, optString8, optBoolean, str6, optJSONObject.optBoolean("select", z2), optJSONObject.optString(Constants.Name.MAX_WIDTH));
                        } else {
                            str4 = changeColorAlpha;
                            String optString15 = optJSONObject.optString("text");
                            String optString16 = optJSONObject.optString(AbsoluteConst.JSON_KEY_TITLE);
                            String optString17 = optJSONObject.optString(Constants.Name.FONT_WEIGHT);
                            String optString18 = optJSONObject.optString(Constants.Name.FONT_SIZE);
                            String optString19 = optJSONObject.optString("fontSrc");
                            boolean optBoolean2 = optJSONObject.optBoolean("redDot");
                            if (optJSONObject.has("badgeText")) {
                                str5 = optJSONObject.optString("badgeText");
                                z = false;
                            } else {
                                z = false;
                                str5 = null;
                            }
                            iTitleNView.addRightButton(optString15, optString16, str2, str, optString17, optString18, optString19, optString4, optString7, str3, iWebview, optString3, optString8, optBoolean2, str5, optJSONObject.optBoolean("select", z), optJSONObject.optString(Constants.Name.MAX_WIDTH));
                        }
                        i++;
                        optString3 = optString3;
                        str7 = str7;
                        optJSONArray = optJSONArray;
                        changeColorAlpha = str4;
                    } else if (TextUtils.isEmpty(optString6)) {
                        optString6 = changeColorAlpha(optString5, 0.3f);
                    }
                    str2 = optString5;
                    str = optString6;
                    if (!optJSONObject.has("__cb__")) {
                    }
                    if (!"left".equals(optJSONObject.optString("float"))) {
                    }
                    i++;
                    optString3 = optString3;
                    str7 = str7;
                    optJSONArray = optJSONArray;
                    changeColorAlpha = str4;
                }
            }
        }
    }

    public static void setCapsuleButtonStyle(ITitleNView iTitleNView, JSONObject jSONObject) {
        if (iTitleNView != null && jSONObject != null && jSONObject.has("capsuleButtonStyle")) {
            iTitleNView.setCapsuleButtonStyle(jSONObject.optJSONObject("capsuleButtonStyle"));
        }
    }

    public static void setHomeButton(ITitleNView iTitleNView, JSONObject jSONObject, int i) {
        if (iTitleNView != null) {
            boolean z = false;
            boolean z2 = true;
            if (i == 5) {
                z = true;
            }
            if (!jSONObject.has("homeButton") || !jSONObject.optBoolean("homeButton")) {
                z2 = z;
            }
            if (z2) {
                String optString = jSONObject.optString("titlecolor");
                if (TextUtils.isEmpty(optString)) {
                    optString = jSONObject.optString("titleColor");
                }
                if (!TextUtils.isEmpty(optString) && optString.startsWith("#") && optString.length() == 9) {
                    optString = "#" + optString.substring(3, optString.length());
                }
                if (!TextUtils.isEmpty(optString) || optString.startsWith("#")) {
                    iTitleNView.addHomeButton(optString, changeColorAlpha(optString, 0.3f), jSONObject.optString("type"));
                    return;
                }
                return;
            }
            iTitleNView.removeHomeButton();
        }
    }

    public static void setProgress(ITitleNView iTitleNView, JSONObject jSONObject) {
        if (iTitleNView == null || !jSONObject.has("progress")) {
            return;
        }
        if (jSONObject.optJSONObject("progress") == null || Constants.Name.UNDEFINED.equalsIgnoreCase(jSONObject.optString("progress"))) {
            iTitleNView.setProgress("", "");
            return;
        }
        JSONObject optJSONObject = jSONObject.optJSONObject("progress");
        String optString = optJSONObject.optString("height");
        if (!optJSONObject.has("height") || "".equals(optString)) {
            optString = "2px";
        }
        String optString2 = optJSONObject.optString("color");
        if (!optJSONObject.has("color") || "".equals(optString2)) {
            optString2 = "#00FF00";
        }
        iTitleNView.setProgress(optString, optString2);
    }

    public static void setRedDotColor(ITitleNView iTitleNView, JSONObject jSONObject) {
        if (jSONObject != null) {
            iTitleNView.setRedDotColor(PdrUtil.stringToColor(jSONObject.optString("redDotColor")));
        }
    }

    public static void setSearchInput(ITitleNView iTitleNView, JSONObject jSONObject, IWebview iWebview) {
        if (iTitleNView != null) {
            if (jSONObject.has("searchInput")) {
                JSONObject optJSONObject = jSONObject.optJSONObject("searchInput");
                iTitleNView.addSearchInput(optJSONObject.optString(AbsoluteConst.JSON_KEY_ALIGN), optJSONObject.optString("backgroundColor"), optJSONObject.optString(Constants.Name.BORDER_RADIUS, "0px"), optJSONObject.optString(Constants.Name.PLACEHOLDER), optJSONObject.optString(Constants.Name.PLACEHOLDER_COLOR, "#CCCCCC"), optJSONObject.optString("color", "#000000"), optJSONObject.optBoolean(Constants.Name.DISABLED, false), optJSONObject.optBoolean("autoFocus", false), iWebview);
                return;
            }
            iTitleNView.clearSearchInput();
        }
    }

    public static void setShadow(ITitleNView iTitleNView, JSONObject jSONObject) {
        if (iTitleNView != null) {
            JSONObject optJSONObject = jSONObject.optJSONObject("shadow");
            if (optJSONObject != null) {
                iTitleNView.setShadow(optJSONObject);
            } else {
                iTitleNView.setShadow(new JSONObject());
            }
        }
    }

    public static void setSplitLine(ITitleNView iTitleNView, IWebview iWebview, JSONObject jSONObject, JSONObject jSONObject2, boolean z, String str) {
        if (iTitleNView == null) {
            return;
        }
        if (jSONObject2 != null) {
            JSONObject combinJSONObject = JSONUtil.combinJSONObject(jSONObject, jSONObject2);
            String optString = combinJSONObject.optString("color");
            if ((combinJSONObject.has("color") && "".equals(optString)) || !combinJSONObject.has("color")) {
                optString = "#CCCCCC";
            }
            if (z && "transparent".equals(str)) {
                optString = changeColorAlpha(optString, 0.0f);
            }
            try {
                if ("transparent".equals(str) && iWebview.obtainWindowView().getScrollY() == 0) {
                    optString = changeColorAlpha(optString, 0.0f);
                }
            } catch (Exception unused) {
            }
            String optString2 = combinJSONObject.optString("height");
            if (!TextUtils.isEmpty(optString)) {
                if (TextUtils.isEmpty(optString2)) {
                    optString2 = "1px";
                }
                iTitleNView.setSplitLine(optString2, optString);
            }
        } else if (jSONObject != null) {
            iTitleNView.removeSplitLine();
        }
    }

    public static void setSubTitleIcon(ITitleNView iTitleNView, JSONObject jSONObject) {
        if (jSONObject != null) {
            String optString = jSONObject.optString("titleColor");
            if (TextUtils.isEmpty(optString)) {
                optString = jSONObject.optString("titlecolor");
            }
            iTitleNView.setIconSubTitleStyle(jSONObject.optString("titleIcon"), jSONObject.optString("titleIconRadius"), jSONObject.optString("subtitleText"), jSONObject.optString("subtitleColor"), jSONObject.optString("subtitleSize"), jSONObject.optString("subtitleOverflow"), optString, jSONObject.optString("titleAlign"), jSONObject.optString("titleIconWidth"));
        }
    }

    public static void setTitleAlign(ITitleNView iTitleNView, JSONObject jSONObject) {
        if (jSONObject != null) {
            iTitleNView.setTitleAlign(jSONObject.optString("titleAlign"));
        }
    }

    public static void setTitleNViewButtonStyle(ITitleNView iTitleNView, String str, JSONObject jSONObject, IFrameView iFrameView) {
        int i;
        String str2;
        JSONObject optJSONObject;
        String optString;
        try {
            i = Integer.parseInt(str);
        } catch (Exception unused) {
            i = -1;
        }
        if (jSONObject != null) {
            String str3 = "";
            String optString2 = jSONObject.optString("type", str3);
            String optString3 = jSONObject.optString("color");
            String optString4 = jSONObject.optString("colorPressed");
            String optString5 = jSONObject.optString("width");
            String optString6 = jSONObject.optString("background");
            if (!PdrUtil.isEmpty(optString3) && PdrUtil.isEmpty(optString4)) {
                optString4 = changeColorAlpha(optString3, 0.3f);
            }
            if (jSONObject.has("__cb__")) {
                JSONObject optJSONObject2 = jSONObject.optJSONObject("__cb__");
                String optString7 = optJSONObject2.optString("id");
                optJSONObject2.optString("htmlId");
                str2 = optString7;
            } else {
                if (jSONObject.has("onClick")) {
                    optString = jSONObject.optString("onClick");
                } else if (jSONObject.has("onclick")) {
                    optString = jSONObject.optString("onclick");
                } else {
                    str2 = null;
                }
                str2 = optString;
            }
            AdaFrameItem adaFrameItem = (AdaFrameItem) iFrameView;
            JSONObject jSONObject2 = adaFrameItem.obtainFrameOptions().titleNView;
            JSONArray optJSONArray = jSONObject2.optJSONArray("buttons");
            if (optJSONArray != null && i < optJSONArray.length() && i >= 0 && (optJSONObject = optJSONArray.optJSONObject(i)) != null) {
                str3 = optJSONObject.optString("width");
            }
            if (iTitleNView.setTitleNViewButtonStyle(i, jSONObject.optString("text"), jSONObject.optString(AbsoluteConst.JSON_KEY_TITLE), optString3, optString4, jSONObject.optString(Constants.Name.FONT_WEIGHT), jSONObject.optString(Constants.Name.FONT_SIZE), jSONObject.optString("fontSrc"), optString2, str2, iFrameView.obtainWebView(), optString6, jSONObject.optString("redDot"), jSONObject.has("badgeText") ? jSONObject.optString("badgeText") : null, jSONObject.optString("select"), optString5, jSONObject2.optString("type"), jSONObject.optString(Constants.Name.MAX_WIDTH), str3) && optJSONArray != null && i < optJSONArray.length() && i >= 0) {
                JSONUtil.combinJSONObject(optJSONArray.optJSONObject(i), jSONObject);
                adaFrameItem.obtainFrameOptions().setTitleNView(jSONObject2, iFrameView.obtainWebView());
            }
        }
    }

    public static void setTitleNViewPadding(ITitleNView iTitleNView, IWebview iWebview, JSONObject jSONObject) {
        int i;
        int i2;
        if (jSONObject.has("padding")) {
            i = PdrUtil.convertToScreenInt(jSONObject.optString("padding"), 0, 0, iWebview.getScale());
            i2 = PdrUtil.convertToScreenInt(jSONObject.optString("padding"), 0, 0, iWebview.getScale());
        } else {
            i2 = 0;
            i = 0;
        }
        if (jSONObject.has(Constants.Name.PADDING_LEFT)) {
            i = PdrUtil.convertToScreenInt(jSONObject.optString(Constants.Name.PADDING_LEFT), 0, 0, iWebview.getScale());
        } else if (jSONObject.has(AbsoluteConst.JSON_KEY_PADDING_LEFT)) {
            i = PdrUtil.convertToScreenInt(jSONObject.optString(AbsoluteConst.JSON_KEY_PADDING_LEFT), 0, 0, iWebview.getScale());
        }
        if (jSONObject.has(Constants.Name.PADDING_RIGHT)) {
            i2 = PdrUtil.convertToScreenInt(jSONObject.optString(Constants.Name.PADDING_RIGHT), 0, 0, iWebview.getScale());
        } else if (jSONObject.has(AbsoluteConst.JSON_KEY_PADDING_RIGHT)) {
            i2 = PdrUtil.convertToScreenInt(jSONObject.optString(AbsoluteConst.JSON_KEY_PADDING_RIGHT), 0, 0, iWebview.getScale());
        }
        iTitleNView.setTitleNViewPadding(i, 0, i2, 0);
    }

    public static void setTitleNViewSearchInputFocus(ITitleNView iTitleNView, String str) {
        iTitleNView.setSearchInputFocus(Boolean.parseBoolean(str));
    }

    public static void setTitleNViewSearchInputText(ITitleNView iTitleNView, String str) {
        iTitleNView.setTitleNViewSearchInputText(str);
    }

    public static boolean splitLineIsChanged(JSONObject jSONObject, JSONObject jSONObject2) {
        if (jSONObject2 != null && jSONObject2.has("splitLine")) {
            JSONObject jSONObject3 = null;
            if (jSONObject != null) {
                jSONObject3 = jSONObject.optJSONObject("splitLine");
            }
            JSONObject optJSONObject = jSONObject2.optJSONObject("splitLine");
            if (jSONObject3 == null && optJSONObject != null) {
                return true;
            }
            if (jSONObject3 != null && optJSONObject == null) {
                return true;
            }
            if (!(jSONObject3 == null || optJSONObject == null)) {
                String optString = jSONObject3.optString("color");
                String optString2 = optJSONObject.optString("color");
                if (optString == null && optString2 != null) {
                    return true;
                }
                if (optString != null && optString2 != null && !optString.equals(optString2)) {
                    return true;
                }
                String optString3 = jSONObject3.optString("height");
                String optString4 = optJSONObject.optString("height");
                if (optString3 == null && optString4 != null) {
                    return true;
                }
                if (optString3 == null || optString4 == null || optString3.equals(optString4)) {
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public static void startProcess(ITitleNView iTitleNView) {
        if (iTitleNView != null) {
            iTitleNView.startProgress();
        }
    }

    public static void stopProcess(ITitleNView iTitleNView) {
        if (iTitleNView != null) {
            iTitleNView.stopProgress();
        }
    }

    public static boolean subTitleIconChanged(JSONObject jSONObject, JSONObject jSONObject2) {
        if (jSONObject2 == null) {
            return false;
        }
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        if (jSONObject2.optString("titleIcon").equals(jSONObject.optString("titleIcon")) && jSONObject2.optString("titleIconRadius").equals(jSONObject.optString("titleIconRadius")) && jSONObject2.optString("subtitleText").equals(jSONObject.optString("subtitleText")) && jSONObject2.optString("subtitleColor").equals(jSONObject.optString("subtitleColor")) && jSONObject2.optString("subtitleSize").equals(jSONObject.optString("subtitleSize")) && jSONObject2.optString("subtitleOverflow").equals(jSONObject.optString("subtitleOverflow"))) {
            return false;
        }
        return true;
    }

    public static boolean titleAlignIsChanged(JSONObject jSONObject, JSONObject jSONObject2) {
        if (jSONObject2 != null && jSONObject2.has("titleAlign")) {
            if (jSONObject == null) {
                return !TextUtils.isEmpty(jSONObject2.optString("titleAlign"));
            }
            String optString = jSONObject.optString("titleAlign");
            String optString2 = jSONObject2.optString("titleAlign");
            if (!TextUtils.isEmpty(optString) || TextUtils.isEmpty(optString2)) {
                return !TextUtils.isEmpty(optString) && !TextUtils.isEmpty(optString2) && !optString.equals(optString2);
            }
            return true;
        }
    }

    /* JADX WARNING: Removed duplicated region for block: B:78:0x00f7 A[RETURN] */
    public static boolean titleColorIsChanged(JSONObject jSONObject, JSONObject jSONObject2) {
        if (jSONObject2 != null && (jSONObject2.has("titleColor") || jSONObject2.has("titlecolor"))) {
            if (jSONObject == null && ((jSONObject2.has("titleColor") && !TextUtils.isEmpty(jSONObject2.optString("titleColor"))) || (jSONObject2.has("titlecolor") && !TextUtils.isEmpty(jSONObject2.optString("titlecolor"))))) {
                return true;
            }
            if (jSONObject != null) {
                if (jSONObject.has("titleColor")) {
                    String optString = jSONObject.optString("titleColor");
                    if (jSONObject2.has("titleColor")) {
                        String optString2 = jSONObject2.optString("titleColor");
                        if (!TextUtils.isEmpty(optString) || TextUtils.isEmpty(optString2)) {
                            return !TextUtils.isEmpty(optString) && !TextUtils.isEmpty(optString2) && !optString.equals(optString2);
                        }
                        return true;
                    } else if (jSONObject2.has("titlecolor")) {
                        String optString3 = jSONObject2.optString("titlecolor");
                        if (TextUtils.isEmpty(optString) && !TextUtils.isEmpty(optString3)) {
                            return true;
                        }
                        if (!TextUtils.isEmpty(optString) && !TextUtils.isEmpty(optString3) && !optString.equals(optString3)) {
                            return true;
                        }
                    }
                } else if (jSONObject.has("titlecolor")) {
                    String optString4 = jSONObject.optString("titlecolor");
                    if (jSONObject2.has("titleColor")) {
                        String optString5 = jSONObject2.optString("titleColor");
                        if (TextUtils.isEmpty(optString4) && !TextUtils.isEmpty(optString5)) {
                            return true;
                        }
                        if (!TextUtils.isEmpty(optString4) && !TextUtils.isEmpty(optString5) && !optString4.equals(optString5)) {
                            return true;
                        }
                    } else if (jSONObject2.has("titlecolor")) {
                        String optString6 = jSONObject2.optString("titlecolor");
                        if (TextUtils.isEmpty(optString4) && !TextUtils.isEmpty(optString6)) {
                            return true;
                        }
                        if (!TextUtils.isEmpty(optString4) && !TextUtils.isEmpty(optString6) && !optString4.equals(optString6)) {
                            return true;
                        }
                    }
                }
            }
        }
    }

    public static boolean titleIsChanged(JSONObject jSONObject, JSONObject jSONObject2) {
        if (jSONObject2 != null && (jSONObject2.has("titleText") || jSONObject2.has("titletext"))) {
            if (jSONObject == null && ((jSONObject2.has("titleText") && !TextUtils.isEmpty(jSONObject2.optString("titleText"))) || (jSONObject2.has("titletext") && !TextUtils.isEmpty(jSONObject2.optString("titletext"))))) {
                return true;
            }
            if (jSONObject != null) {
                if (jSONObject.has("titleText")) {
                    String optString = jSONObject.optString("titleText");
                    if (jSONObject2.has("titleText")) {
                        String optString2 = jSONObject2.optString("titleText");
                        if ((!TextUtils.isEmpty(optString) || TextUtils.isEmpty(optString2)) && !TextUtils.isEmpty(optString) && !TextUtils.isEmpty(optString2) && !optString.equals(optString2)) {
                            return true;
                        }
                    } else if (jSONObject2.has("titletext")) {
                        String optString3 = jSONObject2.optString("titletext");
                        if ((!TextUtils.isEmpty(optString) || TextUtils.isEmpty(optString3)) && !TextUtils.isEmpty(optString) && !TextUtils.isEmpty(optString3) && !optString.equals(optString3)) {
                            return true;
                        }
                    }
                } else if (jSONObject.has("titletext")) {
                    String optString4 = jSONObject.optString("titletext");
                    if (jSONObject2.has("titleText")) {
                        String optString5 = jSONObject2.optString("titleText");
                        if ((!TextUtils.isEmpty(optString4) || TextUtils.isEmpty(optString5)) && !TextUtils.isEmpty(optString4) && !TextUtils.isEmpty(optString5) && !optString4.equals(optString5)) {
                            return true;
                        }
                    } else if (jSONObject2.has("titletext")) {
                        String optString6 = jSONObject2.optString("titletext");
                        if ((!TextUtils.isEmpty(optString4) || TextUtils.isEmpty(optString6)) && !TextUtils.isEmpty(optString4) && !TextUtils.isEmpty(optString6) && !optString4.equals(optString6)) {
                        }
                    }
                }
                return true;
            }
        }
        return false;
    }

    public static void titleNViewButtonBadge(ITitleNView iTitleNView, JSONObject jSONObject, boolean z) {
        iTitleNView.setBadgeText(jSONObject, z);
    }

    public static void titleNViewButtonRedDot(ITitleNView iTitleNView, JSONObject jSONObject, boolean z) {
        iTitleNView.setRedDot(jSONObject, z);
    }

    public static boolean titleNViewStyleNoTitle(JSONObject jSONObject) {
        if (jSONObject == null) {
            return true;
        }
        if (!jSONObject.has("titleText") && !jSONObject.has("titletext")) {
            return true;
        }
        if (jSONObject.has("titleText")) {
            if (TextUtils.isEmpty(jSONObject.optString("titleText"))) {
                return true;
            }
            return false;
        } else if (!jSONObject.has("titletext") || !TextUtils.isEmpty(jSONObject.optString("titletext"))) {
            return false;
        } else {
            return true;
        }
    }

    /* JADX WARNING: Removed duplicated region for block: B:35:0x006d A[RETURN] */
    public static boolean titleOverflowIsChanged(JSONObject jSONObject, JSONObject jSONObject2) {
        if (jSONObject2 != null && jSONObject2.has("titleOverflow")) {
            if (jSONObject == null && jSONObject2.has("titleOverflow") && !TextUtils.isEmpty(jSONObject2.optString("titleOverflow"))) {
                return true;
            }
            if (jSONObject != null) {
                if (!jSONObject.has("titleOverflow")) {
                    return jSONObject2.has("titleOverflow") && !TextUtils.isEmpty(jSONObject2.optString("titleOverflow"));
                }
                if (jSONObject.has("titleOverflow")) {
                    String optString = jSONObject.optString("titleOverflow");
                    if (jSONObject2.has("titleOverflow")) {
                        String optString2 = jSONObject2.optString("titleOverflow");
                        if (TextUtils.isEmpty(optString) && !TextUtils.isEmpty(optString2)) {
                            return true;
                        }
                        if (!TextUtils.isEmpty(optString) && !TextUtils.isEmpty(optString2) && !optString.equals(optString2)) {
                            return true;
                        }
                    }
                }
            }
        }
    }

    /* JADX WARNING: Removed duplicated region for block: B:78:0x00f7 A[RETURN] */
    public static boolean titleSizeIsChanged(JSONObject jSONObject, JSONObject jSONObject2) {
        if (jSONObject2 != null && (jSONObject2.has("titleSize") || jSONObject2.has("titlesize"))) {
            if (jSONObject == null && ((jSONObject2.has("titleSize") && !TextUtils.isEmpty(jSONObject2.optString("titleSize"))) || (jSONObject2.has("titlesize") && !TextUtils.isEmpty(jSONObject2.optString("titlesize"))))) {
                return true;
            }
            if (jSONObject != null) {
                if (jSONObject.has("titleSize")) {
                    String optString = jSONObject.optString("titleSize");
                    if (jSONObject2.has("titleSize")) {
                        String optString2 = jSONObject2.optString("titleSize");
                        if (!TextUtils.isEmpty(optString) || TextUtils.isEmpty(optString2)) {
                            return !TextUtils.isEmpty(optString) && !TextUtils.isEmpty(optString2) && !optString.equals(optString2);
                        }
                        return true;
                    } else if (jSONObject2.has("titlesize")) {
                        String optString3 = jSONObject2.optString("titlesize");
                        if (TextUtils.isEmpty(optString) && !TextUtils.isEmpty(optString3)) {
                            return true;
                        }
                        if (!TextUtils.isEmpty(optString) && !TextUtils.isEmpty(optString3) && !optString.equals(optString3)) {
                            return true;
                        }
                    }
                } else if (jSONObject.has("titlesize")) {
                    String optString4 = jSONObject.optString("titlesize");
                    if (jSONObject2.has("titleSize")) {
                        String optString5 = jSONObject2.optString("titleSize");
                        if (TextUtils.isEmpty(optString4) && !TextUtils.isEmpty(optString5)) {
                            return true;
                        }
                        if (!TextUtils.isEmpty(optString4) && !TextUtils.isEmpty(optString5) && !optString4.equals(optString5)) {
                            return true;
                        }
                    } else if (jSONObject2.has("titlesize")) {
                        String optString6 = jSONObject2.optString("titlesize");
                        if (TextUtils.isEmpty(optString4) && !TextUtils.isEmpty(optString6)) {
                            return true;
                        }
                        if (!TextUtils.isEmpty(optString4) && !TextUtils.isEmpty(optString6) && !optString4.equals(optString6)) {
                            return true;
                        }
                    }
                }
            }
        }
    }

    /* JADX WARNING: Removed duplicated region for block: B:163:? A[RETURN, SYNTHETIC] */
    /* JADX WARNING: Removed duplicated region for block: B:23:0x0074  */
    /* JADX WARNING: Removed duplicated region for block: B:26:0x007e  */
    /* JADX WARNING: Removed duplicated region for block: B:27:0x0090  */
    /* JADX WARNING: Removed duplicated region for block: B:41:0x00cf  */
    /* JADX WARNING: Removed duplicated region for block: B:47:0x00df A[SYNTHETIC, Splitter:B:47:0x00df] */
    /* JADX WARNING: Removed duplicated region for block: B:53:0x00f5  */
    /* JADX WARNING: Removed duplicated region for block: B:56:0x0107  */
    /* JADX WARNING: Removed duplicated region for block: B:71:0x0158  */
    /* JADX WARNING: Removed duplicated region for block: B:88:0x01b0  */
    public static void updateTitleNViewStatus(ITitleNView iTitleNView, IWebview iWebview, float f, JSONObject jSONObject, float f2) {
        int titleColor;
        JSONObject optJSONObject;
        String str;
        int i;
        String str2;
        String str3;
        int i2;
        float f3;
        String str4;
        String str5;
        int i3;
        String str6;
        String str7;
        JSONArray optJSONArray;
        int i4;
        String optString;
        if (iTitleNView != null) {
            try {
                String optString2 = jSONObject.optString("backgroundColor");
                JSONObject jSONObject2 = new JSONObject(iTitleNView.getStatusBarColor());
                int optInt = jSONObject2.optInt("color");
                boolean optBoolean = jSONObject2.optBoolean("alpha");
                String optString3 = jSONObject.optString("titleColor");
                if (jSONObject.has("titleColor")) {
                    optString = jSONObject.optString("titleColor");
                } else {
                    if (jSONObject.has("titlecolor")) {
                        optString = jSONObject.optString("titlecolor");
                    }
                    titleColor = iTitleNView.getTitleColor();
                    optJSONObject = jSONObject.optJSONObject("splitLine");
                    String str8 = null;
                    if (optJSONObject != null || Constants.Name.UNDEFINED.equals(optJSONObject)) {
                        str = null;
                    } else {
                        str = optJSONObject.optString("color");
                        if (!optJSONObject.has("color") || "".equals(str)) {
                            str = "#CCCCCC";
                        }
                    }
                    if (!TextUtils.isEmpty(str)) {
                        str8 = str;
                    }
                    i = (f > 0.0f ? 1 : (f == 0.0f ? 0 : -1));
                    if (i != 0) {
                        String changeColorAlpha = changeColorAlpha(optString2, 0.0f);
                        optInt = changeColorAlpha(optInt, 0.0f);
                        i4 = changeColorAlpha(titleColor, 0.0f);
                        str3 = changeColorAlpha(str, 0.0f);
                        str2 = changeColorAlpha;
                    } else {
                        float f4 = f / f2;
                        if (f4 >= 1.0f) {
                            i4 = changeColorAlpha(titleColor, 1.0f);
                            str3 = changeColorAlpha(str, 1.0f);
                            str2 = optString2;
                        } else {
                            str2 = ((float) getColorAlpha(optString2)) / 255.0f > f4 ? changeColorAlpha(optString2, f4) : optString2;
                            if (((float) Color.alpha(optInt)) / 255.0f > f4 || optBoolean) {
                                optInt = changeColorAlpha(optInt, f4);
                            }
                            i2 = changeColorAlpha(titleColor, f4);
                            str3 = changeColorAlpha(str, f4);
                            if (titleColor != i2) {
                                iTitleNView.setTitleColor(i2);
                            }
                            iTitleNView.setStatusBarColor(optInt);
                            if (str8 != null && !str8.equalsIgnoreCase(str3)) {
                                if (optJSONObject != null) {
                                    try {
                                        optJSONObject.put("color", str3);
                                    } catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                                setSplitLine(iTitleNView, iWebview, optJSONObject, optJSONObject, false, "");
                            }
                            if (optString2 != null) {
                                iTitleNView.setBackgroundColor(str2);
                            }
                            if (i == 0) {
                                JSONObject optJSONObject2 = jSONObject.optJSONObject("backButton");
                                iTitleNView.setBackButtonColor((optJSONObject2 == null || !optJSONObject2.has("background")) ? TRANSPARENT_BUTTON_BACKGROUND_COLOR : optJSONObject2.optString("background"), changeColorAlpha(TRANSPARENT_BUTTON_TEXT_COLOR, 1.0f), changeColorAlpha(TRANSPARENT_BUTTON_TEXT_COLOR, 0.3f));
                                iTitleNView.setHomeButtonColor(TRANSPARENT_BUTTON_BACKGROUND_COLOR, changeColorAlpha(TRANSPARENT_BUTTON_TEXT_COLOR, 1.0f), changeColorAlpha(TRANSPARENT_BUTTON_TEXT_COLOR, 0.3f));
                                JSONArray optJSONArray2 = jSONObject.optJSONArray("buttons");
                                if (optJSONArray2 != null) {
                                    for (int i5 = 0; i5 < optJSONArray2.length(); i5++) {
                                        JSONObject optJSONObject3 = optJSONArray2.optJSONObject(i5);
                                        if (optJSONObject3 != null) {
                                            iTitleNView.setButtonColorByIndex(i5, optJSONObject3.optString("background", TRANSPARENT_BUTTON_BACKGROUND_COLOR), changeColorAlpha(TRANSPARENT_BUTTON_TEXT_COLOR, 1.0f), changeColorAlpha(TRANSPARENT_BUTTON_TEXT_COLOR, 0.3f));
                                        }
                                    }
                                    return;
                                }
                                return;
                            } else if (f2 <= f) {
                                String changeColorAlpha2 = changeColorAlpha(optString3, 1.0f);
                                JSONObject optJSONObject4 = jSONObject.optJSONObject("backButton");
                                String changeColorAlpha3 = changeColorAlpha(changeColorAlpha2, 0.3f);
                                if (optJSONObject4 != null && (optJSONObject4.has("color") || optJSONObject4.has("colorPressed"))) {
                                    str6 = optJSONObject4.optString("color");
                                    str7 = optJSONObject4.optString("colorPressed");
                                    if (TextUtils.isEmpty(str6)) {
                                        changeColorAlpha3 = changeColorAlpha(changeColorAlpha2, 0.3f);
                                    } else {
                                        if (TextUtils.isEmpty(str7)) {
                                            str7 = changeColorAlpha(str6, 0.3f);
                                        }
                                        iTitleNView.setBackButtonColor("#00333333", str6, str7);
                                        iTitleNView.setHomeButtonColor("#00333333", changeColorAlpha(changeColorAlpha2, 1.0f), changeColorAlpha(changeColorAlpha2, 0.3f));
                                        optJSONArray = jSONObject.optJSONArray("buttons");
                                        if (optJSONArray == null) {
                                            for (int i6 = 0; i6 < optJSONArray.length(); i6++) {
                                                JSONObject optJSONObject5 = optJSONArray.optJSONObject(i6);
                                                if (optJSONObject5 != null) {
                                                    String optString4 = optJSONObject5.optString("color");
                                                    String optString5 = optJSONObject5.optString("colorPressed");
                                                    if (TextUtils.isEmpty(optString4)) {
                                                        optString5 = changeColorAlpha(changeColorAlpha2, 0.3f);
                                                        optString4 = changeColorAlpha2;
                                                    } else if (TextUtils.isEmpty(optString5)) {
                                                        optString5 = changeColorAlpha(optString4, 0.3f);
                                                    }
                                                    iTitleNView.setButtonColorByIndex(i6, "#00333333", optString4, optString5);
                                                }
                                            }
                                            return;
                                        }
                                        return;
                                    }
                                }
                                str7 = changeColorAlpha3;
                                str6 = changeColorAlpha2;
                                iTitleNView.setBackButtonColor("#00333333", str6, str7);
                                iTitleNView.setHomeButtonColor("#00333333", changeColorAlpha(changeColorAlpha2, 1.0f), changeColorAlpha(changeColorAlpha2, 0.3f));
                                optJSONArray = jSONObject.optJSONArray("buttons");
                                if (optJSONArray == null) {
                                }
                            } else {
                                float f5 = f / f2;
                                String changeColorAlpha4 = changeColorAlpha(optString3, 1.0f);
                                String color2Color = color2Color(TRANSPARENT_BUTTON_TEXT_COLOR, changeColorAlpha4, f5);
                                JSONObject optJSONObject6 = jSONObject.optJSONObject("backButton");
                                String optString6 = (optJSONObject6 == null || !optJSONObject6.has("background")) ? TRANSPARENT_BUTTON_BACKGROUND_COLOR : optJSONObject6.optString("background");
                                String changeColorAlpha5 = changeColorAlpha(color2Color, 0.3f);
                                if (optJSONObject6 != null) {
                                    String optString7 = optJSONObject6.optString("color");
                                    str5 = optJSONObject6.optString("colorPressed");
                                    if (TextUtils.isEmpty(optString7)) {
                                        str5 = changeColorAlpha(changeColorAlpha4, 0.3f);
                                        optString7 = changeColorAlpha4;
                                    } else if (TextUtils.isEmpty(str5)) {
                                        str5 = changeColorAlpha(optString7, 0.3f);
                                    }
                                    str4 = color2Color(TRANSPARENT_BUTTON_TEXT_COLOR, optString7, f5);
                                    f3 = 1.0f;
                                } else {
                                    str5 = changeColorAlpha5;
                                    f3 = 1.0f;
                                    str4 = color2Color;
                                }
                                float f6 = f3 - f5;
                                if (f6 < ((float) Color.alpha(Color.parseColor(optString6))) / 255.0f) {
                                    iTitleNView.setBackButtonColor(changeColorAlpha(optString6, f6), str4, str5);
                                } else {
                                    iTitleNView.setBackButtonColor(optString6, str4, str5);
                                }
                                if (f6 < ((float) Color.alpha(Color.parseColor(TRANSPARENT_BUTTON_BACKGROUND_COLOR))) / 255.0f) {
                                    iTitleNView.setHomeButtonColor(changeColorAlpha(TRANSPARENT_BUTTON_BACKGROUND_COLOR, f6), color2Color, changeColorAlpha(color2Color, 0.3f));
                                } else {
                                    iTitleNView.setHomeButtonColor(TRANSPARENT_BUTTON_BACKGROUND_COLOR, color2Color, changeColorAlpha(color2Color, 0.3f));
                                }
                                JSONArray optJSONArray3 = jSONObject.optJSONArray("buttons");
                                if (optJSONArray3 != null) {
                                    for (int i7 = 0; i7 < optJSONArray3.length(); i7++) {
                                        JSONObject optJSONObject7 = optJSONArray3.optJSONObject(i7);
                                        if (optJSONObject7 != null) {
                                            String optString8 = optJSONObject7.optString("color");
                                            String optString9 = optJSONObject7.optString("colorPressed");
                                            if (TextUtils.isEmpty(optString8)) {
                                                optString9 = changeColorAlpha(changeColorAlpha4, 0.3f);
                                                optString8 = changeColorAlpha4;
                                            } else if (TextUtils.isEmpty(optString9)) {
                                                optString9 = changeColorAlpha(optString8, 0.3f);
                                            }
                                            String color2Color2 = color2Color(TRANSPARENT_BUTTON_TEXT_COLOR, optString8, f5);
                                            String optString10 = optJSONObject7.optString("background", TRANSPARENT_BUTTON_BACKGROUND_COLOR);
                                            try {
                                                i3 = Color.parseColor(optString10);
                                            } catch (Exception unused) {
                                                i3 = PdrUtil.stringToColor(optString10);
                                            }
                                            if (f6 < ((float) Color.alpha(i3)) / 255.0f) {
                                                iTitleNView.setButtonColorByIndex(i7, changeColorAlpha(optString10, f6), color2Color2, optString9);
                                            } else {
                                                iTitleNView.setButtonColorByIndex(i7, optString10, color2Color2, optString9);
                                            }
                                        }
                                    }
                                    return;
                                }
                                return;
                            }
                        }
                    }
                    i2 = i4;
                    if (titleColor != i2) {
                    }
                    iTitleNView.setStatusBarColor(optInt);
                    if (optJSONObject != null) {
                    }
                    setSplitLine(iTitleNView, iWebview, optJSONObject, optJSONObject, false, "");
                    if (optString2 != null) {
                    }
                    if (i == 0) {
                    }
                }
                optString3 = optString;
                titleColor = iTitleNView.getTitleColor();
                optJSONObject = jSONObject.optJSONObject("splitLine");
                String str82 = null;
                if (optJSONObject != null) {
                }
                str = null;
                if (!TextUtils.isEmpty(str)) {
                }
                i = (f > 0.0f ? 1 : (f == 0.0f ? 0 : -1));
                if (i != 0) {
                }
                i2 = i4;
                if (titleColor != i2) {
                }
                iTitleNView.setStatusBarColor(optInt);
                if (optJSONObject != null) {
                }
                setSplitLine(iTitleNView, iWebview, optJSONObject, optJSONObject, false, "");
                if (optString2 != null) {
                }
                if (i == 0) {
                }
            } catch (Exception unused2) {
            }
        }
    }

    public static String changeColorAlpha(String str, float f) {
        String[] stringSplit;
        try {
            if (TextUtils.isEmpty(str) || 0.0f > f || f > 1.0f) {
                return null;
            }
            if (str.startsWith("#")) {
                String substring = str.substring(1, str.length());
                if (substring.length() == 3) {
                    str = "#" + substring.charAt(0) + substring.charAt(0) + substring.charAt(1) + substring.charAt(1) + substring.charAt(2) + substring.charAt(2);
                }
                int parseColor = Color.parseColor(str);
                String hexString = Integer.toHexString((int) (f * 255.0f));
                if (1 == hexString.length()) {
                    hexString = WXInstanceApm.VALUE_ERROR_CODE_DEFAULT + hexString;
                }
                String hexString2 = Integer.toHexString(Color.red(parseColor));
                if (1 == hexString2.length()) {
                    hexString2 = WXInstanceApm.VALUE_ERROR_CODE_DEFAULT + hexString2;
                }
                String hexString3 = Integer.toHexString(Color.green(parseColor));
                if (1 == hexString3.length()) {
                    hexString3 = WXInstanceApm.VALUE_ERROR_CODE_DEFAULT + hexString3;
                }
                String hexString4 = Integer.toHexString(Color.blue(parseColor));
                if (1 == hexString4.length()) {
                    hexString4 = WXInstanceApm.VALUE_ERROR_CODE_DEFAULT + hexString4;
                }
                return "#" + hexString + hexString2 + hexString3 + hexString4;
            } else if (!str.startsWith("rgba") || !str.contains(Operators.BRACKET_START_STR) || !str.contains(Operators.BRACKET_END_STR) || !str.contains(",") || (stringSplit = PdrUtil.stringSplit(str.substring(str.indexOf(Operators.BRACKET_START_STR) + 1, str.indexOf(Operators.BRACKET_END_STR)), ",")) == null || 4 != stringSplit.length) {
                return null;
            } else {
                return "rgba(" + stringSplit[0] + "," + stringSplit[1] + "," + stringSplit[2] + "," + f + Operators.BRACKET_END_STR;
            }
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}
