package io.dcloud.common.util;

import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import androidx.core.content.ContextCompat;
import com.taobao.weex.el.parse.Operators;
import io.dcloud.common.adapter.io.DHFile;
import io.dcloud.common.adapter.util.DeviceInfo;
import io.dcloud.common.adapter.util.Logger;
import io.dcloud.common.adapter.util.PlatformUtil;
import io.dcloud.common.adapter.util.SP;
import io.dcloud.f.a;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

public class TelephonyUtil {
    private static String AIDKEY = "aid";
    private static String AId = "";
    private static String IMEI1_KEY = "II1";
    private static String IMEI2_KEY = "II2";
    private static String IMSI_KEY = "isi";
    private static String MAC_KEY = "mc";
    private static String[] MultiIMEITemp = null;
    private static String MultiIMEI_KEY = "mmikey";
    private static final String OLD_UUID_FILE_NAME = ".imei.txt";
    public static final String TAG = "TelephonyUtil";
    private static final String UUID_FILE_NAME = ".DC4278477faeb9.txt";
    private static boolean isGetAId = false;
    private static boolean isGetIMSI = false;
    private static boolean isGetMac = false;
    private static boolean isGetMultiIMEI = false;
    private static Boolean isGetRdId = Boolean.FALSE;
    private static String mImei = "";
    private static String randomId = null;
    private static String sIMSI = null;
    private static String sImei = "";
    private static String sMac = null;
    private static String sOriginalImeiAndBakInfo;

    private static boolean checkPseudoData(String str) {
        if (PdrUtil.isEmpty(str) || str.contains("000000")) {
            return true;
        }
        str.hashCode();
        char c = 65535;
        switch (str.hashCode()) {
            case -627373694:
                if (str.equals("020000000000")) {
                    c = 0;
                    break;
                }
                break;
            case -337781687:
                if (str.equals("9F89C84A559F573636A47FF8DAED0D33")) {
                    c = 1;
                    break;
                }
                break;
            case 1197925380:
                if (str.equals("E3F5536A141811DB40EFD6400F1D0A4E")) {
                    c = 2;
                    break;
                }
                break;
            case 1428967488:
                if (str.equals("00000000-0000-0000-0000-000000000000")) {
                    c = 3;
                    break;
                }
                break;
        }
        switch (c) {
            case 0:
            case 1:
            case 2:
            case 3:
                return true;
            default:
                return false;
        }
    }

    private static String createRandomBSFile(Context context, File file, File file2, String str) throws IOException {
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
            file.createNewFile();
        }
        String replaceAll = UUID.randomUUID().toString().replaceAll(Operators.SUB, "").replaceAll("\n", "");
        byte[] bytes = replaceAll.getBytes();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(bytes);
            fileOutputStream.flush();
            fileOutputStream.close();
            if (!FileUtil.needMediaStoreOpenFile(context)) {
                if (file2 != null) {
                    DHFile.copyFile(file.getPath(), file2.getPath());
                }
            }
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e2) {
            e2.printStackTrace();
        }
        return replaceAll;
    }

    public static String getAId(Context context) {
        if (!isGetAId) {
            if (ContextCompat.checkSelfPermission(context, "android.permission.READ_PHONE_STATE") != 0) {
                return AId;
            }
            SharedPreferences orCreateBundle = SP.getOrCreateBundle(context, SP.N_DEVICE_INFO);
            if (orCreateBundle.contains(AIDKEY)) {
                String string = orCreateBundle.getString(AIDKEY, null);
                if (!PdrUtil.isEmpty(string)) {
                    AId = Base64.decodeString(string, true, 10);
                }
            } else {
                String string2 = Settings.Secure.getString(context.getContentResolver(), a.a("aWZsemdhbFdhbA=="));
                AId = string2;
                SP.setBundleData(orCreateBundle, AIDKEY, PdrUtil.isEmpty(string2) ? AId : Base64.encodeString(AId, true, 10));
            }
            isGetAId = true;
        }
        return AId;
    }

    private static String getAPSubId(Context context) {
        if (Build.VERSION.SDK_INT < 29) {
            if (!AppRuntime.hasPrivacyForNotShown(context)) {
                return "";
            }
            try {
                Object invokeMethod = ReflectUtils.invokeMethod(context.getSystemService("phone"), a.a("b218W31qe2t6YWptekFs"), new Class[0], new Object[0]);
                if (invokeMethod != null) {
                    return (String) invokeMethod;
                }
            } catch (Exception unused) {
            }
        }
        return null;
    }

    /* JADX WARNING: Removed duplicated region for block: B:12:0x0034  */
    /* JADX WARNING: Removed duplicated region for block: B:23:0x0057 A[RETURN] */
    /* JADX WARNING: Removed duplicated region for block: B:24:0x0058  */
    public static String getDCloudDeviceID(Context context) {
        String str;
        String bundleData = SP.getBundleData(context, BaseInfo.PDR, "android_device_dcloud_id");
        if (!checkPseudoData(bundleData)) {
            return bundleData;
        }
        if (Build.VERSION.SDK_INT > 28 && !PdrUtil.isEmpty(DeviceInfo.oaids)) {
            String[] split = DeviceInfo.oaids.split("\\|");
            if (split.length > 0) {
                str = split[0];
                if (checkPseudoData(str)) {
                    String[] strArr = MultiIMEITemp;
                    if (strArr != null) {
                        str = TextUtils.join(",", strArr);
                    } else {
                        str = "";
                    }
                    if (checkPseudoData(str)) {
                        str = getRandomId(context);
                        if (checkPseudoData(str)) {
                            str = "";
                        }
                    }
                }
                if (!PdrUtil.isEmpty(str)) {
                    return "";
                }
                String md5LowerCase32Bit = Md5Utils.md5LowerCase32Bit(str);
                SP.setBundleData(context, BaseInfo.PDR, "android_device_dcloud_id", md5LowerCase32Bit);
                return md5LowerCase32Bit;
            }
        }
        str = "";
        if (checkPseudoData(str)) {
        }
        if (!PdrUtil.isEmpty(str)) {
        }
    }

    public static String getIMEI(Context context) {
        return getIMEI(context, true);
    }

    public static String getIMEIS(Context context) {
        try {
            String[] multiIMEI = getMultiIMEI(context);
            if (multiIMEI != null) {
                return TextUtils.join(",", multiIMEI);
            }
        } catch (Exception unused) {
        }
        return "";
    }

    public static String getIMSI(Context context) {
        if (context == null) {
            return "";
        }
        try {
            if (ContextCompat.checkSelfPermission(context, "android.permission.READ_PHONE_STATE") != 0) {
                return "";
            }
            boolean hasPrivacyForNotShown = AppRuntime.hasPrivacyForNotShown(context);
            if (!isGetIMSI) {
                if (!hasPrivacyForNotShown) {
                    String str = sIMSI;
                    if (str != null) {
                        return str;
                    }
                    SharedPreferences orCreateBundle = SP.getOrCreateBundle(context, SP.N_DEVICE_INFO);
                    if (orCreateBundle.contains(IMSI_KEY)) {
                        String string = orCreateBundle.getString(IMSI_KEY, null);
                        if (!PdrUtil.isEmpty(string)) {
                            sIMSI = Base64.decodeString(string, true, 10);
                        }
                    } else {
                        int subId = getSubId(0, context);
                        int subId2 = getSubId(1, context);
                        if (subId == -1 && subId2 == -1) {
                            sIMSI = getAPSubId(context);
                        } else {
                            String str2 = (String) getPhoneInfo(subId, context);
                            String str3 = (String) getPhoneInfo(subId2, context);
                            if (!PdrUtil.isEmpty(str2)) {
                                sIMSI = str2;
                                if (!PdrUtil.isEmpty(str3) && !str2.equals(str3)) {
                                    sIMSI += "," + str3;
                                }
                            } else if (!PdrUtil.isEmpty(str3)) {
                                sIMSI = str3;
                            } else {
                                sIMSI = getAPSubId(context);
                            }
                        }
                        SP.setBundleData(orCreateBundle, IMSI_KEY, PdrUtil.isEmpty(sIMSI) ? sIMSI : Base64.encodeString(sIMSI, true, 10));
                    }
                    isGetIMSI = true;
                    return sIMSI;
                }
            }
            return sIMSI;
        } catch (Exception unused) {
        }
    }

    /* JADX WARNING: Removed duplicated region for block: B:51:0x00da  */
    /* JADX WARNING: Removed duplicated region for block: B:52:0x00e1  */
    public static String[] getMultiIMEI(Context context) {
        String str;
        String str2;
        if (ContextCompat.checkSelfPermission(context, "android.permission.READ_PHONE_STATE") != 0) {
            return null;
        }
        if (AppRuntime.hasPrivacyForNotShown(context)) {
            return MultiIMEITemp;
        }
        if (isGetMultiIMEI) {
            return MultiIMEITemp;
        }
        SharedPreferences orCreateBundle = SP.getOrCreateBundle(context, SP.N_DEVICE_INFO);
        if (orCreateBundle.contains(MultiIMEI_KEY)) {
            String string = orCreateBundle.getString(MultiIMEI_KEY, null);
            if (!PdrUtil.isEmpty(string)) {
                try {
                    JSONObject jSONObject = new JSONObject(Base64.decodeString(string, true, 10));
                    str = jSONObject.optString(IMEI1_KEY);
                    try {
                        str2 = jSONObject.optString(IMEI2_KEY);
                    } catch (JSONException unused) {
                    }
                } catch (JSONException unused2) {
                    str = null;
                    str2 = null;
                    isGetMultiIMEI = true;
                    if (isUnValid(str)) {
                    }
                    if (isUnValid(str)) {
                    }
                    isGetMultiIMEI = true;
                    return MultiIMEITemp;
                }
            } else {
                str = null;
                str2 = null;
            }
            isGetMultiIMEI = true;
        } else {
            TelephonyManager telephonyManager = (TelephonyManager) context.getSystemService("phone");
            try {
                String str3 = (String) PlatformUtil.invokeMethod(telephonyManager.getClass().getName(), "getDeviceId", telephonyManager);
                String str4 = (String) PlatformUtil.invokeMethod(telephonyManager.getClass().getName(), "getDeviceId", telephonyManager, new Class[]{Integer.TYPE}, new Object[]{1});
                if (isUnValid(str3)) {
                    str3 = null;
                }
                try {
                    str2 = !isUnValid(str4) ? str4 : null;
                    try {
                        JSONObject jSONObject2 = new JSONObject();
                        jSONObject2.put(IMEI1_KEY, str3);
                        jSONObject2.put(IMEI2_KEY, str2);
                        SP.setBundleData(orCreateBundle, MultiIMEI_KEY, Base64.encodeString(jSONObject2.toString(), true, 10));
                    } catch (Exception unused3) {
                    }
                } catch (Exception unused4) {
                    str2 = null;
                }
                str = str3;
            } catch (Exception unused5) {
                str = null;
                str2 = null;
            }
        }
        if (isUnValid(str) && !isUnValid(str2)) {
            MultiIMEITemp = new String[]{str, str2};
        } else if (isUnValid(str)) {
            MultiIMEITemp = new String[]{str};
        } else if (!isUnValid(str2)) {
            MultiIMEITemp = new String[]{str2};
        } else {
            MultiIMEITemp = null;
        }
        isGetMultiIMEI = true;
        return MultiIMEITemp;
    }

    private static Object getPhoneInfo(int i, Context context) {
        try {
            Object systemService = context.getSystemService("phone");
            String a = a.a("b218W31qe2t6YWptekFs");
            int i2 = Build.VERSION.SDK_INT;
            if (i2 > 21) {
                return ReflectUtils.invokeMethod(systemService, a, new Class[]{Integer.TYPE}, new Object[]{Integer.valueOf(i)});
            }
            if (i2 == 21) {
                return ReflectUtils.invokeMethod(systemService, a, new Class[]{Long.TYPE}, new Object[]{Integer.valueOf(i)});
            }
            return null;
        } catch (Exception unused) {
        }
    }

    /* JADX WARNING: Removed duplicated region for block: B:37:0x00e8 A[Catch:{ Exception -> 0x010e }] */
    /* JADX WARNING: Removed duplicated region for block: B:44:0x0114  */
    public static String getRandomId(Context context) {
        File file;
        String str;
        String str2;
        if (isGetRdId.booleanValue()) {
            return randomId;
        }
        String str3 = null;
        try {
            boolean needMediaStoreOpenFile = FileUtil.needMediaStoreOpenFile(context);
            StringBuilder sb = new StringBuilder();
            sb.append(context.getFilesDir());
            String str4 = File.separator;
            sb.append(str4);
            sb.append(OLD_UUID_FILE_NAME);
            String sb2 = sb.toString();
            File file2 = new File(sb2);
            if (!file2.exists()) {
                sb2 = context.getFilesDir() + str4 + UUID_FILE_NAME;
                file2 = new File(sb2);
            }
            if (!"mounted".equalsIgnoreCase(Environment.getExternalStorageState()) || needMediaStoreOpenFile || ContextCompat.checkSelfPermission(context, "android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
                str = null;
                file = null;
            } else {
                str = Environment.getExternalStorageDirectory() + str4 + OLD_UUID_FILE_NAME;
                file = new File(str);
                if (!file.exists()) {
                    str = Environment.getExternalStorageDirectory() + str4 + UUID_FILE_NAME;
                    file = new File(str);
                }
            }
            if (file2.isDirectory()) {
                file2.delete();
            }
            if (file == null || !file.exists() || file.length() <= 0) {
                str2 = savePublicFile(file2, file, sb2, str, context);
            } else {
                if (needMediaStoreOpenFile) {
                    try {
                        if (Build.VERSION.SDK_INT >= 29) {
                            if (!TextUtils.isEmpty(str3)) {
                                if (!file2.getParentFile().exists()) {
                                    file2.getParentFile().mkdirs();
                                    file2.createNewFile();
                                }
                                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                                fileOutputStream.write(str3.getBytes());
                                fileOutputStream.flush();
                                fileOutputStream.close();
                            }
                            if (TextUtils.isEmpty(str3)) {
                                str2 = savePublicFile(file2, file, sb2, str, context);
                            }
                            randomId = str3;
                            isGetRdId = Boolean.TRUE;
                            return str3;
                        }
                    } catch (Exception unused) {
                    }
                }
                str3 = IOUtil.toString(new FileInputStream(file));
                if (!PdrUtil.isEmpty(str3)) {
                    str3 = str3.replace("\n", "");
                }
                if (!TextUtils.isEmpty(str3)) {
                }
                if (TextUtils.isEmpty(str3)) {
                }
                randomId = str3;
                isGetRdId = Boolean.TRUE;
                return str3;
            }
            str3 = str2;
        } catch (Exception e) {
            e.printStackTrace();
        }
        randomId = str3;
        isGetRdId = Boolean.TRUE;
        return str3;
    }

    public static String getSBBS(Context context, boolean z, boolean z2) {
        return getSBBS(context, z, z2, true);
    }

    public static String getSimOperator(Context context) {
        if (!AppRuntime.hasPrivacyForNotShown(context)) {
            TelephonyManager telephonyManager = (TelephonyManager) context.getSystemService("phone");
            if (telephonyManager.getSimState() == 5) {
                return telephonyManager.getSimOperator();
            }
        }
        return "";
    }

    private static int getSubId(int i, Context context) {
        Uri parse = Uri.parse("content://telephony/siminfo");
        ContentResolver contentResolver = context.getContentResolver();
        Cursor cursor = null;
        try {
            String[] strArr = {"_id", "sim_id"};
            cursor = contentResolver.query(parse, strArr, "sim_id = ?", new String[]{String.valueOf(i)}, null);
            if (cursor == null || !cursor.moveToFirst()) {
                if (cursor == null) {
                    return -1;
                }
                cursor.close();
                return -1;
            }
            int i2 = cursor.getInt(cursor.getColumnIndex("_id"));
            cursor.close();
            return i2;
        } catch (Exception unused) {
            if (0 == 0) {
                return -1;
            }
        } catch (Throwable th) {
            if (0 != 0) {
                cursor.close();
            }
            throw th;
        }
    }

    @Deprecated
    public static String getWifiData(Context context) {
        Object invokeMethod;
        String str = null;
        if (AppRuntime.hasPrivacyForNotShown(context)) {
            return null;
        }
        if (isGetMac) {
            return sMac;
        }
        SharedPreferences orCreateBundle = SP.getOrCreateBundle(context, SP.N_DEVICE_INFO);
        if (orCreateBundle.contains(MAC_KEY)) {
            String string = orCreateBundle.getString(MAC_KEY, null);
            if (!PdrUtil.isEmpty(string)) {
                sMac = Base64.decodeString(string, true, 10);
            }
        } else {
            Object systemService = context.getSystemService(a.a("f2FuYQ=="));
            if (!(systemService == null || (invokeMethod = ReflectUtils.invokeMethod(systemService, a.a("b218S2dmZm1rfGFnZkFmbmc"), new Class[0], new Object[0])) == null)) {
                Object invokeMethod2 = ReflectUtils.invokeMethod(invokeMethod, a.a("b218RWlrSWxsem17ew"), new Class[0], new Object[0]);
                String str2 = invokeMethod2 != null ? (String) invokeMethod2 : null;
                if (!TextUtils.isEmpty(str2)) {
                    str = str2.replace(":", "");
                }
            }
            sMac = str;
            SP.setBundleData(orCreateBundle, MAC_KEY, PdrUtil.isEmpty(str) ? sMac : Base64.encodeString(sMac, true, 10));
        }
        isGetMac = true;
        return sMac;
    }

    private static boolean isUnValid(String str) {
        return TextUtils.isEmpty(str) || str.contains("Unknown") || str.contains("00000000");
    }

    /* JADX WARNING: Removed duplicated region for block: B:22:0x004f  */
    /* JADX WARNING: Removed duplicated region for block: B:27:? A[RETURN, SYNTHETIC] */
    private static String savePublicFile(File file, File file2, String str, String str2, Context context) throws IOException {
        String str3;
        if (!file.exists() || file.length() <= 0) {
            return createRandomBSFile(context, file, file2, UUID_FILE_NAME);
        }
        try {
            str3 = IOUtil.toString(new FileInputStream(file));
            try {
                if (!PdrUtil.isEmpty(str3)) {
                    str3 = str3.replaceAll("\n", "");
                }
                if (file2 == null) {
                    return str3;
                }
                if (FileUtil.needMediaStoreOpenFile(context)) {
                    return str3;
                }
                if (!file2.getParentFile().exists()) {
                    file2.getParentFile().mkdirs();
                    file2.createNewFile();
                }
                DHFile.copyFile(str, str2);
                return str3;
            } catch (Exception unused) {
                if (str3 != null) {
                }
            }
        } catch (Exception unused2) {
            str3 = null;
            if (str3 != null) {
                return createRandomBSFile(context, file, file2, UUID_FILE_NAME);
            }
            return str3;
        }
    }

    public static String updateIMEI(Context context) {
        if (!PdrUtil.isEmpty(mImei)) {
            return mImei;
        }
        String[] multiIMEI = getMultiIMEI(context);
        if (multiIMEI != null) {
            StringBuilder sb = new StringBuilder();
            for (String str : multiIMEI) {
                sb.append(str);
                sb.append(",");
            }
            if (sb.lastIndexOf(",") >= sb.length() - 1) {
                String sb2 = sb.deleteCharAt(sb.length() - 1).toString();
                mImei = sb2;
                return sb2;
            }
            String sb3 = sb.toString();
            mImei = sb3;
            return sb3;
        }
        mImei = "";
        return "";
    }

    public static String getIMEI(Context context, boolean z) {
        return getIMEI(context, z, false);
    }

    /* JADX WARNING: Code restructure failed: missing block: B:102:0x0128, code lost:
        if (android.text.TextUtils.isEmpty(null) != false) goto L_0x012f;
     */
    /* JADX WARNING: Code restructure failed: missing block: B:103:0x012b, code lost:
        r2 = r4.replace("\n", r2);
     */
    /* JADX WARNING: Code restructure failed: missing block: B:104:0x012f, code lost:
        r0.append(r2);
        r0.append("|");
     */
    /* JADX WARNING: Code restructure failed: missing block: B:36:0x0071, code lost:
        if (r9 != false) goto L_0x0099;
     */
    /* JADX WARNING: Code restructure failed: missing block: B:45:0x0097, code lost:
        if (r9 != false) goto L_0x0099;
     */
    /* JADX WARNING: Code restructure failed: missing block: B:46:0x0099, code lost:
        r0.append(r4);
        r0.append("|");
     */
    /* JADX WARNING: Code restructure failed: missing block: B:65:0x00cf, code lost:
        if (android.text.TextUtils.isEmpty(r11) != false) goto L_0x00e1;
     */
    /* JADX WARNING: Code restructure failed: missing block: B:73:0x00df, code lost:
        if (android.text.TextUtils.isEmpty(r11) != false) goto L_0x00e1;
     */
    /* JADX WARNING: Code restructure failed: missing block: B:74:0x00e1, code lost:
        r11 = r2;
     */
    /* JADX WARNING: Code restructure failed: missing block: B:75:0x00e2, code lost:
        r0.append(r11);
        r0.append("|");
     */
    /* JADX WARNING: Code restructure failed: missing block: B:95:0x0119, code lost:
        if (android.text.TextUtils.isEmpty(r4) != false) goto L_0x012f;
     */
    /* JADX WARNING: Removed duplicated region for block: B:106:0x0137  */
    /* JADX WARNING: Removed duplicated region for block: B:108:0x013e  */
    /* JADX WARNING: Removed duplicated region for block: B:48:0x00a2  */
    /* JADX WARNING: Removed duplicated region for block: B:79:0x00ed  */
    /* JADX WARNING: Removed duplicated region for block: B:92:0x0111 A[Catch:{ Exception -> 0x011e, all -> 0x011c }] */
    /* JADX WARNING: Removed duplicated region for block: B:94:0x0115  */
    public static String getSBBS(Context context, boolean z, boolean z2, boolean z3) {
        boolean isUnValid;
        Throwable th;
        String str;
        Exception e;
        Throwable th2;
        String str2;
        Exception e2;
        StringBuffer stringBuffer = new StringBuffer();
        if (z) {
            stringBuffer.append("|");
        }
        String str3 = "";
        if (context == null) {
            return z ? "|||||" : str3;
        }
        if (AppRuntime.hasPrivacyForNotShown(context)) {
            z3 = false;
        }
        if (z && !TextUtils.isEmpty(sOriginalImeiAndBakInfo)) {
            return sOriginalImeiAndBakInfo;
        }
        if (!isUnValid(sImei) && !z) {
            return sImei;
        }
        if (isUnValid(sImei) || z) {
            if (z3) {
                try {
                    String[] multiIMEI = getMultiIMEI(context);
                    if (multiIMEI == null || multiIMEI.length <= 0) {
                        str2 = str3;
                    } else {
                        str2 = multiIMEI[0];
                        try {
                            if (multiIMEI.length > 1) {
                                str2 = str2 + "," + multiIMEI[1];
                            }
                        } catch (Exception e3) {
                            e2 = e3;
                            try {
                                Logger.e(TAG, "getsbbs exception==" + e2.getMessage());
                            } catch (Throwable th3) {
                                th2 = th3;
                                str3 = str2;
                                if (z) {
                                    stringBuffer.append(str3);
                                    stringBuffer.append("|");
                                }
                                throw th2;
                            }
                        }
                    }
                    sImei = str2;
                } catch (Exception e4) {
                    e2 = e4;
                    str2 = str3;
                    Logger.e(TAG, "getsbbs exception==" + e2.getMessage());
                } catch (Throwable th4) {
                    th2 = th4;
                    if (z) {
                    }
                    throw th2;
                }
            } else if (z) {
                stringBuffer.append("|");
            }
        }
        if (z) {
            stringBuffer.append("|");
        }
        boolean isUnValid2 = isUnValid(sImei);
        String str4 = null;
        if (z) {
            if (z3) {
                try {
                    str = getAId(context);
                    if (isUnValid2) {
                        try {
                            sImei = str;
                        } catch (Exception e5) {
                            e = e5;
                        }
                    }
                    if (z) {
                    }
                } catch (Exception e6) {
                    e = e6;
                    str = null;
                    try {
                        e.printStackTrace();
                        if (z) {
                        }
                        isUnValid = isUnValid(sImei);
                        try {
                            str4 = getRandomId(context);
                            if (isUnValid) {
                            }
                            if (z) {
                            }
                        } catch (Exception e7) {
                            e7.printStackTrace();
                            if (z) {
                            }
                        } catch (Throwable th5) {
                            if (z) {
                                if (!TextUtils.isEmpty(null)) {
                                    str3 = str4.replace("\n", str3);
                                }
                                stringBuffer.append(str3);
                                stringBuffer.append("|");
                            }
                            throw th5;
                        }
                        if (z) {
                        }
                    } catch (Throwable th6) {
                        th = th6;
                        str4 = str;
                        if (z) {
                            if (!TextUtils.isEmpty(str4)) {
                                str3 = str4;
                            }
                            stringBuffer.append(str3);
                            stringBuffer.append("|");
                        }
                        throw th;
                    }
                } catch (Throwable th7) {
                    th = th7;
                    if (z) {
                    }
                    throw th;
                }
            } else if (z) {
                stringBuffer.append("|");
            }
        }
        isUnValid = isUnValid(sImei);
        if (isUnValid || z) {
            str4 = getRandomId(context);
            if (isUnValid) {
                sImei = str4;
            }
            if (z) {
            }
        }
        if (z) {
            return sImei;
        }
        String stringBuffer2 = stringBuffer.toString();
        sOriginalImeiAndBakInfo = stringBuffer2;
        return stringBuffer2;
    }

    public static String getIMEI(Context context, boolean z, boolean z2) {
        return getSBBS(context, z, z2);
    }
}
