package io.dcloud.common.util;

import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import io.dcloud.common.DHInterface.IApp;
import io.dcloud.common.DHInterface.IMgr;
import io.dcloud.common.DHInterface.INativeView;
import io.dcloud.common.adapter.ui.AdaFrameView;
import io.dcloud.common.constant.AbsoluteConst;
import io.dcloud.common.core.ui.l;
import io.dcloud.nineoldandroids.animation.Animator;
import java.util.ArrayList;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SubNViewsUtil {
    public static void initFrameSubNViews(AdaFrameView adaFrameView) {
        int i = 4;
        if (adaFrameView.getFrameType() == 2) {
            JSONObject obtainThridInfo = adaFrameView.obtainApp().obtainThridInfo(IApp.ConfigProperty.ThridInfo.LaunchWebviewJsonData);
            if (obtainThridInfo != null && obtainThridInfo.has(AbsoluteConst.JSON_KEY_SUB_NVIEWS)) {
                try {
                    adaFrameView.obtainFrameOptions().mSubNViews = obtainThridInfo.getJSONArray(AbsoluteConst.JSON_KEY_SUB_NVIEWS);
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            if (obtainThridInfo != null && obtainThridInfo.has(AbsoluteConst.JSON_KEY_ANIMATION_OPTIMIZATION) && obtainThridInfo.optString(AbsoluteConst.JSON_KEY_ANIMATION_OPTIMIZATION).equals("auto")) {
                adaFrameView.obtainFrameOptions().isAnimationOptimization = true;
            }
        } else if (adaFrameView.getFrameType() == 4) {
            JSONObject obtainThridInfo2 = adaFrameView.obtainApp().obtainThridInfo(IApp.ConfigProperty.ThridInfo.SecondWebviewJsonData);
            if (obtainThridInfo2 != null && obtainThridInfo2.has(AbsoluteConst.JSON_KEY_SUB_NVIEWS)) {
                try {
                    adaFrameView.obtainFrameOptions().mSubNViews = obtainThridInfo2.getJSONArray(AbsoluteConst.JSON_KEY_SUB_NVIEWS);
                } catch (JSONException e2) {
                    e2.printStackTrace();
                }
            }
            if (obtainThridInfo2 != null && obtainThridInfo2.has(AbsoluteConst.JSON_KEY_ANIMATION_OPTIMIZATION) && obtainThridInfo2.optString(AbsoluteConst.JSON_KEY_ANIMATION_OPTIMIZATION).equals("auto")) {
                adaFrameView.obtainFrameOptions().isAnimationOptimization = true;
            }
        }
        if (adaFrameView.obtainFrameOptions().mSubNViews != null) {
            JSONArray jSONArray = adaFrameView.obtainFrameOptions().mSubNViews;
            int i2 = 0;
            while (i2 < jSONArray.length()) {
                try {
                    JSONObject jSONObject = jSONArray.getJSONObject(i2);
                    String optString = jSONObject.optString("id", i2 + "NativeView");
                    String optString2 = jSONObject.optString("uuid");
                    if (TextUtils.isEmpty(optString2)) {
                        optString2 = "NativeView" + (System.currentTimeMillis() + ((long) i2));
                    }
                    JSONObject optJSONObject = jSONObject.optJSONObject("styles");
                    JSONArray optJSONArray = jSONObject.optJSONArray("tags");
                    String optString3 = jSONObject.optString("type", "NView");
                    l lVar = adaFrameView.mWindowMgr;
                    IMgr.MgrType mgrType = IMgr.MgrType.FeatureMgr;
                    Object[] objArr = new Object[i];
                    objArr[0] = adaFrameView.obtainWebView();
                    objArr[1] = "nativeobj";
                    objArr[2] = "View";
                    objArr[3] = new Object[]{adaFrameView, adaFrameView.obtainWebView(), optString, optString2, optJSONObject, optJSONArray, optString3};
                    Object processEvent = lVar.processEvent(mgrType, 10, objArr);
                    if (processEvent != null) {
                        ((INativeView) processEvent).attachToViewGroup(adaFrameView);
                    }
                    i2++;
                    i = 4;
                } catch (JSONException e3) {
                    e3.printStackTrace();
                    return;
                }
            }
        }
    }

    public static boolean startAnimation(final AdaFrameView adaFrameView, Animator animator, int i) {
        ArrayList<INativeView> arrayList;
        if (adaFrameView.getAnimOptions().mAnimator != null && i == 0 && (arrayList = adaFrameView.mChildNativeViewList) != null && arrayList.size() > 0) {
            final ViewGroup obtainWindowView = adaFrameView.obtainWebView().obtainWindowView();
            final ViewGroup viewGroup = (ViewGroup) obtainWindowView.getParent();
            final ArrayList arrayList2 = new ArrayList();
            if (adaFrameView.obtainFrameOptions().background == -1) {
                viewGroup.setBackgroundColor(-1);
            }
            for (int i2 = 0; i2 < obtainWindowView.getChildCount(); i2++) {
                View childAt = obtainWindowView.getChildAt(i2);
                if (childAt instanceof INativeView) {
                    arrayList2.add((INativeView) childAt);
                }
            }
            Iterator it = arrayList2.iterator();
            while (it.hasNext()) {
                INativeView iNativeView = (INativeView) it.next();
                obtainWindowView.removeView(iNativeView.obtanMainView());
                viewGroup.addView(iNativeView.obtanMainView());
            }
            viewGroup.removeView(obtainWindowView);
            try {
                obtainWindowView.getClass().getMethod("onPause", null).invoke(obtainWindowView, null);
            } catch (Exception e) {
                e.printStackTrace();
            }
            final View obtainMainView = adaFrameView.obtainMainView();
            if (!PdrUtil.isEmpty(obtainMainView)) {
                obtainMainView.bringToFront();
                obtainMainView.setVisibility(0);
                adaFrameView.getAnimOptions().mAnimator.setAnimationListener(new Animation.AnimationListener() {
                    /* class io.dcloud.common.util.SubNViewsUtil.AnonymousClass1 */

                    public void onAnimationEnd(Animation animation) {
                        Animator.AnimatorListener animatorListener = AdaFrameView.this.mAnimatorListener;
                        if (animatorListener != null) {
                            animatorListener.onAnimationEnd(null);
                        }
                        BaseInfo.sDoingAnimation = false;
                        AdaFrameView.this.setSlipping(false);
                        obtainMainView.post(new Runnable() {
                            /* class io.dcloud.common.util.SubNViewsUtil.AnonymousClass1.AnonymousClass1 */

                            public void run() {
                                Iterator it = arrayList2.iterator();
                                while (it.hasNext()) {
                                    INativeView iNativeView = (INativeView) it.next();
                                    viewGroup.removeView(iNativeView.obtanMainView());
                                    obtainWindowView.addView(iNativeView.obtanMainView());
                                }
                                AnonymousClass1 r0 = AnonymousClass1.this;
                                viewGroup.addView(obtainWindowView);
                                if (AdaFrameView.this.obtainFrameOptions().background == -1) {
                                    viewGroup.setBackgroundColor(0);
                                }
                                try {
                                    obtainWindowView.getClass().getMethod("onResume", null).invoke(obtainWindowView, null);
                                } catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        });
                    }

                    public void onAnimationRepeat(Animation animation) {
                    }

                    public void onAnimationStart(Animation animation) {
                        Animator.AnimatorListener animatorListener = AdaFrameView.this.mAnimatorListener;
                        if (animatorListener != null) {
                            animatorListener.onAnimationStart(null);
                        }
                        BaseInfo.sDoingAnimation = true;
                    }
                });
                adaFrameView.setSlipping(true);
                obtainMainView.startAnimation(adaFrameView.getAnimOptions().mAnimator);
                return true;
            }
        }
        return false;
    }

    public static void updateSubNViews(AdaFrameView adaFrameView, JSONArray jSONArray) {
        if (jSONArray != null) {
            adaFrameView.mWindowMgr.processEvent(IMgr.MgrType.FeatureMgr, 10, new Object[]{adaFrameView.obtainWebView(), "nativeobj", "updateSubNViews", new Object[]{adaFrameView, adaFrameView.obtainWebView(), jSONArray}});
        }
    }
}
