package io.dcloud.common.util;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import io.dcloud.application.DCLoudApplicationImpl;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;

public class RuningAcitvityUtil {
    private static HashMap<String, WeakReference<Activity>> RuningActivitys = new HashMap<>();
    public static boolean isRuningActivity = false;

    public static void StartActivity(Context context, Intent intent) {
        Intent intent2 = new Intent(intent);
        intent2.setAction("android.intent.action.VIEW");
        context.startActivity(intent2);
    }

    public static Activity getActivity(String str) {
        WeakReference<Activity> weakReference;
        if (!RuningActivitys.containsKey(str) || (weakReference = RuningActivitys.get(str)) == null) {
            return null;
        }
        return weakReference.get();
    }

    public static String getAppName(Context context) {
        return ProcessUtil.getCurrentProcessName(context);
    }

    public static Activity getTopRuningActivity(Activity activity) {
        Activity activity2;
        ActivityManager.RunningTaskInfo runningTaskInfo = ((ActivityManager) activity.getSystemService("activity")).getRunningTasks(1).get(0);
        if (!RuningActivitys.containsKey(runningTaskInfo.topActivity.getClassName())) {
            return (!"com.g.gysdk.view.ELoginActivity".equals(runningTaskInfo.topActivity.getClassName()) || (activity2 = DCLoudApplicationImpl.self().topActiveMap.get(runningTaskInfo.topActivity.getClassName()).get()) == null) ? activity : activity2;
        }
        WeakReference<Activity> weakReference = RuningActivitys.get(runningTaskInfo.topActivity.getClassName());
        if (weakReference != null) {
            return weakReference.get();
        }
    }

    public static boolean isRunningProcess(Context context, String str) {
        List<ActivityManager.RunningAppProcessInfo> runningAppProcesses;
        ActivityManager activityManager = (ActivityManager) context.getSystemService("activity");
        if (!(activityManager == null || TextUtils.isEmpty(str) || (runningAppProcesses = activityManager.getRunningAppProcesses()) == null)) {
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : runningAppProcesses) {
                if (TextUtils.equals(runningAppProcessInfo.processName, str)) {
                    return true;
                }
            }
        }
        return false;
    }

    public static void putRuningActivity(Activity activity) {
        String className = activity.getComponentName().getClassName();
        if (!RuningActivitys.containsKey(className)) {
            RuningActivitys.put(className, new WeakReference<>(activity));
        }
    }

    public static void removeRuningActivity(String str) {
        if (RuningActivitys.containsKey(str)) {
            RuningActivitys.remove(str);
        }
    }
}
