package io.dcloud.common.util;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.Point;
import android.graphics.drawable.BitmapDrawable;
import android.net.Uri;
import android.os.Build;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.Display;
import android.view.KeyCharacterMap;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.webkit.MimeTypeMap;
import android.webkit.URLUtil;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.dcloud.android.widget.toast.ToastCompat;
import com.nostra13.dcloudimageloader.core.download.ImageDownloader;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.el.parse.Operators;
import com.taobao.weex.performance.WXInstanceApm;
import io.dcloud.base.R;
import io.dcloud.common.DHInterface.IApp;
import io.dcloud.common.DHInterface.IWebview;
import io.dcloud.common.adapter.io.DHFile;
import io.dcloud.common.adapter.util.DeviceInfo;
import io.dcloud.common.adapter.util.Logger;
import io.dcloud.common.adapter.util.MobilePhoneModel;
import io.dcloud.common.adapter.util.PlatformUtil;
import io.dcloud.common.constant.AbsoluteConst;
import io.dcloud.common.util.XmlUtil;
import io.dcloud.common.util.language.LanguageUtil;
import io.dcloud.e.c.b;
import io.dcloud.f.a;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import tv.danmaku.ijk.media.player.IjkMediaPlayer;

public class PdrUtil {
    public static final String FILE_PATH_ENTRY_BACK = "..";
    public static final String FILE_PATH_ENTRY_SEPARATOR2 = "%";
    private static final String NAVIGATION = "navigationBarBackground";
    private static volatile boolean mHasCheckAllScreen;
    private static volatile boolean mIsAllScreenDevice;

    public static void alert(Activity activity, String str, Bitmap bitmap) {
        final AlertDialog create = new AlertDialog.Builder(activity).create();
        LinearLayout linearLayout = new LinearLayout(activity);
        linearLayout.setOrientation(1);
        linearLayout.setGravity(17);
        TextView textView = new TextView(activity);
        textView.setText(str);
        linearLayout.addView(textView);
        ImageView imageView = new ImageView(activity);
        imageView.setBackgroundDrawable(new BitmapDrawable(bitmap));
        linearLayout.addView(imageView, new ViewGroup.LayoutParams(-2, -2));
        create.setView(linearLayout);
        create.setCanceledOnTouchOutside(false);
        create.setButton(activity.getString(R.string.dcloud_common_ok), new DialogInterface.OnClickListener() {
            /* class io.dcloud.common.util.PdrUtil.AnonymousClass1 */

            public void onClick(DialogInterface dialogInterface, int i) {
                create.dismiss();
            }
        });
        create.show();
    }

    public static String appendByDeviceRootDir(String str) {
        if (str == null || str.startsWith(DeviceInfo.sDeviceRootDir)) {
            return str;
        }
        if (str.startsWith(DeviceInfo.FILE_PROTOCOL)) {
            str = str.substring(7);
        }
        if (str.indexOf("sdcard/") > -1) {
            str = str.substring(str.indexOf("sdcard/") + 7);
        }
        if (!str.endsWith("/")) {
            str = str + "/";
        }
        return DeviceInfo.sDeviceRootDir + "/" + str;
    }

    public static boolean checkAlphaTransparent(int i) {
        return (i == -1 || (i >>> 24) == 255) ? false : true;
    }

    public static boolean checkIntl() {
        return PlatformUtil.checkClass("io.dcloud.common.DHInterface.IntlCallback");
    }

    public static boolean checkStatusbarColor(int i) {
        String str = Build.BRAND;
        if (str.equals(MobilePhoneModel.GOOGLE)) {
            str = Build.MANUFACTURER;
        }
        if ((Build.VERSION.SDK_INT >= 23 || str.equalsIgnoreCase(MobilePhoneModel.XIAOMI) || str.equalsIgnoreCase(MobilePhoneModel.MEIZU)) && !str.equalsIgnoreCase(MobilePhoneModel.DUOWEI)) {
            return true;
        }
        int i2 = (i >> 16) & 255;
        int i3 = (i >> 8) & 255;
        int i4 = i & 255;
        if (i2 >= 30 || i3 >= 30 || i4 >= 30) {
            return i2 <= 235 || i3 <= 235 || i4 <= 235;
        }
        return false;
    }

    public static void closeAndroidPDialog() {
        if (Build.VERSION.SDK_INT >= 28) {
            try {
                PlatformUtil.invokeSetFieldValue(PlatformUtil.invokeMethod(Base64.decode2String("YW5kcm9pZC5hcHAuQWN0aXZpdHlUaHJlYWQ="), "currentActivityThread"), "mHiddenApiWarningShown", Boolean.TRUE);
            } catch (Exception e) {
                Logger.e("PdrUtil", "closeAndroidPDialog--" + e.getMessage());
            }
        }
    }

    public static String convertAppPath(IWebview iWebview, String str) {
        IApp obtainApp = iWebview.obtainApp();
        if (isNetPath(str) || str.startsWith("file:") || str.contains("/storage") || obtainApp.obtainRunningAppMode() != 1) {
            return obtainApp.convert2WebviewFullPath(iWebview.obtainFullUrl(), str);
        }
        String convert2AbsFullPath = iWebview.obtainApp().convert2AbsFullPath(iWebview.obtainFullUrl(), str);
        if (convert2AbsFullPath.startsWith("/")) {
            convert2AbsFullPath = convert2AbsFullPath.substring(1, convert2AbsFullPath.length());
        }
        if (convert2AbsFullPath.contains("android_asset/")) {
            convert2AbsFullPath = convert2AbsFullPath.replace("android_asset/", "");
        }
        return ImageDownloader.Scheme.ASSETS.wrap(convert2AbsFullPath);
    }

    public static int convertToScreenInt(String str, int i, int i2, float f) {
        return convertToScreenInt(str, i, i2, f, false);
    }

    public static String dealString(String str) throws UnsupportedEncodingException {
        byte[] bytes = str.getBytes("GBK");
        for (int i = 0; i < bytes.length; i++) {
            bytes[i] = (byte) (bytes[i] ^ 8);
        }
        return new String(bytes, "GBK");
    }

    public static float dpiFromPx(int i, DisplayMetrics displayMetrics) {
        return ((float) i) / (((float) displayMetrics.densityDpi) / 160.0f);
    }

    public static String encodeURL(String str) {
        if (TextUtils.isEmpty(str)) {
            return null;
        }
        try {
            return URLEncoder.encode(str, "utf-8");
        } catch (UnsupportedEncodingException unused) {
            Logger.e("URLEncode error str=" + str);
            return URLEncoder.encode(str);
        }
    }

    public static boolean getAdEnv(Context context) {
        return !LanguageUtil.getDeviceDefCountry().equalsIgnoreCase(b.c().decryptStr("GJ", (byte) 4));
    }

    public static JSONObject getConfigData(Context context, String str, String str2, boolean z) {
        InputStream inputStream;
        if (z) {
            try {
                inputStream = PlatformUtil.getResInputStream(str2);
            } catch (Exception unused) {
                return null;
            }
        } else {
            inputStream = DHFile.getInputStream(DHFile.createFileHandler(str2));
        }
        if (inputStream == null) {
            return null;
        }
        byte[] bytes = IOUtil.getBytes(inputStream);
        String a = a.a(context, bytes);
        if (TextUtils.isEmpty(a)) {
            a = new String(bytes);
        }
        return new JSONObject(a);
    }

    public static int getConfigOrientation(JSONObject jSONObject) throws JSONException {
        if (jSONObject == null || !jSONObject.has("screenOrientation")) {
            return 2;
        }
        JSONArray optJSONArray = jSONObject.optJSONArray("screenOrientation");
        boolean z = false;
        boolean z2 = false;
        boolean z3 = false;
        boolean z4 = false;
        for (int i = 0; i < optJSONArray.length(); i++) {
            String string = optJSONArray.getString(i);
            string.hashCode();
            string.hashCode();
            char c = 65535;
            switch (string.hashCode()) {
                case -1228021296:
                    if (string.equals("portrait-primary")) {
                        c = 0;
                        break;
                    }
                    break;
                case -147105566:
                    if (string.equals("landscape-secondary")) {
                        c = 1;
                        break;
                    }
                    break;
                case 1862465776:
                    if (string.equals("landscape-primary")) {
                        c = 2;
                        break;
                    }
                    break;
                case 2012187074:
                    if (string.equals("portrait-secondary")) {
                        c = 3;
                        break;
                    }
                    break;
            }
            switch (c) {
                case 0:
                    z3 = true;
                    break;
                case 1:
                    z2 = true;
                    break;
                case 2:
                    z = true;
                    break;
                case 3:
                    z4 = true;
                    break;
            }
        }
        if ((z || z2) && (z3 || z4)) {
            return 2;
        }
        if (z && z2) {
            return 6;
        }
        if (z3 && z4) {
            return 7;
        }
        if (z) {
            return 0;
        }
        if (z2) {
            return 8;
        }
        if (z3) {
            return 1;
        }
        if (z4) {
            return 9;
        }
        return 2;
    }

    public static String getDefaultPrivateDocPath(String str, String str2) {
        if (isEmpty(str)) {
            str = AbsoluteConst.MINI_SERVER_APP_DOC + System.currentTimeMillis();
        } else if (str.endsWith("/")) {
            str = str + System.currentTimeMillis();
        }
        if (str.endsWith(Operators.DOT_STR + str2)) {
            return str;
        }
        return str + Operators.DOT_STR + str2;
    }

    public static String getDownloadFilename(String str, String str2, String str3) {
        String[] stringSplit;
        String[] stringSplit2;
        String str4 = null;
        try {
            str3 = URLDecoder.decode(str3, "utf-8");
            Uri parse = Uri.parse(str3);
            if (parse != null) {
                String path = parse.getPath();
                if (!isEmpty(path)) {
                    str3 = path;
                }
            }
            if (!isEmpty(str) && (stringSplit = stringSplit(str, ";")) != null) {
                int i = 0;
                while (true) {
                    if (i >= stringSplit.length) {
                        break;
                    }
                    if (!(stringSplit[i] == null || !stringSplit[i].contains(AbsoluteConst.JSON_KEY_FILENAME) || (stringSplit2 = stringSplit(stringSplit[i].trim(), "=")) == null)) {
                        String replace = stringSplit2[0].replace(JSUtil.QUOTE, "");
                        String replace2 = stringSplit2[1].replace(JSUtil.QUOTE, "");
                        if (!isEmpty(stringSplit2[1]) && isEquals(AbsoluteConst.JSON_KEY_FILENAME, replace) && !isEmpty(replace2)) {
                            str4 = replace2;
                            break;
                        }
                    }
                    i++;
                }
            }
        } catch (Exception unused) {
            Logger.d("PdrUtil.getDownloadFilename " + str + " not found filename");
        }
        if (isEmpty(str4)) {
            int lastIndexOf = str3.lastIndexOf(47);
            if (lastIndexOf == -1 || lastIndexOf >= str3.length() - 1) {
                str4 = String.valueOf(System.currentTimeMillis());
            } else {
                str4 = str3.substring(lastIndexOf + 1);
                int indexOf = str4.indexOf(Operators.CONDITION_IF_STRING);
                if (indexOf != -1) {
                    if (indexOf < str4.length() - 1) {
                        str4 = str4.substring(0, indexOf);
                    } else {
                        str4 = String.valueOf(System.currentTimeMillis());
                    }
                }
            }
        }
        if (!str4.contains(Operators.DOT_STR)) {
            String extensionFromMimeType = getExtensionFromMimeType(str2);
            if (!isEmpty(extensionFromMimeType)) {
                str4 = str4 + Operators.DOT_STR + extensionFromMimeType;
            }
        }
        try {
            String replaceAll = URLDecoder.decode(str4, "UTF-8").replaceAll(File.separator, "");
            if (replaceAll.contains(Operators.CONDITION_IF_STRING)) {
                replaceAll = replaceAll.replaceAll("\\?", WXInstanceApm.VALUE_ERROR_CODE_DEFAULT);
            }
            if (replaceAll.length() <= 80) {
                return replaceAll;
            }
            return replaceAll.substring(0, 80) + System.currentTimeMillis();
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return str4;
        }
    }

    public static String getExtensionFromMimeType(String str) {
        return MimeTypeMap.getSingleton().getExtensionFromMimeType(str);
    }

    public static String getFileNameByUrl(String str, String str2, String str3) {
        if (TextUtils.isEmpty(str2)) {
            Matcher matcher = Pattern.compile("[\\w\\.]+[\\.](" + "avi|mpeg|3gp|mp3|mp4|wav|jpeg|gif|jpg|png|apk|exe|pdf|rar|zip|docx|doc" + Operators.BRACKET_END_STR).matcher(str);
            if (matcher.find()) {
                return matcher.group();
            }
            if (!TextUtils.isEmpty(str3)) {
                return str3;
            }
            return String.valueOf(System.currentTimeMillis()) + ".dat";
        }
        String lastPathSegment = Uri.parse(str).getLastPathSegment();
        if (lastPathSegment != null && lastPathSegment.contains(str2)) {
            return lastPathSegment;
        }
        if (!TextUtils.isEmpty(str3)) {
            return str3;
        }
        return String.valueOf(System.currentTimeMillis()) + str2;
    }

    public static Object getKeyByIndex(HashMap hashMap, int i) {
        if (i < 0) {
            return null;
        }
        int i2 = 0;
        for (Object obj : hashMap.keySet()) {
            if (i == i2) {
                return obj;
            }
            i2++;
        }
        return null;
    }

    public static Object getKeyByValue(HashMap hashMap, Object obj, boolean z) {
        if (z && !hashMap.containsValue(obj)) {
            return null;
        }
        for (Object obj2 : hashMap.keySet()) {
            Object obj3 = hashMap.get(obj2);
            if (obj3 != null && obj3.equals(obj)) {
                return obj2;
            }
        }
        return null;
    }

    public static String getMimeType(String str) {
        MimeTypeMap singleton = MimeTypeMap.getSingleton();
        String fileExtensionFromUrl = MimeTypeMap.getFileExtensionFromUrl(str);
        if (isEmpty(fileExtensionFromUrl) && str.lastIndexOf(Operators.DOT_STR) >= 0) {
            fileExtensionFromUrl = str.substring(str.lastIndexOf(Operators.DOT_STR) + 1);
        }
        String mimeTypeFromExtension = singleton.getMimeTypeFromExtension(fileExtensionFromUrl);
        if (!TextUtils.isEmpty(mimeTypeFromExtension)) {
            return mimeTypeFromExtension;
        }
        if (TextUtils.isEmpty(fileExtensionFromUrl)) {
            return "*/*";
        }
        return "application/" + fileExtensionFromUrl;
    }

    private static String getNavBarOverride() {
        if (Build.VERSION.SDK_INT < 19) {
            return null;
        }
        try {
            Method declaredMethod = Class.forName("android.os.SystemProperties").getDeclaredMethod("get", String.class);
            declaredMethod.setAccessible(true);
            return (String) declaredMethod.invoke(null, "qemu.hw.mainkeys");
        } catch (Throwable unused) {
            return null;
        }
    }

    public static int getNavigationBarHeight(Context context) {
        Resources resources;
        int identifier;
        if (!hasNavBar(context) || (identifier = (resources = context.getResources()).getIdentifier("navigation_bar_height", "dimen", WXEnvironment.OS)) <= 0) {
            return 0;
        }
        return resources.getDimensionPixelSize(identifier);
    }

    public static String getNonString(String str, String str2) {
        return isEmpty(str) ? str2 : str;
    }

    public static Object getObject(Object[] objArr, int i) {
        try {
            return objArr[i];
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /* JADX WARNING: Removed duplicated region for block: B:102:0x0172 A[SYNTHETIC] */
    /* JADX WARNING: Removed duplicated region for block: B:106:0x0168 A[ADDED_TO_REGION, SYNTHETIC] */
    /* JADX WARNING: Removed duplicated region for block: B:55:0x015f A[ADDED_TO_REGION] */
    /* JADX WARNING: Removed duplicated region for block: B:97:0x0216 A[LOOP:1: B:16:0x0074->B:97:0x0216, LOOP_END] */
    public static JSONObject getSitemapParameters(JSONObject jSONObject, String str, String str2) {
        String optString;
        String str3;
        JSONArray jSONArray;
        String str4;
        JSONObject jSONObject2;
        JSONObject optJSONObject;
        JSONObject jSONObject3;
        String str5;
        JSONArray jSONArray2;
        String str6;
        JSONArray jSONArray3;
        String sb;
        String str7 = str2;
        String str8 = IjkMediaPlayer.OnNativeInvokeListener.ARG_PORT;
        String str9 = "matchUrls";
        String str10 = "webviewId";
        try {
            JSONArray optJSONArray = jSONObject.optJSONArray("pages");
            String optString2 = jSONObject.optString(IApp.ConfigProperty.CONFIG_LAUNCH_PATH);
            int i = 0;
            while (i < optJSONArray.length()) {
                JSONObject optJSONObject2 = optJSONArray.optJSONObject(i);
                if (optJSONObject2.has(str10)) {
                    optString = optJSONObject2.optString(str10);
                } else {
                    optString = optJSONObject2.optString("webviewid");
                }
                if (optJSONObject2.has(str9)) {
                    str3 = str9;
                    jSONArray = optJSONObject2.optJSONArray(str9);
                } else {
                    str3 = str9;
                    jSONArray = optJSONObject2.optJSONArray("matchurls");
                }
                int i2 = 0;
                boolean z = false;
                while (i2 < jSONArray.length()) {
                    Object opt = jSONArray.opt(i2);
                    if (opt instanceof String) {
                        z = match((String) opt, str7);
                    } else if (opt instanceof JSONObject) {
                        JSONObject jSONObject4 = (JSONObject) opt;
                        URL url = new URL(str7);
                        Iterator<String> keys = jSONObject4.keys();
                        while (true) {
                            if (!keys.hasNext()) {
                                break;
                            }
                            String next = keys.next();
                            if ("protocol".equals(next)) {
                                jSONArray2 = jSONObject4.optJSONArray("protocol");
                                str6 = url.getProtocol();
                            } else if ("hostname".equals(next)) {
                                jSONArray2 = jSONObject4.optJSONArray("hostname");
                                str6 = url.getHost();
                            } else {
                                if (str8.equals(next)) {
                                    jSONArray3 = jSONObject4.optJSONArray(str8);
                                    StringBuilder sb2 = new StringBuilder();
                                    str4 = str8;
                                    sb2.append("");
                                    sb2.append(url.getPort());
                                    sb = sb2.toString();
                                } else {
                                    str4 = str8;
                                    if ("host".equals(next)) {
                                        JSONArray optJSONArray2 = jSONObject4.optJSONArray("host");
                                        StringBuilder sb3 = new StringBuilder();
                                        jSONArray3 = optJSONArray2;
                                        sb3.append(url.getHost());
                                        sb3.append(":");
                                        sb3.append(url.getPort());
                                        sb = sb3.toString();
                                    } else {
                                        if (!"pathname".equals(next)) {
                                            if (!"search".equals(next)) {
                                                if (!"hash".equals(next)) {
                                                    if ("href".equals(next)) {
                                                        jSONArray2 = jSONObject4.optJSONArray("href");
                                                        str5 = str2;
                                                    } else {
                                                        jSONArray2 = null;
                                                        str5 = null;
                                                    }
                                                    if (jSONArray2 == null && str5 != null && !(z = matchArray(jSONArray2, str5))) {
                                                        break;
                                                    }
                                                    str8 = str4;
                                                } else {
                                                    jSONArray2 = jSONObject4.optJSONArray("hash");
                                                    str6 = url.getRef();
                                                }
                                            } else {
                                                jSONArray2 = jSONObject4.optJSONArray("search");
                                                str6 = url.getQuery();
                                            }
                                        } else {
                                            jSONArray2 = jSONObject4.optJSONArray("pathname");
                                            str6 = url.getPath();
                                        }
                                        str5 = str6;
                                        if (jSONArray2 == null) {
                                        }
                                        str8 = str4;
                                    }
                                }
                                str6 = sb;
                                jSONArray2 = jSONArray3;
                                str5 = str6;
                                if (jSONArray2 == null) {
                                }
                                str8 = str4;
                            }
                            str4 = str8;
                            str5 = str6;
                            if (jSONArray2 == null) {
                            }
                            str8 = str4;
                        }
                        if (!z) {
                            if (optJSONObject2.has("webviewParameter")) {
                                jSONObject2 = optJSONObject2.optJSONObject("webviewParameter");
                            } else {
                                jSONObject2 = optJSONObject2.optJSONObject("__html5plusWebviewParameter ");
                            }
                            if (jSONObject2 == null) {
                                jSONObject2 = new JSONObject();
                            }
                            JSONObject jSONObject5 = jSONObject2;
                            jSONObject5.put(IApp.ConfigProperty.CONFIG_LAUNCH_PATH, optString2);
                            jSONObject5.put("webviewid", optString);
                            jSONObject5.put("appid", str);
                            try {
                                if (jSONObject.has("global") && (optJSONObject = jSONObject.optJSONObject("global")) != null) {
                                    if (optJSONObject.has("webviewParameter")) {
                                        jSONObject3 = optJSONObject.optJSONObject("webviewParameter");
                                    } else {
                                        jSONObject3 = optJSONObject.optJSONObject("__html5plusWebviewParameter ");
                                    }
                                    if (jSONObject3 != null) {
                                        jSONObject5 = JSONUtil.combinSitemapHtmlJSONObject(new JSONObject(jSONObject3.toString()), jSONObject5);
                                    }
                                    if (!jSONObject5.has(AbsoluteConst.JSONKEY_STATUSBAR) && optJSONObject.has(AbsoluteConst.JSONKEY_STATUSBAR) && !optJSONObject.isNull(AbsoluteConst.JSONKEY_STATUSBAR)) {
                                        jSONObject5.put(AbsoluteConst.JSONKEY_STATUSBAR, new JSONObject(optJSONObject.optJSONObject(AbsoluteConst.JSONKEY_STATUSBAR).toString()));
                                    }
                                }
                                if (!jSONObject5.has(AbsoluteConst.JSONKEY_STATUSBAR) && jSONObject.has(AbsoluteConst.JSONKEY_STATUSBAR) && !jSONObject.isNull(AbsoluteConst.JSONKEY_STATUSBAR)) {
                                    jSONObject5.put(AbsoluteConst.JSONKEY_STATUSBAR, new JSONObject(jSONObject.optJSONObject(AbsoluteConst.JSONKEY_STATUSBAR).toString()));
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                            return jSONObject5;
                        }
                        i2++;
                        jSONArray = jSONArray;
                        str8 = str4;
                        str7 = str2;
                    }
                    str4 = str8;
                    if (!z) {
                    }
                }
                i++;
                str9 = str3;
                str10 = str10;
                optJSONArray = optJSONArray;
                str7 = str2;
            }
            return null;
        } catch (Exception e2) {
            Logger.e("PdrUtil", "getSitemapParameters e==" + e2.getMessage());
            return null;
        }
    }

    public static String getUrlPathName(String str) {
        return str != null ? URLUtil.stripAnchor(stripQuery(str)) : str;
    }

    public static boolean hasNavBar(Context context) {
        Resources resources = context.getResources();
        int identifier = resources.getIdentifier("config_showNavigationBar", "bool", WXEnvironment.OS);
        if (identifier == 0) {
            return !ViewConfiguration.get(context).hasPermanentMenuKey();
        }
        boolean z = resources.getBoolean(identifier);
        String navBarOverride = getNavBarOverride();
        if ("1".equals(navBarOverride)) {
            return false;
        }
        if (WXInstanceApm.VALUE_ERROR_CODE_DEFAULT.equals(navBarOverride)) {
            return true;
        }
        return z;
    }

    public static String int2DecimalStr(int i, int i2) {
        return String.valueOf(BigDecimal.valueOf((long) i).divide(BigDecimal.valueOf((long) i2)));
    }

    public static boolean isAllScreenDevice(Activity activity) {
        float f;
        float f2;
        if (mHasCheckAllScreen) {
            return mIsAllScreenDevice;
        }
        mHasCheckAllScreen = true;
        mIsAllScreenDevice = false;
        int i = Build.VERSION.SDK_INT;
        if (i < 21) {
            return false;
        }
        if (i < 28 || activity.getWindow().getDecorView().getRootWindowInsets() == null || activity.getWindow().getDecorView().getRootWindowInsets().getDisplayCutout() == null) {
            WindowManager windowManager = (WindowManager) activity.getSystemService("window");
            if (windowManager != null) {
                Display defaultDisplay = windowManager.getDefaultDisplay();
                Point point = new Point();
                defaultDisplay.getRealSize(point);
                int i2 = point.x;
                int i3 = point.y;
                if (i2 < i3) {
                    f = (float) i2;
                    f2 = (float) i3;
                } else {
                    float f3 = (float) i3;
                    f2 = (float) i2;
                    f = f3;
                }
                if (f2 / f >= 1.97f) {
                    mIsAllScreenDevice = true;
                }
            }
            return mIsAllScreenDevice;
        }
        mIsAllScreenDevice = true;
        return mIsAllScreenDevice;
    }

    public static boolean isBase64ImagePath(String str) {
        return !TextUtils.isEmpty(str) && str.startsWith("data:image");
    }

    public static boolean isContains(String str, String str2) {
        if (!isEmpty(str) && !isEmpty(str2)) {
            return str.contains(str2);
        }
        return false;
    }

    public static boolean isDeviceRootDir(String str) {
        try {
            return str.startsWith(DeviceInfo.sDeviceRootDir) || str.startsWith(DeviceInfo.sCacheRootDir) || str.startsWith("/sdcard/") || str.startsWith(DeviceInfo.sDeviceRootDir.substring(1)) || str.startsWith("sdcard/");
        } catch (Exception unused) {
            return false;
        }
    }

    public static boolean isEmpty(Object obj) {
        return obj == null || obj.equals("") || (obj.toString().length() == 4 && obj.toString().toLowerCase(Locale.ENGLISH).equals("null"));
    }

    public static boolean isEquals(String str, String str2) {
        if (str == null || str2 == null) {
            return false;
        }
        return str.equalsIgnoreCase(str2);
    }

    public static boolean isFilePath(String str) {
        return !TextUtils.isEmpty(str) && str.startsWith("file:/");
    }

    public static boolean isFullScreen(Activity activity) {
        return (activity.getWindow().getAttributes().flags & 1024) == 1024;
    }

    public static boolean isLightColor(int i) {
        double red = (double) Color.red(i);
        Double.isNaN(red);
        double green = (double) Color.green(i);
        Double.isNaN(green);
        double d = (red * 0.299d) + (green * 0.587d);
        double blue = (double) Color.blue(i);
        Double.isNaN(blue);
        return ((int) (d + (blue * 0.114d))) >= 192;
    }

    public static boolean isNavigationBarExist(Activity activity) {
        ViewGroup viewGroup = (ViewGroup) activity.getWindow().getDecorView();
        if (viewGroup != null) {
            for (int i = 0; i < viewGroup.getChildCount(); i++) {
                viewGroup.getChildAt(i).getContext().getPackageName();
                try {
                    if (viewGroup.getChildAt(i).getId() != -1 && NAVIGATION.equals(activity.getResources().getResourceEntryName(viewGroup.getChildAt(i).getId())) && viewGroup.getChildAt(i).getVisibility() == 0) {
                        return true;
                    }
                } catch (Exception unused) {
                }
            }
        }
        return false;
    }

    public static boolean isNavigationBarShow(Activity activity) {
        if (Build.VERSION.SDK_INT >= 17) {
            Display defaultDisplay = activity.getWindowManager().getDefaultDisplay();
            Point point = new Point();
            Point point2 = new Point();
            defaultDisplay.getSize(point);
            defaultDisplay.getRealSize(point2);
            if (point2.y != point.y) {
                return true;
            }
            return false;
        }
        return !ViewConfiguration.get(activity).hasPermanentMenuKey() && !KeyCharacterMap.deviceHasKey(4);
    }

    /* JADX WARNING: Removed duplicated region for block: B:17:0x0043 A[ORIG_RETURN, RETURN, SYNTHETIC] */
    /* JADX WARNING: Removed duplicated region for block: B:20:? A[RETURN, SYNTHETIC] */
    public static boolean isNavigationBarShowing(Context context) {
        String str;
        if (!hasNavBar(context) || Build.VERSION.SDK_INT < 17) {
            return false;
        }
        String str2 = Build.BRAND;
        if (!str2.equalsIgnoreCase("HUAWEI")) {
            if (str2.equalsIgnoreCase("XIAOMI")) {
                str = "force_fsg_nav_bar";
            } else if (str2.equalsIgnoreCase("VIVO") || str2.equalsIgnoreCase("OPPO")) {
                str = "navigation_gesture_on";
            }
            if (Settings.Global.getInt(context.getContentResolver(), str, 0) != 0) {
                return true;
            }
            return false;
        }
        str = "navigationbar_is_min";
        if (Settings.Global.getInt(context.getContentResolver(), str, 0) != 0) {
        }
    }

    public static boolean isNetPath(String str) {
        return str != null && ((str.startsWith(DeviceInfo.HTTP_PROTOCOL) && !str.startsWith("http://localhost")) || ((str.startsWith(DeviceInfo.HTTPS_PROTOCOL) && !str.startsWith("https://localhost")) || ((str.startsWith("rtmp://") && !str.startsWith("rtmp://localhost")) || (str.startsWith("rtsp://") && !str.startsWith("rtsp://localhost")))));
    }

    public static boolean isSafeEntryName(String str) {
        return !str.contains(FILE_PATH_ENTRY_BACK) && !str.contains("%");
    }

    public static boolean isSameDay(long j, long j2) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeInMillis(j);
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        gregorianCalendar2.setTimeInMillis(j2);
        if (gregorianCalendar.get(1) == gregorianCalendar2.get(1) && gregorianCalendar.get(2) == gregorianCalendar2.get(2) && gregorianCalendar.get(5) == gregorianCalendar2.get(5)) {
            return true;
        }
        return false;
    }

    public static boolean isSupportOaid() {
        String str = Build.BRAND;
        int i = Build.VERSION.SDK_INT;
        if ((str.equalsIgnoreCase("honor") || str.equalsIgnoreCase("huawei")) && i >= 23) {
            return true;
        }
        if (str.equalsIgnoreCase("vivo") && i >= 28) {
            return true;
        }
        if ((!str.equalsIgnoreCase("xiaomi") || i < 28) && i < 29) {
            return false;
        }
        return true;
    }

    public static boolean isUniMPHostForUniApp() {
        return PlatformUtil.checkClass("io.dcloud.feature.sdk.Interface.DCUniAppHost");
    }

    private static void loadProperties2HashMap(HashMap<String, String> hashMap, String str) {
        InputStream resInputStream = PlatformUtil.getResInputStream(str);
        Properties properties = new Properties();
        try {
            properties.load(resInputStream);
            Enumeration<?> propertyNames = properties.propertyNames();
            if (propertyNames != null) {
                while (propertyNames.hasMoreElements()) {
                    String str2 = (String) propertyNames.nextElement();
                    hashMap.put(str2.toLowerCase(Locale.ENGLISH), (String) properties.get(str2));
                }
            }
        } catch (IOException e) {
            e.printStackTrace();
        } catch (Throwable th) {
            IOUtil.close(resInputStream);
            throw th;
        }
        IOUtil.close(resInputStream);
    }

    public static String makeQueryStringAllRegExp(String str) {
        if (TextUtils.isEmpty(str)) {
            return str;
        }
        return str.replace("\\", "\\\\").replace("*", "\\*").replace(Operators.PLUS, "\\+").replace("|", "\\|").replace(Operators.BLOCK_START_STR, "\\{").replace(Operators.BLOCK_END_STR, "\\}").replace(Operators.BRACKET_START_STR, "\\(").replace(Operators.BRACKET_END_STR, "\\)").replace("^", "\\^").replace(Operators.DOLLAR_STR, "\\$").replace(Operators.ARRAY_START_STR, "\\[").replace(Operators.ARRAY_END_STR, "\\]").replace(Operators.CONDITION_IF_STRING, "\\?").replace(",", "\\,").replace(Operators.DOT_STR, "\\.").replace("&", "\\&").replace("'", "\\'");
    }

    private static boolean match(String str, String str2) {
        return Pattern.compile(str).matcher(str2).find();
    }

    private static boolean matchArray(JSONArray jSONArray, String str) {
        if (jSONArray != null) {
            for (int i = 0; i < jSONArray.length(); i++) {
                if (match(jSONArray.optString(i), str)) {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean navigationGestureEnabled(Context context) {
        int i;
        if (DeviceInfo.sBrand.toLowerCase(Locale.ENGLISH).equals("xiaomi")) {
            i = Build.VERSION.SDK_INT >= 26 ? Settings.Global.getInt(context.getContentResolver(), "force_fsg_nav_bar", 0) : 0;
        } else {
            i = Settings.Secure.getInt(context.getContentResolver(), "navigation_gesture_on", 0);
        }
        if (i != 0) {
            return true;
        }
        return false;
    }

    public static boolean parseBoolean(String str, boolean z, boolean z2) {
        if (isEmpty(str)) {
            return z;
        }
        if (str.equalsIgnoreCase(AbsoluteConst.TRUE)) {
            return (!z2) & true;
        }
        return str.equalsIgnoreCase(AbsoluteConst.FALSE) ? z2 | false : z;
    }

    public static float parseFloat(String str, float f) {
        if (str == null) {
            return f;
        }
        try {
            return Float.parseFloat(str);
        } catch (Exception unused) {
            return f;
        }
    }

    public static int parseInt(String str, int i) {
        if (str == null) {
            return i;
        }
        try {
            return Integer.parseInt(str);
        } catch (Exception unused) {
            return i;
        }
    }

    public static long parseLong(String str, long j) {
        try {
            return Long.parseLong(str);
        } catch (Exception unused) {
            return j;
        }
    }

    public static int pxFromDp(float f, DisplayMetrics displayMetrics) {
        return Math.round(TypedValue.applyDimension(1, f, displayMetrics));
    }

    public static int pxFromSp(float f, DisplayMetrics displayMetrics) {
        return Math.round(TypedValue.applyDimension(2, f, displayMetrics));
    }

    public static Bitmap renderCroppedGreyscaleBitmap(byte[] bArr, int i, int i2, int i3, int i4, int i5, int i6) {
        int[] iArr = new int[(i5 * i6)];
        int i7 = (i4 * i) + i3;
        for (int i8 = 0; i8 < i6; i8++) {
            int i9 = i8 * i5;
            for (int i10 = 0; i10 < i5; i10++) {
                iArr[i9 + i10] = ((bArr[i7 + i10] & IApp.ABS_PRIVATE_WWW_DIR_APP_MODE) * 65793) | -16777216;
            }
            i7 += i;
        }
        Bitmap createBitmap = Bitmap.createBitmap(i5, i6, Bitmap.Config.ARGB_8888);
        createBitmap.setPixels(iArr, 0, i5, 0, 0, i5, i6);
        return createBitmap;
    }

    public static boolean saveBitmapToFile(Bitmap bitmap, String str) {
        try {
            File file = new File(str);
            File parentFile = file.getParentFile();
            if (!parentFile.exists()) {
                parentFile.mkdirs();
            }
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, new FileOutputStream(file));
            return true;
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String standardizedURL(String str, String str2) {
        String stripQuery = stripQuery(stripAnchor(str));
        boolean z = true;
        if (str2.startsWith("./")) {
            str2 = str2.substring(2);
            int lastIndexOf = stripQuery.lastIndexOf(47);
            if (lastIndexOf >= 0) {
                return stripQuery.substring(0, lastIndexOf + 1) + str2;
            }
        }
        int indexOf = str2.indexOf("../");
        int lastIndexOf2 = stripQuery.lastIndexOf(47);
        if (lastIndexOf2 <= -1) {
            z = false;
        }
        if (!z) {
            return str2;
        }
        String substring = stripQuery.substring(0, lastIndexOf2);
        while (indexOf > -1) {
            str2 = str2.substring(3);
            substring = substring.substring(0, substring.lastIndexOf(47));
            indexOf = str2.indexOf("../");
        }
        return substring + '/' + str2;
    }

    public static String[] stringSplit(String str, String str2) {
        if (TextUtils.isEmpty(str) || TextUtils.isEmpty(str2)) {
            return null;
        }
        int i = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(str, str2, false);
        String[] strArr = new String[stringTokenizer.countTokens()];
        while (stringTokenizer.hasMoreElements()) {
            strArr[i] = stringTokenizer.nextToken().trim();
            i++;
        }
        return strArr;
    }

    public static int stringToColor(String str) {
        boolean z;
        int i;
        int i2;
        int i3;
        try {
            if (!isEmpty(str)) {
                str = str.trim();
            }
            int length = str.length();
            if (!(length == 4 || length == 7 || length == 3)) {
                if (length != 6) {
                    if (str.startsWith("#") && length > 1 && length < 10) {
                        return Color.parseColor(str);
                    }
                    String[] strArr = null;
                    if (str.startsWith("rgba")) {
                        strArr = stringSplit(str.substring(5, str.length() - 1), ",");
                        z = true;
                    } else {
                        if (str.startsWith("rgb")) {
                            strArr = stringSplit(str.substring(4, str.length() - 1), ",");
                        }
                        z = false;
                    }
                    int i4 = 255;
                    if (strArr != null) {
                        if (!z) {
                            try {
                                i = Integer.parseInt(strArr[0]);
                                try {
                                    i2 = Integer.parseInt(strArr[1]);
                                    try {
                                        i3 = Integer.parseInt(strArr[2]);
                                    } catch (Exception unused) {
                                        i3 = 255;
                                    }
                                } catch (Exception unused2) {
                                }
                            } catch (Exception unused3) {
                            }
                        } else {
                            i = Integer.parseInt(strArr[0]);
                            i2 = Integer.parseInt(strArr[1]);
                            i3 = Integer.parseInt(strArr[2]);
                            try {
                                i4 = (int) (((float) 255) * Float.parseFloat(strArr[3]));
                            } catch (Exception unused4) {
                            }
                        }
                        return (i4 << 24) + (i << 16) + (i2 << 8) + i3;
                    }
                    i = 255;
                    i3 = 255;
                    i2 = 255;
                    return (i4 << 24) + (i << 16) + (i2 << 8) + i3;
                }
            }
            if (length == 4 || length == 7) {
                str = str.substring(1);
            }
            if (str.length() == 3) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i5 = 0; i5 < 3; i5++) {
                    stringBuffer.append(str.charAt(i5));
                    stringBuffer.append(str.charAt(i5));
                }
                str = stringBuffer.toString();
            }
            return Integer.parseInt(str, 16) - 16777216;
        } catch (Exception unused5) {
            return -1;
        }
    }

    public static String stripAnchor(String str) {
        return URLUtil.stripAnchor(str);
    }

    public static String stripQuery(String str) {
        int indexOf = str.indexOf(63);
        return indexOf != -1 ? str.substring(0, indexOf) : str;
    }

    public static String toHexFromColor(int i) {
        StringBuilder sb = new StringBuilder();
        String hexString = Integer.toHexString(Color.red(i));
        String hexString2 = Integer.toHexString(Color.green(i));
        String hexString3 = Integer.toHexString(Color.blue(i));
        if (hexString.length() == 1) {
            hexString = WXInstanceApm.VALUE_ERROR_CODE_DEFAULT + hexString;
        }
        if (hexString2.length() == 1) {
            hexString2 = WXInstanceApm.VALUE_ERROR_CODE_DEFAULT + hexString2;
        }
        if (hexString3.length() == 1) {
            hexString3 = WXInstanceApm.VALUE_ERROR_CODE_DEFAULT + hexString3;
        }
        String upperCase = hexString.toUpperCase();
        String upperCase2 = hexString2.toUpperCase();
        String upperCase3 = hexString3.toUpperCase();
        sb.append("#");
        sb.append(upperCase);
        sb.append(upperCase2);
        sb.append(upperCase3);
        return sb.toString();
    }

    public static void toast(Context context, String str, Bitmap bitmap) {
        ToastCompat makeText = ToastCompat.makeText(context, (CharSequence) str, 1);
        if (bitmap != null) {
            int height = bitmap.getHeight();
            int width = bitmap.getWidth();
            View view = makeText.getView();
            ImageView imageView = new ImageView(context);
            imageView.setImageBitmap(bitmap);
            ((ViewGroup) view).addView(imageView, 0);
            makeText.setText(str + " w=" + width + ";h=" + height);
        }
        makeText.setDuration(1);
        makeText.show();
    }

    public static int convertToScreenInt(String str, int i, int i2, float f, boolean z) {
        float f2;
        if (str == null) {
            return i2;
        }
        try {
            if (str.endsWith("px")) {
                String substring = str.substring(0, str.length() - 2);
                if (substring == null || !substring.contains(Operators.DOT_STR)) {
                    f2 = (float) Integer.parseInt(substring);
                } else {
                    f2 = Float.parseFloat(substring);
                }
                float f3 = f2 * f;
                return z ? Math.round(f3) : (int) f3;
            } else if (str.endsWith("%")) {
                String substring2 = str.substring(0, str.length() - 1);
                try {
                    if (!substring2.contains(Operators.DOT_STR)) {
                        return (i * Integer.parseInt(substring2)) / 100;
                    }
                    float parseFloat = (((float) i) * Float.parseFloat(substring2)) / 100.0f;
                    return z ? Math.round(parseFloat) : (int) parseFloat;
                } catch (NumberFormatException unused) {
                    return i2;
                }
            } else {
                double parseDouble = Double.parseDouble(str);
                double d = (double) f;
                Double.isNaN(d);
                double d2 = parseDouble * d;
                return z ? (int) Math.round(d2) : (int) d2;
            }
        } catch (Exception unused2) {
            return i2;
        }
    }

    public static float parseFloat(String str, float f, float f2) {
        return parseFloat(str, f, f2, 1.0f);
    }

    public static int parseInt(String str, int i, int i2) {
        if (str == null) {
            return i2;
        }
        try {
            String lowerCase = str.toLowerCase(Locale.ENGLISH);
            if (lowerCase.endsWith("px")) {
                return Integer.parseInt(lowerCase.substring(0, lowerCase.length() - 2));
            }
            if (lowerCase.endsWith("%")) {
                String substring = lowerCase.substring(0, lowerCase.length() - 1);
                try {
                    if (substring.contains(Operators.DOT_STR)) {
                        return (int) ((((float) i) * Float.parseFloat(substring)) / 100.0f);
                    }
                    return (i * Integer.parseInt(substring)) / 100;
                } catch (NumberFormatException unused) {
                    return i2;
                }
            } else {
                if (lowerCase.startsWith("#")) {
                    lowerCase = "0x" + lowerCase.substring(1);
                }
                if (lowerCase.startsWith("0x")) {
                    return Integer.valueOf(lowerCase.substring(2), 16).intValue();
                }
                return Integer.parseInt(lowerCase);
            }
        } catch (Exception unused2) {
            return i2;
        }
    }

    public static float parseFloat(String str, float f, float f2, float f3) {
        if (str == null) {
            return f2;
        }
        String lowerCase = str.toLowerCase(Locale.ENGLISH);
        if (lowerCase.endsWith("px")) {
            lowerCase = lowerCase.substring(0, lowerCase.length() - 2);
        }
        try {
            return Float.parseFloat(lowerCase) * f3;
        } catch (NumberFormatException unused) {
            if (lowerCase.endsWith("%")) {
                try {
                    return (f * Float.parseFloat(lowerCase.substring(0, lowerCase.length() - 1))) / 100.0f;
                } catch (Exception unused2) {
                    return f2;
                }
            }
            return f2;
        }
    }

    public static boolean parseBoolean(String str, boolean z) {
        if (isEmpty(str)) {
            return z;
        }
        return str.equalsIgnoreCase(AbsoluteConst.TRUE);
    }

    public static Object getKeyByValue(HashMap hashMap, Object obj) {
        return getKeyByValue(hashMap, obj, false);
    }

    public static void loadProperties2HashMap(HashMap<String, String> hashMap, HashMap<String, String> hashMap2, HashMap<String, HashMap<String, String>> hashMap3, String str) {
        XmlUtil.DHNode XML_Parser;
        InputStream resInputStream = PlatformUtil.getResInputStream(str);
        if (resInputStream != null && (XML_Parser = XmlUtil.XML_Parser(resInputStream)) != null) {
            ArrayList<XmlUtil.DHNode> elements = XmlUtil.getElements(XmlUtil.getElement(XML_Parser, IApp.ConfigProperty.CONFIG_FEATURES), IApp.ConfigProperty.CONFIG_FEATURE);
            if (elements != null && !elements.isEmpty()) {
                Iterator<XmlUtil.DHNode> it = elements.iterator();
                while (it.hasNext()) {
                    XmlUtil.DHNode next = it.next();
                    String lowerCase = XmlUtil.getAttributeValue(next, "name").toLowerCase(Locale.ENGLISH);
                    String attributeValue = XmlUtil.getAttributeValue(next, "value");
                    if (AbsoluteConst.F_UI.equals(lowerCase)) {
                        hashMap2.put("webview", attributeValue);
                    }
                    hashMap2.put(lowerCase, attributeValue);
                    ArrayList<XmlUtil.DHNode> elements2 = XmlUtil.getElements(next, "module");
                    if (elements2 != null && !elements2.isEmpty()) {
                        HashMap<String, String> hashMap4 = hashMap3.get(lowerCase);
                        if (hashMap4 == null) {
                            hashMap4 = new LinkedHashMap<>(2);
                            hashMap3.put(lowerCase, hashMap4);
                        }
                        Iterator<XmlUtil.DHNode> it2 = elements2.iterator();
                        while (it2.hasNext()) {
                            XmlUtil.DHNode next2 = it2.next();
                            hashMap4.put(XmlUtil.getAttributeValue(next2, "name").toLowerCase(Locale.ENGLISH), XmlUtil.getAttributeValue(next2, "value"));
                        }
                    }
                }
            }
            ArrayList<XmlUtil.DHNode> elements3 = XmlUtil.getElements(XmlUtil.getElement(XML_Parser, IApp.ConfigProperty.CONFIG_SERVICES), "service");
            if (elements3 != null && !elements3.isEmpty()) {
                Iterator<XmlUtil.DHNode> it3 = elements3.iterator();
                while (it3.hasNext()) {
                    XmlUtil.DHNode next3 = it3.next();
                    hashMap.put(XmlUtil.getAttributeValue(next3, "name").toLowerCase(Locale.ENGLISH), XmlUtil.getAttributeValue(next3, "value"));
                }
            }
        }
    }
}
