package io.dcloud.common.util;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.text.TextUtils;
import io.dcloud.common.adapter.io.DHFile;
import io.dcloud.common.adapter.util.DCloudTrustManager;
import io.dcloud.common.adapter.util.Logger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

public class NetTool {
    private static final int DEFAULT_TIME_OUT_TIMES = 5000;
    private static String TAG = "NetTool";
    static HostnameVerifier sCustomeHostnameVerifier;

    public static HttpURLConnection createConnection(URL url, String str, int i, boolean z, boolean z2) {
        HttpURLConnection httpURLConnection;
        try {
            if (BaseInfo.isUniStatistics) {
                z2 = false;
            }
            if (!z2 || DHFile.hasFile()) {
                httpURLConnection = (HttpURLConnection) url.openConnection();
            } else {
                httpURLConnection = (HttpURLConnection) url.openConnection(Proxy.NO_PROXY);
            }
            if ((httpURLConnection instanceof HttpsURLConnection) && z) {
                try {
                    SSLSocketFactory sSLSocketFactory = DCloudTrustManager.getSSLSocketFactory();
                    if (sSLSocketFactory != null) {
                        ((HttpsURLConnection) httpURLConnection).setSSLSocketFactory(sSLSocketFactory);
                    }
                    ((HttpsURLConnection) httpURLConnection).setHostnameVerifier(getDefaultHostnameVerifier());
                } catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            httpURLConnection.setConnectTimeout(i);
            httpURLConnection.setReadTimeout(i);
            httpURLConnection.setRequestMethod(str);
            httpURLConnection.setDoInput(true);
            return httpURLConnection;
        } catch (IOException e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public static HostnameVerifier getDefaultHostnameVerifier() {
        HostnameVerifier hostnameVerifier = sCustomeHostnameVerifier;
        return hostnameVerifier != null ? hostnameVerifier : DCloudTrustManager.getHostnameVerifier(true);
    }

    public static byte[] httpGet(String str, HashMap<String, String> hashMap) throws Exception {
        return request(str, null, hashMap, "GET", 5000, true);
    }

    public static byte[] httpGetThrows(String str) throws Exception {
        return httpGet(str, (HashMap<String, String>) null);
    }

    public static byte[] httpPost(String str, String str2, HashMap<String, String> hashMap) {
        return request(str, str2, hashMap, "POST", 5000, true);
    }

    public static boolean isNetworkAvailable(Context context) {
        NetworkInfo[] allNetworkInfo;
        ConnectivityManager connectivityManager = (ConnectivityManager) context.getSystemService("connectivity");
        if (!(connectivityManager == null || (allNetworkInfo = connectivityManager.getAllNetworkInfo()) == null)) {
            for (int i = 0; i < allNetworkInfo.length; i++) {
                if (allNetworkInfo[i].getState() == NetworkInfo.State.CONNECTED || allNetworkInfo[i].getState() == NetworkInfo.State.CONNECTING) {
                    return true;
                }
            }
        }
        return false;
    }

    private static byte[] read(InputStream inputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int i = 10240;
            int min = Math.min(10240, inputStream.available());
            if (min > 0) {
                i = min;
            }
            byte[] bArr = new byte[i];
            while (true) {
                int read = inputStream.read(bArr);
                if (read <= 0) {
                    break;
                }
                byteArrayOutputStream.write(bArr, 0, read);
            }
            inputStream.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static byte[] request(String str, String str2, HashMap<String, String> hashMap, String str3, int i, boolean z) {
        return request(str, str2, hashMap, str3, i, z, false, null);
    }

    private static void write(OutputStream outputStream, String str) {
        if (str != null) {
            try {
                if (str.length() > 0) {
                    outputStream.write(str.getBytes("UTF-8"));
                }
            } catch (IOException unused) {
            }
        }
    }

    public static byte[] httpGet(String str, HashMap<String, String> hashMap, boolean z) throws Exception {
        return request(str, null, hashMap, "GET", 5000, z);
    }

    public static byte[] httpGetThrows(String str, boolean z) throws Exception {
        return httpGet(str, (HashMap<String, String>) null, z);
    }

    public static byte[] httpPost(String str, String str2, HashMap<String, String> hashMap, boolean z) {
        return request(str, str2, hashMap, "POST", 5000, z);
    }

    private static byte[] request(String str, String str2, HashMap<String, String> hashMap, String str3, int i, boolean z, boolean z2) {
        return request(str, str2, hashMap, str3, i, z, z2, null);
    }

    public static byte[] httpGet(String str, HashMap<String, String> hashMap, int i) throws Exception {
        return request(str, null, hashMap, "GET", i, true);
    }

    public static byte[] httpPost(String str, String str2, HashMap<String, String> hashMap, boolean z, boolean z2) {
        return request(str, str2, hashMap, "POST", 5000, z, z2);
    }

    private static byte[] request(String str, String str2, HashMap<String, String> hashMap, String str3, int i, boolean z, boolean z2, String[] strArr) {
        if (str == null || str.length() == 0) {
            Logger.p(TAG, "httpPost, url is null");
            return null;
        }
        try {
            HttpURLConnection createConnection = createConnection(new URL(str), str3, i, z, z2);
            if (hashMap != null && !hashMap.isEmpty()) {
                for (String str4 : hashMap.keySet()) {
                    createConnection.setRequestProperty(str4, hashMap.get(str4));
                }
            }
            if (!TextUtils.isEmpty(str3) && TextUtils.equals(str3.toLowerCase(Locale.ENGLISH), "post")) {
                write(createConnection.getOutputStream(), str2);
            }
            int responseCode = createConnection.getResponseCode();
            if (responseCode == 200) {
                return read(createConnection.getInputStream());
            }
            String str5 = TAG;
            Logger.p(str5, "httpGet fail, status code = " + responseCode);
            if (strArr != null) {
                strArr[0] = String.valueOf(responseCode);
            }
            return null;
        } catch (Exception e) {
            String str6 = TAG;
            Logger.p(str6, "httpPost exception, e = " + e.getMessage());
            if (strArr != null) {
                strArr[0] = e.getMessage();
            }
            return null;
        }
    }

    public static byte[] httpGet(String str, HashMap<String, String> hashMap, int i, boolean z) throws Exception {
        return request(str, null, hashMap, "GET", i, z);
    }

    public static byte[] httpPost(String str, String str2, HashMap<String, String> hashMap, boolean z, String[] strArr) {
        return request(str, str2, hashMap, "POST", 5000, z, false, strArr);
    }

    public static byte[] httpGet(String str) {
        return httpGet(str, true);
    }

    public static byte[] httpPost(String str, String str2, HashMap<String, String> hashMap, boolean z, boolean z2, String[] strArr) {
        return request(str, str2, hashMap, "POST", 5000, z, z2, strArr);
    }

    public static byte[] httpGet(String str, boolean z) {
        try {
            return httpGet(str, (HashMap<String, String>) null, z);
        } catch (Exception e) {
            String str2 = TAG;
            Logger.p(str2, "httpGet exception, e = " + e.getMessage());
            return null;
        }
    }

    public static byte[] httpPost(String str, String str2, HashMap<String, String> hashMap, int i) {
        return request(str, str2, hashMap, "POST", i, true);
    }

    public static byte[] httpPost(String str, String str2, HashMap<String, String> hashMap, int i, boolean z) {
        return request(str, str2, hashMap, "POST", i, z);
    }

    public static byte[] httpGet(String str, int i) {
        return httpGet(str, i, true);
    }

    public static byte[] httpGet(String str, int i, boolean z) {
        try {
            return httpGet(str, null, i, z);
        } catch (Exception e) {
            String str2 = TAG;
            Logger.p(str2, "httpGet exception, e = " + e.getMessage());
            return null;
        }
    }
}
