package io.dcloud.common.util;

import android.text.TextUtils;
import io.dcloud.application.DCLoudApplicationImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Md5Utils {
    public static final String ALGORITHM = "MD5";
    public static final String DEFAULT_CHARSET = "UTF-8";
    private static final char[] HEX = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final char[] HEX_LOWER_CASE = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String md5(String str) {
        try {
            MessageDigest instance = MessageDigest.getInstance(ALGORITHM);
            instance.update(str.getBytes("UTF-8"));
            return toHex(instance.digest());
        } catch (UnsupportedEncodingException | Exception | NoSuchAlgorithmException unused) {
            return str;
        }
    }

    public static String md5LowerCase(String str) {
        if (TextUtils.isEmpty(str)) {
            return "";
        }
        try {
            MessageDigest instance = MessageDigest.getInstance(ALGORITHM);
            instance.update(str.getBytes("UTF-8"));
            return toLowerCaseHex(instance.digest());
        } catch (UnsupportedEncodingException | Exception | NoSuchAlgorithmException unused) {
            return str;
        }
    }

    public static String md5LowerCase32Bit(String str) {
        try {
            byte[] bytes = str.getBytes();
            MessageDigest instance = MessageDigest.getInstance(ALGORITHM);
            instance.update(bytes);
            byte[] digest = instance.digest();
            int length = digest.length;
            char[] cArr = new char[(length * 2)];
            int i = 0;
            for (byte b : digest) {
                int i2 = i + 1;
                char[] cArr2 = HEX;
                cArr[i] = cArr2[(b >>> 4) & 15];
                i = i2 + 1;
                cArr[i2] = cArr2[b & 15];
            }
            return new String(cArr);
        } catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private static String toHex(byte[] bArr) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bArr) {
            char[] cArr = HEX;
            sb.append(cArr[(b & 240) >> 4]);
            sb.append(cArr[b & 15]);
        }
        return sb.toString();
    }

    private static String toLowerCaseHex(byte[] bArr) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bArr) {
            char[] cArr = HEX_LOWER_CASE;
            sb.append(cArr[(b & 240) >> 4]);
            sb.append(cArr[b & 15]);
        }
        return sb.toString();
    }

    public static boolean verifyFileMd5(String str, String str2) {
        String md5;
        return str.length() > 0 && (md5 = md5(new File(str))) != null && str2 != null && md5.compareToIgnoreCase(str2) == 0;
    }

    public static String md5(byte[] bArr) {
        try {
            MessageDigest instance = MessageDigest.getInstance(ALGORITHM);
            instance.update(bArr);
            return toHex(instance.digest());
        } catch (NoSuchAlgorithmException unused) {
            return "";
        }
    }

    public static String md5(File file) {
        return md5(file, ALGORITHM);
    }

    /* JADX WARNING: Removed duplicated region for block: B:24:0x0054 A[SYNTHETIC, Splitter:B:24:0x0054] */
    /* JADX WARNING: Removed duplicated region for block: B:32:0x0061 A[SYNTHETIC, Splitter:B:32:0x0061] */
    public static String md5(File file, String str) {
        Throwable th;
        Exception e;
        InputStream inputStream;
        byte[] bArr = new byte[1024];
        InputStream inputStream2 = null;
        try {
            if (FileUtil.checkPrivatePath(DCLoudApplicationImpl.self().getContext(), file.getPath())) {
                inputStream = new FileInputStream(file);
            } else {
                inputStream = FileUtil.getFileInputStream(DCLoudApplicationImpl.self().getContext(), file);
            }
            try {
                MessageDigest instance = MessageDigest.getInstance(str);
                while (true) {
                    int read = inputStream.read(bArr);
                    if (read <= 0) {
                        break;
                    }
                    instance.update(bArr, 0, read);
                }
                String hex = toHex(instance.digest());
                try {
                    inputStream.close();
                } catch (IOException e2) {
                    e2.printStackTrace();
                }
                return hex;
            } catch (Exception e3) {
                e = e3;
                try {
                    e.printStackTrace();
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        } catch (IOException e4) {
                            e4.printStackTrace();
                        }
                    }
                    return null;
                } catch (Throwable th2) {
                    th = th2;
                    inputStream2 = inputStream;
                    if (inputStream2 != null) {
                    }
                    throw th;
                }
            }
        } catch (Exception e5) {
            e = e5;
            inputStream = null;
            e.printStackTrace();
            if (inputStream != null) {
            }
            return null;
        } catch (Throwable th3) {
            th = th3;
            if (inputStream2 != null) {
                try {
                    inputStream2.close();
                } catch (IOException e6) {
                    e6.printStackTrace();
                }
            }
            throw th;
        }
    }
}
