package io.dcloud.common.util;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.text.TextUtils;
import androidx.core.content.FileProvider;
import com.facebook.common.util.UriUtil;
import com.taobao.weex.el.parse.Operators;
import io.dcloud.common.adapter.io.DHFile;
import io.dcloud.common.adapter.util.DeviceInfo;
import io.dcloud.common.constant.AbsoluteConst;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;

public class FileUtil {
    public static boolean checkFilePathLegalization(Context context, String str) {
        if (checkPrivatePath(context, str)) {
            return true;
        }
        if (!needMediaStoreOpenFile(context) || TextUtils.isEmpty(getPathForPublicType(str))) {
            return false;
        }
        return true;
    }

    public static boolean checkPathAccord(Context context, String... strArr) {
        boolean z = true;
        if (needMediaStoreOpenFile(context)) {
            if (Build.VERSION.SDK_INT > 29 && Environment.isExternalStorageManager()) {
                return true;
            }
            for (String str : strArr) {
                if (!checkPrivatePath(context, str)) {
                    z = false;
                }
            }
        }
        return z;
    }

    public static boolean checkPrivatePath(Context context, String str) {
        if (TextUtils.isEmpty(DeviceInfo.sPrivateDir)) {
            DeviceInfo.initAppDir(context);
        }
        int i = Build.VERSION.SDK_INT;
        if (i > 29 && Environment.isExternalStorageManager()) {
            return true;
        }
        if (str.startsWith(DeviceInfo.FILE_PROTOCOL)) {
            str = str.replace(DeviceInfo.FILE_PROTOCOL, "");
        }
        if (DeviceInfo.sPrivateExternalDir.startsWith("/") && !str.startsWith("/")) {
            str = "/" + str;
        }
        if (str.contains(DeviceInfo.sPrivateDir) || str.contains(DeviceInfo.sPrivateExternalDir) || isAssetFile(str) || i < 29) {
            return true;
        }
        return false;
    }

    private static Uri copyMediaFile(Context context, InputStream inputStream, String str, String str2, String str3, String str4) throws Exception {
        String fileTypeForSuffix = getFileTypeForSuffix(str2);
        if (TextUtils.isEmpty(fileTypeForSuffix)) {
            return null;
        }
        Uri contentUriForSuffix = getContentUriForSuffix(str2);
        File file = new File(DeviceInfo.sPublicDCIMDir + "/" + str4 + str);
        StringBuilder sb = new StringBuilder();
        sb.append(Operators.DOT_STR);
        sb.append(str2);
        String sb2 = sb.toString();
        String replace = str.replace(sb2, "");
        ContentResolver contentResolver = context.getContentResolver();
        int i = 1;
        while (file.exists()) {
            str = replace + Operators.BRACKET_START_STR + i + Operators.BRACKET_END_STR + sb2;
            i++;
            file = new File(DeviceInfo.sPublicDCIMDir + "/" + str4 + str);
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("_display_name", str);
        contentValues.put("mime_type", fileTypeForSuffix);
        contentValues.put(AbsoluteConst.JSON_KEY_TITLE, str);
        contentValues.put("relative_path", str3 + str4);
        Uri insert = contentResolver.insert(contentUriForSuffix, contentValues);
        if (insert == null) {
            return null;
        }
        OutputStream openOutputStream = context.getContentResolver().openOutputStream(insert);
        byte[] bArr = new byte[DHFile.BUF_SIZE];
        if (openOutputStream != null) {
            while (true) {
                int read = inputStream.read(bArr);
                if (read <= 0) {
                    break;
                }
                openOutputStream.write(bArr, 0, read);
                openOutputStream.flush();
            }
            openOutputStream.close();
        }
        inputStream.close();
        return insert;
    }

    public static Uri copyMediaFileToDCIM(Context context, String str) {
        InputStream inputStream;
        String str2;
        String str3;
        if (needMediaStoreOpenFile(context)) {
            try {
                File file = new File(str);
                if (!file.exists()) {
                    return null;
                }
                if (checkPrivatePath(context, str)) {
                    inputStream = new FileInputStream(file);
                } else {
                    inputStream = getFileInputStream(context, file);
                }
                if (inputStream == null) {
                    return null;
                }
                String fileNameForPath = getFileNameForPath(str);
                String fileNameWithSuffix = getFileNameWithSuffix(fileNameForPath);
                if (TextUtils.isEmpty(fileNameWithSuffix)) {
                    BitmapFactory.Options options = new BitmapFactory.Options();
                    options.inJustDecodeBounds = true;
                    if (checkPrivatePath(context, str)) {
                        BitmapFactory.decodeFile(str, options);
                    } else {
                        InputStream fileInputStream = getFileInputStream(context, file);
                        BitmapFactory.decodeStream(fileInputStream, null, options);
                        fileInputStream.close();
                    }
                    String str4 = options.outMimeType;
                    if (PdrUtil.isEmpty(str4) || !str4.contains("/")) {
                        str3 = "jpg";
                    } else {
                        String[] split = str4.split("/");
                        str3 = split[split.length - 1];
                    }
                    str2 = str3;
                } else {
                    str2 = fileNameWithSuffix;
                }
                return copyMediaFile(context, inputStream, fileNameForPath, str2, "DCIM/", "Camera/");
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static Uri createPublicDocumentsFile(Context context, String str, String str2) {
        if (!needMediaStoreOpenFile(context)) {
            return null;
        }
        Uri contentUri = MediaStore.Files.getContentUri("external");
        File file = new File(DeviceInfo.sPublicDocumentsDir + "/" + str);
        if (file.exists()) {
            return getFileUri(context, file, contentUri);
        }
        ContentResolver contentResolver = context.getContentResolver();
        ContentValues contentValues = new ContentValues();
        contentValues.put("_display_name", str);
        contentValues.put("mime_type", str2);
        contentValues.put(AbsoluteConst.JSON_KEY_TITLE, str);
        contentValues.put("relative_path", "Documents/");
        try {
            return contentResolver.insert(contentUri, contentValues);
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void deleteFile(Context context, String str) {
        if (context != null) {
            try {
                if (!TextUtils.isEmpty(str)) {
                    File fileStreamPath = context.getFileStreamPath(str);
                    if (fileStreamPath.exists()) {
                        fileStreamPath.delete();
                    }
                }
            } catch (Exception unused) {
            }
        }
    }

    /* JADX INFO: Can't fix incorrect switch cases order, some code will duplicate */
    public static Uri getContentUriForSuffix(String str) {
        char c;
        String upperCase = str.toUpperCase();
        upperCase.hashCode();
        switch (upperCase.hashCode()) {
            case 64547:
                if (upperCase.equals("AAC")) {
                    c = 0;
                    break;
                }
                c = 65535;
                break;
            case 64934:
                if (upperCase.equals("AMR")) {
                    c = 1;
                    break;
                }
                c = 65535;
                break;
            case 65108:
                if (upperCase.equals("ASF")) {
                    c = 2;
                    break;
                }
                c = 65535;
                break;
            case 65204:
                if (upperCase.equals("AVI")) {
                    c = 3;
                    break;
                }
                c = 65535;
                break;
            case 65893:
                if (upperCase.equals("BMP")) {
                    c = 4;
                    break;
                }
                c = 65535;
                break;
            case 70564:
                if (upperCase.equals("GIF")) {
                    c = 5;
                    break;
                }
                c = 65535;
                break;
            case 73665:
                if (upperCase.equals("JPG")) {
                    c = 6;
                    break;
                }
                c = 65535;
                break;
            case 75674:
                if (upperCase.equals("M4A")) {
                    c = 7;
                    break;
                }
                c = 65535;
                break;
            case 75695:
                if (upperCase.equals("M4V")) {
                    c = '\b';
                    break;
                }
                c = 65535;
                break;
            case 76387:
                if (upperCase.equals("MKA")) {
                    c = '\t';
                    break;
                }
                c = 65535;
                break;
            case 76408:
                if (upperCase.equals("MKV")) {
                    c = '\n';
                    break;
                }
                c = 65535;
                break;
            case 76528:
                if (upperCase.equals("MP3")) {
                    c = 11;
                    break;
                }
                c = 65535;
                break;
            case 76529:
                if (upperCase.equals("MP4")) {
                    c = '\f';
                    break;
                }
                c = 65535;
                break;
            case 78191:
                if (upperCase.equals("OGG")) {
                    c = '\r';
                    break;
                }
                c = 65535;
                break;
            case 79369:
                if (upperCase.equals("PNG")) {
                    c = 14;
                    break;
                }
                c = 65535;
                break;
            case 85708:
                if (upperCase.equals("WAV")) {
                    c = 15;
                    break;
                }
                c = 65535;
                break;
            case 86059:
                if (upperCase.equals("WMA")) {
                    c = 16;
                    break;
                }
                c = 65535;
                break;
            case 86080:
                if (upperCase.equals("WMV")) {
                    c = 17;
                    break;
                }
                c = 65535;
                break;
            case 1590132:
                if (upperCase.equals("3GPP")) {
                    c = 18;
                    break;
                }
                c = 65535;
                break;
            case 2160488:
                if (upperCase.equals("FLAC")) {
                    c = 19;
                    break;
                }
                c = 65535;
                break;
            case 2283624:
                if (upperCase.equals("JPEG")) {
                    c = 20;
                    break;
                }
                c = 65535;
                break;
            case 2657710:
                if (upperCase.equals("WBMP")) {
                    c = 21;
                    break;
                }
                c = 65535;
                break;
            case 2660249:
                if (upperCase.equals("WEBM")) {
                    c = 22;
                    break;
                }
                c = 65535;
                break;
            case 2660252:
                if (upperCase.equals("WEBP")) {
                    c = 23;
                    break;
                }
                c = 65535;
                break;
            case 49294142:
                if (upperCase.equals("3GPP2")) {
                    c = 24;
                    break;
                }
                c = 65535;
                break;
            case 73545134:
                if (upperCase.equals("MP2TS")) {
                    c = 25;
                    break;
                }
                c = 65535;
                break;
            default:
                c = 65535;
                break;
        }
        switch (c) {
            case 0:
            case 1:
            case 7:
            case '\t':
            case 11:
            case '\r':
            case 15:
            case 16:
            case 19:
                return MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
            case 2:
            case 3:
            case '\b':
            case '\n':
            case '\f':
            case 17:
            case 18:
            case 22:
            case 24:
            case 25:
                return MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
            case 4:
            case 5:
            case 6:
            case 14:
            case 20:
            case 21:
            case 23:
                return MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
            default:
                return MediaStore.Files.getContentUri("external");
        }
    }

    public static InputStream getFileInputStream(Context context, String str) {
        if (str.startsWith(DeviceInfo.FILE_PROTOCOL)) {
            str = str.replace(DeviceInfo.FILE_PROTOCOL, "");
        }
        return getFileInputStream(context, new File(str));
    }

    public static String getFileNameForPath(String str) {
        int lastIndexOf;
        if (!TextUtils.isEmpty(str) && (lastIndexOf = str.lastIndexOf("/")) != -1) {
            return str.substring(lastIndexOf + 1);
        }
        return null;
    }

    public static String getFileNameWithSuffix(String str) {
        if (TextUtils.isEmpty(str)) {
            return "";
        }
        int lastIndexOf = str.lastIndexOf(Operators.DOT_STR);
        if (lastIndexOf == -1) {
            return null;
        }
        return str.substring(lastIndexOf + 1);
    }

    public static String getFileProviderUriToPath(Context context, Uri uri) {
        try {
            Method declaredMethod = FileProvider.class.getDeclaredMethod("getPathStrategy", Context.class, String.class);
            declaredMethod.setAccessible(true);
            Object invoke = declaredMethod.invoke(null, context, uri.getAuthority());
            if (invoke != null) {
                Method declaredMethod2 = Class.forName(FileProvider.class.getName() + "$PathStrategy").getDeclaredMethod("getFileForUri", Uri.class);
                declaredMethod2.setAccessible(true);
                Object invoke2 = declaredMethod2.invoke(invoke, uri);
                if (invoke2 instanceof File) {
                    return ((File) invoke2).getAbsolutePath();
                }
            }
        } catch (Exception unused) {
        }
        return null;
    }

    /* JADX INFO: Can't fix incorrect switch cases order, some code will duplicate */
    public static String getFileTypeForSuffix(String str) {
        char c;
        String upperCase = str.toUpperCase();
        upperCase.hashCode();
        switch (upperCase.hashCode()) {
            case 64547:
                if (upperCase.equals("AAC")) {
                    c = 0;
                    break;
                }
                c = 65535;
                break;
            case 64934:
                if (upperCase.equals("AMR")) {
                    c = 1;
                    break;
                }
                c = 65535;
                break;
            case 65108:
                if (upperCase.equals("ASF")) {
                    c = 2;
                    break;
                }
                c = 65535;
                break;
            case 65204:
                if (upperCase.equals("AVI")) {
                    c = 3;
                    break;
                }
                c = 65535;
                break;
            case 65893:
                if (upperCase.equals("BMP")) {
                    c = 4;
                    break;
                }
                c = 65535;
                break;
            case 70564:
                if (upperCase.equals("GIF")) {
                    c = 5;
                    break;
                }
                c = 65535;
                break;
            case 73665:
                if (upperCase.equals("JPG")) {
                    c = 6;
                    break;
                }
                c = 65535;
                break;
            case 75674:
                if (upperCase.equals("M4A")) {
                    c = 7;
                    break;
                }
                c = 65535;
                break;
            case 75695:
                if (upperCase.equals("M4V")) {
                    c = '\b';
                    break;
                }
                c = 65535;
                break;
            case 76387:
                if (upperCase.equals("MKA")) {
                    c = '\t';
                    break;
                }
                c = 65535;
                break;
            case 76408:
                if (upperCase.equals("MKV")) {
                    c = '\n';
                    break;
                }
                c = 65535;
                break;
            case 76528:
                if (upperCase.equals("MP3")) {
                    c = 11;
                    break;
                }
                c = 65535;
                break;
            case 76529:
                if (upperCase.equals("MP4")) {
                    c = '\f';
                    break;
                }
                c = 65535;
                break;
            case 78191:
                if (upperCase.equals("OGG")) {
                    c = '\r';
                    break;
                }
                c = 65535;
                break;
            case 79369:
                if (upperCase.equals("PNG")) {
                    c = 14;
                    break;
                }
                c = 65535;
                break;
            case 85708:
                if (upperCase.equals("WAV")) {
                    c = 15;
                    break;
                }
                c = 65535;
                break;
            case 86059:
                if (upperCase.equals("WMA")) {
                    c = 16;
                    break;
                }
                c = 65535;
                break;
            case 86080:
                if (upperCase.equals("WMV")) {
                    c = 17;
                    break;
                }
                c = 65535;
                break;
            case 1590132:
                if (upperCase.equals("3GPP")) {
                    c = 18;
                    break;
                }
                c = 65535;
                break;
            case 2160488:
                if (upperCase.equals("FLAC")) {
                    c = 19;
                    break;
                }
                c = 65535;
                break;
            case 2283624:
                if (upperCase.equals("JPEG")) {
                    c = 20;
                    break;
                }
                c = 65535;
                break;
            case 2657710:
                if (upperCase.equals("WBMP")) {
                    c = 21;
                    break;
                }
                c = 65535;
                break;
            case 2660249:
                if (upperCase.equals("WEBM")) {
                    c = 22;
                    break;
                }
                c = 65535;
                break;
            case 2660252:
                if (upperCase.equals("WEBP")) {
                    c = 23;
                    break;
                }
                c = 65535;
                break;
            case 49294142:
                if (upperCase.equals("3GPP2")) {
                    c = 24;
                    break;
                }
                c = 65535;
                break;
            case 73545134:
                if (upperCase.equals("MP2TS")) {
                    c = 25;
                    break;
                }
                c = 65535;
                break;
            default:
                c = 65535;
                break;
        }
        switch (c) {
            case 0:
            case 1:
            case 7:
            case '\t':
            case 11:
            case '\r':
            case 15:
            case 16:
            case 19:
                return "audio/*";
            case 2:
            case 3:
            case '\b':
            case '\n':
            case '\f':
            case 17:
            case 18:
            case 22:
            case 24:
            case 25:
                return "video/*";
            case 4:
            case 5:
            case 6:
            case 14:
            case 20:
            case 21:
            case 23:
                return "image/*";
            default:
                return null;
        }
    }

    public static Uri getFileUri(Context context, File file, Uri uri) {
        Cursor query = context.getContentResolver().query(uri, new String[]{"_id"}, "_data=? ", new String[]{file.getAbsolutePath()}, null);
        if (query != null && query.moveToFirst()) {
            int i = query.getInt(query.getColumnIndex("_id"));
            query.close();
            return Uri.withAppendedPath(uri, "" + i);
        } else if (query == null) {
            return null;
        } else {
            query.close();
            return null;
        }
    }

    public static InputStream getImageFileStream(Context context, File file) {
        Uri imageFileUri = getImageFileUri(context, file.getPath());
        if (imageFileUri == null) {
            return null;
        }
        try {
            return context.getContentResolver().openInputStream(imageFileUri);
        } catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Uri getImageFileUri(Context context, String str) {
        return getImageFileUri(context, new File(str));
    }

    public static String getPathForPublicType(String str) {
        if (str.contains(DeviceInfo.sPublicDCIMDir)) {
            return Environment.DIRECTORY_DCIM;
        }
        if (str.contains(DeviceInfo.sPublicDownloadDir)) {
            return Environment.DIRECTORY_DOWNLOADS;
        }
        if (str.contains(DeviceInfo.sPublicMoviesDir)) {
            return Environment.DIRECTORY_MOVIES;
        }
        if (str.contains(DeviceInfo.sPublicMusicDir)) {
            return Environment.DIRECTORY_MUSIC;
        }
        if (str.contains(DeviceInfo.sPublicPicturesDir)) {
            return Environment.DIRECTORY_PICTURES;
        }
        if (str.contains(DeviceInfo.sPublicDocumentsDir)) {
            return Environment.DIRECTORY_DOCUMENTS;
        }
        if (str.contains(DeviceInfo.sPublicRingtonesDir)) {
            return Environment.DIRECTORY_RINGTONES;
        }
        return null;
    }

    public static String getPathFromUri(Context context, Uri uri) {
        Uri uri2;
        if (uri == null) {
            return null;
        }
        if (!(Build.VERSION.SDK_INT >= 19) || !DocumentsContract.isDocumentUri(context, uri)) {
            String scheme = uri.getScheme();
            if (UriUtil.LOCAL_CONTENT_SCHEME.equals(scheme)) {
                return queryAbsolutePath(context, uri);
            }
            if ("file".equals(scheme)) {
                return uri.getPath();
            }
            return null;
        }
        String authority = uri.getAuthority();
        if ("com.android.externalstorage.documents".equals(authority)) {
            String[] split = DocumentsContract.getDocumentId(uri).split(":");
            String str = split[0];
            if ("primary".equals(str)) {
                return Environment.getExternalStorageDirectory().getAbsolutePath().concat("/").concat(split[1]);
            }
            return "/storage/".concat(str).concat("/").concat(split[1]);
        } else if ("com.android.providers.downloads.documents".equals(authority)) {
            String documentId = DocumentsContract.getDocumentId(uri);
            if (documentId.startsWith("raw:")) {
                return documentId.replaceFirst("raw:", "");
            }
            return queryAbsolutePath(context, ContentUris.withAppendedId(Uri.parse("content://downloads/public_downloads"), Long.parseLong(documentId)));
        } else {
            if ("com.android.providers.media.documents".equals(authority)) {
                String[] split2 = DocumentsContract.getDocumentId(uri).split(":");
                String str2 = split2[0];
                if ("image".equals(str2)) {
                    uri2 = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                } else if ("video".equals(str2)) {
                    uri2 = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                } else if ("audio".equals(str2)) {
                    uri2 = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                }
                return queryAbsolutePath(context, ContentUris.withAppendedId(uri2, Long.parseLong(split2[1])));
            }
            return null;
        }
    }

    public static DCFileUriData getShareImageUri(Context context, File file, String str, Intent intent) {
        DCFileUriData dCFileUriData = new DCFileUriData();
        String path = file.getPath();
        dCFileUriData.filePath = path;
        if (!isExternalPublicDir(path) && Build.VERSION.SDK_INT >= 29 && getPathForPublicType(path) == null) {
            String str2 = context.getExternalFilesDir(Environment.DIRECTORY_DCIM).getPath() + "/" + str.hashCode() + Operators.DOT_STR + getFileNameWithSuffix(str);
            File file2 = new File(str2);
            File parentFile = file2.getParentFile();
            if (!parentFile.exists()) {
                parentFile.mkdirs();
            }
            dCFileUriData.fileUri = FileProvider.getUriForFile(context, context.getPackageName() + ".dc.fileprovider", file2);
            dCFileUriData.isReplace = true;
            dCFileUriData.fileReplacePath = str2;
            if (intent != null) {
                intent.addFlags(1);
            }
        } else if (isExternalPublicDir(path)) {
            File parentFile2 = file.getParentFile();
            if (!parentFile2.exists()) {
                parentFile2.mkdirs();
            }
            dCFileUriData.fileUri = FileProvider.getUriForFile(context, context.getPackageName() + ".dc.fileprovider", file);
        } else {
            dCFileUriData.fileUri = Uri.fromFile(file);
        }
        return dCFileUriData;
    }

    public static Uri getVideoFileUri(Context context, String str) {
        File file = new File(str);
        if (checkPrivatePath(context, str)) {
            return Uri.fromFile(file);
        }
        return getFileUri(context, file, MediaStore.Video.Media.EXTERNAL_CONTENT_URI);
    }

    public static boolean isAssetFile(String str) {
        return str.startsWith("apps/") || str.startsWith("/android_asset/") || str.startsWith("android_asset/");
    }

    private static boolean isExternalPublicDir(String str) {
        StringBuilder sb = new StringBuilder();
        sb.append(DeviceInfo.sPrivateExternalDir);
        sb.append("/file/");
        return str.contains(sb.toString()) || str.contains(DeviceInfo.sBaseFsRootPath);
    }

    public static boolean isFilePathForPublic(Context context, String str) {
        if (PdrUtil.isEmpty(str)) {
            return false;
        }
        if (str.startsWith(DeviceInfo.FILE_PROTOCOL)) {
            str = str.replace(DeviceInfo.FILE_PROTOCOL, "");
        }
        File file = new File(str);
        if (!file.exists()) {
            return false;
        }
        if (!needMediaStoreOpenFile(context)) {
            return true;
        }
        String fileNameWithSuffix = getFileNameWithSuffix(str);
        if (PdrUtil.isEmpty(fileNameWithSuffix) || getFileUri(context, file, getContentUriForSuffix(fileNameWithSuffix)) == null) {
            return false;
        }
        return true;
    }

    public static boolean needMediaStoreOpenFile(Context context) {
        int i = Build.VERSION.SDK_INT;
        return (i >= 29 && context.getApplicationInfo().targetSdkVersion >= 29) || i >= 30;
    }

    /* JADX WARNING: Code restructure failed: missing block: B:11:0x002c, code lost:
        if (r8 != null) goto L_0x0038;
     */
    /* JADX WARNING: Code restructure failed: missing block: B:17:0x0036, code lost:
        if (r8 != null) goto L_0x0038;
     */
    /* JADX WARNING: Code restructure failed: missing block: B:18:0x0038, code lost:
        r8.close();
     */
    /* JADX WARNING: Code restructure failed: missing block: B:19:0x003b, code lost:
        return null;
     */
    /* JADX WARNING: Removed duplicated region for block: B:23:0x0040  */
    private static String queryAbsolutePath(Context context, Uri uri) {
        Throwable th;
        Cursor cursor;
        Exception e;
        Cursor cursor2 = null;
        try {
            cursor = context.getContentResolver().query(uri, new String[]{"_data"}, null, null, null);
            if (cursor != null) {
                try {
                    if (cursor.moveToFirst()) {
                        String string = cursor.getString(cursor.getColumnIndexOrThrow("_data"));
                        cursor.close();
                        cursor.close();
                        return string;
                    }
                } catch (Exception e2) {
                    e = e2;
                    try {
                        e.printStackTrace();
                    } catch (Throwable th2) {
                        th = th2;
                        cursor2 = cursor;
                        if (cursor2 != null) {
                        }
                        throw th;
                    }
                }
            }
        } catch (Exception e3) {
            e = e3;
            cursor = null;
            e.printStackTrace();
        } catch (Throwable th3) {
            th = th3;
            if (cursor2 != null) {
                cursor2.close();
            }
            throw th;
        }
    }

    public static Object readData4Disk(Context context, String str) {
        ObjectInputStream objectInputStream;
        Throwable th;
        ObjectInputStream objectInputStream2 = null;
        if (context != null && !TextUtils.isEmpty(str)) {
            try {
                objectInputStream = new ObjectInputStream(new FileInputStream(context.getFileStreamPath(str)));
                try {
                    Object readObject = objectInputStream.readObject();
                    objectInputStream.close();
                    IOUtil.close(objectInputStream);
                    return readObject;
                } catch (Exception unused) {
                    IOUtil.close(objectInputStream);
                    return null;
                } catch (Throwable th2) {
                    th = th2;
                    objectInputStream2 = objectInputStream;
                    IOUtil.close(objectInputStream2);
                    throw th;
                }
            } catch (Exception unused2) {
                objectInputStream = null;
                IOUtil.close(objectInputStream);
                return null;
            } catch (Throwable th3) {
                th = th3;
                IOUtil.close(objectInputStream2);
                throw th;
            }
        }
        return null;
    }

    public static void saveData2Disk(Context context, Object obj, String str) {
        Throwable th;
        if (context != null && obj != null && (obj instanceof Serializable) && !TextUtils.isEmpty(str)) {
            ObjectOutputStream objectOutputStream = null;
            try {
                File fileStreamPath = context.getFileStreamPath(str);
                if (!fileStreamPath.exists()) {
                    fileStreamPath.createNewFile();
                }
                ObjectOutputStream objectOutputStream2 = new ObjectOutputStream(new FileOutputStream(fileStreamPath));
                try {
                    objectOutputStream2.writeObject(obj);
                    objectOutputStream2.close();
                    IOUtil.close(objectOutputStream2);
                } catch (IOException unused) {
                    objectOutputStream = objectOutputStream2;
                    IOUtil.close(objectOutputStream);
                } catch (Throwable th2) {
                    th = th2;
                    objectOutputStream = objectOutputStream2;
                    IOUtil.close(objectOutputStream);
                    throw th;
                }
            } catch (IOException unused2) {
                IOUtil.close(objectOutputStream);
            } catch (Throwable th3) {
                th = th3;
                IOUtil.close(objectOutputStream);
                throw th;
            }
        }
    }

    public static void writeStream2File(InputStream inputStream, File file) {
        Throwable th;
        Exception e;
        FileOutputStream fileOutputStream = null;
        if (inputStream != null) {
            try {
                FileOutputStream fileOutputStream2 = new FileOutputStream(file);
                try {
                    byte[] bArr = new byte[1024];
                    while (true) {
                        int read = inputStream.read(bArr);
                        if (read == -1) {
                            break;
                        }
                        fileOutputStream2.write(bArr, 0, read);
                    }
                    fileOutputStream2.close();
                    inputStream.close();
                    fileOutputStream = fileOutputStream2;
                } catch (Exception e2) {
                    e = e2;
                    fileOutputStream = fileOutputStream2;
                    try {
                        e.printStackTrace();
                        IOUtil.close(inputStream);
                        IOUtil.close(fileOutputStream);
                    } catch (Throwable th2) {
                        th = th2;
                    }
                } catch (Throwable th3) {
                    th = th3;
                    fileOutputStream = fileOutputStream2;
                    IOUtil.close(inputStream);
                    IOUtil.close(fileOutputStream);
                    throw th;
                }
            } catch (Exception e3) {
                e = e3;
                e.printStackTrace();
                IOUtil.close(inputStream);
                IOUtil.close(fileOutputStream);
            }
        }
        IOUtil.close(inputStream);
        IOUtil.close(fileOutputStream);
    }

    public static Uri getImageFileUri(Context context, File file) {
        if (checkPrivatePath(context, file.getPath())) {
            return Uri.fromFile(file);
        }
        return getFileUri(context, file, MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
    }

    public static InputStream getFileInputStream(Context context, File file) {
        Uri fileUri;
        if (file != null && !TextUtils.isEmpty(file.getPath())) {
            try {
                String path = file.getPath();
                if (checkPrivatePath(context, path)) {
                    return new FileInputStream(file);
                }
                String fileNameWithSuffix = getFileNameWithSuffix(path);
                if (needMediaStoreOpenFile(context)) {
                    if (TextUtils.isEmpty(fileNameWithSuffix)) {
                        String pathForPublicType = getPathForPublicType(path);
                        if (!TextUtils.isEmpty(pathForPublicType)) {
                            char c = 65535;
                            switch (pathForPublicType.hashCode()) {
                                case -1984392349:
                                    if (pathForPublicType.equals("Movies")) {
                                        c = 2;
                                        break;
                                    }
                                    break;
                                case -1970382607:
                                    if (pathForPublicType.equals("Ringtones")) {
                                        c = 6;
                                        break;
                                    }
                                    break;
                                case -1347456360:
                                    if (pathForPublicType.equals("Documents")) {
                                        c = 5;
                                        break;
                                    }
                                    break;
                                case -665475243:
                                    if (pathForPublicType.equals("Pictures")) {
                                        c = 4;
                                        break;
                                    }
                                    break;
                                case 2092515:
                                    if (pathForPublicType.equals("DCIM")) {
                                        c = 0;
                                        break;
                                    }
                                    break;
                                case 74710533:
                                    if (pathForPublicType.equals("Music")) {
                                        c = 3;
                                        break;
                                    }
                                    break;
                                case 1492462760:
                                    if (pathForPublicType.equals("Download")) {
                                        c = 1;
                                        break;
                                    }
                                    break;
                            }
                            switch (c) {
                                case 0:
                                    Uri fileUri2 = getFileUri(context, file, MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
                                    if (fileUri2 != null) {
                                        return context.getContentResolver().openInputStream(fileUri2);
                                    }
                                    break;
                                case 1:
                                    if (Build.VERSION.SDK_INT >= 29 && (fileUri = getFileUri(context, file, MediaStore.Downloads.EXTERNAL_CONTENT_URI)) != null) {
                                        return context.getContentResolver().openInputStream(fileUri);
                                    }
                                case 2:
                                    Uri fileUri3 = getFileUri(context, file, MediaStore.Video.Media.EXTERNAL_CONTENT_URI);
                                    if (fileUri3 != null) {
                                        return context.getContentResolver().openInputStream(fileUri3);
                                    }
                                    break;
                                case 3:
                                    Uri fileUri4 = getFileUri(context, file, MediaStore.Audio.Media.EXTERNAL_CONTENT_URI);
                                    if (fileUri4 != null) {
                                        return context.getContentResolver().openInputStream(fileUri4);
                                    }
                                    break;
                                case 4:
                                    Uri fileUri5 = getFileUri(context, file, MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
                                    if (fileUri5 != null) {
                                        return context.getContentResolver().openInputStream(fileUri5);
                                    }
                                    break;
                                case 5:
                                    Uri fileUri6 = getFileUri(context, file, MediaStore.Files.getContentUri("external"));
                                    if (fileUri6 != null) {
                                        return context.getContentResolver().openInputStream(fileUri6);
                                    }
                                    break;
                                case 6:
                                    Uri fileUri7 = getFileUri(context, file, MediaStore.Audio.Media.EXTERNAL_CONTENT_URI);
                                    if (fileUri7 != null) {
                                        return context.getContentResolver().openInputStream(fileUri7);
                                    }
                                    break;
                                default:
                                    Uri fileUri8 = getFileUri(context, file, MediaStore.Files.getContentUri("external"));
                                    if (fileUri8 != null) {
                                        return context.getContentResolver().openInputStream(fileUri8);
                                    }
                                    break;
                            }
                        }
                    } else {
                        Uri fileUri9 = getFileUri(context, file, getContentUriForSuffix(fileNameWithSuffix));
                        if (fileUri9 != null) {
                            return context.getContentResolver().openInputStream(fileUri9);
                        }
                    }
                } else {
                    return new FileInputStream(file);
                }
            } catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static Uri copyMediaFileToDCIM(Context context, InputStream inputStream, String str) {
        if (!needMediaStoreOpenFile(context) || inputStream == null) {
            return null;
        }
        try {
            String fileNameWithSuffix = getFileNameWithSuffix(str);
            if (TextUtils.isEmpty(getFileTypeForSuffix(fileNameWithSuffix))) {
                return null;
            }
            return copyMediaFile(context, inputStream, str, fileNameWithSuffix, "DCIM/", "Camera/");
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}
