package io.dcloud.common.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class CompressUtil {
    /* JADX WARNING: Code restructure failed: missing block: B:57:0x012f, code lost:
        r0 = move-exception;
     */
    /* JADX WARNING: Code restructure failed: missing block: B:59:?, code lost:
        r6.close();
     */
    /* JADX WARNING: Failed to process nested try/catch */
    /* JADX WARNING: Missing exception handler attribute for start block: B:52:0x0128 */
    /* JADX WARNING: Missing exception handler attribute for start block: B:62:0x0134 */
    /* JADX WARNING: Removed duplicated region for block: B:57:0x012f A[ExcHandler: all (r0v3 'th' java.lang.Throwable A[CUSTOM_DECLARE]), Splitter:B:30:0x00d5] */
    public static String compressImage(String str, String str2, boolean z, Context context) {
        ByteArrayOutputStream byteArrayOutputStream;
        Bitmap bitmap;
        try {
            byte[] inputStream2ByteArr = inputStream2ByteArr(str, context);
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeByteArray(inputStream2ByteArr, 0, inputStream2ByteArr.length, options);
            options.inJustDecodeBounds = false;
            options.inPreferredConfig = Bitmap.Config.RGB_565;
            Bitmap.CompressFormat compressFormat = z ? Bitmap.CompressFormat.PNG : Bitmap.CompressFormat.JPEG;
            int i = options.outWidth;
            if (i >= 1080 || options.outHeight >= 1080) {
                int i2 = options.outHeight;
                if (i2 < 1080 || i < 1080) {
                    float f = ((float) i) / (((float) i2) * 1.0f);
                    if (f <= 2.0f) {
                        if (((double) f) >= 0.5d) {
                            Matrix matrix = new Matrix();
                            int i3 = options.outWidth;
                            int i4 = options.outHeight;
                            float f2 = 1080.0f / (i3 > i4 ? (float) i3 : (float) i4);
                            matrix.setScale(f2, f2);
                            Bitmap decodeByteArray = BitmapFactory.decodeByteArray(inputStream2ByteArr, 0, inputStream2ByteArr.length, options);
                            bitmap = Bitmap.createBitmap(decodeByteArray, 0, 0, decodeByteArray.getWidth(), decodeByteArray.getHeight(), matrix, true);
                            byteArrayOutputStream = new ByteArrayOutputStream();
                            bitmap.compress(compressFormat, 75, byteArrayOutputStream);
                        }
                    }
                    bitmap = BitmapFactory.decodeByteArray(inputStream2ByteArr, 0, inputStream2ByteArr.length, options);
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    bitmap.compress(compressFormat, 73, byteArrayOutputStream);
                } else {
                    Matrix matrix2 = new Matrix();
                    int i5 = options.outWidth;
                    int i6 = options.outHeight;
                    float f3 = 1080.0f / (i5 > i6 ? (float) i6 : (float) i5);
                    matrix2.setScale(f3, f3);
                    Bitmap decodeByteArray2 = BitmapFactory.decodeByteArray(inputStream2ByteArr, 0, inputStream2ByteArr.length, options);
                    bitmap = Bitmap.createBitmap(decodeByteArray2, 0, 0, decodeByteArray2.getWidth(), decodeByteArray2.getHeight(), matrix2, true);
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    bitmap.compress(compressFormat, 70, byteArrayOutputStream);
                }
            } else {
                bitmap = BitmapFactory.decodeByteArray(inputStream2ByteArr, 0, inputStream2ByteArr.length, options);
                byteArrayOutputStream = new ByteArrayOutputStream();
                bitmap.compress(compressFormat, 75, byteArrayOutputStream);
            }
            try {
                File file = new File(str2);
                File parentFile = file.getParentFile();
                if (parentFile != null && !parentFile.exists() && !parentFile.mkdirs()) {
                    try {
                        byteArrayOutputStream.close();
                    } catch (Exception unused) {
                    }
                    return "";
                } else if (file.exists() || file.createNewFile()) {
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    fileOutputStream.write(byteArrayOutputStream.toByteArray());
                    fileOutputStream.close();
                    ExifInterface exifInterface = new ExifInterface(new ByteArrayInputStream(inputStream2ByteArr));
                    ExifInterface exifInterface2 = new ExifInterface(file);
                    exifInterface2.setAttribute("Orientation", exifInterface.getAttribute("Orientation"));
                    exifInterface2.saveAttributes();
                    try {
                        byteArrayOutputStream.close();
                    } catch (Exception unused2) {
                    }
                    bitmap.recycle();
                    return str2;
                } else {
                    try {
                        byteArrayOutputStream.close();
                    } catch (Exception unused3) {
                    }
                    return "";
                }
            } catch (Exception unknown) {
                try {
                    byteArrayOutputStream.close();
                } catch (Exception unused4) {
                }
                return "";
            } catch (Throwable th) {
            }
            throw th;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static byte[] inputStream2ByteArr(String str, Context context) throws IOException {
        InputStream inputStream;
        File file = new File(str);
        if (!file.exists()) {
            return null;
        }
        try {
            if (FileUtil.checkPrivatePath(context, str)) {
                inputStream = new FileInputStream(file);
            } else {
                inputStream = FileUtil.getImageFileStream(context, file);
            }
            if (inputStream == null) {
                inputStream = new FileInputStream(file);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] bArr = new byte[1024];
            while (true) {
                int read = inputStream.read(bArr);
                if (read != -1) {
                    byteArrayOutputStream.write(bArr, 0, read);
                } else {
                    inputStream.close();
                    byteArrayOutputStream.close();
                    return byteArrayOutputStream.toByteArray();
                }
            }
        } catch (Exception unused) {
            return null;
        }
    }
}
