package io.dcloud.common.util;

import android.content.Context;
import android.os.Environment;
import android.text.TextUtils;
import io.dcloud.common.adapter.util.DeviceInfo;
import java.io.File;
import java.io.FileInputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.json.JSONObject;

public class BuildProperties {
    private static String BUILD_PROPERTIES_FILE_NAME = ".buildPropertiesMD5.data";
    private static String BUILD_PROPERTIES_FILE_PATH = "";
    private static volatile BuildProperties ourInstance;
    private Properties properties;

    private BuildProperties() throws Exception {
        Properties properties2 = new Properties();
        this.properties = properties2;
        properties2.load(new FileInputStream(new File(Environment.getRootDirectory(), "build.prop")));
    }

    public static BuildProperties getInstance() throws Exception {
        if (ourInstance == null) {
            synchronized (BuildProperties.class) {
                if (ourInstance == null) {
                    ourInstance = new BuildProperties();
                }
            }
        }
        return ourInstance;
    }

    public boolean containsKey(Object obj) {
        return this.properties.containsKey(obj);
    }

    public boolean containsValue(Object obj) {
        return this.properties.containsValue(obj);
    }

    public Set<Map.Entry<Object, Object>> entrySet() {
        return this.properties.entrySet();
    }

    /* JADX WARNING: Removed duplicated region for block: B:19:0x0067 A[Catch:{ Exception -> 0x00a8 }] */
    public String getBuildPropertiesLimit(Context context) {
        if (DeviceInfo.isSDcardExists()) {
            BUILD_PROPERTIES_FILE_PATH = DeviceInfo.sBaseFsCachePath;
        } else if (context == null) {
            return "";
        } else {
            BUILD_PROPERTIES_FILE_PATH = context.getFilesDir().getAbsolutePath();
        }
        try {
            String md5 = Md5Utils.md5(new File(Environment.getRootDirectory(), "build.prop"));
            if (md5 != null) {
                boolean z = false;
                String str = BUILD_PROPERTIES_FILE_PATH + File.separator + BUILD_PROPERTIES_FILE_NAME;
                File file = new File(str);
                if (file.exists()) {
                    String readStringFile = IOUtil.readStringFile(str);
                    if (!TextUtils.isEmpty(readStringFile) && !readStringFile.equals(md5)) {
                    }
                    if (z) {
                        IOUtil.writeStringFile(str, md5);
                        JSONObject jSONObject = new JSONObject();
                        Properties properties2 = this.properties;
                        if (properties2 != null) {
                            for (Map.Entry entry : properties2.entrySet()) {
                                jSONObject.put(entry.getKey().toString(), entry.getValue());
                            }
                        }
                        String jSONObject2 = jSONObject.toString();
                        if (jSONObject2 == null || "".equals(jSONObject2.trim())) {
                            return "";
                        }
                        return jSONObject2;
                    }
                } else {
                    file.createNewFile();
                }
                z = true;
                if (z) {
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public String getProperty(String str) {
        return this.properties.getProperty(str);
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public Set keySet() {
        return this.properties.keySet();
    }

    public Enumeration keys() {
        return this.properties.keys();
    }

    public int size() {
        return this.properties.size();
    }

    public Collection values() {
        return this.properties.values();
    }

    public String getProperty(String str, String str2) {
        return this.properties.getProperty(str, str2);
    }
}
