package io.dcloud.common.util;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.URLUtil;
import androidx.vectordrawable.graphics.drawable.PathInterpolatorCompat;
import com.taobao.weex.common.Constants;
import com.taobao.weex.performance.WXInstanceApm;
import io.dcloud.application.DCLoudApplicationImpl;
import io.dcloud.common.DHInterface.IActivityHandler;
import io.dcloud.common.DHInterface.IApp;
import io.dcloud.common.DHInterface.ICore;
import io.dcloud.common.DHInterface.IFrameView;
import io.dcloud.common.adapter.io.DHFile;
import io.dcloud.common.adapter.io.UnicodeInputStream;
import io.dcloud.common.adapter.util.AndroidResources;
import io.dcloud.common.adapter.util.DeviceInfo;
import io.dcloud.common.adapter.util.Logger;
import io.dcloud.common.adapter.util.PlatformUtil;
import io.dcloud.common.adapter.util.SP;
import io.dcloud.common.adapter.util.UEH;
import io.dcloud.common.constant.AbsoluteConst;
import io.dcloud.common.constant.IntentConst;
import io.dcloud.common.util.XmlUtil;
import io.dcloud.feature.internal.sdk.SDK;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class BaseInfo {
    private static String APPS_NAME = "apps/";
    public static String APP_DB_DATA = "dbdata/";
    public static String APP_JSDATA = "jsdata/";
    public static String APP_WEB_CHACHE = "webcache/";
    public static String APP_WWW_FS_DIR = "www/";
    public static boolean AuxiliaryInput = false;
    private static final X500Principal DEBUG_DN = new X500Principal("CN=Android Debug,O=Android,C=US");
    public static boolean ISAMU = false;
    public static boolean ISDEBUG = false;
    public static String PDR = "pdr";
    public static String REAL_PRIVATE_DOC_DIR = "doc/";
    public static String REAL_PRIVATE_WWW_DIR = "www/";
    public static String REAL_PUBLIC_DOCUMENTS_DIR = "documents/";
    public static String REAL_PUBLIC_DOWNLOADS_DIR = "downloads/";
    public static final String REL_PRIVATE_DOC_DIR = "_doc";
    public static final String REL_PRIVATE_WWW_DIR = "_www";
    public static final String REL_PUBLIC_DOCUMENTS_DIR = "_documents";
    public static final String REL_PUBLIC_DOWNLOADS_DIR = "_downloads";
    private static String SITMAP = "sitemap/";
    public static String STKEY = "2aSGNEUriKrg4cDH";
    public static boolean SyncDebug = false;
    public static boolean USE_ACTIVITY_HANDLE_KEYEVENT = false;
    public static String WGTU_UPDATE_XML = "update.xml";
    public static boolean allowDownloadWithoutWiFi = false;
    public static boolean injectionGeolocationJS = false;
    public static boolean isDefaultAim = false;
    public static boolean isDefense = false;
    public static boolean isFirstRun = false;
    public static boolean isImmersive = false;
    public static final boolean isOnlinePackage = true;
    public static boolean isPostChcekShortCut = false;
    public static boolean isUniStatistics = false;
    public static String lia = "";
    public static HashMap<String, BaseAppInfo> mBaseAppInfoSet = new HashMap<>();
    public static int mDeStatusBarBackground = -111111;
    public static HashMap<String, BaseAppInfo> mInstalledAppInfoSet = new HashMap<>();
    public static HashMap<String, CmtInfo> mLaunchers = new HashMap<>();
    public static HashMap<String, BaseAppInfo> mUnInstalledAppInfoSet = new HashMap<>();
    public static HashMap<String, byte[]> mW2AE = new HashMap<>();
    public static ArrayList<String> mWap2appTemplateFiles = new ArrayList<>();
    public static String minUserAgentVersion = "";
    public static String renderer = "";
    public static long run5appEndTime = 0;
    public static boolean sAnimationCaptureB = true;
    public static boolean sAnimationCaptureC = true;
    public static String sBaseConfigTemplatePath = (DeviceInfo.sBaseResRootPathName + "data/wap2app/__template.json");
    public static String sBaseControlPath = (DeviceInfo.sBaseResRootPathName + "data/dcloud_control.xml");
    public static String sBaseFsAppsPath = null;
    public static String sBaseFsSitMapPath = null;
    public static String sBaseNotificationPath = null;
    public static String sBaseResAppsFullPath = null;
    public static String sBaseResAppsPath = null;
    public static final String sBaseVersion = "1.9.9.81993";
    public static String sBaseWap2AppFilePath = (DeviceInfo.sBaseResRootPathName + "data/wap2app/__wap2app.js");
    public static String sBaseWap2AppTemplatePath = null;
    public static String sCacheFsAppsPath = null;
    public static String sChannel = "";
    public static String sConfigXML = "manifest.json";
    public static boolean sCoverApkRuning = false;
    public static String sCurrentAppOriginalAppid = null;
    public static String sDefWebViewUserAgent = "";
    public static String sDefaultBootApp = null;
    public static String sDocumentFullPath = "";
    public static boolean sDoingAnimation = false;
    public static String sDownloadFullPath = null;
    public static String sFontScale = "none";
    public static float sFontScaleFloat = 1.0f;
    public static boolean sFullScreenChanged = false;
    public static String sGlobalAuthority = null;
    public static boolean sGlobalFullScreen = false;
    public static String sGlobalUserAgent = null;
    public static String sLastAppVersionName = null;
    public static String sLastRunApp = null;
    public static int sOpenedCount = 0;
    private static boolean sParsedControl = false;
    public static long sProcessId = 0;
    public static ArrayList<String> sRunningApp = null;
    public static String sRuntimeJsPath = "io/dcloud/all.js";
    public static SDK.IntegratedMode sRuntimeMode = null;
    public static String sSplashExitCondition = AbsoluteConst.EVENTS_LOADED;
    public static boolean sSupportAddByHand = true;
    public static long sTemplateModifyTime = 0;
    public static int sTimeOutCount = 0;
    public static int sTimeOutMax = 3;
    public static int sTimeoutCapture = 350;
    public static String sURDFilePath = null;
    public static String sUniNViewServiceJsPath = (DeviceInfo.sBaseResRootPathName + "data/dcloud3.dat");
    public static String sWap2AppTemplateVersion;
    public static boolean s_Is_DCloud_Packaged = false;
    public static int s_Runing_App_Count = 0;
    public static int s_Runing_App_Count_Max = 3;
    public static int s_Runing_App_Count_Trim = 0;
    public static int s_Webview_Count = 0;
    public static String s_properties = "/data/dcloud_properties.xml";
    public static boolean showTipsWithoutWifi = false;
    public static long splashCloseTime;
    public static long splashCreateTime;
    public static long startTime;
    public static int timeOut = PathInterpolatorCompat.MAX_NUM_POINTS;
    public static String uniVersionV3 = "";
    public static String untrustedca = "accept";

    public static class AppIsTestWrapper {
        static final String name = "test_app";
        Context mContext = null;

        public boolean containsKey(String str) {
            return SP.getOrCreateBundle(name, true).contains(str);
        }

        public void init(Context context) {
            this.mContext = context;
        }

        public void put(String str, String str2) {
            SharedPreferences.Editor edit = SP.getOrCreateBundle(name, true).edit();
            edit.putString(str, str2);
            edit.commit();
        }

        public void remove(String str) {
            SP.getOrCreateBundle(name, true).edit().remove(str).commit();
        }
    }

    public static class BaseAppInfo {
        public String mAppVer = null;
        String mAppid = null;
        public boolean mDeleted = false;
        public boolean mMoreRecent = true;

        public BaseAppInfo(String str, String str2) {
            this.mAppid = str;
            this.mAppVer = str2;
        }

        public static final boolean compareVersion(String str, String str2) {
            if (TextUtils.isEmpty(str2)) {
                return true;
            }
            if (TextUtils.isEmpty(str)) {
                return false;
            }
            try {
                String[] split = str.split("\\.");
                String[] split2 = str2.split("\\.");
                int length = split.length;
                int length2 = split2.length;
                for (int i = 0; i < length; i++) {
                    if (i >= length2) {
                        return true;
                    }
                    int parseInt = Integer.parseInt(split[i]);
                    int parseInt2 = Integer.parseInt(split2[i]);
                    if (parseInt > parseInt2) {
                        return true;
                    }
                    if (parseInt < parseInt2) {
                        break;
                    }
                }
            } catch (NumberFormatException e) {
                e.printStackTrace();
            }
            return false;
        }

        public void clearBundleData() {
            String str = BaseInfo.PDR;
            SP.removeBundleData(str, this.mAppid + "_" + AbsoluteConst.XML_APPVER);
        }

        /* access modifiers changed from: package-private */
        public boolean high(BaseAppInfo baseAppInfo) {
            return compareVersion(this.mAppVer, baseAppInfo.mAppVer);
        }

        public void saveToBundleData(Context context) {
            String str = BaseInfo.PDR;
            SP.setBundleData(context, str, this.mAppid + "_" + AbsoluteConst.XML_APPVER, this.mAppVer);
            String str2 = BaseInfo.PDR;
            SP.setBundleData(context, str2, this.mAppid + "_" + AbsoluteConst.XML_DELETED, String.valueOf(this.mDeleted));
            String installAppMapToString = BaseInfo.installAppMapToString();
            StringBuffer stringBuffer = new StringBuffer();
            if (!PdrUtil.isEmpty(installAppMapToString)) {
                stringBuffer.append(installAppMapToString);
                stringBuffer.append("|");
            }
            stringBuffer.append(this.mAppid);
            SP.setBundleData(context, BaseInfo.PDR, AbsoluteConst.XML_APPS, stringBuffer.toString());
        }
    }

    public static class CmtInfo {
        public boolean needUpdate = true;
        public String plusLauncher;
        public boolean rptCrs = true;
        public boolean rptJse = true;
        public String sStartupTime;
        public String sfd;
        public String templateVersion;
    }

    static {
        int i = Build.VERSION.SDK_INT;
        boolean z = true;
        USE_ACTIVITY_HANDLE_KEYEVENT = (i < 19) | true;
        if (i < 21) {
            z = false;
        }
        isDefaultAim = z;
    }

    public static boolean checkAppIsTest(String str) {
        return new File(sCacheFsAppsPath + str + "/.test").exists();
    }

    private static void checkOrResetTemplate(IApp iApp) {
        File file = new File(sBaseWap2AppTemplatePath + "wap2app__template/__template.json");
        long lastModified = file.lastModified();
        if (sTemplateModifyTime != lastModified) {
            try {
                mWap2appTemplateFiles.clear();
                mW2AE.clear();
                JSONObject jSONObject = null;
                try {
                    jSONObject = new JSONObject(new String(IOUtil.getBytes(new UnicodeInputStream(new FileInputStream(file), Charset.defaultCharset().name()))));
                } catch (Exception e) {
                    e.printStackTrace();
                }
                int i = 0;
                if (jSONObject == null || !jSONObject.has("files")) {
                    String[] list = new File(sBaseWap2AppTemplatePath + "wap2app__template/").list();
                    if (list != null) {
                        while (i < list.length) {
                            mWap2appTemplateFiles.add(list[i]);
                            i++;
                        }
                    }
                } else {
                    JSONArray optJSONArray = jSONObject.optJSONArray("files");
                    int length = optJSONArray.length();
                    while (i < length) {
                        mWap2appTemplateFiles.add(optJSONArray.optString(i));
                        i++;
                    }
                }
                if (jSONObject.has(IApp.ConfigProperty.CONFIG_CONFUSION)) {
                    String handleEncryption = iApp.getConfusionMgr().handleEncryption(iApp.getActivity(), Base64.decode2bytes(jSONObject.optString(IApp.ConfigProperty.CONFIG_CONFUSION)));
                    if (PdrUtil.isEmpty(handleEncryption)) {
                        handleEncryption = "{}";
                    }
                    iApp.getConfusionMgr().removeData("__w2a__template__");
                    iApp.getConfusionMgr().recordEncryptionResources("__w2a__template__", new JSONObject(handleEncryption));
                }
                sWap2AppTemplateVersion = jSONObject.optString("version");
            } catch (JSONException e2) {
                e2.printStackTrace();
            } catch (Exception e3) {
                e3.printStackTrace();
            }
        }
        sTemplateModifyTime = lastModified;
    }

    public static boolean checkTestOpenFile() {
        return new File(DeviceInfo.sDeviceRootDir + "/.system/d85a37c6-afdc-11e6-80f5-76304dec7eb7").exists();
    }

    public static void clearData() {
        sParsedControl = false;
        sGlobalFullScreen = false;
        UEH.sInited = false;
        sCurrentAppOriginalAppid = null;
        sLastRunApp = null;
        sRunningApp = null;
        s_Webview_Count = 0;
        s_Runing_App_Count = 0;
        DeviceInfo.DEVICESTATUS_JS = null;
    }

    public static boolean containsInTemplate(IApp iApp, String str) {
        if ((iApp.getActivity() instanceof IActivityHandler) && ((IActivityHandler) iApp.getActivity()).isMultiProcessMode()) {
            checkOrResetTemplate(iApp);
        }
        return mWap2appTemplateFiles.contains(str);
    }

    public static void createAppTestFile(String str) {
        File file = new File(sCacheFsAppsPath + str + "/.test");
        if (!file.exists()) {
            try {
                file.mkdirs();
                file.createNewFile();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean existsBase() {
        try {
            return new File(Environment.getExternalStorageDirectory() + "/Android/data/io.dcloud.HBuilder").exists();
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean existsLibso() {
        try {
            System.loadLibrary("so");
            return true;
        } catch (UnsatisfiedLinkError unused) {
            return false;
        }
    }

    public static boolean existsStreamEnv() {
        try {
            Class.forName("io.dcloud.appstream.StreamAppMainActivity");
            return true;
        } catch (Throwable unused) {
            return false;
        }
    }

    public static String getAnalysisChannel() {
        String str = sChannel;
        if (TextUtils.isEmpty(str)) {
            str = AndroidResources.getMetaValue("DCLOUD_STREAMAPP_CHANNEL");
        }
        if (!TextUtils.isEmpty(str)) {
            if (str.startsWith("_")) {
                return str.substring(1);
            }
            if (!str.contains("|")) {
                return str;
            }
            String[] split = str.split("\\|");
            if (split.length >= 4) {
                return split[3];
            }
        }
        return "";
    }

    public static CmtInfo getCmitInfo(String str) {
        CmtInfo cmtInfo = mLaunchers.get(str);
        if (cmtInfo != null) {
            return cmtInfo;
        }
        CmtInfo cmtInfo2 = new CmtInfo();
        mLaunchers.put(str, cmtInfo2);
        return cmtInfo2;
    }

    public static String getCrashLogsPath(Context context) {
        return DeviceInfo.sBaseFsRootPath + "logs/" + context.getPackageName() + "/";
    }

    public static String getLastKey(LinkedHashMap<String, Intent> linkedHashMap) {
        String str = null;
        if (linkedHashMap != null) {
            Iterator<String> it = linkedHashMap.keySet().iterator();
            while (it.hasNext()) {
                str = it.next();
            }
        }
        return str;
    }

    public static String getLaunchType(Intent intent) {
        String str = "default";
        if (intent == null) {
            return str;
        }
        Uri data = intent.getData();
        if (intent.hasExtra(IntentConst.RUNING_STREAPP_LAUNCHER)) {
            str = intent.getStringExtra(IntentConst.RUNING_STREAPP_LAUNCHER);
        }
        if (data == null || URLUtil.isNetworkUrl(data.toString())) {
            if (intent.getExtras() == null) {
                return str;
            }
            if (!TextUtils.isEmpty(intent.getStringExtra(IntentConst.STREAM_LAUNCHER))) {
                return intent.getStringExtra(IntentConst.STREAM_LAUNCHER);
            }
            if (intent.getBooleanExtra(IntentConst.FROM_SHORT_CUT_STRAT, false)) {
                return IApp.ConfigProperty.CONFIG_SHORTCUT;
            }
            if (!intent.getBooleanExtra(IntentConst.FROM_BARCODE, false)) {
                if (intent.getIntExtra(IntentConst.START_FROM, -1) == 3 || intent.hasExtra("UP-OL-SU")) {
                    return "push";
                }
                if (intent.getIntExtra(IntentConst.START_FROM, -1) == 5) {
                    return "myapp";
                }
                if (intent.getIntExtra(IntentConst.START_FROM, -1) == 7) {
                    return "browser";
                }
                if (intent.getIntExtra(IntentConst.START_FROM, -1) == 8) {
                    return "favorite";
                }
                if (intent.getIntExtra(IntentConst.START_FROM, -1) == 9) {
                    return "engines";
                }
                if (intent.getIntExtra(IntentConst.START_FROM, -1) == 40) {
                    return "apush";
                }
                return intent.getIntExtra(IntentConst.START_FROM, -1) == 10 ? "speech" : str;
            }
        } else if (intent.getBooleanExtra(IntentConst.FROM_BARCODE, false)) {
            return "barcode";
        } else {
            return "scheme";
        }
        return "barcode";
    }

    public static String getLauncherData(String str) {
        CmtInfo cmtInfo = mLaunchers.get(str);
        if (cmtInfo != null && !TextUtils.isEmpty(cmtInfo.plusLauncher)) {
            return cmtInfo.plusLauncher;
        }
        return "default";
    }

    public static String getShortCutActivity(Context context) {
        return null;
    }

    public static String getStackTrace() {
        StackTraceElement[] stackTrace;
        StringBuffer stringBuffer = new StringBuffer();
        for (StackTraceElement stackTraceElement : Thread.currentThread().getStackTrace()) {
            stringBuffer.append(stackTraceElement);
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public static String getStartupTimeData(String str) {
        CmtInfo cmtInfo = mLaunchers.get(str);
        if (cmtInfo != null) {
            return cmtInfo.sStartupTime;
        }
        return null;
    }

    public static String getUniNViewId(IFrameView iFrameView) {
        if (iFrameView.getFrameType() == 2) {
            return iFrameView.obtainApp().obtainAppId();
        }
        return iFrameView.obtainWebView().getWebviewUUID();
    }

    /* access modifiers changed from: private */
    public static String installAppMapToString() {
        StringBuffer stringBuffer = new StringBuffer();
        Set<String> keySet = mInstalledAppInfoSet.keySet();
        int size = keySet.size();
        for (String str : keySet) {
            stringBuffer.append(str);
            stringBuffer.append("|");
        }
        if (size > 1) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    public static boolean isBase(Context context) {
        return SyncDebug || context.getPackageName().equals("io.dcloud.HBuilder");
    }

    public static boolean isChannelGooglePlay() {
        String str = sChannel;
        if (TextUtils.isEmpty(str)) {
            str = AndroidResources.getMetaValue("DCLOUD_STREAMAPP_CHANNEL");
        }
        return !TextUtils.isEmpty(str) && str.endsWith("|google");
    }

    private static boolean isDebugSignature(Context context) {
        Signature[] signatureArr;
        boolean z = false;
        try {
            boolean z2 = false;
            for (Signature signature : context.getPackageManager().getPackageInfo(context.getPackageName(), 64).signatures) {
                try {
                    z2 = ((X509Certificate) CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(signature.toByteArray()))).getSubjectX500Principal().equals(DEBUG_DN);
                    if (z2) {
                        return z2;
                    }
                } catch (PackageManager.NameNotFoundException | Exception | CertificateException unused) {
                    z = z2;
                    return z;
                }
            }
            return z2;
        } catch (PackageManager.NameNotFoundException | Exception | CertificateException unused2) {
            return z;
        }
    }

    public static synchronized boolean isLoadingLaunchePage() {
        synchronized (BaseInfo.class) {
        }
        return false;
    }

    public static boolean isStandardBase(Context context) {
        return context.getPackageName().equals("io.dcloud.HBuilder");
    }

    public static boolean isTest(String str) {
        return false;
    }

    public static boolean isUniAppAppid(IApp iApp) {
        String str;
        if (iApp == null) {
            return false;
        }
        String obtainConfigProperty = iApp.obtainConfigProperty(AbsoluteConst.APP_IS_UNIAPP);
        if (!PdrUtil.isEmpty(obtainConfigProperty)) {
            return Boolean.valueOf(obtainConfigProperty).booleanValue();
        }
        String obtainAppId = iApp.obtainAppId();
        if (TextUtils.isEmpty(obtainAppId)) {
            return false;
        }
        if ("HBuilder".equals(obtainAppId) && (str = sCurrentAppOriginalAppid) != null) {
            obtainAppId = str;
        }
        return obtainAppId.startsWith("__UNI__");
    }

    public static boolean isUniNViewBackgroud() {
        return Boolean.valueOf(AndroidResources.getMetaValue(AbsoluteConst.DCLOUD_UNINVIEW_BACKGROUD)).booleanValue();
    }

    public static boolean isWap2AppAppid(String str) {
        String str2;
        if (str == null) {
            return false;
        }
        if ("HBuilder".equals(str) && (str2 = sCurrentAppOriginalAppid) != null) {
            str = str2;
        }
        String lowerCase = str.toLowerCase(Locale.ENGLISH);
        if (lowerCase.startsWith("__w2a__") || "H52588A9C".equalsIgnoreCase(lowerCase) || "H5B5EEFBB".equalsIgnoreCase(lowerCase) || "H5A0B1958".equalsIgnoreCase(lowerCase) || "H5EA885FD".equalsIgnoreCase(lowerCase) || "H592E7F63".equalsIgnoreCase(lowerCase) || "H5BCD03E4".equalsIgnoreCase(lowerCase)) {
            return true;
        }
        return false;
    }

    public static boolean isWeexUniJs(IApp iApp) {
        String obtainConfigProperty = iApp.obtainConfigProperty(IApp.ConfigProperty.CONFIG_UNIAPP_CONTROL);
        if (!TextUtils.isEmpty(obtainConfigProperty)) {
            return (obtainConfigProperty.equals(Constants.CodeCache.SAVE_PATH) || obtainConfigProperty.equals(AbsoluteConst.UNI_V3)) && isUniAppAppid(iApp);
        }
        return false;
    }

    public static boolean isWifi(Context context) {
        NetworkInfo activeNetworkInfo = ((ConnectivityManager) context.getSystemService("connectivity")).getActiveNetworkInfo();
        return activeNetworkInfo != null && activeNetworkInfo.getType() == 1;
    }

    public static void loadInstalledAppInfo(Context context) {
        String[] listFsAppsFiles;
        String bundleData = SP.getBundleData(context, PDR, AbsoluteConst.XML_APPS);
        if (bundleData != null) {
            String[] split = bundleData.split("\\|");
            for (String str : split) {
                BaseAppInfo baseAppInfo = new BaseAppInfo(str, SP.getBundleData(context, PDR, str + "_" + AbsoluteConst.XML_APPVER));
                boolean parseBoolean = Boolean.parseBoolean(SP.getBundleData(context, PDR, str + "_" + AbsoluteConst.XML_DELETED));
                baseAppInfo.mDeleted = parseBoolean;
                if (parseBoolean) {
                    mUnInstalledAppInfoSet.put(str, baseAppInfo);
                } else if (!PdrUtil.isEmpty(str)) {
                    mInstalledAppInfoSet.put(str, baseAppInfo);
                }
            }
        }
        if (sSupportAddByHand && (listFsAppsFiles = PlatformUtil.listFsAppsFiles(sBaseFsAppsPath)) != null) {
            for (String str2 : listFsAppsFiles) {
                if (!mInstalledAppInfoSet.containsKey(str2)) {
                    String str3 = sDefaultBootApp;
                    Locale locale = Locale.ENGLISH;
                    if (TextUtils.equals(str3.toLowerCase(locale), str2.toLowerCase(locale))) {
                        mInstalledAppInfoSet.put(str2, new BaseAppInfo(str2, WXInstanceApm.VALUE_ERROR_CODE_DEFAULT));
                    }
                }
            }
        }
    }

    public static void parseControl() {
        XmlUtil.DHNode XML_Parser;
        InputStream resInputStream = PlatformUtil.getResInputStream(sBaseControlPath);
        if (resInputStream != null && (XML_Parser = XmlUtil.XML_Parser(resInputStream)) != null) {
            boolean parseBoolean = Boolean.parseBoolean(XmlUtil.getAttributeValue(XML_Parser, AbsoluteConst.XML_SyncDebug, AbsoluteConst.FALSE));
            SyncDebug = parseBoolean;
            ISDEBUG = parseBoolean || Boolean.parseBoolean(XmlUtil.getAttributeValue(XML_Parser, "debug", AbsoluteConst.FALSE));
            XmlUtil.DHNode element = XmlUtil.getElement(XML_Parser, AbsoluteConst.XML_APPS);
            if (!SDK.isUniMPSDK()) {
                ArrayList<XmlUtil.DHNode> elements = XmlUtil.getElements(element, AbsoluteConst.XML_APP);
                if (elements.size() > 0) {
                    sDefaultBootApp = XmlUtil.getAttributeValue(elements.get(0), "appid");
                }
                XmlUtil.DHNode element2 = XmlUtil.getElement(XML_Parser, "lia");
                if (element2 != null) {
                    lia = XmlUtil.getText(element2);
                }
            }
        }
    }

    public static void putLauncherData(String str, String str2) {
        getCmitInfo(str).plusLauncher = str2;
    }

    public static void putStartupTimeData(String str, String str2) {
        getCmitInfo(str).sStartupTime = str2;
    }

    public static void removeTestFile(String str) {
        File file = new File(sCacheFsAppsPath + str + "/.test");
        if (file.exists()) {
            file.delete();
        }
    }

    public static void saveInstalledAppInfo(Context context) {
        SP.setBundleData(context, PDR, AbsoluteConst.XML_APPS, installAppMapToString());
    }

    public static synchronized void setLoadingLaunchePage(boolean z, String str) {
        synchronized (BaseInfo.class) {
        }
    }

    public static void setUniVersionV3(String str, Context context) {
        uniVersionV3 = str;
        SP.setBundleData(context, "pdr", "F_V", str);
    }

    public static void updateBaseInfo(boolean z) {
        if (!APPS_NAME.equals("/")) {
            sBaseResAppsFullPath = DeviceInfo.sBaseResRootFullPath + APPS_NAME;
            sBaseResAppsPath = DeviceInfo.sBaseResRootPathName + APPS_NAME;
            sCacheFsAppsPath = DeviceInfo.sBaseFsCachePath + APPS_NAME;
            sBaseFsAppsPath = DeviceInfo.sBaseFsRootPath + APPS_NAME;
            sBaseFsSitMapPath = DeviceInfo.sBaseFsRootPath + SITMAP;
            sBaseWap2AppTemplatePath = DeviceInfo.sBaseFsCachePath + "cnc3ejE5/";
            sURDFilePath = DeviceInfo.sBaseFsCachePath + "cnc3ejE6/eje3cnc";
            if (z) {
                DHFile.createNewFile(sBaseFsAppsPath);
                DHFile.createNewFile(sBaseFsSitMapPath);
            }
        }
        if (z) {
            String str = sDownloadFullPath;
            if (str == null || str.indexOf("sdcard/") <= -1) {
                sDownloadFullPath = DeviceInfo.sBaseFsRootPath + REAL_PUBLIC_DOWNLOADS_DIR;
            } else {
                sDownloadFullPath = PdrUtil.appendByDeviceRootDir(sDownloadFullPath);
            }
            String str2 = sDocumentFullPath;
            if (str2 == null || str2.indexOf("sdcard/") <= -1) {
                sDocumentFullPath = DeviceInfo.sBaseFsRootPath + REAL_PUBLIC_DOCUMENTS_DIR;
                return;
            }
            sDocumentFullPath = PdrUtil.appendByDeviceRootDir(sDocumentFullPath);
        }
    }

    public static void updateBaseInfoByApp(String str, String str2) {
        if (str != null) {
            PDR = str;
        }
        if (str2 != null) {
            DeviceInfo.sBaseFsRootPath = str2;
        }
        DeviceInfo.initBaseFsRootPath();
    }

    public static boolean useStreamAppStatistic(Context context) {
        return true;
    }

    /* JADX WARNING: Removed duplicated region for block: B:19:0x0071  */
    /* JADX WARNING: Removed duplicated region for block: B:23:0x0083  */
    /* JADX WARNING: Removed duplicated region for block: B:29:0x00ba  */
    /* JADX WARNING: Removed duplicated region for block: B:37:0x00eb  */
    /* JADX WARNING: Removed duplicated region for block: B:40:0x0100  */
    /* JADX WARNING: Removed duplicated region for block: B:47:0x011b A[SYNTHETIC, Splitter:B:47:0x011b] */
    /* JADX WARNING: Removed duplicated region for block: B:84:0x01ca  */
    /* JADX WARNING: Removed duplicated region for block: B:86:0x01cf  */
    public static String[] parseControl(Context context, ICore iCore, ICore.ICoreStatusListener iCoreStatusListener) {
        Exception e;
        boolean z;
        String metaValue;
        String attributeValue;
        int parseInt;
        int parseInt2;
        ArrayList<XmlUtil.DHNode> elements;
        int size;
        int i;
        String str = null;
        String[] strArr = null;
        if (!sParsedControl) {
            boolean z2 = false;
            boolean z3 = false;
            try {
                InputStream resInputStream = PlatformUtil.getResInputStream(sBaseControlPath);
                if (resInputStream != null) {
                    XmlUtil.DHNode XML_Parser = XmlUtil.XML_Parser(resInputStream);
                    IOUtil.close(resInputStream);
                    if (XML_Parser != null) {
                        boolean parseBoolean = Boolean.parseBoolean(XmlUtil.getAttributeValue(XML_Parser, AbsoluteConst.XML_SyncDebug, AbsoluteConst.FALSE));
                        SyncDebug = parseBoolean;
                        if (!parseBoolean) {
                            try {
                                if (!Boolean.parseBoolean(XmlUtil.getAttributeValue(XML_Parser, "debug", AbsoluteConst.FALSE))) {
                                    z = false;
                                    ISDEBUG = z;
                                    AuxiliaryInput = Boolean.parseBoolean(XmlUtil.getAttributeValue(XML_Parser, AbsoluteConst.XML_AUXILIARYINPUT, AbsoluteConst.FALSE));
                                    ISAMU = Boolean.parseBoolean(XmlUtil.getAttributeValue(XML_Parser, AbsoluteConst.XML_AMU, AbsoluteConst.FALSE));
                                    sGlobalAuthority = XmlUtil.getAttributeValue(XML_Parser, IApp.ConfigProperty.CONFIG_AUTHORITY, (String) null);
                                    metaValue = AndroidResources.getMetaValue("DCLOUD_STREAMAPP_CHANNEL");
                                    if (!PdrUtil.isEmpty(metaValue)) {
                                        String attributeValue2 = XmlUtil.getAttributeValue(XML_Parser, AbsoluteConst.XML_CHANNEL, (String) null);
                                        if (!PdrUtil.isEmpty(attributeValue2)) {
                                            sChannel = attributeValue2;
                                        } else {
                                            sChannel = "";
                                        }
                                    } else if (metaValue.startsWith("_")) {
                                        sChannel = metaValue.substring(1);
                                    } else {
                                        sChannel = metaValue;
                                    }
                                    sSplashExitCondition = XmlUtil.getAttributeValue(XML_Parser, "back", sSplashExitCondition);
                                    s_Is_DCloud_Packaged = Boolean.parseBoolean(XmlUtil.getAttributeValue(XML_Parser, AbsoluteConst.XML_NS, AbsoluteConst.FALSE));
                                    attributeValue = XmlUtil.getAttributeValue(XML_Parser, AbsoluteConst.XML_FONT_SCALE, sFontScale);
                                    if (!TextUtils.isEmpty(attributeValue)) {
                                        sFontScale = attributeValue;
                                        try {
                                            if (!"none".equals(attributeValue)) {
                                                sFontScaleFloat = Float.valueOf(sFontScale).floatValue();
                                            }
                                        } catch (Exception unused) {
                                        }
                                    }
                                    sSupportAddByHand &= ISDEBUG;
                                    XmlUtil.DHNode element = XmlUtil.getElement(XML_Parser, AbsoluteConst.XML_APPS);
                                    parseInt = PdrUtil.parseInt(XmlUtil.getAttributeValue(element, "max"), s_Runing_App_Count_Max);
                                    s_Runing_App_Count_Max = parseInt;
                                    if (parseInt <= 0) {
                                        s_Runing_App_Count_Max = Integer.MAX_VALUE;
                                    }
                                    parseInt2 = PdrUtil.parseInt(XmlUtil.getAttributeValue(element, AbsoluteConst.XML_TRIM), s_Runing_App_Count_Trim);
                                    s_Runing_App_Count_Trim = parseInt2;
                                    if (parseInt2 <= 0) {
                                        s_Runing_App_Count_Trim = 0;
                                    }
                                    elements = XmlUtil.getElements(element, AbsoluteConst.XML_APP);
                                    if (elements != null && !SDK.isUniMPSDK()) {
                                        size = elements.size();
                                        String[] strArr2 = null;
                                        HashMap<String, BaseAppInfo> hashMap = null;
                                        i = 0;
                                        boolean z4 = false;
                                        boolean z5 = true;
                                        while (i < size) {
                                            try {
                                                XmlUtil.DHNode dHNode = elements.get(i);
                                                String attributeValue3 = XmlUtil.getAttributeValue(dHNode, "appid");
                                                if (i == 0) {
                                                    strArr2 = new String[1];
                                                    char c = z2 ? 1 : 0;
                                                    char c2 = z2 ? 1 : 0;
                                                    char c3 = z2 ? 1 : 0;
                                                    strArr2[c] = attributeValue3;
                                                    if (!SDK.isUniMPSDK()) {
                                                        sDefaultBootApp = attributeValue3;
                                                    }
                                                    updateBaseInfoByApp(attributeValue3, str);
                                                    z5 = DeviceInfo.checkCoverLoadApp();
                                                    sCoverApkRuning = z5;
                                                    if (isBase(DCLoudApplicationImpl.self().getContext())) {
                                                        z5 &= !ISDEBUG;
                                                    }
                                                    loadInstalledAppInfo(context);
                                                    hashMap = mInstalledAppInfoSet;
                                                }
                                                BaseAppInfo baseAppInfo = new BaseAppInfo(attributeValue3, XmlUtil.getAttributeValue(dHNode, AbsoluteConst.XML_APPVER));
                                                mBaseAppInfoSet.put(attributeValue3, baseAppInfo);
                                                if (z5 && hashMap.containsKey(attributeValue3)) {
                                                    BaseAppInfo baseAppInfo2 = hashMap.get(attributeValue3);
                                                    if (!sCoverApkRuning) {
                                                        if (!baseAppInfo.high(baseAppInfo2)) {
                                                            baseAppInfo.mMoreRecent = z2;
                                                            mBaseAppInfoSet.remove(attributeValue3);
                                                        }
                                                    }
                                                    Log.i(Logger.MAIN_TAG, attributeValue3 + " App has new version! it is " + baseAppInfo.mAppVer);
                                                    try {
                                                        baseAppInfo.clearBundleData();
                                                        hashMap.remove(attributeValue3);
                                                        z4 = true;
                                                    } catch (Exception e2) {
                                                        e = e2;
                                                        strArr = strArr2;
                                                        z3 = true;
                                                        e.printStackTrace();
                                                        sParsedControl = true;
                                                        if (ISDEBUG) {
                                                        }
                                                        if (z3) {
                                                        }
                                                        Logger.e("channel:" + sChannel + ";ver:" + "1.9.9.81993" + ";max:" + s_Runing_App_Count_Max + ";trim:" + s_Runing_App_Count_Trim + ";dg:" + ISDEBUG);
                                                        Log.i(Logger.MAIN_TAG, "will exc coreListener.onCoreReady");
                                                        iCoreStatusListener.onCoreReady(iCore);
                                                        return strArr;
                                                    }
                                                }
                                                i++;
                                                z2 = false;
                                                str = null;
                                            } catch (Exception e3) {
                                                e = e3;
                                                strArr = strArr2;
                                                z3 = z4;
                                                e.printStackTrace();
                                                sParsedControl = true;
                                                if (ISDEBUG) {
                                                }
                                                if (z3) {
                                                }
                                                Logger.e("channel:" + sChannel + ";ver:" + "1.9.9.81993" + ";max:" + s_Runing_App_Count_Max + ";trim:" + s_Runing_App_Count_Trim + ";dg:" + ISDEBUG);
                                                Log.i(Logger.MAIN_TAG, "will exc coreListener.onCoreReady");
                                                iCoreStatusListener.onCoreReady(iCore);
                                                return strArr;
                                            }
                                        }
                                        strArr = strArr2;
                                        z3 = z4;
                                        sParsedControl = true;
                                        if (ISDEBUG) {
                                            Logger.setOpen(true);
                                        }
                                        if (z3) {
                                            SP.setBundleData(context, PDR, AbsoluteConst.XML_APPS, installAppMapToString());
                                        }
                                    }
                                }
                            } catch (Exception e4) {
                                e = e4;
                                e.printStackTrace();
                                sParsedControl = true;
                                if (ISDEBUG) {
                                }
                                if (z3) {
                                }
                                Logger.e("channel:" + sChannel + ";ver:" + "1.9.9.81993" + ";max:" + s_Runing_App_Count_Max + ";trim:" + s_Runing_App_Count_Trim + ";dg:" + ISDEBUG);
                                Log.i(Logger.MAIN_TAG, "will exc coreListener.onCoreReady");
                                iCoreStatusListener.onCoreReady(iCore);
                                return strArr;
                            }
                        }
                        z = true;
                        ISDEBUG = z;
                        AuxiliaryInput = Boolean.parseBoolean(XmlUtil.getAttributeValue(XML_Parser, AbsoluteConst.XML_AUXILIARYINPUT, AbsoluteConst.FALSE));
                        ISAMU = Boolean.parseBoolean(XmlUtil.getAttributeValue(XML_Parser, AbsoluteConst.XML_AMU, AbsoluteConst.FALSE));
                        sGlobalAuthority = XmlUtil.getAttributeValue(XML_Parser, IApp.ConfigProperty.CONFIG_AUTHORITY, (String) null);
                        metaValue = AndroidResources.getMetaValue("DCLOUD_STREAMAPP_CHANNEL");
                        if (!PdrUtil.isEmpty(metaValue)) {
                        }
                        sSplashExitCondition = XmlUtil.getAttributeValue(XML_Parser, "back", sSplashExitCondition);
                        s_Is_DCloud_Packaged = Boolean.parseBoolean(XmlUtil.getAttributeValue(XML_Parser, AbsoluteConst.XML_NS, AbsoluteConst.FALSE));
                        attributeValue = XmlUtil.getAttributeValue(XML_Parser, AbsoluteConst.XML_FONT_SCALE, sFontScale);
                        if (!TextUtils.isEmpty(attributeValue)) {
                        }
                        sSupportAddByHand &= ISDEBUG;
                        XmlUtil.DHNode element2 = XmlUtil.getElement(XML_Parser, AbsoluteConst.XML_APPS);
                        parseInt = PdrUtil.parseInt(XmlUtil.getAttributeValue(element2, "max"), s_Runing_App_Count_Max);
                        s_Runing_App_Count_Max = parseInt;
                        if (parseInt <= 0) {
                        }
                        parseInt2 = PdrUtil.parseInt(XmlUtil.getAttributeValue(element2, AbsoluteConst.XML_TRIM), s_Runing_App_Count_Trim);
                        s_Runing_App_Count_Trim = parseInt2;
                        if (parseInt2 <= 0) {
                        }
                        elements = XmlUtil.getElements(element2, AbsoluteConst.XML_APP);
                        size = elements.size();
                        String[] strArr22 = null;
                        HashMap<String, BaseAppInfo> hashMap2 = null;
                        i = 0;
                        boolean z42 = false;
                        boolean z52 = true;
                        while (i < size) {
                        }
                        strArr = strArr22;
                        z3 = z42;
                        sParsedControl = true;
                        if (ISDEBUG) {
                        }
                        if (z3) {
                        }
                    }
                } else {
                    DeviceInfo.initBaseFsRootPath();
                }
                z3 = false;
                strArr = null;
            } catch (Exception e5) {
                e = e5;
                z3 = false;
                strArr = null;
                e.printStackTrace();
                sParsedControl = true;
                if (ISDEBUG) {
                }
                if (z3) {
                }
                Logger.e("channel:" + sChannel + ";ver:" + "1.9.9.81993" + ";max:" + s_Runing_App_Count_Max + ";trim:" + s_Runing_App_Count_Trim + ";dg:" + ISDEBUG);
                Log.i(Logger.MAIN_TAG, "will exc coreListener.onCoreReady");
                iCoreStatusListener.onCoreReady(iCore);
                return strArr;
            }
            sParsedControl = true;
            if (ISDEBUG) {
            }
            if (z3) {
            }
        } else {
            strArr = null;
        }
        Logger.e("channel:" + sChannel + ";ver:" + "1.9.9.81993" + ";max:" + s_Runing_App_Count_Max + ";trim:" + s_Runing_App_Count_Trim + ";dg:" + ISDEBUG);
        if (!(iCoreStatusListener == null || iCore == null)) {
            Log.i(Logger.MAIN_TAG, "will exc coreListener.onCoreReady");
            iCoreStatusListener.onCoreReady(iCore);
        }
        return strArr;
    }
}
