package io.dcloud.common.util;

import android.app.Activity;
import android.app.Application;
import android.app.UiModeManager;
import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import androidx.webkit.WebSettingsCompat;
import androidx.webkit.WebViewFeature;
import io.dcloud.application.DCLoudApplicationImpl;
import io.dcloud.common.DHInterface.ICallBack;
import io.dcloud.common.DHInterface.IFrameView;
import io.dcloud.common.DHInterface.INativeAppInfo;
import io.dcloud.common.DHInterface.IUniInstanceMgr;
import io.dcloud.common.DHInterface.IWebview;
import io.dcloud.common.adapter.io.DHFile;
import io.dcloud.common.adapter.ui.AdaUniWebView;
import io.dcloud.common.adapter.ui.webview.DCWebView;
import io.dcloud.common.adapter.util.AndroidResources;
import io.dcloud.common.adapter.util.EventActionInfo;
import io.dcloud.common.adapter.util.Logger;
import io.dcloud.common.adapter.util.PlatformUtil;
import io.dcloud.common.adapter.util.SP;
import io.dcloud.common.constant.AbsoluteConst;
import io.dcloud.common.core.ui.TabBarWebview;
import io.dcloud.common.ui.PrivacyManager;
import io.dcloud.common.ui.blur.DCBlurDraweeView;
import io.dcloud.common.util.BaseInfo;
import io.dcloud.feature.internal.sdk.SDK;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.json.JSONObject;

public class AppRuntime {
    private static int sBatteryLevel = 100;
    private static int sTemperature = 20;
    private static String sUniStatistics;

    public static void applyWebViewDarkMode(final Context context, final WebView webView) {
        AnonymousClass1 r0 = new Runnable() {
            /* class io.dcloud.common.util.AppRuntime.AnonymousClass1 */

            public void run() {
                if (Build.VERSION.SDK_INT >= 29) {
                    if (WebViewFeature.isFeatureSupported("FORCE_DARK")) {
                        if (AppRuntime.getAppDarkMode(context)) {
                            WebSettingsCompat.setForceDark(webView.getSettings(), 2);
                        } else {
                            WebSettingsCompat.setForceDark(webView.getSettings(), 0);
                        }
                    }
                    if (WebViewFeature.isFeatureSupported(WebViewFeature.FORCE_DARK_STRATEGY)) {
                        WebSettingsCompat.setForceDarkStrategy(webView.getSettings(), 1);
                    }
                }
            }
        };
        if (Thread.currentThread() != Looper.getMainLooper().getThread()) {
            new Handler(Looper.getMainLooper()).post(r0);
        } else {
            r0.run();
        }
    }

    public static void checkPrivacyComplianceAndPrompt(Context context, String str) {
        boolean z = BaseInfo.SyncDebug;
    }

    private static List<View> findAllWebView(View view) {
        ArrayList arrayList = new ArrayList();
        if (view instanceof DCWebView) {
            arrayList.add(view);
            return arrayList;
        }
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup) view;
            for (int i = 0; i < viewGroup.getChildCount(); i++) {
                arrayList.addAll(findAllWebView(viewGroup.getChildAt(i)));
            }
        }
        return arrayList;
    }

    public static boolean getAppDarkMode(Context context) {
        String str;
        if (Build.VERSION.SDK_INT < 29) {
            return false;
        }
        if (SDK.isUniMP) {
            str = SDK.hostAppThemeDark;
        } else {
            str = SP.getBundleData(context, SP.DARK_MODE_BUNDLE_FORMAT, SP.DARK_MODE_KEY);
            String metaValue = AndroidResources.getMetaValue("DCLOUD_DARK_MODE");
            if (PdrUtil.isEmpty(metaValue)) {
                metaValue = DCBlurDraweeView.LIGHT;
            }
            if (PdrUtil.isEmpty(str)) {
                str = metaValue;
            }
        }
        str.hashCode();
        if (!str.equals("auto")) {
            if (!str.equals(DCBlurDraweeView.DARK)) {
                return false;
            }
            return true;
        } else if (((UiModeManager) context.getSystemService("uimode")).getNightMode() == 2) {
            return true;
        } else {
            return false;
        }
    }

    public static int getBatteryLevel() {
        return sBatteryLevel;
    }

    public static String getDCloudDeviceID(Context context) {
        return TelephonyUtil.getDCloudDeviceID(context);
    }

    public static IUniInstanceMgr getInstanceMgr() {
        return (IUniInstanceMgr) PlatformUtil.invokeMethod("io.dcloud.feature.weex.WeexInstanceMgr", "self");
    }

    public static int getTemperature() {
        return sTemperature;
    }

    public static String getUniStatistics() {
        return sUniStatistics;
    }

    public static boolean hasPrivacyForNotShown(Context context) {
        if (SDK.isUniMPSDK()) {
            return SDK.uniMPSilentMode;
        }
        return PrivacyManager.getInstance().isPrivacyAllRight(context);
    }

    public static void initUTS() {
        Class<?> cls;
        Object obj;
        Method method = null;
        try {
            cls = Class.forName("io.dcloud.uts.android.AndroidUTSContext");
        } catch (ClassNotFoundException unused) {
            cls = null;
        }
        try {
            obj = cls.getField("INSTANCE").get(null);
        } catch (Exception e) {
            Logger.e("AppRuntime", "initUTS error " + e.toString());
            obj = null;
        }
        if (cls != null && obj != null) {
            try {
                method = cls.getMethod("initApp", new Class[0]);
            } catch (NoSuchMethodException unused2) {
            }
            if (method != null) {
                try {
                    method.invoke(obj, new Object[0]);
                } catch (IllegalAccessException e2) {
                    e2.printStackTrace();
                } catch (InvocationTargetException e3) {
                    e3.printStackTrace();
                }
            }
        }
    }

    public static void initUTSHooksClassArray(Application application) {
        try {
            Class<?> cls = Class.forName("io.dcloud.uts.UTSAndroid");
            Method method = null;
            Object obj = cls.getField("INSTANCE").get(null);
            if (obj != null) {
                try {
                    Method declaredMethod = cls.getDeclaredMethod("initUTSHooksClassArray", Application.class);
                    declaredMethod.setAccessible(true);
                    method = declaredMethod;
                } catch (NoSuchMethodException unused) {
                }
                if (method != null) {
                    try {
                        method.invoke(obj, application);
                    } catch (IllegalAccessException e) {
                        e.printStackTrace();
                    } catch (InvocationTargetException e2) {
                        e2.printStackTrace();
                    }
                }
            }
        } catch (Exception unused2) {
        }
    }

    public static void initUniappPlugin(Application application) {
        IUniInstanceMgr instanceMgr = getInstanceMgr();
        if (instanceMgr != null) {
            instanceMgr.initUniappPlugin(application);
        }
    }

    public static void initWeex(INativeAppInfo iNativeAppInfo) {
        IUniInstanceMgr iUniInstanceMgr = (IUniInstanceMgr) PlatformUtil.invokeMethod("io.dcloud.feature.weex.WeexInstanceMgr", "self");
        if (iUniInstanceMgr != null) {
            iUniInstanceMgr.initWeexEnv(iNativeAppInfo);
        }
    }

    public static void initX5(Application application, boolean z, ICallBack iCallBack) {
        PlatformUtil.invokeMethod("io.dcloud.feature.x5.X5InitImpl", "init", null, new Class[]{Application.class, Boolean.class, ICallBack.class}, new Object[]{application, Boolean.valueOf(z), iCallBack});
    }

    public static boolean isAppResourcesInAssetsPath(Context context, String str) {
        String str2;
        JSONObject createJSONObject;
        if (PdrUtil.isEmpty(str)) {
            if (PdrUtil.isEmpty(BaseInfo.sDefaultBootApp)) {
                BaseInfo.parseControl();
            }
            str = BaseInfo.sDefaultBootApp;
            if (PdrUtil.isEmpty(str)) {
                return false;
            }
        }
        if (BaseInfo.isBase(context)) {
            return false;
        }
        String str3 = "apps/" + str + "/www/" + BaseInfo.sConfigXML;
        if (BaseInfo.ISDEBUG || DHFile.hasFile()) {
            str2 = Environment.getExternalStorageDirectory().getPath() + "/Android/data/" + context.getPackageName();
        } else {
            str2 = context.getFilesDir().getPath();
        }
        String str4 = str2 + "/" + str3;
        try {
            JSONObject configData = PdrUtil.getConfigData(context, str, str3, true);
            String str5 = "";
            String string = (configData == null || (createJSONObject = JSONUtil.createJSONObject(configData.getString("version"))) == null) ? str5 : createJSONObject.getString("name");
            JSONObject configData2 = PdrUtil.getConfigData(context, str, str4, false);
            if (configData2 != null) {
                str5 = JSONUtil.createJSONObject(configData2.getString("version")).getString("name");
            }
            return BaseInfo.BaseAppInfo.compareVersion(string, str5);
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isUniApp(String str) {
        return !TextUtils.isEmpty(str) && str.startsWith("__UNI__");
    }

    static /* synthetic */ void lambda$switchAllWebViewDarkMode$0(View view) {
        if (view instanceof DCWebView) {
            ((DCWebView) view).applyWebViewDarkMode();
        }
    }

    static /* synthetic */ void lambda$switchAllWebViewDarkMode$1(IWebview iWebview) {
        ViewGroup obtainWindowView = iWebview.obtainWindowView();
        if (iWebview instanceof TabBarWebview) {
            findAllWebView(obtainWindowView).forEach($$Lambda$AppRuntime$iOsiCkjBhiP8W7dUfTQnPok5DM.INSTANCE);
        }
        if (obtainWindowView instanceof DCWebView) {
            ((DCWebView) obtainWindowView).applyWebViewDarkMode();
        }
    }

    public static void loadDex(Application application) {
        PlatformUtil.invokeMethod("io.dcloud.debug.DexSwap", "loadDex", null, new Class[]{Application.class}, new Object[]{application});
    }

    public static InputStream loadWeexAsset(String str, Context context) {
        if ((str.startsWith("weex-main-jsfm") || str.startsWith("uni-jsframework")) && str.endsWith(".js") && context.getPackageName().equals("io.dcloud.HBuilder") && context.getExternalCacheDir() != null) {
            String path = context.getExternalCacheDir().getPath();
            File file = new File(path + File.separator + str);
            if (file.exists()) {
                try {
                    return new FileInputStream(file);
                } catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public static void onCreateProcess(Application application, Boolean bool, Boolean bool2) {
        IUniInstanceMgr instanceMgr = getInstanceMgr();
        if (instanceMgr == null) {
            return;
        }
        if (!bool.booleanValue() || bool2.booleanValue()) {
            instanceMgr.onCreateProcess(application, bool);
        }
    }

    public static void preInitX5(Application application) {
        PlatformUtil.invokeMethod("io.dcloud.feature.x5.X5InitImpl", "preInit", null, new Class[]{Application.class}, new Object[]{application});
    }

    public static void restartWeex(Application application, ICallBack iCallBack, String str) {
        IUniInstanceMgr instanceMgr = getInstanceMgr();
        if (instanceMgr != null) {
            instanceMgr.restartWeex(application, iCallBack, str);
        }
    }

    public static void setAppDarkMode(Activity activity, IWebview iWebview, String str) {
        if (Build.VERSION.SDK_INT >= 29 && !SDK.isUniMP && activity != null && !PdrUtil.isEmpty(str)) {
            if (!PdrUtil.isEquals(SP.getBundleData(activity, SP.DARK_MODE_BUNDLE_FORMAT, SP.DARK_MODE_KEY), str)) {
                if (iWebview instanceof AdaUniWebView) {
                    HashMap hashMap = new HashMap();
                    hashMap.put("uistyle", str);
                    ((AdaUniWebView) iWebview).fireEvent(new EventActionInfo(AbsoluteConst.EVENTS_UISTYLECHANGE, hashMap));
                } else {
                    iWebview.loadUrl(StringUtil.format(AbsoluteConst.EVENTS_DOCUMENT_EXECUTE_TEMPLATE_PARAMETER_OF_UISTYLE, AbsoluteConst.EVENTS_UISTYLECHANGE, str));
                }
            }
            SP.setBundleData(activity, SP.DARK_MODE_BUNDLE_FORMAT, SP.DARK_MODE_KEY, str);
            switchAllWebViewDarkMode(null);
        }
    }

    public static void setBatteryLevel(int i) {
        sBatteryLevel = i;
    }

    public static void setTemperature(int i) {
        sTemperature = i;
    }

    public static void setUniStatistics(String str) {
        sUniStatistics = str;
    }

    public static void switchAllWebViewDarkMode(ArrayList<? extends IFrameView> arrayList) {
        ArrayList<IWebview> arrayList2 = new ArrayList<>();
        if (arrayList == null || arrayList.isEmpty()) {
            arrayList2 = SDK.obtainAllIWebview();
        } else {
            Iterator<? extends IFrameView> it = arrayList.iterator();
            while (it.hasNext()) {
                arrayList2.add(((IFrameView) it.next()).obtainWebView());
            }
        }
        if (arrayList2 != null && !arrayList2.isEmpty()) {
            arrayList2.forEach($$Lambda$AppRuntime$_ZSq3SuXcfKmm3Jn1F1hS3RLdmo.INSTANCE);
        }
    }

    public static void initWeex(Application application) {
        IUniInstanceMgr iUniInstanceMgr = (IUniInstanceMgr) PlatformUtil.invokeMethod("io.dcloud.feature.weex.WeexInstanceMgr", "self");
        if (iUniInstanceMgr != null) {
            iUniInstanceMgr.initWeexEnv(DCLoudApplicationImpl.self().getNativeInfo(application));
        }
    }
}
