package io.dcloud.common.ui.blur;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.text.TextUtils;
import android.view.Choreographer;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import io.dcloud.common.adapter.util.MessageHandler;
import io.dcloud.common.ui.blur.AppEventForBlurManager;
import io.dcloud.common.util.BaseInfo;
import io.dcloud.common.util.TitleNViewUtil;
import java.lang.ref.WeakReference;

public class DCBlurDraweeView extends FrameLayout implements AppEventForBlurManager.OnAppChangedCallBack {
    public static final String AUTOMATICALLY = "automatically";
    public static final String DARK = "dark";
    public static final String EXTRALIGHT = "extralight";
    public static final String LIGHT = "light";
    public static final String NONE = "none";
    public static final String SEMI_AUTOMATICALLY = "semi-automatic";
    public static final String STATIC = "static";
    private final String TAG = "DCBlurDraweeView";
    private Choreographer.FrameCallback invalidationLoop = new Choreographer.FrameCallback() {
        /* class io.dcloud.common.ui.blur.DCBlurDraweeView.AnonymousClass1 */

        public void doFrame(long j) {
            if (!BaseInfo.sDoingAnimation) {
                DCBlurDraweeView.this.invalidate();
            }
            Choreographer.getInstance().postFrameCallbackDelayed(this, (long) (1000 / DCBlurDraweeView.this.mFPS));
        }
    };
    private boolean isBlur = false;
    private float mAlpha = Float.NaN;
    private boolean mAttachedToWindow;
    private String mBlurEffect = "none";
    private int mBlurRadius = 15;
    private String mBlurState = "static";
    private BlurLayoutChangeCallBack mChangeCB;
    private float mCornerRadius = 0.0f;
    private float mDownscaleFactor = 0.2f;
    private int mFPS = 60;
    private int mGravityType = 17;
    private ImageView mImageView;
    private float mOverlayColorAlpha = 0.6f;
    private long mPostTime = 1500;
    private WeakReference<View> mRootView;
    private boolean mRunning;
    private int postDelayTime = 50;
    private Choreographer.FrameCallback postInvalidationLoop = new Choreographer.FrameCallback() {
        /* class io.dcloud.common.ui.blur.DCBlurDraweeView.AnonymousClass2 */

        public void doFrame(long j) {
            if (!DCBlurDraweeView.this.mRunning) {
                if (!BaseInfo.sDoingAnimation) {
                    DCBlurDraweeView.this.invalidate();
                }
                Choreographer.getInstance().postFrameCallbackDelayed(this, (long) DCBlurDraweeView.this.postDelayTime);
            }
        }
    };
    private Runnable removePostDelayed = new Runnable() {
        /* class io.dcloud.common.ui.blur.DCBlurDraweeView.AnonymousClass3 */

        public void run() {
            Choreographer.getInstance().removeFrameCallback(DCBlurDraweeView.this.postInvalidationLoop);
        }
    };

    public interface BlurLayoutChangeCallBack {
        void setVisibility(int i);
    }

    public DCBlurDraweeView(Context context) {
        super(context);
    }

    private View getActivityView() {
        try {
            return ((Activity) getContext()).getWindow().getDecorView().findViewById(16908290);
        } catch (ClassCastException unused) {
            return null;
        }
    }

    private Bitmap getDownscaledBitmapForView(View view, Rect rect, float f, int i) throws Exception {
        int i2;
        int i3;
        float f2 = f / 0.5f;
        if (f >= 0.5f) {
            f2 = 1.0f;
        } else {
            f = 0.5f;
        }
        int width = (int) (((float) rect.width()) * f);
        int height = (int) (((float) rect.height()) * f);
        if (view.getWidth() <= 0 || view.getHeight() <= 0 || width <= 0 || height <= 0) {
            throw new Exception("No screen available (width or height = 0)");
        }
        float f3 = ((float) (-rect.left)) * f;
        float f4 = ((float) ((-rect.top) + i)) * f;
        int i4 = this.mGravityType;
        if (i4 == 17) {
            i3 = rect.height();
            i *= 2;
        } else if (i4 != 48) {
            i3 = rect.height();
        } else {
            i2 = (int) (((float) (rect.height() + i)) * f);
            f4 -= ((float) i) * f;
            setViewVisibility(4);
            Bitmap createBitmap = Bitmap.createBitmap(width, i2, Bitmap.Config.ARGB_8888);
            BlurCanvas blurCanvas = new BlurCanvas(createBitmap);
            Matrix matrix = new Matrix();
            matrix.postScale(f, f);
            matrix.postTranslate(f3, f4);
            blurCanvas.setMatrix(matrix);
            view.draw(blurCanvas);
            blurCanvas.drawColor(getOverlayColor());
            blurCanvas.save();
            setViewVisibility(0);
            float f5 = (float) width;
            int i5 = (int) (f5 * f2);
            float f6 = (float) i2;
            int i6 = (int) (f2 * f6);
            Bitmap createBitmap2 = Bitmap.createBitmap(i5, i6, Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(createBitmap2);
            Matrix matrix2 = new Matrix();
            matrix2.setScale(((float) i5) / f5, ((float) i6) / f6);
            canvas.setMatrix(matrix2);
            canvas.drawColor(getBlurBGColor());
            Paint paint = new Paint();
            paint.setFlags(3);
            canvas.drawBitmap(createBitmap, 0.0f, 0.0f, paint);
            createBitmap.recycle();
            return createBitmap2;
        }
        i2 = (int) (((float) (i3 + i)) * f);
        setViewVisibility(4);
        Bitmap createBitmap3 = Bitmap.createBitmap(width, i2, Bitmap.Config.ARGB_8888);
        BlurCanvas blurCanvas2 = new BlurCanvas(createBitmap3);
        Matrix matrix3 = new Matrix();
        matrix3.postScale(f, f);
        matrix3.postTranslate(f3, f4);
        blurCanvas2.setMatrix(matrix3);
        view.draw(blurCanvas2);
        blurCanvas2.drawColor(getOverlayColor());
        blurCanvas2.save();
        setViewVisibility(0);
        float f52 = (float) width;
        int i52 = (int) (f52 * f2);
        float f62 = (float) i2;
        int i62 = (int) (f2 * f62);
        Bitmap createBitmap22 = Bitmap.createBitmap(i52, i62, Bitmap.Config.ARGB_8888);
        Canvas canvas2 = new Canvas(createBitmap22);
        Matrix matrix22 = new Matrix();
        matrix22.setScale(((float) i52) / f52, ((float) i62) / f62);
        canvas2.setMatrix(matrix22);
        canvas2.drawColor(getBlurBGColor());
        Paint paint2 = new Paint();
        paint2.setFlags(3);
        canvas2.drawBitmap(createBitmap3, 0.0f, 0.0f, paint2);
        createBitmap3.recycle();
        return createBitmap22;
    }

    private int getOverlayColor() {
        String str = this.mBlurEffect;
        str.hashCode();
        str.hashCode();
        char c = 65535;
        switch (str.hashCode()) {
            case 3075958:
                if (str.equals(DARK)) {
                    c = 0;
                    break;
                }
                break;
            case 102970646:
                if (str.equals(LIGHT)) {
                    c = 1;
                    break;
                }
                break;
            case 759540486:
                if (str.equals(EXTRALIGHT)) {
                    c = 2;
                    break;
                }
                break;
        }
        switch (c) {
            case 0:
                return Color.parseColor(TitleNViewUtil.changeColorAlpha("#454545", this.mOverlayColorAlpha));
            case 1:
                return Color.parseColor(TitleNViewUtil.changeColorAlpha("#F8F8F8", this.mOverlayColorAlpha));
            case 2:
                return Color.parseColor(TitleNViewUtil.changeColorAlpha(TitleNViewUtil.TRANSPARENT_BUTTON_TEXT_COLOR, this.mOverlayColorAlpha));
            default:
                return 0;
        }
    }

    private Point getPositionInScreen() {
        PointF positionInScreen = getPositionInScreen(this);
        return new Point((int) positionInScreen.x, (int) positionInScreen.y);
    }

    private void initImageView() {
        ImageView imageView = this.mImageView;
        if (imageView == null) {
            this.mImageView = new ImageView(getContext());
        } else if (imageView.getParent() == null) {
            ((ViewGroup) this.mImageView.getParent()).removeView(this.mImageView);
        }
        this.mImageView.setScaleType(ImageView.ScaleType.FIT_XY);
        addView(this.mImageView, 0);
        setCornerRadius(this.mCornerRadius);
    }

    private void pauseBlur() {
        if (this.mRunning && this.isBlur) {
            this.mRunning = false;
            Choreographer.getInstance().removeFrameCallback(this.invalidationLoop);
        }
    }

    private void setViewVisibility(int i) {
        setVisibility(i);
        BlurLayoutChangeCallBack blurLayoutChangeCallBack = this.mChangeCB;
        if (blurLayoutChangeCallBack != null) {
            blurLayoutChangeCallBack.setVisibility(i);
        }
    }

    private void startBlur() {
        if (!this.mRunning && this.isBlur && this.mFPS > 0 && !this.mBlurState.equals("static")) {
            this.mRunning = true;
            Choreographer.getInstance().removeFrameCallback(this.postInvalidationLoop);
            Choreographer.getInstance().postFrameCallback(this.invalidationLoop);
        }
    }

    public boolean checkBlurEffect(String str) {
        if (!TextUtils.isEmpty(str)) {
            return str.equals(LIGHT) || str.equals(DARK) || str.equals(EXTRALIGHT);
        }
        return false;
    }

    public int getBlurBGColor() {
        String str = this.mBlurEffect;
        str.hashCode();
        str.hashCode();
        char c = 65535;
        switch (str.hashCode()) {
            case 3075958:
                if (str.equals(DARK)) {
                    c = 0;
                    break;
                }
                break;
            case 102970646:
                if (str.equals(LIGHT)) {
                    c = 1;
                    break;
                }
                break;
            case 759540486:
                if (str.equals(EXTRALIGHT)) {
                    c = 2;
                    break;
                }
                break;
        }
        switch (c) {
            case 0:
                return Color.parseColor("#F2454545");
            case 1:
                return Color.parseColor("#F2F8F8F8");
            case 2:
                return Color.parseColor("#F2FFFFFF");
            default:
                return 0;
        }
    }

    public void invalidate() {
        Bitmap makeBlur;
        super.invalidate();
        if (this.mAttachedToWindow && this.mImageView != null && this.isBlur && (makeBlur = makeBlur()) != null) {
            this.mImageView.setImageBitmap(makeBlur);
        }
    }

    /* JADX WARNING: Code restructure failed: missing block: B:40:0x00ac, code lost:
        if (r7 != 80) goto L_0x00ce;
     */
    public Bitmap makeBlur() {
        Bitmap bitmap = null;
        if (getContext() == null || isInEditMode() || !this.isBlur) {
            return null;
        }
        WeakReference<View> weakReference = this.mRootView;
        if (weakReference == null || weakReference.get() == null) {
            WeakReference<View> weakReference2 = new WeakReference<>(getActivityView());
            this.mRootView = weakReference2;
            if (weakReference2.get() == null) {
                return null;
            }
        }
        getLocationOnScreen(new int[2]);
        Point positionInScreen = getPositionInScreen();
        Rect rect = new Rect();
        if (!getGlobalVisibleRect(rect)) {
            return null;
        }
        int height = getHeight();
        int width = getWidth();
        boolean z = rect.height() >= height;
        int i = z ? this.mBlurRadius : 0;
        try {
            int i2 = positionInScreen.x;
            int i3 = positionInScreen.y;
            bitmap = getDownscaledBitmapForView(this.mRootView.get(), new Rect(i2, i3, width + i2, height + i3), this.mDownscaleFactor, i);
        } catch (Exception e) {
            e.printStackTrace();
        }
        if (bitmap == null) {
            return bitmap;
        }
        Bitmap processNatively = BlurManager.getInstance().processNatively(bitmap, this.mBlurRadius, false);
        int i4 = (int) (((float) i) * this.mDownscaleFactor);
        int i5 = z ? i4 : 0;
        int height2 = z ? processNatively.getHeight() - (i4 * 2) : processNatively.getHeight();
        int i6 = this.mGravityType;
        if (i6 != 17) {
            if (i6 == 48) {
                i5 = 5;
                height2 = (z ? processNatively.getHeight() - i4 : processNatively.getHeight()) - 5;
            }
            return Bitmap.createBitmap(processNatively, 0, i5, processNatively.getWidth(), height2);
        }
        height2 = z ? processNatively.getHeight() - (i4 * 2) : processNatively.getHeight();
        return Bitmap.createBitmap(processNatively, 0, i5, processNatively.getWidth(), height2);
    }

    /* JADX INFO: Can't fix incorrect switch cases order, some code will duplicate */
    /* access modifiers changed from: protected */
    /* JADX WARNING: Code restructure failed: missing block: B:9:0x002d, code lost:
        if (r1.equals(io.dcloud.common.ui.blur.DCBlurDraweeView.SEMI_AUTOMATICALLY) == false) goto L_0x001a;
     */
    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        char c = 1;
        this.mAttachedToWindow = true;
        if (this.isBlur) {
            String str = this.mBlurState;
            str.hashCode();
            str.hashCode();
            switch (str.hashCode()) {
                case -892481938:
                    if (str.equals("static")) {
                        c = 0;
                        break;
                    }
                    c = 65535;
                    break;
                case 1030681228:
                    break;
                case 1977933731:
                    if (str.equals(AUTOMATICALLY)) {
                        c = 2;
                        break;
                    }
                    c = 65535;
                    break;
                default:
                    c = 65535;
                    break;
            }
            switch (c) {
                case 0:
                    postInvalidate(this.mPostTime);
                    AppEventForBlurManager.removeEventChangedCallBack(this);
                    return;
                case 1:
                    postInvalidate(this.mPostTime);
                    AppEventForBlurManager.addEventChangedCallBack(this);
                    return;
                case 2:
                    AppEventForBlurManager.removeEventChangedCallBack(this);
                    startBlur();
                    return;
                default:
                    return;
            }
        }
    }

    @Override // io.dcloud.common.ui.blur.AppEventForBlurManager.OnAppChangedCallBack
    public void onContentScrollEnd() {
        pauseBlur();
    }

    @Override // io.dcloud.common.ui.blur.AppEventForBlurManager.OnAppChangedCallBack
    public void onContentScrollStart() {
        startBlur();
    }

    /* access modifiers changed from: protected */
    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mAttachedToWindow = false;
        pauseBlur();
        AppEventForBlurManager.removeEventChangedCallBack(this);
    }

    /* access modifiers changed from: protected */
    public void onSizeChanged(int i, int i2, int i3, int i4) {
        super.onSizeChanged(i, i2, i3, i4);
        if (this.isBlur) {
            postInvalidate(this.mPostTime);
        }
    }

    @Override // io.dcloud.common.ui.blur.AppEventForBlurManager.OnAppChangedCallBack
    public void onSplashclosed() {
        postInvalidate(this.mPostTime);
    }

    public void postInvalidate(long j) {
        if (!this.mRunning && this.isBlur) {
            MessageHandler.removeCallbacks(this.removePostDelayed);
            Choreographer.getInstance().removeFrameCallback(this.postInvalidationLoop);
            Choreographer.getInstance().postFrameCallback(this.postInvalidationLoop);
            MessageHandler.postDelayed(this.removePostDelayed, j + 10);
        }
    }

    public void setBlur(boolean z) {
        this.isBlur = z;
        if (z && this.mImageView == null) {
            initImageView();
        }
    }

    public void setBlurEffect(String str) {
        this.mBlurEffect = str;
        if (this.isBlur || !this.mBlurState.equals("none")) {
            setBackgroundColor(0);
        } else {
            setBackgroundColor(getBlurBGColor());
        }
    }

    public void setBlurLayoutChangeCallBack(BlurLayoutChangeCallBack blurLayoutChangeCallBack) {
        this.mChangeCB = blurLayoutChangeCallBack;
    }

    public void setBlurRadius(int i) {
        if (i < 0) {
            i = 15;
        } else if (i > 25) {
            i = 25;
        }
        this.mBlurRadius = i;
        invalidate();
    }

    public void setBlurState(String str) {
        this.mBlurState = str;
    }

    public void setContentFocusable(boolean z) {
        String str = this.mBlurState;
        str.hashCode();
        str.hashCode();
        char c = 65535;
        switch (str.hashCode()) {
            case -892481938:
                if (str.equals("static")) {
                    c = 0;
                    break;
                }
                break;
            case 1030681228:
                if (str.equals(SEMI_AUTOMATICALLY)) {
                    c = 1;
                    break;
                }
                break;
            case 1977933731:
                if (str.equals(AUTOMATICALLY)) {
                    c = 2;
                    break;
                }
                break;
        }
        switch (c) {
            case 0:
                AppEventForBlurManager.removeEventChangedCallBack(this);
                pauseBlur();
                return;
            case 1:
                if (z) {
                    AppEventForBlurManager.addEventChangedCallBack(this);
                    return;
                } else {
                    AppEventForBlurManager.removeEventChangedCallBack(this);
                    return;
                }
            case 2:
                if (z) {
                    startBlur();
                    return;
                } else {
                    pauseBlur();
                    return;
                }
            default:
                return;
        }
    }

    public void setCornerRadius(float f) {
        this.mCornerRadius = f;
        invalidate();
    }

    public void setDownscaleFactor(float f) {
        this.mDownscaleFactor = f;
        invalidate();
    }

    public void setFPS(int i) {
        if (this.mRunning) {
            pauseBlur();
        }
        this.mFPS = i;
    }

    public void setGravityType(int i) {
        this.mGravityType = i;
    }

    public void setOverlayColorAlpha(float f) {
        this.mOverlayColorAlpha = f;
    }

    public void setRootView(View view) {
        WeakReference<View> weakReference = this.mRootView;
        if (!(weakReference == null || weakReference.get() == null)) {
            this.mRootView.clear();
        }
        this.mRootView = new WeakReference<>(view);
    }

    private PointF getPositionInScreen(View view) {
        if (getParent() == null) {
            return new PointF();
        }
        if (this.mRootView.get() != null && view == this.mRootView.get()) {
            return new PointF();
        }
        try {
            ViewGroup viewGroup = (ViewGroup) view.getParent();
            if (viewGroup == null) {
                return new PointF();
            }
            PointF positionInScreen = getPositionInScreen(viewGroup);
            positionInScreen.offset(view.getX(), view.getY());
            return positionInScreen;
        } catch (Exception unused) {
            return new PointF();
        }
    }

    public DCBlurDraweeView(Context context, boolean z, String str) {
        super(context);
        this.isBlur = z;
        this.mBlurState = str;
        if (z) {
            initImageView();
        }
    }
}
