package io.dcloud.common.core.ui;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import android.widget.FrameLayout;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.dcloud.android.widget.TabView;
import com.taobao.weex.ui.component.WXBasicComponentType;
import io.dcloud.common.DHInterface.IApp;
import io.dcloud.common.DHInterface.ICallBack;
import io.dcloud.common.DHInterface.IFrameView;
import io.dcloud.common.DHInterface.IMgr;
import io.dcloud.common.DHInterface.IWebview;
import io.dcloud.common.adapter.ui.AdaFrameItem;
import io.dcloud.common.adapter.ui.AdaWebview;
import io.dcloud.common.adapter.ui.ReceiveJSValue;
import io.dcloud.common.constant.AbsoluteConst;
import java.util.ArrayList;
import java.util.Iterator;
import org.json.JSONException;

public class TabBarWebview extends AdaWebview {
    private boolean isVisible;
    private IApp mApp;
    private JSONArray mChildJson;
    private ArrayList<String> mPagePaths;
    ViewGroup mRoot;
    float mScale = 3.0f;
    private int mSelectIndex = 0;
    private TabView mTabBar;
    private JSONObject mTabBarJson;
    private ArrayList<b> mTabItems;
    private FrameLayout mTabLayout;
    private l mWindowMgr;

    /* access modifiers changed from: package-private */
    public class a implements Runnable {
        final /* synthetic */ b a;

        a(b bVar) {
            this.a = bVar;
        }

        public void run() {
            this.a.resize();
        }
    }

    class b implements Animation.AnimationListener {
        b() {
        }

        public void onAnimationEnd(Animation animation) {
            TabBarWebview.this.mTabBar.setVisibility(8);
        }

        public void onAnimationRepeat(Animation animation) {
        }

        public void onAnimationStart(Animation animation) {
        }
    }

    class c implements Runnable {
        c() {
        }

        public void run() {
            TabBarWebview.this.mTabBar.setVisibility(8);
        }
    }

    class d implements Animation.AnimationListener {
        d() {
        }

        public void onAnimationEnd(Animation animation) {
            TabBarWebview tabBarWebview = TabBarWebview.this;
            tabBarWebview.setTabItemsBottomMargin(tabBarWebview.mTabBar.getTabHeight());
        }

        public void onAnimationRepeat(Animation animation) {
        }

        public void onAnimationStart(Animation animation) {
        }
    }

    /* access modifiers changed from: package-private */
    public class e implements Runnable {
        final /* synthetic */ b a;

        e(b bVar) {
            this.a = bVar;
        }

        public void run() {
            ViewGroup viewGroup = (ViewGroup) this.a.obtainWebviewParent().obtainMainView();
            if (!(viewGroup == null || viewGroup.getHeight() == this.a.obtainMainView().getHeight())) {
                AdaFrameItem.LayoutParamsUtil.setViewLayoutParams(viewGroup, 0, 0, -1, -1);
            }
            this.a.resize();
        }
    }

    public TabBarWebview(Context context, IApp iApp, l lVar, c cVar, org.json.JSONObject jSONObject) {
        super(context);
        this.mFrameView = cVar;
        this.mWindowMgr = lVar;
        this.mTabItems = new ArrayList<>();
        this.mPagePaths = new ArrayList<>();
        initWebviewUUID("TabBar");
        initPagePaths(JSON.parseObject(jSONObject.toString()));
        this.mScale = context.getResources().getDisplayMetrics().density;
        this.mApp = iApp;
        JSONObject parseObject = JSON.parseObject(jSONObject.toString());
        this.mTabBarJson = parseObject;
        this.mChildJson = parseObject.getJSONArray("child");
        this.mTabLayout = new FrameLayout(context);
        if (this.mTabBarJson.containsKey("selected")) {
            String string = this.mTabBarJson.getString("selected");
            if (!TextUtils.isEmpty(string)) {
                this.mSelectIndex = Integer.valueOf(string).intValue();
            }
        }
        this.mRoot = (FrameLayout) cVar.obtainMainView();
        TabView tabView = new TabView(context, this.mRoot, this.mTabBarJson, this.mScale, iApp);
        this.mTabBar = tabView;
        setMainView(tabView);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
        layoutParams.bottomMargin = this.mTabBar.getTabHeight();
        this.mRoot.addView(this.mTabLayout, layoutParams);
        TabBarWebviewMgr.getInstance().setLancheTabBar(this);
        this.isVisible = true;
        cVar.addFrameItem(this, new ViewGroup.LayoutParams(-1, -1));
    }

    private void initPagePaths(JSONObject jSONObject) {
        if (jSONObject.containsKey(WXBasicComponentType.LIST)) {
            JSONArray jSONArray = jSONObject.getJSONArray(WXBasicComponentType.LIST);
            for (int i = 0; i < jSONArray.size(); i++) {
                String string = jSONArray.getJSONObject(i).getString("pagePath");
                if (!TextUtils.isEmpty(string)) {
                    if (string.startsWith("/")) {
                        string = string.substring(1);
                    }
                    this.mPagePaths.add(string);
                }
            }
        }
    }

    public void append(String str, ICallBack iCallBack) {
        l lVar;
        if (TextUtils.isEmpty(str) || (lVar = this.mWindowMgr) == null) {
            iCallBack.onCallBack(-1, null);
            return;
        }
        IMgr.MgrType mgrType = IMgr.MgrType.FeatureMgr;
        IApp iApp = this.mApp;
        Object processEvent = lVar.processEvent(mgrType, 10, new Object[]{iApp, AbsoluteConst.F_UI, "findWebview", new String[]{iApp.obtainAppId(), str}});
        if (processEvent == null || !(processEvent instanceof IWebview)) {
            iCallBack.onCallBack(-1, null);
            return;
        }
        IFrameView obtainFrameView = ((IWebview) processEvent).obtainFrameView();
        if (obtainFrameView instanceof b) {
            append((b) obtainFrameView);
            iCallBack.onCallBack(0, null);
        }
    }

    public boolean checkPagePathIsTab(String str) {
        Iterator<String> it = this.mPagePaths.iterator();
        while (it.hasNext()) {
            if (it.next().equalsIgnoreCase(str)) {
                return true;
            }
        }
        return false;
    }

    public boolean checkUrlToReload(String str) {
        try {
            Iterator<b> it = this.mTabItems.iterator();
            while (it.hasNext()) {
                b next = it.next();
                if (str.endsWith(".js")) {
                    Object[] objArr = {str};
                    next.mWindowMgr.processEvent(IMgr.MgrType.FeatureMgr, 10, new Object[]{next.obtainApp(), "weex,io.dcloud.feature.weex.WeexFeature", "updateReload", objArr});
                    return true;
                } else if (next.obtainWebView().obtainUrl().startsWith(str)) {
                    next.obtainWebView().reload();
                    return true;
                }
            }
        } catch (Exception unused) {
        }
        return false;
    }

    @Override // io.dcloud.common.adapter.ui.AdaFrameItem, io.dcloud.common.adapter.ui.AdaWebview, io.dcloud.common.adapter.ui.AdaContainerFrameItem
    public void dispose() {
        super.dispose();
        TabView tabView = this.mTabBar;
        if (tabView != null) {
            tabView.dispose();
        }
        this.mTabItems.clear();
        ArrayList<String> arrayList = this.mPagePaths;
        if (arrayList != null) {
            arrayList.clear();
        }
    }

    @Override // io.dcloud.common.DHInterface.IWebview, io.dcloud.common.adapter.ui.AdaWebview
    public void evalJS(String str) {
    }

    @Override // io.dcloud.common.DHInterface.IWebview, io.dcloud.common.adapter.ui.AdaWebview
    public void evalJS(String str, ReceiveJSValue.ReceiveJSValueCallback receiveJSValueCallback) {
    }

    @Override // io.dcloud.common.DHInterface.IWebview, io.dcloud.common.adapter.ui.AdaWebview
    public void executeScript(String str) {
    }

    @Override // io.dcloud.common.DHInterface.IWebview, io.dcloud.common.adapter.ui.AdaWebview
    public float getScale() {
        return this.mScale;
    }

    public int getSelectIndex() {
        return this.mSelectIndex;
    }

    public String getTabBarHeight() {
        return this.mTabBar.getTabHeightStr().substring(0, this.mTabBar.getTabHeightStr().length() - 2);
    }

    public void hideTabBar(JSONObject jSONObject) {
        if (this.isVisible) {
            boolean booleanValue = jSONObject.containsKey("animation") ? jSONObject.getBoolean("animation").booleanValue() : false;
            setTabItemsBottomMargin(0);
            this.mTabBar.bringToFront();
            this.mTabBar.bringMaskToFront();
            if (booleanValue) {
                TranslateAnimation translateAnimation = new TranslateAnimation(0.0f, 0.0f, 0.0f, (float) (this.mTabBar.getTabHeight() + this.mTabBar.getMidHeight()));
                translateAnimation.setDuration(100);
                translateAnimation.setAnimationListener(new b());
                this.mTabBar.startAnimation(translateAnimation);
            } else {
                this.mTabBar.postDelayed(new c(), 150);
            }
            this.isVisible = false;
        }
    }

    public void hideTabBarRedDot(JSONObject jSONObject) {
        this.mTabBar.hideTabBarRedDot(jSONObject);
    }

    public boolean isInsertLauch() {
        if (this.mChildJson != null) {
            for (int i = 0; i < this.mChildJson.size(); i++) {
                if (this.mChildJson.getString(i).equals("lauchwebview")) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    @Override // io.dcloud.common.DHInterface.IWebview
    public IApp obtainApp() {
        return this.mApp;
    }

    @Override // io.dcloud.common.DHInterface.IWebview, io.dcloud.common.adapter.ui.AdaWebview
    public ViewGroup obtainWindowView() {
        return this.mRoot;
    }

    /* access modifiers changed from: protected */
    @Override // io.dcloud.common.adapter.ui.AdaFrameItem, io.dcloud.common.adapter.ui.AdaContainerFrameItem
    public void onResize() {
        super.onResize();
    }

    public void popFrame(String str) {
        IApp iApp;
        Object processEvent;
        if (this.mTabLayout != null && (processEvent = this.mWindowMgr.processEvent(IMgr.MgrType.FeatureMgr, 10, new Object[]{(iApp = this.mApp), AbsoluteConst.F_UI, "findWebview", new String[]{iApp.obtainAppId(), str}})) != null && (processEvent instanceof IWebview)) {
            ((IWebview) processEvent).obtainFrameView().obtainMainView().setVisibility(8);
        }
    }

    public void pushFrame(String str) {
        IApp iApp;
        Object processEvent;
        if (this.mTabLayout != null && (processEvent = this.mWindowMgr.processEvent(IMgr.MgrType.FeatureMgr, 10, new Object[]{(iApp = this.mApp), AbsoluteConst.F_UI, "findWebview", new String[]{iApp.obtainAppId(), str}})) != null && (processEvent instanceof IWebview)) {
            ((IWebview) processEvent).obtainFrameView().obtainMainView().setVisibility(0);
        }
    }

    public void removeFrameView(b bVar) {
        FrameLayout frameLayout;
        if (bVar != null && (frameLayout = this.mTabLayout) != null) {
            frameLayout.removeView(bVar.obtainMainView());
            if (this.mTabItems.contains(bVar)) {
                this.mTabItems.remove(bVar);
            }
            if (this.mTabItems.size() == 0 && this.mTabBar.getVisibility() == 0) {
                this.mTabBar.setVisibility(4);
            }
        }
    }

    public void removeTabBarBadge(JSONObject jSONObject) {
        this.mTabBar.removeTabBarBadge(jSONObject);
    }

    public void setClickCallBack(ICallBack iCallBack) {
        this.mTabBar.setSingleCallbackListener(iCallBack);
    }

    public void setDoubleClickCallBack(ICallBack iCallBack) {
        this.mTabBar.setDoubleCallbackListener(iCallBack);
    }

    @Override // io.dcloud.common.DHInterface.IWebview, io.dcloud.common.adapter.ui.AdaWebview
    public void setIWebViewFocusable(boolean z) {
        super.setIWebViewFocusable(z);
        ArrayList<b> arrayList = this.mTabItems;
        if (arrayList != null) {
            Iterator<b> it = arrayList.iterator();
            while (it.hasNext()) {
                b next = it.next();
                if (!(next == null || next.obtainWebView() == null)) {
                    next.obtainWebView().setIWebViewFocusable(z);
                }
            }
        }
        TabView tabView = this.mTabBar;
        if (tabView != null) {
            tabView.setIWebViewFocusable(z);
        }
    }

    public void setItem(JSONObject jSONObject) {
        this.mTabBar.setTabBarItem(jSONObject);
    }

    public void setMask(JSONObject jSONObject) {
        this.mTabBar.setMask(jSONObject);
    }

    public void setMaskButtonClickCallBack(ICallBack iCallBack) {
        this.mTabBar.setMaskCallbackListener(iCallBack);
    }

    public void setMidButtonClickCallBack(ICallBack iCallBack) {
        this.mTabBar.setMidCallbackListener(iCallBack);
    }

    public void setStyle(JSONObject jSONObject) {
        if (jSONObject != null) {
            this.mTabBar.setTabBarStyle(jSONObject);
            if (jSONObject.containsKey("height")) {
                setTabItemsBottomMargin(this.isVisible ? this.mTabBar.getTabHeight() : 0);
            }
        }
    }

    public void setTabBarBadge(JSONObject jSONObject) {
        this.mTabBar.setTabBarBadge(jSONObject);
    }

    public void setTabItemsBottomMargin(int i) {
        String str;
        if (this.mTabItems != null) {
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams) this.mTabLayout.getLayoutParams();
            layoutParams.bottomMargin = i;
            this.mTabLayout.setLayoutParams(layoutParams);
            Iterator<b> it = this.mTabItems.iterator();
            while (it.hasNext()) {
                b next = it.next();
                if (!(next == null || next.obtainMainView() == null)) {
                    org.json.JSONObject jSONObject = new org.json.JSONObject();
                    try {
                        jSONObject.put("top", "0px");
                        if (i > 0) {
                            str = this.mTabBar.getTabHeightStr();
                        } else {
                            str = "0px";
                        }
                        jSONObject.put("bottom", str);
                        jSONObject.put("isTab", true);
                    } catch (JSONException e2) {
                        e2.printStackTrace();
                    }
                    next.obtainFrameOptions().updateViewData(jSONObject);
                    next.obtainMainView().post(new e(next));
                }
            }
            this.mFrameView.resize();
        }
    }

    @Override // io.dcloud.common.DHInterface.IWebview
    public void show(Animation animation) {
    }

    public void showTabBar(JSONObject jSONObject) {
        if (!this.isVisible) {
            if (jSONObject.containsKey("animation") ? jSONObject.getBoolean("animation").booleanValue() : false) {
                TranslateAnimation translateAnimation = new TranslateAnimation(0.0f, 0.0f, (float) (this.mTabBar.getTabHeight() + this.mTabBar.getMidHeight()), 0.0f);
                translateAnimation.setDuration(100);
                translateAnimation.setAnimationListener(new d());
                this.mTabBar.startAnimation(translateAnimation);
            } else {
                setTabItemsBottomMargin(this.mTabBar.getTabHeight());
            }
            this.mTabBar.setVisibility(0);
            this.isVisible = true;
        }
    }

    public void showTabBarRedDot(JSONObject jSONObject) {
        this.mTabBar.showTabBarRedDot(jSONObject);
    }

    public void switchSelect(int i) {
        this.mSelectIndex = i;
        this.mTabBar.switchTab(i);
    }

    public void tabItemActive(b bVar) {
        for (int i = 0; i < this.mTabItems.size(); i++) {
            b bVar2 = this.mTabItems.get(i);
            if (bVar == null || bVar2 != bVar) {
                this.mTabItems.get(i).obtainMainView().setImportantForAccessibility(4);
                bVar2.obtainMainView().setImportantForAccessibility(4);
            } else {
                bVar2.obtainMainView().setImportantForAccessibility(0);
            }
        }
    }

    public void updateMidButton(JSONObject jSONObject) {
        this.mTabBar.updateMidButton(jSONObject);
    }

    public void append(b bVar) {
        int i;
        String str = "0px";
        if (bVar != null) {
            View obtainMainView = bVar.obtainMainView();
            if (obtainMainView.getParent() != null) {
                bVar.q();
                bVar.getAnimOptions().mOption = 1;
                bVar.p.b(bVar);
                if (bVar.f()) {
                    this.mWindowMgr.processEvent(IMgr.MgrType.WindowMgr, 28, bVar.g);
                    bVar.g = null;
                }
                bVar.s();
                bVar.b(false);
                bVar.getAnimOptions().mOption = 0;
                ViewGroup viewGroup = (ViewGroup) obtainMainView.getParent();
                i = viewGroup == this.mTabLayout ? viewGroup.indexOfChild(obtainMainView) : -1;
                viewGroup.removeView(obtainMainView);
            } else {
                i = -1;
            }
            bVar.setTabItem(true);
            this.mWindowMgr.processEvent(IMgr.MgrType.WindowMgr, 22, bVar);
            org.json.JSONObject jSONObject = new org.json.JSONObject();
            try {
                jSONObject.put("top", str);
                if (this.isVisible) {
                    str = this.mTabBar.getTabHeightStr();
                }
                jSONObject.put("bottom", str);
                jSONObject.put("isTab", true);
            } catch (JSONException e2) {
                e2.printStackTrace();
            }
            bVar.obtainFrameOptions().setParentViewRect(this.mFrameView.obtainFrameOptions());
            bVar.obtainFrameOptions().updateViewData(jSONObject);
            bVar.setParentFrameItem(this.mFrameView);
            this.mFrameView.mChildArrayList.add(bVar);
            bVar.inStack = true;
            bVar.isChildOfFrameView = true;
            this.mTabLayout.addView(obtainMainView, i, new FrameLayout.LayoutParams(-1, -1));
            bVar.obtainWebView().setIWebViewFocusable(true);
            if (!this.mTabItems.contains(bVar)) {
                this.mTabItems.add(bVar);
            }
            if (this.mTabItems.size() > 0 && this.mTabBar.getVisibility() != 0 && this.isVisible) {
                this.mTabBar.setVisibility(0);
            }
            if (obtainMainView.getImportantForAccessibility() == 4) {
                obtainMainView.setImportantForAccessibility(0);
            }
            bVar.obtainMainView().post(new a(bVar));
        }
    }
}
