package io.dcloud.common.core.ui;

import android.app.Activity;
import android.graphics.Rect;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.webkit.WebView;
import android.widget.FrameLayout;
import io.dcloud.common.DHInterface.IActivityDelegate;
import io.dcloud.common.DHInterface.IActivityHandler;
import io.dcloud.common.DHInterface.IFrameView;
import io.dcloud.common.DHInterface.IMgr;
import io.dcloud.common.DHInterface.IWebview;
import io.dcloud.common.adapter.ui.AdaFrameView;
import io.dcloud.common.adapter.util.AndroidResources;
import io.dcloud.common.adapter.util.DeviceInfo;
import io.dcloud.common.core.ui.DCKeyboardManager;
import io.dcloud.common.core.ui.keyboard.DCEditText;
import io.dcloud.common.util.BaseInfo;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.common.util.StringUtil;
import io.src.dcloud.adapter.DCloudAdapterUtil;
import java.lang.ref.SoftReference;
import org.json.JSONObject;

public class DCKeyboardManager {
    public static String SOFT_INPUT_MODE_ADJUST_NOTHING = "nothing";
    public static String SOFT_INPUT_MODE_ADJUST_PAN = "adjustPan";
    public static String SOFT_INPUT_MODE_ADJUST_RESIZE = "adjustResize";
    public static DCKeyboardManager instance;
    String EVENTS_DOCUMENT_KEYBOARD = "javascript:(function(){if(!((window.__html5plus__&&__html5plus__.isReady)?__html5plus__:(navigator.plus&&navigator.plus.isReady)?navigator.plus:window.plus)){window.__load__plus__&&window.__load__plus__();}var e = document.createEvent('HTMLEvents');var evt = '%s';e.initEvent(evt, false, true); e.height = %d;/*console.log('dispatch ' + evt + ' event');*/document.dispatchEvent(e);})();";
    private final String TAG = "DCKeyboardManager";
    private boolean isAdjust = true;
    boolean isAdministration = false;
    private boolean isAllScreen = false;
    private boolean isNativeFocus = false;
    boolean isNativeUpDate = false;
    private Runnable keyBoardHideRunnable;
    private Runnable keyBoardShowRunnable;
    private String mActivitySoftInputMode = "";
    private View mContentView;
    private a mDHAppRoot;
    private float mFocusTop = 0.0f;
    private String mFrontInputType = "text";
    private Handler mHandler;
    private float mHtmlInputFT = -1.0f;
    String mInputMode;
    private IFrameView mInputRootFrame = null;
    private ViewTreeObserver.OnGlobalLayoutListener mLayoutChangeListener;
    float mNaiveCursorSpacing = 0.0f;
    private View mNativeView = null;
    int mOrientation = -100;
    private View mRootContentView;
    private SoftReference<Activity> mSoftAc = null;
    int rootViewVisibleHeight;

    class a implements ViewTreeObserver.OnGlobalLayoutListener {
        final /* synthetic */ Activity a;

        /* access modifiers changed from: package-private */
        /* renamed from: io.dcloud.common.core.ui.DCKeyboardManager$a$a  reason: collision with other inner class name */
        public class RunnableC0015a implements Runnable {
            final /* synthetic */ int a;

            RunnableC0015a(int i) {
                this.a = i;
            }

            public void run() {
                DCKeyboardManager.this.onKeyboardChanged(this.a, true);
                AndroidResources.sIMEAlive = true;
                DeviceInfo.isIMEShow = true;
                DeviceInfo.sInputMethodHeight = Math.abs(this.a);
            }
        }

        /* access modifiers changed from: package-private */
        public class b implements Runnable {
            b() {
            }

            public void run() {
                DCKeyboardManager.this.onKeyboardChanged(-1, AndroidResources.sIMEAlive);
                if (DCKeyboardManager.this.mDHAppRoot != null) {
                    DCKeyboardManager.this.mDHAppRoot.h();
                }
                AndroidResources.sIMEAlive = false;
                DeviceInfo.isIMEShow = false;
            }
        }

        a(Activity activity) {
            this.a = activity;
        }

        /* access modifiers changed from: private */
        public /* synthetic */ void a(Activity activity) {
            int i;
            int height = DCKeyboardManager.this.mRootContentView.getHeight();
            int height2 = ((FrameLayout) DCKeyboardManager.this.mRootContentView).getChildAt(0).getHeight();
            DCKeyboardManager dCKeyboardManager = DCKeyboardManager.this;
            if (dCKeyboardManager.rootViewVisibleHeight == 0) {
                dCKeyboardManager.rootViewVisibleHeight = height;
                return;
            }
            boolean isFullScreen = PdrUtil.isFullScreen(activity);
            Rect rect = new Rect();
            DCKeyboardManager.this.mContentView.getWindowVisibleDisplayFrame(rect);
            int height3 = rect.height();
            if (!isFullScreen && (i = DeviceInfo.sStatusBarHeight + height3) <= height2) {
                height3 = i;
            }
            int i2 = DCKeyboardManager.this.isAllScreen ? height / 6 : height / 5;
            DCKeyboardManager dCKeyboardManager2 = DCKeyboardManager.this;
            if (dCKeyboardManager2.rootViewVisibleHeight != height3) {
                int i3 = height2 - height3;
                if (i3 > i2) {
                    try {
                        if (dCKeyboardManager2.keyBoardShowRunnable != null) {
                            DCKeyboardManager.this.mHandler.removeCallbacks(DCKeyboardManager.this.keyBoardShowRunnable);
                        }
                        DCKeyboardManager.this.keyBoardShowRunnable = new RunnableC0015a(i3);
                        DCKeyboardManager.this.mHandler.post(DCKeyboardManager.this.keyBoardShowRunnable);
                    } catch (Exception e) {
                        e.printStackTrace();
                        return;
                    }
                } else {
                    if (dCKeyboardManager2.keyBoardHideRunnable != null) {
                        DCKeyboardManager.this.mHandler.removeCallbacks(DCKeyboardManager.this.keyBoardHideRunnable);
                    }
                    DCKeyboardManager.this.keyBoardHideRunnable = new b();
                    DCKeyboardManager.this.mHandler.post(DCKeyboardManager.this.keyBoardHideRunnable);
                }
                DCKeyboardManager.this.rootViewVisibleHeight = height3;
            }
        }

        public void onGlobalLayout() {
            if (DCKeyboardManager.this.mContentView != null) {
                DCKeyboardManager.this.mContentView.post(new Runnable(this.a) {
                    /* class io.dcloud.common.core.ui.$$Lambda$DCKeyboardManager$a$139pqmr69TfsahKdMjQXJSoCWy0 */
                    public final /* synthetic */ Activity f$1;

                    {
                        this.f$1 = r2;
                    }

                    public final void run() {
                        DCKeyboardManager.a.this.a(this.f$1);
                    }
                });
            }
        }
    }

    class b implements Runnable {
        b() {
        }

        public void run() {
            DCKeyboardManager.this.onKeyboardChanged(DCKeyboardManager.this.getKeyBoardHeight(), true);
        }
    }

    class c implements Runnable {
        c() {
        }

        public void run() {
            DCKeyboardManager.this.onKeyboardChanged(DCKeyboardManager.this.getKeyBoardHeight(), true);
        }
    }

    /* access modifiers changed from: package-private */
    public class d implements Runnable {
        final /* synthetic */ String a;
        final /* synthetic */ AdaFrameView b;
        final /* synthetic */ View c;

        d(String str, AdaFrameView adaFrameView, View view) {
            this.a = str;
            this.b = adaFrameView;
            this.c = view;
        }

        public void run() {
            if (this.a.equals(DCKeyboardManager.SOFT_INPUT_MODE_ADJUST_PAN)) {
                int i = 0;
                AdaFrameView adaFrameView = this.b;
                if (adaFrameView != null) {
                    i = adaFrameView.obtainFrameOptions().top;
                }
                View view = this.c;
                if (view != null) {
                    view.setTranslationY((float) i);
                }
            }
            ViewGroup.LayoutParams layoutParams = DCKeyboardManager.this.mContentView.getLayoutParams();
            layoutParams.height = -1;
            layoutParams.width = -1;
            DCKeyboardManager.this.mContentView.setLayoutParams(layoutParams);
        }
    }

    /* access modifiers changed from: package-private */
    public class e implements Runnable {
        final /* synthetic */ int a;
        final /* synthetic */ View b;

        e(int i, View view) {
            this.a = i;
            this.b = view;
        }

        public void run() {
            this.b.setTranslationY(((float) this.a) - DCKeyboardManager.this.mFocusTop);
        }
    }

    private void fireKeyboardEvent(IFrameView iFrameView, int i) {
        if (!iFrameView.obtainWebView().isUniWebView()) {
            iFrameView.obtainWebView().loadUrl(StringUtil.format(this.EVENTS_DOCUMENT_KEYBOARD, "keyboardchange", Integer.valueOf((int) (((float) i) / iFrameView.obtainWebView().getScale()))));
        }
        if (BaseInfo.isUniAppAppid(iFrameView.obtainApp())) {
            Object[] objArr = {"__uniapp__service", Integer.valueOf(i)};
            iFrameView.obtainWindowMgr().processEvent(IMgr.MgrType.FeatureMgr, 10, new Object[]{iFrameView.obtainApp(), "weex,io.dcloud.feature.weex.WeexFeature", "onKeyboardHeightChange", objArr});
        }
    }

    private String getActivityInput(Activity activity) {
        int i = activity.getWindow().getAttributes().softInputMode;
        if (i == 16) {
            return SOFT_INPUT_MODE_ADJUST_RESIZE;
        }
        if (i == 32) {
            return SOFT_INPUT_MODE_ADJUST_PAN;
        }
        if (i == 48) {
            return SOFT_INPUT_MODE_ADJUST_NOTHING;
        }
        String metaValue = AndroidResources.getMetaValue("DCLOUD_INPUT_MODE");
        if (!TextUtils.isEmpty(metaValue)) {
            return metaValue;
        }
        return SOFT_INPUT_MODE_ADJUST_RESIZE;
    }

    public static DCKeyboardManager getInstance() {
        if (instance == null) {
            instance = new DCKeyboardManager();
        }
        return instance;
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private int getKeyBoardHeight() {
        SoftReference<Activity> softReference;
        int i;
        if (this.mContentView == null || (softReference = this.mSoftAc) == null || softReference.get() == null) {
            return 0;
        }
        boolean isFullScreen = PdrUtil.isFullScreen(this.mSoftAc.get());
        Rect rect = new Rect();
        this.mContentView.getWindowVisibleDisplayFrame(rect);
        int height = rect.height();
        int height2 = ((FrameLayout) this.mRootContentView).getChildAt(0).getHeight();
        if (!isFullScreen && (i = DeviceInfo.sStatusBarHeight + height) <= height2) {
            height = i;
        }
        return height2 - height;
    }

    private static View getScrollView(View view) {
        if (view instanceof ViewGroup) {
            try {
                if (view.canScrollVertically(1)) {
                    return view;
                }
                for (int i = 0; i < ((ViewGroup) view).getChildCount(); i++) {
                    View scrollView = getScrollView(((ViewGroup) view).getChildAt(i));
                    if (scrollView != null) {
                        return scrollView;
                    }
                }
            } catch (Exception unused) {
            }
        }
        return null;
    }

    private void keyboardHide(AdaFrameView adaFrameView, View view, String str) {
        if (this.isAdjust) {
            this.mFocusTop = 0.0f;
            this.mContentView.post(new d(str, adaFrameView, view));
        }
    }

    private void keyboardShow(View view, int i, String str, boolean z) {
        if (!str.equals(SOFT_INPUT_MODE_ADJUST_NOTHING) && this.isAdjust && !DeviceInfo.isIMEShow) {
            int height = this.mContentView.getHeight();
            if (str.equals(SOFT_INPUT_MODE_ADJUST_RESIZE)) {
                ViewGroup.LayoutParams layoutParams = this.mContentView.getLayoutParams();
                layoutParams.height = height - i;
                this.mContentView.setLayoutParams(layoutParams);
                return;
            }
            int i2 = height - i;
            if (!z) {
                this.mFocusTop = this.mHtmlInputFT;
            }
            float f = 0.0f;
            if (DeviceInfo.isIMEShow) {
                f = 0.0f - view.getTranslationY();
            }
            if (((float) i2) < this.mFocusTop - f) {
                this.mContentView.post(new e(i2, view));
            }
        }
    }

    public void dhAppRootIsReady(a aVar) {
        if (this.isAdministration) {
            this.mDHAppRoot = aVar;
            this.mContentView.getViewTreeObserver().addOnGlobalLayoutListener(this.mLayoutChangeListener);
        }
    }

    public String getFrameSoftInputMode() {
        a aVar = this.mDHAppRoot;
        if (aVar != null) {
            return aVar.i().obtainFrameOptions().softinputMode;
        }
        return null;
    }

    public String getFrontInputType() {
        return this.mFrontInputType;
    }

    public View getNativeInput() {
        return this.mNativeView;
    }

    public boolean isTakeOver() {
        String frameSoftInputMode = getInstance().getFrameSoftInputMode();
        if (frameSoftInputMode != null) {
            return SOFT_INPUT_MODE_ADJUST_PAN.equals(frameSoftInputMode) || SOFT_INPUT_MODE_ADJUST_NOTHING.equals(frameSoftInputMode);
        }
        return false;
    }

    public void nativeEditTextFocus(String str, View view, boolean z, String str2, float f) {
        this.isNativeFocus = z;
        this.isNativeUpDate = true;
        this.mInputRootFrame = null;
        this.mInputMode = str2;
        if (z) {
            this.mNativeView = view;
            this.mNaiveCursorSpacing = f;
            if (this.mDHAppRoot != null && !TextUtils.isEmpty(str)) {
                b i = this.mDHAppRoot.i();
                if (i != null) {
                    Object[] objArr = {str};
                    Object processEvent = i.obtainWindowMgr().processEvent(IMgr.MgrType.FeatureMgr, 10, new Object[]{i.obtainApp(), "weex,io.dcloud.feature.weex.WeexFeature", "findWebviewByInstanceId", objArr});
                    if (processEvent != null && (processEvent instanceof IWebview)) {
                        this.mInputRootFrame = ((IWebview) processEvent).obtainFrameView();
                    }
                } else {
                    return;
                }
            }
            if (!str2.equals(SOFT_INPUT_MODE_ADJUST_NOTHING) && DeviceInfo.isIMEShow) {
                Runnable runnable = this.keyBoardShowRunnable;
                if (runnable != null) {
                    this.mHandler.removeCallbacks(runnable);
                }
                c cVar = new c();
                this.keyBoardShowRunnable = cVar;
                this.mHandler.post(cVar);
            }
        }
    }

    public void onCreate(Activity activity) {
        this.mActivitySoftInputMode = getActivityInput(activity);
        this.isAdministration = true;
        this.mSoftAc = new SoftReference<>(activity);
        this.mHandler = new Handler(Looper.getMainLooper());
        this.mOrientation = activity.getResources().getConfiguration().orientation;
        this.mRootContentView = activity.getWindow().getDecorView();
        IActivityHandler iActivityHandler = DCloudAdapterUtil.getIActivityHandler(activity);
        if (iActivityHandler != null) {
            this.mContentView = iActivityHandler.obtainActivityContentView();
        } else if (activity instanceof IActivityDelegate) {
            this.mContentView = ((IActivityDelegate) activity).obtainActivityContentView();
        }
        this.isAllScreen = PdrUtil.isAllScreenDevice(activity);
        DeviceInfo.updateStatusBarHeight(activity);
        this.mLayoutChangeListener = new a(activity);
    }

    public void onKeyboardChanged(int i, boolean z) {
        b i2;
        View view;
        View view2;
        if (this.isAdjust && this.mDHAppRoot != null && this.mActivitySoftInputMode.equals(SOFT_INPUT_MODE_ADJUST_RESIZE) && (i2 = this.mDHAppRoot.i()) != null) {
            if (TextUtils.isEmpty(this.mInputMode)) {
                this.mInputMode = getFrameSoftInputMode();
            }
            if (z) {
                IFrameView iFrameView = this.mInputRootFrame;
                if (iFrameView != null && iFrameView.obtainWebView() != null) {
                    fireKeyboardEvent(this.mInputRootFrame, i);
                } else if (i2.obtainWebView() != null) {
                    fireKeyboardEvent(i2, i);
                }
            }
            if (i <= 1 || !this.mInputMode.equals(SOFT_INPUT_MODE_ADJUST_NOTHING)) {
                int height = this.mContentView.getHeight();
                IFrameView iFrameView2 = this.mInputRootFrame;
                if (iFrameView2 == null) {
                    view = i2.getChilds().size() > 1 ? i2.obtainMainView() : i2.obtainWebView().obtainWindowView();
                } else if (iFrameView2.obtainWebView() == null) {
                    this.mInputRootFrame = null;
                    return;
                } else {
                    view = this.mInputRootFrame.obtainWebView().obtainWindowView();
                }
                if (i <= 0) {
                    try {
                        View view3 = this.mNativeView;
                        if ((view3 instanceof DCEditText) && ((DCEditText) view3).getKeyboardHeightChangeListener() != null) {
                            ((DCEditText) this.mNativeView).getKeyboardHeightChangeListener().onChange(false, i);
                        }
                        if (this.mInputRootFrame == null) {
                            if (i2.getChilds().size() > 1) {
                                keyboardHide(i2, view, this.mInputMode);
                                this.isNativeUpDate = true;
                            }
                        }
                        i2 = null;
                        keyboardHide(i2, view, this.mInputMode);
                        this.isNativeUpDate = true;
                    } catch (Exception unused) {
                        this.mInputMode = null;
                        this.mNativeView = null;
                    }
                } else if (!this.isNativeFocus || (view2 = this.mNativeView) == null) {
                    this.mNativeView = null;
                    this.isNativeUpDate = true;
                    if (this.mInputMode.equals(SOFT_INPUT_MODE_ADJUST_PAN)) {
                        float f = this.mHtmlInputFT;
                        float f2 = (float) height;
                        if (f > f2) {
                            int i3 = (int) (f - f2);
                            if (view instanceof WebView) {
                                view.scrollBy(0, i3);
                            }
                            this.mHtmlInputFT = f2;
                        }
                    }
                    keyboardShow(view, i, this.mInputMode, false);
                } else {
                    if (this.isNativeUpDate) {
                        int[] iArr = new int[2];
                        view2.getLocationOnScreen(iArr);
                        float height2 = ((float) (iArr[1] + this.mNativeView.getHeight())) + this.mNaiveCursorSpacing;
                        this.mFocusTop = height2;
                        float f3 = (float) height;
                        if (height2 > f3) {
                            int i4 = (int) (height2 - f3);
                            View scrollView = getScrollView(view);
                            if (scrollView != null) {
                                scrollView.scrollBy(0, i4);
                            }
                            this.mFocusTop = f3;
                        }
                        this.isNativeUpDate = false;
                    }
                    View view4 = this.mNativeView;
                    if ((view4 instanceof DCEditText) && ((DCEditText) view4).getKeyboardHeightChangeListener() != null) {
                        ((DCEditText) this.mNativeView).getKeyboardHeightChangeListener().onChange(true, i);
                    }
                    keyboardShow(view, i, this.mInputMode, true);
                }
            } else {
                View view5 = this.mNativeView;
                if (view5 != null && (view5 instanceof DCEditText) && ((DCEditText) view5).getKeyboardHeightChangeListener() != null) {
                    ((DCEditText) this.mNativeView).getKeyboardHeightChangeListener().onChange(true, i);
                }
            }
        }
    }

    public void onStop() {
        if (this.isAdministration) {
            if (Build.VERSION.SDK_INT >= 16) {
                this.mRootContentView.getViewTreeObserver().removeOnGlobalLayoutListener(this.mLayoutChangeListener);
            } else {
                this.mRootContentView.getViewTreeObserver().removeGlobalOnLayoutListener(this.mLayoutChangeListener);
            }
        }
    }

    public void setAdjust(boolean z) {
        this.isAdjust = z;
    }

    public void setContentView(IActivityHandler iActivityHandler) {
        if (iActivityHandler != null) {
            this.mContentView = iActivityHandler.obtainActivityContentView();
        }
    }

    public void setFrontInputType(String str) {
        this.mFrontInputType = str;
    }

    public void setHTMLInputRect(IWebview iWebview, String str) {
        try {
            if (this.isAdjust) {
                IFrameView obtainFrameView = iWebview.obtainFrameView();
                this.mInputRootFrame = obtainFrameView;
                if (obtainFrameView != null) {
                    int[] iArr = new int[2];
                    obtainFrameView.obtainWebView().obtainWindowView().getLocationOnScreen(iArr);
                    JSONObject jSONObject = new JSONObject(str);
                    JSONObject jSONObject2 = jSONObject.getJSONObject("position");
                    String optString = jSONObject.optString("mode");
                    this.mInputMode = optString;
                    if (!optString.equals(SOFT_INPUT_MODE_ADJUST_NOTHING)) {
                        float parseFloat = PdrUtil.parseFloat(jSONObject2.optString("top"), 0.0f, 0.0f, iWebview.getScale()) + PdrUtil.parseFloat(jSONObject2.optString("height"), 0.0f, 0.0f, iWebview.getScale()) + ((float) iArr[1]);
                        this.mHtmlInputFT = parseFloat;
                        this.mFocusTop = parseFloat;
                        if (DeviceInfo.isIMEShow) {
                            Runnable runnable = this.keyBoardShowRunnable;
                            if (runnable != null) {
                                this.mHandler.removeCallbacks(runnable);
                            }
                            b bVar = new b();
                            this.keyBoardShowRunnable = bVar;
                            this.mHandler.post(bVar);
                        }
                    }
                }
            }
        } catch (Exception e2) {
            e2.printStackTrace();
            this.mInputMode = null;
            this.mFocusTop = 0.0f;
            this.mHtmlInputFT = 0.0f;
        }
    }

    public void setNativeInput(View view, float f) {
        this.mNativeView = view;
        this.mNaiveCursorSpacing = f;
        this.isNativeUpDate = true;
    }
}
