package io.dcloud.common.constant;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.text.TextUtils;
import com.facebook.common.callercontext.ContextChain;
import com.taobao.weex.common.WXConfig;
import com.taobao.weex.el.parse.Operators;
import io.dcloud.common.adapter.util.AndroidResources;
import io.dcloud.common.adapter.util.DeviceInfo;
import io.dcloud.common.adapter.util.Logger;
import io.dcloud.common.adapter.util.MobilePhoneModel;
import io.dcloud.common.adapter.util.SP;
import io.dcloud.common.util.BaseInfo;
import io.dcloud.common.util.CreateShortResultReceiver;
import io.dcloud.common.util.NetworkTypeUtil;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.common.util.TelephonyUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;

public class DataInterface {
    public static String getRomVersion() {
        String str;
        if (!Build.MANUFACTURER.equals(MobilePhoneModel.XIAOMI)) {
            return Build.VERSION.INCREMENTAL;
        }
        String buildValue = DeviceInfo.getBuildValue("ro.miui.ui.version.name");
        StringBuilder sb = new StringBuilder();
        sb.append(Build.VERSION.INCREMENTAL);
        if (TextUtils.isEmpty(buildValue)) {
            str = "";
        } else {
            str = Operators.SUB + buildValue;
        }
        sb.append(str);
        return sb.toString();
    }

    public static HashMap getStartupUrlBaseData(Context context, String str, String str2, String str3, boolean z) {
        String bundleData = SP.getBundleData(context, "pdr", SP.STARTUP_DEVICE_ID);
        if (PdrUtil.isEmpty(bundleData)) {
            bundleData = TelephonyUtil.getSBBS(context, true, true, false);
        }
        int networkType = NetworkTypeUtil.getNetworkType(context);
        String str4 = Build.MODEL;
        int i = Build.VERSION.SDK_INT;
        String str5 = DeviceInfo.sPackageName;
        if (str5 == null) {
            str5 = AndroidResources.packageName;
        }
        HashMap hashMap = new HashMap();
        hashMap.put("appid", str);
        if (!z) {
            hashMap.put("net", Integer.valueOf(networkType));
        }
        hashMap.put("imei", bundleData);
        hashMap.put("md", str4);
        hashMap.put(WXConfig.os, Integer.valueOf(i));
        hashMap.put("vb", "1.9.9.81993");
        hashMap.put(CreateShortResultReceiver.KEY_SF, Integer.valueOf(StringConst.getIntSF(str2)));
        hashMap.put(ContextChain.TAG_PRODUCT, "a");
        hashMap.put("d1", Long.valueOf(System.currentTimeMillis()));
        hashMap.put(CreateShortResultReceiver.KEY_SFD, str3);
        hashMap.put("vd", Build.MANUFACTURER);
        hashMap.put("pn", str5);
        return hashMap;
    }

    public static String getStreamappFrom(Intent intent) {
        if (intent == null || !intent.hasExtra(IntentConst.RUNING_STREAPP_LAUNCHER)) {
            return null;
        }
        String stringExtra = intent.getStringExtra(IntentConst.RUNING_STREAPP_LAUNCHER);
        if (stringExtra.indexOf("third:") == 0) {
            return stringExtra.substring(6, stringExtra.length());
        }
        return null;
    }

    /* JADX WARNING: Removed duplicated region for block: B:17:0x006c A[SYNTHETIC, Splitter:B:17:0x006c] */
    /* JADX WARNING: Removed duplicated region for block: B:25:0x0088 A[SYNTHETIC, Splitter:B:25:0x0088] */
    public static String getSystemProperty() {
        Throwable th;
        BufferedReader bufferedReader;
        IOException e;
        BufferedReader bufferedReader2 = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(Runtime.getRuntime().exec("getprop " + "ro.miui.ui.version.name").getInputStream()), 1024);
            try {
                String readLine = bufferedReader.readLine();
                bufferedReader.close();
                try {
                    bufferedReader.close();
                } catch (IOException e2) {
                    Logger.i("Exception while closing InputStream" + e2);
                }
                return readLine;
            } catch (IOException e3) {
                e = e3;
                try {
                    Logger.i("Unable to read sysprop " + "ro.miui.ui.version.name" + e);
                    if (bufferedReader != null) {
                    }
                    return null;
                } catch (Throwable th2) {
                    th = th2;
                    bufferedReader2 = bufferedReader;
                    if (bufferedReader2 != null) {
                        try {
                            bufferedReader2.close();
                        } catch (IOException e4) {
                            Logger.i("Exception while closing InputStream" + e4);
                        }
                    }
                    throw th;
                }
            }
        } catch (IOException e5) {
            e = e5;
            bufferedReader = null;
            Logger.i("Unable to read sysprop " + "ro.miui.ui.version.name" + e);
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                } catch (IOException e6) {
                    Logger.i("Exception while closing InputStream" + e6);
                }
            }
            return null;
        } catch (Throwable th3) {
            th = th3;
            if (bufferedReader2 != null) {
            }
            throw th;
        }
    }

    public static String getTestParam(String str) {
        String str2 = (TextUtils.isEmpty(str) || !BaseInfo.isTest(str)) ? "r" : "t";
        return "&__am=" + str2;
    }
}
