package io.dcloud.common.adapter.util;

import android.os.Build;
import io.dcloud.common.constant.AbsoluteConst;
import io.dcloud.common.util.BaseInfo;
import io.dcloud.common.util.JSONUtil;
import io.dcloud.common.util.PdrUtil;
import java.util.ArrayList;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;

public class ViewRect {
    public static final int DEFAULT_MARGIN = 0;
    public static byte DOCK_BOTTOM = 6;
    public static byte DOCK_LEFT = 3;
    public static byte DOCK_RIGHT = 4;
    public static byte DOCK_TOP = 5;
    public static byte POSITION_ABSOLUTE = 1;
    public static byte POSITION_DOCK = 2;
    public static byte POSITION_STATIC;
    public boolean allowUpdate = true;
    public int anim_left;
    public int anim_top;
    public int bottom;
    private boolean doUpdate = false;
    public int height;
    public boolean isNotHeightFullScreen = false;
    public boolean isStatusbar = false;
    public boolean isStatusbarDodifyHeight = false;
    public int left;
    private byte mDock = DOCK_TOP;
    private ViewRect mFrameParentViewRect = null;
    public JSONObject mJsonViewOption = JSONUtil.createJSONObject("{}");
    private ViewRect mParentViewRect = null;
    private byte mPosition = POSITION_STATIC;
    private ArrayList<ViewRect> mRelViewRectDockSet = null;
    public String mStatusbarColor;
    public float mWebviewScale = 1.0f;
    public String margin = String.valueOf(0);
    public int right;
    public int top;
    public int width;

    /* JADX WARNING: Removed duplicated region for block: B:13:0x0040 A[RETURN] */
    /* JADX WARNING: Removed duplicated region for block: B:14:0x0041  */
    /* JADX WARNING: Removed duplicated region for block: B:54:0x0154  */
    public static void layoutDockViewRect(ViewRect viewRect, ViewRect viewRect2, boolean z) {
        boolean z2;
        ViewRect viewRect3 = viewRect2.mParentViewRect;
        JSONObject jSONObject = viewRect2.mJsonViewOption;
        String string = JSONUtil.getString(jSONObject, "position");
        int i = 0;
        if (!PdrUtil.isEmpty(string)) {
            if (AbsoluteConst.JSON_VALUE_POSITION_ABSOLUTE.equals(string)) {
                viewRect2.mPosition = POSITION_ABSOLUTE;
            } else if ("dock".equals(string)) {
                viewRect2.mPosition = POSITION_DOCK;
                z2 = true;
                if (!z2) {
                    String string2 = JSONUtil.getString(jSONObject, "dock");
                    if (!PdrUtil.isEmpty(string2)) {
                        if ("bottom".equals(string2)) {
                            viewRect2.mDock = DOCK_BOTTOM;
                        } else if ("top".equals(string2)) {
                            viewRect2.mDock = DOCK_TOP;
                        } else if ("left".equals(string2)) {
                            viewRect2.mDock = DOCK_LEFT;
                        } else if ("right".equals(string2)) {
                            viewRect2.mDock = DOCK_RIGHT;
                        }
                    }
                    String string3 = JSONUtil.getString(jSONObject, "left");
                    String string4 = JSONUtil.getString(jSONObject, "top");
                    String string5 = JSONUtil.getString(jSONObject, "width");
                    String string6 = JSONUtil.getString(jSONObject, "height");
                    boolean z3 = !PdrUtil.isEmpty(string3);
                    boolean z4 = !PdrUtil.isEmpty(string4);
                    boolean z5 = !PdrUtil.isEmpty(string5);
                    boolean isEmpty = true ^ PdrUtil.isEmpty(string6);
                    viewRect2.width = PdrUtil.convertToScreenInt(string5, viewRect3.width, viewRect.width, viewRect3.mWebviewScale);
                    int convertToScreenInt = PdrUtil.convertToScreenInt(string6, viewRect3.height, viewRect.height, viewRect3.mWebviewScale);
                    viewRect2.height = convertToScreenInt;
                    int i2 = viewRect2.width;
                    if (i2 < 0) {
                        i2 = viewRect2.mParentViewRect.width;
                    }
                    viewRect2.width = i2;
                    if (convertToScreenInt < 0) {
                        convertToScreenInt = viewRect2.mParentViewRect.height;
                    }
                    viewRect2.height = convertToScreenInt;
                    int i3 = viewRect.top;
                    int i4 = viewRect.left;
                    int i5 = viewRect.width;
                    int i6 = viewRect.height;
                    int convertToScreenInt2 = PdrUtil.convertToScreenInt(string3, viewRect3.width, i4, viewRect3.mWebviewScale);
                    int convertToScreenInt3 = PdrUtil.convertToScreenInt(string4, viewRect3.height, viewRect.top, viewRect3.mWebviewScale);
                    byte b = viewRect2.mDock;
                    if (b == DOCK_BOTTOM) {
                        if (!z4 || isEmpty) {
                            int i7 = viewRect.height - viewRect2.height;
                            viewRect.height = i7;
                            convertToScreenInt3 = i7 + viewRect.top;
                        } else {
                            viewRect.height = convertToScreenInt3 - viewRect.top;
                            viewRect2.height -= convertToScreenInt3;
                        }
                    } else if (b != DOCK_RIGHT) {
                        if (b == DOCK_LEFT) {
                            int i8 = viewRect2.width;
                            viewRect.left = i8 + 0;
                            viewRect.width -= i8;
                        } else if (b == DOCK_TOP) {
                            int i9 = viewRect2.height;
                            viewRect.top = i9 + 0;
                            viewRect.height -= i9;
                            i = convertToScreenInt2;
                            convertToScreenInt3 = 0;
                        }
                        if (!z) {
                        }
                        viewRect2.left = i;
                        viewRect2.top = convertToScreenInt3;
                        return;
                    } else if (!z3 || z5) {
                        int i10 = viewRect.width - viewRect2.width;
                        viewRect.width = i10;
                        i = i10 + viewRect.left;
                        if (!z) {
                            viewRect.left = i4;
                            viewRect.top = i3;
                            viewRect.width = i5;
                            viewRect.height = i6;
                        }
                        viewRect2.left = i;
                        viewRect2.top = convertToScreenInt3;
                        return;
                    } else {
                        viewRect.width = convertToScreenInt2 - viewRect.left;
                        viewRect2.width -= convertToScreenInt2;
                    }
                    i = convertToScreenInt2;
                    if (!z) {
                    }
                    viewRect2.left = i;
                    viewRect2.top = convertToScreenInt3;
                    return;
                }
                return;
            } else if ("static".equals(string)) {
                viewRect2.mPosition = POSITION_STATIC;
            }
        }
        z2 = false;
        if (!z2) {
        }
    }

    private void layoutWithRelViewRect() {
        ArrayList<ViewRect> arrayList = this.mRelViewRectDockSet;
        if (arrayList != null) {
            Iterator<ViewRect> it = arrayList.iterator();
            while (it.hasNext()) {
                layoutDockViewRect(this, it.next());
            }
        }
    }

    public void checkValueIsPercentage(String str, int i, int i2, boolean z, boolean z2) {
        try {
            if (this.mJsonViewOption.isNull(str) && !z) {
                return;
            }
            if ((this.mJsonViewOption.isNull(str) || this.mJsonViewOption.getString(str).indexOf("%") < 0) && !z2) {
                this.mJsonViewOption.put(str, (double) (((float) i) / this.mWebviewScale));
            } else if (i2 > 0) {
                JSONObject jSONObject = this.mJsonViewOption;
                jSONObject.put(str, ((i * 100) / i2) + "%");
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void commitUpdate2JSONObject(boolean z, boolean z2) {
        ViewRect viewRect = this.mFrameParentViewRect;
        int i = viewRect != null ? viewRect.width : this.mParentViewRect.width;
        if (viewRect == null) {
            viewRect = this.mParentViewRect;
        }
        int i2 = viewRect.height;
        checkValueIsPercentage("left", this.left, i, z, z2);
        checkValueIsPercentage("top", this.top, i2, z, z2);
        checkValueIsPercentage("width", this.width, i, z, z2);
        checkValueIsPercentage("height", this.height, i2, z, z2);
        checkValueIsPercentage("right", this.right, i, z, z2);
        checkValueIsPercentage("bottom", this.bottom, i2, z, z2);
    }

    public void delRelViewRect(ViewRect viewRect) {
        ArrayList<ViewRect> arrayList = this.mRelViewRectDockSet;
        if (arrayList != null) {
            arrayList.remove(viewRect);
        }
    }

    public ViewRect getParentViewRect() {
        return this.mParentViewRect;
    }

    public boolean hasHeightAbsolutevalue() {
        JSONObject jSONObject = this.mJsonViewOption;
        if (jSONObject != null && jSONObject.has("height") && !this.mJsonViewOption.isNull("height")) {
            return true ^ JSONUtil.getString(this.mJsonViewOption, "height").endsWith("%");
        }
        if (!this.mJsonViewOption.has("bottom") || !this.mJsonViewOption.has("top")) {
            return false;
        }
        return true;
    }

    public boolean hasRectChanged(ViewRect viewRect, ViewRect viewRect2) {
        return (viewRect.left == viewRect2.left && viewRect.top == viewRect2.top && viewRect.height == viewRect2.height && viewRect.width == viewRect2.width) ? false : true;
    }

    public boolean isBottomAbsolute() {
        JSONObject jSONObject = this.mJsonViewOption;
        return jSONObject != null && jSONObject.has("bottom");
    }

    public boolean isHeightAbsolute() {
        JSONObject jSONObject = this.mJsonViewOption;
        if (jSONObject == null) {
            return true;
        }
        if (!jSONObject.has("height") || this.mJsonViewOption.isNull("height")) {
            if (this.mJsonViewOption.has("bottom") && this.mJsonViewOption.has("top")) {
                return true;
            }
            if (this.mJsonViewOption.has("height") || this.mJsonViewOption.isNull("height")) {
            }
        } else if (!JSONUtil.getString(this.mJsonViewOption, "height").equals("100%")) {
            return true;
        }
        return false;
    }

    public void onScreenChanged(int i, int i2) {
        updateViewData(this.mJsonViewOption, i, i2);
    }

    public void putRelViewRect(ViewRect viewRect) {
        if (this.mRelViewRectDockSet == null) {
            this.mRelViewRectDockSet = new ArrayList<>();
        }
        this.mRelViewRectDockSet.add(viewRect);
    }

    public void setFrameParentViewRect(ViewRect viewRect) {
        this.mFrameParentViewRect = viewRect;
        this.mFrameParentViewRect = null;
    }

    public void setParentViewRect(ViewRect viewRect) {
        this.mParentViewRect = viewRect;
    }

    public void setUpdateAction(boolean z) {
        this.doUpdate = z;
    }

    public boolean updateViewData(JSONObject jSONObject, int i, int i2) {
        return updateViewData(jSONObject, i, i2, this.mWebviewScale);
    }

    public void onScreenChanged() {
        updateViewData(this.mJsonViewOption);
    }

    public boolean updateViewData(JSONObject jSONObject, int i, int i2, float f) {
        int i3;
        boolean z;
        int i4;
        boolean z2;
        boolean z3;
        JSONObject jSONObject2 = jSONObject;
        JSONObject jSONObject3 = this.mJsonViewOption;
        if (jSONObject3 == null) {
            return false;
        }
        if (jSONObject3 != null) {
            JSONUtil.combinJSONObject(jSONObject3, jSONObject2);
            jSONObject2 = this.mJsonViewOption;
        } else {
            this.mJsonViewOption = jSONObject2;
        }
        int i5 = i2 < 0 ? this.height + this.bottom + this.top : i2;
        int i6 = i < 0 ? this.width : i;
        int i7 = this.left;
        int i8 = this.top;
        int i9 = this.width;
        int i10 = this.height;
        if (jSONObject2.has(AbsoluteConst.JSONKEY_STATUSBAR) && BaseInfo.isImmersive && Build.VERSION.SDK_INT >= 19) {
            this.isStatusbar = true;
            JSONObject optJSONObject = jSONObject2.optJSONObject(AbsoluteConst.JSONKEY_STATUSBAR);
            if (optJSONObject != null && optJSONObject.has("background")) {
                this.mStatusbarColor = optJSONObject.optString("background", this.mStatusbarColor);
            }
        }
        boolean z4 = this.doUpdate || !jSONObject2.isNull("left");
        boolean z5 = this.doUpdate || !jSONObject2.isNull("right");
        boolean z6 = this.doUpdate || !jSONObject2.isNull("top");
        if (this.doUpdate || !jSONObject2.isNull("width")) {
            i3 = i10;
            z = true;
        } else {
            i3 = i10;
            z = false;
        }
        if (this.doUpdate || !jSONObject2.isNull("height")) {
            i4 = i7;
            z2 = true;
        } else {
            i4 = i7;
            z2 = false;
        }
        boolean z7 = this.doUpdate || !jSONObject2.isNull("bottom");
        this.left = PdrUtil.convertToScreenInt(JSONUtil.getString(jSONObject2, "left"), i6, 0, f);
        this.top = PdrUtil.convertToScreenInt(JSONUtil.getString(jSONObject2, "top"), i5, 0, f);
        this.width = PdrUtil.convertToScreenInt(JSONUtil.getString(jSONObject2, "width"), i6, z ? this.width : i6, f);
        int convertToScreenInt = PdrUtil.convertToScreenInt(JSONUtil.getString(jSONObject2, "height"), i5, z2 ? this.height : i5, f);
        this.height = convertToScreenInt;
        if (z2 && convertToScreenInt < i5) {
            this.isNotHeightFullScreen = true;
            if (this.isStatusbar) {
                this.isStatusbarDodifyHeight = true;
            }
        }
        this.right = PdrUtil.convertToScreenInt(JSONUtil.getString(jSONObject2, "right"), i6, this.right, f);
        this.bottom = PdrUtil.convertToScreenInt(JSONUtil.getString(jSONObject2, "bottom"), i5, this.bottom, f);
        if (!jSONObject2.isNull("margin")) {
            String string = JSONUtil.getString(jSONObject2, "margin");
            this.margin = string;
            z3 = PdrUtil.isEquals("auto", string);
        } else {
            z3 = false;
        }
        if (!z4) {
            if (!z && z5) {
                this.left = -this.right;
            } else if (z && !z5 && z3) {
                this.left = (i6 - this.width) / 2;
            } else if (z && z5) {
                this.left = (i6 - this.width) - this.right;
            }
        } else if (!z && z5) {
            this.width = (i6 - this.left) - this.right;
        }
        if (!z6) {
            if (!z2 && z7) {
                this.top = -this.bottom;
            } else if (z2 && !z7 && z3) {
                this.top = (i5 - this.height) / 2;
            } else if (z2 && z7) {
                this.top = (i5 - this.height) - this.bottom;
            }
        } else if (!z2 && z7) {
            this.height = (i5 - this.top) - this.bottom;
        }
        layoutWithRelViewRect();
        layoutDockViewRect(this.mParentViewRect, this, false);
        int i11 = this.left;
        boolean z8 = (i4 == i11 && i8 == this.top && i3 == this.height && i9 == this.width) ? false : true;
        this.anim_left = i11;
        this.anim_top = this.top;
        return z8;
    }

    public void commitUpdate2JSONObject() {
        commitUpdate2JSONObject(false, false);
    }

    public void updateViewData(ViewRect viewRect) {
        this.mWebviewScale = viewRect.mWebviewScale;
        this.left = viewRect.left;
        this.top = viewRect.top;
        this.width = viewRect.width;
        this.height = viewRect.height;
        this.right = viewRect.right;
        this.bottom = viewRect.bottom;
        updateViewData(viewRect.mJsonViewOption);
    }

    public static void layoutDockViewRect(ViewRect viewRect, ViewRect viewRect2) {
        layoutDockViewRect(viewRect, viewRect2, true);
    }

    public boolean updateViewData(JSONObject jSONObject) {
        ViewRect viewRect = this.mParentViewRect;
        if (viewRect == null) {
            return false;
        }
        return updateViewData(jSONObject, viewRect.width, viewRect.height);
    }
}
