package io.dcloud.common.adapter.util;

import android.graphics.Color;
import android.os.Build;
import android.text.TextUtils;
import android.view.View;
import com.taobao.weex.common.Constants;
import com.taobao.weex.performance.WXInstanceApm;
import io.dcloud.common.DHInterface.IFrameView;
import io.dcloud.common.DHInterface.IWebview;
import io.dcloud.common.constant.AbsoluteConst;
import io.dcloud.common.util.JSONUtil;
import io.dcloud.common.util.PdrUtil;
import java.util.HashMap;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONObject;

public class ViewOptions extends ViewRect {
    public static final int BG_NONE = -1;
    public String animationAlphaBackground;
    public String backButtonAutoControl;
    public int background;
    public int coverage;
    public HashMap<String, DragBean> dragData;
    public boolean dragH5NeedTouchEvent;
    public String errorPage;
    public String historyBack;
    public boolean isAnimationOptimization;
    public Boolean isTabItem;
    public boolean isUniH5;
    public boolean isUserSelect;
    public boolean mBounce;
    public String mCacheMode;
    public JSONObject mDebugRefresh;
    public boolean mDisablePlus;
    public String mGeoInject;
    public String mInjection;
    public String mPlusrequire;
    public JSONObject mProgressJson;
    public JSONObject mPullToRefresh;
    private String mScrollIndicator;
    public JSONArray mSubNViews;
    public Object mTag;
    public JSONObject mUniNViewJson;
    public JSONObject mUniPageUrl;
    public boolean mUseHardwave;
    public String mVideoFullscree;
    public int maskColor;
    public String name;
    public float opacity;
    public String popGesture;
    public boolean scalable;
    public String softinputMode;
    public String strBackground;
    public String strTabBG;
    public JSONObject titleNView;
    public JSONObject transform;
    public JSONObject transition;
    public boolean webviewBGTransparent;

    public ViewOptions() {
        this.mUseHardwave = true;
        this.scalable = false;
        this.mInjection = AbsoluteConst.TRUE;
        this.mPlusrequire = "normal";
        this.mDisablePlus = false;
        this.mScrollIndicator = "all";
        this.opacity = -1.0f;
        this.background = -1;
        this.maskColor = -1;
        this.strBackground = null;
        this.webviewBGTransparent = false;
        this.strTabBG = null;
        this.errorPage = null;
        this.mBounce = false;
        this.mCacheMode = "default";
        this.mVideoFullscree = "auto";
        this.popGesture = "none";
        this.historyBack = "none";
        this.mGeoInject = "none";
        this.dragH5NeedTouchEvent = false;
        this.backButtonAutoControl = "none";
        this.isAnimationOptimization = false;
        this.isUserSelect = true;
        this.softinputMode = "adjustResize";
        this.mUniNViewJson = null;
        this.mProgressJson = null;
        this.mDebugRefresh = null;
        this.mUniPageUrl = null;
        this.isTabItem = Boolean.FALSE;
        this.isUniH5 = false;
        this.mUseHardwave = MobilePhoneModel.checkPhoneBanAcceleration(Build.BRAND);
    }

    public static ViewOptions createViewOptionsData(ViewOptions viewOptions, ViewRect viewRect) {
        return createViewOptionsData(viewOptions, null, viewRect);
    }

    public String getScrollIndicator() {
        return this.mScrollIndicator;
    }

    public boolean hasBackground() {
        return this.background != -1 || (!PdrUtil.isEmpty(this.strBackground) && !this.strBackground.equals("transparent"));
    }

    public boolean hasMask() {
        return this.maskColor != -1;
    }

    public boolean hasTransparentValue() {
        if (!isTransparent() && !PdrUtil.checkAlphaTransparent(this.background)) {
            float f = this.opacity;
            if (f < 0.0f || f >= 1.0f) {
                return false;
            }
        }
        return true;
    }

    public boolean isTabHasBg() {
        return this.isTabItem.booleanValue() && !PdrUtil.isEmpty(this.strTabBG);
    }

    public boolean isTransparent() {
        return PdrUtil.isEquals("transparent", this.strBackground);
    }

    public void setBackButtonAutoControl(JSONObject jSONObject) {
        if (jSONObject != null && jSONObject.has("backButtonAutoControl")) {
            String string = JSONUtil.getString(jSONObject, "backButtonAutoControl");
            if ("none".equals(string) || "hide".equals(string) || AbsoluteConst.EVENTS_CLOSE.equals(string) || "quit".equals(string)) {
                this.backButtonAutoControl = string;
            }
        }
    }

    public void setDragData(JSONObject jSONObject, JSONObject jSONObject2, IFrameView iFrameView, IFrameView iFrameView2, String str, View view) {
        try {
            if (this.dragData == null) {
                this.dragData = new HashMap<>();
            }
            DragBean dragBean = new DragBean();
            dragBean.dragCurrentViewOp = jSONObject;
            dragBean.dragBindViewOp = jSONObject2;
            dragBean.dragBindWebView = iFrameView;
            dragBean.dragCallBackWebView = iFrameView2;
            dragBean.dragCbId = str;
            dragBean.nativeView = view;
            if (jSONObject.has("direction")) {
                String string = jSONObject.getString("direction");
                if (!TextUtils.isEmpty(string)) {
                    this.dragData.put(string.toLowerCase(Locale.ENGLISH), dragBean);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setTitleNView(JSONObject jSONObject, IWebview iWebview) {
        if (jSONObject != null) {
            if ("transparent".equals(jSONObject.optString("type"))) {
                String str = null;
                if (jSONObject.has("titleColor")) {
                    str = jSONObject.optString("titleColor");
                } else if (jSONObject.has("titlecolor")) {
                    str = jSONObject.optString("titlecolor");
                }
                if (!TextUtils.isEmpty(str)) {
                    try {
                        int parseColor = Color.parseColor(str);
                        String hexString = Integer.toHexString(0);
                        if (1 == hexString.length()) {
                            hexString = WXInstanceApm.VALUE_ERROR_CODE_DEFAULT + hexString.toUpperCase();
                        }
                        String hexString2 = Integer.toHexString(Color.red(parseColor));
                        if (1 == hexString2.length()) {
                            hexString2 = WXInstanceApm.VALUE_ERROR_CODE_DEFAULT + hexString2.toUpperCase();
                        }
                        String hexString3 = Integer.toHexString(Color.green(parseColor));
                        if (1 == hexString3.length()) {
                            hexString3 = WXInstanceApm.VALUE_ERROR_CODE_DEFAULT + hexString3.toUpperCase();
                        }
                        String hexString4 = Integer.toHexString(Color.blue(parseColor));
                        if (1 == hexString4.length()) {
                            hexString4 = WXInstanceApm.VALUE_ERROR_CODE_DEFAULT + hexString4.toUpperCase();
                        }
                        String str2 = "#" + hexString + hexString2 + hexString3 + hexString4;
                        if (jSONObject.has("titleColor")) {
                            jSONObject.put("titleColor", str2);
                        } else if (jSONObject.has("titlecolor")) {
                            jSONObject.put("titlecolor", str2);
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            this.coverage = PdrUtil.convertToScreenInt("136px", PlatformUtil.SCREEN_WIDTH(iWebview.getContext()), 0, iWebview.getScale());
            this.coverage = PdrUtil.convertToScreenInt(jSONObject.optString("coverage"), PlatformUtil.SCREEN_WIDTH(iWebview.getContext()), this.coverage, iWebview.getScale());
            this.titleNView = jSONObject;
        }
    }

    @Override // io.dcloud.common.adapter.util.ViewRect
    public void updateViewData(ViewRect viewRect) {
        super.updateViewData(viewRect);
    }

    public static ViewOptions createViewOptionsData(ViewOptions viewOptions, ViewRect viewRect, ViewRect viewRect2) {
        if (viewOptions == null) {
            return null;
        }
        ViewOptions viewOptions2 = new ViewOptions();
        if (viewRect != null) {
            viewOptions2.setFrameParentViewRect(viewRect);
        }
        viewOptions2.mWebviewScale = viewOptions.mWebviewScale;
        viewOptions2.setParentViewRect(viewRect2);
        viewOptions2.updateViewData(viewOptions.mJsonViewOption);
        return viewOptions2;
    }

    /* JADX WARNING: Removed duplicated region for block: B:27:0x0075  */
    /* JADX WARNING: Removed duplicated region for block: B:30:0x0083  */
    /* JADX WARNING: Removed duplicated region for block: B:33:0x0097 A[SYNTHETIC, Splitter:B:33:0x0097] */
    /* JADX WARNING: Removed duplicated region for block: B:37:0x00a9  */
    /* JADX WARNING: Removed duplicated region for block: B:45:0x00be A[SYNTHETIC, Splitter:B:45:0x00be] */
    /* JADX WARNING: Removed duplicated region for block: B:51:0x00db  */
    /* JADX WARNING: Removed duplicated region for block: B:54:0x016e  */
    /* JADX WARNING: Removed duplicated region for block: B:57:0x017e  */
    /* JADX WARNING: Removed duplicated region for block: B:62:0x0193  */
    /* JADX WARNING: Removed duplicated region for block: B:72:0x01cf  */
    /* JADX WARNING: Removed duplicated region for block: B:75:0x01e4  */
    /* JADX WARNING: Removed duplicated region for block: B:83:0x020e  */
    /* JADX WARNING: Removed duplicated region for block: B:84:0x021b  */
    /* JADX WARNING: Removed duplicated region for block: B:89:0x0237  */
    /* JADX WARNING: Removed duplicated region for block: B:92:0x024b  */
    @Override // io.dcloud.common.adapter.util.ViewRect
    public boolean updateViewData(JSONObject jSONObject) {
        String string;
        Exception e;
        boolean updateViewData = super.updateViewData(jSONObject);
        if (jSONObject != null) {
            if (!jSONObject.isNull("isTab")) {
                this.isTabItem = Boolean.valueOf(jSONObject.optBoolean("isTab", false));
            }
            if (!jSONObject.isNull("isUniH5")) {
                this.isUniH5 = jSONObject.optBoolean("isUniH5", false);
            }
            if (!JSONUtil.isNull(jSONObject, AbsoluteConst.JSON_KEY_SCROLLINDICATOR)) {
                this.mScrollIndicator = JSONUtil.getString(jSONObject, AbsoluteConst.JSON_KEY_SCROLLINDICATOR);
            }
            String str = null;
            if (!jSONObject.isNull("background")) {
                try {
                    String lowerCase = JSONUtil.getString(jSONObject, "background").toLowerCase(Locale.ENGLISH);
                    try {
                        if (this.isTabItem.booleanValue()) {
                            jSONObject.remove("background");
                            this.strTabBG = lowerCase;
                            this.strBackground = null;
                            this.background = -1;
                        } else {
                            this.strBackground = lowerCase;
                            this.background = PdrUtil.stringToColor(lowerCase);
                        }
                        str = lowerCase;
                    } catch (Exception e2) {
                        e = e2;
                        str = lowerCase;
                        e.printStackTrace();
                        if (!jSONObject.isNull(AbsoluteConst.JSON_KEY_WEBBG_TRANSPARENT)) {
                        }
                        if (!jSONObject.isNull(AbsoluteConst.JSON_KEY_TABBG)) {
                        }
                        if (!jSONObject.isNull(AbsoluteConst.JSON_KEY_ANIMATION_ALPHA_BG)) {
                        }
                        if (!jSONObject.isNull(AbsoluteConst.JSON_KEY_MASK)) {
                        }
                        if (!jSONObject.isNull(AbsoluteConst.JSON_KEY_CACHEMODE)) {
                        }
                        this.mUseHardwave = PdrUtil.parseBoolean(JSONUtil.getString(jSONObject, AbsoluteConst.JSON_KEY_HARDWARE_ACCELERATED), this.mUseHardwave, false);
                        this.opacity = PdrUtil.parseFloat(JSONUtil.getString(jSONObject, "opacity"), this.opacity);
                        this.scalable = PdrUtil.parseBoolean(JSONUtil.getString(jSONObject, AbsoluteConst.JSON_KEY_SCALABLE), this.scalable, false);
                        this.transition = JSONUtil.getJSONObject(jSONObject, AbsoluteConst.JSON_KEY_TRANSITION);
                        this.transform = JSONUtil.getJSONObject(jSONObject, "transform");
                        this.errorPage = JSONUtil.getString(jSONObject, AbsoluteConst.JSON_KEY_ERROR_PAGE);
                        this.mInjection = JSONUtil.getString(jSONObject, "injection");
                        this.mPlusrequire = jSONObject.optString("plusrequire", this.mPlusrequire);
                        this.mDisablePlus = jSONObject.optBoolean(AbsoluteConst.JSON_KEY_DISABLE_PLUS, this.mDisablePlus);
                        this.popGesture = jSONObject.optString("popGesture", this.popGesture);
                        this.historyBack = jSONObject.optString(AbsoluteConst.JSON_KEY_HISTORYBACK, this.historyBack);
                        this.isUserSelect = jSONObject.optBoolean("userSelect", true);
                        this.softinputMode = jSONObject.optString(AbsoluteConst.JSON_KEY_SOFTINPUT_MODE, this.softinputMode);
                        if (jSONObject.has(AbsoluteConst.JSON_KEY_UNINVIEW)) {
                        }
                        if (jSONObject.has("replacewebapi")) {
                        }
                        this.mProgressJson = JSONUtil.getJSONObject(jSONObject, "progress");
                        JSONObject jSONObject2 = JSONUtil.getJSONObject(jSONObject, AbsoluteConst.JSON_KEY_DEBUG_REFRESH);
                        this.mDebugRefresh = jSONObject2;
                        this.mUniPageUrl = JSONUtil.createJSONObject(this.mDebugRefresh.optString("arguments"));
                        if (jSONObject.has("uniPageUrl")) {
                        }
                        string = JSONUtil.getString(jSONObject, "bounce");
                        if (!"vertical".equalsIgnoreCase(string)) {
                        }
                        this.mBounce = true;
                        this.mVideoFullscree = JSONUtil.getString(jSONObject, AbsoluteConst.JSON_KEY_VIDEO_FULL_SCREEN);
                        setBackButtonAutoControl(jSONObject);
                        if (jSONObject.has("titleNView")) {
                        }
                        if (jSONObject.has(AbsoluteConst.EVENTS_PULL_TO_REFRESH)) {
                        }
                        if (jSONObject.has(AbsoluteConst.JSON_KEY_SUB_NVIEWS)) {
                        }
                        this.isAnimationOptimization = true;
                        return updateViewData;
                    }
                } catch (Exception e3) {
                    e = e3;
                    e.printStackTrace();
                    if (!jSONObject.isNull(AbsoluteConst.JSON_KEY_WEBBG_TRANSPARENT)) {
                    }
                    if (!jSONObject.isNull(AbsoluteConst.JSON_KEY_TABBG)) {
                    }
                    if (!jSONObject.isNull(AbsoluteConst.JSON_KEY_ANIMATION_ALPHA_BG)) {
                    }
                    if (!jSONObject.isNull(AbsoluteConst.JSON_KEY_MASK)) {
                    }
                    if (!jSONObject.isNull(AbsoluteConst.JSON_KEY_CACHEMODE)) {
                    }
                    this.mUseHardwave = PdrUtil.parseBoolean(JSONUtil.getString(jSONObject, AbsoluteConst.JSON_KEY_HARDWARE_ACCELERATED), this.mUseHardwave, false);
                    this.opacity = PdrUtil.parseFloat(JSONUtil.getString(jSONObject, "opacity"), this.opacity);
                    this.scalable = PdrUtil.parseBoolean(JSONUtil.getString(jSONObject, AbsoluteConst.JSON_KEY_SCALABLE), this.scalable, false);
                    this.transition = JSONUtil.getJSONObject(jSONObject, AbsoluteConst.JSON_KEY_TRANSITION);
                    this.transform = JSONUtil.getJSONObject(jSONObject, "transform");
                    this.errorPage = JSONUtil.getString(jSONObject, AbsoluteConst.JSON_KEY_ERROR_PAGE);
                    this.mInjection = JSONUtil.getString(jSONObject, "injection");
                    this.mPlusrequire = jSONObject.optString("plusrequire", this.mPlusrequire);
                    this.mDisablePlus = jSONObject.optBoolean(AbsoluteConst.JSON_KEY_DISABLE_PLUS, this.mDisablePlus);
                    this.popGesture = jSONObject.optString("popGesture", this.popGesture);
                    this.historyBack = jSONObject.optString(AbsoluteConst.JSON_KEY_HISTORYBACK, this.historyBack);
                    this.isUserSelect = jSONObject.optBoolean("userSelect", true);
                    this.softinputMode = jSONObject.optString(AbsoluteConst.JSON_KEY_SOFTINPUT_MODE, this.softinputMode);
                    if (jSONObject.has(AbsoluteConst.JSON_KEY_UNINVIEW)) {
                    }
                    if (jSONObject.has("replacewebapi")) {
                    }
                    this.mProgressJson = JSONUtil.getJSONObject(jSONObject, "progress");
                    JSONObject jSONObject22 = JSONUtil.getJSONObject(jSONObject, AbsoluteConst.JSON_KEY_DEBUG_REFRESH);
                    this.mDebugRefresh = jSONObject22;
                    this.mUniPageUrl = JSONUtil.createJSONObject(this.mDebugRefresh.optString("arguments"));
                    if (jSONObject.has("uniPageUrl")) {
                    }
                    string = JSONUtil.getString(jSONObject, "bounce");
                    if (!"vertical".equalsIgnoreCase(string)) {
                    }
                    this.mBounce = true;
                    this.mVideoFullscree = JSONUtil.getString(jSONObject, AbsoluteConst.JSON_KEY_VIDEO_FULL_SCREEN);
                    setBackButtonAutoControl(jSONObject);
                    if (jSONObject.has("titleNView")) {
                    }
                    if (jSONObject.has(AbsoluteConst.EVENTS_PULL_TO_REFRESH)) {
                    }
                    if (jSONObject.has(AbsoluteConst.JSON_KEY_SUB_NVIEWS)) {
                    }
                    this.isAnimationOptimization = true;
                    return updateViewData;
                }
            }
            if (!jSONObject.isNull(AbsoluteConst.JSON_KEY_WEBBG_TRANSPARENT)) {
                this.webviewBGTransparent = JSONUtil.getBoolean(jSONObject, AbsoluteConst.JSON_KEY_WEBBG_TRANSPARENT);
            }
            if (!jSONObject.isNull(AbsoluteConst.JSON_KEY_TABBG)) {
                str = JSONUtil.getString(jSONObject, AbsoluteConst.JSON_KEY_TABBG).toLowerCase(Locale.ENGLISH);
                this.strTabBG = str;
            }
            if (!jSONObject.isNull(AbsoluteConst.JSON_KEY_ANIMATION_ALPHA_BG)) {
                try {
                    this.animationAlphaBackground = JSONUtil.getString(jSONObject, AbsoluteConst.JSON_KEY_ANIMATION_ALPHA_BG).toLowerCase(Locale.ENGLISH);
                } catch (Exception e4) {
                    e4.printStackTrace();
                }
            } else if (!TextUtils.isEmpty(str)) {
                try {
                    this.animationAlphaBackground = str;
                } catch (Exception e5) {
                    e5.printStackTrace();
                }
            }
            if (!jSONObject.isNull(AbsoluteConst.JSON_KEY_MASK)) {
                try {
                    this.maskColor = PdrUtil.stringToColor(JSONUtil.getString(jSONObject, AbsoluteConst.JSON_KEY_MASK).toLowerCase(Locale.ENGLISH));
                } catch (Exception e6) {
                    e6.printStackTrace();
                }
            }
            if (!jSONObject.isNull(AbsoluteConst.JSON_KEY_CACHEMODE)) {
                this.mCacheMode = JSONUtil.getString(jSONObject, AbsoluteConst.JSON_KEY_CACHEMODE);
            }
            this.mUseHardwave = PdrUtil.parseBoolean(JSONUtil.getString(jSONObject, AbsoluteConst.JSON_KEY_HARDWARE_ACCELERATED), this.mUseHardwave, false);
            this.opacity = PdrUtil.parseFloat(JSONUtil.getString(jSONObject, "opacity"), this.opacity);
            this.scalable = PdrUtil.parseBoolean(JSONUtil.getString(jSONObject, AbsoluteConst.JSON_KEY_SCALABLE), this.scalable, false);
            this.transition = JSONUtil.getJSONObject(jSONObject, AbsoluteConst.JSON_KEY_TRANSITION);
            this.transform = JSONUtil.getJSONObject(jSONObject, "transform");
            this.errorPage = JSONUtil.getString(jSONObject, AbsoluteConst.JSON_KEY_ERROR_PAGE);
            this.mInjection = JSONUtil.getString(jSONObject, "injection");
            this.mPlusrequire = jSONObject.optString("plusrequire", this.mPlusrequire);
            this.mDisablePlus = jSONObject.optBoolean(AbsoluteConst.JSON_KEY_DISABLE_PLUS, this.mDisablePlus);
            this.popGesture = jSONObject.optString("popGesture", this.popGesture);
            this.historyBack = jSONObject.optString(AbsoluteConst.JSON_KEY_HISTORYBACK, this.historyBack);
            this.isUserSelect = jSONObject.optBoolean("userSelect", true);
            this.softinputMode = jSONObject.optString(AbsoluteConst.JSON_KEY_SOFTINPUT_MODE, this.softinputMode);
            if (jSONObject.has(AbsoluteConst.JSON_KEY_UNINVIEW)) {
                this.mUniNViewJson = jSONObject.optJSONObject(AbsoluteConst.JSON_KEY_UNINVIEW);
            }
            if (jSONObject.has("replacewebapi")) {
                JSONObject optJSONObject = jSONObject.optJSONObject("replacewebapi");
                if (optJSONObject != null && optJSONObject.has("geolocation")) {
                    this.mGeoInject = optJSONObject.optString("geolocation", this.mGeoInject);
                }
            } else if (jSONObject.has("geolocation")) {
                this.mGeoInject = jSONObject.optString("geolocation", this.mGeoInject);
            }
            this.mProgressJson = JSONUtil.getJSONObject(jSONObject, "progress");
            JSONObject jSONObject222 = JSONUtil.getJSONObject(jSONObject, AbsoluteConst.JSON_KEY_DEBUG_REFRESH);
            this.mDebugRefresh = jSONObject222;
            if (jSONObject222 != null && jSONObject222.has("arguments")) {
                this.mUniPageUrl = JSONUtil.createJSONObject(this.mDebugRefresh.optString("arguments"));
            }
            if (jSONObject.has("uniPageUrl")) {
                this.mUniPageUrl = JSONUtil.getJSONObject(jSONObject, "uniPageUrl");
            }
            string = JSONUtil.getString(jSONObject, "bounce");
            if (!"vertical".equalsIgnoreCase(string) || Constants.Value.HORIZONTAL.equalsIgnoreCase(string) || "all".equalsIgnoreCase(string)) {
                this.mBounce = true;
            } else {
                this.mBounce = false;
            }
            this.mVideoFullscree = JSONUtil.getString(jSONObject, AbsoluteConst.JSON_KEY_VIDEO_FULL_SCREEN);
            setBackButtonAutoControl(jSONObject);
            if (jSONObject.has("titleNView")) {
                this.titleNView = JSONUtil.combinJSONObject(this.titleNView, JSONUtil.getJSONObject(jSONObject, "titleNView"));
            } else if (jSONObject.has("navigationbar")) {
                this.titleNView = JSONUtil.combinJSONObject(this.titleNView, JSONUtil.getJSONObject(jSONObject, "navigationbar"));
            }
            if (jSONObject.has(AbsoluteConst.EVENTS_PULL_TO_REFRESH)) {
                this.mPullToRefresh = JSONUtil.combinJSONObject(this.mPullToRefresh, JSONUtil.getJSONObject(jSONObject, AbsoluteConst.EVENTS_PULL_TO_REFRESH));
            }
            if (jSONObject.has(AbsoluteConst.JSON_KEY_SUB_NVIEWS)) {
                this.mSubNViews = JSONUtil.getJSONArray(jSONObject, AbsoluteConst.JSON_KEY_SUB_NVIEWS);
            }
            if (jSONObject.has(AbsoluteConst.JSON_KEY_ANIMATION_OPTIMIZATION) && "auto".equals(jSONObject.optString(AbsoluteConst.JSON_KEY_ANIMATION_OPTIMIZATION))) {
                this.isAnimationOptimization = true;
            }
        }
        return updateViewData;
    }
}
