package io.dcloud.common.adapter.util;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.hardware.Camera;
import android.location.LocationManager;
import android.media.MediaRecorder;
import android.os.Binder;
import android.os.Build;
import android.os.Environment;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.KeyEvent;
import android.widget.CheckBox;
import androidx.core.app.ActivityCompat;
import com.dcloud.android.widget.dialog.DCloudAlertDialog;
import com.facebook.common.callercontext.ContextChain;
import io.dcloud.WebAppActivity;
import io.dcloud.base.R;
import io.dcloud.common.DHInterface.IApp;
import io.dcloud.common.DHInterface.IReflectAble;
import io.dcloud.common.DHInterface.ISysEventListener;
import io.dcloud.common.DHInterface.IWebview;
import io.dcloud.common.constant.IntentConst;
import io.dcloud.common.core.permission.PermissionControler;
import io.dcloud.common.util.AppPermissionUtil;
import io.dcloud.common.util.DialogUtil;
import io.dcloud.common.util.IOUtil;
import io.dcloud.common.util.StringUtil;
import io.dcloud.feature.gg.dcloud.ADSim;
import io.dcloud.feature.ui.nativeui.c;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONObject;

public class PermissionUtil implements IReflectAble {
    public static final String PMS_CAMERA = "CAMERA";
    public static final String PMS_CONTACTS = "CONTACTS";
    public static final String PMS_GALLERY = "GALLERY";
    public static final String PMS_LOCATION = "LOCATION";
    public static final String PMS_NATIVEJS = "NATIVE.JS";
    public static final String PMS_PHONE = "PHONE";
    public static final String PMS_PUSH = "PUSH";
    public static final String PMS_RECORD = "RECORD";
    public static final String PMS_SHORTCUT = "SHORTCUT";
    public static final String PMS_SMS = "SMS";
    public static final String PMS_STORAGE = "STORAGE";
    public static final String PMS_STORAGE_IMAGE = "STORAGE_IMAGE";
    private static List<String> alwaysDeniedPer = null;
    public static boolean isCheckPermissionDisabled = false;
    private static HashMap<Integer, Object[]> sActivityResultCallBacks = new HashMap<>();
    private static int sDefQequestCode = 60505;
    private static HashMap<String, PermissionData> sPermissionData;
    private static HashMap<Integer, HashMap<Request, String[]>> sRequestCallBacks = new HashMap<>();
    private static int sRequestCodeCounter = 60505;
    public static int sUseStreamAppPermissionDialogCount = 0;
    private static LinkedList<ShowDialogData> sUseStreamAppPermissionDialogs = new LinkedList<>();
    private static HashMap<String, HashMap<String, Integer>> useRejectedCache = new HashMap<>();

    /* access modifiers changed from: package-private */
    public static class PermissionData {
        static final int CB_NOSHOW = -1;
        static final int CB_SELECTED = 1;
        static final int CB_SHOW = 0;
        static final int GT_DENIED = -1;
        static final int GT_GRANTED = 1;
        static final int GT_ONCE = 0;
        int checkbox;
        int grantType;
        int messageId;
        String name;

        PermissionData(String str, int i, int i2, int i3) {
            this.name = str;
            this.messageId = i;
            this.checkbox = i2;
            this.grantType = i3;
        }
    }

    public static abstract class Request {
        public static final int PERMISSION_ASK = 1;
        public static final int PERMISSION_DENIED = -1;
        public static final int PERMISSION_GRANTED = 0;
        private int mRequestCode = PermissionUtil.sDefQequestCode;

        public String getAppName() {
            return null;
        }

        public int getRequestCode() {
            return this.mRequestCode;
        }

        public abstract void onDenied(String str);

        public abstract void onGranted(String str);

        public void setRequestCode(int i) {
            this.mRequestCode = i;
        }
    }

    public static abstract class StreamPermissionRequest extends Request {
        IApp mApp;
        private String mAppName = null;
        public String mAppid = null;
        private String[] mOriginalPermisson = null;
        private String[] mPermission = null;
        public Object mTag = null;

        public StreamPermissionRequest(IApp iApp) {
            setApp(iApp);
        }

        @Override // io.dcloud.common.adapter.util.PermissionUtil.Request
        public String getAppName() {
            return this.mAppName;
        }

        /* access modifiers changed from: package-private */
        public String[] getStreamRequestPermission() {
            return this.mOriginalPermisson;
        }

        /* access modifiers changed from: protected */
        public String[] getSystemRequestPermission() {
            return this.mPermission;
        }

        public void setApp(IApp iApp) {
            this.mApp = iApp;
            this.mAppid = iApp.obtainAppId();
            this.mAppName = iApp.obtainAppName();
        }

        public StreamPermissionRequest setRequestPermission(String... strArr) {
            this.mOriginalPermisson = strArr;
            this.mPermission = new String[strArr.length];
            int i = 0;
            while (true) {
                String[] strArr2 = this.mPermission;
                if (i >= strArr2.length) {
                    return this;
                }
                strArr2[i] = PermissionUtil.convert2SystemPermission(strArr[i]);
                i++;
            }
        }
    }

    static {
        HashMap<String, PermissionData> hashMap = new HashMap<>();
        sPermissionData = hashMap;
        hashMap.put(PMS_LOCATION, new PermissionData(PMS_LOCATION, R.string.dcloud_permissions_whether_allow, -1, 1));
        sPermissionData.put(PMS_RECORD, new PermissionData(PMS_RECORD, R.string.dcloud_permissions_record_whether_allow, -1, 1));
        sPermissionData.put(PMS_CAMERA, new PermissionData(PMS_CAMERA, R.string.dcloud_permissions_camera_whether_allow, -1, 1));
        sPermissionData.put(PMS_GALLERY, new PermissionData(PMS_GALLERY, R.string.dcloud_permissions_album_whether_allow, -1, 1));
        sPermissionData.put(PMS_PUSH, new PermissionData(PMS_PUSH, R.string.dcloud_permissions_informs_whether_allow, -1, 1));
        sPermissionData.put("SHORTCUT", new PermissionData("SHORTCUT", R.string.dcloud_permissions_short_cut_close_tips, 1, 0));
        sPermissionData.put(PMS_SMS, new PermissionData(PMS_SMS, R.string.dcloud_permissions_sms_whether_allow, -1, 1));
        sPermissionData.put(PMS_PHONE, new PermissionData(PMS_PHONE, R.string.dcloud_permissions_phone_call_whether_allow, -1, 1));
        sPermissionData.put(PMS_NATIVEJS, new PermissionData(PMS_NATIVEJS, R.string.dcloud_permissions_njs_whether_allow, 1, 0));
    }

    private PermissionUtil() {
    }

    private static boolean caseVersion(Activity activity) {
        if (Build.VERSION.SDK_INT >= 23 && activity != null && activity.getApplicationInfo().targetSdkVersion >= 23) {
            String str = Build.BRAND;
            return !str.equalsIgnoreCase(MobilePhoneModel.GIONEE) && !str.equalsIgnoreCase(MobilePhoneModel.QIHU360);
        }
    }

    public static boolean checkLocationPermission(Activity activity) {
        if (isEMUIRom(activity)) {
            return checkPermission_EMUI(activity);
        }
        if (isMiuiRom(activity)) {
            int isMiui = isMiui(activity, "android.permission.ACCESS_COARSE_LOCATION", (String) null);
            if (isMiui == -100 || isMiui == 0) {
                return true;
            }
            return false;
        } else if (isFlymeRom(activity)) {
            return checkPermission_Flyme(activity);
        } else {
            return true;
        }
    }

    public static boolean checkLocationService(Activity activity) {
        try {
            LocationManager locationManager = (LocationManager) activity.getSystemService("location");
            boolean isProviderEnabled = locationManager.isProviderEnabled("gps");
            boolean isProviderEnabled2 = locationManager.isProviderEnabled("network");
            if (isProviderEnabled || isProviderEnabled2) {
                return true;
            }
            return false;
        } catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    public static String checkPermission(IWebview iWebview, String[] strArr) {
        if (strArr[0].equals("SHORTCUT")) {
            return PermissionControler.checkPermission(iWebview, strArr);
        }
        if (caseVersion(iWebview.getActivity())) {
            return PermissionControler.checkPermission(iWebview, strArr);
        }
        return checkSelfPermission(iWebview.getActivity(), convert2SystemPermission(strArr[0]), iWebview.obtainApp().obtainAppName()) == -1 ? IApp.AUTHORITY_DENIED : "notdeny";
    }

    public static boolean checkPermissionDenied(Activity activity, String str) {
        initAlwaysDenied(activity);
        if (alwaysDeniedPer.contains(str)) {
            return isCheckPermissionDisabled || !ActivityCompat.shouldShowRequestPermissionRationale(activity, str);
        }
        return false;
    }

    private static boolean checkPermission_EMUI(Activity activity) {
        try {
            if (((Integer) PlatformUtil.invokeMethod("com.huawei.android.app.AppOpsManagerEx", "getMode", null, new Class[]{Integer.TYPE, String.class}, new Object[]{8, activity.getPackageName()})).intValue() == 1) {
                return true;
            }
            return false;
        } catch (Throwable th) {
            th.printStackTrace();
            return true;
        }
    }

    private static boolean checkPermission_Flyme(Activity activity) {
        try {
            return ((Boolean) PlatformUtil.invokeMethod("meizu.security.FlymePermissionManager", "isFlymePermissionGranted", null, new Class[]{Integer.TYPE}, new Object[]{75})).booleanValue();
        } catch (Throwable th) {
            th.printStackTrace();
            return true;
        }
    }

    public static boolean checkPermissions(Context context, String[] strArr) {
        if (strArr != null && strArr.length > 0) {
            for (String str : strArr) {
                if (checkSelfPermission((Activity) context, str, "") == -1) {
                    return false;
                }
            }
        }
        return true;
    }

    public static int checkSelfPermission(Activity activity, String str, String str2) {
        if ("android.permission.INSTALL_SHORTCUT".equals(str)) {
            return 1 != AppPermissionUtil.checkPermission(activity, str2) ? 0 : -1;
        }
        if (!caseVersion(activity) || str == null) {
            return trycatchGetPermission(activity, str, str2);
        }
        return ActivityCompat.checkSelfPermission(activity, str);
    }

    public static int checkStreamAppPermission(Context context, String str, String str2) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("stream_permission", 0);
        return sharedPreferences.getInt(str + "_" + str2, 1);
    }

    public static void clearPermission(Context context, String str) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("stream_permission", 0);
        Iterator<String> it = sPermissionData.keySet().iterator();
        SharedPreferences.Editor edit = sharedPreferences.edit();
        while (it.hasNext()) {
            edit.remove(str + "_" + it.next());
        }
        edit.commit();
    }

    public static void clearUseRejectedCache() {
        useRejectedCache.clear();
    }

    private static synchronized boolean continueShowStreamAppPermissionDialog(ShowDialogData showDialogData) {
        synchronized (PermissionUtil.class) {
            if (showDialogData.force) {
                return true;
            }
            if (sUseStreamAppPermissionDialogCount != 0) {
                sUseStreamAppPermissionDialogs.add(showDialogData);
            }
            sUseStreamAppPermissionDialogCount++;
            return sUseStreamAppPermissionDialogs.isEmpty();
        }
    }

    public static String convert2StreamPermission(String str) {
        if ("android.permission.CAMERA".equals(str)) {
            return PMS_CAMERA;
        }
        if ("android.permission.RECORD_AUDIO".equals(str)) {
            return PMS_RECORD;
        }
        if ("android.permission.ACCESS_COARSE_LOCATION".equals(str)) {
            return PMS_LOCATION;
        }
        if ("android.permission.WRITE_CONTACTS".equals(str)) {
            return PMS_CONTACTS;
        }
        if ("android.permission.SEND_SMS".equals(str)) {
            return PMS_SMS;
        }
        if ("android.permission.CALL_PHONE".equals(str)) {
            return PMS_PHONE;
        }
        if ("android.permission.WRITE_EXTERNAL_STORAGE".equals(str)) {
            return PMS_STORAGE;
        }
        if ("android.permission.INSTALL_SHORTCUT".equals(str)) {
            return "SHORTCUT";
        }
        if (!PMS_GALLERY.equals(str) && !PMS_NATIVEJS.equals(str)) {
            PMS_PUSH.equals(str);
        }
        return str;
    }

    public static String convert2SystemPermission(String str) {
        if (PMS_CAMERA.equalsIgnoreCase(str)) {
            return "android.permission.CAMERA";
        }
        if (PMS_RECORD.equalsIgnoreCase(str)) {
            return "android.permission.RECORD_AUDIO";
        }
        if (PMS_LOCATION.equalsIgnoreCase(str)) {
            return "android.permission.ACCESS_COARSE_LOCATION";
        }
        if (PMS_CONTACTS.equalsIgnoreCase(str)) {
            return "android.permission.WRITE_CONTACTS";
        }
        if (PMS_STORAGE.equalsIgnoreCase(str)) {
            return "android.permission.WRITE_EXTERNAL_STORAGE";
        }
        if (PMS_STORAGE_IMAGE.equalsIgnoreCase(str)) {
            if (Build.VERSION.SDK_INT < 33) {
                return "android.permission.WRITE_EXTERNAL_STORAGE";
            }
            return "android.permission.READ_MEDIA_IMAGES";
        } else if (PMS_SMS.equalsIgnoreCase(str)) {
            return "android.permission.SEND_SMS";
        } else {
            if (PMS_PHONE.equalsIgnoreCase(str)) {
                return "android.permission.CALL_PHONE";
            }
            if ("SHORTCUT".equalsIgnoreCase(str)) {
                return "android.permission.INSTALL_SHORTCUT";
            }
            if (!PMS_GALLERY.equalsIgnoreCase(str) && !PMS_NATIVEJS.equalsIgnoreCase(str)) {
                PMS_PUSH.equalsIgnoreCase(str);
            }
            return str;
        }
    }

    public static String convert5PlusValue(int i) {
        return PermissionControler.convert5PlusValue(i);
    }

    public static String convertNativePermission(String str) {
        return PermissionControler.convertNativePermission(str);
    }

    private static int getDeivceSuitablePixel(Activity activity, int i) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        activity.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        return (int) (((float) i) * displayMetrics.density);
    }

    public static int getRequestCode() {
        if (sRequestCodeCounter >= 65535) {
            restRequstCode();
        }
        int i = sRequestCodeCounter;
        sRequestCodeCounter = i + 1;
        return i;
    }

    public static void goPermissionCenter(Activity activity, String str, String str2, Request request) {
        if (!SafeCenter.goSafeCenter(activity, str2, request)) {
            request.onDenied(str2);
        }
    }

    public static void goSafeCenter(Activity activity) {
        SafeCenter.goSafeCenter(activity);
    }

    public static boolean hasDefinedInManifest(Context context, String str) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getApplicationInfo().packageName, 4096);
            if (packageInfo != null) {
                int i = 0;
                while (true) {
                    String[] strArr = packageInfo.requestedPermissions;
                    if (i >= strArr.length) {
                        break;
                    } else if (str.equals(strArr[i])) {
                        return true;
                    } else {
                        i++;
                    }
                }
            }
            return false;
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void initAlwaysDenied(Activity activity) {
        if (alwaysDeniedPer == null) {
            String bundleData = SP.getBundleData(activity, "ALWAYS_DENIED_PERMISSION", "permissions");
            if (!TextUtils.isEmpty(bundleData)) {
                alwaysDeniedPer = new ArrayList(Arrays.asList(bundleData.split(",")));
            } else {
                alwaysDeniedPer = new ArrayList();
            }
        }
    }

    private static boolean isAndroid(Activity activity, String str, Request request) {
        Intent intent = new Intent();
        intent.setClassName("com.android.Setting", "com.android.SubSetting");
        intent.putExtra("package", activity.getPackageName());
        int requestCode = getRequestCode();
        activity.startActivityForResult(intent, requestCode);
        saveCallabckData(activity, str, request, requestCode);
        return true;
    }

    public static boolean isEMUIRom(Activity activity) {
        return Build.MANUFACTURER.toLowerCase(Locale.ENGLISH).contains("huawei");
    }

    private static boolean isFlyme(Activity activity, String str, Request request) {
        if (!Build.BRAND.contains("Meizu")) {
            return false;
        }
        Intent intent = new Intent();
        intent.setClassName("com.meizu.safe", "com.meizu.safe.security.AppSecActivity");
        intent.putExtra("packageName", activity.getPackageName());
        int requestCode = getRequestCode();
        activity.startActivityForResult(intent, requestCode);
        saveCallabckData(activity, str, request, requestCode);
        return true;
    }

    private static boolean isFlymeRom(Activity activity) {
        return Build.BRAND.toLowerCase(Locale.ENGLISH).contains("meizu");
    }

    public static boolean isMainStreamPermission(String str) {
        return PMS_LOCATION.equalsIgnoreCase(str) || "SHORTCUT".equalsIgnoreCase(str) || PMS_RECORD.equalsIgnoreCase(str);
    }

    private static int isMiui(Activity activity, String str, String str2) {
        Object systemService;
        try {
            if (isMiuiRom(activity) && (systemService = activity.getSystemService("appops")) != null) {
                int i = systemService.getClass().getField("OP_GPS").getInt(null);
                Class<?> cls = systemService.getClass();
                Class<?> cls2 = Integer.TYPE;
                int intValue = ((Integer) cls.getMethod("checkOp", cls2, cls2, String.class).invoke(systemService, Integer.valueOf(i), Integer.valueOf(Binder.getCallingUid()), activity.getPackageName())).intValue();
                if (intValue == systemService.getClass().getField("MODE_IGNORED").getInt(null)) {
                    return -1;
                }
                if (intValue == systemService.getClass().getField("MODE_ALLOWED").getInt(null)) {
                    return 0;
                }
            }
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        } catch (Exception e2) {
            e2.printStackTrace();
        }
        return -100;
    }

    private static boolean isMiuiRom(Activity activity) {
        if (Build.VERSION.SDK_INT < 21) {
            return false;
        }
        String property = System.getProperty("http.agent");
        return !TextUtils.isEmpty(property) && property.toLowerCase(Locale.ENGLISH).contains("miui");
    }

    public static void onActivityResult(Activity activity, int i, int i2, Intent intent) {
        HashMap<Integer, Object[]> hashMap = sActivityResultCallBacks;
        int i3 = i % ADSim.INTISPLSH;
        Object[] objArr = hashMap.get(Integer.valueOf(i3));
        if (objArr != null) {
            if (System.currentTimeMillis() - activity.getIntent().getLongExtra(IntentConst.PER_GO_CENTER_TIME, System.currentTimeMillis()) > 1000) {
                sActivityResultCallBacks.remove(Integer.valueOf(i3));
                String str = (String) objArr[0];
                String convert2SystemPermission = convert2SystemPermission(str);
                Request request = (Request) objArr[1];
                activity.getIntent().removeExtra(IntentConst.PER_GO_CENTER_TIME);
                if (checkSelfPermission(activity, convert2SystemPermission, request.getAppName()) == 0) {
                    request.onGranted(str);
                } else {
                    request.onDenied(str);
                }
            }
        }
    }

    public static void onRequestSysPermissionResume(Activity activity) {
        int intExtra = activity.getIntent().getIntExtra(IntentConst.PER_GO_CENTER_REQUESTCODE, 0);
        if (intExtra != 0) {
            onActivityResult(activity, intExtra, 0, null);
        }
    }

    public static void onSystemPermissionsResult(Activity activity, int i, String[] strArr, int[] iArr) {
        String[] strArr2;
        HashMap<Request, String[]> remove = sRequestCallBacks.remove(Integer.valueOf(i));
        if (remove != null && remove.size() > 0) {
            Request[] requestArr = (Request[]) remove.keySet().toArray(new Request[0]);
            Request request = null;
            if (requestArr.length > 0) {
                request = requestArr[0];
            }
            initAlwaysDenied(activity);
            for (int i2 = 0; i2 < strArr.length; i2++) {
                int i3 = iArr[i2];
                String convert2StreamPermission = convert2StreamPermission(strArr[i2]);
                if (i3 == -1) {
                    try {
                        if (!checkPermissionDenied(activity, strArr[i2])) {
                            alwaysDeniedPer.add(strArr[i2]);
                        }
                    } catch (RuntimeException unused) {
                    }
                    if (request != null) {
                        request.onDenied(convert2StreamPermission);
                    }
                } else if (i3 == 0) {
                    if (alwaysDeniedPer.contains(strArr[i2])) {
                        alwaysDeniedPer.remove(strArr[i2]);
                    }
                    if (request != null) {
                        request.onGranted(convert2StreamPermission);
                    }
                }
            }
            if (alwaysDeniedPer.size() > 0) {
                SP.setBundleData(activity, "ALWAYS_DENIED_PERMISSION", "permissions", TextUtils.join(",", (String[]) alwaysDeniedPer.toArray(new String[0])));
            }
            if (strArr.length == 0 && iArr.length == 0 && request != null && (strArr2 = remove.get(request)) != null) {
                for (String str : strArr2) {
                    request.onDenied(convert2StreamPermission(str));
                }
            }
        }
    }

    public static void putStreamAppPermission(Context context, String str, String str2, int i) {
        SharedPreferences.Editor edit = context.getSharedPreferences("stream_permission", 0).edit();
        edit.putInt(str + "_" + str2, i).commit();
    }

    public static void removeStreamAppPermission(Context context, String str, String str2) {
        SharedPreferences.Editor edit = context.getSharedPreferences("stream_permission", 0).edit();
        edit.remove(str + "_" + str2).commit();
    }

    public static void removeTempPermission(Context context, String str) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("stream_permission", 0);
        SharedPreferences.Editor edit = sharedPreferences.edit();
        for (String str2 : sPermissionData.keySet()) {
            String str3 = str + "_" + str2;
            if (sharedPreferences.contains(str3) && (sharedPreferences.getInt(str3, 1) != 0 || "SHORTCUT".equals(str2) || PMS_NATIVEJS.equals(str2))) {
                edit.remove(str3);
            }
        }
        edit.commit();
    }

    public static void requestPermissions(Activity activity, String[] strArr, int i) {
        PermissionControler.requestPermissions(activity, strArr, i);
    }

    public static void requestSystemPermissions(Activity activity, String[] strArr, int i, Request request) {
        requestSystemPermissions(activity, strArr, i, request, true);
    }

    public static void restRequstCode() {
        sRequestCodeCounter = sDefQequestCode;
    }

    /* access modifiers changed from: private */
    public static void saveCallabckData(Activity activity, String str, Request request, int i) {
        sActivityResultCallBacks.put(Integer.valueOf(i), new Object[]{str, request});
        activity.getIntent().putExtra(IntentConst.PER_GO_CENTER_REQUESTCODE, i);
        activity.getIntent().putExtra(IntentConst.PER_GO_CENTER_TIME, System.currentTimeMillis());
    }

    /* access modifiers changed from: private */
    public static synchronized void showStreamAppPermissionDialog() {
        synchronized (PermissionUtil.class) {
            int i = sUseStreamAppPermissionDialogCount;
            if (i > 0) {
                sUseStreamAppPermissionDialogCount = i - 1;
            }
            if (!sUseStreamAppPermissionDialogs.isEmpty()) {
                ShowDialogData pop = sUseStreamAppPermissionDialogs.pop();
                pop.force = true;
                if (1 != useStreamPermission(pop)) {
                    showStreamAppPermissionDialog();
                }
            }
        }
    }

    /* JADX WARNING: Code restructure failed: missing block: B:102:?, code lost:
        return 0;
     */
    /* JADX WARNING: Code restructure failed: missing block: B:20:0x003f, code lost:
        r6 = move-exception;
     */
    /* JADX WARNING: Code restructure failed: missing block: B:21:0x0040, code lost:
        r6.printStackTrace();
     */
    /* JADX WARNING: Code restructure failed: missing block: B:30:0x00cc, code lost:
        r6 = e;
     */
    /* JADX WARNING: Code restructure failed: missing block: B:31:0x00cd, code lost:
        r2 = 0;
     */
    /* JADX WARNING: Code restructure failed: missing block: B:32:0x00cf, code lost:
        r6 = e;
     */
    /* JADX WARNING: Code restructure failed: missing block: B:33:0x00d0, code lost:
        r2 = 0;
     */
    /* JADX WARNING: Code restructure failed: missing block: B:34:0x00d2, code lost:
        r6 = e;
     */
    /* JADX WARNING: Code restructure failed: missing block: B:36:?, code lost:
        r6 = r6.getMessage();
     */
    /* JADX WARNING: Code restructure failed: missing block: B:37:0x00d7, code lost:
        if (r6 == null) goto L_?;
     */
    /* JADX WARNING: Code restructure failed: missing block: B:44:0x00ec, code lost:
        r6 = e;
     */
    /* JADX WARNING: Code restructure failed: missing block: B:46:0x00f1, code lost:
        if (r6.getMessage() != null) goto L_0x00f3;
     */
    /* JADX WARNING: Code restructure failed: missing block: B:48:0x00fd, code lost:
        if (r6.getMessage().contains("Permission deny") == false) goto L_0x00ff;
     */
    /* JADX WARNING: Code restructure failed: missing block: B:50:0x0109, code lost:
        if (r6.getMessage().contains("Permission denied") != false) goto L_0x010b;
     */
    /* JADX WARNING: Code restructure failed: missing block: B:53:0x0114, code lost:
        if (android.os.Build.BRAND.equalsIgnoreCase(io.dcloud.common.adapter.util.MobilePhoneModel.GIONEE) == false) goto L_?;
     */
    /* JADX WARNING: Code restructure failed: missing block: B:78:0x01aa, code lost:
        r6 = move-exception;
     */
    /* JADX WARNING: Code restructure failed: missing block: B:79:0x01ab, code lost:
        r6.printStackTrace();
     */
    /* JADX WARNING: Code restructure failed: missing block: B:94:?, code lost:
        return 0;
     */
    /* JADX WARNING: Code restructure failed: missing block: B:95:?, code lost:
        return 0;
     */
    /* JADX WARNING: Code restructure failed: missing block: B:96:?, code lost:
        return 0;
     */
    /* JADX WARNING: Code restructure failed: missing block: B:97:?, code lost:
        return r2;
     */
    /* JADX WARNING: Failed to process nested try/catch */
    /* JADX WARNING: Removed duplicated region for block: B:102:? A[RETURN, SYNTHETIC] */
    /* JADX WARNING: Removed duplicated region for block: B:38:0x00d9 A[Catch:{ SecurityException -> 0x00e9, all -> 0x01d7 }] */
    /* JADX WARNING: Removed duplicated region for block: B:47:0x00f3 A[Catch:{ SecurityException -> 0x00e9, all -> 0x01d7 }] */
    /* JADX WARNING: Removed duplicated region for block: B:91:? A[ExcHandler: all (unused java.lang.Throwable), SYNTHETIC, Splitter:B:1:0x0006] */
    /* JADX WARNING: Removed duplicated region for block: B:95:? A[RETURN, SYNTHETIC] */
    /* JADX WARNING: Unknown top exception splitter block from list: {B:35:0x00d3=Splitter:B:35:0x00d3, B:6:0x000f=Splitter:B:6:0x000f} */
    private static int trycatchGetPermission(Activity activity, String str, String str2) {
        int i = -1;
        try {
            if ("android.permission.CAMERA".equals(str)) {
                Camera camera = null;
                int i2 = 0;
                while (true) {
                    if (i2 >= Camera.getNumberOfCameras()) {
                        break;
                    }
                    Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
                    Camera.getCameraInfo(i2, cameraInfo);
                    if (cameraInfo.facing == 1) {
                        camera = Camera.open(i2);
                        break;
                    }
                    i2++;
                }
                if (camera == null) {
                    camera = Camera.open();
                }
                if (camera != null) {
                    Camera.Parameters parameters = camera.getParameters();
                    if (parameters != null) {
                        parameters.getSupportedVideoSizes();
                    }
                    camera.release();
                    return 0;
                }
                return -1;
            } else if ("android.permission.RECORD_AUDIO".equals(str)) {
                MediaRecorder mediaRecorder = new MediaRecorder();
                mediaRecorder.reset();
                mediaRecorder.setAudioSource(0);
                mediaRecorder.setOutputFile(activity.getExternalFilesDir(Environment.DIRECTORY_DOWNLOADS) + "/temp.3gp");
                mediaRecorder.setAudioSamplingRate(96000);
                mediaRecorder.setOutputFormat(1);
                mediaRecorder.setAudioEncoder(3);
                mediaRecorder.prepare();
                mediaRecorder.start();
                mediaRecorder.stop();
                mediaRecorder.release();
                if (new File(activity.getExternalFilesDir(Environment.DIRECTORY_DOWNLOADS) + "/temp.3gp").length() > 0) {
                    new File(activity.getExternalFilesDir(Environment.DIRECTORY_DOWNLOADS) + "/temp.3gp").delete();
                    return 0;
                }
                return -1;
            } else {
                if ("android.permission.ACCESS_COARSE_LOCATION".equals(str)) {
                    LocationManager locationManager = (LocationManager) activity.getSystemService("location");
                    boolean isProviderEnabled = locationManager.isProviderEnabled("gps");
                    boolean isProviderEnabled2 = locationManager.isProviderEnabled("network");
                    boolean equals = TextUtils.equals("ZTE B880", Build.MODEL);
                    if (isProviderEnabled || isProviderEnabled2) {
                        int isMiui = isMiui(activity, str, str2);
                        if (isMiui != -100) {
                            return isMiui;
                        }
                        return 0;
                    } else if (equals) {
                        return 0;
                    }
                } else if (!"android.permission.WRITE_CONTACTS".equals(str) && !"android.permission.SEND_SMS".equals(str) && !"android.permission.CALL_PHONE".equals(str)) {
                    if ("android.permission.WRITE_EXTERNAL_STORAGE".equals(str)) {
                        File file = new File(activity.getExternalFilesDir(Environment.DIRECTORY_DOWNLOADS) + "/temp.arm");
                        if (!file.getParentFile().exists()) {
                            file.getParentFile().mkdirs();
                        }
                        if (file.exists()) {
                            return 0;
                        }
                        file.createNewFile();
                        return 0;
                    } else if ("android.permission.INSTALL_SHORTCUT".equals(str)) {
                        if (1 != AppPermissionUtil.checkPermission(activity, str2)) {
                            return 0;
                        }
                    } else if (!PMS_GALLERY.equals(str) && !PMS_NATIVEJS.equals(str)) {
                        PMS_PUSH.equals(str);
                    }
                }
                return -1;
            }
        } catch (SecurityException unused) {
        } catch (Throwable unused2) {
        }
    }

    /* access modifiers changed from: private */
    public static void unregisterWebAppReStartEvent(IApp iApp, ISysEventListener iSysEventListener) {
        iApp.unregisterSysEventListener(iSysEventListener, ISysEventListener.SysEventType.onWebAppReStart);
    }

    public static synchronized void usePermission(Activity activity, final String str, String str2, int i, final Request request) {
        HashMap<String, Integer> hashMap;
        synchronized (PermissionUtil.class) {
            if (!str2.equals(PMS_STORAGE) || activity.getApplicationInfo().targetSdkVersion < 33 || Build.VERSION.SDK_INT < 33) {
                String convert2SystemPermission = convert2SystemPermission(str2);
                if (checkSelfPermission(activity, convert2SystemPermission, request.getAppName()) == 0) {
                    request.onGranted(str2);
                } else if (!useRejectedCache.containsKey(str) || i <= 0 || (hashMap = useRejectedCache.get(str)) == null || !hashMap.containsKey(str2) || hashMap.get(str2).intValue() < i) {
                    useSystemPermission(activity, convert2SystemPermission, new Request() {
                        /* class io.dcloud.common.adapter.util.PermissionUtil.AnonymousClass1 */

                        @Override // io.dcloud.common.adapter.util.PermissionUtil.Request
                        public void onDenied(String str) {
                            try {
                                if (PermissionUtil.useRejectedCache.containsKey(str)) {
                                    HashMap hashMap = (HashMap) PermissionUtil.useRejectedCache.get(str);
                                    if (hashMap == null) {
                                        hashMap = new HashMap();
                                    }
                                    if (hashMap.containsKey(str)) {
                                        hashMap.put(str, Integer.valueOf(((Integer) hashMap.get(str)).intValue() + 1));
                                    } else {
                                        hashMap.put(str, 1);
                                    }
                                    PermissionUtil.useRejectedCache.put(str, hashMap);
                                } else {
                                    HashMap hashMap2 = new HashMap();
                                    hashMap2.put(str, 1);
                                    PermissionUtil.useRejectedCache.put(str, hashMap2);
                                }
                            } catch (Exception unused) {
                            }
                            request.onDenied(str);
                        }

                        @Override // io.dcloud.common.adapter.util.PermissionUtil.Request
                        public void onGranted(String str) {
                            try {
                                if (PermissionUtil.useRejectedCache.containsKey(str)) {
                                    ((HashMap) PermissionUtil.useRejectedCache.get(str)).remove(str);
                                }
                            } catch (Exception unused) {
                            }
                            request.onGranted(str);
                        }
                    });
                } else {
                    request.onDenied(str2);
                }
            } else {
                request.onGranted(str2);
            }
        }
    }

    private static int useStreamPermission(ShowDialogData showDialogData) {
        Activity activity = showDialogData.activity;
        String str = showDialogData.appid;
        String str2 = showDialogData.streamPerName;
        Request request = showDialogData.request;
        int checkStreamAppPermission = checkStreamAppPermission(activity, str, str2);
        if (checkStreamAppPermission == -1) {
            request.onDenied(str2);
        } else if (checkStreamAppPermission == 0) {
            request.onGranted(str2);
        } else if (checkStreamAppPermission == 1) {
            showStreamAppPermissionDialog(showDialogData);
        }
        return checkStreamAppPermission;
    }

    public static boolean useSystemPermission(Activity activity, String str, Request request) {
        boolean z = activity.getApplicationInfo().targetSdkVersion >= 23 && str != null && str.contains("android.permission") && Build.VERSION.SDK_INT >= 23;
        String convert2StreamPermission = convert2StreamPermission(str);
        if (z) {
            request.setRequestCode(getRequestCode());
            int checkSelfPermission = checkSelfPermission(activity, str, request.getAppName());
            if (checkSelfPermission == -1) {
                if (checkPermissionDenied(activity, str)) {
                    request.onDenied(convert2StreamPermission);
                    return true;
                } else if (str.equals("android.permission.ACCESS_COARSE_LOCATION")) {
                    requestSystemPermissions(activity, new String[]{str, "android.permission.ACCESS_FINE_LOCATION"}, request.getRequestCode(), request);
                    return false;
                } else if (str.equalsIgnoreCase("android.permission.READ_MEDIA_IMAGES")) {
                    requestSystemPermissions(activity, new String[]{str, "android.permission.READ_MEDIA_VIDEO", "android.permission.WRITE_EXTERNAL_STORAGE"}, request.getRequestCode(), request);
                    return false;
                } else {
                    requestSystemPermissions(activity, new String[]{str}, request.getRequestCode(), request);
                    return false;
                }
            } else if (checkSelfPermission != 0) {
                return false;
            } else {
                request.onGranted(convert2StreamPermission);
            }
        } else {
            request.onGranted(convert2StreamPermission);
        }
        return true;
    }

    public static void useSystemPermissions(Activity activity, String[] strArr, Request request) {
        boolean z = true;
        boolean z2 = activity.getApplicationInfo().targetSdkVersion >= 23 && strArr != null && strArr.length > 0 && Build.VERSION.SDK_INT >= 23;
        ArrayList arrayList = new ArrayList(Arrays.asList(strArr));
        if (z2) {
            request.setRequestCode(getRequestCode());
            ArrayList arrayList2 = new ArrayList();
            if (alwaysDeniedPer != null) {
                z = false;
            }
            for (int i = 0; i < arrayList.size(); i++) {
                String convert2SystemPermission = convert2SystemPermission((String) arrayList.get(i));
                if (checkSelfPermission(activity, convert2SystemPermission, request.getAppName()) == 0) {
                    arrayList2.add(convert2SystemPermission);
                    request.onGranted(convert2StreamPermission(convert2SystemPermission));
                } else if (checkPermissionDenied(activity, convert2SystemPermission) && !z) {
                    arrayList2.add(convert2SystemPermission);
                    request.onDenied(convert2StreamPermission(convert2SystemPermission));
                }
            }
            if (arrayList2.size() > 0) {
                arrayList.removeAll(arrayList2);
            }
            if (arrayList.size() > 0) {
                requestSystemPermissions(activity, (String[]) arrayList.toArray(new String[0]), request.getRequestCode(), request);
                return;
            }
            return;
        }
        for (int i2 = 0; i2 < arrayList.size(); i2++) {
            request.onGranted(convert2StreamPermission((String) arrayList.get(i2)));
        }
    }

    /* access modifiers changed from: private */
    public static class ShowDialogData {
        Activity activity;
        String appName;
        String appid;
        boolean force;
        IApp mApp;
        Request request;
        String streamPerName;
        int tryTimes;

        ShowDialogData(Activity activity2, IApp iApp, String str, String str2, String str3, Request request2) {
            this(activity2, iApp, str, str2, str3);
            setRequestHandler(request2);
        }

        /* access modifiers changed from: package-private */
        public void setRequestHandler(Request request2) {
            this.request = request2;
        }

        ShowDialogData(Activity activity2, IApp iApp, String str, String str2, String str3) {
            this.tryTimes = 0;
            this.activity = activity2;
            this.mApp = iApp;
            this.streamPerName = str;
            this.appid = str2;
            this.appName = str3;
        }
    }

    public static void requestSystemPermissions(Activity activity, String[] strArr, int i, Request request, boolean z) {
        if (caseVersion(activity) && strArr != null) {
            HashMap<Request, String[]> hashMap = new HashMap<>();
            hashMap.put(request, strArr);
            sRequestCallBacks.put(Integer.valueOf(i), hashMap);
            ArrayList arrayList = new ArrayList();
            if (z) {
                for (String str : strArr) {
                    if (!checkPermissionDenied(activity, str)) {
                        arrayList.add(str);
                    } else if (request != null) {
                        request.onDenied(str);
                        return;
                    } else {
                        return;
                    }
                }
                if (arrayList.size() > 0) {
                    strArr = (String[]) arrayList.toArray(new String[0]);
                }
            }
            requestPermissions(activity, strArr, i);
        } else if (strArr != null) {
            try {
                for (String str2 : strArr) {
                    request.onGranted(convert2StreamPermission(str2));
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void showStreamAppPermissionDialog(final ShowDialogData showDialogData) {
        String str;
        final Activity activity = showDialogData.activity;
        final String str2 = showDialogData.appid;
        String str3 = showDialogData.appName;
        final String str4 = showDialogData.streamPerName;
        final Request request = showDialogData.request;
        Logger.e("Permission", "showStreamAppPermissionDialog streamPerName=" + str4 + ";count=" + sUseStreamAppPermissionDialogCount);
        PermissionData permissionData = sPermissionData.get(str4);
        if (permissionData == null) {
            request.onGranted(str4);
        } else if (continueShowStreamAppPermissionDialog(showDialogData)) {
            boolean z = true;
            int i = showDialogData.tryTimes + 1;
            showDialogData.tryTimes = i;
            boolean z2 = i == 1;
            final DCloudAlertDialog initDialogTheme = DialogUtil.initDialogTheme(activity, true);
            if (activity != null && (activity instanceof WebAppActivity)) {
                ((WebAppActivity) activity).recordDialog(initDialogTheme);
            }
            initDialogTheme.setCanceledOnTouchOutside(false);
            if (!z2) {
                if (Build.BRAND.equalsIgnoreCase(MobilePhoneModel.QiKU)) {
                    initDialogTheme.setMessage(activity.getString(R.string.dcloud_permissions_short_cut_tips2));
                }
                if (PMS_LOCATION.equalsIgnoreCase(str4)) {
                    initDialogTheme.setMessage(activity.getString(R.string.dcloud_permissions_geo_retry_tips));
                } else {
                    initDialogTheme.setMessage(StringUtil.format(activity.getString(R.string.dcloud_permissions_retry_tips), activity.getPackageManager().getApplicationLabel(activity.getApplicationInfo())));
                }
            } else if (Build.BRAND.equalsIgnoreCase(MobilePhoneModel.QiKU)) {
                initDialogTheme.setMessage(activity.getString(R.string.dcloud_permissions_short_cut_tips));
            } else if (!TextUtils.isEmpty(str3)) {
                initDialogTheme.setMessage(StringUtil.format(activity.getString(permissionData.messageId), str3));
            } else {
                initDialogTheme.setMessage(StringUtil.format(activity.getString(permissionData.messageId), "App"));
            }
            final CheckBox checkBox = null;
            if (permissionData.checkbox != -1 && z2) {
                checkBox = new CheckBox(activity);
                checkBox.setText(R.string.dcloud_permissions_checkbox_close_tips);
                checkBox.setTextColor(-65536);
                if (permissionData.checkbox != 1) {
                    z = false;
                }
                checkBox.setChecked(z);
                int deivceSuitablePixel = getDeivceSuitablePixel(activity, 20);
                initDialogTheme.setView(checkBox, deivceSuitablePixel, deivceSuitablePixel, 0, 0);
            }
            final AnonymousClass3 r14 = new ISysEventListener() {
                /* class io.dcloud.common.adapter.util.PermissionUtil.AnonymousClass3 */

                @Override // io.dcloud.common.DHInterface.ISysEventListener
                public boolean onExecute(ISysEventListener.SysEventType sysEventType, Object obj) {
                    Logger.e("Permission", "unregisterSysEventListener registerSysEventListener pEventType=" + sysEventType);
                    if (sysEventType != ISysEventListener.SysEventType.onWebAppReStart) {
                        return false;
                    }
                    initDialogTheme.dismiss();
                    PermissionUtil.unregisterWebAppReStartEvent(showDialogData.mApp, this);
                    try {
                        request.onDenied(str4);
                        PermissionUtil.showStreamAppPermissionDialog();
                        return false;
                    } catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                }
            };
            if (showDialogData.mApp != null) {
                Logger.e("Permission", "showStreamAppPermissionDialog registerSysEventListener");
                showDialogData.mApp.registerSysEventListener(r14, ISysEventListener.SysEventType.onWebAppReStart);
            }
            AnonymousClass4 r15 = new DialogInterface.OnClickListener() {
                /* class io.dcloud.common.adapter.util.PermissionUtil.AnonymousClass4 */

                public void onClick(DialogInterface dialogInterface, int i) {
                    initDialogTheme.dismiss();
                    IApp iApp = showDialogData.mApp;
                    if (iApp != null) {
                        PermissionUtil.unregisterWebAppReStartEvent(iApp, r14);
                    }
                    if (i == -1) {
                        CheckBox checkBox = checkBox;
                        PermissionUtil.putStreamAppPermission(activity, str2, str4, !(checkBox == null ? true : checkBox.isChecked()) ? 1 : 0);
                        request.onGranted(str4);
                    } else if (i == -2) {
                        CheckBox checkBox2 = checkBox;
                        if (checkBox2 != null && checkBox2.isChecked()) {
                            PermissionUtil.putStreamAppPermission(activity, str2, str4, -1);
                        }
                        request.onDenied(str4);
                    }
                    PermissionUtil.showStreamAppPermissionDialog();
                }
            };
            String string = activity.getString(z2 ? R.string.dcloud_common_no_allow : R.string.dcloud_common_cancel);
            if (z2) {
                str = activity.getString(R.string.dcloud_common_allow);
            } else if (Build.BRAND.equalsIgnoreCase(MobilePhoneModel.QiKU) || PMS_LOCATION.equalsIgnoreCase(str4)) {
                str = activity.getString(R.string.dcloud_permissions_reopened);
            } else {
                str = activity.getString(R.string.dcloud_permissions_reauthorization);
            }
            initDialogTheme.setButton(-2, string, r15);
            initDialogTheme.setButton(-1, str, r15);
            initDialogTheme.setOnKeyListener(new DialogInterface.OnKeyListener() {
                /* class io.dcloud.common.adapter.util.PermissionUtil.AnonymousClass5 */

                public boolean onKey(DialogInterface dialogInterface, int i, KeyEvent keyEvent) {
                    if (keyEvent.getAction() != 1 || i != 4) {
                        return false;
                    }
                    initDialogTheme.dismiss();
                    IApp iApp = showDialogData.mApp;
                    if (iApp != null) {
                        PermissionUtil.unregisterWebAppReStartEvent(iApp, r14);
                    }
                    request.onDenied(str4);
                    PermissionUtil.showStreamAppPermissionDialog();
                    return true;
                }
            });
            try {
                initDialogTheme.show();
                initDialogTheme.setOnDismissListener(new DialogInterface.OnDismissListener() {
                    /* class io.dcloud.common.adapter.util.PermissionUtil.AnonymousClass6 */

                    public void onDismiss(DialogInterface dialogInterface) {
                        Activity activity = activity;
                        if (activity != null && (activity instanceof WebAppActivity)) {
                            ((WebAppActivity) activity).removeFromRecord(initDialogTheme);
                        }
                    }
                });
            } catch (Exception e) {
                Logger.e("ian", "try dialog");
                e.printStackTrace();
            }
        }
    }

    public static int checkSelfPermission(Activity activity, String str) {
        if (activity == null || str == null) {
            return 0;
        }
        return ((Integer) PlatformUtil.invokeMethod(activity.getClass().getName(), "checkSelfPermission", activity, new Class[]{str.getClass()}, new Object[]{str})).intValue();
    }

    private static boolean isMiui(Activity activity, String str, Request request) {
        String property = System.getProperty("http.agent");
        if (!TextUtils.isEmpty(property) ? !property.toLowerCase(Locale.ENGLISH).contains("miui") : !Build.BRAND.contains("Xiaomi")) {
            return false;
        }
        int requestCode = getRequestCode();
        Intent intent = new Intent();
        intent.setClassName("com.miui.securitycenter", "com.miui.permcenter.permissions.PermissionsEditorActivity");
        intent.putExtra("extra_pkgname", activity.getPackageName());
        try {
            activity.startActivityForResult(intent, requestCode);
            saveCallabckData(activity, str, request, requestCode);
            return true;
        } catch (ActivityNotFoundException unused) {
            intent.setComponent(null);
            intent.setClassName("com.miui.securitycenter", "com.miui.permcenter.permissions.AppPermissionsEditorActivity");
            try {
                activity.startActivityForResult(intent, requestCode);
                saveCallabckData(activity, str, request, requestCode);
                return true;
            } catch (ActivityNotFoundException unused2) {
                intent.setComponent(null);
                intent.setPackage("com.android.Setting");
                activity.startActivityForResult(intent, requestCode);
                saveCallabckData(activity, str, request, requestCode);
                return true;
            } catch (Exception e) {
                e.printStackTrace();
                return true;
            }
        } catch (Exception e2) {
            e2.printStackTrace();
            return true;
        }
    }

    public static void usePermission(Activity activity, String str, final Request request) {
        useSystemPermission(activity, convert2SystemPermission(str), new Request() {
            /* class io.dcloud.common.adapter.util.PermissionUtil.AnonymousClass2 */

            @Override // io.dcloud.common.adapter.util.PermissionUtil.Request
            public void onDenied(String str) {
                Request.this.onDenied(str);
            }

            @Override // io.dcloud.common.adapter.util.PermissionUtil.Request
            public void onGranted(String str) {
                Request.this.onGranted(str);
            }
        });
    }

    /* access modifiers changed from: package-private */
    public static class SafeCenter {
        private static ArrayList<Item> datas = new ArrayList<>();

        /* access modifiers changed from: package-private */
        public static class Item {
            String action;
            String clsName;
            String extParamName;
            String pname;

            Item(String str, String str2, String str3, String str4) {
                this.pname = str;
                this.clsName = str2;
                this.extParamName = str3;
                this.action = str4;
            }
        }

        SafeCenter() {
        }

        /* access modifiers changed from: private */
        public static void goSafeCenter(Activity activity) {
            init(activity);
            PackageManager packageManager = activity.getPackageManager();
            for (int i = 0; i < datas.size(); i++) {
                Intent intent = new Intent();
                Item item = datas.get(i);
                try {
                    if (packageManager.getPackageInfo(item.pname, 0) != null) {
                        if (!TextUtils.isEmpty(item.clsName)) {
                            intent.setClassName(item.pname, item.clsName);
                        } else if (!TextUtils.isEmpty(item.pname)) {
                            intent.setPackage(item.pname);
                        }
                        if (!TextUtils.isEmpty(item.action)) {
                            intent.setAction(item.action);
                        }
                        if (!TextUtils.isEmpty(item.extParamName)) {
                            intent.putExtra(item.extParamName, activity.getPackageName());
                        }
                        try {
                            intent.setFlags(268435456);
                            activity.startActivity(intent);
                            Logger.i("Permission", "successful " + Build.MODEL + "intent=" + intent);
                        } catch (ActivityNotFoundException e) {
                            Logger.e("Permission", "ActivityNotFoundException =" + e);
                            e.printStackTrace();
                        } catch (Exception e2) {
                            Logger.e("Permission", "Exception =" + e2);
                        }
                    }
                } catch (PackageManager.NameNotFoundException unused) {
                }
            }
        }

        static void init(Context context) {
            if (datas.isEmpty()) {
                try {
                    JSONArray jSONArray = new JSONArray(new String(IOUtil.toString(new FileInputStream(new File(context.getExternalFilesDir(Environment.DIRECTORY_DOWNLOADS) + "/temp.j")))));
                    for (int i = 0; i < jSONArray.length(); i++) {
                        JSONObject optJSONObject = jSONArray.optJSONObject(i);
                        String optString = optJSONObject.optString(ContextChain.TAG_PRODUCT);
                        if (!TextUtils.isEmpty(optString)) {
                            datas.add(new Item(optString, optJSONObject.optString(c.a), optJSONObject.optString("e"), optJSONObject.optString("a")));
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
                if (datas.isEmpty()) {
                    datas.add(new Item("com.miui.securitycenter", "com.miui.permcenter.permissions.PermissionsEditorActivity", "extra_pkgname", null));
                    datas.add(new Item("com.miui.securitycenter", "com.miui.permcenter.permissions.AppPermissionsEditorActivity", "extra_pkgname", null));
                    datas.add(new Item("com.meizu.safe", "com.meizu.safe.security.AppSecActivity", "packageName", null));
                    datas.add(new Item("com.aliyun.mobile.permission", "com.aliyun.mobile.permission.ExternalAppDetailActivity", "packageName", null));
                    datas.add(new Item("com.iqoo.secure", "com.iqoo.secure.MainActivity", "packageName", null));
                    datas.add(new Item("com.sonymobile.cta", "com.sonymobile.cta.SomcCTAMainActivity", "package", null));
                    datas.add(new Item("com.mediatek.security", "com.mediatek.security.ui.PermissionControlPageActivity", "package", null));
                    datas.add(new Item("com.yulong.android.launcher3", "com.yulong.android.launcher3.LauncherSettingsActivity", "package", null));
                    datas.add(new Item("com.android.settings", "com.android.settings.Settings$ManageApplicationsActivity", "package", null));
                    datas.add(new Item(null, null, "package", "android.settings.MANAGE_APPLICATIONS_SETTINGS"));
                }
            }
        }

        /* access modifiers changed from: private */
        public static boolean goSafeCenter(Activity activity, String str, Request request) {
            int requestCode = PermissionUtil.getRequestCode();
            if (PermissionUtil.PMS_LOCATION.equalsIgnoreCase(str)) {
                LocationManager locationManager = (LocationManager) activity.getSystemService("location");
                boolean isProviderEnabled = locationManager.isProviderEnabled("gps");
                boolean isProviderEnabled2 = locationManager.isProviderEnabled("network");
                if (!isProviderEnabled && !isProviderEnabled2) {
                    Intent intent = new Intent("android.settings.LOCATION_SOURCE_SETTINGS");
                    try {
                        activity.startActivity(intent);
                        PermissionUtil.saveCallabckData(activity, str, request, requestCode);
                        Logger.i("Permission", "successful " + Build.MODEL + "intent=" + intent);
                        return true;
                    } catch (ActivityNotFoundException e) {
                        Logger.e("Permission", "ActivityNotFoundException =" + e);
                        e.printStackTrace();
                    } catch (Exception e2) {
                        Logger.e("Permission", "Exception =" + e2);
                    }
                }
            }
            init(activity);
            PackageManager packageManager = activity.getPackageManager();
            int i = 0;
            int i2 = 0;
            while (i2 < datas.size()) {
                Intent intent2 = new Intent();
                Item item = datas.get(i2);
                try {
                    if (packageManager.getPackageInfo(item.pname, i) == null) {
                        continue;
                        i2++;
                        i = 0;
                    } else {
                        if (!TextUtils.isEmpty(item.clsName)) {
                            intent2.setClassName(item.pname, item.clsName);
                        } else if (!TextUtils.isEmpty(item.pname)) {
                            intent2.setPackage(item.pname);
                        }
                        if (!TextUtils.isEmpty(item.action)) {
                            intent2.setAction(item.action);
                        }
                        if (!TextUtils.isEmpty(item.extParamName)) {
                            intent2.putExtra(item.extParamName, activity.getPackageName());
                        }
                        try {
                            activity.startActivityForResult(intent2, requestCode);
                            PermissionUtil.saveCallabckData(activity, str, request, requestCode);
                            Logger.i("Permission", "successful " + Build.MODEL + "intent=" + intent2);
                            return true;
                        } catch (ActivityNotFoundException e3) {
                            Logger.e("Permission", "ActivityNotFoundException =" + e3);
                            e3.printStackTrace();
                        } catch (Exception e4) {
                            Logger.e("Permission", "Exception =" + e4);
                        }
                    }
                } catch (PackageManager.NameNotFoundException unused) {
                }
            }
            return true;
        }
    }
}
