package io.dcloud.common.adapter.util;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;

public class MessageHandler {
    private static Handler myHandler = new Handler(Looper.getMainLooper()) {
        /* class io.dcloud.common.adapter.util.MessageHandler.AnonymousClass1 */

        public void handleMessage(Message message) {
            try {
                Object[] objArr = (Object[]) message.obj;
                if (objArr[0] instanceof IMessages) {
                    ((IMessages) objArr[0]).execute(objArr[1]);
                }
            } catch (Exception e) {
                e.printStackTrace();
                Logger.e("MessageHandler.handleMessage e=" + e);
            }
        }
    };

    public interface IMessages {
        void execute(Object obj);
    }

    public interface UncheckedCallable {
        void run(WaitableRunnable waitableRunnable);
    }

    public static abstract class WaitableRunnable implements Runnable {
        private Exception mException;
        private String mTimeOutKey = "evalJSSync_time_out";
        private Object mValue;

        protected WaitableRunnable() {
        }

        /* JADX WARNING: Exception block dominator not found, dom blocks: [] */
        /* JADX WARNING: Missing exception handler attribute for start block: B:7:0x0011 */
        private void join() {
            synchronized (this) {
                wait(500);
                if (this.mValue == null) {
                    this.mValue = this.mTimeOutKey;
                }
            }
        }

        public void callBack(Object obj) {
            this.mValue = obj;
            synchronized (this) {
                notifyAll();
            }
        }

        public Object invoke(Handler handler) {
            if (handler.post(this)) {
                join();
                if (this.mException == null) {
                    return this.mValue;
                }
                throw new RuntimeException(this.mException);
            }
            throw new RuntimeException("Handler.post() returned false");
        }

        /* access modifiers changed from: protected */
        public abstract void onRun(WaitableRunnable waitableRunnable);

        public final void run() {
            try {
                onRun(this);
                this.mException = null;
            } catch (Exception e) {
                this.mValue = null;
                this.mException = e;
            }
        }
    }

    public static boolean hasCallbacks(Runnable runnable) {
        return myHandler.hasCallbacks(runnable);
    }

    public static void post(Runnable runnable) {
        myHandler.post(runnable);
    }

    public static Object postAndWait(final UncheckedCallable uncheckedCallable) {
        return new WaitableRunnable() {
            /* class io.dcloud.common.adapter.util.MessageHandler.AnonymousClass2 */

            /* access modifiers changed from: protected */
            @Override // io.dcloud.common.adapter.util.MessageHandler.WaitableRunnable
            public void onRun(WaitableRunnable waitableRunnable) {
                UncheckedCallable.this.run(waitableRunnable);
            }
        }.invoke(myHandler);
    }

    public static void postDelayed(Runnable runnable, long j) {
        myHandler.postDelayed(runnable, j);
    }

    public static void removeCallbacks(Runnable runnable) {
        myHandler.removeCallbacks(runnable);
    }

    public static void removeCallbacksAndMessages() {
    }

    public static void sendMessage(IMessages iMessages, Object obj) {
        Message obtain = Message.obtain();
        obtain.what = 0;
        obtain.obj = new Object[]{iMessages, obj};
        myHandler.sendMessage(obtain);
    }

    public static void sendMessage(IMessages iMessages, long j, Object obj) {
        Message obtain = Message.obtain();
        obtain.what = 0;
        obtain.obj = new Object[]{iMessages, obj};
        myHandler.sendMessageDelayed(obtain, j);
    }
}
