package io.dcloud.common.adapter.ui.webview;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.net.http.SslError;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import android.view.KeyEvent;
import android.view.ViewGroup;
import android.webkit.CookieSyncManager;
import android.webkit.MimeTypeMap;
import android.webkit.SslErrorHandler;
import android.webkit.URLUtil;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.AbsoluteLayout;
import android.widget.ProgressBar;
import androidx.webkit.internal.AssetHelper;
import com.nostra13.dcloudimageloader.core.ImageLoaderL;
import com.nostra13.dcloudimageloader.core.download.BaseImageDownloader;
import com.taobao.weex.el.parse.Operators;
import io.dcloud.base.R;
import io.dcloud.common.DHInterface.IApp;
import io.dcloud.common.DHInterface.IDCloudWebviewClientListener;
import io.dcloud.common.DHInterface.IFrameView;
import io.dcloud.common.DHInterface.ISysEventListener;
import io.dcloud.common.DHInterface.ITitleNView;
import io.dcloud.common.adapter.io.DHFile;
import io.dcloud.common.adapter.ui.AdaFrameView;
import io.dcloud.common.adapter.ui.AdaWebview;
import io.dcloud.common.adapter.ui.ReceiveJSValue;
import io.dcloud.common.adapter.ui.WaitingView;
import io.dcloud.common.adapter.util.AndroidResources;
import io.dcloud.common.adapter.util.DCloudTrustManager;
import io.dcloud.common.adapter.util.DeviceInfo;
import io.dcloud.common.adapter.util.InvokeExecutorHelper;
import io.dcloud.common.adapter.util.Logger;
import io.dcloud.common.adapter.util.MessageHandler;
import io.dcloud.common.constant.AbsoluteConst;
import io.dcloud.common.constant.IntentConst;
import io.dcloud.common.util.BaseInfo;
import io.dcloud.common.util.DLGeolocation;
import io.dcloud.common.util.IOUtil;
import io.dcloud.common.util.ImageLoaderUtil;
import io.dcloud.common.util.Md5Utils;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.common.util.StringUtil;
import io.dcloud.common.util.TitleNViewUtil;
import io.src.dcloud.adapter.DCloudAdapterUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class WebLoadEvent extends WebViewClient {
    private static final String DIFFERENT_VERSION_JS = "window.plus && (plus.android.import=plus.android.importClass);";
    public static final String ENABLE = "enable";
    private static final String ERROR_TEMPLATE = "javascript:(function(){var b=document.createEvent('HTMLEvents');var a='%s';b.url='%s';b.href='%s';b.initEvent(a,false,true);console.error(a);document.dispatchEvent(b);})();";
    private static final String IF_LOAD_TEMPLATE = "(function(){/*console.log('eval js loading href=' + location.href);*/if(location.__page__load__over__){return 2}if(location.__plusready__||window.__html5plus__){return 1}return 0})();";
    private static final String IF_PLUSREADY_EVENT_TEMPLATE = "(function(){/*console.log('plusready event loading href=' + location.href);*/if(location.__page__load__over__){return 2}if(location.__plusready__||window.__html5plus__){if(!location.__plusready__event__){location.__plusready__event__=true;return 1}else{return 2}}return 0})();";
    private static final String IF_PLUSREADY_TEMPLATE = "(function(){/*console.log('all.js loading href=' + location.href);*/if(location.__page__load__over__){return 2}if(!location.__plusready__){location.__plusready__=true;return 1}else{return 2}return 0})();";
    private static final String IF_PRELOAD_TEMPLATE = "(function(){/*console.log( 'preload js loading href=' + location.href);*/if(location.__page__load__over__){return 2}var jsfile='%s';if(location.__plusready__||window.__html5plus__){location.__preload__=location.__preload__||[];if(location.__preload__.indexOf(jsfile)<0){location.__preload__.push(jsfile);return 1}else{return 2}}return 0})();";
    private static final int LOADABLE = 1;
    private static final int LOADED = 2;
    private static final int NOLOAD = 0;
    public static String PAGE_FINISHED_FLAG = "javascript:setTimeout(function(){location.__page__load__over__ = true;},2000);";
    public static final String PLUSREADY = "html5plus://ready";
    static final String TAG = "WebLoadEvent";
    static final int Timeout_Page_Finish = 6000;
    static final int Timeout_Plus_Inject = 3000;
    public static final String UNIAPP_READY = "uniapp://ready";
    String TYPE_CSS = "type_css";
    String TYPE_JS = "type_js";
    Runnable Timeout_Page_Finish_Runnable = null;
    Runnable Timeout_Plus_Inject_Runnable = null;
    boolean isInitAmapGEO = false;
    AdaWebview mAdaWebview = null;
    String mAppid = null;
    private boolean mClearCache = false;
    private String mLastPageUrl = "";
    private OnPageFinishedCallack mPageFinishedCallack = null;
    String mPlusJS = null;
    long mShowLoadingTime;
    private Runnable mTitleNViewProgressStop = null;
    ProgressBar mWaitingForWapPage = null;
    WaitingView mWap2AppBlockDialog = null;
    ISysEventListener mWap2AppBlockDialogSysEventListener = null;
    private IDCloudWebviewClientListener mdcloudwebviewclientlister = null;
    boolean needResponseRedirect = true;
    boolean printLog = true;

    /* access modifiers changed from: package-private */
    public class CatchFile {
        String mContentType = null;
        String mEncoding = null;
        boolean mExist = false;
        File mFile = null;

        CatchFile() {
        }
    }

    static class TitleNViewProgressStop implements Runnable {
        private WeakReference<AdaWebview> mAdaWebview;

        public TitleNViewProgressStop(AdaWebview adaWebview) {
            this.mAdaWebview = new WeakReference<>(adaWebview);
        }

        public void run() {
            WeakReference<AdaWebview> weakReference = this.mAdaWebview;
            if (weakReference != null && weakReference.get() != null && this.mAdaWebview.get().obtainFrameView() != null) {
                Object titleNView = TitleNViewUtil.getTitleNView(this.mAdaWebview.get().obtainFrameView().obtainWindowMgr(), this.mAdaWebview.get().obtainFrameView().obtainWebView(), this.mAdaWebview.get().obtainFrameView(), TitleNViewUtil.getTitleNViewId(this.mAdaWebview.get().obtainFrameView()));
                if (titleNView instanceof ITitleNView) {
                    TitleNViewUtil.stopProcess((ITitleNView) titleNView);
                }
            }
        }
    }

    public WebLoadEvent(AdaWebview adaWebview) {
        this.mAdaWebview = adaWebview;
        this.mAppid = adaWebview.obtainApp().obtainAppId();
        String obtainConfigProperty = adaWebview.obtainApp().obtainConfigProperty(IApp.ConfigProperty.CONFIG_RAM_CACHE_MODE);
        if (BaseInfo.isBase(adaWebview.getContext()) && !ENABLE.equalsIgnoreCase(obtainConfigProperty)) {
            this.mClearCache = true;
        }
        reset();
        this.isInitAmapGEO = DLGeolocation.checkGeo(adaWebview.getContext());
    }

    private boolean checkCssFile(String str) {
        return !TextUtils.isEmpty(str) && str.contains(".css");
    }

    private boolean checkJsFile(String str) {
        return !TextUtils.isEmpty(str) && str.contains(".js") && !str.contains(".jsp");
    }

    private WebResourceResponse checkWebResourceResponseRedirect(WebView webView, String str) {
        AdaWebview adaWebview;
        JSONObject obtainThridInfo;
        String str2;
        if (!this.needResponseRedirect) {
            return null;
        }
        try {
            if (!URLUtil.isNetworkUrl(str) || !BaseInfo.existsStreamEnv() || (adaWebview = this.mAdaWebview) == null || adaWebview.obtainFrameView().obtainApp() == null || (obtainThridInfo = this.mAdaWebview.obtainFrameView().obtainApp().obtainThridInfo(IApp.ConfigProperty.ThridInfo.URDJsonData)) == null) {
                return null;
            }
            JSONArray optJSONArray = obtainThridInfo.optJSONObject("data").optJSONArray(InvokeExecutorHelper.create("io.dcloud.appstream.rules.util.Tools").invoke("getTopDomainInHost", new URL(str).getHost()));
            if (optJSONArray == null) {
                return null;
            }
            int i = 0;
            boolean z = false;
            while (true) {
                if (i >= optJSONArray.length()) {
                    str2 = null;
                    break;
                }
                JSONObject optJSONObject = optJSONArray.optJSONObject(i);
                JSONArray optJSONArray2 = optJSONObject.optJSONArray("match");
                str2 = optJSONObject.optString("redirect");
                int i2 = 0;
                while (true) {
                    if (i2 >= optJSONArray2.length()) {
                        break;
                    } else if (Pattern.compile(optJSONArray2.optString(i)).matcher(str).matches()) {
                        z = true;
                        break;
                    } else {
                        i2++;
                    }
                }
                if (z) {
                    break;
                }
                i++;
            }
            return downloadResponse(webView, str2);
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private final void completeLoadJs(final WebView webView, final String str, final String str2, final String[] strArr, final String str3, final Object... objArr) {
        final SoftReference softReference = new SoftReference(this.mAdaWebview);
        this.mAdaWebview.executeScript(ReceiveJSValue.registerCallback((AdaWebview) softReference.get(), StringUtil.format(str3, objArr), new ReceiveJSValue.ReceiveJSValueCallback() {
            /* class io.dcloud.common.adapter.ui.webview.WebLoadEvent.AnonymousClass9 */

            @Override // io.dcloud.common.adapter.ui.ReceiveJSValue.ReceiveJSValueCallback
            public String callback(JSONArray jSONArray) {
                try {
                    int i = jSONArray.getInt(1);
                    if (i == 0 && !PdrUtil.isEquals(str2, "onPageFinished")) {
                        WebLoadEvent.this.completeLoadJs(webView, str, str2, strArr, str3, objArr);
                        return null;
                    } else if (1 != i) {
                        return null;
                    } else {
                        String[] strArr = strArr;
                        for (String str : strArr) {
                            if (softReference.get() != null) {
                                ((AdaWebview) softReference.get()).executeScript(str);
                            }
                        }
                        return null;
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        }));
    }

    private boolean directPageIsLaunchPage(IApp iApp) {
        return iApp != null && !TextUtils.isEmpty(iApp.getOriginalDirectPage()) && !iApp.obtainWebAppIntent().hasExtra(IntentConst.DIRECT_PAGE);
    }

    private WebResourceResponse downloadResponse(final WebView webView, final String str) {
        if (!URLUtil.isNetworkUrl(str)) {
            return null;
        }
        try {
            MessageHandler.sendMessage(new MessageHandler.IMessages() {
                /* class io.dcloud.common.adapter.ui.webview.WebLoadEvent.AnonymousClass1 */

                @Override // io.dcloud.common.adapter.util.MessageHandler.IMessages
                public void execute(Object obj) {
                    webView.stopLoading();
                    WebLoadEvent.this.needResponseRedirect = false;
                    webView.loadUrl(str);
                }
            }, null);
            return new WebResourceResponse(null, null, new ByteArrayInputStream("".getBytes()));
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /* JADX WARNING: Removed duplicated region for block: B:74:0x016b  */
    /* JADX WARNING: Removed duplicated region for block: B:77:0x01a0  */
    /* JADX WARNING: Removed duplicated region for block: B:82:0x01b1  */
    /* JADX WARNING: Removed duplicated region for block: B:83:0x01b7  */
    /* JADX WARNING: Removed duplicated region for block: B:85:0x01bb A[SYNTHETIC, Splitter:B:85:0x01bb] */
    private WebResourceResponse downloadResponseInjection(WebResourceResponse webResourceResponse, String str, String str2, String str3, String str4) {
        WebResourceResponse webResourceResponse2;
        byte[] bArr;
        WebResourceResponse webResourceResponse3;
        Exception e;
        String str5;
        String str6;
        long currentTimeMillis = System.currentTimeMillis();
        if (str4.equals(this.TYPE_JS)) {
            String preLoadJsString = this.mAdaWebview.getPreLoadJsString();
            AdaWebview adaWebview = this.mAdaWebview;
            ByteArrayInputStream byteArrayInputStream = null;
            if (!adaWebview.mForceAHeadJsFileLoaded && !TextUtils.isEmpty(adaWebview.mForceAHeadJsFile)) {
                try {
                    AdaWebview adaWebview2 = this.mAdaWebview;
                    InputStream encryptionInputStream = WebResUtil.getEncryptionInputStream(adaWebview2.mForceAHeadJsFile, adaWebview2.mFrameView.obtainApp());
                    if (encryptionInputStream != null) {
                        bArr = IOUtil.getBytes(encryptionInputStream);
                        if (!TextUtils.isEmpty(preLoadJsString) && bArr == null && TextUtils.isEmpty(this.mPlusJS)) {
                            return null;
                        }
                        if (!URLUtil.isNetworkUrl(str) && (this.mAdaWebview.mNeedInjection || this.isInitAmapGEO || bArr != null)) {
                            CatchFile urlFile = getUrlFile(str, str4);
                            if (urlFile != null) {
                                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                                if (bArr != null) {
                                    byteArrayOutputStream.write(bArr);
                                    this.mAdaWebview.mForceAHeadJsFileLoaded = true;
                                }
                                if (!TextUtils.isEmpty(this.mPlusJS) && this.mAdaWebview.mPlusrequire.equals("ahead")) {
                                    AdaWebview adaWebview3 = this.mAdaWebview;
                                    adaWebview3.mPlusInjectTag = str;
                                    adaWebview3.mPlusLoading = true;
                                    byteArrayOutputStream.write(this.mPlusJS.getBytes());
                                }
                                if (!TextUtils.isEmpty(preLoadJsString) && this.mAdaWebview.mPlusrequire.equals("ahead")) {
                                    Logger.i(TAG, "mPlusrequire=ahead;this=" + this);
                                    this.mAdaWebview.mPreloadJsLoading = true;
                                    byteArrayOutputStream.write(preLoadJsString.getBytes());
                                }
                                if (this.isInitAmapGEO && DLGeolocation.checkInjectGeo(this.mAdaWebview.mInjectGEO) && !this.mAdaWebview.mPlusrequire.equals("ahead")) {
                                    this.mAdaWebview.mInjectGeoLoaded = true;
                                    byteArrayOutputStream.write(DLGeolocation.getGEOJS().getBytes());
                                }
                                if (urlFile.mExist) {
                                    try {
                                        FileInputStream fileInputStream = new FileInputStream(urlFile.mFile);
                                        byte[] bArr2 = new byte[4096];
                                        while (true) {
                                            int read = fileInputStream.read(bArr2);
                                            if (read <= 0) {
                                                break;
                                            }
                                            byteArrayOutputStream.write(bArr2, 0, read);
                                        }
                                        fileInputStream.close();
                                    } catch (IOException e2) {
                                        e2.printStackTrace();
                                    }
                                }
                                str6 = !TextUtils.isEmpty(urlFile.mEncoding) ? urlFile.mEncoding : str3;
                                str5 = !TextUtils.isEmpty(urlFile.mContentType) ? urlFile.mContentType : str2;
                                ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                                if (this.mAdaWebview.mPlusrequire.equals("ahead")) {
                                    listenPlusInjectTimeout((WebView) this.mAdaWebview.getDCWebView().getWebView(), this.mAdaWebview.obtainFullUrl(), "inject_with_js");
                                }
                                byteArrayInputStream = byteArrayInputStream2;
                                webResourceResponse3 = byteArrayInputStream != null ? new WebResourceResponse(str5, str6, byteArrayInputStream) : webResourceResponse;
                                if (webResourceResponse3 != null) {
                                    try {
                                        this.mAdaWebview.mEncoding = str6;
                                        Logger.i(TAG, "提前注入JS成功耗时：" + (System.currentTimeMillis() - currentTimeMillis) + this.mAdaWebview.getOriginalUrl() + ";url=" + str);
                                    } catch (Exception e3) {
                                        e = e3;
                                    }
                                }
                                return webResourceResponse3;
                            }
                        } else if (!PLUSREADY.equals(str)) {
                            if (!TextUtils.isEmpty(this.mPlusJS)) {
                                Logger.i("PLUSREADY", this.mAdaWebview.getOriginalUrl() + ";url=" + str);
                                this.mAdaWebview.mPlusLoading = true;
                                byteArrayInputStream = new ByteArrayInputStream(this.mPlusJS.getBytes());
                            }
                        } else if (PdrUtil.isDeviceRootDir(str)) {
                            byteArrayInputStream = new FileInputStream(str);
                        }
                        str5 = str2;
                        str6 = str3;
                        if (byteArrayInputStream != null) {
                        }
                        if (webResourceResponse3 != null) {
                        }
                        return webResourceResponse3;
                    }
                } catch (IOException e4) {
                    Logger.e("Exception", e4.getMessage());
                }
            }
            bArr = null;
            if (!TextUtils.isEmpty(preLoadJsString)) {
            }
            try {
                if (!URLUtil.isNetworkUrl(str)) {
                }
                if (!PLUSREADY.equals(str)) {
                }
                str5 = str2;
                str6 = str3;
                if (byteArrayInputStream != null) {
                }
                if (webResourceResponse3 != null) {
                }
            } catch (Exception e5) {
                e = e5;
                webResourceResponse3 = webResourceResponse;
                e.printStackTrace();
                return webResourceResponse3;
            }
            return webResourceResponse3;
        }
        if (this.TYPE_CSS.equals(str4)) {
            String cssString = this.mAdaWebview.getCssString();
            if (!this.mAdaWebview.mIsAdvanceCss && !TextUtils.isEmpty(cssString)) {
                try {
                    ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
                    CatchFile urlFile2 = getUrlFile(str, str4);
                    if (urlFile2 != null) {
                        if (urlFile2.mExist) {
                            FileInputStream fileInputStream2 = new FileInputStream(urlFile2.mFile);
                            byte[] bArr3 = new byte[4096];
                            while (true) {
                                int read2 = fileInputStream2.read(bArr3);
                                if (read2 <= 0) {
                                    break;
                                }
                                byteArrayOutputStream2.write(bArr3, 0, read2);
                            }
                            fileInputStream2.close();
                        }
                        byteArrayOutputStream2.write(cssString.getBytes());
                    }
                    String str7 = !TextUtils.isEmpty(urlFile2.mEncoding) ? urlFile2.mEncoding : str3;
                    webResourceResponse2 = new WebResourceResponse("text/css", str7, new ByteArrayInputStream(byteArrayOutputStream2.toByteArray()));
                    try {
                        AdaWebview adaWebview4 = this.mAdaWebview;
                        adaWebview4.mIsAdvanceCss = true;
                        adaWebview4.mEncoding = str7;
                        Logger.i(TAG, "提前注入CSS成功耗时：" + (System.currentTimeMillis() - currentTimeMillis) + this.mAdaWebview.getOriginalUrl() + ";url=" + str);
                        return webResourceResponse2;
                    } catch (Exception unused) {
                    }
                } catch (Exception unused2) {
                    webResourceResponse2 = webResourceResponse;
                    this.mAdaWebview.mIsAdvanceCss = false;
                    return webResourceResponse2;
                }
            }
        }
        return webResourceResponse;
    }

    private String getCacheLocalFilePath(String str, String str2) {
        IApp obtainApp;
        AdaWebview adaWebview = this.mAdaWebview;
        if (adaWebview == null || (obtainApp = adaWebview.obtainApp()) == null) {
            return null;
        }
        if (this.TYPE_JS.equals(str2)) {
            return obtainApp.obtainAppTempPath() + "__plus__cache__/" + Md5Utils.md5(str) + ".js";
        }
        return obtainApp.obtainAppTempPath() + "__plus__cache__/" + Md5Utils.md5(str) + ".css";
    }

    public static String getMimeType(String str) {
        String fileExtensionFromUrl = MimeTypeMap.getFileExtensionFromUrl(str);
        String mimeTypeFromExtension = fileExtensionFromUrl != null ? MimeTypeMap.getSingleton().getMimeTypeFromExtension(fileExtensionFromUrl) : null;
        return TextUtils.isEmpty(mimeTypeFromExtension) ? AssetHelper.DEFAULT_MIME_TYPE : mimeTypeFromExtension;
    }

    private CatchFile getUrlFile(String str, String str2) throws Exception {
        String cacheLocalFilePath = getCacheLocalFilePath(str, str2);
        try {
            if (DHFile.isExist(cacheLocalFilePath)) {
                CatchFile catchFile = new CatchFile();
                File file = new File(cacheLocalFilePath);
                catchFile.mFile = file;
                catchFile.mExist = file.exists();
                return catchFile;
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
        try {
            URL url = new URL(str);
            HttpURLConnection httpURLConnection = (HttpURLConnection) url.openConnection();
            if (httpURLConnection instanceof HttpsURLConnection) {
                try {
                    SSLSocketFactory sSLSocketFactory = DCloudTrustManager.getSSLSocketFactory();
                    if (sSLSocketFactory != null) {
                        ((HttpsURLConnection) httpURLConnection).setSSLSocketFactory(sSLSocketFactory);
                    }
                    ((HttpsURLConnection) httpURLConnection).setHostnameVerifier(DCloudTrustManager.getHostnameVerifier(true));
                } catch (Exception e2) {
                    throw new RuntimeException(e2);
                }
            }
            httpURLConnection.setConnectTimeout(BaseImageDownloader.DEFAULT_HTTP_CONNECT_TIMEOUT);
            httpURLConnection.setReadTimeout(BaseImageDownloader.DEFAULT_HTTP_CONNECT_TIMEOUT);
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setDoInput(true);
            int responseCode = httpURLConnection.getResponseCode();
            String contentType = httpURLConnection.getContentType();
            if (!TextUtils.isEmpty(contentType) && (((str2.equals(this.TYPE_JS) && contentType.contains("javascript")) || (str2.equals(this.TYPE_CSS) && (contentType.contains("text/css") || url.getPath().endsWith(".css")))) && (responseCode == 200 || responseCode == 206))) {
                InputStream inputStream = httpURLConnection.getInputStream();
                boolean writeFile = DHFile.writeFile(inputStream, cacheLocalFilePath);
                IOUtil.close(inputStream);
                if (writeFile) {
                    CatchFile catchFile2 = new CatchFile();
                    File file2 = new File(cacheLocalFilePath);
                    catchFile2.mFile = file2;
                    catchFile2.mExist = file2.exists();
                    catchFile2.mEncoding = httpURLConnection.getContentEncoding();
                    catchFile2.mContentType = contentType;
                    return catchFile2;
                }
                File file3 = new File(cacheLocalFilePath);
                if (file3.exists()) {
                    file3.delete();
                }
            }
            return null;
        } catch (IOException e3) {
            e3.printStackTrace();
            return null;
        }
    }

    private WebResourceResponse handleDecode(String str, WebResourceResponse webResourceResponse) {
        InputStream encryptionInputStream;
        return (!TextUtils.isEmpty(str) && (encryptionInputStream = WebResUtil.getEncryptionInputStream(str, this.mAdaWebview.obtainApp())) != null) ? new WebResourceResponse(getMimeType(str), "UTF-8", encryptionInputStream) : webResourceResponse;
    }

    private void hideLoading() {
        this.mAdaWebview.obtainMainView().post(new Runnable() {
            /* class io.dcloud.common.adapter.ui.webview.WebLoadEvent.AnonymousClass12 */

            public void run() {
                if (WebLoadEvent.this.mAdaWebview != null) {
                    long currentTimeMillis = System.currentTimeMillis();
                    WebLoadEvent webLoadEvent = WebLoadEvent.this;
                    if (currentTimeMillis - webLoadEvent.mShowLoadingTime < 1000) {
                        webLoadEvent.mAdaWebview.getDCWebView().getWebView().postDelayed(this, currentTimeMillis - WebLoadEvent.this.mShowLoadingTime);
                        return;
                    }
                    AdaFrameView adaFrameView = webLoadEvent.mAdaWebview.mFrameView;
                    adaFrameView.dispatchFrameViewEvents(AbsoluteConst.EVENTS_HIDE_LOADING, adaFrameView);
                }
            }
        });
    }

    private void listenPlusInjectTimeout(final WebView webView, final String str, final String str2) {
        AdaWebview adaWebview = this.mAdaWebview;
        if (adaWebview != null || !adaWebview.mPlusrequire.equals("none")) {
            Runnable runnable = this.Timeout_Plus_Inject_Runnable;
            if (runnable != null) {
                MessageHandler.removeCallbacks(runnable);
            }
            AnonymousClass7 r0 = new Runnable() {
                /* class io.dcloud.common.adapter.ui.webview.WebLoadEvent.AnonymousClass7 */

                public void run() {
                    AdaWebview adaWebview = WebLoadEvent.this.mAdaWebview;
                    if (adaWebview != null && !adaWebview.isRealInject(str)) {
                        Logger.i("WebViewData", "listenPlusInjectTimeout url=" + str);
                        WebLoadEvent webLoadEvent = WebLoadEvent.this;
                        WebView webView = webView;
                        String str = str;
                        webLoadEvent.onLoadPlusJSContent(webView, str, "plus_inject_timeout_" + str2);
                        WebLoadEvent webLoadEvent2 = WebLoadEvent.this;
                        webLoadEvent2.mAdaWebview.mPreloadJsLoading = false;
                        webLoadEvent2.Timeout_Plus_Inject_Runnable = null;
                    }
                }
            };
            this.Timeout_Plus_Inject_Runnable = r0;
            MessageHandler.postDelayed(r0, 3000);
        }
    }

    private void loadAllJSContent(WebView webView, String str, String str2) {
        if (onLoadPlusJSContent(webView, str, str2)) {
            injectScript(webView, str, str2);
        }
    }

    private void onExecuteEvalJSStatck(WebView webView, String str, String str2) {
        String str3 = this.mAdaWebview.get_eval_js_stack();
        if (!PdrUtil.isEmpty(str3)) {
            completeLoadJs(webView, str, str2, new String[]{str3}, IF_LOAD_TEMPLATE, str);
        }
    }

    private void onLoadCssContent() {
        AdaWebview adaWebview = this.mAdaWebview;
        if (adaWebview.mIsAdvanceCss) {
            Logger.i(TAG, "已经提前注入CSS完成。不需要再注入了" + this.mAdaWebview.getOriginalUrl());
        } else if (adaWebview.loadCssFile()) {
            Logger.i(TAG, "提前注入CSS完成" + this.mAdaWebview.getOriginalUrl());
        }
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private boolean onLoadPlusJSContent(final WebView webView, final String str, final String str2) {
        if (this.mAdaWebview.mPlusrequire.equals("none")) {
            return false;
        }
        if (this.mAdaWebview.isRealInject(str)) {
            Logger.i(TAG, "all.js已经注入完成。不需要再注入了" + this.mAdaWebview.getOriginalUrl());
            return true;
        }
        Logger.i(TAG, "onLoadPlusJSContent all.js注入 " + this.mAdaWebview.getOriginalUrl() + ";tag=" + str2 + ";mAdaWebview.mPlusrequire=" + this.mAdaWebview.mPlusrequire);
        if (!this.mAdaWebview.mPlusrequire.equals("later") || !str2.equals("onPageFinished")) {
            AdaWebview adaWebview = this.mAdaWebview;
            adaWebview.mPlusInjectTag = str2;
            adaWebview.mPlusLoading = true;
            completeLoadJs(webView, str, str2, new String[]{this.mPlusJS, DIFFERENT_VERSION_JS}, IF_PLUSREADY_TEMPLATE, str);
        } else {
            webView.postDelayed(new Runnable() {
                /* class io.dcloud.common.adapter.ui.webview.WebLoadEvent.AnonymousClass6 */

                public void run() {
                    WebLoadEvent webLoadEvent = WebLoadEvent.this;
                    AdaWebview adaWebview = webLoadEvent.mAdaWebview;
                    if (adaWebview != null) {
                        String str = str2;
                        adaWebview.mPlusInjectTag = str;
                        adaWebview.mPlusLoading = true;
                        WebView webView = webView;
                        String str2 = str;
                        webLoadEvent.completeLoadJs(webView, str2, str, new String[]{webLoadEvent.mPlusJS, WebLoadEvent.DIFFERENT_VERSION_JS}, WebLoadEvent.IF_PLUSREADY_TEMPLATE, new Object[]{str2});
                    }
                }
            }, 2000);
        }
        return false;
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void onPlusreadyEvent(WebView webView, String str, String str2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(StringUtil.format(AbsoluteConst.EVENTS_DOCUMENT_EXECUTE_TEMPLATE, AbsoluteConst.EVENTS_PLUSREADY));
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(StringUtil.format(AbsoluteConst.EVENTS_IFRAME_DOUCMENT_EXECUTE_TEMPLATE, AbsoluteConst.EVENTS_PLUSREADY));
        completeLoadJs(webView, str, str2, new String[]{stringBuffer.toString(), stringBuffer2.toString(), "plus.webview.currentWebview().__needTouchEvent__()"}, IF_PLUSREADY_EVENT_TEMPLATE, str);
    }

    private void printOpenLog(WebView webView, String str) {
        IApp obtainApp;
        String url = webView.getUrl();
        if (BaseInfo.isBase(webView.getContext()) && !TextUtils.isEmpty(str) && !TextUtils.isEmpty(url) && (obtainApp = this.mAdaWebview.mFrameView.obtainApp()) != null && !str.startsWith(DeviceInfo.HTTP_PROTOCOL) && !url.startsWith(DeviceInfo.HTTP_PROTOCOL) && !str.startsWith(DeviceInfo.HTTPS_PROTOCOL) && !url.startsWith(DeviceInfo.HTTPS_PROTOCOL)) {
            Log.i(AbsoluteConst.HBUILDER_TAG, StringUtil.format(AbsoluteConst.OPENLOG, WebResUtil.getHBuilderPrintUrl(obtainApp.convert2RelPath(WebResUtil.getOriginalUrl(url))), WebResUtil.getHBuilderPrintUrl(obtainApp.convert2RelPath(WebResUtil.getOriginalUrl(str)))));
        }
    }

    private void printResourceLog(WebView webView, IApp iApp, String str, String str2) {
        if (!TextUtils.isEmpty(str2) && !TextUtils.isEmpty(str) && webView != null && iApp != null && BaseInfo.isBase(webView.getContext()) && !str.equalsIgnoreCase(str2) && !TextUtils.isEmpty(str2)) {
            if (this.mClearCache && !this.mLastPageUrl.equalsIgnoreCase(str)) {
                webView.clearCache(true);
            }
            this.mLastPageUrl = str;
            String originalUrl = WebResUtil.getOriginalUrl(str);
            if (!str2.startsWith(DeviceInfo.HTTP_PROTOCOL) && !str2.startsWith(DeviceInfo.HTTPS_PROTOCOL)) {
                Log.i(AbsoluteConst.HBUILDER_TAG, StringUtil.format(AbsoluteConst.RESOURCELOG, WebResUtil.getHBuilderPrintUrl(iApp.convert2RelPath(originalUrl)), WebResUtil.getHBuilderPrintUrl(iApp.convert2RelPath(WebResUtil.getOriginalUrl(str2)))));
            }
        }
    }

    private boolean shouldRuntimeHandle(String str) {
        return PdrUtil.isDeviceRootDir(str) || PdrUtil.isNetPath(str) || str.startsWith(DeviceInfo.FILE_PROTOCOL);
    }

    private void showLoading() {
        this.mAdaWebview.getDCWebView().getWebView().post(new Runnable() {
            /* class io.dcloud.common.adapter.ui.webview.WebLoadEvent.AnonymousClass11 */

            public void run() {
                AdaWebview adaWebview = WebLoadEvent.this.mAdaWebview;
                if (adaWebview != null) {
                    AdaFrameView adaFrameView = adaWebview.mFrameView;
                    adaFrameView.dispatchFrameViewEvents(AbsoluteConst.EVENTS_SHOW_LOADING, adaFrameView);
                }
            }
        });
        this.mShowLoadingTime = System.currentTimeMillis();
    }

    private void startTryLoadAllJSContent(WebView webView, String str, String str2) {
        loadAllJSContent(webView, str, str2);
    }

    public void closeWap2AppBlockDialog(boolean z) {
        WaitingView waitingView = this.mWap2AppBlockDialog;
        if (waitingView != null) {
            waitingView.close();
            this.mAdaWebview.obtainApp().unregisterSysEventListener(this.mWap2AppBlockDialogSysEventListener, ISysEventListener.SysEventType.onKeyUp);
            this.mWap2AppBlockDialog = null;
            this.mWap2AppBlockDialogSysEventListener = null;
            if (z) {
                AdaWebview adaWebview = this.mAdaWebview;
                adaWebview.loadUrl(adaWebview.mRecordLastUrl);
            }
        }
    }

    public void destroy() {
        this.mAdaWebview = null;
        this.mPlusJS = null;
        this.mTitleNViewProgressStop = null;
        this.mWap2AppBlockDialog = null;
        this.mWaitingForWapPage = null;
    }

    public void doUpdateVisitedHistory(WebView webView, String str, boolean z) {
        if (!PdrUtil.isEmpty(this.mdcloudwebviewclientlister)) {
            this.mdcloudwebviewclientlister.doUpdateVisitedHistory(webView, str, z);
        }
    }

    /* access modifiers changed from: package-private */
    public String getErrorPage() {
        String str = this.mAdaWebview.mFrameView.obtainFrameOptions().errorPage;
        if (URLUtil.isNetworkUrl(str)) {
            return str;
        }
        if (!TextUtils.isEmpty(str)) {
            IApp obtainApp = this.mAdaWebview.obtainApp();
            if ("none".equals(str)) {
                return str;
            }
            String convert2AbsFullPath = obtainApp.convert2AbsFullPath(this.mAdaWebview.obtainFullUrl(), str);
            File file = new File(convert2AbsFullPath);
            if (file.exists()) {
                return obtainApp.convert2WebviewFullPath(this.mAdaWebview.obtainFullUrl(), str);
            }
            if (BaseInfo.isWap2AppAppid(obtainApp.obtainAppId())) {
                String relPath = WebResUtil.getRelPath(PdrUtil.stripQuery(PdrUtil.stripAnchor(convert2AbsFullPath)), obtainApp);
                if (WebResUtil.isWap2appTemplateFile(obtainApp, relPath)) {
                    str = WebResUtil.handleWap2appTemplateFilePath(relPath);
                    file = new File(str);
                }
            }
            if (file.exists()) {
                return DeviceInfo.FILE_PROTOCOL + str;
            }
            String obtainConfigProperty = obtainApp.obtainConfigProperty("error");
            if (!"none".equals(obtainConfigProperty)) {
                return obtainApp.convert2WebviewFullPath(null, obtainConfigProperty);
            }
        } else {
            String obtainConfigProperty2 = this.mAdaWebview.obtainApp().obtainConfigProperty("error");
            if (!"none".equals(obtainConfigProperty2)) {
                return this.mAdaWebview.obtainApp().convert2WebviewFullPath(null, obtainConfigProperty2);
            }
        }
        return "none";
    }

    /* access modifiers changed from: package-private */
    public void injectScript(final WebView webView, final String str, final String str2) {
        if (!str2.equals("onPageFinished") || !this.mAdaWebview.mPlusrequire.equals("later")) {
            onPreloadJSContent(webView, str, str2);
            onPlusreadyEvent(webView, str, str2);
        } else {
            webView.postDelayed(new Runnable() {
                /* class io.dcloud.common.adapter.ui.webview.WebLoadEvent.AnonymousClass10 */

                public void run() {
                    WebLoadEvent webLoadEvent = WebLoadEvent.this;
                    if (webLoadEvent.mAdaWebview != null) {
                        webLoadEvent.onPreloadJSContent(webView, str, str2);
                        WebLoadEvent.this.onPlusreadyEvent(webView, str, str2);
                    }
                }
            }, 2000);
        }
        onLoadCssContent();
    }

    public void listenPageFinishTimeout(final WebView webView, final String str, final String str2) {
        AdaWebview adaWebview = this.mAdaWebview;
        if (!adaWebview.mLoaded || !adaWebview.isRealInject(str)) {
            Runnable runnable = this.Timeout_Page_Finish_Runnable;
            if (runnable != null) {
                MessageHandler.removeCallbacks(runnable);
            }
            AnonymousClass8 r0 = new Runnable() {
                /* class io.dcloud.common.adapter.ui.webview.WebLoadEvent.AnonymousClass8 */

                public void run() {
                    AdaWebview adaWebview = WebLoadEvent.this.mAdaWebview;
                    if (adaWebview != null && !adaWebview.mLoaded && adaWebview.isRealInject(str)) {
                        WebLoadEvent webLoadEvent = WebLoadEvent.this;
                        WebView webView = webView;
                        String str = str;
                        webLoadEvent.injectScript(webView, str, "page_finished_timeout_" + str2);
                        WebLoadEvent.this.Timeout_Page_Finish_Runnable = null;
                    }
                }
            };
            this.Timeout_Page_Finish_Runnable = r0;
            MessageHandler.postDelayed(r0, 6000);
            return;
        }
        injectScript(webView, str, str2);
    }

    public void onLoadResource(WebView webView, String str) {
        if (this.mAdaWebview != null) {
            if (this.printLog) {
                Logger.i(TAG, "onLoadResource url=" + str);
            }
            this.needResponseRedirect = true;
            printResourceLog(webView, this.mAdaWebview.mFrameView.obtainApp(), webView.getUrl(), str);
            IFrameView obtainFrameView = this.mAdaWebview.obtainFrameView();
            if (obtainFrameView.obtainStatus() != 3) {
                obtainFrameView.onLoading();
            }
            if (this.mAdaWebview.checkResourceLoading(str)) {
                AdaFrameView adaFrameView = this.mAdaWebview.mFrameView;
                adaFrameView.dispatchFrameViewEvents(AbsoluteConst.EVENTS_LISTEN_RESOURCE_LOADING, "{url:'" + str + "'}");
            }
            this.mAdaWebview.dispatchWebviewStateEvent(2, str);
            super.onLoadResource(webView, str);
        }
    }

    public void onPageFinished(WebView webView, String str) {
        boolean z;
        if (this.mAdaWebview != null) {
            Logger.d(TAG, "onPageFinished=" + str);
            if (PdrUtil.isEmpty(this.mAdaWebview.mFrameView.obtainApp())) {
                Logger.e(TAG, "mAdaWebview.mFrameView.obtainApp()===null");
            } else if (this.mAdaWebview.hadClearHistory(str)) {
                this.mAdaWebview.hasErrorPage = false;
            } else {
                if (this.mAdaWebview.hasErrorPage) {
                    String errorPage = getErrorPage();
                    if (PdrUtil.isEquals(str, errorPage) || ("data:text/html,chromewebdata".equals(str) && "none".equals(errorPage))) {
                        z = true;
                    } else {
                        return;
                    }
                } else {
                    z = false;
                }
                if (this.mAdaWebview.unReceiveTitle) {
                    Logger.i(TAG, "onPageFinished will exe titleUpdate =" + str);
                    AdaWebview adaWebview = this.mAdaWebview;
                    adaWebview.mFrameView.dispatchFrameViewEvents(AbsoluteConst.EVENTS_TITLE_UPDATE, adaWebview.getDCWebView().getTitle());
                    this.mAdaWebview.unReceiveTitle = false;
                }
                CookieSyncManager.getInstance().sync();
                Logger.i(TAG, "onPageFinished" + this.mAdaWebview.getOriginalUrl());
                this.mAdaWebview.dispatchWebviewStateEvent(1, str);
                this.mAdaWebview.loadForceAHeadJs();
                onLoadPlusJSContent(webView, str, "onPageFinished");
                if (this.mAdaWebview.isRealInject(str)) {
                    injectScript(webView, str, "onPageFinished");
                }
                AdaWebview adaWebview2 = this.mAdaWebview;
                adaWebview2.mFrameView.dispatchFrameViewEvents(AbsoluteConst.EVENTS_LOADED, adaWebview2);
                if (z) {
                    this.mAdaWebview.executeScript(StringUtil.format(ERROR_TEMPLATE, "error", this.mAdaWebview.getOriginalUrl(), this.mAdaWebview.errorPageUrl));
                    AdaWebview adaWebview3 = this.mAdaWebview;
                    adaWebview3.errorPageUrl = null;
                    adaWebview3.hasErrorPage = false;
                }
                AdaFrameView adaFrameView = this.mAdaWebview.mFrameView;
                if (adaFrameView.obtainStatus() != 3) {
                    adaFrameView.onPreShow(null);
                }
                AdaWebview adaWebview4 = this.mAdaWebview;
                if (!adaWebview4.mLoaded) {
                    adaWebview4.mLoaded = true;
                    adaWebview4.mPlusLoaded = true;
                }
                super.onPageFinished(webView, str);
                if (this.mAdaWebview.justClearOption && !str.startsWith("data:")) {
                    Logger.d(TAG, "onPageFinished mWebViewImpl.clearHistory url=" + str);
                    this.mAdaWebview.getDCWebView().clearHistory();
                    this.mAdaWebview.justClearOption = false;
                }
                this.mAdaWebview.getDCWebView().webReload(false);
                OnPageFinishedCallack onPageFinishedCallack = this.mPageFinishedCallack;
                if (onPageFinishedCallack != null) {
                    onPageFinishedCallack.onLoad();
                }
                if (this.mWaitingForWapPage != null) {
                    try {
                        ((ViewGroup) this.mAdaWebview.obtainFrameView().obtainMainView()).removeView(this.mWaitingForWapPage);
                        this.mWaitingForWapPage = null;
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.mAdaWebview.checkInjectSitemap();
                if (!PdrUtil.isEmpty(this.mdcloudwebviewclientlister)) {
                    this.mdcloudwebviewclientlister.onPageFinished(webView, str);
                }
            }
        }
    }

    public void onPageStarted(WebView webView, String str, Bitmap bitmap) {
        AdaWebview adaWebview = this.mAdaWebview;
        if (adaWebview != null) {
            if (adaWebview.hasErrorPage) {
                String errorPage = getErrorPage();
                if (!PdrUtil.isEquals(str, errorPage) && ((!"data:text/html,chromewebdata".equals(str) || !"none".equals(errorPage)) && (PdrUtil.isEmpty(this.mAdaWebview.errorPageUrl) || !this.mAdaWebview.errorPageUrl.equals(str)))) {
                    AdaWebview adaWebview2 = this.mAdaWebview;
                    adaWebview2.hasErrorPage = false;
                    adaWebview2.errorPageUrl = null;
                }
            }
            Logger.i(TAG, "onPageStarted url=" + str);
            this.mAdaWebview.onPageStarted();
            printOpenLog(webView, str);
            if (!this.mAdaWebview.hadClearHistory(str)) {
                if (this.mAdaWebview.mPlusrequire.equals("ahead")) {
                    listenPlusInjectTimeout(webView, str, "onPageStarted");
                }
                if (!str.startsWith("data:")) {
                    this.mAdaWebview.getDCWebView().setUrlStr(str);
                }
                this.mAdaWebview.resetPlusLoadSaveData();
                if (!PdrUtil.isEmpty(this.mAdaWebview.getDCWebView().getUrlStr())) {
                    AdaWebview adaWebview3 = this.mAdaWebview;
                    adaWebview3.mFrameView.dispatchFrameViewEvents(AbsoluteConst.EVENTS_WINDOW_CLOSE, adaWebview3);
                }
                this.mAdaWebview.dispatchWebviewStateEvent(0, str);
                AdaWebview adaWebview4 = this.mAdaWebview;
                AdaFrameView adaFrameView = adaWebview4.mFrameView;
                adaFrameView.dispatchFrameViewEvents("loading", adaWebview4);
                if (adaFrameView.obtainStatus() != 3) {
                    adaFrameView.onPreLoading();
                }
                super.onPageStarted(webView, str, bitmap);
                if (this.mAdaWebview.mFrameView.getFrameType() == 3) {
                    try {
                        if (this.mWaitingForWapPage == null) {
                            this.mWaitingForWapPage = new ProgressBar(this.mAdaWebview.getContext());
                            int i = AndroidResources.mResources.getDisplayMetrics().widthPixels;
                            int i2 = AndroidResources.mResources.getDisplayMetrics().heightPixels;
                            int parseInt = PdrUtil.parseInt("7%", i, -1);
                            ((ViewGroup) this.mAdaWebview.obtainFrameView().obtainMainView()).addView(this.mWaitingForWapPage, new AbsoluteLayout.LayoutParams(parseInt, parseInt, (i - parseInt) / 2, (i2 - parseInt) / 2));
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                Object titleNView = TitleNViewUtil.getTitleNView(this.mAdaWebview.obtainFrameView().obtainWindowMgr(), this.mAdaWebview.obtainFrameView().obtainWebView(), this.mAdaWebview.obtainFrameView(), TitleNViewUtil.getTitleNViewId(this.mAdaWebview.obtainFrameView()));
                if (titleNView instanceof ITitleNView) {
                    if (this.mTitleNViewProgressStop != null) {
                        TitleNViewUtil.stopProcess((ITitleNView) titleNView);
                        this.mAdaWebview.obtainWindowView().removeCallbacks(this.mTitleNViewProgressStop);
                        this.mTitleNViewProgressStop = null;
                    }
                    this.mTitleNViewProgressStop = new TitleNViewProgressStop(this.mAdaWebview);
                    TitleNViewUtil.startProcess((ITitleNView) titleNView);
                    this.mAdaWebview.obtainWindowView().postDelayed(this.mTitleNViewProgressStop, 6000);
                }
                if (!PdrUtil.isEmpty(this.mdcloudwebviewclientlister)) {
                    this.mdcloudwebviewclientlister.onPageStarted(webView, str, bitmap);
                }
            }
        }
    }

    public void onPreloadJSContent(WebView webView, String str, String str2) {
        if (this.mAdaWebview.obtainFrameView().obtainApp() == null || this.mAdaWebview.obtainFrameView().obtainApp().manifestBeParsed()) {
            AdaWebview adaWebview = this.mAdaWebview;
            if (adaWebview.mPreloadJsLoaded) {
                Logger.i(TAG, "mPreloadJs 已经提前注入JS完成。不需要再注入了" + this.mAdaWebview.getOriginalUrl());
                return;
            }
            String preLoadJsString = adaWebview.getPreLoadJsString();
            if (!PdrUtil.isEmpty(preLoadJsString)) {
                this.mAdaWebview.mPreloadJsLoading = true;
                Logger.i(TAG, " tag=" + str2 + ";url=" + str);
                completeLoadJs(webView, str, str2, new String[]{preLoadJsString}, IF_PRELOAD_TEMPLATE, this.mAdaWebview.mPreloadJsFile);
                this.mAdaWebview.mPreloadJsLoaded = true;
            }
        }
    }

    public void onReceivedError(WebView webView, int i, String str, final String str2) {
        if (this.mAdaWebview != null) {
            Logger.e(TAG, "onReceivedError description=" + str + ";failingUrl=" + str2 + ";errorCode=" + i);
            this.mAdaWebview.dispatchWebviewStateEvent(5, str);
            AdaWebview adaWebview = this.mAdaWebview;
            adaWebview.mFrameView.dispatchFrameViewEvents(AbsoluteConst.EVENTS_FAILED, adaWebview);
            AdaWebview adaWebview2 = this.mAdaWebview;
            adaWebview2.hasErrorPage = true;
            adaWebview2.errorPageUrl = str2;
            final IApp obtainApp = adaWebview2.mFrameView.obtainApp();
            if (obtainApp != null) {
                try {
                    if (!BaseInfo.isWap2AppAppid(obtainApp.obtainAppId()) || this.mAdaWebview.mFrameView.getFrameType() != 2 || TextUtils.equals("none", obtainApp.obtainConfigProperty("launchError"))) {
                        String errorPage = getErrorPage();
                        if (!"none".equals(errorPage)) {
                            Logger.e(TAG, "onReceivedError  load errorPage " + errorPage);
                            this.mAdaWebview.loadUrl(errorPage);
                        } else {
                            this.mAdaWebview.hasErrorPage = false;
                        }
                    } else {
                        Context context = this.mAdaWebview.getContext();
                        final AlertDialog create = new AlertDialog.Builder(context).create();
                        create.setTitle(R.string.dcloud_common_tips);
                        create.setCanceledOnTouchOutside(false);
                        create.setMessage(context.getString(R.string.dcloud_common_no_network_tips));
                        AnonymousClass3 r3 = new DialogInterface.OnClickListener() {
                            /* class io.dcloud.common.adapter.ui.webview.WebLoadEvent.AnonymousClass3 */

                            public void onClick(DialogInterface dialogInterface, int i) {
                                if (i == -2) {
                                    WebLoadEvent.this.mAdaWebview.getActivity().startActivity(new Intent("android.settings.SETTINGS"));
                                } else if (i == -3) {
                                    Logger.e(WebLoadEvent.TAG, "onReceivedError try again");
                                    DCloudAdapterUtil.getIActivityHandler(WebLoadEvent.this.mAdaWebview.getActivity());
                                    WebLoadEvent.this.mAdaWebview.loadUrl(str2);
                                } else if (i == -1) {
                                    Activity activity = WebLoadEvent.this.mAdaWebview.getActivity();
                                    DCloudAdapterUtil.getIActivityHandler(activity).updateParam("closewebapp", activity);
                                }
                                create.dismiss();
                            }
                        };
                        create.setOnKeyListener(new DialogInterface.OnKeyListener() {
                            /* class io.dcloud.common.adapter.ui.webview.WebLoadEvent.AnonymousClass4 */

                            public boolean onKey(DialogInterface dialogInterface, int i, KeyEvent keyEvent) {
                                if (i != 4) {
                                    return false;
                                }
                                create.dismiss();
                                Activity activity = WebLoadEvent.this.mAdaWebview.getActivity();
                                DCloudAdapterUtil.getIActivityHandler(activity).updateParam("closewebapp", activity);
                                return false;
                            }
                        });
                        create.setButton(-2, context.getString(R.string.dcloud_common_set_network), r3);
                        create.setButton(-3, context.getString(R.string.dcloud_common_retry), r3);
                        create.setButton(-1, context.getString(R.string.dcloud_common_exit), r3);
                        create.show();
                        obtainApp.registerSysEventListener(new ISysEventListener() {
                            /* class io.dcloud.common.adapter.ui.webview.WebLoadEvent.AnonymousClass5 */

                            @Override // io.dcloud.common.DHInterface.ISysEventListener
                            public boolean onExecute(ISysEventListener.SysEventType sysEventType, Object obj) {
                                AdaWebview adaWebview;
                                if (ISysEventListener.SysEventType.onResume != sysEventType || (adaWebview = WebLoadEvent.this.mAdaWebview) == null) {
                                    return false;
                                }
                                adaWebview.obtainMainView().postDelayed(new Runnable() {
                                    /* class io.dcloud.common.adapter.ui.webview.WebLoadEvent.AnonymousClass5.AnonymousClass1 */

                                    public void run() {
                                        Logger.e(WebLoadEvent.TAG, "onReceivedError 500ms retry after the onResume");
                                        DCloudAdapterUtil.getIActivityHandler(WebLoadEvent.this.mAdaWebview.getActivity());
                                        AnonymousClass5 r0 = AnonymousClass5.this;
                                        WebLoadEvent.this.mAdaWebview.loadUrl(str2);
                                    }
                                }, 500);
                                obtainApp.unregisterSysEventListener(this, sysEventType);
                                return false;
                            }
                        }, ISysEventListener.SysEventType.onResume);
                        Logger.e(TAG, "onReceivedError do clearHistory");
                        this.mAdaWebview.clearHistory();
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!PdrUtil.isEmpty(this.mdcloudwebviewclientlister)) {
                this.mdcloudwebviewclientlister.onReceivedError(webView, i, str, str2);
            }
        }
    }

    public void onReceivedSslError(WebView webView, final SslErrorHandler sslErrorHandler, final SslError sslError) {
        AdaWebview adaWebview = this.mAdaWebview;
        if (adaWebview != null && adaWebview.obtainApp() != null) {
            String obtainConfigProperty = this.mAdaWebview.obtainApp().obtainConfigProperty(IApp.ConfigProperty.CONFIG_UNTRUSTEDCA);
            Logger.i("onReceivedSslError", "onReceivedSslError++type====" + obtainConfigProperty);
            if (PdrUtil.isEquals(obtainConfigProperty, "refuse")) {
                sslErrorHandler.cancel();
            } else if (PdrUtil.isEquals(obtainConfigProperty, "warning")) {
                Context context = webView.getContext();
                final AlertDialog create = new AlertDialog.Builder(context).create();
                create.setIcon(17301601);
                create.setTitle(R.string.dcloud_common_safety_warning);
                create.setCanceledOnTouchOutside(false);
                String str = null;
                if (Build.VERSION.SDK_INT >= 14) {
                    str = sslError.getUrl();
                }
                String string = context.getString(R.string.dcloud_common_certificate_continue);
                if (!TextUtils.isEmpty(str)) {
                    string = str + "\n" + string;
                }
                create.setMessage(string);
                AnonymousClass2 r2 = new DialogInterface.OnClickListener() {
                    /* class io.dcloud.common.adapter.ui.webview.WebLoadEvent.AnonymousClass2 */

                    public void onClick(DialogInterface dialogInterface, int i) {
                        if (i == -2) {
                            create.cancel();
                            create.dismiss();
                        } else if (i == -3) {
                            sslError.getCertificate().getIssuedBy();
                        } else if (i == -1) {
                            WebViewFactory.setSslHandlerState(sslErrorHandler, 1);
                            create.dismiss();
                        }
                    }
                };
                create.setButton(-2, context.getResources().getString(17039360), r2);
                create.setButton(-1, context.getResources().getString(17039370), r2);
                create.show();
            } else {
                WebViewFactory.setSslHandlerState(sslErrorHandler, 1);
            }
            if (!PdrUtil.isEmpty(this.mdcloudwebviewclientlister)) {
                this.mdcloudwebviewclientlister.onReceivedSslError(webView, sslErrorHandler, sslError);
            }
        }
    }

    public void onUnhandledKeyEvent(WebView webView, KeyEvent keyEvent) {
        super.onUnhandledKeyEvent(webView, keyEvent);
        if (webView instanceof SysWebView) {
            SysWebView sysWebView = (SysWebView) webView;
            if (keyEvent.getAction() == 0) {
                sysWebView.doKeyDownAction(keyEvent.getKeyCode(), keyEvent);
            } else if (keyEvent.getAction() == 1) {
                sysWebView.doKeyUpAction(keyEvent.getKeyCode(), keyEvent);
            }
        }
    }

    public void onUpdatePlusData(WebView webView, String str, String str2) {
        AdaWebview adaWebview = this.mAdaWebview;
        adaWebview.executeScript(adaWebview.getScreenAndDisplayJson(adaWebview));
        onExecuteEvalJSStatck(webView, str, str2);
    }

    public void reset() {
        this.mPlusJS = "(function(){/*console.log('all.js loading href=' + location.href);*/if(location.__page__load__over__){return 2}if(!location.__plusready__){location.__plusready__=true;return 1}else{return 2}return 0})();\n" + this.mAdaWebview.mFrameView.obtainPrePlusreadyJs() + "\n" + DIFFERENT_VERSION_JS;
    }

    public void setDcloudwebviewclientListener(IDCloudWebviewClientListener iDCloudWebviewClientListener) {
        this.mdcloudwebviewclientlister = iDCloudWebviewClientListener;
    }

    public void setPageFinishedCallack(OnPageFinishedCallack onPageFinishedCallack) {
        this.mPageFinishedCallack = onPageFinishedCallack;
    }

    @Override // android.webkit.WebViewClient
    public WebResourceResponse shouldInterceptRequest(WebView webView, String str) {
        String str2;
        JSONObject jSONObject;
        String str3;
        File file;
        File file2;
        AdaWebview.OverrideResourceRequestItem overrideResourceRequestItem = null;
        if (this.mAdaWebview == null) {
            return null;
        }
        WebResourceResponse shouldInterceptRequest = super.shouldInterceptRequest(webView, str);
        WebResourceResponse shouldInterceptRequest2 = super.shouldInterceptRequest(webView, str);
        if (!PdrUtil.isEmpty(this.mdcloudwebviewclientlister)) {
            shouldInterceptRequest2 = this.mdcloudwebviewclientlister.shouldInterceptRequest(webView, str);
        }
        WebResourceResponse checkWebResourceResponseRedirect = checkWebResourceResponseRedirect(webView, str);
        if (checkWebResourceResponseRedirect != null) {
            return checkWebResourceResponseRedirect;
        }
        String str4 = "image/gif";
        if (!PdrUtil.isEmpty(str)) {
            if (str.startsWith("plusfile://")) {
                String replace = str.replace("plusfile://", "");
                if (replace.startsWith(BaseInfo.REL_PUBLIC_DOWNLOADS_DIR) || replace.startsWith(BaseInfo.REL_PRIVATE_DOC_DIR) || replace.startsWith(BaseInfo.REL_PUBLIC_DOCUMENTS_DIR)) {
                    String convert2WebviewFullPath = this.mAdaWebview.obtainApp().convert2WebviewFullPath(null, replace);
                    if (convert2WebviewFullPath.startsWith("file:///")) {
                        convert2WebviewFullPath = convert2WebviewFullPath.substring(7);
                    }
                    if (convert2WebviewFullPath.startsWith(DeviceInfo.FILE_PROTOCOL)) {
                        convert2WebviewFullPath = convert2WebviewFullPath.substring(6);
                    }
                    file2 = new File(convert2WebviewFullPath);
                } else {
                    file2 = new File(replace);
                }
                if (file2.exists()) {
                    try {
                        FileInputStream fileInputStream = new FileInputStream(file2);
                        String mimeType = PdrUtil.getMimeType(str);
                        if (str.contains(".jpg")) {
                            mimeType = "image/jpeg";
                        } else if (str.contains(".png")) {
                            mimeType = "image/png";
                        } else if (str.contains(".gif")) {
                            mimeType = str4;
                        }
                        return new WebResourceResponse(mimeType, null, fileInputStream);
                    } catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                }
            } else if (str.contains("h5pscript://")) {
                InputStream encryptionInputStream = WebResUtil.getEncryptionInputStream(str.substring(str.indexOf("h5pscript://") + 12), this.mAdaWebview.obtainApp());
                String mimeType2 = PdrUtil.getMimeType(str);
                if (encryptionInputStream != null) {
                    if (str.contains(".jpg")) {
                        str4 = "image/jpeg";
                    } else if (str.contains(".png")) {
                        str4 = "image/png";
                    } else if (!str.contains(".gif")) {
                        str4 = mimeType2;
                    }
                    return new WebResourceResponse(str4, null, encryptionInputStream);
                }
            } else if (str.startsWith("plus-confusion://")) {
                InputStream encryptionInputStream2 = WebResUtil.getEncryptionInputStream(this.mAdaWebview.obtainApp().convert2WebviewFullPath(this.mAdaWebview.obtainFullUrl(), str.substring(17)), this.mAdaWebview.obtainApp());
                String mimeType3 = PdrUtil.getMimeType(str);
                if (encryptionInputStream2 != null) {
                    return new WebResourceResponse(mimeType3, null, encryptionInputStream2);
                }
            }
        }
        if (ImageLoaderUtil.isDownload(str) && (file = ImageLoaderL.getInstance().getDiscCache().get(str)) != null && file.exists()) {
            String mimeType4 = PdrUtil.getMimeType(str);
            if (str.contains(".jpg")) {
                str4 = "image/jpeg";
            } else if (str.contains(".png")) {
                str4 = "image/png";
            } else if (!str.contains(".gif")) {
                str4 = mimeType4;
            }
            try {
                return new WebResourceResponse(str4, null, new FileInputStream(file));
            } catch (FileNotFoundException e2) {
                e2.printStackTrace();
            }
        }
        AdaWebview adaWebview = this.mAdaWebview;
        if (adaWebview != null) {
            overrideResourceRequestItem = adaWebview.checkResourceRequestUrl(str);
        }
        AdaWebview adaWebview2 = this.mAdaWebview;
        if (adaWebview2 == null) {
            return shouldInterceptRequest;
        }
        String str5 = adaWebview2.mEncoding;
        if (overrideResourceRequestItem != null) {
            str = overrideResourceRequestItem.redirect;
            str5 = overrideResourceRequestItem.encoding;
            str2 = overrideResourceRequestItem.mime;
        } else {
            str2 = "application/x-javascript";
        }
        try {
            Logger.i(TAG, "shouldInterceptRequest url=" + str + ";withJs=" + this.mAdaWebview.mInjectPlusWidthJs);
            shouldInterceptRequest = handleDecode(str, shouldInterceptRequest);
            if (shouldInterceptRequest == null) {
                if (this.mAdaWebview.mPlusrequire.equals("ahead") && this.mAdaWebview.hasPreLoadJsFile() && (((str3 = this.mAdaWebview.mInjectPlusWidthJs) == null || TextUtils.equals(str3, str)) && PdrUtil.isNetPath(str) && checkJsFile(str))) {
                    shouldInterceptRequest = downloadResponseInjection(shouldInterceptRequest, str, str2, str5, this.TYPE_JS);
                    if (shouldInterceptRequest != null) {
                        this.mAdaWebview.mInjectPlusWidthJs = str;
                    }
                } else if (!TextUtils.isEmpty(this.mAdaWebview.getCssString()) && !this.mAdaWebview.mIsAdvanceCss && PdrUtil.isNetPath(str) && checkCssFile(str)) {
                    str2 = "text/css";
                    shouldInterceptRequest = downloadResponseInjection(shouldInterceptRequest, str, str2, str5, this.TYPE_CSS);
                } else if (this.isInitAmapGEO) {
                    AdaWebview adaWebview3 = this.mAdaWebview;
                    if (!adaWebview3.mInjectGeoLoaded && DLGeolocation.checkInjectGeo(adaWebview3.mInjectGEO)) {
                        shouldInterceptRequest = downloadResponseInjection(shouldInterceptRequest, str, str2, str5, this.TYPE_JS);
                    }
                }
            }
            if (shouldInterceptRequest == null && !BaseInfo.isWap2AppAppid(this.mAppid) && PLUSREADY.equals(str) && !this.mAdaWebview.mPlusLoaded) {
                shouldInterceptRequest = downloadResponseInjection(shouldInterceptRequest, str, str2, str5, this.TYPE_JS);
            }
            if (shouldInterceptRequest == null) {
                BaseInfo.isUniAppAppid(this.mAdaWebview.obtainApp());
            }
            if (shouldInterceptRequest == null && overrideResourceRequestItem != null) {
                try {
                    shouldInterceptRequest = new WebResourceResponse(str2, str5, new FileInputStream(str));
                } catch (FileNotFoundException e3) {
                    e3.printStackTrace();
                }
            }
            if (shouldInterceptRequest != null && Build.VERSION.SDK_INT >= 21) {
                Map<String, String> responseHeaders = shouldInterceptRequest.getResponseHeaders();
                if (responseHeaders == null) {
                    responseHeaders = new HashMap<>();
                }
                responseHeaders.put("Access-Control-Allow-Credentials", AbsoluteConst.TRUE);
                responseHeaders.put("Access-Control-Allow-Methods", "GET, POST, OPTIONS");
                responseHeaders.put("Access-Control-Allow-Origin", "*");
                if (!(overrideResourceRequestItem == null || (jSONObject = overrideResourceRequestItem.headerJson) == null)) {
                    Iterator<String> keys = jSONObject.keys();
                    if (overrideResourceRequestItem.headerJson.length() > 0) {
                        while (keys.hasNext()) {
                            String next = keys.next();
                            responseHeaders.put(next, overrideResourceRequestItem.headerJson.opt(next).toString());
                        }
                    }
                }
                shouldInterceptRequest.setResponseHeaders(responseHeaders);
                return shouldInterceptRequest;
            }
        } catch (Exception e4) {
            e4.printStackTrace();
            Logger.e(this.mAppid + ";url=" + str);
        }
        return (PdrUtil.isEmpty(this.mdcloudwebviewclientlister) || PdrUtil.isEmpty(shouldInterceptRequest2)) ? shouldInterceptRequest : shouldInterceptRequest2;
    }

    public boolean shouldOverrideKeyEvent(WebView webView, KeyEvent keyEvent) {
        return false;
    }

    @Override // android.webkit.WebViewClient
    public boolean shouldOverrideUrlLoading(WebView webView, String str) {
        if (this.mAdaWebview == null) {
            return false;
        }
        Logger.e(TAG, "shouldOverrideUrlLoading url=" + str);
        AdaWebview adaWebview = this.mAdaWebview;
        adaWebview.mProgressIntValue = 0;
        adaWebview.mRecordLastUrl = str;
        if (adaWebview.checkOverrideUrl(str)) {
            Logger.e(TAG, "检测拦截回调shouldOverrideUrlLoading url=" + str);
            AdaFrameView adaFrameView = this.mAdaWebview.mFrameView;
            adaFrameView.dispatchFrameViewEvents(AbsoluteConst.EVENTS_OVERRIDE_URL_LOADING, "{url:'" + str + "'}");
            return true;
        }
        if (this.mAdaWebview.mFrameView.getFrameType() == 5 || (this.mAdaWebview.mFrameView.getFrameType() == 2 && directPageIsLaunchPage(this.mAdaWebview.obtainApp()))) {
            this.mAdaWebview.obtainApp().updateDirectPage(str);
        }
        if (!shouldRuntimeHandle(str) && this.mAdaWebview.mFrameView.getFrameType() != 6) {
            try {
                if (str.startsWith("sms:")) {
                    int indexOf = str.indexOf("sms:");
                    int indexOf2 = str.indexOf(Operators.CONDITION_IF_STRING);
                    if (indexOf2 == -1) {
                        this.mAdaWebview.getActivity().startActivity(new Intent("android.intent.action.VIEW", Uri.parse(str)));
                        return true;
                    }
                    String substring = str.substring(indexOf + 4, indexOf2);
                    String substring2 = str.substring(indexOf2 + 1);
                    Intent intent = new Intent("android.intent.action.VIEW", Uri.parse("sms:" + substring));
                    intent.putExtra("address", substring);
                    intent.putExtra("sms_body", substring2);
                    this.mAdaWebview.getActivity().startActivity(intent);
                } else if (str.startsWith("intent://")) {
                    Intent parseUri = Intent.parseUri(str, 1);
                    parseUri.addCategory("android.intent.category.BROWSABLE");
                    parseUri.setComponent(null);
                    if (Build.VERSION.SDK_INT >= 15) {
                        parseUri.setSelector(null);
                    }
                    if (this.mAdaWebview.getActivity().getPackageManager().queryIntentActivities(parseUri, 0).size() > 0) {
                        this.mAdaWebview.getActivity().startActivityIfNeeded(parseUri, -1);
                    }
                } else {
                    AdaWebview adaWebview2 = this.mAdaWebview;
                    if (!(adaWebview2 == null || adaWebview2.getActivity() == null || !this.mAdaWebview.obtainApp().checkSchemeWhite(str))) {
                        this.mAdaWebview.getActivity().startActivity(new Intent("android.intent.action.VIEW", Uri.parse(str)));
                    }
                }
            } catch (Exception unused) {
                Logger.e(TAG, "ActivityNotFoundException url=" + str);
            }
            return true;
        } else if (!PdrUtil.isEmpty(this.mdcloudwebviewclientlister)) {
            return this.mdcloudwebviewclientlister.shouldOverrideUrlLoading(webView, str);
        } else {
            return false;
        }
    }

    /* JADX WARNING: Removed duplicated region for block: B:37:0x008c  */
    /* JADX WARNING: Removed duplicated region for block: B:42:0x009b  */
    private WebResourceResponse downloadResponse(WebView webView, String str, String str2, WebResourceResponse webResourceResponse, File file, boolean z) {
        Throwable th;
        Exception e;
        if (!URLUtil.isNetworkUrl(str2) || file == null) {
            return webResourceResponse;
        }
        showLoading();
        HttpURLConnection httpURLConnection = null;
        try {
            HttpURLConnection httpURLConnection2 = (HttpURLConnection) new URL(str2).openConnection();
            try {
                httpURLConnection2.setConnectTimeout(BaseImageDownloader.DEFAULT_HTTP_CONNECT_TIMEOUT);
                httpURLConnection2.setReadTimeout(BaseImageDownloader.DEFAULT_HTTP_CONNECT_TIMEOUT);
                httpURLConnection2.setRequestMethod("GET");
                httpURLConnection2.setDoInput(true);
                int responseCode = httpURLConnection2.getResponseCode();
                if (responseCode != 200) {
                    if (responseCode != 206) {
                        if ((responseCode < 400 || responseCode >= 500) && z) {
                            downloadResponse(webView, str, str2, webResourceResponse, file, false);
                        } else {
                            hideLoading();
                        }
                        httpURLConnection2.disconnect();
                        hideLoading();
                        return handleDecode(str, webResourceResponse);
                    }
                }
                if (DHFile.writeFile(httpURLConnection2.getInputStream(), file.getAbsolutePath())) {
                    hideLoading();
                } else if (z) {
                    downloadResponse(webView, str, str2, webResourceResponse, file, false);
                } else {
                    hideLoading();
                }
                httpURLConnection2.disconnect();
                hideLoading();
            } catch (Exception e2) {
                e = e2;
                httpURLConnection = httpURLConnection2;
                try {
                    e.printStackTrace();
                    if (httpURLConnection != null) {
                        httpURLConnection.disconnect();
                    }
                    hideLoading();
                    return handleDecode(str, webResourceResponse);
                } catch (Throwable th2) {
                    th = th2;
                    if (httpURLConnection != null) {
                        httpURLConnection.disconnect();
                    }
                    hideLoading();
                    throw th;
                }
            } catch (Throwable th3) {
                th = th3;
                httpURLConnection = httpURLConnection2;
                if (httpURLConnection != null) {
                }
                hideLoading();
                throw th;
            }
        } catch (Exception e3) {
            e = e3;
            e.printStackTrace();
            if (httpURLConnection != null) {
            }
            hideLoading();
            return handleDecode(str, webResourceResponse);
        }
        return handleDecode(str, webResourceResponse);
    }
}
