package io.dcloud.common.adapter.ui.webview;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.ClipData;
import android.content.DialogInterface;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.ConsoleMessage;
import android.webkit.GeolocationPermissions;
import android.webkit.JsPromptResult;
import android.webkit.JsResult;
import android.webkit.PermissionRequest;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebStorage;
import android.webkit.WebView;
import android.widget.EditText;
import android.widget.FrameLayout;
import androidx.core.content.FileProvider;
import com.facebook.common.util.UriUtil;
import com.taobao.weex.el.parse.Operators;
import io.dcloud.common.DHInterface.AbsMgr;
import io.dcloud.common.DHInterface.IActivityDelegate;
import io.dcloud.common.DHInterface.IActivityHandler;
import io.dcloud.common.DHInterface.IApp;
import io.dcloud.common.DHInterface.IMgr;
import io.dcloud.common.DHInterface.ISysEventListener;
import io.dcloud.common.DHInterface.ITitleNView;
import io.dcloud.common.DHInterface.IWebview;
import io.dcloud.common.adapter.ui.AdaWebview;
import io.dcloud.common.adapter.ui.FileChooseDialog;
import io.dcloud.common.adapter.util.AndroidResources;
import io.dcloud.common.adapter.util.CanvasHelper;
import io.dcloud.common.adapter.util.DeviceInfo;
import io.dcloud.common.adapter.util.Logger;
import io.dcloud.common.adapter.util.PermissionUtil;
import io.dcloud.common.adapter.util.UEH;
import io.dcloud.common.constant.AbsoluteConst;
import io.dcloud.common.util.AppConsoleLogUtil;
import io.dcloud.common.util.AppRuntime;
import io.dcloud.common.util.BaseInfo;
import io.dcloud.common.util.ExifInterface;
import io.dcloud.common.util.JSONUtil;
import io.dcloud.common.util.JSUtil;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.common.util.TitleNViewUtil;
import io.src.dcloud.adapter.DCloudAdapterUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class WebJsEvent extends WebChromeClient {
    static final FrameLayout.LayoutParams COVER_SCREEN_GRAVITY_CENTER = new FrameLayout.LayoutParams(-1, -1, 17);
    public static final int FILECHOOSER_RESULTCODE = 1;
    static final String TAG = "webview";
    private int defaultSystemUI = 0;
    FileChooseDialog dialog;
    private boolean isNeedCloseScreenWakelock = false;
    AdaWebview mAdaWebview = null;
    View mCustomView;
    WebChromeClient.CustomViewCallback mCustomViewCallback;
    private int mDefaultScreemOrientation = -2;
    private boolean mDefaultTitleBarVisibility = false;
    private Bitmap mDefaultVideoPoster = null;
    DialogListener mListener = null;
    private boolean mScreemOrientationChanged = false;
    ValueCallback<Uri> mUploadMessage;
    ValueCallback<Uri[]> mUploadMessage21Level;
    private boolean rptJsErr = true;

    class DialogListener implements DialogInterface.OnClickListener {
        JsResult mResult = null;

        DialogListener() {
        }

        public void onClick(DialogInterface dialogInterface, int i) {
            this.mResult.cancel();
        }
    }

    public WebJsEvent(AdaWebview adaWebview) {
        this.mAdaWebview = adaWebview;
        adaWebview.mProgressIntValue = 0;
        this.rptJsErr = BaseInfo.getCmitInfo(BaseInfo.sLastRunApp).rptJse;
    }

    private void handleConsoleMessage(ConsoleMessage consoleMessage) {
        if (this.mAdaWebview != null) {
            String message = consoleMessage.message();
            if (!isFilterConsoleMessage(message)) {
                int lineNumber = consoleMessage.lineNumber();
                String sourceId = consoleMessage.sourceId();
                String name = consoleMessage.messageLevel().name();
                ConsoleMessage.MessageLevel messageLevel = consoleMessage.messageLevel();
                if (PdrUtil.isEmpty(sourceId)) {
                    AppConsoleLogUtil.DCLog(message, name);
                } else {
                    try {
                        sourceId = this.mAdaWebview.getDCWebView().convertRelPath(sourceId);
                    } catch (Exception unused) {
                    }
                    message = message + " at " + sourceId + ":" + lineNumber;
                    AppConsoleLogUtil.DCLog(message, name);
                }
                JSONObject createJSONObject = JSONUtil.createJSONObject(AppRuntime.getUniStatistics());
                boolean z = false;
                if (createJSONObject != null) {
                    String string = JSONUtil.getString(createJSONObject, "version");
                    boolean z2 = JSONUtil.getBoolean(createJSONObject, WebLoadEvent.ENABLE);
                    if (PdrUtil.isEquals(ExifInterface.GPS_MEASUREMENT_2D, string) && z2) {
                        z = true;
                    }
                }
                if (z && this.rptJsErr && messageLevel == ConsoleMessage.MessageLevel.ERROR && this.mAdaWebview.obtainApp() != null && !BaseInfo.isBase(this.mAdaWebview.getContext()) && this.mAdaWebview.obtainApp().isUniApp()) {
                    JSONObject jSONObject = this.mAdaWebview.mFrameView.obtainFrameOptions().mUniPageUrl;
                    String url = this.mAdaWebview.getDCWebView().getUrl();
                    if (jSONObject != null && jSONObject.has(AbsoluteConst.XML_PATH)) {
                        url = jSONObject.optString(AbsoluteConst.XML_PATH);
                        if (jSONObject.has("query")) {
                            String optString = jSONObject.optString("query");
                            if (!TextUtils.isEmpty(optString)) {
                                url = url + Operators.CONDITION_IF_STRING + optString;
                            }
                        }
                    }
                    UEH.commitUncatchException(this.mAdaWebview.getContext(), url, message, 2);
                }
            }
        }
    }

    private void handleMessage(JsPromptResult jsPromptResult, AdaWebview adaWebview, String str, String str2, String str3, boolean z) {
        jsPromptResult.confirm(this.mAdaWebview.execScript(str, str2, JSONUtil.createJSONArray(str3), z));
    }

    private void initUniLoadUrl() {
        if (!this.mAdaWebview.isDisposed() && this.mAdaWebview.obtainApp() != null && BaseInfo.isUniAppAppid(this.mAdaWebview.obtainApp())) {
            BaseInfo.isWeexUniJs(this.mAdaWebview.obtainApp());
        }
    }

    private boolean isCallbackId(String str) {
        return str != null && str.startsWith(IApp.ConfigProperty.CONFIG_PLUS);
    }

    private boolean isFilterConsoleMessage(String str) {
        return !PdrUtil.isEmpty(str) && (str.contains("viewport-fit") || str.contains("Ignored attempt to cancel a touchend event with cancelable=false"));
    }

    private boolean isUrlWhiteListed(String str) {
        return true;
    }

    private void openFileChooserLogic(ValueCallback<Uri> valueCallback, String str, String str2) {
        openFileChooserLogic(valueCallback, null, str, str2, null);
    }

    private void setStatusBarVisibility(Activity activity, boolean z) {
        if (z) {
            activity.getWindow().getDecorView().setSystemUiVisibility(this.defaultSystemUI);
            return;
        }
        this.defaultSystemUI = activity.getWindow().getDecorView().getSystemUiVisibility();
        activity.getWindow().getDecorView().setSystemUiVisibility(5894);
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void showOpenFileChooser(ValueCallback<Uri> valueCallback, ValueCallback<Uri[]> valueCallback2, String str, String str2, WebChromeClient.FileChooserParams fileChooserParams) {
        this.mUploadMessage = valueCallback;
        this.mUploadMessage21Level = valueCallback2;
        Intent intent = new Intent("android.intent.action.GET_CONTENT");
        intent.addCategory("android.intent.category.OPENABLE");
        if (!PdrUtil.isEmpty(str)) {
            intent.setType(str);
        } else {
            intent.setType("*/*");
        }
        if (Build.VERSION.SDK_INT >= 21 && fileChooserParams != null && fileChooserParams.getMode() == 1) {
            intent.putExtra("android.intent.extra.ALLOW_MULTIPLE", true);
        }
        this.dialog = new FileChooseDialog(this.mAdaWebview.getActivity(), this.mAdaWebview.getActivity(), intent);
        this.mAdaWebview.obtainFrameView().obtainApp().registerSysEventListener(new ISysEventListener() {
            /* class io.dcloud.common.adapter.ui.webview.WebJsEvent.AnonymousClass10 */

            private Uri getUri(Uri uri) {
                Cursor query = WebJsEvent.this.mAdaWebview.getContext().getContentResolver().query(uri, new String[]{"_data"}, null, null, null);
                if (query != null) {
                    if (Build.VERSION.SDK_INT < 29 && query.moveToFirst()) {
                        try {
                            int columnIndexOrThrow = query.getColumnIndexOrThrow("_data");
                            if (columnIndexOrThrow > -1) {
                                String string = query.getString(columnIndexOrThrow);
                                uri = Uri.parse(string);
                                if (PdrUtil.isEmpty(uri.getScheme())) {
                                    String str = string.startsWith("/") ? DeviceInfo.FILE_PROTOCOL : "file:///";
                                    uri = Uri.parse(str + string);
                                }
                            }
                        } catch (Exception unused) {
                        }
                    }
                    query.close();
                }
                return uri;
            }

            @Override // io.dcloud.common.DHInterface.ISysEventListener
            public boolean onExecute(ISysEventListener.SysEventType sysEventType, Object obj) {
                List<File> list;
                Object[] objArr = (Object[]) obj;
                int intValue = ((Integer) objArr[0]).intValue();
                int intValue2 = ((Integer) objArr[1]).intValue();
                FileChooseDialog fileChooseDialog = WebJsEvent.this.dialog;
                if (fileChooseDialog != null) {
                    fileChooseDialog.dismiss();
                }
                IApp obtainApp = WebJsEvent.this.mAdaWebview.obtainFrameView().obtainApp();
                ISysEventListener.SysEventType sysEventType2 = ISysEventListener.SysEventType.onActivityResult;
                obtainApp.unregisterSysEventListener(this, sysEventType2);
                Uri uri = null;
                if (intValue2 == 0 || sysEventType != sysEventType2) {
                    WebJsEvent webJsEvent = WebJsEvent.this;
                    ValueCallback<Uri[]> valueCallback = webJsEvent.mUploadMessage21Level;
                    if (valueCallback != null) {
                        valueCallback.onReceiveValue(null);
                    } else {
                        ValueCallback<Uri> valueCallback2 = webJsEvent.mUploadMessage;
                        if (valueCallback2 != null) {
                            valueCallback2.onReceiveValue(null);
                        }
                    }
                    return false;
                }
                Intent intent = (Intent) objArr[2];
                ArrayList arrayList = new ArrayList();
                if (intValue == 1) {
                    if (intent.getClipData() != null) {
                        ClipData clipData = intent.getClipData();
                        for (int i = 0; i < clipData.getItemCount(); i++) {
                            Uri uri2 = clipData.getItemAt(i).getUri();
                            if (uri2 != null && UriUtil.LOCAL_CONTENT_SCHEME.equals(uri2.getScheme())) {
                                arrayList.add(getUri(uri2));
                            }
                        }
                    } else {
                        Uri data = intent.getData();
                        if (data != null && UriUtil.LOCAL_CONTENT_SCHEME.equals(data.getScheme())) {
                            data = getUri(data);
                        }
                        arrayList.add(data);
                        Logger.i(WebJsEvent.TAG, "openFileChooserLogic  OnActivityResult url=" + data);
                    }
                } else if (intValue == 2 && (list = WebJsEvent.this.dialog.uris) != null) {
                    Iterator<File> it = list.iterator();
                    while (true) {
                        if (!it.hasNext()) {
                            break;
                        }
                        File next = it.next();
                        if (next.exists()) {
                            Activity activity = WebJsEvent.this.mAdaWebview.getActivity();
                            arrayList.add(FileProvider.getUriForFile(activity, WebJsEvent.this.mAdaWebview.getActivity().getPackageName() + ".dc.fileprovider", next));
                            break;
                        }
                    }
                }
                Uri[] uriArr = arrayList.size() > 0 ? (Uri[]) arrayList.toArray(new Uri[arrayList.size()]) : null;
                WebJsEvent webJsEvent2 = WebJsEvent.this;
                ValueCallback<Uri[]> valueCallback3 = webJsEvent2.mUploadMessage21Level;
                if (valueCallback3 != null) {
                    valueCallback3.onReceiveValue(uriArr);
                } else {
                    ValueCallback<Uri> valueCallback4 = webJsEvent2.mUploadMessage;
                    if (valueCallback4 != null) {
                        if (!arrayList.isEmpty()) {
                            uri = (Uri) arrayList.get(0);
                        }
                        valueCallback4.onReceiveValue(uri);
                    }
                }
                return true;
            }
        }, ISysEventListener.SysEventType.onActivityResult);
        try {
            this.dialog.show();
            this.dialog.setOnCancelListener(new DialogInterface.OnCancelListener() {
                /* class io.dcloud.common.adapter.ui.webview.WebJsEvent.AnonymousClass11 */

                public void onCancel(DialogInterface dialogInterface) {
                    try {
                        WebJsEvent webJsEvent = WebJsEvent.this;
                        ValueCallback<Uri[]> valueCallback = webJsEvent.mUploadMessage21Level;
                        if (valueCallback != null) {
                            valueCallback.onReceiveValue(null);
                            return;
                        }
                        ValueCallback<Uri> valueCallback2 = webJsEvent.mUploadMessage;
                        if (valueCallback2 != null) {
                            valueCallback2.onReceiveValue(null);
                        }
                    } catch (Exception unused) {
                    }
                }
            });
        } catch (Exception unused) {
            Logger.e("openFileChooserLogic Exception");
        }
    }

    /* JADX WARNING: Removed duplicated region for block: B:16:0x003c A[Catch:{ JSONException -> 0x00f2 }] */
    /* JADX WARNING: Removed duplicated region for block: B:19:0x004e A[Catch:{ JSONException -> 0x00f2 }] */
    private void updateTitleNViewTitle(String str) {
        String optString;
        String optString2;
        Object obj;
        JSONObject jSONObject = this.mAdaWebview.mFrameView.obtainFrameOptions().titleNView;
        if (jSONObject != null) {
            Object obj2 = null;
            try {
                if (jSONObject.has("titleText")) {
                    obj = jSONObject.get("titleText");
                } else {
                    if (jSONObject.has("titletext")) {
                        obj = jSONObject.get("titletext");
                    }
                    if (obj2 != null || !(obj2 instanceof String)) {
                        optString = jSONObject.optString("titleColor");
                        if (TextUtils.isEmpty(optString)) {
                            optString = jSONObject.optString("titlecolor");
                        }
                        optString2 = jSONObject.optString("titleSize");
                        if (TextUtils.isEmpty(optString2)) {
                            optString2 = jSONObject.optString("titlesize");
                        }
                        String optString3 = jSONObject.optString("titleOverflow");
                        String optString4 = jSONObject.optString("titleAlign");
                        String optString5 = jSONObject.optString("titleIcon");
                        String optString6 = jSONObject.optString("titleIconRadius");
                        String optString7 = jSONObject.optString("subtitleText");
                        String optString8 = jSONObject.optString("subtitleColor");
                        String optString9 = jSONObject.optString("subtitleSize");
                        String optString10 = jSONObject.optString("subtitleOverflow");
                        String optString11 = jSONObject.optString("titleIconWidth");
                        if (!TextUtils.isEmpty(str) && !TextUtils.isEmpty(optString) && !TextUtils.isEmpty(optString2)) {
                            AbsMgr obtainWindowMgr = this.mAdaWebview.mFrameView.obtainWindowMgr();
                            IWebview obtainWebView = this.mAdaWebview.mFrameView.obtainWebView();
                            AdaWebview adaWebview = this.mAdaWebview;
                            Object titleNView = TitleNViewUtil.getTitleNView(obtainWindowMgr, obtainWebView, adaWebview.mFrameView, TitleNViewUtil.getTitleNViewId(adaWebview.obtainFrameView()));
                            if (titleNView instanceof ITitleNView) {
                                ITitleNView iTitleNView = (ITitleNView) titleNView;
                                if ("transparent".equals(jSONObject.optString("type")) && !TextUtils.isEmpty(optString) && Color.alpha(iTitleNView.getTitleColor()) == 0) {
                                    optString = TitleNViewUtil.changeColorAlpha(optString, 0.0f);
                                }
                                TitleNViewUtil.drawTitle(this.mAdaWebview.mFrameView, iTitleNView, str, optString, optString2, optString3, optString4, optString5, optString6, optString7, optString8, optString9, optString10, optString11);
                                return;
                            }
                            return;
                        }
                        return;
                    }
                    return;
                }
                obj2 = obj;
                if (obj2 != null) {
                }
                optString = jSONObject.optString("titleColor");
                if (TextUtils.isEmpty(optString)) {
                }
                optString2 = jSONObject.optString("titleSize");
                if (TextUtils.isEmpty(optString2)) {
                }
                String optString32 = jSONObject.optString("titleOverflow");
                String optString42 = jSONObject.optString("titleAlign");
                String optString52 = jSONObject.optString("titleIcon");
                String optString62 = jSONObject.optString("titleIconRadius");
                String optString72 = jSONObject.optString("subtitleText");
                String optString82 = jSONObject.optString("subtitleColor");
                String optString92 = jSONObject.optString("subtitleSize");
                String optString102 = jSONObject.optString("subtitleOverflow");
                String optString112 = jSONObject.optString("titleIconWidth");
                if (!TextUtils.isEmpty(str)) {
                }
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    public void destroy() {
        this.mAdaWebview = null;
    }

    public Bitmap getDefaultVideoPoster() {
        return super.getDefaultVideoPoster();
    }

    public void hideCustomView() {
        Log.d(TAG, "Hidding Custom View");
        if (this.mCustomView != null) {
            if (this.mAdaWebview.obtainMainView() != null) {
                this.mAdaWebview.obtainMainView().setVisibility(0);
            }
            this.mCustomView.setVisibility(8);
            ((ViewGroup) this.mCustomView.getParent()).removeView(this.mCustomView);
            Activity activity = null;
            this.mCustomView = null;
            this.mCustomViewCallback.onCustomViewHidden();
            if (this.mAdaWebview.obtainApp() != null) {
                activity = this.mAdaWebview.obtainApp().getActivity();
            }
            if (activity != null) {
                if (!(!this.isNeedCloseScreenWakelock || this.mAdaWebview.obtainFrameView() == null || this.mAdaWebview.obtainFrameView().obtainWindowMgr() == null)) {
                    this.mAdaWebview.obtainFrameView().obtainWindowMgr().processEvent(IMgr.MgrType.FeatureMgr, 1, new Object[]{this.mAdaWebview, "device", "setWakelock", new JSONArray().put(false)});
                }
                IApp obtainApp = this.mAdaWebview.obtainApp();
                if (!(obtainApp == null || obtainApp.obtainStatusBarMgr() == null)) {
                    if (!obtainApp.obtainStatusBarMgr().isFullScreenOrImmersive()) {
                        setStatusBarVisibility(activity, true);
                    } else if (!obtainApp.obtainStatusBarMgr().isFullScreen) {
                        setStatusBarVisibility(activity, true);
                    }
                    if (obtainApp.obtainStatusBarMgr().isImmersive) {
                        obtainApp.obtainStatusBarMgr().setImmersive(activity, true);
                    }
                }
                if (this.mScreemOrientationChanged) {
                    this.mScreemOrientationChanged = false;
                    AdaWebview.ScreemOrientationChangedNeedLayout = true;
                    activity.setRequestedOrientation(this.mDefaultScreemOrientation);
                }
                IActivityHandler iActivityHandler = DCloudAdapterUtil.getIActivityHandler(activity);
                if (iActivityHandler != null) {
                    iActivityHandler.setSideBarVisibility(0);
                }
            }
        }
    }

    public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
        handleConsoleMessage(consoleMessage);
        return true;
    }

    public void onExceededDatabaseQuota(String str, String str2, long j, long j2, long j3, WebStorage.QuotaUpdater quotaUpdater) {
        Logger.i(TAG, "onExceededDatabaseQuota url=" + str);
        quotaUpdater.updateQuota(j2 * 2);
    }

    public void onGeolocationPermissionsHidePrompt() {
        Logger.i(TAG, "onGeolocationPermissionsHidePrompt");
        super.onGeolocationPermissionsHidePrompt();
    }

    public void onGeolocationPermissionsShowPrompt(final String str, final GeolocationPermissions.Callback callback) {
        if (this.mAdaWebview != null) {
            Logger.i(TAG, "onGeolocationPermissionsShowPrompt origin=" + str);
            IApp obtainApp = this.mAdaWebview.obtainFrameView().obtainApp();
            if (obtainApp != null) {
                PermissionUtil.usePermission(this.mAdaWebview.getActivity(), "base", PermissionUtil.PMS_LOCATION, 2, new PermissionUtil.StreamPermissionRequest(obtainApp) {
                    /* class io.dcloud.common.adapter.ui.webview.WebJsEvent.AnonymousClass12 */

                    @Override // io.dcloud.common.adapter.util.PermissionUtil.Request
                    public void onDenied(String str) {
                        callback.invoke(str, false, false);
                    }

                    @Override // io.dcloud.common.adapter.util.PermissionUtil.Request
                    public void onGranted(String str) {
                        callback.invoke(str, true, false);
                    }
                });
            }
        }
    }

    public void onHideCustomView() {
        hideCustomView();
    }

    public boolean onJsAlert(WebView webView, String str, String str2, final JsResult jsResult) {
        AdaWebview adaWebview = this.mAdaWebview;
        if (adaWebview == null || PdrUtil.isEmpty(adaWebview.getAppName())) {
            return super.onJsAlert(webView, str, str2, jsResult);
        }
        final AlertDialog create = new AlertDialog.Builder(this.mAdaWebview.getActivity()).create();
        create.setTitle(this.mAdaWebview.getAppName());
        create.setMessage(str2);
        if (this.mListener == null) {
            this.mListener = new DialogListener();
        }
        this.mListener.mResult = jsResult;
        create.setButton(AndroidResources.getString(17039370), this.mListener);
        create.setCanceledOnTouchOutside(false);
        create.setOnKeyListener(new DialogInterface.OnKeyListener() {
            /* class io.dcloud.common.adapter.ui.webview.WebJsEvent.AnonymousClass4 */

            public boolean onKey(DialogInterface dialogInterface, int i, KeyEvent keyEvent) {
                if (keyEvent.getAction() != 1 || i != 4) {
                    return false;
                }
                jsResult.cancel();
                create.dismiss();
                return true;
            }
        });
        create.show();
        return true;
    }

    public boolean onJsBeforeUnload(WebView webView, String str, String str2, JsResult jsResult) {
        return super.onJsBeforeUnload(webView, str, str2, jsResult);
    }

    public boolean onJsConfirm(WebView webView, String str, String str2, final JsResult jsResult) {
        AdaWebview adaWebview = this.mAdaWebview;
        if (adaWebview == null || PdrUtil.isEmpty(adaWebview.getAppName())) {
            return super.onJsConfirm(webView, str, str2, jsResult);
        }
        try {
            final AlertDialog create = new AlertDialog.Builder(this.mAdaWebview.getActivity()).create();
            create.setMessage(str2);
            create.setTitle(this.mAdaWebview.getAppName());
            create.setButton(AndroidResources.getString(17039370), new DialogInterface.OnClickListener() {
                /* class io.dcloud.common.adapter.ui.webview.WebJsEvent.AnonymousClass5 */

                public void onClick(DialogInterface dialogInterface, int i) {
                    jsResult.confirm();
                }
            });
            create.setButton2(AndroidResources.getString(17039360), new DialogInterface.OnClickListener() {
                /* class io.dcloud.common.adapter.ui.webview.WebJsEvent.AnonymousClass6 */

                public void onClick(DialogInterface dialogInterface, int i) {
                    jsResult.cancel();
                }
            });
            create.setOnCancelListener(new DialogInterface.OnCancelListener() {
                /* class io.dcloud.common.adapter.ui.webview.WebJsEvent.AnonymousClass7 */

                public void onCancel(DialogInterface dialogInterface) {
                    jsResult.cancel();
                }
            });
            create.setOnKeyListener(new DialogInterface.OnKeyListener() {
                /* class io.dcloud.common.adapter.ui.webview.WebJsEvent.AnonymousClass8 */

                public boolean onKey(DialogInterface dialogInterface, int i, KeyEvent keyEvent) {
                    if (keyEvent.getAction() != 0 || i != 4) {
                        return false;
                    }
                    jsResult.cancel();
                    create.dismiss();
                    return true;
                }
            });
            create.show();
            return true;
        } catch (Exception e) {
            e.printStackTrace();
            return super.onJsConfirm(webView, str, str2, jsResult);
        }
    }

    public boolean onJsPrompt(WebView webView, String str, String str2, String str3, final JsPromptResult jsPromptResult) {
        CharSequence charSequence;
        JSONException e;
        String str4;
        CharSequence charSequence2;
        CharSequence charSequence3;
        int i;
        JSONException e2;
        if (this.mAdaWebview == null) {
            return false;
        }
        boolean isUrlWhiteListed = isUrlWhiteListed(str);
        if (isUrlWhiteListed && str3 != null && str3.length() > 3 && str3.substring(0, 4).equals("pdr:")) {
            try {
                JSONArray jSONArray = new JSONArray(str3.substring(4));
                String string = jSONArray.getString(0);
                String string2 = jSONArray.getString(1);
                boolean z = jSONArray.getBoolean(2);
                AdaWebview adaWebview = this.mAdaWebview;
                charSequence2 = "\\\"";
                charSequence3 = JSUtil.QUOTE;
                i = 4;
                str4 = "pdr:";
                try {
                    handleMessage(jsPromptResult, adaWebview, string, string2, str2, z);
                    return true;
                } catch (JSONException e3) {
                    e2 = e3;
                }
            } catch (JSONException e4) {
                e2 = e4;
                charSequence2 = "\\\"";
                charSequence3 = JSUtil.QUOTE;
                str4 = "pdr:";
                i = 4;
                if (!PdrUtil.isEquals(str3, str3.replace(charSequence2, charSequence3))) {
                    String replace = str2.replace(charSequence2, charSequence3);
                    String substring = replace.substring(1, replace.length() - 1);
                    String substring2 = str3.replace(charSequence2, charSequence3).substring(i);
                    onJsPrompt(webView, str, substring, str4 + substring2.substring(1, substring2.length() - 1), jsPromptResult);
                    return true;
                }
                e2.printStackTrace();
                Logger.e(TAG, "onJsPrompt js->native message=" + str2 + ";defaultValue=" + str3);
                return true;
            }
        } else if (this.mAdaWebview.mReceiveJSValue_android42 == null || !isUrlWhiteListed || str3 == null || str3.length() <= 5 || !str3.substring(0, 5).equals("sync:")) {
            final AlertDialog create = new AlertDialog.Builder(this.mAdaWebview.getActivity()).create();
            create.setMessage(str2);
            create.setTitle(this.mAdaWebview.getAppName());
            final EditText editText = new EditText(this.mAdaWebview.getActivity());
            if (str3 != null) {
                editText.setText(str3);
                editText.setSelection(0, str3.length());
                DeviceInfo.showIME(editText);
            }
            create.setView(editText);
            create.setButton(AndroidResources.getString(17039370), new DialogInterface.OnClickListener() {
                /* class io.dcloud.common.adapter.ui.webview.WebJsEvent.AnonymousClass1 */

                public void onClick(DialogInterface dialogInterface, int i) {
                    jsPromptResult.confirm(editText.getText().toString());
                }
            });
            create.setButton2(AndroidResources.getString(17039360), new DialogInterface.OnClickListener() {
                /* class io.dcloud.common.adapter.ui.webview.WebJsEvent.AnonymousClass2 */

                public void onClick(DialogInterface dialogInterface, int i) {
                    jsPromptResult.cancel();
                }
            });
            create.setOnKeyListener(new DialogInterface.OnKeyListener() {
                /* class io.dcloud.common.adapter.ui.webview.WebJsEvent.AnonymousClass3 */

                public boolean onKey(DialogInterface dialogInterface, int i, KeyEvent keyEvent) {
                    if (AndroidResources.sIMEAlive || keyEvent.getAction() != 0 || i != 4) {
                        return false;
                    }
                    create.dismiss();
                    jsPromptResult.cancel();
                    return true;
                }
            });
            create.show();
            return true;
        } else {
            try {
                JSONArray jSONArray2 = new JSONArray(str3.substring(5));
                String __js__call__native__ = this.mAdaWebview.mReceiveJSValue_android42.__js__call__native__(jSONArray2.getString(0), jSONArray2.getString(1));
                charSequence = JSUtil.QUOTE;
                try {
                    jsPromptResult.confirm(__js__call__native__);
                    return true;
                } catch (JSONException e5) {
                    e = e5;
                }
            } catch (JSONException e6) {
                e = e6;
                charSequence = JSUtil.QUOTE;
                if (!PdrUtil.isEquals(str3, str3.replace("\\\"", charSequence))) {
                    String replace2 = str2.replace("\\\"", charSequence);
                    String substring3 = replace2.substring(1, replace2.length() - 1);
                    String substring4 = str3.replace("\\\"", charSequence).substring(4);
                    onJsPrompt(webView, str, substring3, "pdr:" + substring4.substring(1, substring4.length() - 1), jsPromptResult);
                    return true;
                }
                e.printStackTrace();
                Logger.e(TAG, "onJsPrompt js->native message=" + str2 + ";defaultValue=" + str3);
                return true;
            }
        }
    }

    public void onPermissionRequest(PermissionRequest permissionRequest) {
        permissionRequest.grant(permissionRequest.getResources());
    }

    public void onProgressChanged(WebView webView, int i) {
        AdaWebview adaWebview = this.mAdaWebview;
        if (adaWebview != null) {
            if (i < 20 && !adaWebview.unReceiveTitle) {
                adaWebview.unReceiveTitle = true;
            }
            adaWebview.mProgressIntValue = i;
            adaWebview.dispatchWebviewStateEvent(3, Integer.valueOf(i));
            this.mAdaWebview.mFrameView.dispatchFrameViewEvents(AbsoluteConst.EVENTS_PROGRESS_CHANGED, Integer.valueOf(i));
            super.onProgressChanged(webView, i);
        }
    }

    public void onReachedMaxAppCacheSize(long j, long j2, WebStorage.QuotaUpdater quotaUpdater) {
        Logger.i(TAG, "onReachedMaxAppCacheSize");
        super.onReachedMaxAppCacheSize(j, j2, quotaUpdater);
    }

    public void onReceivedTitle(WebView webView, String str) {
        AdaWebview adaWebview = this.mAdaWebview;
        if (adaWebview != null) {
            adaWebview.unReceiveTitle = false;
            adaWebview.dispatchWebviewStateEvent(4, str);
            this.mAdaWebview.mFrameView.dispatchFrameViewEvents(AbsoluteConst.EVENTS_TITLE_UPDATE, str);
            this.mAdaWebview.getDCWebView().setPageTitle(str);
            Logger.i(TAG, "onReceivedTitle title=" + str);
            this.mAdaWebview.mLoadCompleted = true;
            updateTitleNViewTitle(str);
            initUniLoadUrl();
            super.onReceivedTitle(webView, str);
        }
    }

    public void onReceivedTouchIconUrl(WebView webView, String str, boolean z) {
        Logger.d("super.onReceivedTouchIconUrl(view, url, precomposed");
        super.onReceivedTouchIconUrl(webView, str, z);
    }

    public void onRequestFocus(WebView webView) {
        Logger.i(TAG, "onRequestFocus");
        super.onRequestFocus(webView);
    }

    public void onShowCustomView(View view, WebChromeClient.CustomViewCallback customViewCallback) {
        showCustomView(view, customViewCallback);
    }

    @Override // android.webkit.WebChromeClient
    public boolean onShowFileChooser(WebView webView, ValueCallback<Uri[]> valueCallback, WebChromeClient.FileChooserParams fileChooserParams) {
        openFileChooserLogic(null, valueCallback, fileChooserParams.getAcceptTypes() != null ? fileChooserParams.getAcceptTypes()[0] : null, "", fileChooserParams);
        return true;
    }

    public void openFileChooser(ValueCallback<Uri> valueCallback) {
        openFileChooserLogic(valueCallback, null, null);
    }

    public void releaseDefaultVideoPoster() {
        Bitmap bitmap = this.mDefaultVideoPoster;
        if (bitmap != null) {
            bitmap.recycle();
            this.mDefaultVideoPoster = null;
        }
    }

    public void showCustomView(View view, WebChromeClient.CustomViewCallback customViewCallback) {
        View view2;
        Log.d(TAG, "showing Custom View");
        if (this.mCustomView != null) {
            customViewCallback.onCustomViewHidden();
            return;
        }
        view.setBackgroundDrawable(CanvasHelper.getDrawable());
        if (DeviceInfo.sModel.equals("HUAWEI MT1-U06") || DeviceInfo.sModel.equals("SM-T310") || DeviceInfo.sModel.equals("vivo Y51A")) {
            this.mAdaWebview.obtainFrameView().obtainApp().registerSysEventListener(new ISysEventListener() {
                /* class io.dcloud.common.adapter.ui.webview.WebJsEvent.AnonymousClass13 */

                @Override // io.dcloud.common.DHInterface.ISysEventListener
                public boolean onExecute(ISysEventListener.SysEventType sysEventType, Object obj) {
                    ISysEventListener.SysEventType sysEventType2 = ISysEventListener.SysEventType.onKeyUp;
                    if (sysEventType != sysEventType2 || ((Integer) ((Object[]) obj)[0]).intValue() != 4) {
                        return false;
                    }
                    WebJsEvent.this.onHideCustomView();
                    WebJsEvent.this.mAdaWebview.obtainFrameView().obtainApp().unregisterSysEventListener(this, sysEventType2);
                    return true;
                }
            }, ISysEventListener.SysEventType.onKeyUp);
        }
        this.mCustomView = view;
        FrameLayout frameLayout = null;
        int i = 0;
        if (!(view instanceof ViewGroup) || ((ViewGroup) view).getChildCount() <= 0) {
            view2 = null;
        } else {
            view2 = ((ViewGroup) this.mCustomView).getChildAt(0);
            if (view2 instanceof ViewGroup) {
                ViewGroup viewGroup = (ViewGroup) view2;
                if (viewGroup.getChildCount() > 0) {
                    view2 = viewGroup.getChildAt(0);
                }
            }
        }
        if (view2 != null) {
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
            layoutParams.setMargins(0, 0, 0, 0);
            layoutParams.gravity = 17;
            view2.setPadding(0, 0, 0, 0);
            view2.setLayoutParams(layoutParams);
            view2.invalidate();
        }
        this.mCustomViewCallback = customViewCallback;
        Activity activity = this.mAdaWebview.obtainApp().getActivity();
        if (!(this.mAdaWebview.obtainFrameView() == null || this.mAdaWebview.obtainFrameView().obtainWindowMgr() == null)) {
            AbsMgr obtainWindowMgr = this.mAdaWebview.obtainFrameView().obtainWindowMgr();
            IMgr.MgrType mgrType = IMgr.MgrType.FeatureMgr;
            Object processEvent = obtainWindowMgr.processEvent(mgrType, 1, new Object[]{this.mAdaWebview, "device", "__isWakelockNative__", new JSONArray()});
            if (!(processEvent instanceof String ? Boolean.valueOf(String.valueOf(processEvent)).booleanValue() : false)) {
                this.isNeedCloseScreenWakelock = true;
                this.mAdaWebview.obtainFrameView().obtainWindowMgr().processEvent(mgrType, 1, new Object[]{this.mAdaWebview, "device", "setWakelock", new JSONArray().put(true)});
            }
        }
        if (activity != null) {
            IActivityHandler iActivityHandler = DCloudAdapterUtil.getIActivityHandler(activity);
            if (iActivityHandler != null) {
                frameLayout = iActivityHandler.obtainActivityContentView();
                iActivityHandler.closeSideBar();
                iActivityHandler.setSideBarVisibility(8);
            } else if (activity instanceof IActivityDelegate) {
                frameLayout = ((IActivityDelegate) activity).obtainActivityContentView();
            }
        }
        if (frameLayout != null) {
            frameLayout.addView(view, COVER_SCREEN_GRAVITY_CENTER);
            this.mAdaWebview.obtainMainView().setVisibility(8);
            setStatusBarVisibility(activity, false);
            String webviewProperty = this.mAdaWebview.getWebviewProperty(AbsoluteConst.JSON_KEY_VIDEO_FULL_SCREEN);
            if ("landscape".equals(webviewProperty)) {
                i = 6;
            } else if (!"landscape-primary".equals(webviewProperty)) {
                if ("landscape-secondary".equals(webviewProperty)) {
                    i = 8;
                } else if ("portrait-primary".equals(webviewProperty)) {
                    i = 1;
                } else if ("portrait-secondary".equals(webviewProperty)) {
                    i = 9;
                } else {
                    i = activity.getRequestedOrientation();
                }
            }
            if (activity.getRequestedOrientation() != i) {
                if (-2 == this.mDefaultScreemOrientation) {
                    this.mDefaultScreemOrientation = activity.getRequestedOrientation();
                }
                this.mScreemOrientationChanged = true;
                AdaWebview.ScreemOrientationChangedNeedLayout = true;
                activity.setRequestedOrientation(i);
            }
        }
    }

    private void openFileChooserLogic(final ValueCallback<Uri> valueCallback, final ValueCallback<Uri[]> valueCallback2, final String str, final String str2, final WebChromeClient.FileChooserParams fileChooserParams) {
        AdaWebview adaWebview = this.mAdaWebview;
        if (adaWebview != null) {
            PermissionUtil.usePermission(adaWebview.getActivity(), "base", PermissionUtil.PMS_STORAGE, 2, new PermissionUtil.Request() {
                /* class io.dcloud.common.adapter.ui.webview.WebJsEvent.AnonymousClass9 */

                @Override // io.dcloud.common.adapter.util.PermissionUtil.Request
                public void onDenied(String str) {
                }

                @Override // io.dcloud.common.adapter.util.PermissionUtil.Request
                public void onGranted(String str) {
                    WebJsEvent.this.showOpenFileChooser(valueCallback, valueCallback2, str, str2, fileChooserParams);
                }
            });
        }
    }

    public void openFileChooser(ValueCallback<Uri> valueCallback, String str) {
        openFileChooserLogic(valueCallback, str, null);
    }

    public void openFileChooser(ValueCallback<Uri> valueCallback, String str, String str2) {
        openFileChooserLogic(valueCallback, str, str2);
    }
}
