package io.dcloud.common.adapter.ui.fresh;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import io.dcloud.common.adapter.ui.fresh.ILoadingLayout;

public abstract class LoadingLayout extends FrameLayout implements ILoadingLayout {
    private View mContainer;
    private ILoadingLayout.State mCurState;
    private ILoadingLayout.State mPreState;

    /* access modifiers changed from: package-private */
    /* renamed from: io.dcloud.common.adapter.ui.fresh.LoadingLayout$1  reason: invalid class name */
    public static /* synthetic */ class AnonymousClass1 {
        static final /* synthetic */ int[] $SwitchMap$io$dcloud$common$adapter$ui$fresh$ILoadingLayout$State;

        /* JADX WARNING: Can't wrap try/catch for region: R(12:0|1|2|3|4|5|6|7|8|9|10|12) */
        /* JADX WARNING: Code restructure failed: missing block: B:13:?, code lost:
            return;
         */
        /* JADX WARNING: Failed to process nested try/catch */
        /* JADX WARNING: Missing exception handler attribute for start block: B:3:0x0012 */
        /* JADX WARNING: Missing exception handler attribute for start block: B:5:0x001d */
        /* JADX WARNING: Missing exception handler attribute for start block: B:7:0x0028 */
        /* JADX WARNING: Missing exception handler attribute for start block: B:9:0x0033 */
        static {
            int[] iArr = new int[ILoadingLayout.State.values().length];
            $SwitchMap$io$dcloud$common$adapter$ui$fresh$ILoadingLayout$State = iArr;
            iArr[ILoadingLayout.State.RESET.ordinal()] = 1;
            $SwitchMap$io$dcloud$common$adapter$ui$fresh$ILoadingLayout$State[ILoadingLayout.State.RELEASE_TO_REFRESH.ordinal()] = 2;
            $SwitchMap$io$dcloud$common$adapter$ui$fresh$ILoadingLayout$State[ILoadingLayout.State.PULL_TO_REFRESH.ordinal()] = 3;
            $SwitchMap$io$dcloud$common$adapter$ui$fresh$ILoadingLayout$State[ILoadingLayout.State.REFRESHING.ordinal()] = 4;
            $SwitchMap$io$dcloud$common$adapter$ui$fresh$ILoadingLayout$State[ILoadingLayout.State.NO_MORE_DATA.ordinal()] = 5;
        }
    }

    public LoadingLayout(Context context) {
        this(context, null);
    }

    /* access modifiers changed from: protected */
    public abstract View createLoadingView(Context context, AttributeSet attributeSet);

    @Override // io.dcloud.common.adapter.ui.fresh.ILoadingLayout
    public abstract int getContentSize();

    /* access modifiers changed from: protected */
    public ILoadingLayout.State getPreState() {
        return this.mPreState;
    }

    @Override // io.dcloud.common.adapter.ui.fresh.ILoadingLayout
    public ILoadingLayout.State getState() {
        return this.mCurState;
    }

    /* access modifiers changed from: protected */
    public void onNoMoreData() {
    }

    @Override // io.dcloud.common.adapter.ui.fresh.ILoadingLayout
    public void onPull(float f) {
    }

    /* access modifiers changed from: protected */
    public void onPullToRefresh() {
    }

    /* access modifiers changed from: protected */
    public void onRefreshing() {
    }

    /* access modifiers changed from: protected */
    public void onReleaseToRefresh() {
    }

    /* access modifiers changed from: protected */
    public void onReset() {
    }

    /* access modifiers changed from: protected */
    public void onStateChanged(ILoadingLayout.State state, ILoadingLayout.State state2) {
        int i = AnonymousClass1.$SwitchMap$io$dcloud$common$adapter$ui$fresh$ILoadingLayout$State[state.ordinal()];
        if (i == 1) {
            onReset();
        } else if (i == 2) {
            onReleaseToRefresh();
        } else if (i == 3) {
            onPullToRefresh();
        } else if (i == 4) {
            onRefreshing();
        } else if (i == 5) {
            onNoMoreData();
        }
    }

    public void setLastUpdatedLabel(CharSequence charSequence) {
    }

    public void setLoadingDrawable(Drawable drawable) {
    }

    public void setPullLabel(CharSequence charSequence) {
    }

    public void setRefreshingLabel(CharSequence charSequence) {
    }

    public void setReleaseLabel(CharSequence charSequence) {
    }

    @Override // io.dcloud.common.adapter.ui.fresh.ILoadingLayout
    public void setState(ILoadingLayout.State state) {
        ILoadingLayout.State state2 = this.mCurState;
        if (state2 != state) {
            this.mPreState = state2;
            this.mCurState = state;
            onStateChanged(state, state2);
        }
    }

    public void show(boolean z) {
        ViewGroup.LayoutParams layoutParams;
        int i = 0;
        if (z != (getVisibility() == 0) && (layoutParams = this.mContainer.getLayoutParams()) != null) {
            if (z) {
                layoutParams.height = -2;
            } else {
                layoutParams.height = 0;
            }
            if (!z) {
                i = 4;
            }
            setVisibility(i);
        }
    }

    public LoadingLayout(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public LoadingLayout(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
        ILoadingLayout.State state = ILoadingLayout.State.NONE;
        this.mCurState = state;
        this.mPreState = state;
    }
}
