package io.dcloud.common.adapter.ui;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.GridView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.TextView;
import androidx.core.content.FileProvider;
import io.dcloud.base.R;
import io.dcloud.common.adapter.util.DeviceInfo;
import io.dcloud.common.adapter.util.PermissionUtil;
import io.dcloud.common.util.PdrUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class FileChooseDialog extends Dialog {
    private Activity activity;
    private int onedp = PdrUtil.pxFromDp(1.0f, getContext().getApplicationContext().getResources().getDisplayMetrics());
    private int onesp = PdrUtil.pxFromSp(1.0f, getContext().getApplicationContext().getResources().getDisplayMetrics());
    public List<File> uris = new ArrayList();

    private class GridAdapter extends BaseAdapter {
        private Context context;
        private List<Item> items;

        private class ViewHolder {
            ImageView iv;

            /* renamed from: tv  reason: collision with root package name */
            TextView f2tv;

            private ViewHolder() {
            }
        }

        GridAdapter(Context context2, List<Item> list) {
            this.context = context2;
            this.items = list;
        }

        public int getCount() {
            return this.items.size();
        }

        public Object getItem(int i) {
            return this.items.get(i);
        }

        public long getItemId(int i) {
            return (long) i;
        }

        public View getView(int i, View view, ViewGroup viewGroup) {
            ViewHolder viewHolder;
            if (view == null) {
                view = FileChooseDialog.this.createView(this.context, this.items.get(i));
                viewHolder = new ViewHolder();
                ViewGroup viewGroup2 = (ViewGroup) view;
                viewHolder.iv = (ImageView) viewGroup2.getChildAt(0);
                viewHolder.f2tv = (TextView) viewGroup2.getChildAt(1);
                view.setTag(viewHolder);
            } else {
                viewHolder = (ViewHolder) view.getTag();
            }
            viewHolder.iv.setImageDrawable(this.items.get(i).icon);
            viewHolder.f2tv.setText(this.items.get(i).name);
            return view;
        }
    }

    /* access modifiers changed from: private */
    public class Item {
        Intent i;
        Drawable icon;
        String name;

        Item(String str, Drawable drawable, Intent intent) {
            this.name = str;
            this.icon = drawable;
            this.i = intent;
        }
    }

    /* JADX WARNING: Removed duplicated region for block: B:25:0x01d9 A[LOOP:1: B:23:0x01d3->B:25:0x01d9, LOOP_END] */
    public FileChooseDialog(Context context, Activity activity2, Intent intent) {
        super(context);
        String str;
        Intent intent2;
        GridView gridView;
        PackageManager packageManager;
        PackageManager packageManager2;
        requestWindowFeature(1);
        this.activity = activity2;
        LinearLayout linearLayout = new LinearLayout(context);
        linearLayout.setOrientation(1);
        TextView textView = new TextView(context);
        textView.setText(R.string.dcloud_choose_an_action);
        textView.setTextSize((float) (this.onesp * 5));
        textView.setTextColor(-16777216);
        textView.getPaint().setFakeBoldText(true);
        textView.setGravity(17);
        linearLayout.addView(textView, new LinearLayout.LayoutParams(-1, -2));
        GridView gridView2 = new GridView(context);
        gridView2.setHorizontalSpacing(this.onedp * 10);
        gridView2.setVerticalSpacing(this.onedp * 10);
        gridView2.setNumColumns(4);
        int i = this.onedp * 20;
        gridView2.setPadding(0, i, 0, i);
        linearLayout.addView(gridView2, new LinearLayout.LayoutParams(-1, -2));
        View view = new View(context);
        view.setBackgroundColor(-3355444);
        linearLayout.addView(view, new ViewGroup.LayoutParams(-1, this.onedp));
        Button button = new Button(context);
        button.setPadding(button.getPaddingLeft(), this.onedp * 15, button.getPaddingRight(), this.onedp * 15);
        button.setBackground(null);
        button.setText(17039360);
        button.setOnClickListener(new View.OnClickListener() {
            /* class io.dcloud.common.adapter.ui.FileChooseDialog.AnonymousClass1 */

            public void onClick(View view) {
                FileChooseDialog.this.cancel();
            }
        });
        button.setGravity(17);
        linearLayout.addView(button, new LinearLayout.LayoutParams(-1, -2));
        setContentView(linearLayout, new ViewGroup.LayoutParams(-1, -1));
        if (intent.getType().startsWith("video/")) {
            intent2 = new Intent("android.media.action.VIDEO_CAPTURE");
            str = ".mp4";
        } else {
            intent2 = new Intent("android.media.action.IMAGE_CAPTURE");
            str = ".jpg";
        }
        PackageManager packageManager3 = activity2.getPackageManager();
        ArrayList arrayList = new ArrayList();
        try {
            for (ResolveInfo resolveInfo : packageManager3.queryIntentActivities(intent2, 0)) {
                String charSequence = resolveInfo.loadLabel(packageManager3).toString();
                Drawable applicationIcon = packageManager3.getApplicationIcon(resolveInfo.activityInfo.applicationInfo);
                Intent intent3 = new Intent(intent2);
                String str2 = DeviceInfo.sDeviceRootDir + "/DCIM/captured_image/";
                StringBuilder sb = new StringBuilder();
                packageManager2 = packageManager3;
                gridView = gridView2;
                try {
                    sb.append(System.currentTimeMillis());
                    sb.append(str);
                    File file = new File(str2, sb.toString());
                    if (!file.getParentFile().exists()) {
                        file.getParentFile().mkdirs();
                    }
                    Uri uriForFile = FileProvider.getUriForFile(activity2, activity2.getPackageName() + ".dc.fileprovider", file);
                    this.uris.add(file);
                    intent3.putExtra("output", uriForFile);
                    ActivityInfo activityInfo = resolveInfo.activityInfo;
                    intent3.setClassName(activityInfo.packageName, activityInfo.name);
                    arrayList.add(new Item(charSequence, applicationIcon, intent3));
                    packageManager3 = packageManager2;
                    gridView2 = gridView;
                } catch (Exception unused) {
                    packageManager = packageManager2;
                    while (r4.hasNext()) {
                    }
                    gridView.setAdapter((ListAdapter) new GridAdapter(activity2, arrayList));
                }
            }
            gridView = gridView2;
            packageManager = packageManager3;
        } catch (Exception unused2) {
            packageManager2 = packageManager3;
            gridView = gridView2;
            packageManager = packageManager2;
            while (r4.hasNext()) {
            }
            gridView.setAdapter((ListAdapter) new GridAdapter(activity2, arrayList));
        }
        for (ResolveInfo resolveInfo2 : packageManager.queryIntentActivities(intent, 0)) {
            String charSequence2 = resolveInfo2.loadLabel(packageManager).toString();
            Drawable applicationIcon2 = packageManager.getApplicationIcon(resolveInfo2.activityInfo.applicationInfo);
            Intent intent4 = new Intent(intent);
            ActivityInfo activityInfo2 = resolveInfo2.activityInfo;
            intent4.setClassName(activityInfo2.packageName, activityInfo2.name);
            arrayList.add(new Item(charSequence2, applicationIcon2, intent4));
        }
        gridView.setAdapter((ListAdapter) new GridAdapter(activity2, arrayList));
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private View createView(Context context, final Item item) {
        LinearLayout linearLayout = new LinearLayout(context);
        linearLayout.setOrientation(1);
        linearLayout.setGravity(17);
        ImageView imageView = new ImageView(context);
        imageView.setImageDrawable(item.icon);
        imageView.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        int i = this.onedp * 50;
        linearLayout.addView(imageView, new LinearLayout.LayoutParams(i, i));
        TextView textView = new TextView(context);
        textView.setText(item.name);
        textView.setTextSize((float) (this.onesp * 4));
        textView.setGravity(17);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -2);
        layoutParams.topMargin = this.onedp * 10;
        linearLayout.addView(textView, layoutParams);
        linearLayout.setOnClickListener(new View.OnClickListener() {
            /* class io.dcloud.common.adapter.ui.FileChooseDialog.AnonymousClass2 */

            public void onClick(View view) {
                if (item.i.getAction() == null || (!item.i.getAction().equals("android.media.action.IMAGE_CAPTURE") && !item.i.getAction().equals("android.media.action.VIDEO_CAPTURE"))) {
                    FileChooseDialog.this.activity.startActivityForResult(item.i, 1);
                } else {
                    PermissionUtil.requestSystemPermissions(FileChooseDialog.this.activity, new String[]{"android.permission.CAMERA"}, PermissionUtil.getRequestCode(), new PermissionUtil.Request() {
                        /* class io.dcloud.common.adapter.ui.FileChooseDialog.AnonymousClass2.AnonymousClass1 */

                        @Override // io.dcloud.common.adapter.util.PermissionUtil.Request
                        public void onDenied(String str) {
                        }

                        @Override // io.dcloud.common.adapter.util.PermissionUtil.Request
                        public void onGranted(String str) {
                            FileChooseDialog.this.activity.startActivityForResult(item.i, 2);
                        }
                    });
                }
            }
        });
        return linearLayout;
    }

    public void show() {
        super.show();
        WindowManager.LayoutParams attributes = getWindow().getAttributes();
        attributes.gravity = 80;
        attributes.width = -1;
        attributes.height = -2;
        View decorView = getWindow().getDecorView();
        int i = this.onedp;
        decorView.setPadding(0, i * 20, 0, i * 10);
        getWindow().getDecorView().setBackgroundColor(-1);
        getWindow().setAttributes(attributes);
    }
}
