package io.dcloud.common.adapter.ui;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.webkit.CookieManager;
import android.webkit.WebView;
import com.taobao.weex.common.WXConfig;
import com.taobao.weex.el.parse.Operators;
import com.taobao.weex.utils.tools.TimeCalculator;
import dc.squareup.cookie.CookieCenter;
import io.dcloud.common.DHInterface.AbsMgr;
import io.dcloud.common.DHInterface.IApp;
import io.dcloud.common.DHInterface.IFeature;
import io.dcloud.common.DHInterface.IFrameView;
import io.dcloud.common.DHInterface.IJsInterface;
import io.dcloud.common.DHInterface.IMgr;
import io.dcloud.common.DHInterface.IUniNView;
import io.dcloud.common.DHInterface.IWebview;
import io.dcloud.common.adapter.ui.ReceiveJSValue;
import io.dcloud.common.adapter.ui.webview.WebViewFactory;
import io.dcloud.common.adapter.util.AndroidResources;
import io.dcloud.common.adapter.util.DeviceInfo;
import io.dcloud.common.adapter.util.EventActionInfo;
import io.dcloud.common.adapter.util.Logger;
import io.dcloud.common.adapter.util.MessageHandler;
import io.dcloud.common.adapter.util.SP;
import io.dcloud.common.constant.AbsoluteConst;
import io.dcloud.common.core.permission.PermissionControler;
import io.dcloud.common.util.BaseInfo;
import io.dcloud.common.util.JSONUtil;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.common.util.TelephonyUtil;
import io.dcloud.common.util.language.LanguageUtil;
import java.util.HashMap;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AdaUniWebView extends AdaWebview {
    MessageHandler.IMessages iMessages = new MessageHandler.IMessages() {
        /* class io.dcloud.common.adapter.ui.AdaUniWebView.AnonymousClass1 */

        @Override // io.dcloud.common.adapter.util.MessageHandler.IMessages
        public void execute(Object obj) {
            Object[] objArr = (Object[]) obj;
            AdaUniWebView.this.exec(String.valueOf(objArr[0]), String.valueOf(objArr[1]), (JSONArray) objArr[2]);
        }
    };
    boolean isUniService = false;
    IApp mApp;
    String mFullUrl;
    float mScale = 3.0f;
    IUniNView mUniNView;
    String mUrl;
    private String mUserAgent = null;
    ViewGroup mViewImpl;
    AbsMgr mWinMgr = null;

    public AdaUniWebView(Context context, IApp iApp, AdaFrameView adaFrameView, String str, String str2, JSONObject jSONObject, boolean z) {
        super(context);
        str = str == null ? "" : str;
        JSONObject jSONObject2 = new JSONObject();
        try {
            jSONObject2.put("js", str);
            jSONObject2.put("data", jSONObject);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        this.isUniService = z;
        this.mApp = iApp;
        this.mFrameView = adaFrameView;
        this.mAppid = iApp.obtainAppId();
        initSitemapState();
        this.mUrl = str;
        this.mFullUrl = TextUtils.isEmpty(str) ? this.mUrl : this.mApp.convert2WebviewFullPath(null, this.mUrl);
        this.mWinMgr = adaFrameView.obtainWindowMgr();
        this.mScale = context.getResources().getDisplayMetrics().density;
        this.mWebViewParent = new AdaWebViewParent(context, false);
        initUserAgent(iApp);
        IUniNView iUniNView = (IUniNView) this.mWinMgr.processEvent(IMgr.MgrType.FeatureMgr, 10, new Object[]{iApp, "weex,io.dcloud.feature.weex.WeexFeature", "createUniNView", new Object[]{this, this.mWebViewParent.obtainMainViewGroup(), jSONObject2, str2}});
        this.mUniNView = iUniNView;
        if (iUniNView != null) {
            ViewGroup obtainMainView = iUniNView.obtainMainView();
            this.mViewImpl = obtainMainView;
            setMainView(obtainMainView);
        }
        this.mWebViewParent.fillsWithWebview(this);
    }

    @Override // io.dcloud.common.DHInterface.IWebview, io.dcloud.common.adapter.ui.AdaWebview
    public void addJsInterface(String str, IJsInterface iJsInterface) {
    }

    @Override // io.dcloud.common.adapter.ui.AdaWebview
    public void addJsInterface(String str, Object obj) {
    }

    @Override // io.dcloud.common.DHInterface.IWebview, io.dcloud.common.adapter.ui.AdaWebview
    public void addJsInterface(String str, String str2) {
    }

    @Override // io.dcloud.common.DHInterface.IWebview, io.dcloud.common.adapter.ui.AdaWebview
    public boolean canGoBack() {
        return false;
    }

    @Override // io.dcloud.common.DHInterface.IWebview, io.dcloud.common.adapter.ui.AdaWebview
    public boolean canGoForward() {
        return false;
    }

    @Override // io.dcloud.common.adapter.ui.AdaFrameItem, io.dcloud.common.adapter.ui.AdaWebview, io.dcloud.common.adapter.ui.AdaContainerFrameItem
    public void dispose() {
        super.dispose();
        this.mUniNView = null;
        this.mViewImpl = null;
    }

    @Override // io.dcloud.common.DHInterface.IWebview, io.dcloud.common.adapter.ui.AdaWebview
    public void endWebViewEvent(String str) {
        if (PdrUtil.isEquals(str, AbsoluteConst.PULL_DOWN_REFRESH)) {
            IUniNView iUniNView = this.mUniNView;
            if (iUniNView != null) {
                iUniNView.endPullToRefresh();
                return;
            }
            return;
        }
        super.endWebViewEvent(str);
    }

    @Override // io.dcloud.common.DHInterface.IWebview, io.dcloud.common.adapter.ui.AdaWebview
    public void evalJS(String str) {
        evalJSToUniNative(str);
    }

    public void evalJSToUniNative(String str) {
        if (this.mUniNView != null && !PdrUtil.isEmpty(str)) {
            HashMap hashMap = new HashMap();
            hashMap.put("data", str);
            this.mUniNView.fireGlobalEvent("nativeToUniJs", hashMap);
        }
    }

    public String exec(String str, String str2, JSONArray jSONArray) {
        if (getContext() == null) {
            return "";
        }
        try {
            if ("syncExecMethod".equalsIgnoreCase(str2)) {
                str2 = AbsoluteConst.UNI_SYNC_EXEC_METHOD;
            }
            return String.valueOf(this.mWinMgr.processEvent(IMgr.MgrType.FeatureMgr, 1, new Object[]{this, str, str2, jSONArray}));
        } catch (Exception e) {
            Logger.w("JsInterfaceImpl.exec pApiFeatureName=" + str + ";pActionName=" + str2 + ";pArgs=" + String.valueOf(jSONArray), e);
            return null;
        }
    }

    @Override // io.dcloud.common.DHInterface.IWebview, io.dcloud.common.adapter.ui.AdaWebview
    public void executeScript(String str) {
        evalJS(str);
    }

    public void fireEvent(EventActionInfo eventActionInfo) {
        if (this.mUniNView != null && eventActionInfo != null) {
            if (!TextUtils.isEmpty(eventActionInfo.getEvalJs())) {
                evalJSToUniNative(eventActionInfo.getEvalJs());
            }
            this.mUniNView.fireGlobalEvent(eventActionInfo.getEventAction(), eventActionInfo.getParams());
        }
    }

    public Object getConfigInfo() {
        if (DeviceInfo.sNetWorkInited) {
            DeviceInfo.initGsmCdmaCell();
        }
        HashMap hashMap = new HashMap();
        hashMap.put("__HtMl_Id__", getWebviewUUID());
        if (PermissionControler.checkPermission(this.mApp.obtainAppId(), IFeature.F_DEVICE.toLowerCase(Locale.ENGLISH)) || !this.mApp.manifestBeParsed()) {
            HashMap hashMap2 = new HashMap();
            hashMap2.put("imei", DeviceInfo.sIMEI);
            hashMap2.put("imsi", DeviceInfo.sIMSI);
            hashMap2.put("model", DeviceInfo.sModel);
            hashMap2.put("vendor", DeviceInfo.sVendor);
            hashMap2.put("uuid", TelephonyUtil.getIMEI(this.mApp.getActivity(), false));
            hashMap.put("device", hashMap2);
            HashMap hashMap3 = new HashMap();
            hashMap3.put("language", LanguageUtil.getDeviceDefLocalLanguage());
            hashMap3.put("version", Build.VERSION.RELEASE);
            hashMap3.put("name", TimeCalculator.PLATFORM_ANDROID);
            hashMap3.put("vendor", "Google");
            hashMap.put(WXConfig.os, hashMap3);
            int i = this.mApp.getInt(2);
            int i2 = this.mApp.getInt(0);
            int i3 = this.mApp.getInt(1);
            HashMap hashMap4 = new HashMap();
            float scale = getScale();
            hashMap4.put("resolutionHeight", Integer.valueOf((int) (((float) i) / scale)));
            int i4 = (int) (((float) i2) / scale);
            hashMap4.put("resolutionWidth", Integer.valueOf(i4));
            hashMap4.put("scale", Float.valueOf(scale));
            hashMap4.put("dpiX", Float.valueOf(DeviceInfo.dpiX));
            hashMap4.put("dpiY", Float.valueOf(DeviceInfo.dpiY));
            hashMap4.put("height", Integer.valueOf(i));
            hashMap4.put("width", Integer.valueOf(i2));
            hashMap.put("screen", hashMap4);
            HashMap hashMap5 = new HashMap();
            hashMap5.put("resolutionHeight", Integer.valueOf((int) (((float) i3) / scale)));
            hashMap5.put("resolutionWidth", Integer.valueOf(i4));
            hashMap.put("display", hashMap5);
        }
        if (PermissionControler.checkPermission(this.mApp.obtainAppId(), IFeature.F_RUNTIME) || !this.mApp.manifestBeParsed()) {
            String obtainConfigProperty = this.mApp.obtainConfigProperty(IApp.ConfigProperty.CONFIG_LOADED_TIME);
            HashMap hashMap6 = new HashMap();
            hashMap6.put("innerVersion", "1.9.9.81993");
            hashMap6.put("appid", this.mApp.obtainAppId());
            hashMap6.put("launchLoadedTime", obtainConfigProperty);
            if (BaseInfo.ISAMU) {
                hashMap6.put("version", this.mApp.obtainAppVersionName());
            } else {
                hashMap6.put("version", AndroidResources.mApplicationInfo.versionName);
            }
            hashMap6.put("arguments", this.mApp.obtainRuntimeArgs(false));
            hashMap6.put("launcher", BaseInfo.getLauncherData(this.mApp.obtainAppId()));
            hashMap6.put(AbsoluteConst.XML_CHANNEL, BaseInfo.getAnalysisChannel());
            hashMap6.put("startupTime", String.valueOf(BaseInfo.getStartupTimeData(this.mApp.obtainAppId())));
            hashMap6.put("processId", Long.valueOf(BaseInfo.sProcessId));
            hashMap6.put("uniVersion", BaseInfo.uniVersionV3);
            hashMap6.put("versionCode", Integer.valueOf(AndroidResources.versionCode));
            Activity activity = this.mApp.getActivity();
            String bundleData = SP.getBundleData(activity, "pdr", this.mApp.obtainAppId() + AbsoluteConst.LAUNCHTYPE);
            if (TextUtils.isEmpty(bundleData)) {
                bundleData = "default";
            }
            hashMap6.put("origin", bundleData);
            hashMap.put("runtime", hashMap6);
        }
        HashMap hashMap7 = new HashMap();
        hashMap7.put("__isUniPush__", Boolean.valueOf(AndroidResources.getMetaValue("DCLOUD_UNIPUSH")));
        hashMap.put("push", hashMap7);
        return hashMap;
    }

    @Override // io.dcloud.common.DHInterface.IWebview, io.dcloud.common.adapter.ui.AdaWebview
    public String getCookie(String str) {
        if (WebViewFactory.isIsOtherInitSuccess()) {
            return CookieCenter.getCookies(str);
        }
        return CookieManager.getInstance().getCookie(str);
    }

    @Override // io.dcloud.common.DHInterface.IWebview, io.dcloud.common.adapter.ui.AdaWebview
    public String getOriginalUrl() {
        return this.mUrl;
    }

    @Override // io.dcloud.common.DHInterface.IWebview, io.dcloud.common.adapter.ui.AdaWebview
    public float getScale() {
        return this.mScale;
    }

    @Override // io.dcloud.common.DHInterface.IWebview, io.dcloud.common.adapter.ui.AdaWebview
    public float getScaleOfOpenerWebview() {
        return 0.0f;
    }

    @Override // io.dcloud.common.DHInterface.IWebview, io.dcloud.common.adapter.ui.AdaWebview
    public String getTitle() {
        return "";
    }

    @Override // io.dcloud.common.DHInterface.IWebview, io.dcloud.common.adapter.ui.AdaWebview
    public String getWebviewProperty(String str) {
        if (IWebview.USER_AGENT.equals(str)) {
            return this.mUserAgent;
        }
        return super.getWebviewProperty(str);
    }

    /* access modifiers changed from: package-private */
    public void initUserAgent(IApp iApp) {
        if (!PdrUtil.isEmpty(AdaWebview.sCustomUserAgent)) {
            this.mUserAgent = AdaWebview.sCustomUserAgent;
            return;
        }
        this.mUserAgent = WebViewFactory.getDefWebViewUA(getContext());
        String obtainConfigProperty = iApp.obtainConfigProperty(IApp.ConfigProperty.CONFIG_USER_AGENT);
        boolean parseBoolean = Boolean.parseBoolean(iApp.obtainConfigProperty(IApp.ConfigProperty.CONFIG_CONCATENATE));
        if (Boolean.parseBoolean(iApp.obtainConfigProperty(IApp.ConfigProperty.CONFIG_funSetUA))) {
            parseBoolean = false;
        }
        if (!parseBoolean && !PdrUtil.isEmpty(obtainConfigProperty)) {
            this.mUserAgent = obtainConfigProperty;
        } else if (!PdrUtil.isEmpty(obtainConfigProperty)) {
            this.mUserAgent += Operators.SPACE_STR + obtainConfigProperty.trim();
        }
        boolean booleanValue = Boolean.valueOf(iApp.obtainConfigProperty(AbsoluteConst.JSONKEY_STATUSBAR_IMMERSED)).booleanValue();
        if (iApp.obtainStatusBarMgr() != null && iApp.obtainStatusBarMgr().checkImmersedStatusBar(getActivity(), booleanValue)) {
            this.mUserAgent += (" (Immersed/" + (((float) DeviceInfo.sStatusBarHeight) / this.mScale) + Operators.BRACKET_END_STR);
        }
    }

    @Override // io.dcloud.common.DHInterface.IWebview, io.dcloud.common.adapter.ui.AdaWebview
    public boolean isUniService() {
        return this.isUniService;
    }

    @Override // io.dcloud.common.DHInterface.IWebview, io.dcloud.common.adapter.ui.AdaWebview
    public boolean isUniWebView() {
        return true;
    }

    @Override // io.dcloud.common.DHInterface.IWebview, io.dcloud.common.adapter.ui.AdaWebview
    public void loadContentData(String str, String str2, String str3, String str4) {
    }

    @Override // io.dcloud.common.DHInterface.IWebview, io.dcloud.common.adapter.ui.AdaWebview
    public void loadUrl(String str) {
        if (!PdrUtil.isNetPath(str) && !PdrUtil.isFilePath(str)) {
            evalJS(str);
        }
    }

    @Override // io.dcloud.common.DHInterface.IWebview
    public IApp obtainApp() {
        return this.mApp;
    }

    @Override // io.dcloud.common.DHInterface.IWebview, io.dcloud.common.adapter.ui.AdaWebview
    public IFrameView obtainFrameView() {
        return this.mFrameView;
    }

    @Override // io.dcloud.common.DHInterface.IWebview, io.dcloud.common.adapter.ui.AdaWebview
    public String obtainFullUrl() {
        return this.mFullUrl;
    }

    @Override // io.dcloud.common.DHInterface.IWebview, io.dcloud.common.adapter.ui.AdaWebview
    public String obtainPageTitle() {
        return "";
    }

    @Override // io.dcloud.common.DHInterface.IWebview, io.dcloud.common.adapter.ui.AdaWebview
    public String obtainUrl() {
        return this.mUrl;
    }

    @Override // io.dcloud.common.DHInterface.IWebview, io.dcloud.common.adapter.ui.AdaWebview
    public WebView obtainWebview() {
        return null;
    }

    @Override // io.dcloud.common.DHInterface.IWebview, io.dcloud.common.adapter.ui.AdaWebview
    public ViewGroup obtainWindowView() {
        return this.mViewImpl;
    }

    public String prompt(String str, String str2) {
        if (str2 != null && str2.length() > 3 && str2.substring(0, 4).equals("pdr:")) {
            try {
                JSONArray jSONArray = new JSONArray(str2.substring(4));
                String string = jSONArray.getString(0);
                String string2 = jSONArray.getString(1);
                boolean z = jSONArray.getBoolean(2);
                JSONArray createJSONArray = JSONUtil.createJSONArray(str);
                if (!z) {
                    return exec(string, string2, createJSONArray);
                }
                MessageHandler.sendMessage(this.iMessages, new Object[]{string, string2, createJSONArray});
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override // io.dcloud.common.DHInterface.IWebview, io.dcloud.common.adapter.ui.AdaWebview
    public void reload() {
        IUniNView iUniNView = this.mUniNView;
        if (iUniNView != null) {
            iUniNView.reload();
        }
    }

    @Override // io.dcloud.common.DHInterface.IWebview, io.dcloud.common.adapter.ui.AdaWebview
    public void reload(String str) {
    }

    public void setNVuePath(String str) {
        this.mUrl = str;
        this.mFullUrl = TextUtils.isEmpty(str) ? this.mUrl : this.mApp.convert2WebviewFullPath(null, this.mUrl);
    }

    @Override // io.dcloud.common.DHInterface.IWebview, io.dcloud.common.adapter.ui.AdaWebview
    public void setOriginalUrl(String str) {
        this.mUrl = str;
    }

    @Override // io.dcloud.common.DHInterface.IWebview, io.dcloud.common.adapter.ui.AdaWebview
    public void setWebViewEvent(String str, Object obj) {
        if (PdrUtil.isEquals(str, AbsoluteConst.PULL_DOWN_REFRESH)) {
            JSONObject jSONObject = (JSONObject) obj;
            IUniNView iUniNView = this.mUniNView;
            if (iUniNView != null) {
                iUniNView.initRefresh(jSONObject);
            }
        } else if (PdrUtil.isEquals(str, AbsoluteConst.PULL_REFRESH_BEGIN)) {
            IUniNView iUniNView2 = this.mUniNView;
            if (iUniNView2 != null) {
                iUniNView2.beginPullRefresh();
            }
        } else {
            super.setWebViewEvent(str, obj);
        }
    }

    @Override // io.dcloud.common.DHInterface.IWebview
    public void show(Animation animation) {
    }

    public void titleNViewRefresh() {
        IUniNView iUniNView = this.mUniNView;
        if (iUniNView != null) {
            iUniNView.titleNViewRefresh();
        }
    }

    public void updateScreenAndDisplay() {
        if (!(obtainApp() == null || this.mUniNView == null)) {
            int i = obtainApp().getInt(2);
            int i2 = obtainApp().getInt(0);
            int i3 = obtainApp().getInt(1);
            HashMap hashMap = new HashMap();
            float scale = getScale();
            hashMap.put("resolutionHeight", Double.valueOf(Math.ceil((double) (((float) i) / scale))));
            double d = (double) (((float) i2) / scale);
            hashMap.put("resolutionWidth", Double.valueOf(Math.ceil(d)));
            hashMap.put("dpiX", Float.valueOf(DeviceInfo.dpiX));
            hashMap.put("dpiY", Float.valueOf(DeviceInfo.dpiY));
            HashMap hashMap2 = new HashMap();
            hashMap2.put("resolutionHeight", Double.valueOf(Math.ceil((double) (((float) i3) / scale))));
            hashMap2.put("resolutionWidth", Double.valueOf(Math.ceil(d)));
            StringBuilder sb = new StringBuilder();
            for (String str : hashMap.keySet()) {
                sb.append("plus.screen.");
                sb.append(str);
                sb.append("=");
                sb.append(hashMap.get(str));
                sb.append(";");
            }
            for (String str2 : hashMap2.keySet()) {
                sb.append("plus.display.");
                sb.append(str2);
                sb.append("=");
                sb.append(hashMap2.get(str2));
                sb.append(";");
            }
            evalJSToUniNative(sb.toString());
        }
    }

    @Override // io.dcloud.common.DHInterface.IWebview, io.dcloud.common.adapter.ui.AdaWebview
    public void evalJS(String str, ReceiveJSValue.ReceiveJSValueCallback receiveJSValueCallback) {
        evalJS(str);
    }

    @Override // io.dcloud.common.DHInterface.IWebview, io.dcloud.common.adapter.ui.AdaWebview
    public void reload(boolean z) {
        reload();
    }
}
