package io.dcloud.common.adapter.ui;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.DecelerateInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.dcloud.android.v4.widget.IRefreshAble;
import com.dcloud.android.widget.AbsoluteLayout;
import com.dcloud.android.widget.StatusBarView;
import io.dcloud.base.R;
import io.dcloud.common.DHInterface.AbsMgr;
import io.dcloud.common.DHInterface.IApp;
import io.dcloud.common.DHInterface.ICallBack;
import io.dcloud.common.DHInterface.IEventCallback;
import io.dcloud.common.DHInterface.IFrameView;
import io.dcloud.common.DHInterface.IMgr;
import io.dcloud.common.DHInterface.INativeBitmap;
import io.dcloud.common.DHInterface.INativeView;
import io.dcloud.common.DHInterface.IWaiter;
import io.dcloud.common.DHInterface.IWebview;
import io.dcloud.common.adapter.ui.AdaFrameItem;
import io.dcloud.common.adapter.util.AnimOptions;
import io.dcloud.common.adapter.util.DeviceInfo;
import io.dcloud.common.adapter.util.Logger;
import io.dcloud.common.adapter.util.MessageHandler;
import io.dcloud.common.adapter.util.PlatformUtil;
import io.dcloud.common.adapter.util.ViewOptions;
import io.dcloud.common.adapter.util.ViewRect;
import io.dcloud.common.constant.AbsoluteConst;
import io.dcloud.common.core.ui.k;
import io.dcloud.common.core.ui.l;
import io.dcloud.common.util.BaseInfo;
import io.dcloud.common.util.JSONUtil;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.common.util.SubNViewsUtil;
import io.dcloud.nineoldandroids.animation.Animator;
import io.dcloud.nineoldandroids.view.ViewHelper;
import java.util.ArrayList;
import java.util.Locale;
import org.mozilla.universalchardet.prober.HebrewProber;

public abstract class AdaFrameView extends AdaContainerFrameItem implements IFrameView {
    private static final int ERROR = 0;
    private static final int SUCCESS = 1;
    public boolean inStack = true;
    public boolean interceptTouchEvent = true;
    public boolean isChildOfFrameView = false;
    private boolean isTabItem = false;
    public boolean isTouchEvent = true;
    public String mAccelerationType = "auto";
    public boolean mAnimationCapture = false;
    Animation.AnimationListener mAnimationListener = new Animation.AnimationListener() {
        /* class io.dcloud.common.adapter.ui.AdaFrameView.AnonymousClass7 */

        public void onAnimationEnd(Animation animation) {
            Animator.AnimatorListener animatorListener = AdaFrameView.this.mAnimatorListener;
            if (animatorListener != null) {
                animatorListener.onAnimationEnd(null);
            }
        }

        public void onAnimationRepeat(Animation animation) {
            Animator.AnimatorListener animatorListener = AdaFrameView.this.mAnimatorListener;
            if (animatorListener != null) {
                animatorListener.onAnimationRepeat(null);
            }
        }

        public void onAnimationStart(Animation animation) {
            Animator.AnimatorListener animatorListener = AdaFrameView.this.mAnimatorListener;
            if (animatorListener != null) {
                animatorListener.onAnimationStart(null);
            }
        }
    };
    protected boolean mAnimationStarted = false;
    BounceView mBounceView = null;
    private Handler mCaptureHandler = new Handler() {
        /* class io.dcloud.common.adapter.ui.AdaFrameView.AnonymousClass4 */

        public void handleMessage(Message message) {
            if (message.what != 1) {
                if (AdaFrameView.this.mErrCallBack != null) {
                    AdaFrameView.this.mErrCallBack.onCallBack(message.arg1, message.obj);
                }
            } else if (AdaFrameView.this.mSucCallBack != null) {
                AdaFrameView.this.mSucCallBack.onCallBack(0, null);
            }
            super.handleMessage(message);
        }
    };
    private IRefreshAble mCircleRefreshView = null;
    private Context mContext;
    private ICallBack mErrCallBack = null;
    protected byte mFrameStatus;
    private int mFrameType = 0;
    private int mLastScreenHeight = 0;
    private ArrayList<IEventCallback> mListeners = null;
    public Bitmap mLoadingSnapshot = null;
    public String mNativeViewAction = "none";
    private DHImageView mPageCImageView = null;
    RefreshView mRefreshView = null;
    public Bitmap mSnapshot = null;
    private ICallBack mSucCallBack = null;
    public l mWindowMgr;

    public interface OnAnimationEnd {
        void onDone();
    }

    protected AdaFrameView(Context context, int i, Object obj) {
        super(context);
        this.mFrameType = i;
        initMainView(context, i, obj);
        this.mContext = context;
        this.mNeedOrientationUpdate = true;
        this.mLastScreenHeight = PlatformUtil.SCREEN_HEIGHT(context);
    }

    private void addCaptureImageView(ViewGroup viewGroup, DHImageView dHImageView, Bitmap bitmap) {
        if (dHImageView.getParent() != viewGroup) {
            if (dHImageView.getParent() != null) {
                ((ViewGroup) dHImageView.getParent()).removeView(dHImageView);
            }
            viewGroup.addView(dHImageView);
        }
        dHImageView.bringToFront();
        dHImageView.setImageBitmap(bitmap);
        dHImageView.removeNativeView();
        dHImageView.setVisibility(AdaFrameItem.VISIBLE);
    }

    /* JADX WARNING: Removed duplicated region for block: B:59:0x0128  */
    /* JADX WARNING: Removed duplicated region for block: B:62:0x0134  */
    /* JADX WARNING: Removed duplicated region for block: B:80:0x0185  */
    /* JADX WARNING: Removed duplicated region for block: B:81:0x0188  */
    /* JADX WARNING: Removed duplicated region for block: B:86:0x01a0  */
    /* JADX WARNING: Removed duplicated region for block: B:87:0x01a6  */
    /* JADX WARNING: Removed duplicated region for block: B:90:0x01c6  */
    /* JADX WARNING: Removed duplicated region for block: B:96:0x01e1  */
    /* JADX WARNING: Removed duplicated region for block: B:97:0x01f9  */
    private boolean captureAnimation(final Animator animator, final int i) {
        boolean z;
        long j;
        Animation animation;
        Bitmap bitmap;
        if (obtainFrameOptions().isAnimationOptimization && SubNViewsUtil.startAnimation(this, animator, i)) {
            return true;
        }
        int i2 = 0;
        if (!this.mAnimationCapture || !BaseInfo.sAnimationCaptureC) {
            return false;
        }
        final ViewGroup viewGroup = (ViewGroup) obtainMainView();
        if (checkITypeofAble()) {
            return false;
        }
        final k kVar = (k) obtainWebAppRootView().obtainMainView();
        Bitmap bitmap2 = null;
        if (this.mPageCImageView == null || kVar.getHeight() == this.mPageCImageView.getHeight()) {
            if (this.mPageCImageView == null) {
                DHImageView rightImageView = kVar.getRightImageView();
                this.mPageCImageView = rightImageView;
                rightImageView.setScaleType(ImageView.ScaleType.FIT_XY);
            }
            if (this.mPageCImageView.isSlipping()) {
                return false;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("C页面是否启用截图动画方案:");
            sb.append(this.mAnimationCapture && BaseInfo.sAnimationCaptureC);
            sb.append(" | ");
            sb.append(this.mAnimOptions.mAnimType);
            Logger.e("mabo", sb.toString());
            long currentTimeMillis = System.currentTimeMillis();
            INativeView iNativeView = this.mNativeView;
            if (iNativeView != null) {
                if (iNativeView.isAnimate()) {
                    this.mPageCImageView.removeNativeView();
                    this.mNativeView = null;
                } else {
                    this.mPageCImageView.setImageBitmap(null);
                    this.mPageCImageView.addNativeView(this, this.mNativeView);
                }
            }
            if (this.mNativeView == null) {
                if (i == 0) {
                    bitmap2 = this.mLoadingSnapshot;
                    if (bitmap2 == null && (bitmap2 = this.mSnapshot) == null) {
                        if (Build.VERSION.SDK_INT >= 22 || !this.isChildOfFrameView || viewGroup.getHeight() <= obtainFrameOptions().height) {
                            bitmap = PlatformUtil.captureView(viewGroup);
                        } else {
                            bitmap = PlatformUtil.captureView(viewGroup, true, true, new Rect(0, 0, viewGroup.getWidth(), obtainFrameOptions().height), "ARGB");
                        }
                        bitmap2 = bitmap;
                    }
                } else {
                    bitmap2 = this.mSnapshot;
                    if (bitmap2 == null) {
                        bitmap2 = PlatformUtil.captureView(viewGroup);
                    }
                }
                z = true;
                long currentTimeMillis2 = System.currentTimeMillis();
                StringBuilder sb2 = new StringBuilder();
                sb2.append("==============C截图耗时=");
                j = currentTimeMillis2 - currentTimeMillis;
                sb2.append(j);
                Logger.i("mabo", sb2.toString());
                if (j < ((long) BaseInfo.sTimeoutCapture)) {
                    int i3 = BaseInfo.sTimeOutCount + 1;
                    BaseInfo.sTimeOutCount = i3;
                    if (i3 > BaseInfo.sTimeOutMax) {
                        BaseInfo.sAnimationCaptureC = false;
                    }
                } else if (z) {
                    BaseInfo.sTimeOutCount = 0;
                }
                this.mPageCImageView.refreshImagerView();
                if (this.mNativeView != null && (bitmap2 == null || PlatformUtil.isWhiteBitmap(bitmap2))) {
                    return false;
                }
                if (!(viewGroup.getMeasuredWidth() == 0 || viewGroup.getMeasuredHeight() == 0)) {
                    FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(viewGroup.getMeasuredWidth(), viewGroup.getMeasuredHeight());
                    if (Build.VERSION.SDK_INT < 22 && this.isChildOfFrameView) {
                        layoutParams.height = (viewGroup.getMeasuredHeight() + obtainFrameOptions().top) - (!getParentFrameItem().obtainFrameOptions().isStatusbar ? DeviceInfo.sStatusBarHeight : 0);
                        this.mPageCImageView.setPadding(0, obtainFrameOptions().top, 0, 0);
                    }
                    this.mPageCImageView.setLayoutParams(layoutParams);
                }
                if (this.mNativeView != null) {
                    addCaptureImageView(kVar, this.mPageCImageView, bitmap2);
                } else {
                    this.mPageCImageView.bringToFront();
                    this.mPageCImageView.setVisibility(0);
                }
                viewGroup.setVisibility(4);
                ViewHelper.setX(this.mPageCImageView, (float) this.mViewOptions.left);
                int i4 = this.mViewOptions.top;
                if (this.isChildOfFrameView) {
                    if (getParentFrameItem().obtainFrameOptions().isStatusbar) {
                        i2 = DeviceInfo.sStatusBarHeight;
                    }
                    i4 += i2;
                }
                ViewHelper.setY(this.mPageCImageView, (float) i4);
                animation = this.mAnimOptions.mAnimator;
                if (animation != null) {
                    animator.setTarget(this.mPageCImageView);
                    animator.addListener(new Animator.AnimatorListener() {
                        /* class io.dcloud.common.adapter.ui.AdaFrameView.AnonymousClass1 */

                        @Override // io.dcloud.nineoldandroids.animation.Animator.AnimatorListener
                        public void onAnimationCancel(Animator animator) {
                            BaseInfo.sDoingAnimation = false;
                            if (BaseInfo.sOpenedCount == 0) {
                                BaseInfo.sFullScreenChanged = false;
                            }
                            Animator.AnimatorListener animatorListener = AdaFrameView.this.mAnimatorListener;
                            if (animatorListener != null) {
                                animatorListener.onAnimationCancel(animator);
                            }
                        }

                        @Override // io.dcloud.nineoldandroids.animation.Animator.AnimatorListener
                        public void onAnimationEnd(Animator animator) {
                            int i = 0;
                            if (AdaFrameView.this.mPageCImageView != null) {
                                AdaFrameView.this.mPageCImageView.setIntercept(false);
                                if (i != 0) {
                                    AdaFrameView.this.mPageCImageView.setNativeAnimationRuning(false);
                                }
                            }
                            Animator.AnimatorListener animatorListener = AdaFrameView.this.mAnimatorListener;
                            if (animatorListener != null) {
                                animatorListener.onAnimationEnd(animator);
                            }
                            byte b = AdaFrameView.this.mAnimOptions.mOption;
                            if (b == 3 || b == 1) {
                                viewGroup.setVisibility(4);
                            } else {
                                viewGroup.setVisibility(0);
                            }
                            if (AdaFrameView.this.mPageCImageView == null || !AdaFrameView.this.mPageCImageView.isNativeView()) {
                                i = HebrewProber.NORMAL_NUN;
                            }
                            kVar.postDelayed(new Runnable() {
                                /* class io.dcloud.common.adapter.ui.AdaFrameView.AnonymousClass1.AnonymousClass1 */

                                public void run() {
                                    if (AdaFrameView.this.mPageCImageView != null) {
                                        if (AdaFrameView.this.mPageCImageView.isNativeView()) {
                                            AdaFrameView adaFrameView = AdaFrameView.this;
                                            adaFrameView.handleNativeViewByAction(adaFrameView.mPageCImageView, i);
                                        } else {
                                            AdaFrameView.this.mPageCImageView.setVisibility(4);
                                            AdaFrameView.this.mPageCImageView.setImageBitmap(null);
                                            AdaFrameView.this.mPageCImageView.removeNativeView();
                                        }
                                    }
                                    BaseInfo.sDoingAnimation = false;
                                    if (BaseInfo.sOpenedCount == 0) {
                                        BaseInfo.sFullScreenChanged = false;
                                    }
                                }
                            }, (long) i);
                            animator.removeListener(this);
                        }

                        @Override // io.dcloud.nineoldandroids.animation.Animator.AnimatorListener
                        public void onAnimationRepeat(Animator animator) {
                            Animator.AnimatorListener animatorListener = AdaFrameView.this.mAnimatorListener;
                            if (animatorListener != null) {
                                animatorListener.onAnimationRepeat(animator);
                            }
                        }

                        @Override // io.dcloud.nineoldandroids.animation.Animator.AnimatorListener
                        public void onAnimationStart(Animator animator) {
                            if (AdaFrameView.this.mPageCImageView != null) {
                                AdaFrameView.this.mPageCImageView.setIntercept(true);
                                if (i != 0) {
                                    AdaFrameView.this.mPageCImageView.setNativeAnimationRuning(true);
                                }
                            }
                            BaseInfo.sDoingAnimation = true;
                            Animator.AnimatorListener animatorListener = AdaFrameView.this.mAnimatorListener;
                            if (animatorListener != null) {
                                animatorListener.onAnimationStart(animator);
                            }
                        }
                    });
                    animator.start();
                } else {
                    animation.setAnimationListener(new Animation.AnimationListener() {
                        /* class io.dcloud.common.adapter.ui.AdaFrameView.AnonymousClass2 */

                        /* JADX WARNING: Code restructure failed: missing block: B:15:0x0054, code lost:
                            if (r4.this$0.mPageCImageView.isNativeView() != false) goto L_0x0059;
                         */
                        public void onAnimationEnd(Animation animation) {
                            int i = 0;
                            if (AdaFrameView.this.mPageCImageView != null) {
                                AdaFrameView.this.mPageCImageView.setIntercept(false);
                            }
                            BaseInfo.sDoingAnimation = false;
                            Animator.AnimatorListener animatorListener = AdaFrameView.this.mAnimatorListener;
                            if (animatorListener != null) {
                                animatorListener.onAnimationEnd(null);
                            }
                            byte b = AdaFrameView.this.mAnimOptions.mOption;
                            if (b == 3 || b == 1) {
                                viewGroup.setVisibility(4);
                            } else {
                                viewGroup.setVisibility(0);
                            }
                            if (AdaFrameView.this.mPageCImageView != null) {
                                AdaFrameView.this.mPageCImageView.setVisibility(4);
                            }
                            i = HebrewProber.NORMAL_NUN;
                            viewGroup.postDelayed(new Runnable() {
                                /* class io.dcloud.common.adapter.ui.AdaFrameView.AnonymousClass2.AnonymousClass1 */

                                public void run() {
                                    if (AdaFrameView.this.mPageCImageView != null && !BaseInfo.sDoingAnimation) {
                                        if (AdaFrameView.this.mPageCImageView.isNativeView()) {
                                            AdaFrameView adaFrameView = AdaFrameView.this;
                                            adaFrameView.handleNativeViewByAction(adaFrameView.mPageCImageView, i);
                                        } else {
                                            AdaFrameView.this.mPageCImageView.clearAnimation();
                                            AdaFrameView.this.mPageCImageView.removeNativeView();
                                            AdaFrameView.this.mPageCImageView.setVisibility(4);
                                            AdaFrameView.this.mPageCImageView.setImageBitmap(null);
                                        }
                                    }
                                    if (BaseInfo.sOpenedCount == 0) {
                                        BaseInfo.sFullScreenChanged = false;
                                    }
                                }
                            }, (long) i);
                        }

                        public void onAnimationRepeat(Animation animation) {
                            Animator.AnimatorListener animatorListener = AdaFrameView.this.mAnimatorListener;
                            if (animatorListener != null) {
                                animatorListener.onAnimationRepeat(null);
                            }
                        }

                        public void onAnimationStart(Animation animation) {
                            if (AdaFrameView.this.mPageCImageView != null) {
                                AdaFrameView.this.mPageCImageView.setIntercept(true);
                            }
                            BaseInfo.sDoingAnimation = true;
                            Animator.AnimatorListener animatorListener = AdaFrameView.this.mAnimatorListener;
                            if (animatorListener != null) {
                                animatorListener.onAnimationStart(null);
                            }
                        }
                    });
                    DHImageView dHImageView = this.mPageCImageView;
                    if (dHImageView != null) {
                        dHImageView.startAnimation(this.mAnimOptions.mAnimator);
                    }
                }
                return true;
            }
            z = false;
            long currentTimeMillis22 = System.currentTimeMillis();
            StringBuilder sb22 = new StringBuilder();
            sb22.append("==============C截图耗时=");
            j = currentTimeMillis22 - currentTimeMillis;
            sb22.append(j);
            Logger.i("mabo", sb22.toString());
            if (j < ((long) BaseInfo.sTimeoutCapture)) {
            }
            this.mPageCImageView.refreshImagerView();
            if (this.mNativeView != null) {
            }
            FrameLayout.LayoutParams layoutParams2 = new FrameLayout.LayoutParams(viewGroup.getMeasuredWidth(), viewGroup.getMeasuredHeight());
            layoutParams2.height = (viewGroup.getMeasuredHeight() + obtainFrameOptions().top) - (!getParentFrameItem().obtainFrameOptions().isStatusbar ? DeviceInfo.sStatusBarHeight : 0);
            this.mPageCImageView.setPadding(0, obtainFrameOptions().top, 0, 0);
            this.mPageCImageView.setLayoutParams(layoutParams2);
            if (this.mNativeView != null) {
            }
            viewGroup.setVisibility(4);
            ViewHelper.setX(this.mPageCImageView, (float) this.mViewOptions.left);
            int i42 = this.mViewOptions.top;
            if (this.isChildOfFrameView) {
            }
            ViewHelper.setY(this.mPageCImageView, (float) i42);
            animation = this.mAnimOptions.mAnimator;
            if (animation != null) {
            }
            return true;
        }
        this.mPageCImageView.clear();
        this.mPageCImageView = null;
        return false;
    }

    private int getFrameHeight() {
        int height = obtainMainView().getHeight();
        if (obtainMainView().getParent() == null) {
            return height;
        }
        if (obtainFrameOptions().height == -1) {
            return obtainWebAppRootView().obtainMainView().getHeight();
        }
        if (obtainFrameOptions().isStatusbarDodifyHeight) {
            return obtainFrameOptions().height + DeviceInfo.sStatusBarHeight;
        }
        return obtainFrameOptions().height;
    }

    private int indexOfViewInParent(View view, ViewGroup viewGroup) {
        int i = 0;
        while (i < viewGroup.getChildCount() && viewGroup.getChildAt(i) != view) {
            i++;
        }
        return i;
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void sendErrorMessage(int i, String str) {
        Message message = new Message();
        message.what = 0;
        message.arg1 = i;
        message.obj = str;
        this.mCaptureHandler.sendMessage(message);
    }

    @Override // io.dcloud.common.DHInterface.IFrameViewStatus
    public final void addFrameViewListener(IEventCallback iEventCallback) {
        if (this.mListeners == null) {
            this.mListeners = new ArrayList<>();
        }
        if (iEventCallback != null && !this.mListeners.contains(iEventCallback)) {
            this.mListeners.add(iEventCallback);
        }
    }

    @Override // io.dcloud.common.DHInterface.IFrameView
    public void animate(IWebview iWebview, String str, String str2) {
        if (obtainMainView() instanceof AbsoluteLayout) {
            ((AbsoluteLayout) obtainMainView()).animate(iWebview, str, str2);
        }
    }

    @Override // io.dcloud.common.DHInterface.IFrameView
    public void captureSnapshot(final String str, final ICallBack iCallBack, final ICallBack iCallBack2) {
        new Thread(new Runnable() {
            /* class io.dcloud.common.adapter.ui.AdaFrameView.AnonymousClass5 */

            public void run() {
                if (AdaFrameView.this.getContext() != null) {
                    if (TextUtils.isEmpty(str) || !"loading".equals(str.toLowerCase(Locale.ENGLISH))) {
                        try {
                            AdaFrameView adaFrameView = AdaFrameView.this;
                            adaFrameView.mSnapshot = PlatformUtil.captureView(adaFrameView.obtainMainView());
                            AdaFrameView adaFrameView2 = AdaFrameView.this;
                            if (adaFrameView2.mSnapshot != null) {
                                adaFrameView2.mSucCallBack = iCallBack;
                                AdaFrameView.this.mCaptureHandler.sendEmptyMessage(1);
                                return;
                            }
                            adaFrameView2.mErrCallBack = iCallBack2;
                            AdaFrameView adaFrameView3 = AdaFrameView.this;
                            adaFrameView3.sendErrorMessage(-100, adaFrameView3.getContext().getString(R.string.dcloud_common_screenshot_fail));
                        } catch (Exception unused) {
                            AdaFrameView.this.mErrCallBack = iCallBack2;
                            AdaFrameView adaFrameView4 = AdaFrameView.this;
                            adaFrameView4.sendErrorMessage(-100, adaFrameView4.getContext().getString(R.string.dcloud_common_screenshot_fail));
                        }
                    } else {
                        try {
                            AdaFrameView adaFrameView5 = AdaFrameView.this;
                            adaFrameView5.mLoadingSnapshot = PlatformUtil.captureView(adaFrameView5.obtainMainView());
                            AdaFrameView adaFrameView6 = AdaFrameView.this;
                            if (adaFrameView6.mLoadingSnapshot != null) {
                                adaFrameView6.mSucCallBack = iCallBack;
                                AdaFrameView.this.mCaptureHandler.sendEmptyMessage(1);
                                return;
                            }
                            adaFrameView6.mErrCallBack = iCallBack2;
                            AdaFrameView adaFrameView7 = AdaFrameView.this;
                            adaFrameView7.sendErrorMessage(-100, adaFrameView7.getContext().getString(R.string.dcloud_common_screenshot_fail));
                        } catch (Exception unused2) {
                            AdaFrameView.this.mErrCallBack = iCallBack2;
                            AdaFrameView adaFrameView8 = AdaFrameView.this;
                            adaFrameView8.sendErrorMessage(-100, adaFrameView8.getContext().getString(R.string.dcloud_common_screenshot_fail));
                        }
                    }
                }
            }
        }).start();
    }

    public void changeWebParentViewRect() {
        int i;
        ViewGroup viewGroup = (ViewGroup) obtainMainView();
        if (obtainWebviewParent() != null) {
            View obtainMainView = obtainWebviewParent().obtainMainView();
            if (viewGroup != null && obtainMainView != null) {
                try {
                    if (viewGroup.getHeight() == obtainMainView.getHeight()) {
                        if (viewGroup.getHeight() == obtainMainView.getHeight()) {
                            ViewOptions viewOptions = this.mViewOptions;
                            if (!viewOptions.isStatusbar && (viewOptions.titleNView == null || !obtainApp().obtainStatusBarMgr().isImmersive)) {
                                return;
                            }
                        } else {
                            return;
                        }
                    }
                    if (!obtainFrameOptions().hasBackground() || obtainMainView.getHeight() != obtainWebviewParent().obtainFrameOptions().height || this.mViewOptions.isStatusbar || obtainFrameOptions().titleNView != null) {
                        int frameHeight = getFrameHeight();
                        int i2 = 0;
                        for (int i3 = 0; i3 < viewGroup.getChildCount(); i3++) {
                            View childAt = viewGroup.getChildAt(i3);
                            if (childAt != obtainMainView) {
                                int height = childAt.getHeight();
                                if (childAt instanceof AbsoluteLayout) {
                                    if (((AbsoluteLayout) childAt).getFrameView().mPosition != ViewRect.DOCK_TOP) {
                                    }
                                } else if (childAt instanceof INativeView) {
                                    if (((INativeView) childAt).isDock()) {
                                        if (childAt.getTag() == null || ((!childAt.getTag().equals("NavigationBar") && !childAt.getTag().equals("titleNView")) || !((INativeView) childAt).isStatusBar())) {
                                            height = ((INativeView) childAt).getInnerHeight();
                                        } else {
                                            height = ((INativeView) childAt).getInnerHeight() + DeviceInfo.sStatusBarHeight;
                                        }
                                        if (!((INativeView) childAt).isDockTop()) {
                                            i = 0;
                                            frameHeight -= height;
                                            i2 += i;
                                        }
                                    }
                                } else if (!(childAt instanceof StatusBarView)) {
                                }
                                i = height;
                                frameHeight -= height;
                                i2 += i;
                            }
                        }
                        obtainMainView.getLayoutParams().height = frameHeight;
                        ViewHelper.setY(obtainMainView, (float) i2);
                        obtainMainView.requestLayout();
                        obtainMainView.invalidate();
                        if (!this.inStack) {
                            changeWebviewRect();
                        }
                    }
                } catch (Exception e) {
                    Log.e("AdaFrameItem", e.getMessage());
                }
            }
        }
    }

    /* access modifiers changed from: protected */
    public void changeWebviewRect() {
        ViewGroup obtainWindowView = obtainWebView().obtainWindowView();
        if (obtainWindowView.getParent() instanceof FrameLayout) {
            obtainWindowView.setLayoutParams(new FrameLayout.LayoutParams(-1, -1));
        } else if (obtainWindowView.getParent() instanceof LinearLayout) {
            obtainWindowView.setLayoutParams(new LinearLayout.LayoutParams(-1, -1));
        }
        obtainWindowView.requestLayout();
    }

    public void chkUseCaptureAnimation(boolean z, int i, boolean z2) {
        StringBuilder sb;
        String str;
        boolean z3;
        if (z) {
            sb = new StringBuilder();
            str = "B页面";
        } else {
            sb = new StringBuilder();
            str = "C页面";
        }
        sb.append(str);
        sb.append(i);
        String sb2 = sb.toString();
        boolean z4 = false;
        if (this.mAccelerationType.equals("none") && !z2) {
            this.mAnimationCapture = false;
        } else if (!this.mAccelerationType.equals(AbsoluteConst.ACCELERATION) && this.mSnapshot == null && this.mNativeView == null && Build.VERSION.SDK_INT >= 23) {
            this.mAnimationCapture = false;
            Logger.e("mabo", sb2 + "1是否启用截图动画方案:" + this.mAnimationCapture);
        } else if (this.mViewOptions.mUniNViewJson != null) {
            this.mAnimationCapture = false;
        } else {
            byte b = this.mAnimOptions.mOption;
            boolean z5 = true;
            boolean z6 = b == 3 || b == 1;
            if (this.mSnapshot == null && this.mNativeView == null && (!obtainWebView().isLoaded() || DeviceInfo.sDeviceSdkVer < 11)) {
                this.mAnimationCapture = false;
                Logger.e("mabo", sb2 + "1是否启用截图动画方案:" + this.mAnimationCapture);
            } else if (this.isChildOfFrameView) {
                this.mAnimationCapture = false;
                Logger.e("mabo", sb2 + "2是否启用截图动画方案:" + this.mAnimationCapture);
            } else {
                PlatformUtil.MESURE_SCREEN_STATUSBAR_HEIGHT(obtainWebView().getActivity());
                if (this.mLastScreenHeight != PlatformUtil.SCREEN_HEIGHT(this.mContext)) {
                    this.mLastScreenHeight = PlatformUtil.SCREEN_HEIGHT(this.mContext);
                    this.mAnimationCapture = false;
                    Logger.e("mabo", sb2 + "3是否启用截图动画方案:" + this.mAnimationCapture);
                    return;
                }
                boolean z7 = (this.mAccelerationType.equals("auto") && !PdrUtil.isEquals(this.mAnimOptions.mAnimType, AnimOptions.ANIM_FADE_IN) && z6 && !PdrUtil.isContains(this.mAnimOptions.mAnimType, "slide")) || this.mAccelerationType.equals(AbsoluteConst.CAPTURE);
                if (!z6) {
                    AnimOptions animOptions = this.mAnimOptions;
                    byte b2 = animOptions.mOption;
                    boolean z8 = b2 == 4 || b2 == 0;
                    if (z7 || PdrUtil.isEquals(animOptions.mAnimType, AnimOptions.ANIM_POP_IN) || PdrUtil.isEquals(this.mAnimOptions.mAnimType, AnimOptions.ANIM_ZOOM_FADE_OUT)) {
                        z4 = true;
                    }
                    z3 = z8 & z4;
                } else {
                    if (z7 || PdrUtil.isEquals(this.mAnimOptions.mAnimType_close, AnimOptions.ANIM_POP_OUT) || PdrUtil.isEquals(this.mAnimOptions.mAnimType, AnimOptions.ANIM_ZOOM_FADE_IN)) {
                        z4 = true;
                    }
                    z3 = true & z4;
                }
                if (this.isChildOfFrameView && PdrUtil.isEquals(this.mAnimOptions.mAnimType, AnimOptions.ANIM_FADE_IN)) {
                    z3 = true;
                }
                if (this.mSnapshot == null && this.mNativeView == null) {
                    z5 = z3;
                }
                this.mAnimationCapture = z5;
            }
        }
    }

    @Override // io.dcloud.common.DHInterface.IFrameView
    public void clearSnapshot(String str) {
        DHImageView dHImageView = this.mPageCImageView;
        if (dHImageView != null) {
            dHImageView.setImageBitmap(null);
        }
        if (TextUtils.isEmpty(str) || !"loading".equals(str.toLowerCase(Locale.ENGLISH))) {
            Bitmap bitmap = this.mSnapshot;
            if (bitmap != null) {
                try {
                    if (!bitmap.isRecycled()) {
                        this.mSnapshot.recycle();
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.mSnapshot = null;
            return;
        }
        Bitmap bitmap2 = this.mLoadingSnapshot;
        if (bitmap2 != null) {
            try {
                if (!bitmap2.isRecycled()) {
                    this.mLoadingSnapshot.recycle();
                }
            } catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        this.mLoadingSnapshot = null;
    }

    public final void dispatchFrameViewEvents(String str, Object obj) {
        if (this.mListeners != null) {
            Logger.d("AdaFrameView.dispatchFrameViewEvents type=" + str + ";args=" + obj);
            for (int size = this.mListeners.size() + -1; size >= 0; size--) {
                IEventCallback iEventCallback = this.mListeners.get(size);
                if (PdrUtil.isEquals(str, AbsoluteConst.EVENTS_CLOSE)) {
                    this.mListeners.remove(size);
                }
                iEventCallback.onCallBack(str, obj);
            }
        }
    }

    @Override // io.dcloud.common.adapter.ui.AdaFrameItem, io.dcloud.common.adapter.ui.AdaContainerFrameItem
    public void dispose() {
        super.dispose();
        if (this.mRefreshView != null) {
            this.mRefreshView = null;
        }
        if (this.mBounceView != null) {
            this.mBounceView = null;
        }
        if (this.mCircleRefreshView != null) {
            this.mCircleRefreshView = null;
        }
    }

    @Override // io.dcloud.common.DHInterface.IFrameView
    public synchronized void draw(final View view, final INativeBitmap iNativeBitmap, final boolean z, final boolean z2, final boolean z3, final Rect rect, final String str, final ICallBack iCallBack, final ICallBack iCallBack2) {
        this.mCaptureHandler.post(new Runnable() {
            /* class io.dcloud.common.adapter.ui.AdaFrameView.AnonymousClass6 */

            public void run() {
                Bitmap bitmap;
                try {
                    if (AdaFrameView.this.getContext() != null) {
                        if (z3) {
                            bitmap = PlatformUtil.captureWebViewContent(view, z, z2, rect, str);
                        } else {
                            bitmap = PlatformUtil.captureView(view, z, z2, rect, str);
                        }
                        if (bitmap != null) {
                            iNativeBitmap.setBitmap(bitmap);
                            AdaFrameView.this.mSucCallBack = iCallBack;
                            AdaFrameView.this.mCaptureHandler.sendEmptyMessage(1);
                            return;
                        }
                        AdaFrameView.this.mErrCallBack = iCallBack2;
                        AdaFrameView adaFrameView = AdaFrameView.this;
                        adaFrameView.sendErrorMessage(-101, adaFrameView.getContext().getString(R.string.dcloud_common_screenshot_blank));
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                    AdaFrameView.this.mErrCallBack = iCallBack2;
                    AdaFrameView adaFrameView2 = AdaFrameView.this;
                    adaFrameView2.sendErrorMessage(-100, adaFrameView2.getContext().getString(R.string.dcloud_common_screenshot_fail));
                }
            }
        });
    }

    @Override // io.dcloud.common.DHInterface.IFrameView
    public IFrameView findPageB() {
        return obtainWebAppRootView().findFrameViewB(this);
    }

    public IRefreshAble getCircleRefreshView() {
        return this.mCircleRefreshView;
    }

    @Override // io.dcloud.common.DHInterface.IFrameView
    public int getFrameType() {
        return this.mFrameType;
    }

    public void handleNativeViewByAction(DHImageView dHImageView, int i) {
        if (!"none".equals(this.mNativeViewAction) && ("hide".equals(this.mNativeViewAction) || AbsoluteConst.EVENTS_CLOSE.equals(this.mNativeViewAction))) {
            String viewUUId = this.mNativeView.getViewUUId();
            String str = this.mNativeViewAction;
            if (str.equalsIgnoreCase("hide")) {
                if (dHImageView != null) {
                    dHImageView.setVisibility(4);
                }
            } else if (this.mNativeViewAction.equalsIgnoreCase(AbsoluteConst.EVENTS_CLOSE)) {
                if (dHImageView != null) {
                    dHImageView.setVisibility(4);
                    dHImageView.setImageBitmap(null);
                    dHImageView.removeNativeView();
                }
                str = "view_close";
            }
            this.mNativeView = null;
            this.mNativeViewAction = "none";
            if (obtainWindowMgr() != null) {
                AbsMgr obtainWindowMgr = obtainWindowMgr();
                IMgr.MgrType mgrType = IMgr.MgrType.FeatureMgr;
                obtainWindowMgr.processEvent(mgrType, 1, new Object[]{obtainWebView(), "nativeobj", str, JSONUtil.createJSONArray("['" + viewUUId + "','" + viewUUId + "']")});
            }
        } else if (i == 1 && dHImageView != null) {
            dHImageView.clearAnimation();
            dHImageView.setVisibility(4);
            dHImageView.setImageBitmap(null);
            dHImageView.removeNativeView();
        }
    }

    /* access modifiers changed from: protected */
    public abstract void initMainView(Context context, int i, Object obj);

    @Override // io.dcloud.common.DHInterface.IFrameView
    public void interceptTouchEvent(boolean z) {
        this.interceptTouchEvent = z;
    }

    public boolean isSupportLongTouch() {
        return false;
    }

    public boolean isTabItem() {
        return this.isTabItem || obtainFrameOptions().isTabItem.booleanValue();
    }

    @Override // io.dcloud.common.DHInterface.IFrameView
    public boolean isWebviewCovered() {
        ViewGroup obtainWindowView;
        IWebview obtainWebView = obtainWebView();
        if (obtainWebView == null || (obtainWindowView = obtainWebView.obtainWindowView()) == null || obtainWindowView.getVisibility() != 0 || obtainWindowView.getParent() == null) {
            return true;
        }
        Rect rect = new Rect(0, 0, PlatformUtil.SCREEN_WIDTH(obtainWindowView.getContext()), PlatformUtil.SCREEN_HEIGHT(obtainWindowView.getContext()));
        Rect rect2 = new Rect();
        obtainWindowView.getGlobalVisibleRect(rect2);
        if (!rect.contains(rect2)) {
            return true;
        }
        while (obtainWindowView.getParent() instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup) obtainWindowView.getParent();
            if (viewGroup.getVisibility() != 0) {
                return true;
            }
            for (int indexOfViewInParent = indexOfViewInParent(obtainWindowView, viewGroup) + 1; indexOfViewInParent < viewGroup.getChildCount(); indexOfViewInParent++) {
                View childAt = viewGroup.getChildAt(indexOfViewInParent);
                if (childAt.getVisibility() == 0 && !(childAt instanceof IWaiter)) {
                    Rect rect3 = new Rect();
                    childAt.getGlobalVisibleRect(rect3);
                    if (rect3.contains(rect2)) {
                        return true;
                    }
                }
            }
            obtainWindowView = viewGroup;
        }
        if (obtainWindowView.getParent() == null) {
            return true;
        }
        return false;
    }

    @Override // io.dcloud.common.DHInterface.IFrameView
    public abstract IApp obtainApp();

    public abstract String obtainPrePlusreadyJs();

    @Override // io.dcloud.common.DHInterface.IFrameViewStatus
    public byte obtainStatus() {
        return this.mFrameStatus;
    }

    @Override // io.dcloud.common.DHInterface.IFrameView
    public abstract IWebview obtainWebView();

    @Override // io.dcloud.common.DHInterface.IFrameView
    public abstract AbsMgr obtainWindowMgr();

    public void onConfigurationChanged() {
    }

    @Override // io.dcloud.common.DHInterface.IFrameViewStatus
    public void onDestroy() {
        this.mFrameStatus = 4;
        transition((byte) 4);
        dispose();
    }

    @Override // io.dcloud.common.adapter.ui.AdaFrameItem, io.dcloud.common.adapter.ui.AdaContainerFrameItem
    public boolean onDispose() {
        boolean onDispose = super.onDispose();
        dispatchFrameViewEvents(AbsoluteConst.EVENTS_CLOSE, obtainWebView());
        DHImageView dHImageView = this.mPageCImageView;
        if (dHImageView != null) {
            dHImageView.setImageBitmap(null);
        }
        return onDispose;
    }

    public void onDrawAfter(Canvas canvas) {
        IRefreshAble iRefreshAble;
        if (obtainMainView() != null && obtainMainView().getVisibility() == 0 && (iRefreshAble = this.mCircleRefreshView) != null && iRefreshAble.isRefreshEnable()) {
            canvas.save();
            int left = obtainWebviewParent().obtainMainView().getLeft();
            int y = (int) ViewHelper.getY(obtainWebviewParent().obtainMainView());
            ViewOptions viewOptions = this.mViewOptions;
            if (viewOptions != null && viewOptions.isStatusbar && viewOptions.titleNView == null) {
                y += DeviceInfo.sStatusBarHeight;
            }
            canvas.translate((float) left, (float) y);
            this.mCircleRefreshView.onSelfDraw(canvas);
            canvas.restore();
        }
    }

    @Override // io.dcloud.common.DHInterface.IFrameViewStatus
    public void onInit() {
        this.mFrameStatus = 0;
    }

    @Override // io.dcloud.common.DHInterface.IFrameViewStatus
    public void onLoading() {
        this.mFrameStatus = 2;
    }

    @Override // io.dcloud.common.DHInterface.IFrameViewStatus
    public void onPreLoading() {
        this.mFrameStatus = 1;
    }

    @Override // io.dcloud.common.DHInterface.IFrameViewStatus
    public void onPreShow(IFrameView iFrameView) {
        this.mFrameStatus = 3;
        transition((byte) 3);
    }

    /* access modifiers changed from: protected */
    @Override // io.dcloud.common.adapter.ui.AdaFrameItem, io.dcloud.common.adapter.ui.AdaContainerFrameItem
    public void onResize() {
        if (obtainApp() != null && obtainApp().manifestBeParsed()) {
            super.onResize();
            RefreshView refreshView = this.mRefreshView;
            if (refreshView != null) {
                refreshView.onResize();
            }
            BounceView bounceView = this.mBounceView;
            if (bounceView != null) {
                bounceView.onResize();
            }
            dispatchFrameViewEvents(AbsoluteConst.EVENTS_FRAME_ONRESIZE, null);
        }
    }

    @Override // io.dcloud.common.adapter.ui.AdaFrameItem
    public void paint(Canvas canvas) {
        super.paint(canvas);
        if (obtainMainView() != null && obtainMainView().getVisibility() == 0 && this.mRefreshView != null && !this.isSlipping) {
            Logger.d(Logger.VIEW_VISIBLE_TAG, "AdaFrameView.paint mRefreshView paint" + this);
            ViewOptions viewOptions = obtainWebviewParent().mViewOptions_birth;
            ViewOptions viewOptions2 = obtainWebviewParent().mViewOptions;
            if (viewOptions == null) {
                viewOptions = this.mViewOptions_birth;
            }
            if (viewOptions2 == null) {
                viewOptions2 = this.mViewOptions;
            }
            int i = viewOptions.left;
            int i2 = viewOptions2.left;
            int i3 = 0;
            if (i == i2) {
                i2 = 0;
            }
            int i4 = viewOptions.top;
            int i5 = viewOptions2.top;
            if (i4 != i5) {
                i3 = i5;
            }
            this.mRefreshView.paint(canvas, i2 + obtainWebviewParent().obtainMainView().getLeft(), (int) (((float) i3) + ViewHelper.getY(obtainWebviewParent().obtainMainView())));
        }
    }

    @Override // io.dcloud.common.DHInterface.IFrameViewStatus
    public final void removeFrameViewListener(IEventCallback iEventCallback) {
        ArrayList<IEventCallback> arrayList = this.mListeners;
        if (arrayList != null) {
            arrayList.remove(iEventCallback);
        }
    }

    @Override // io.dcloud.common.DHInterface.IFrameView
    public void restore() {
        if (obtainMainView() instanceof AbsoluteLayout) {
            ((AbsoluteLayout) obtainMainView()).restore();
        }
    }

    @Override // io.dcloud.common.DHInterface.IFrameView
    public void setAccelerationType(String str) {
        this.mAccelerationType = str;
    }

    public void setCircleRefreshView(IRefreshAble iRefreshAble) {
        this.mCircleRefreshView = iRefreshAble;
    }

    @Override // io.dcloud.common.DHInterface.IFrameView
    public void setSnapshot(Bitmap bitmap) {
        Bitmap bitmap2 = this.mSnapshot;
        if (bitmap2 != null && !bitmap2.isRecycled()) {
            this.mSnapshot.recycle();
        }
        this.mSnapshot = bitmap;
    }

    @Override // io.dcloud.common.DHInterface.IFrameView
    public void setSnapshotView(INativeView iNativeView, String str) {
        this.mNativeView = iNativeView;
        this.mNativeViewAction = str;
    }

    public void setTabItem(boolean z) {
        this.isTabItem = z;
    }

    @Override // io.dcloud.common.DHInterface.IFrameView
    public void setVisible(boolean z, boolean z2) {
        Logger.d(Logger.VIEW_VISIBLE_TAG, "AdaFrameView.setVisible pVisible" + z + "       " + this);
        setVisibility(z ? AdaFrameItem.VISIBLE : AdaFrameItem.INVISIBLE);
    }

    @Override // io.dcloud.common.adapter.ui.AdaFrameItem
    public void startAnimator(int i) {
        startAnimator(null, i);
    }

    @Override // io.dcloud.common.DHInterface.IFrameView
    public void transition(byte b) {
    }

    public void updateFrameRelViewRect(ViewRect viewRect) {
        ViewRect parentViewRect;
        ViewGroup viewGroup = (ViewGroup) obtainMainView();
        if (!this.mViewOptions.hasBackground()) {
            this.mViewOptions.updateViewData(viewRect);
            if (!(viewGroup == null || viewGroup.getVisibility() != 0 || this.mRefreshView == null)) {
                obtainWebviewParent().reInit();
            }
        } else if (obtainWebviewParent().obtainFrameOptions().allowUpdate) {
            obtainWebviewParent().obtainFrameOptions().updateViewData(viewRect);
        }
        ViewOptions viewOptions = this.mViewOptions;
        int i = viewOptions.top;
        int i2 = viewOptions.height;
        if (this.isChildOfFrameView && (parentViewRect = viewOptions.getParentViewRect()) != null && parentViewRect.isStatusbar && !this.mViewOptions.isStatusbar) {
            if (obtainFrameOptions().isBottomAbsolute()) {
                i2 -= DeviceInfo.sStatusBarHeight;
            }
            i += DeviceInfo.sStatusBarHeight;
        }
        View view = this.mViewImpl;
        ViewOptions viewOptions2 = this.mViewOptions;
        AdaFrameItem.LayoutParamsUtil.setViewLayoutParams(view, viewOptions2.left, i, viewOptions2.width, i2);
        changeWebParentViewRect();
        if (viewGroup != null) {
            obtainMainView().invalidate();
        }
    }

    public void startAnimator(final OnAnimationEnd onAnimationEnd, int i) {
        AnimOptions animOptions = this.mAnimOptions;
        if (animOptions != null) {
            animOptions.mUserFrameItem = this;
            animOptions.sScreenWidth = obtainApp().getInt(0);
            this.mAnimOptions.sScreenHeight = obtainApp().getInt(1);
            Animator createAnimation = this.mAnimOptions.createAnimation();
            if (obtainFrameOptions().hasBackground() && this.mAnimOptions.mOption == 2) {
                AdaWebViewParent obtainWebviewParent = obtainWebviewParent();
                this.mAnimOptions.mUserFrameItem = obtainWebviewParent;
                createAnimation.setTarget(obtainWebviewParent.obtainMainView());
                createAnimation.addListener(this.mAnimatorListener);
                createAnimation.start();
            } else if (!captureAnimation(createAnimation, i)) {
                DHImageView dHImageView = this.mPageCImageView;
                if (dHImageView != null && !dHImageView.isSlipping()) {
                    this.mPageCImageView.clearAnimation();
                    this.mPageCImageView.setVisibility(4);
                    this.mPageCImageView.setImageBitmap(null);
                }
                this.mViewImpl.bringToFront();
                Animation animation = this.mAnimOptions.mAnimator;
                if (animation == null) {
                    createAnimation.setTarget(this.mViewImpl);
                    createAnimation.addListener(this.mAnimatorListener);
                    createAnimation.start();
                } else {
                    animation.setAnimationListener(this.mAnimationListener);
                    this.mViewImpl.startAnimation(this.mAnimOptions.mAnimator);
                }
            }
            createAnimation.setInterpolator(new DecelerateInterpolator());
            AnimOptions animOptions2 = this.mAnimOptions;
            MessageHandler.sendMessage(new MessageHandler.IMessages() {
                /* class io.dcloud.common.adapter.ui.AdaFrameView.AnonymousClass3 */

                @Override // io.dcloud.common.adapter.util.MessageHandler.IMessages
                public void execute(Object obj) {
                    Animator.AnimatorListener animatorListener;
                    AdaFrameView adaFrameView = AdaFrameView.this;
                    if (!adaFrameView.mAnimationStarted && (animatorListener = adaFrameView.mAnimatorListener) != null) {
                        animatorListener.onAnimationEnd(null);
                    }
                    OnAnimationEnd onAnimationEnd = onAnimationEnd;
                    if (onAnimationEnd != null) {
                        onAnimationEnd.onDone();
                    }
                    if (BaseInfo.sOpenedCount == 0) {
                        BaseInfo.sFullScreenChanged = false;
                    }
                }
            }, (long) Math.max(animOptions2.duration_show, Math.max(animOptions2.duration_close, animOptions2.duration)), null);
        }
    }
}
