package io.dcloud.common.adapter.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

public class UnicodeInputStream extends InputStream {
    private static final int BOM_SIZE = 4;
    String defaultEnc;
    String encoding;
    PushbackInputStream internalIn;
    boolean isInited = false;

    public UnicodeInputStream(InputStream inputStream, String str) {
        this.internalIn = new PushbackInputStream(inputStream, 4);
        this.defaultEnc = str;
    }

    @Override // java.io.Closeable, java.lang.AutoCloseable, java.io.InputStream
    public void close() throws IOException {
        this.isInited = true;
        this.internalIn.close();
    }

    public String getDefaultEncoding() {
        return this.defaultEnc;
    }

    public String getEncoding() {
        if (!this.isInited) {
            try {
                init();
            } catch (IOException unused) {
                IllegalStateException illegalStateException = new IllegalStateException("Init method failed.");
                illegalStateException.initCause(illegalStateException);
                throw illegalStateException;
            }
        }
        return this.encoding;
    }

    /* access modifiers changed from: protected */
    /* JADX WARNING: Removed duplicated region for block: B:42:0x007c  */
    public void init() throws IOException {
        int i;
        if (!this.isInited) {
            byte[] bArr = new byte[4];
            int read = this.internalIn.read(bArr, 0, 4);
            if (bArr[0] == 0 && bArr[1] == 0 && bArr[2] == -2 && bArr[3] == -1) {
                this.encoding = "UTF-32BE";
            } else if (bArr[0] == -1 && bArr[1] == -2 && bArr[2] == 0 && bArr[3] == 0) {
                this.encoding = "UTF-32LE";
            } else if (bArr[0] == -17 && bArr[1] == -69 && bArr[2] == -65) {
                this.encoding = "UTF-8";
                i = read - 3;
                if (i > 0) {
                }
                this.isInited = true;
            } else {
                if (bArr[0] == -2 && bArr[1] == -1) {
                    this.encoding = "UTF-16BE";
                } else if (bArr[0] == -1 && bArr[1] == -2) {
                    this.encoding = "UTF-16LE";
                } else {
                    this.encoding = this.defaultEnc;
                    i = read;
                    if (i > 0) {
                        this.internalIn.unread(bArr, read - i, i);
                    }
                    this.isInited = true;
                }
                i = read - 2;
                if (i > 0) {
                }
                this.isInited = true;
            }
            i = read - 4;
            if (i > 0) {
            }
            this.isInited = true;
        }
    }

    @Override // java.io.InputStream
    public int read() throws IOException {
        init();
        this.isInited = true;
        return this.internalIn.read();
    }
}
