package io.dcloud.common.adapter.io;

import android.content.Context;
import io.dcloud.application.DCLoudApplicationImpl;
import io.dcloud.common.DHInterface.ICallBack;
import io.dcloud.common.adapter.util.AndroidResources;
import io.dcloud.common.adapter.util.DeviceInfo;
import io.dcloud.common.adapter.util.Logger;
import io.dcloud.common.adapter.util.PlatformUtil;
import io.dcloud.common.util.FileUtil;
import io.dcloud.common.util.IOUtil;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.common.util.ThreadPool;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;

public class DHFile {
    public static final int BUF_SIZE = 204800;
    public static final byte FS_JAR = 0;
    public static final byte FS_NATIVE = 2;
    public static final byte FS_RMS = 1;
    public static final int READ = 1;
    public static final int READ_WRITE = 3;
    private static final String ROOTPATH = "/";
    public static final int WRITE = 2;

    public static void addFile(String str, byte[] bArr) throws IOException {
        Object createFileHandler = createFileHandler(str);
        createNewFile(createFileHandler);
        OutputStream outputStream = getOutputStream(createFileHandler, false);
        if (outputStream != null) {
            try {
                outputStream.write(bArr, 0, bArr.length);
                outputStream.flush();
                outputStream.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean canRead(String str) throws IOException {
        return getFile(getRealPath(str)).canRead();
    }

    private static boolean checkIsNeedReload(String str) {
        return str.endsWith(".png") || str.endsWith(".jpg") || str.endsWith(".xml") || str.endsWith(".bmp");
    }

    public static boolean copyAssetsFile(String str, String str2) {
        boolean z = false;
        InputStream inputStream = null;
        try {
            inputStream = PlatformUtil.getResInputStream(str);
            if (inputStream != null) {
                z = writeFile(inputStream, str2);
            } else if (checkIsNeedReload(str)) {
                Logger.d("PlatFU copyAssetsFile fail ！！！！  is = null < " + str + " > to < " + str2 + " >");
            }
            Logger.d("PlatFU copyAssetsFile < " + str + " > to < " + str2 + " >");
        } catch (Exception e) {
            Logger.d("PlatFU copyAssetsFile " + str2 + " error!!!  is it a dir ?");
            StringBuilder sb = new StringBuilder();
            sb.append("PlatFU copyAssetsFile ");
            sb.append(e);
            Logger.d(sb.toString());
            if (checkIsNeedReload(str)) {
                Logger.d("PlatFU copyAssetsFile fail ！！！！ Exception< " + str + " > to < " + str2 + " >");
            }
        } finally {
            IOUtil.close(inputStream);
        }
        return z;
    }

    public static void copyDir(String str, String str2) {
        if (str != null && str2 != null) {
            try {
                if (str.charAt(0) == '/') {
                    str = str.substring(1, str.length());
                }
                if (str.charAt(str.length() - 1) == '/') {
                    str = str.substring(0, str.length() - 1);
                }
                String[] listResFiles = PlatformUtil.listResFiles(str);
                if (createNewFile(str2) != -1) {
                    for (String str3 : listResFiles) {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append(str);
                        stringBuffer.append('/');
                        stringBuffer.append(str3);
                        String stringBuffer2 = stringBuffer.toString();
                        StringBuffer stringBuffer3 = new StringBuffer();
                        stringBuffer3.append(str2);
                        stringBuffer3.append(str3);
                        String stringBuffer4 = stringBuffer3.toString();
                        if (!copyAssetsFile(stringBuffer2, stringBuffer4)) {
                            if (!checkIsNeedReload(str3)) {
                                copyDir(stringBuffer2, stringBuffer4 + "/");
                            } else if (!copyAssetsFile(stringBuffer2, stringBuffer4) && !copyAssetsFile(stringBuffer2, stringBuffer4)) {
                                Logger.d("PlatFU copyDir fail 3 times!!!!" + stringBuffer2);
                                copyDir(stringBuffer2, stringBuffer4 + "/");
                            }
                        }
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /* JADX WARNING: Removed duplicated region for block: B:94:0x01a2 A[Catch:{ all -> 0x01c4 }] */
    public static int copyFile(String str, String str2, boolean z, boolean z2, ICallBack iCallBack) {
        InputStream inputStream;
        Throwable th;
        OutputStream outputStream;
        Exception e;
        InputStream inputStream2;
        String realPath = getRealPath(str);
        String realPath2 = getRealPath(str2);
        InputStream inputStream3 = null;
        OutputStream outputStream2 = null;
        r5 = null;
        OutputStream outputStream3 = null;
        int i = -1;
        try {
            Context context = DCLoudApplicationImpl.self().getContext();
            if (FileUtil.checkPathAccord(context, realPath2) || AndroidResources.sAppTargetSdkVersion <= 28) {
                if (isExist(realPath2)) {
                    if (z2) {
                        try {
                            Thread.sleep(10);
                        } catch (Exception unused) {
                        }
                        IOUtil.close((InputStream) null);
                        IOUtil.close((OutputStream) null);
                        return -2;
                    } else if (z && !isDirectory(new File(realPath2))) {
                        deleteFile(realPath2);
                    }
                }
                File file = new File(realPath);
                if (!file.exists()) {
                    if (iCallBack != null) {
                        iCallBack.onCallBack(-1, "not file =" + realPath);
                    }
                    try {
                        Thread.sleep(10);
                    } catch (Exception unused2) {
                    }
                    IOUtil.close((InputStream) null);
                    IOUtil.close((OutputStream) null);
                    return -1;
                }
                if (file.isDirectory()) {
                    String[] list = list(file);
                    StringBuilder sb = new StringBuilder();
                    sb.append(realPath);
                    String str3 = File.separator;
                    sb.append(realPath.endsWith(str3) ? "" : str3);
                    String sb2 = sb.toString();
                    StringBuilder sb3 = new StringBuilder();
                    sb3.append(realPath2);
                    if (realPath2.endsWith(str3)) {
                        str3 = "";
                    }
                    sb3.append(str3);
                    String sb4 = sb3.toString();
                    int i2 = -1;
                    for (int i3 = 0; i3 < list.length; i3++) {
                        i2 = copyFile(sb2 + list[i3], sb4 + list[i3], z, z2);
                        if (i2 != 1) {
                            if (iCallBack != null) {
                                iCallBack.onCallBack(i2, "copyFile error src=" + sb2 + list[i3] + " dest=" + sb4 + list[i3]);
                            }
                            try {
                                Thread.sleep(10);
                            } catch (Exception unused3) {
                            }
                            IOUtil.close((InputStream) null);
                            IOUtil.close((OutputStream) null);
                            return i2;
                        }
                    }
                    inputStream = null;
                    i = i2;
                } else {
                    if (FileUtil.checkPathAccord(context, realPath) || AndroidResources.sAppTargetSdkVersion <= 28) {
                        inputStream2 = new FileInputStream(file);
                    } else if (FileUtil.isFilePathForPublic(context, realPath)) {
                        inputStream2 = FileUtil.getFileInputStream(context, file);
                    } else {
                        try {
                            Thread.sleep(10);
                        } catch (Exception unused4) {
                        }
                        IOUtil.close((InputStream) null);
                        IOUtil.close((OutputStream) null);
                        return -3;
                    }
                    inputStream = inputStream2;
                    try {
                        Object createFileHandler = createFileHandler(realPath2);
                        if (!isExist(createFileHandler)) {
                            createNewFile(createFileHandler);
                        }
                        outputStream2 = getOutputStream(createFileHandler);
                        byte[] bArr = new byte[BUF_SIZE];
                        if (inputStream != null) {
                            while (true) {
                                int read = inputStream.read(bArr);
                                if (read <= 0) {
                                    break;
                                }
                                outputStream2.write(bArr, 0, read);
                                outputStream2.flush();
                            }
                            i = 1;
                        }
                    } catch (Exception e2) {
                        e = e2;
                        inputStream3 = inputStream;
                        outputStream = null;
                        try {
                            Logger.i("copyFile:" + e);
                            if (iCallBack != null) {
                            }
                            try {
                                Thread.sleep(10);
                            } catch (Exception unused5) {
                            }
                            IOUtil.close(inputStream3);
                            IOUtil.close(outputStream);
                            return i;
                        } catch (Throwable th2) {
                            th = th2;
                            outputStream3 = outputStream;
                            inputStream = inputStream3;
                            try {
                                Thread.sleep(10);
                            } catch (Exception unused6) {
                            }
                            IOUtil.close(inputStream);
                            IOUtil.close(outputStream3);
                            throw th;
                        }
                    } catch (Throwable th3) {
                        th = th3;
                        Thread.sleep(10);
                        IOUtil.close(inputStream);
                        IOUtil.close(outputStream3);
                        throw th;
                    }
                }
                try {
                    Thread.sleep(10);
                } catch (Exception unused7) {
                }
                IOUtil.close(inputStream);
                IOUtil.close(outputStream2);
                return i;
            }
            try {
                Thread.sleep(10);
            } catch (Exception unused8) {
            }
            IOUtil.close((InputStream) null);
            IOUtil.close((OutputStream) null);
            return -3;
        } catch (Exception e3) {
            e = e3;
            outputStream = null;
            Logger.i("copyFile:" + e);
            if (iCallBack != null) {
                iCallBack.onCallBack(-1, "copyFile error Message=" + e.getMessage());
            }
            Thread.sleep(10);
            IOUtil.close(inputStream3);
            IOUtil.close(outputStream);
            return i;
        } catch (Throwable th4) {
            th = th4;
            inputStream = null;
            Thread.sleep(10);
            IOUtil.close(inputStream);
            IOUtil.close(outputStream3);
            throw th;
        }
    }

    public static Object createFileHandler(String str) {
        return str.replace('\\', '/');
    }

    /* JADX WARNING: Removed duplicated region for block: B:14:0x0043  */
    /* JADX WARNING: Removed duplicated region for block: B:17:0x0061 A[RETURN] */
    /* JADX WARNING: Removed duplicated region for block: B:18:0x0063  */
    public static byte createNewFile(Object obj) {
        boolean z;
        File file;
        File parentFile;
        if (obj == null) {
            return -1;
        }
        boolean z2 = false;
        if (obj instanceof String) {
            String str = (String) obj;
            Logger.d("createNewFile 0:" + str);
            file = new File(str);
            if (str.endsWith("/")) {
                z = true;
                parentFile = file.getParentFile();
                if (!parentFile.exists()) {
                    boolean mkdirs = parentFile.mkdirs();
                    Logger.d("createNewFile: parentPath mkdirs " + mkdirs);
                }
                if (!file.exists()) {
                    return -2;
                }
                if (z) {
                    z2 = file.mkdirs();
                } else {
                    try {
                        z2 = file.createNewFile();
                    } catch (IOException e) {
                        Logger.w("createNewFile:", e);
                    }
                }
                if (z2) {
                    return 1;
                }
                return -1;
            }
        } else if (!(obj instanceof File)) {
            return -1;
        } else {
            file = (File) obj;
        }
        z = false;
        parentFile = file.getParentFile();
        if (!parentFile.exists()) {
        }
        if (!file.exists()) {
        }
    }

    public static boolean delete(Object obj) {
        boolean z;
        if (obj == null) {
            return false;
        }
        try {
            File file = getFile(obj);
            if (!file.exists()) {
                return false;
            }
            if (file.isFile()) {
                return file.delete();
            }
            File[] listFiles = file.listFiles();
            if (listFiles != null && listFiles.length > 0) {
                for (int i = 0; i < listFiles.length; i++) {
                    Logger.d("delete:" + listFiles[i].getPath());
                    if (listFiles[i].isDirectory()) {
                        z = delete(file.getPath() + "/" + listFiles[i].getName());
                    } else {
                        z = listFiles[i].delete();
                        Thread.sleep(2);
                    }
                    if (!z) {
                        return false;
                    }
                }
            }
            boolean delete = file.delete();
            Logger.i("delete " + obj + ":" + String.valueOf(delete));
            return delete;
        } catch (Exception e) {
            Logger.w("DHFile.delete", e);
            return false;
        }
    }

    public static void deleteAsync(final Object obj, final IAsyncCallback iAsyncCallback) {
        if (iAsyncCallback != null) {
            if (obj == null) {
                iAsyncCallback.done(false);
                return;
            }
            try {
                ThreadPool.self().addSingleThreadTask(new Runnable() {
                    /* class io.dcloud.common.adapter.io.DHFile.AnonymousClass1 */

                    public void run() {
                        boolean z;
                        try {
                            File file = DHFile.getFile(obj);
                            if (!file.exists()) {
                                iAsyncCallback.done(false);
                            } else if (file.isFile()) {
                                iAsyncCallback.done(file.delete());
                            } else {
                                File[] listFiles = file.listFiles();
                                if (listFiles != null && listFiles.length > 0) {
                                    for (int i = 0; i < listFiles.length; i++) {
                                        if (listFiles[i].isDirectory()) {
                                            z = DHFile.delete(file.getPath() + "/" + listFiles[i].getName());
                                        } else {
                                            z = listFiles[i].delete();
                                        }
                                        if (!z) {
                                            iAsyncCallback.done(false);
                                            return;
                                        }
                                    }
                                }
                                iAsyncCallback.done(file.delete());
                            }
                        } catch (Exception e) {
                            Logger.w("DHFile.delete", e);
                            iAsyncCallback.done(false);
                        }
                    }
                });
            } catch (Exception unused) {
                iAsyncCallback.done(false);
            }
        }
    }

    public static int deleteFile(String str) throws IOException {
        return delete(new File(getRealPath(str))) ? 1 : -1;
    }

    public static boolean exists(Object obj) {
        boolean z;
        if (obj instanceof String) {
            try {
                String str = (String) obj;
                if (str.endsWith("/")) {
                    str = str.substring(0, str.length() - 1);
                }
                z = new File(str).exists();
            } catch (Exception unused) {
                return false;
            }
        } else if (!(obj instanceof File)) {
            return false;
        } else {
            z = ((File) obj).exists();
        }
        return z;
    }

    /* access modifiers changed from: private */
    public static File getFile(Object obj) {
        if (obj instanceof String) {
            String str = (String) obj;
            if (str.endsWith("/")) {
                str = str.substring(0, str.length() - 1);
            }
            return new File(str);
        } else if (obj instanceof File) {
            return (File) obj;
        } else {
            return null;
        }
    }

    public static String getFileName(Object obj) {
        return getName(obj);
    }

    public static String getFilePath(Object obj) {
        return getPath(obj);
    }

    public static long getFileSize(File file) {
        long j = 0;
        if (!file.isDirectory()) {
            return 0 + file.length();
        }
        for (File file2 : file.listFiles()) {
            j += getFileSize(file2);
        }
        return j;
    }

    public static String getFileUrl(Object obj) {
        return getPath(obj);
    }

    public static InputStream getInputStream(Object obj) throws IOException {
        File file;
        if (obj instanceof String) {
            String str = (String) obj;
            if (str.startsWith(DeviceInfo.FILE_PROTOCOL)) {
                str = str.substring(7);
            }
            file = new File(str);
        } else {
            file = obj instanceof File ? (File) obj : null;
        }
        if (file == null || !file.exists() || file.isDirectory()) {
            return null;
        }
        try {
            return new FileInputStream(file);
        } catch (FileNotFoundException unused) {
            Logger.e("DHFile getInputStream not found file: " + file.getPath());
            return null;
        } catch (SecurityException e) {
            Logger.w("getInputStream2", e);
            return null;
        }
    }

    public static long getLastModify(String str) throws IOException {
        File file = new File(getRealPath(str));
        if (file.exists()) {
            return file.lastModified();
        }
        return 0;
    }

    public static String getName(Object obj) {
        if (!(obj instanceof String)) {
            return ((File) obj).getName();
        }
        String str = (String) obj;
        if (str.endsWith("/")) {
            str = str.substring(0, str.length() - 1);
        }
        return str.substring(str.lastIndexOf(47) + 1);
    }

    public static OutputStream getOutputStream(Object obj) throws IOException {
        File file;
        if (obj instanceof String) {
            file = new File((String) obj);
        } else {
            file = obj instanceof File ? (File) obj : null;
        }
        if (file == null) {
            return null;
        }
        if (file.canWrite()) {
            try {
                return new FileOutputStream(file);
            } catch (FileNotFoundException e) {
                Logger.w("getOutputStream:", e);
                return null;
            }
        } else {
            Logger.i("getOutputStream:can not write");
            return null;
        }
    }

    public static Object getParent(Object obj) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(getPath(obj));
        if (((File) obj).isDirectory()) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        stringBuffer.delete(stringBuffer.toString().lastIndexOf(47), stringBuffer.length());
        return createFileHandler(stringBuffer.toString());
    }

    public static String getPath(Object obj) {
        if (obj instanceof String) {
            String str = (String) obj;
            return str.substring(0, str.lastIndexOf(47) + 1);
        } else if (obj instanceof File) {
            return ((File) obj).getPath();
        } else {
            return null;
        }
    }

    private static String getRealPath(String str) {
        String str2 = DeviceInfo.sBaseFsRootPath;
        StringBuffer stringBuffer = new StringBuffer();
        if ("".equals(str)) {
            return str2;
        }
        try {
            char[] charArray = str.toCharArray();
            int i = 0;
            while (i < charArray.length) {
                int i2 = 3;
                if ((charArray[0] == 'C' || charArray[0] == 'c') && i == 0) {
                    stringBuffer.append(str2);
                    i = 3;
                }
                if ((charArray[0] == 'D' || charArray[0] == 'd') && i == 0) {
                    stringBuffer.append(str2);
                } else {
                    i2 = i;
                }
                if (charArray[i2] == '\\') {
                    stringBuffer.append('/');
                } else {
                    stringBuffer.append(charArray[i2]);
                }
                i = i2 + 1;
            }
            return stringBuffer.toString();
        } catch (ArrayIndexOutOfBoundsException unused) {
            return str;
        }
    }

    public static boolean hasFile() {
        return false;
    }

    public static boolean isDirectory(Object obj) throws IOException {
        return ((File) obj).isDirectory();
    }

    public static boolean isExist(String str) throws IOException {
        return exists(getFile(getRealPath(str)));
    }

    public static boolean isHidden(Object obj) throws IOException {
        File file = getFile(obj);
        if (file == null) {
            return false;
        }
        return file.isHidden();
    }

    public static long length(Object obj) {
        try {
            return ((File) obj).length();
        } catch (Exception e) {
            Logger.w("length:", e);
            return -1;
        }
    }

    public static String[] list(Object obj) throws IOException {
        Object[] listFiles = listFiles(obj);
        if (listFiles == null) {
            return null;
        }
        String[] strArr = new String[listFiles.length];
        for (int i = 0; i < listFiles.length; i++) {
            File file = (File) listFiles[i];
            if (file.isDirectory()) {
                strArr[i] = file.getName() + "/";
            } else {
                strArr[i] = file.getName();
            }
        }
        return strArr;
    }

    public static String[] listDir(Object obj) throws IOException {
        Object[] listFiles = listFiles(obj);
        if (listFiles == null) {
            return null;
        }
        String[] strArr = new String[listFiles.length];
        for (int i = 0; i < listFiles.length; i++) {
            File file = (File) listFiles[i];
            if (file.isDirectory()) {
                strArr[i] = file.getName() + "/";
            }
        }
        return strArr;
    }

    public static Object[] listFiles(Object obj) throws IOException {
        File file;
        if (obj instanceof String) {
            file = new File((String) obj);
        } else {
            file = obj instanceof File ? (File) obj : null;
        }
        if (file == null) {
            return null;
        }
        file.isDirectory();
        try {
            return file.listFiles();
        } catch (Exception e) {
            Logger.w("listFiles:", e);
            return null;
        }
    }

    public static List<String> listFilesWithName(Object obj, final String str) {
        File[] listFiles;
        ArrayList arrayList = new ArrayList();
        if (str == null) {
            return arrayList;
        }
        File file = null;
        if (obj instanceof String) {
            file = new File((String) obj);
        } else if (obj instanceof File) {
            file = (File) obj;
        }
        if (file == null || !file.exists() || !file.isDirectory() || (listFiles = file.listFiles(new FilenameFilter() {
            /* class io.dcloud.common.adapter.io.DHFile.AnonymousClass3 */

            public boolean accept(File file, String str) {
                return new File(file, str).isDirectory() || str.equals(str);
            }
        })) == null) {
            return arrayList;
        }
        for (File file2 : listFiles) {
            if (file2.isDirectory()) {
                arrayList.addAll(listFilesWithName(file2, str));
            } else {
                arrayList.add(file2.getPath());
            }
        }
        return arrayList;
    }

    public static List<String> listFilesWithSuffix(Object obj, final String str) {
        File[] listFiles;
        ArrayList arrayList = new ArrayList();
        if (str == null) {
            return arrayList;
        }
        File file = null;
        if (obj instanceof String) {
            file = new File((String) obj);
        } else if (obj instanceof File) {
            file = (File) obj;
        }
        if (file == null || !file.exists() || !file.isDirectory() || (listFiles = file.listFiles(new FilenameFilter() {
            /* class io.dcloud.common.adapter.io.DHFile.AnonymousClass2 */

            public boolean accept(File file, String str) {
                return new File(file, str).isDirectory() || str.toLowerCase().endsWith(str);
            }
        })) == null) {
            return arrayList;
        }
        for (File file2 : listFiles) {
            if (file2.isDirectory()) {
                arrayList.addAll(listFilesWithSuffix(file2, str));
            } else {
                arrayList.add(file2.getPath());
            }
        }
        return arrayList;
    }

    public static String[] listRoot() throws IOException {
        return new File("/").list();
    }

    protected static Object openFile(String str, int i, boolean z) throws IOException {
        return createFileHandler(getRealPath(str));
    }

    /* JADX WARNING: Removed duplicated region for block: B:27:0x0032  */
    /* JADX WARNING: Removed duplicated region for block: B:32:0x003f  */
    /* JADX WARNING: Removed duplicated region for block: B:37:0x005f  */
    /* JADX WARNING: Removed duplicated region for block: B:41:0x0069 A[SYNTHETIC, Splitter:B:41:0x0069] */
    public static byte[] readAll(Object obj) {
        InputStream inputStream;
        Throwable th;
        FileNotFoundException e;
        SecurityException e2;
        IOException e3;
        try {
            inputStream = getInputStream(obj);
            if (inputStream != null) {
                try {
                    byte[] bytes = IOUtil.getBytes(inputStream);
                    try {
                        inputStream.close();
                    } catch (IOException e4) {
                        e4.printStackTrace();
                    }
                    return bytes;
                } catch (FileNotFoundException e5) {
                    e = e5;
                    Logger.i("readAll 0:" + e.getLocalizedMessage());
                    if (inputStream != null) {
                    }
                    return null;
                } catch (SecurityException e6) {
                    e2 = e6;
                    Logger.w("readAll 1:", e2);
                    if (inputStream != null) {
                    }
                    return null;
                } catch (IOException e7) {
                    e3 = e7;
                    try {
                        Logger.w("readAll 2:", e3);
                        if (inputStream != null) {
                        }
                        return null;
                    } catch (Throwable th2) {
                        th = th2;
                        if (inputStream != null) {
                        }
                        throw th;
                    }
                }
            } else {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    } catch (IOException e8) {
                        e8.printStackTrace();
                    }
                }
                return null;
            }
        } catch (FileNotFoundException e9) {
            e = e9;
            inputStream = null;
            Logger.i("readAll 0:" + e.getLocalizedMessage());
            if (inputStream != null) {
                inputStream.close();
            }
            return null;
        } catch (SecurityException e10) {
            e2 = e10;
            inputStream = null;
            Logger.w("readAll 1:", e2);
            if (inputStream != null) {
                inputStream.close();
            }
            return null;
        } catch (IOException e11) {
            e3 = e11;
            inputStream = null;
            Logger.w("readAll 2:", e3);
            if (inputStream != null) {
                inputStream.close();
            }
            return null;
        } catch (Throwable th3) {
            th = th3;
            inputStream = null;
            if (inputStream != null) {
                try {
                    inputStream.close();
                } catch (IOException e12) {
                    e12.printStackTrace();
                }
            }
            throw th;
        }
    }

    public static int rename(String str, String str2) throws IOException {
        String str3;
        String realPath = getRealPath(str);
        if (realPath.endsWith("/")) {
            if (!str2.endsWith("/")) {
                str2 = str2 + "/";
            }
            str3 = realPath.substring(0, realPath.length() - 1);
        } else {
            str3 = null;
        }
        if (str3 == null) {
            return -1;
        }
        if (!PdrUtil.isDeviceRootDir(str2)) {
            str2 = str3.substring(0, str3.lastIndexOf("/") + 1) + str2;
        }
        String realPath2 = getRealPath(str2);
        File file = new File(realPath);
        if (file.exists()) {
            File file2 = new File(realPath2);
            if (!file2.exists() && file.renameTo(file2)) {
                return 1;
            }
        }
        return -1;
    }

    public static boolean writeFile(InputStream inputStream, String str) throws IOException {
        Throwable th;
        FileOutputStream fileOutputStream;
        Exception e;
        File file = new File(str);
        File parentFile = file.getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        FileOutputStream fileOutputStream2 = null;
        boolean z = false;
        try {
            fileOutputStream = new FileOutputStream(file);
            if (inputStream != null) {
                try {
                    byte[] bArr = new byte[BUF_SIZE];
                    while (true) {
                        int read = inputStream.read(bArr);
                        if (read <= 0) {
                            break;
                        }
                        fileOutputStream.write(bArr, 0, read);
                    }
                    z = true;
                } catch (Exception e2) {
                    e = e2;
                    fileOutputStream2 = fileOutputStream;
                    try {
                        e.printStackTrace();
                        fileOutputStream = fileOutputStream2;
                        IOUtil.close(fileOutputStream);
                        return z;
                    } catch (Throwable th2) {
                        th = th2;
                        IOUtil.close(fileOutputStream2);
                        throw th;
                    }
                } catch (Throwable th3) {
                    th = th3;
                    fileOutputStream2 = fileOutputStream;
                    IOUtil.close(fileOutputStream2);
                    throw th;
                }
            }
        } catch (Exception e3) {
            e = e3;
            e.printStackTrace();
            fileOutputStream = fileOutputStream2;
            IOUtil.close(fileOutputStream);
            return z;
        }
        IOUtil.close(fileOutputStream);
        return z;
    }

    public static Object openFile(String str, int i) throws IOException {
        return openFile(str, i, false);
    }

    public static boolean isExist(Object obj) throws IOException {
        File file = getFile(obj);
        if (file == null) {
            return false;
        }
        return file.exists();
    }

    public static boolean isHidden(String str) throws IOException {
        File file = new File(getRealPath(str));
        if (file.exists()) {
            return isHidden(file);
        }
        return false;
    }

    public static OutputStream getOutputStream(Object obj, boolean z) throws IOException {
        File file;
        if (obj instanceof String) {
            file = new File((String) obj);
        } else {
            file = obj instanceof File ? (File) obj : null;
        }
        if (file == null) {
            return null;
        }
        if (file.canWrite()) {
            try {
                return new FileOutputStream(file, z);
            } catch (FileNotFoundException e) {
                Logger.w("getOutputStream:", e);
                return null;
            }
        } else {
            Logger.i("getOutputStream:can not write");
            return null;
        }
    }

    public static void writeFile(byte[] bArr, int i, String str) {
        File file = new File(str);
        File parentFile = file.getParentFile();
        if (!parentFile.exists() && !parentFile.mkdirs()) {
            Logger.i(str + "cannot create!");
        } else if (file.exists()) {
            try {
                RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rws");
                randomAccessFile.setLength((long) (bArr.length + i));
                randomAccessFile.seek((long) i);
                randomAccessFile.write(bArr);
                randomAccessFile.close();
            } catch (FileNotFoundException e) {
                e.printStackTrace();
            } catch (IOException e2) {
                e2.printStackTrace();
            }
        } else {
            try {
                file.createNewFile();
            } catch (IOException e3) {
                e3.printStackTrace();
            }
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(file);
            } catch (FileNotFoundException e4) {
                e4.printStackTrace();
            }
            if (fileOutputStream != null) {
                if (bArr != null) {
                    try {
                        fileOutputStream.write(bArr, 0, bArr.length);
                        fileOutputStream.flush();
                    } catch (IOException e5) {
                        e5.printStackTrace();
                        try {
                            fileOutputStream.close();
                            return;
                        } catch (IOException e6) {
                            e6.printStackTrace();
                            return;
                        }
                    } catch (Throwable th) {
                        try {
                            fileOutputStream.close();
                        } catch (IOException e7) {
                            e7.printStackTrace();
                        }
                        throw th;
                    }
                }
                fileOutputStream.close();
            }
        }
    }

    public static void writeFile(InputStream inputStream, int i, String str) {
        File file = new File(str);
        File parentFile = file.getParentFile();
        if (!parentFile.exists() && !parentFile.mkdirs()) {
            Logger.i(str + "cannot create!");
        } else if (file.exists()) {
            try {
                RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rws");
                randomAccessFile.seek(file.length());
                byte[] bArr = new byte[8192];
                while (true) {
                    int read = inputStream.read(bArr, 0, 8192);
                    if (read != -1) {
                        randomAccessFile.write(bArr, 0, read);
                    } else {
                        randomAccessFile.close();
                        return;
                    }
                }
            } catch (FileNotFoundException e) {
                e.printStackTrace();
            } catch (IOException e2) {
                e2.printStackTrace();
            }
        } else {
            try {
                file.createNewFile();
            } catch (IOException e3) {
                e3.printStackTrace();
            }
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(file);
            } catch (FileNotFoundException e4) {
                e4.printStackTrace();
            }
            if (fileOutputStream != null) {
                try {
                    byte[] bArr2 = new byte[8192];
                    while (true) {
                        int read2 = inputStream.read(bArr2, 0, 8192);
                        if (read2 != -1) {
                            fileOutputStream.write(bArr2, 0, read2);
                        } else {
                            try {
                                fileOutputStream.close();
                                return;
                            } catch (IOException e5) {
                                e5.printStackTrace();
                                return;
                            }
                        }
                    }
                } catch (IOException e6) {
                    e6.printStackTrace();
                    fileOutputStream.close();
                } catch (Throwable th) {
                    try {
                        fileOutputStream.close();
                    } catch (IOException e7) {
                        e7.printStackTrace();
                    }
                    throw th;
                }
            }
        }
    }

    public static int copyFile(String str, String str2) {
        return copyFile(str, str2, false, false, null);
    }

    public static int copyFile(String str, String str2, ICallBack iCallBack) {
        return copyFile(str, str2, false, false, iCallBack);
    }

    public static int copyFile(String str, String str2, boolean z, boolean z2) {
        return copyFile(str, str2, z, z2, null);
    }
}
