package io.dcloud.common.DHInterface;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.NinePatch;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.NinePatchDrawable;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import io.dcloud.PdrR;
import io.dcloud.common.adapter.util.DeviceInfo;
import io.dcloud.common.adapter.util.Logger;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.feature.internal.splash.ISplash;

public class SplashView extends RelativeLayout {
    public static int STYLE_BLACK = 1;
    public static int STYLE_DEFAULT = 0;
    public static int STYLE_WHITE = 2;
    final String TAG = "SplashView";
    private boolean hasAdSplash = false;
    protected boolean mShowSplashScreen = false;
    protected boolean mShowSplashWaiting = false;
    int screenHeight;
    int screenWidth;
    boolean showBitmap = false;

    public SplashView(Context context, Bitmap bitmap) {
        super(context);
        Drawable drawable;
        setBackgroundColor(-1);
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        this.screenWidth = displayMetrics.widthPixels;
        this.screenHeight = displayMetrics.heightPixels;
        if (NinePatch.isNinePatchChunk(bitmap.getNinePatchChunk())) {
            drawable = new NinePatchDrawable(context.getResources(), bitmap, bitmap.getNinePatchChunk(), new Rect(), null);
        } else {
            drawable = new BitmapDrawable(context.getResources(), bitmap);
        }
        if (Build.VERSION.SDK_INT < 16) {
            setBackgroundDrawable(drawable);
        } else {
            setBackground(drawable);
        }
    }

    @Override // android.view.ViewGroup
    public void addView(View view, int i, ViewGroup.LayoutParams layoutParams) {
        super.addView(view, i, layoutParams);
        if (view instanceof ISplash) {
            this.hasAdSplash = true;
        }
    }

    /* access modifiers changed from: protected */
    public void dispatchDraw(Canvas canvas) {
        if (DeviceInfo.sStatusBarHeight <= 0) {
            Logger.d("SplashView", "paint() before DeviceInfo.updateScreenInfo()");
            DeviceInfo.updateStatusBarHeight((Activity) getContext());
        }
        Logger.d("SplashView", "dispatchDraw.....");
        super.dispatchDraw(canvas);
    }

    public boolean dispatchTouchEvent(MotionEvent motionEvent) {
        if (this.hasAdSplash) {
            return super.dispatchTouchEvent(motionEvent);
        }
        return true;
    }

    /* access modifiers changed from: protected */
    public void onShowProgressBar(ViewGroup viewGroup, int i) {
        if (!this.hasAdSplash) {
            Logger.d(Logger.MAIN_TAG, "showWaiting style=" + i);
            ProgressBar progressBar = new ProgressBar(getContext());
            int parseInt = PdrUtil.parseInt("7%", this.screenWidth, -1);
            setGravity(17);
            Drawable drawable = null;
            if (i == STYLE_BLACK) {
                drawable = getContext().getResources().getDrawable(PdrR.DRAWBLE_PROGRESSBAR_BLACK_SNOW);
            } else if (i == STYLE_WHITE) {
                drawable = getContext().getResources().getDrawable(PdrR.DRAWBLE_PROGRESSBAR_WHITE_SNOW);
            }
            if (drawable != null) {
                progressBar.setIndeterminateDrawable(drawable);
            }
            viewGroup.addView(progressBar, new RelativeLayout.LayoutParams(parseInt, parseInt));
            Logger.d(Logger.MAIN_TAG, "onShowProgressBar");
        }
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        return true;
    }

    public void showWaiting() {
        showWaiting(STYLE_DEFAULT);
    }

    public void showWaiting(final int i) {
        post(new Runnable() {
            /* class io.dcloud.common.DHInterface.SplashView.AnonymousClass1 */

            public void run() {
                SplashView splashView = SplashView.this;
                splashView.onShowProgressBar(splashView, i);
            }
        });
    }
}
