package dc.squareup.okio;

import tv.danmaku.ijk.media.player.IjkMediaMeta;

/* access modifiers changed from: package-private */
public final class SegmentPool {
    static final long MAX_SIZE = 65536;
    static long byteCount;
    static Segment next;

    private SegmentPool() {
    }

    static void recycle(Segment segment) {
        if (segment.next != null || segment.prev != null) {
            throw new IllegalArgumentException();
        } else if (!segment.shared) {
            synchronized (SegmentPool.class) {
                long j = byteCount + IjkMediaMeta.AV_CH_TOP_FRONT_CENTER;
                if (j <= 65536) {
                    byteCount = j;
                    segment.next = next;
                    segment.limit = 0;
                    segment.pos = 0;
                    next = segment;
                }
            }
        }
    }

    static Segment take() {
        synchronized (SegmentPool.class) {
            Segment segment = next;
            if (segment == null) {
                return new Segment();
            }
            next = segment.next;
            segment.next = null;
            byteCount -= IjkMediaMeta.AV_CH_TOP_FRONT_CENTER;
            return segment;
        }
    }
}
