package dc.squareup.okhttp3.internal.cache2;

import dc.squareup.okhttp3.internal.Util;
import dc.squareup.okio.Buffer;
import dc.squareup.okio.ByteString;
import dc.squareup.okio.Source;
import dc.squareup.okio.Timeout;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

final class Relay {
    private static final long FILE_HEADER_SIZE = 32;
    static final ByteString PREFIX_CLEAN = ByteString.encodeUtf8("OkHttp cache v1\n");
    static final ByteString PREFIX_DIRTY = ByteString.encodeUtf8("OkHttp DIRTY :(\n");
    private static final int SOURCE_FILE = 2;
    private static final int SOURCE_UPSTREAM = 1;
    final Buffer buffer = new Buffer();
    final long bufferMaxSize;
    boolean complete;
    RandomAccessFile file;
    private final ByteString metadata;
    int sourceCount;
    Source upstream;
    final Buffer upstreamBuffer = new Buffer();
    long upstreamPos;
    Thread upstreamReader;

    class RelaySource implements Source {
        private FileOperator fileOperator;
        private long sourcePos;
        private final Timeout timeout = new Timeout();

        RelaySource() {
            this.fileOperator = new FileOperator(Relay.this.file.getChannel());
        }

        @Override // java.io.Closeable, dc.squareup.okio.Source, java.lang.AutoCloseable
        public void close() throws IOException {
            if (this.fileOperator != null) {
                RandomAccessFile randomAccessFile = null;
                this.fileOperator = null;
                synchronized (Relay.this) {
                    Relay relay = Relay.this;
                    int i = relay.sourceCount - 1;
                    relay.sourceCount = i;
                    if (i == 0) {
                        RandomAccessFile randomAccessFile2 = relay.file;
                        relay.file = null;
                        randomAccessFile = randomAccessFile2;
                    }
                }
                if (randomAccessFile != null) {
                    Util.closeQuietly(randomAccessFile);
                }
            }
        }

        /* JADX WARNING: Code restructure failed: missing block: B:20:0x0040, code lost:
            r0 = 2;
         */
        @Override // dc.squareup.okio.Source
        public long read(Buffer buffer, long j) throws IOException {
            long j2;
            char c;
            Relay relay;
            if (this.fileOperator != null) {
                synchronized (Relay.this) {
                    while (true) {
                        long j3 = this.sourcePos;
                        Relay relay2 = Relay.this;
                        j2 = relay2.upstreamPos;
                        if (j3 != j2) {
                            long size = j2 - relay2.buffer.size();
                            long j4 = this.sourcePos;
                            if (j4 >= size) {
                                long min = Math.min(j, j2 - j4);
                                Relay.this.buffer.copyTo(buffer, this.sourcePos - size, min);
                                this.sourcePos += min;
                                return min;
                            }
                        } else if (relay2.complete) {
                            return -1;
                        } else {
                            if (relay2.upstreamReader != null) {
                                this.timeout.waitUntilNotified(relay2);
                            } else {
                                relay2.upstreamReader = Thread.currentThread();
                                c = 1;
                            }
                        }
                    }
                    if (c == 2) {
                        long min2 = Math.min(j, j2 - this.sourcePos);
                        this.fileOperator.read(this.sourcePos + 32, buffer, min2);
                        this.sourcePos += min2;
                        return min2;
                    }
                    try {
                        Relay relay3 = Relay.this;
                        long read = relay3.upstream.read(relay3.upstreamBuffer, relay3.bufferMaxSize);
                        if (read == -1) {
                            Relay.this.commit(j2);
                            synchronized (Relay.this) {
                                Relay relay4 = Relay.this;
                                relay4.upstreamReader = null;
                                relay4.notifyAll();
                            }
                            return -1;
                        }
                        long min3 = Math.min(read, j);
                        Relay.this.upstreamBuffer.copyTo(buffer, 0, min3);
                        this.sourcePos += min3;
                        this.fileOperator.write(j2 + 32, Relay.this.upstreamBuffer.clone(), read);
                        synchronized (Relay.this) {
                            Relay relay5 = Relay.this;
                            relay5.buffer.write(relay5.upstreamBuffer, read);
                            long size2 = Relay.this.buffer.size();
                            Relay relay6 = Relay.this;
                            if (size2 > relay6.bufferMaxSize) {
                                Buffer buffer2 = relay6.buffer;
                                buffer2.skip(buffer2.size() - Relay.this.bufferMaxSize);
                            }
                            relay = Relay.this;
                            relay.upstreamPos += read;
                        }
                        synchronized (relay) {
                            Relay relay7 = Relay.this;
                            relay7.upstreamReader = null;
                            relay7.notifyAll();
                        }
                        return min3;
                    } catch (Throwable th) {
                        synchronized (Relay.this) {
                            Relay relay8 = Relay.this;
                            relay8.upstreamReader = null;
                            relay8.notifyAll();
                            throw th;
                        }
                    }
                }
            } else {
                throw new IllegalStateException("closed");
            }
        }

        @Override // dc.squareup.okio.Source
        public Timeout timeout() {
            return this.timeout;
        }
    }

    private Relay(RandomAccessFile randomAccessFile, Source source, long j, ByteString byteString, long j2) {
        this.file = randomAccessFile;
        this.upstream = source;
        this.complete = source == null;
        this.upstreamPos = j;
        this.metadata = byteString;
        this.bufferMaxSize = j2;
    }

    public static Relay edit(File file2, Source source, ByteString byteString, long j) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(file2, "rw");
        Relay relay = new Relay(randomAccessFile, source, 0, byteString, j);
        randomAccessFile.setLength(0);
        relay.writeHeader(PREFIX_DIRTY, -1, -1);
        return relay;
    }

    public static Relay read(File file2) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(file2, "rw");
        FileOperator fileOperator = new FileOperator(randomAccessFile.getChannel());
        Buffer buffer2 = new Buffer();
        fileOperator.read(0, buffer2, 32);
        ByteString byteString = PREFIX_CLEAN;
        if (buffer2.readByteString((long) byteString.size()).equals(byteString)) {
            long readLong = buffer2.readLong();
            long readLong2 = buffer2.readLong();
            Buffer buffer3 = new Buffer();
            fileOperator.read(readLong + 32, buffer3, readLong2);
            return new Relay(randomAccessFile, null, readLong, buffer3.readByteString(), 0);
        }
        throw new IOException("unreadable cache file");
    }

    private void writeHeader(ByteString byteString, long j, long j2) throws IOException {
        Buffer buffer2 = new Buffer();
        buffer2.write(byteString);
        buffer2.writeLong(j);
        buffer2.writeLong(j2);
        if (buffer2.size() == 32) {
            new FileOperator(this.file.getChannel()).write(0, buffer2, 32);
            return;
        }
        throw new IllegalArgumentException();
    }

    private void writeMetadata(long j) throws IOException {
        Buffer buffer2 = new Buffer();
        buffer2.write(this.metadata);
        new FileOperator(this.file.getChannel()).write(32 + j, buffer2, (long) this.metadata.size());
    }

    /* access modifiers changed from: package-private */
    public void commit(long j) throws IOException {
        writeMetadata(j);
        this.file.getChannel().force(false);
        writeHeader(PREFIX_CLEAN, j, (long) this.metadata.size());
        this.file.getChannel().force(false);
        synchronized (this) {
            this.complete = true;
        }
        Util.closeQuietly(this.upstream);
        this.upstream = null;
    }

    /* access modifiers changed from: package-private */
    public boolean isClosed() {
        return this.file == null;
    }

    public ByteString metadata() {
        return this.metadata;
    }

    public Source newSource() {
        synchronized (this) {
            if (this.file == null) {
                return null;
            }
            this.sourceCount++;
            return new RelaySource();
        }
    }
}
