package dc.squareup.okhttp3.internal.cache;

import dc.squareup.okio.Buffer;
import dc.squareup.okio.ForwardingSink;
import dc.squareup.okio.Sink;
import java.io.IOException;

class FaultHidingSink extends ForwardingSink {
    private boolean hasErrors;

    FaultHidingSink(Sink sink) {
        super(sink);
    }

    @Override // dc.squareup.okio.Sink, java.io.Closeable, java.lang.AutoCloseable, dc.squareup.okio.ForwardingSink
    public void close() throws IOException {
        if (!this.hasErrors) {
            try {
                super.close();
            } catch (IOException e) {
                this.hasErrors = true;
                onException(e);
            }
        }
    }

    @Override // dc.squareup.okio.Sink, dc.squareup.okio.ForwardingSink, java.io.Flushable
    public void flush() throws IOException {
        if (!this.hasErrors) {
            try {
                super.flush();
            } catch (IOException e) {
                this.hasErrors = true;
                onException(e);
            }
        }
    }

    /* access modifiers changed from: protected */
    public void onException(IOException iOException) {
    }

    @Override // dc.squareup.okio.Sink, dc.squareup.okio.ForwardingSink
    public void write(Buffer buffer, long j) throws IOException {
        if (this.hasErrors) {
            buffer.skip(j);
            return;
        }
        try {
            super.write(buffer, j);
        } catch (IOException e) {
            this.hasErrors = true;
            onException(e);
        }
    }
}
