package com.taobao.weex.utils;

import android.app.Application;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import android.text.TextUtils;
import com.taobao.weex.IWXStatisticsListener;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.adapter.IWXSoLoaderAdapter;
import com.taobao.weex.adapter.IWXUserTrackAdapter;
import com.taobao.weex.common.WXErrorCode;
import com.taobao.weex.performance.WXInstanceApm;
import dalvik.system.PathClassLoader;
import io.dcloud.common.util.PdrUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Enumeration;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class WXSoInstallMgrSdk {
    private static final String ARMEABI = "armeabi";
    static final String LOGTAG = "INIT_SO";
    private static final String MIPS = "mips";
    private static final String STARTUPSO = "/libweexjsb.so";
    private static final String STARTUPSOANDROID15 = "/libweexjst.so";
    private static final String X86 = "x86";
    private static String mAbi;
    static Application mContext;
    private static IWXSoLoaderAdapter mSoLoader;
    private static IWXStatisticsListener mStatisticsListener;

    public static void init(Application application, IWXSoLoaderAdapter iWXSoLoaderAdapter, IWXStatisticsListener iWXStatisticsListener) {
        mContext = application;
        mSoLoader = iWXSoLoaderAdapter;
        mStatisticsListener = iWXStatisticsListener;
    }

    public static boolean isX86() {
        return _cpuType().equalsIgnoreCase("x86");
    }

    public static boolean isCPUSupport() {
        return !_cpuType().equalsIgnoreCase("mips");
    }

    public static boolean initSo(String str, int i, IWXUserTrackAdapter iWXUserTrackAdapter) {
        String _cpuType = _cpuType();
        if (_cpuType.equalsIgnoreCase("mips")) {
            WXExceptionUtils.commitCriticalExceptionRT(null, WXErrorCode.WX_KEY_EXCEPTION_SDK_INIT, "initSo", "[WX_KEY_EXCEPTION_SDK_INIT_CPU_NOT_SUPPORT] for android cpuType is MIPS", null);
            return false;
        }
        if (WXEnvironment.CORE_SO_NAME.equals(str)) {
            copyStartUpSo();
        }
        try {
            IWXSoLoaderAdapter iWXSoLoaderAdapter = mSoLoader;
            if (iWXSoLoaderAdapter != null) {
                iWXSoLoaderAdapter.doLoadLibrary("c++_shared");
            } else {
                System.loadLibrary("c++_shared");
            }
        } catch (Error | Exception e) {
            WXErrorCode wXErrorCode = WXErrorCode.WX_KEY_EXCEPTION_SDK_INIT;
            WXExceptionUtils.commitCriticalExceptionRT(null, wXErrorCode, "initSo", "load c++_shared failed Detail Error is: " + e.getMessage(), null);
            if (WXEnvironment.isApkDebugable()) {
                throw e;
            }
        }
        try {
            IWXSoLoaderAdapter iWXSoLoaderAdapter2 = mSoLoader;
            if (iWXSoLoaderAdapter2 != null) {
                iWXSoLoaderAdapter2.doLoadLibrary(str);
            } else {
                System.loadLibrary(str);
            }
            return true;
        } catch (Error | Exception e2) {
            if (_cpuType.contains(ARMEABI) || _cpuType.contains("x86")) {
                WXErrorCode wXErrorCode2 = WXErrorCode.WX_KEY_EXCEPTION_SDK_INIT;
                WXExceptionUtils.commitCriticalExceptionRT(null, wXErrorCode2, "initSo", str + "[WX_KEY_EXCEPTION_SDK_INIT_CPU_NOT_SUPPORT] for android cpuType is " + _cpuType + "\n Detail Error is: " + e2.getMessage(), null);
            }
            if (!WXEnvironment.isApkDebugable()) {
                return false;
            }
            throw e2;
        }
    }

    private static File _desSoCopyFile(String str) {
        String _cpuType = _cpuType();
        String copySoDesDir = WXEnvironment.copySoDesDir();
        if (TextUtils.isEmpty(copySoDesDir)) {
            return null;
        }
        return new File(copySoDesDir, str + "/" + _cpuType);
    }

    public static void copyStartUpSo() {
        String str;
        File file;
        try {
            String packageName = WXEnvironment.getApplication().getPackageName();
            String path = WXEnvironment.getApplication().getApplicationContext().getCacheDir().getPath();
            boolean z = true;
            String str2 = WXEnvironment.CORE_JSB_SO_NAME;
            if (Build.VERSION.SDK_INT < 16) {
                z = false;
                str2 = WXEnvironment.CORE_JST_SO_NAME;
                str = STARTUPSOANDROID15;
            } else {
                str = STARTUPSO;
            }
            File _desSoCopyFile = _desSoCopyFile(str2);
            if (!_desSoCopyFile.exists()) {
                _desSoCopyFile.mkdirs();
            }
            File file2 = new File(_desSoCopyFile, str);
            WXEnvironment.CORE_JSB_SO_PATH = file2.getAbsolutePath();
            String defaultSettingValue = WXEnvironment.getDefaultSettingValue(str2, "-1");
            if (!file2.exists() || !TextUtils.equals(WXEnvironment.getAppVersionName(), defaultSettingValue)) {
                String str3 = "/data/data/" + packageName + "/lib";
                if (path != null && path.indexOf("/cache") > 0) {
                    str3 = path.replace("/cache", "/lib");
                }
                if (z) {
                    file = new File(str3, STARTUPSO);
                } else {
                    file = new File(str3, STARTUPSOANDROID15);
                }
                if (!file.exists()) {
                    try {
                        file = new File(((PathClassLoader) WXSoInstallMgrSdk.class.getClassLoader()).findLibrary(str2));
                    } catch (Throwable unused) {
                    }
                }
                if (!file.exists()) {
                    WXEnvironment.extractSo();
                    file = new File(WXEnvironment.copySoDesDir(), STARTUPSO);
                }
                if (file.exists()) {
                    WXFileUtils.copyFile(file, file2);
                }
                WXEnvironment.writeDefaultSettingsValue(str2, WXEnvironment.getAppVersionName());
            }
        } catch (Throwable th) {
            th.printStackTrace();
        }
    }

    public static void copyJssRuntimeSo() {
        boolean checkGreyConfig = WXUtils.checkGreyConfig("wxapm", "use_runtime_api", WXInstanceApm.VALUE_ERROR_CODE_DEFAULT);
        WXLogUtils.e("weex", "tryUseRunTimeApi ? " + checkGreyConfig);
        if (checkGreyConfig) {
            try {
                WXLogUtils.e("weex", "copyJssRuntimeSo: ");
                File _desSoCopyFile = _desSoCopyFile(WXEnvironment.CORE_JSS_SO_NAME);
                if (!_desSoCopyFile.exists()) {
                    _desSoCopyFile.mkdirs();
                }
                File file = new File(_desSoCopyFile, "libweexjss.so");
                String defaultSettingValue = WXEnvironment.getDefaultSettingValue("app_version_code_weex", "-1");
                if (file.exists()) {
                    if (!TextUtils.equals(WXEnvironment.getAppVersionName(), defaultSettingValue)) {
                        file.delete();
                    } else {
                        WXEnvironment.CORE_JSS_RUNTIME_SO_PATH = file.getAbsolutePath();
                        WXEnvironment.sUseRunTimeApi = true;
                        WXLogUtils.e("weex", "copyJssRuntimeSo exist:  return");
                        return;
                    }
                }
                String findLibrary = ((PathClassLoader) WXSoInstallMgrSdk.class.getClassLoader()).findLibrary("weexjssr");
                if (!TextUtils.isEmpty(findLibrary)) {
                    file.createNewFile();
                    WXFileUtils.copyFileWithException(new File(findLibrary), file);
                    WXEnvironment.CORE_JSS_RUNTIME_SO_PATH = file.getAbsolutePath();
                    WXEnvironment.writeDefaultSettingsValue("app_version_code_weex", WXEnvironment.getAppVersionName());
                    WXEnvironment.sUseRunTimeApi = true;
                    WXLogUtils.e("weex", "copyJssRuntimeSo: cp end and return ");
                }
            } catch (Throwable th) {
                th.printStackTrace();
                WXEnvironment.sUseRunTimeApi = false;
                WXLogUtils.e("weex", "copyJssRuntimeSo:  exception" + th);
            }
        }
    }

    private static String _getFieldReflectively(Build build, String str) {
        try {
            return Build.class.getField(str).get(build).toString();
        } catch (Exception unused) {
            return "Unknown";
        }
    }

    private static String _cpuType() {
        if (TextUtils.isEmpty(mAbi)) {
            try {
                mAbi = Build.CPU_ABI;
            } catch (Throwable th) {
                th.printStackTrace();
                mAbi = ARMEABI;
            }
            if (TextUtils.isEmpty(mAbi)) {
                mAbi = ARMEABI;
            }
            mAbi = mAbi.toLowerCase(Locale.ROOT);
        }
        return mAbi;
    }

    static boolean checkSoIsValid(String str, long j) {
        if (mContext == null) {
            return false;
        }
        try {
            long currentTimeMillis = System.currentTimeMillis();
            if (WXSoInstallMgrSdk.class.getClassLoader() instanceof PathClassLoader) {
                String findLibrary = ((PathClassLoader) WXSoInstallMgrSdk.class.getClassLoader()).findLibrary(str);
                if (TextUtils.isEmpty(findLibrary)) {
                    return false;
                }
                File file = new File(findLibrary);
                if (file.exists()) {
                    if (j != file.length()) {
                        return false;
                    }
                }
                WXLogUtils.w("weex so size check path :" + findLibrary + "   " + (System.currentTimeMillis() - currentTimeMillis));
                return true;
            }
        } catch (Throwable th) {
            WXErrorCode wXErrorCode = WXErrorCode.WX_KEY_EXCEPTION_SDK_INIT;
            WXExceptionUtils.commitCriticalExceptionRT(null, wXErrorCode, "checkSoIsValid", "[WX_KEY_EXCEPTION_SDK_INIT_CPU_NOT_SUPPORT] for weex so size check fail exception :" + th.getMessage(), null);
            WXLogUtils.e("weex so size check fail exception :" + th.getMessage());
        }
        return true;
    }

    static String _targetSoFile(String str, int i) {
        Application application = mContext;
        if (application == null) {
            return "";
        }
        String str2 = "/data/data/" + application.getPackageName() + "/files";
        File filesDir = application.getFilesDir();
        if (filesDir != null) {
            str2 = filesDir.getPath();
        }
        return str2 + "/lib" + str + "bk" + i + ".so";
    }

    static void removeSoIfExit(String str, int i) {
        File file = new File(_targetSoFile(str, i));
        if (file.exists()) {
            file.delete();
        }
    }

    static boolean isExist(String str, int i) {
        return new File(_targetSoFile(str, i)).exists();
    }

    static boolean _loadUnzipSo(String str, int i, IWXUserTrackAdapter iWXUserTrackAdapter) {
        try {
            if (isExist(str, i)) {
                IWXSoLoaderAdapter iWXSoLoaderAdapter = mSoLoader;
                if (iWXSoLoaderAdapter != null) {
                    iWXSoLoaderAdapter.doLoad(_targetSoFile(str, i));
                } else {
                    System.load(_targetSoFile(str, i));
                }
            }
            return true;
        } catch (Throwable th) {
            WXErrorCode wXErrorCode = WXErrorCode.WX_KEY_EXCEPTION_SDK_INIT_CPU_NOT_SUPPORT;
            WXExceptionUtils.commitCriticalExceptionRT(null, wXErrorCode, "_loadUnzipSo", "[WX_KEY_EXCEPTION_SDK_INIT_WX_ERR_COPY_FROM_APK] \n Detail Msg is : " + th.getMessage(), null);
            WXLogUtils.e("", th);
            return false;
        }
    }

    /* JADX WARNING: Code restructure failed: missing block: B:85:0x0110, code lost:
        if (r5 != null) goto L_0x00ea;
     */
    /* JADX WARNING: Removed duplicated region for block: B:60:0x00c4 A[SYNTHETIC, Splitter:B:60:0x00c4] */
    /* JADX WARNING: Removed duplicated region for block: B:65:0x00ce A[SYNTHETIC, Splitter:B:65:0x00ce] */
    /* JADX WARNING: Removed duplicated region for block: B:70:0x00d8 A[SYNTHETIC, Splitter:B:70:0x00d8] */
    /* JADX WARNING: Removed duplicated region for block: B:88:0x0116  */
    static boolean unZipSelectedFiles(String str, int i, IWXUserTrackAdapter iWXUserTrackAdapter) throws ZipException, IOException {
        Application application;
        Throwable th;
        IOException e;
        Throwable th2;
        FileChannel fileChannel;
        FileOutputStream fileOutputStream;
        InputStream inputStream;
        String str2 = "lib/armeabi/lib" + str + ".so";
        if (!PdrUtil.isSafeEntryName(str2) || (application = mContext) == null) {
            return false;
        }
        ApplicationInfo applicationInfo = application.getApplicationInfo();
        ZipFile zipFile = new ZipFile(applicationInfo != null ? applicationInfo.sourceDir : "");
        try {
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = (ZipEntry) entries.nextElement();
                if (zipEntry.getName().startsWith(str2)) {
                    try {
                        removeSoIfExit(str, i);
                        inputStream = zipFile.getInputStream(zipEntry);
                        try {
                            fileOutputStream = application.openFileOutput("lib" + str + "bk" + i + ".so", 0);
                        } catch (Throwable th3) {
                            th2 = th3;
                            fileOutputStream = null;
                            fileChannel = fileOutputStream;
                            if (inputStream != null) {
                            }
                            if (fileChannel != null) {
                            }
                            if (fileOutputStream != null) {
                            }
                            zipFile.close();
                            throw th2;
                        }
                        try {
                            fileChannel = fileOutputStream.getChannel();
                            try {
                                byte[] bArr = new byte[1024];
                                int i2 = 0;
                                while (true) {
                                    int read = inputStream.read(bArr);
                                    if (read <= 0) {
                                        break;
                                    }
                                    fileChannel.write(ByteBuffer.wrap(bArr, 0, read));
                                    i2 += read;
                                }
                                if (inputStream != null) {
                                    try {
                                        inputStream.close();
                                    } catch (Exception e2) {
                                        e2.printStackTrace();
                                    }
                                }
                                if (fileChannel != null) {
                                    try {
                                        fileChannel.close();
                                    } catch (Exception e3) {
                                        e3.printStackTrace();
                                    }
                                }
                                if (fileOutputStream != null) {
                                    try {
                                        fileOutputStream.close();
                                    } catch (Exception e4) {
                                        e4.printStackTrace();
                                    }
                                }
                                zipFile.close();
                                if (i2 <= 0) {
                                    return false;
                                }
                                try {
                                    return _loadUnzipSo(str, i, iWXUserTrackAdapter);
                                } catch (IOException e5) {
                                    e = e5;
                                    zipFile = null;
                                    try {
                                        e.printStackTrace();
                                        WXExceptionUtils.commitCriticalExceptionRT(null, WXErrorCode.WX_KEY_EXCEPTION_SDK_INIT_CPU_NOT_SUPPORT, "unZipSelectedFiles", "[WX_KEY_EXCEPTION_SDK_INIT_unZipSelectedFiles] \n Detail msg is: " + e.getMessage(), null);
                                    } catch (Throwable th4) {
                                        th = th4;
                                        if (zipFile != null) {
                                            zipFile.close();
                                        }
                                        throw th;
                                    }
                                } catch (Throwable th5) {
                                    th = th5;
                                    zipFile = null;
                                    if (zipFile != null) {
                                    }
                                    throw th;
                                }
                            } catch (Throwable th6) {
                                th2 = th6;
                                if (inputStream != null) {
                                    try {
                                        inputStream.close();
                                    } catch (Exception e6) {
                                        e6.printStackTrace();
                                    }
                                }
                                if (fileChannel != null) {
                                    try {
                                        fileChannel.close();
                                    } catch (Exception e7) {
                                        e7.printStackTrace();
                                    }
                                }
                                if (fileOutputStream != null) {
                                    try {
                                        fileOutputStream.close();
                                    } catch (Exception e8) {
                                        e8.printStackTrace();
                                    }
                                }
                                zipFile.close();
                                throw th2;
                            }
                        } catch (Throwable th7) {
                            th2 = th7;
                            fileChannel = null;
                            if (inputStream != null) {
                            }
                            if (fileChannel != null) {
                            }
                            if (fileOutputStream != null) {
                            }
                            zipFile.close();
                            throw th2;
                        }
                    } catch (Throwable th8) {
                        th2 = th8;
                        inputStream = null;
                        fileOutputStream = null;
                        fileChannel = fileOutputStream;
                        if (inputStream != null) {
                        }
                        if (fileChannel != null) {
                        }
                        if (fileOutputStream != null) {
                        }
                        zipFile.close();
                        throw th2;
                    }
                }
            }
        } catch (IOException e9) {
            e = e9;
            e.printStackTrace();
            WXExceptionUtils.commitCriticalExceptionRT(null, WXErrorCode.WX_KEY_EXCEPTION_SDK_INIT_CPU_NOT_SUPPORT, "unZipSelectedFiles", "[WX_KEY_EXCEPTION_SDK_INIT_unZipSelectedFiles] \n Detail msg is: " + e.getMessage(), null);
        }
        zipFile.close();
        return false;
    }
}
