package com.taobao.weex.utils;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.util.Base64;
import io.dcloud.common.util.Md5Utils;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.weex.DCFileUtils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class WXFileUtils {
    public static String loadFileOrAsset(String str, Context context) {
        if (TextUtils.isEmpty(str)) {
            return "";
        }
        File file = new File(str);
        if (!file.exists()) {
            return loadAsset(str, context);
        }
        try {
            return readStreamToString(new FileInputStream(file));
        } catch (FileNotFoundException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String loadAsset(String str, Context context) {
        if (context == null || TextUtils.isEmpty(str)) {
            return null;
        }
        try {
            String assetPath = DCFileUtils.getAssetPath(str);
            InputStream loadWeexAsset = DCFileUtils.loadWeexAsset(assetPath, context);
            if (loadWeexAsset == null) {
                loadWeexAsset = context.getAssets().open(assetPath);
            }
            return readStreamToString(loadWeexAsset);
        } catch (IOException unused) {
            return "";
        }
    }

    /* JADX WARNING: Removed duplicated region for block: B:27:0x004c A[SYNTHETIC, Splitter:B:27:0x004c] */
    /* JADX WARNING: Removed duplicated region for block: B:32:0x0056 A[SYNTHETIC, Splitter:B:32:0x0056] */
    /* JADX WARNING: Removed duplicated region for block: B:40:0x0063 A[SYNTHETIC, Splitter:B:40:0x0063] */
    /* JADX WARNING: Removed duplicated region for block: B:45:0x006d A[SYNTHETIC, Splitter:B:45:0x006d] */
    private static String readStreamToString(InputStream inputStream) {
        Throwable th;
        BufferedReader bufferedReader;
        IOException e;
        BufferedReader bufferedReader2 = null;
        try {
            StringBuilder sb = new StringBuilder(inputStream.available() + 10);
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            try {
                char[] cArr = new char[4096];
                while (true) {
                    int read = bufferedReader.read(cArr);
                    if (read <= 0) {
                        break;
                    }
                    sb.append(cArr, 0, read);
                }
                String sb2 = sb.toString();
                try {
                    bufferedReader.close();
                } catch (IOException e2) {
                    WXLogUtils.e("WXFileUtils loadAsset: ", e2);
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    } catch (IOException e3) {
                        WXLogUtils.e("WXFileUtils loadAsset: ", e3);
                    }
                }
                return sb2;
            } catch (IOException e4) {
                e = e4;
                try {
                    WXLogUtils.e("", e);
                    if (bufferedReader != null) {
                    }
                    if (inputStream != null) {
                    }
                    return "";
                } catch (Throwable th2) {
                    th = th2;
                    bufferedReader2 = bufferedReader;
                    if (bufferedReader2 != null) {
                    }
                    if (inputStream != null) {
                    }
                    throw th;
                }
            }
        } catch (IOException e5) {
            bufferedReader = null;
            e = e5;
            WXLogUtils.e("", e);
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                } catch (IOException e6) {
                    WXLogUtils.e("WXFileUtils loadAsset: ", e6);
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                } catch (IOException e7) {
                    WXLogUtils.e("WXFileUtils loadAsset: ", e7);
                }
            }
            return "";
        } catch (Throwable th3) {
            th = th3;
            if (bufferedReader2 != null) {
                try {
                    bufferedReader2.close();
                } catch (IOException e8) {
                    WXLogUtils.e("WXFileUtils loadAsset: ", e8);
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                } catch (IOException e9) {
                    WXLogUtils.e("WXFileUtils loadAsset: ", e9);
                }
            }
            throw th;
        }
    }

    public static byte[] readBytesFromAssets(String str, Context context) {
        if (context != null && !TextUtils.isEmpty(str)) {
            try {
                InputStream open = context.getAssets().open(str);
                byte[] bArr = new byte[4096];
                int read = open.read(bArr);
                byte[] bArr2 = new byte[read];
                System.arraycopy(bArr, 0, bArr2, 0, read);
                return bArr2;
            } catch (IOException e) {
                WXLogUtils.e("", e);
            }
        }
        return null;
    }

    /* JADX WARNING: Removed duplicated region for block: B:24:0x0042 A[SYNTHETIC, Splitter:B:24:0x0042] */
    /* JADX WARNING: Removed duplicated region for block: B:30:0x004d A[SYNTHETIC, Splitter:B:30:0x004d] */
    public static boolean saveFile(String str, byte[] bArr, Context context) {
        Throwable th;
        Exception e;
        if (TextUtils.isEmpty(str) || bArr == null || context == null) {
            return false;
        }
        FileOutputStream fileOutputStream = null;
        try {
            FileOutputStream fileOutputStream2 = new FileOutputStream(str);
            try {
                fileOutputStream2.write(bArr);
                try {
                    fileOutputStream2.close();
                } catch (IOException e2) {
                    e2.printStackTrace();
                }
                return true;
            } catch (Exception e3) {
                e = e3;
                fileOutputStream = fileOutputStream2;
                try {
                    WXLogUtils.e("WXFileUtils saveFile: " + WXLogUtils.getStackTrace(e));
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        } catch (IOException e4) {
                            e4.printStackTrace();
                        }
                    }
                    return false;
                } catch (Throwable th2) {
                    th = th2;
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        } catch (IOException e5) {
                            e5.printStackTrace();
                        }
                    }
                    throw th;
                }
            } catch (Throwable th3) {
                th = th3;
                fileOutputStream = fileOutputStream2;
                if (fileOutputStream != null) {
                }
                throw th;
            }
        } catch (Exception e6) {
            e = e6;
            WXLogUtils.e("WXFileUtils saveFile: " + WXLogUtils.getStackTrace(e));
            if (fileOutputStream != null) {
            }
            return false;
        }
    }

    public static String md5(String str) {
        if (str == null) {
            return "";
        }
        try {
            return md5(str.getBytes("UTF-8"));
        } catch (UnsupportedEncodingException unused) {
            return "";
        }
    }

    public static String md5(byte[] bArr) {
        try {
            MessageDigest instance = MessageDigest.getInstance(Md5Utils.ALGORITHM);
            instance.update(bArr);
            return new BigInteger(1, instance.digest()).toString(16);
        } catch (NoSuchAlgorithmException unused) {
            return "";
        }
    }

    public static String base64Md5(String str) {
        if (str == null) {
            return "";
        }
        try {
            return base64Md5(str.getBytes("UTF-8"));
        } catch (UnsupportedEncodingException unused) {
            return "";
        }
    }

    public static String base64Md5(byte[] bArr) {
        try {
            MessageDigest instance = MessageDigest.getInstance(Md5Utils.ALGORITHM);
            instance.update(bArr);
            return Base64.encodeToString(instance.digest(), 2);
        } catch (NoSuchAlgorithmException unused) {
            return "";
        }
    }

    private static String[] validCPUABIS() {
        String[] strArr = Build.VERSION.SDK_INT >= 21 ? Build.SUPPORTED_ABIS : null;
        if (strArr != null && strArr.length != 0) {
            return strArr;
        }
        return new String[]{Build.CPU_ABI};
    }

    private static boolean validLibPath(String str) {
        for (String str2 : validCPUABIS()) {
            if (str.contains(str2)) {
                return true;
            }
        }
        return false;
    }

    private static boolean replaceLib(String str, String str2) {
        if (str == null || str2 == null) {
            return true;
        }
        String[] validCPUABIS = validCPUABIS();
        boolean z = false;
        for (String str3 : validCPUABIS) {
            if (str2.contains(str3) && z) {
                return true;
            }
            if (str.contains(str3)) {
                z = true;
            }
        }
        return false;
    }

    public static boolean extractSo(String str, String str2) throws IOException {
        boolean z = false;
        if (PdrUtil.isSafeEntryName(str) && PdrUtil.isSafeEntryName(str2)) {
            HashMap hashMap = new HashMap();
            ZipFile zipFile = new ZipFile(str);
            ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(str)));
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = (ZipEntry) entries.nextElement();
                if (!zipEntry.getName().contains("../") && !zipEntry.isDirectory() && validLibPath(zipEntry.getName())) {
                    if (zipEntry.getName().contains("weex") || zipEntry.getName().equals("libjsc.so") || zipEntry.getName().equals("libJavaScriptCore.so")) {
                        String[] split = zipEntry.getName().split("/");
                        String str3 = split[split.length - 1];
                        File file = new File(str2 + "/" + str3);
                        if (replaceLib(zipEntry.getName(), (String) hashMap.get(str3))) {
                            hashMap.put(str3, zipEntry.getName());
                            if (file.exists()) {
                                file.delete();
                            }
                            InputStream inputStream = zipFile.getInputStream(zipEntry);
                            byte[] bArr = new byte[1024];
                            file.createNewFile();
                            FileOutputStream fileOutputStream = new FileOutputStream(file);
                            while (inputStream.read(bArr) != -1) {
                                fileOutputStream.write(bArr);
                            }
                            fileOutputStream.close();
                        }
                        z = true;
                    }
                }
            }
            zipInputStream.closeEntry();
        }
        return z;
    }

    /* JADX WARNING: Removed duplicated region for block: B:18:0x005b A[SYNTHETIC, Splitter:B:18:0x005b] */
    /* JADX WARNING: Removed duplicated region for block: B:23:0x0065 A[SYNTHETIC, Splitter:B:23:0x0065] */
    /* JADX WARNING: Removed duplicated region for block: B:29:? A[RETURN, SYNTHETIC] */
    public static void copyFile(File file, File file2) {
        FileOutputStream fileOutputStream;
        FileInputStream fileInputStream;
        Exception e;
        try {
            fileInputStream = new FileInputStream(file);
            try {
                byte[] bArr = new byte[1024];
                fileOutputStream = new FileOutputStream(file2);
                while (fileInputStream.read(bArr) != -1) {
                    try {
                        fileOutputStream.write(bArr);
                    } catch (Exception e2) {
                        e = e2;
                        WXLogUtils.e("copyFile " + e.getMessage() + ": " + file.getAbsolutePath() + ": " + file2.getAbsolutePath());
                        if (fileInputStream != null) {
                            try {
                                fileInputStream.close();
                            } catch (IOException e3) {
                                e3.printStackTrace();
                            }
                        }
                        if (fileOutputStream != null) {
                            try {
                                fileOutputStream.close();
                                return;
                            } catch (IOException e4) {
                                e4.printStackTrace();
                                return;
                            }
                        } else {
                            return;
                        }
                    }
                }
                fileInputStream.close();
                fileOutputStream.close();
            } catch (Exception e5) {
                fileOutputStream = null;
                e = e5;
                WXLogUtils.e("copyFile " + e.getMessage() + ": " + file.getAbsolutePath() + ": " + file2.getAbsolutePath());
                if (fileInputStream != null) {
                }
                if (fileOutputStream != null) {
                }
            }
        } catch (Exception e6) {
            fileOutputStream = null;
            e = e6;
            fileInputStream = null;
            WXLogUtils.e("copyFile " + e.getMessage() + ": " + file.getAbsolutePath() + ": " + file2.getAbsolutePath());
            if (fileInputStream != null) {
            }
            if (fileOutputStream != null) {
            }
        }
    }

    public static void copyFileWithException(File file, File file2) throws Exception {
        Throwable th;
        FileOutputStream fileOutputStream;
        Exception e;
        FileInputStream fileInputStream = null;
        try {
            FileInputStream fileInputStream2 = new FileInputStream(file);
            try {
                byte[] bArr = new byte[1024];
                fileOutputStream = new FileOutputStream(file2);
                while (fileInputStream2.read(bArr) != -1) {
                    try {
                        fileOutputStream.write(bArr);
                    } catch (Exception e2) {
                        e = e2;
                        fileInputStream = fileInputStream2;
                        try {
                            throw e;
                        } catch (Throwable th2) {
                            th = th2;
                        }
                    } catch (Throwable th3) {
                        th = th3;
                        fileInputStream = fileInputStream2;
                        closeIo(fileInputStream);
                        closeIo(fileOutputStream);
                        throw th;
                    }
                }
                closeIo(fileInputStream2);
                closeIo(fileOutputStream);
            } catch (Exception e3) {
                e = e3;
                fileOutputStream = null;
                fileInputStream = fileInputStream2;
                throw e;
            } catch (Throwable th4) {
                th = th4;
                fileOutputStream = null;
                fileInputStream = fileInputStream2;
                closeIo(fileInputStream);
                closeIo(fileOutputStream);
                throw th;
            }
        } catch (Exception e4) {
            e = e4;
            fileOutputStream = null;
            throw e;
        } catch (Throwable th5) {
            th = th5;
            fileOutputStream = null;
            closeIo(fileInputStream);
            closeIo(fileOutputStream);
            throw th;
        }
    }

    public static void closeIo(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            } catch (Throwable th) {
                th.printStackTrace();
            }
        }
    }
}
