package com.taobao.weex.utils;

import android.content.Intent;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.net.Uri;
import android.text.TextUtils;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.adapter.IWXHttpAdapter;
import com.taobao.weex.common.Constants;
import com.taobao.weex.common.WXRequest;
import com.taobao.weex.common.WXResponse;
import com.taobao.weex.font.FontAdapter;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TypefaceUtil {
    public static final String ACTION_TYPE_FACE_AVAILABLE = "type_face_available";
    public static final String FONT_CACHE_DIR_NAME = "font-family";
    private static final String TAG = "TypefaceUtil";
    private static final Map<String, FontDO> sCacheMap = new HashMap();

    public static void putFontDO(FontDO fontDO) {
        if (fontDO != null && !TextUtils.isEmpty(fontDO.getFontFamilyName())) {
            sCacheMap.put(fontDO.getFontFamilyName(), fontDO);
        }
    }

    public static void registerNativeFont(Map<String, Typeface> map) {
        if (map != null && map.size() > 0) {
            for (Map.Entry<String, Typeface> entry : map.entrySet()) {
                putFontDO(new FontDO(entry.getKey(), entry.getValue()));
                if (WXEnvironment.isApkDebugable()) {
                    WXLogUtils.d(TAG, "register new typeface: " + entry.getKey());
                }
            }
        }
    }

    public static FontDO getFontDO(String str) {
        return sCacheMap.get(str);
    }

    public static void removeFontDO(String str) {
        sCacheMap.remove(str);
    }

    public static void applyFontStyle(Paint paint, int i, int i2, String str) {
        int i3;
        Typeface typeface = paint.getTypeface();
        int i4 = 0;
        if (typeface == null) {
            i3 = 0;
        } else {
            i3 = typeface.getStyle();
        }
        int i5 = 1;
        if (i2 != 1 && ((i3 & 1) == 0 || i2 != -1)) {
            i5 = 0;
        }
        if (i == 2 || ((i3 & 2) != 0 && i == -1)) {
            i5 |= 2;
        }
        if (str != null) {
            typeface = getOrCreateTypeface(str, i5);
        }
        if (typeface != null) {
            paint.setTypeface(Typeface.create(typeface, i5));
        } else {
            paint.setTypeface(Typeface.defaultFromStyle(i5));
        }
        if (i >= 0) {
            if (paint.getTypeface() != null) {
                i4 = paint.getTypeface().getStyle();
            }
            paint.setTextSkewX(((i & (i4 ^ -1)) & 2) != 0 ? -0.2f : 0.0f);
        }
    }

    public static Typeface getOrCreateTypeface(String str, int i) {
        FontDO fontDO = sCacheMap.get(str);
        if (fontDO == null || fontDO.getTypeface() == null) {
            return Typeface.create(str, i);
        }
        return fontDO.getTypeface();
    }

    private static void loadFromAsset(FontDO fontDO, String str) {
        try {
            Typeface createFromAsset = Typeface.createFromAsset(WXEnvironment.getApplication().getAssets(), str);
            if (createFromAsset != null) {
                if (WXEnvironment.isApkDebugable()) {
                    WXLogUtils.d(TAG, "load asset file success");
                }
                fontDO.setState(2);
                fontDO.setTypeface(createFromAsset);
                return;
            }
            WXLogUtils.e(TAG, "Font asset file not found " + fontDO.getUrl());
        } catch (Exception e) {
            WXLogUtils.e(TAG, e.toString());
        }
    }

    public static void loadTypeface(FontDO fontDO, boolean z) {
        if (fontDO != null && fontDO.getTypeface() == null && (fontDO.getState() == 3 || fontDO.getState() == 0)) {
            fontDO.setState(1);
            if (fontDO.getType() == 3) {
                loadFromAsset(fontDO, Uri.parse(fontDO.getUrl()).getPath().substring(1));
            } else if (fontDO.getType() == 1) {
                String url = fontDO.getUrl();
                String fontFamilyName = fontDO.getFontFamilyName();
                String md5 = WXFileUtils.md5(url);
                File file = new File(getFontCacheDir());
                if (!file.exists()) {
                    file.mkdirs();
                }
                String str = file.getAbsolutePath() + File.separator + md5;
                if (!loadLocalFontFile(str, fontFamilyName, false)) {
                    downloadFontByNetwork(url, str, fontFamilyName);
                }
            } else if ((fontDO.getType() == 2 || fontDO.getType() == 5) && !loadLocalFontFile(fontDO.getUrl(), fontDO.getFontFamilyName(), false)) {
                fontDO.setState(3);
            }
        } else if (z) {
            notifyFontAvailable(false, fontDO);
        }
    }

    private static void downloadFontByNetwork(final String str, final String str2, final String str3) {
        IWXHttpAdapter iWXHttpAdapter = WXSDKManager.getInstance().getIWXHttpAdapter();
        if (iWXHttpAdapter == null) {
            WXLogUtils.e(TAG, "downloadFontByNetwork() IWXHttpAdapter == null");
            return;
        }
        WXRequest wXRequest = new WXRequest();
        wXRequest.url = str;
        wXRequest.method = "GET";
        iWXHttpAdapter.sendRequest(wXRequest, new IWXHttpAdapter.OnHttpListener() {
            /* class com.taobao.weex.utils.TypefaceUtil.AnonymousClass1 */

            @Override // com.taobao.weex.adapter.IWXHttpAdapter.OnHttpListener
            public void onHeadersReceived(int i, Map<String, List<String>> map) {
            }

            @Override // com.taobao.weex.adapter.IWXHttpAdapter.OnHttpListener
            public void onHttpResponseProgress(int i) {
            }

            @Override // com.taobao.weex.adapter.IWXHttpAdapter.OnHttpListener
            public void onHttpUploadProgress(int i) {
            }

            @Override // com.taobao.weex.adapter.IWXHttpAdapter.OnHttpListener
            public void onHttpStart() {
                if (WXEnvironment.isApkDebugable()) {
                    WXLogUtils.d(TypefaceUtil.TAG, "downloadFontByNetwork begin url:" + str);
                }
            }

            /* JADX WARNING: Removed duplicated region for block: B:15:0x0043  */
            /* JADX WARNING: Removed duplicated region for block: B:16:0x004d  */
            @Override // com.taobao.weex.adapter.IWXHttpAdapter.OnHttpListener
            public void onHttpFinish(WXResponse wXResponse) {
                int i;
                FontDO fontDO;
                boolean z = false;
                if (!TextUtils.isEmpty(wXResponse.statusCode)) {
                    try {
                        i = Integer.parseInt(wXResponse.statusCode);
                    } catch (NumberFormatException unused) {
                        WXLogUtils.e(TypefaceUtil.TAG, "IWXHttpAdapter onHttpFinish statusCode:" + wXResponse.statusCode);
                    }
                    if (i >= 200 && i <= 299 && wXResponse.originalData != null) {
                        z = WXFileUtils.saveFile(str2, wXResponse.originalData, WXEnvironment.getApplication());
                        if (!z) {
                            z = TypefaceUtil.loadLocalFontFile(str2, str3, true);
                        } else if (WXEnvironment.isApkDebugable()) {
                            WXLogUtils.d(TypefaceUtil.TAG, "downloadFontByNetwork() onHttpFinish success, but save file failed.");
                        }
                    }
                    if (!z && (fontDO = (FontDO) TypefaceUtil.sCacheMap.get(str3)) != null) {
                        fontDO.setState(3);
                        return;
                    }
                }
                i = 0;
                z = WXFileUtils.saveFile(str2, wXResponse.originalData, WXEnvironment.getApplication());
                if (!z) {
                }
                if (!z) {
                }
            }
        });
    }

    /* access modifiers changed from: private */
    public static boolean loadLocalFontFile(String str, String str2, boolean z) {
        if (!TextUtils.isEmpty(str) && !TextUtils.isEmpty(str2)) {
            try {
                if (!new File(str).exists()) {
                    return false;
                }
                Typeface createFromFile = Typeface.createFromFile(str);
                if (createFromFile != null) {
                    final FontDO fontDO = sCacheMap.get(str2);
                    if (fontDO != null) {
                        fontDO.setState(2);
                        fontDO.setTypeface(createFromFile);
                        fontDO.setFilePath(str);
                        if (WXEnvironment.isApkDebugable()) {
                            WXLogUtils.d(TAG, "load local font file success");
                        }
                        if (z) {
                            WXSDKManager.getInstance().getWXRenderManager().postOnUiThread(new Runnable() {
                                /* class com.taobao.weex.utils.TypefaceUtil.AnonymousClass2 */

                                public void run() {
                                    TypefaceUtil.notifyFontAvailable(true, FontDO.this);
                                }
                            }, 100);
                        } else {
                            notifyFontAvailable(true, fontDO);
                        }
                        return true;
                    }
                } else {
                    WXLogUtils.e(TAG, "load local font file failed, can't create font.");
                }
            } catch (Exception e) {
                WXLogUtils.e(TAG, e.toString());
            }
        }
        return false;
    }

    /* access modifiers changed from: private */
    public static void notifyFontAvailable(boolean z, FontDO fontDO) {
        if (z) {
            Intent intent = new Intent(ACTION_TYPE_FACE_AVAILABLE);
            intent.putExtra(Constants.Name.FONT_FAMILY, fontDO.getFontFamilyName());
            intent.putExtra("filePath", fontDO.getFilePath());
            intent.putExtra("fontUrl", fontDO.getUrl());
            LocalBroadcastManager.getInstance(WXEnvironment.getApplication()).sendBroadcast(intent);
        }
        FontAdapter fontAdapter = WXSDKManager.getInstance().getFontAdapter();
        if (fontAdapter != null) {
            fontAdapter.onFontLoad(fontDO.getFontFamilyName(), fontDO.getUrl(), fontDO.getFilePath());
        }
    }

    private static String getFontCacheDir() {
        return WXEnvironment.getApplication().getCacheDir() + "/" + FONT_CACHE_DIR_NAME;
    }
}
