package com.taobao.weex.ui.component;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.text.Layout;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.annotation.Component;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.common.Constants;
import com.taobao.weex.layout.measurefunc.TextContentBoxMeasurement;
import com.taobao.weex.ui.ComponentCreator;
import com.taobao.weex.ui.action.BasicComponentData;
import com.taobao.weex.ui.flat.FlatComponent;
import com.taobao.weex.ui.flat.widget.TextWidget;
import com.taobao.weex.ui.view.WXTextView;
import com.taobao.weex.utils.FontDO;
import com.taobao.weex.utils.TypefaceUtil;
import com.taobao.weex.utils.WXLogUtils;
import java.lang.reflect.InvocationTargetException;

@Component(lazyload = false)
public class WXText extends WXComponent<WXTextView> implements FlatComponent<TextWidget> {
    private String mFontFamily;
    private TextWidget mTextWidget;
    private BroadcastReceiver mTypefaceObserver;

    @Override // com.taobao.weex.ui.flat.FlatComponent
    public boolean promoteToView(boolean z) {
        if (getInstance().getFlatUIContext() != null) {
            return getInstance().getFlatUIContext().promoteToView(this, z, WXText.class);
        }
        return false;
    }

    @Override // com.taobao.weex.ui.flat.FlatComponent
    public TextWidget getOrCreateFlatWidget() {
        if (this.mTextWidget == null) {
            this.mTextWidget = new TextWidget(getInstance().getFlatUIContext());
        }
        return this.mTextWidget;
    }

    @Override // com.taobao.weex.ui.component.WXComponent
    public boolean isVirtualComponent() {
        return true ^ promoteToView(true);
    }

    public static class Creator implements ComponentCreator {
        @Override // com.taobao.weex.ui.ComponentCreator
        public WXComponent createInstance(WXSDKInstance wXSDKInstance, WXVContainer wXVContainer, BasicComponentData basicComponentData) throws IllegalAccessException, InvocationTargetException, InstantiationException {
            return new WXText(wXSDKInstance, wXVContainer, basicComponentData);
        }
    }

    @Deprecated
    public WXText(WXSDKInstance wXSDKInstance, WXVContainer wXVContainer, String str, boolean z, BasicComponentData basicComponentData) {
        this(wXSDKInstance, wXVContainer, basicComponentData);
    }

    public WXText(WXSDKInstance wXSDKInstance, WXVContainer wXVContainer, BasicComponentData basicComponentData) {
        super(wXSDKInstance, wXVContainer, basicComponentData);
        setContentBoxMeasurement(new TextContentBoxMeasurement(this));
    }

    /* access modifiers changed from: protected */
    @Override // com.taobao.weex.ui.component.WXComponent
    public WXTextView initComponentHostView(Context context) {
        WXTextView wXTextView = new WXTextView(context);
        wXTextView.holdComponent(this);
        return wXTextView;
    }

    @Override // io.dcloud.feature.uniapp.ui.component.AbsBasicComponent
    public void updateExtra(Object obj) {
        super.updateExtra(obj);
        if (obj instanceof Layout) {
            Layout layout = (Layout) obj;
            if (!promoteToView(true)) {
                getOrCreateFlatWidget().updateTextDrawable(layout);
            } else if (getHostView() != null && !obj.equals(((WXTextView) getHostView()).getTextLayout())) {
                ((WXTextView) getHostView()).setTextLayout(layout);
                ((WXTextView) getHostView()).invalidate();
            }
        }
    }

    /* access modifiers changed from: protected */
    @Override // com.taobao.weex.ui.component.WXComponent
    public void setAriaLabel(String str) {
        WXTextView wXTextView = (WXTextView) getHostView();
        if (wXTextView != null) {
            wXTextView.setAriaLabel(str);
        }
    }

    @Override // com.taobao.weex.ui.component.WXComponent
    public void refreshData(WXComponent wXComponent) {
        super.refreshData(wXComponent);
        if (wXComponent instanceof WXText) {
            updateExtra(wXComponent.getExtra());
        }
    }

    /* access modifiers changed from: protected */
    @Override // com.taobao.weex.ui.component.WXComponent
    public boolean setProperty(String str, Object obj) {
        str.hashCode();
        char c = 65535;
        switch (str.hashCode()) {
            case -1550943582:
                if (str.equals(Constants.Name.FONT_STYLE)) {
                    c = 0;
                    break;
                }
                break;
            case -1224696685:
                if (str.equals(Constants.Name.FONT_FAMILY)) {
                    c = 1;
                    break;
                }
                break;
            case -1065511464:
                if (str.equals(Constants.Name.TEXT_ALIGN)) {
                    c = 2;
                    break;
                }
                break;
            case -879295043:
                if (str.equals(Constants.Name.TEXT_DECORATION)) {
                    c = 3;
                    break;
                }
                break;
            case -734428249:
                if (str.equals(Constants.Name.FONT_WEIGHT)) {
                    c = 4;
                    break;
                }
                break;
            case -515807685:
                if (str.equals(Constants.Name.LINE_HEIGHT)) {
                    c = 5;
                    break;
                }
                break;
            case 94842723:
                if (str.equals("color")) {
                    c = 6;
                    break;
                }
                break;
            case 102977279:
                if (str.equals(Constants.Name.LINES)) {
                    c = 7;
                    break;
                }
                break;
            case 111972721:
                if (str.equals("value")) {
                    c = '\b';
                    break;
                }
                break;
            case 261414991:
                if (str.equals(Constants.Name.TEXT_OVERFLOW)) {
                    c = '\t';
                    break;
                }
                break;
            case 365601008:
                if (str.equals(Constants.Name.FONT_SIZE)) {
                    c = '\n';
                    break;
                }
                break;
        }
        switch (c) {
            case 0:
            case 2:
            case 3:
            case 4:
            case 5:
            case 6:
            case 7:
            case '\b':
            case '\t':
            case '\n':
                break;
            default:
                return super.setProperty(str, obj);
            case 1:
                if (obj != null) {
                    registerTypefaceObserver(obj.toString());
                    break;
                }
                break;
        }
        return true;
    }

    /* access modifiers changed from: protected */
    @Override // com.taobao.weex.ui.component.WXComponent
    public Object convertEmptyProperty(String str, Object obj) {
        str.hashCode();
        if (str.equals("color")) {
            return "black";
        }
        if (!str.equals(Constants.Name.FONT_SIZE)) {
            return super.convertEmptyProperty(str, obj);
        }
        return Integer.valueOf(getInstance().getDefaultFontSize());
    }

    /* access modifiers changed from: protected */
    @Override // com.taobao.weex.ui.component.WXComponent
    public void createViewImpl() {
        if (promoteToView(true)) {
            super.createViewImpl();
        }
    }

    @Override // com.taobao.weex.ui.component.WXComponent
    public void destroy() {
        super.destroy();
        if (WXEnvironment.getApplication() != null && this.mTypefaceObserver != null) {
            WXLogUtils.d("WXText", "Unregister the typeface observer");
            LocalBroadcastManager.getInstance(WXEnvironment.getApplication()).unregisterReceiver(this.mTypefaceObserver);
            this.mTypefaceObserver = null;
        }
    }

    private void registerTypefaceObserver(String str) {
        if (WXEnvironment.getApplication() == null) {
            WXLogUtils.w("WXText", "ApplicationContent is null on register typeface observer");
            return;
        }
        this.mFontFamily = str;
        if (this.mTypefaceObserver == null) {
            this.mTypefaceObserver = new BroadcastReceiver() {
                /* class com.taobao.weex.ui.component.WXText.AnonymousClass1 */

                public void onReceive(Context context, Intent intent) {
                    FontDO fontDO;
                    String stringExtra = intent.getStringExtra(Constants.Name.FONT_FAMILY);
                    if (WXText.this.mFontFamily.equals(stringExtra) && (fontDO = TypefaceUtil.getFontDO(stringExtra)) != null && fontDO.getTypeface() != null && WXText.this.getHostView() != null) {
                        Layout textLayout = ((WXTextView) WXText.this.getHostView()).getTextLayout();
                        if (textLayout != null) {
                            textLayout.getPaint().setTypeface(fontDO.getTypeface());
                        } else {
                            WXLogUtils.d("WXText", "Layout not created");
                        }
                        WXBridgeManager.getInstance().markDirty(WXText.this.getInstanceId(), WXText.this.getRef(), true);
                        WXText.this.forceRelayout();
                    }
                }
            };
            LocalBroadcastManager.getInstance(WXEnvironment.getApplication()).registerReceiver(this.mTypefaceObserver, new IntentFilter(TypefaceUtil.ACTION_TYPE_FACE_AVAILABLE));
        }
    }

    /* access modifiers changed from: protected */
    @Override // com.taobao.weex.ui.component.WXComponent
    public void layoutDirectionDidChanged(boolean z) {
        forceRelayout();
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void forceRelayout() {
        WXBridgeManager.getInstance().post(new Runnable() {
            /* class com.taobao.weex.ui.component.WXText.AnonymousClass2 */

            public void run() {
                if (WXText.this.contentBoxMeasurement instanceof TextContentBoxMeasurement) {
                    ((TextContentBoxMeasurement) WXText.this.contentBoxMeasurement).forceRelayout();
                }
            }
        });
    }
}
