package com.taobao.weex.ui.component;

import android.animation.ObjectAnimator;
import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import androidx.core.view.ViewCompat;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.annotation.Component;
import com.taobao.weex.annotation.JSMethod;
import com.taobao.weex.bridge.JSCallback;
import com.taobao.weex.common.Constants;
import com.taobao.weex.common.ICheckBindingScroller;
import com.taobao.weex.common.OnWXScrollListener;
import com.taobao.weex.common.WXThread;
import com.taobao.weex.performance.WXInstanceApm;
import com.taobao.weex.ui.ComponentCreator;
import com.taobao.weex.ui.action.BasicComponentData;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.helper.ScrollStartEndHelper;
import com.taobao.weex.ui.view.IWXScroller;
import com.taobao.weex.ui.view.WXBaseRefreshLayout;
import com.taobao.weex.ui.view.refresh.wrapper.BaseBounceView;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;
import io.dcloud.common.constant.AbsoluteConst;
import io.dcloud.common.util.DensityUtils;
import io.dcloud.common.util.StringUtil;
import io.dcloud.feature.weex_scroller.helper.DCScrollStartEndHelper;
import io.dcloud.feature.weex_scroller.view.DCBounceScrollerView;
import io.dcloud.feature.weex_scroller.view.DCWXHorizontalScrollView;
import io.dcloud.feature.weex_scroller.view.DCWXScrollView;
import io.dcloud.feature.weex_scroller.view.WXStickyHelper;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

@Component(lazyload = false)
public class DCWXScroller extends WXBaseScroller implements DCWXScrollView.WXScrollViewListener, Scrollable {
    public static final String DIRECTION = "direction";
    private static final int SWIPE_MIN_DISTANCE = 5;
    private static final int SWIPE_THRESHOLD_VELOCITY = 300;
    private boolean canScroll2Top;
    Map<String, WXComponent> childens;
    private Handler handler;
    private boolean isAnimation;
    private boolean isScrollable;
    private AtomicBoolean isViewLayoutFinished;
    private int mActiveFeature;
    private Map<String, AppearanceHelper> mAppearanceComponents;
    private int mChildrenLayoutOffset;
    private int mContentHeight;
    private int mContentWidth;
    private boolean mForceLoadmoreNextTime;
    private GestureDetector mGestureDetector;
    private boolean mHasAddScrollEvent;
    private boolean mIsHostAttachedToWindow;
    private Point mLastReport;
    private int mOffsetAccuracy;
    private View.OnAttachStateChangeListener mOnAttachStateChangeListener;
    protected int mOrientation;
    private FrameLayout mRealView;
    private List<WXComponent> mRefreshs;
    private ScrollStartEndHelper mScrollStartEndHelper;
    private FrameLayout mScrollerView;
    private Map<String, Map<String, WXComponent>> mStickyMap;
    private boolean pageEnable;
    private int pageSize;
    private WXStickyHelper stickyHelper;

    @Override // io.dcloud.feature.weex_scroller.view.DCWXScrollView.WXScrollViewListener
    public void onScrollStopped(DCWXScrollView dCWXScrollView, int i, int i2) {
    }

    @Override // io.dcloud.feature.weex_scroller.view.DCWXScrollView.WXScrollViewListener
    public void onScrollToBottom(DCWXScrollView dCWXScrollView, int i, int i2) {
    }

    @Override // io.dcloud.feature.weex_scroller.view.DCWXScrollView.WXScrollViewListener
    public void onScrollToTop(DCWXScrollView dCWXScrollView, int i, int i2) {
    }

    public static class Creator implements ComponentCreator {
        @Override // com.taobao.weex.ui.ComponentCreator
        public WXComponent createInstance(WXSDKInstance wXSDKInstance, WXVContainer wXVContainer, BasicComponentData basicComponentData) throws IllegalAccessException, InvocationTargetException, InstantiationException {
            wXSDKInstance.setUseScroller(true);
            return new DCWXScroller(wXSDKInstance, wXVContainer, basicComponentData);
        }
    }

    @Deprecated
    public DCWXScroller(WXSDKInstance wXSDKInstance, WXVContainer wXVContainer, String str, boolean z, BasicComponentData basicComponentData) {
        this(wXSDKInstance, wXVContainer, basicComponentData);
    }

    public DCWXScroller(WXSDKInstance wXSDKInstance, WXVContainer wXVContainer, BasicComponentData basicComponentData) {
        super(wXSDKInstance, wXVContainer, basicComponentData);
        this.mOrientation = 1;
        this.mRefreshs = new ArrayList();
        this.mChildrenLayoutOffset = 0;
        this.mForceLoadmoreNextTime = false;
        this.mOffsetAccuracy = 10;
        this.mLastReport = new Point(-1, -1);
        this.mHasAddScrollEvent = false;
        this.mActiveFeature = 0;
        this.pageSize = 0;
        this.pageEnable = false;
        this.mIsHostAttachedToWindow = false;
        this.isAnimation = false;
        this.canScroll2Top = false;
        this.mAppearanceComponents = new HashMap();
        this.mStickyMap = new HashMap();
        this.mContentHeight = 0;
        this.mContentWidth = 0;
        this.handler = new Handler(Looper.getMainLooper());
        this.isScrollable = true;
        this.childens = new HashMap();
        this.isViewLayoutFinished = new AtomicBoolean(false);
        this.stickyHelper = new WXStickyHelper(this);
        wXSDKInstance.getApmForInstance().updateDiffStats(WXInstanceApm.KEY_PAGE_STATS_SCROLLER_NUM, 1.0d);
    }

    @Override // io.dcloud.feature.uniapp.ui.component.AbsVContainer, io.dcloud.feature.uniapp.ui.component.AbsVContainer, com.taobao.weex.ui.component.WXComponent
    public ViewGroup getRealView() {
        return this.mScrollerView;
    }

    @Override // io.dcloud.feature.uniapp.ui.component.AbsVContainer, com.taobao.weex.ui.component.WXComponent
    public void createViewImpl() {
        super.createViewImpl();
        for (int i = 0; i < this.mRefreshs.size(); i++) {
            WXComponent wXComponent = this.mRefreshs.get(i);
            wXComponent.createViewImpl();
            checkRefreshOrLoading(wXComponent);
        }
    }

    @Override // com.taobao.weex.ui.component.WXBaseScroller
    public ViewGroup getInnerView() {
        if (getHostView() == null) {
            return null;
        }
        if (getHostView() instanceof DCBounceScrollerView) {
            return (ViewGroup) ((DCBounceScrollerView) getHostView()).getInnerView();
        }
        return (ViewGroup) getHostView();
    }

    @Override // com.taobao.weex.ui.component.WXComponent
    public void addEvent(String str) {
        super.addEvent(str);
        if (DCScrollStartEndHelper.isScrollEvent(str) && getInnerView() != null && !this.mHasAddScrollEvent) {
            this.mHasAddScrollEvent = true;
            if (getInnerView() instanceof DCWXScrollView) {
                ((DCWXScrollView) getInnerView()).addScrollViewListener(new DCWXScrollView.WXScrollViewListener() {
                    /* class com.taobao.weex.ui.component.DCWXScroller.AnonymousClass1 */

                    @Override // io.dcloud.feature.weex_scroller.view.DCWXScrollView.WXScrollViewListener
                    public void onScroll(DCWXScrollView dCWXScrollView, int i, int i2) {
                    }

                    @Override // io.dcloud.feature.weex_scroller.view.DCWXScrollView.WXScrollViewListener
                    public void onScrollChanged(DCWXScrollView dCWXScrollView, int i, int i2, int i3, int i4) {
                        DCWXScroller.this.getScrollStartEndHelper().onScrolled(i, i2);
                        if (DCWXScroller.this.getEvents().contains("scroll") && DCWXScroller.this.shouldReport(i, i2)) {
                            DCWXScroller.this.fireScrollEvent(dCWXScrollView.getContentFrame(), i, i2, i3, i4);
                        }
                    }

                    @Override // io.dcloud.feature.weex_scroller.view.DCWXScrollView.WXScrollViewListener
                    public void onScrollToBottom(DCWXScrollView dCWXScrollView, int i, int i2) {
                        HashMap hashMap = new HashMap(1);
                        hashMap.put("direction", "bottom");
                        HashMap hashMap2 = new HashMap(1);
                        hashMap2.put("detail", hashMap);
                        DCWXScroller.this.fireEvent("scrolltolower", hashMap2);
                    }

                    @Override // io.dcloud.feature.weex_scroller.view.DCWXScrollView.WXScrollViewListener
                    public void onScrollToTop(DCWXScrollView dCWXScrollView, int i, int i2) {
                        HashMap hashMap = new HashMap(1);
                        hashMap.put("direction", "top");
                        HashMap hashMap2 = new HashMap(1);
                        hashMap2.put("detail", hashMap);
                        DCWXScroller.this.fireEvent("scrolltoupper", hashMap2);
                    }

                    @Override // io.dcloud.feature.weex_scroller.view.DCWXScrollView.WXScrollViewListener
                    public void onScrollStopped(DCWXScrollView dCWXScrollView, int i, int i2) {
                        DCWXScroller.this.getScrollStartEndHelper().onScrolled(i, i2);
                        if (DCWXScroller.this.getEvents().contains("scroll")) {
                            DCWXScroller.this.fireScrollEvent(dCWXScrollView.getContentFrame(), i, i2, 0, 0);
                        }
                    }
                });
            } else if (getInnerView() instanceof DCWXHorizontalScrollView) {
                ((DCWXHorizontalScrollView) getInnerView()).addScrollViewListener(new DCWXHorizontalScrollView.ScrollViewListener() {
                    /* class com.taobao.weex.ui.component.DCWXScroller.AnonymousClass2 */

                    @Override // io.dcloud.feature.weex_scroller.view.DCWXHorizontalScrollView.ScrollViewListener
                    public void onScrollChanged(DCWXHorizontalScrollView dCWXHorizontalScrollView, int i, int i2, int i3, int i4) {
                        DCWXScroller.this.getScrollStartEndHelper().onScrolled(i, i2);
                        if (DCWXScroller.this.getEvents().contains("scroll") && DCWXScroller.this.shouldReport(i, i2)) {
                            DCWXScroller.this.fireScrollEvent(dCWXHorizontalScrollView.getContentFrame(), i, i2, i3, i4);
                        }
                    }

                    @Override // io.dcloud.feature.weex_scroller.view.DCWXHorizontalScrollView.ScrollViewListener
                    public void onScrolltoTop() {
                        HashMap hashMap = new HashMap(1);
                        hashMap.put("direction", "top");
                        HashMap hashMap2 = new HashMap(1);
                        hashMap2.put("detail", hashMap);
                        DCWXScroller.this.fireEvent("scrolltoupper", hashMap2);
                    }

                    @Override // io.dcloud.feature.weex_scroller.view.DCWXHorizontalScrollView.ScrollViewListener
                    public void onScrollToBottom() {
                        HashMap hashMap = new HashMap(1);
                        hashMap.put("direction", "bottom");
                        HashMap hashMap2 = new HashMap(1);
                        hashMap2.put("detail", hashMap);
                        DCWXScroller.this.fireEvent("scrolltolower", hashMap2);
                    }
                });
            }
        }
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void fireScrollEvent(Rect rect, int i, int i2, int i3, int i4) {
        fireEvent("scroll", getScrollEvent(i, i2, i3, i4));
    }

    public Map<String, Object> getScrollEvent(int i, int i2, int i3, int i4) {
        int i5;
        Rect rect = new Rect();
        int i6 = 0;
        if (getInnerView() instanceof DCWXScrollView) {
            rect = ((DCWXScrollView) getInnerView()).getContentFrame();
            i5 = getInnerView().getScrollY();
        } else {
            if (getInnerView() instanceof DCWXHorizontalScrollView) {
                rect = ((DCWXHorizontalScrollView) getInnerView()).getContentFrame();
                i6 = getInnerView().getScrollX();
            }
            i5 = 0;
        }
        HashMap hashMap = new HashMap(2);
        HashMap hashMap2 = new HashMap(6);
        new HashMap(2);
        float instanceViewPortWidthWithFloat = getInstance().getInstanceViewPortWidthWithFloat();
        hashMap2.put("scrollWidth", Float.valueOf(WXViewUtils.getWebPxByWidth((float) rect.width(), instanceViewPortWidthWithFloat)));
        hashMap2.put("scrollHeight", Float.valueOf(WXViewUtils.getWebPxByWidth((float) rect.height(), instanceViewPortWidthWithFloat)));
        hashMap2.put(Constants.Name.SCROLL_LEFT, Float.valueOf(WXViewUtils.getWebPxByWidth((float) i6, instanceViewPortWidthWithFloat)));
        hashMap2.put(Constants.Name.SCROLL_TOP, Float.valueOf(WXViewUtils.getWebPxByWidth((float) i5, instanceViewPortWidthWithFloat)));
        hashMap2.put("deltaX", Float.valueOf(WXViewUtils.getWebPxByWidth((float) i3, instanceViewPortWidthWithFloat)));
        hashMap2.put("deltaY", Float.valueOf(WXViewUtils.getWebPxByWidth((float) i4, instanceViewPortWidthWithFloat)));
        hashMap.put("detail", hashMap2);
        return hashMap;
    }

    @Override // com.taobao.weex.ui.component.WXBaseScroller
    public Map<String, Object> getScrollEvent(int i, int i2) {
        Rect rect = new Rect();
        if (getInnerView() instanceof DCWXScrollView) {
            rect = ((DCWXScrollView) getInnerView()).getContentFrame();
        } else if (getInnerView() instanceof DCWXHorizontalScrollView) {
            rect = ((DCWXHorizontalScrollView) getInnerView()).getContentFrame();
        }
        HashMap hashMap = new HashMap(2);
        HashMap hashMap2 = new HashMap(2);
        HashMap hashMap3 = new HashMap(2);
        float instanceViewPortWidthWithFloat = getInstance().getInstanceViewPortWidthWithFloat();
        hashMap2.put("width", Float.valueOf(WXViewUtils.getWebPxByWidth((float) rect.width(), instanceViewPortWidthWithFloat)));
        hashMap2.put("height", Float.valueOf(WXViewUtils.getWebPxByWidth((float) rect.height(), instanceViewPortWidthWithFloat)));
        hashMap3.put(Constants.Name.X, Float.valueOf(WXViewUtils.getWebPxByWidth((float) i, instanceViewPortWidthWithFloat)));
        hashMap3.put(Constants.Name.Y, Float.valueOf(WXViewUtils.getWebPxByWidth((float) i2, instanceViewPortWidthWithFloat)));
        hashMap.put(Constants.Name.CONTENT_SIZE, hashMap2);
        hashMap.put(Constants.Name.CONTENT_OFFSET, hashMap3);
        return hashMap;
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private boolean shouldReport(int i, int i2) {
        if (this.mLastReport.x == -1 && this.mLastReport.y == -1) {
            this.mLastReport.x = i;
            this.mLastReport.y = i2;
            return true;
        } else if (this.mOrientation == 0 && Math.abs(i - this.mLastReport.x) >= this.mOffsetAccuracy) {
            this.mLastReport.x = i;
            this.mLastReport.y = i2;
            return true;
        } else if (this.mOrientation != 1 || Math.abs(i2 - this.mLastReport.y) < this.mOffsetAccuracy) {
            return false;
        } else {
            this.mLastReport.x = i;
            this.mLastReport.y = i2;
            return true;
        }
    }

    @Override // io.dcloud.feature.uniapp.ui.component.AbsVContainer
    public void addSubView(View view, int i) {
        FrameLayout frameLayout;
        if (view != null && (frameLayout = this.mRealView) != null && !(view instanceof WXBaseRefreshLayout)) {
            if (i >= frameLayout.getChildCount()) {
                i = -1;
            }
            if (view.getParent() != null) {
                ((ViewGroup) view.getParent()).removeView(view);
            }
            if (i == -1) {
                this.mRealView.addView(view);
            } else {
                this.mRealView.addView(view, i);
            }
        }
    }

    /* access modifiers changed from: protected */
    @Override // com.taobao.weex.ui.component.WXVContainer, io.dcloud.feature.uniapp.ui.component.AbsVContainer
    public int getChildrenLayoutTopOffset() {
        int size;
        if (this.mChildrenLayoutOffset == 0 && (size = this.mRefreshs.size()) > 0) {
            for (int i = 0; i < size; i++) {
                this.mChildrenLayoutOffset += this.mRefreshs.get(i).getLayoutTopOffsetForSibling();
            }
        }
        return this.mChildrenLayoutOffset;
    }

    @Override // io.dcloud.feature.uniapp.ui.component.AbsVContainer
    public void addChild(WXComponent wXComponent, int i) {
        if (wXComponent.getAttrs().containsKey("id")) {
            this.childens.put(wXComponent.getAttrs().get("id").toString(), wXComponent);
        }
        if ((wXComponent instanceof WXBaseRefresh) && checkRefreshOrLoading(wXComponent)) {
            this.mRefreshs.add(wXComponent);
        }
        super.addChild(wXComponent, i);
    }

    private boolean checkRefreshOrLoading(final WXComponent wXComponent) {
        boolean z;
        if (!(wXComponent instanceof WXRefresh) || getHostView() == null) {
            z = false;
        } else {
            ((BaseBounceView) getHostView()).setOnRefreshListener((WXRefresh) wXComponent);
            this.handler.postDelayed(WXThread.secure(new Runnable() {
                /* class com.taobao.weex.ui.component.DCWXScroller.AnonymousClass3 */

                public void run() {
                    ((BaseBounceView) DCWXScroller.this.getHostView()).setHeaderView(wXComponent);
                }
            }), 100);
            z = true;
        }
        if (!(wXComponent instanceof WXLoading) || getHostView() == null) {
            return z;
        }
        ((BaseBounceView) getHostView()).setOnLoadingListener((WXLoading) wXComponent);
        this.handler.postDelayed(WXThread.secure(new Runnable() {
            /* class com.taobao.weex.ui.component.DCWXScroller.AnonymousClass4 */

            public void run() {
                ((BaseBounceView) DCWXScroller.this.getHostView()).setFooterView(wXComponent);
            }
        }), 100);
        return true;
    }

    @Override // io.dcloud.feature.uniapp.ui.component.AbsVContainer
    public void remove(WXComponent wXComponent, boolean z) {
        super.remove(wXComponent, z);
        if (wXComponent instanceof WXLoading) {
            ((BaseBounceView) getHostView()).removeFooterView(wXComponent);
        } else if (wXComponent instanceof WXRefresh) {
            ((BaseBounceView) getHostView()).removeHeaderView(wXComponent);
        }
    }

    @Override // io.dcloud.feature.uniapp.ui.component.AbsVContainer, com.taobao.weex.ui.component.WXComponent
    public void destroy() {
        if (getInnerView() != null && (getInnerView() instanceof IWXScroller)) {
            ((IWXScroller) getInnerView()).destroy();
        }
        Map<String, AppearanceHelper> map = this.mAppearanceComponents;
        if (map != null) {
            map.clear();
        }
        Map<String, Map<String, WXComponent>> map2 = this.mStickyMap;
        if (map2 != null) {
            map2.clear();
        }
        if (!(this.mOnAttachStateChangeListener == null || getInnerView() == null)) {
            getInnerView().removeOnAttachStateChangeListener(this.mOnAttachStateChangeListener);
        }
        super.destroy();
    }

    @Override // com.taobao.weex.ui.component.WXComponent
    public void setMarginsSupportRTL(ViewGroup.MarginLayoutParams marginLayoutParams, int i, int i2, int i3, int i4) {
        if (Build.VERSION.SDK_INT >= 17) {
            marginLayoutParams.setMargins(i, i2, i3, i4);
            marginLayoutParams.setMarginStart(i);
            marginLayoutParams.setMarginEnd(i3);
        } else if (marginLayoutParams instanceof FrameLayout.LayoutParams) {
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams) marginLayoutParams;
            if (isLayoutRTL()) {
                layoutParams.gravity = 53;
                marginLayoutParams.setMargins(i3, i2, i, i4);
                return;
            }
            layoutParams.gravity = 51;
            marginLayoutParams.setMargins(i, i2, i3, i4);
        } else {
            marginLayoutParams.setMargins(i, i2, i3, i4);
        }
    }

    @Override // com.taobao.weex.ui.component.WXComponent
    public void setLayout(WXComponent wXComponent) {
        if (!TextUtils.isEmpty(wXComponent.getComponentType()) && !TextUtils.isEmpty(wXComponent.getRef()) && wXComponent.getLayoutPosition() != null && wXComponent.getLayoutSize() != null) {
            if (wXComponent.getHostView() != null) {
                ViewCompat.setLayoutDirection(wXComponent.getHostView(), wXComponent.isLayoutRTL() ? 1 : 0);
            }
            super.setLayout(wXComponent);
        }
    }

    /* access modifiers changed from: protected */
    @Override // com.taobao.weex.ui.component.WXComponent
    public WXComponent.MeasureOutput measure(int i, int i2) {
        WXComponent.MeasureOutput measureOutput = new WXComponent.MeasureOutput();
        if (this.mOrientation == 0) {
            int screenWidth = WXViewUtils.getScreenWidth(WXEnvironment.sApplication);
            int weexWidth = WXViewUtils.getWeexWidth(getInstanceId());
            if (weexWidth < screenWidth) {
                screenWidth = weexWidth;
            }
            if (i > screenWidth) {
                i = -1;
            }
            measureOutput.width = i;
            measureOutput.height = i2;
        } else {
            int screenHeight = WXViewUtils.getScreenHeight(WXEnvironment.sApplication);
            int weexHeight = WXViewUtils.getWeexHeight(getInstanceId());
            if (weexHeight < screenHeight) {
                screenHeight = weexHeight;
            }
            if (i2 > screenHeight) {
                i2 = -1;
            }
            measureOutput.height = i2;
            measureOutput.width = i;
        }
        return measureOutput;
    }

    /* JADX DEBUG: Multi-variable search result rejected for r0v11, resolved type: io.dcloud.feature.weex_scroller.view.DCWXHorizontalScrollView */
    /* JADX WARN: Multi-variable type inference failed */
    /* access modifiers changed from: protected */
    @Override // com.taobao.weex.ui.component.WXComponent
    public ViewGroup initComponentHostView(Context context) {
        boolean z;
        boolean z2;
        boolean z3;
        DCBounceScrollerView dCBounceScrollerView;
        String str = "vertical";
        if (getAttrs().isEmpty()) {
            z3 = false;
            z2 = true;
            z = false;
        } else {
            z3 = getAttrs().containsKey("scrollX") ? Boolean.parseBoolean(getAttrs().get("scrollX").toString()) : false;
            z = getAttrs().containsKey("scrollY") ? Boolean.parseBoolean(getAttrs().get("scrollY").toString()) : false;
            if (z) {
                z2 = !getAttrs().get("scrollY").equals(AbsoluteConst.FALSE);
            } else if (z3) {
                z2 = !getAttrs().get("scrollX").equals(AbsoluteConst.FALSE);
                str = Constants.Value.HORIZONTAL;
            } else {
                if (getAttrs().containsKey(Constants.Name.SCROLL_DIRECTION)) {
                    str = getAttrs().getScrollDirection();
                }
                z2 = true;
            }
            Object obj = getAttrs().get(Constants.Name.PAGE_ENABLED);
            this.pageEnable = obj != null && Boolean.parseBoolean(obj.toString());
            Object obj2 = getAttrs().get(Constants.Name.PAGE_SIZE);
            if (obj2 != null) {
                float realPxByWidth = WXViewUtils.getRealPxByWidth(WXUtils.getFloat(obj2), getInstance().getInstanceViewPortWidth());
                if (realPxByWidth != 0.0f) {
                    this.pageSize = (int) realPxByWidth;
                }
            }
        }
        if (Constants.Value.HORIZONTAL.equals(str)) {
            this.mOrientation = 0;
            final DCWXHorizontalScrollView dCWXHorizontalScrollView = new DCWXHorizontalScrollView(context);
            dCWXHorizontalScrollView.setWAScroller(this);
            dCWXHorizontalScrollView.setScrollable(z2);
            this.mRealView = new FrameLayout(context);
            dCWXHorizontalScrollView.setScrollViewListener(new DCWXHorizontalScrollView.ScrollViewListener() {
                /* class com.taobao.weex.ui.component.DCWXScroller.AnonymousClass5 */

                @Override // io.dcloud.feature.weex_scroller.view.DCWXHorizontalScrollView.ScrollViewListener
                public void onScrollToBottom() {
                }

                @Override // io.dcloud.feature.weex_scroller.view.DCWXHorizontalScrollView.ScrollViewListener
                public void onScrolltoTop() {
                }

                @Override // io.dcloud.feature.weex_scroller.view.DCWXHorizontalScrollView.ScrollViewListener
                public void onScrollChanged(DCWXHorizontalScrollView dCWXHorizontalScrollView, int i, int i2, int i3, int i4) {
                    if (DCWXScroller.this.getInstance() != null) {
                        DCWXScroller.this.procAppear(i, i2, i3, i4);
                        DCWXScroller.this.onLoadMore(dCWXHorizontalScrollView, i, i2);
                    }
                }
            });
            dCWXHorizontalScrollView.addView(this.mRealView, new FrameLayout.LayoutParams(-1, -1));
            dCWXHorizontalScrollView.setHorizontalScrollBarEnabled(true);
            this.mScrollerView = dCWXHorizontalScrollView;
            dCWXHorizontalScrollView.setScrollBarSize(DensityUtils.dip2px(getInstance().getContext(), 4.0f));
            final AnonymousClass6 r10 = new View.OnLayoutChangeListener() {
                /* class com.taobao.weex.ui.component.DCWXScroller.AnonymousClass6 */

                public void onLayoutChange(final View view, int i, int i2, int i3, int i4, int i5, int i6, int i7, int i8) {
                    dCWXHorizontalScrollView.post(new Runnable() {
                        /* class com.taobao.weex.ui.component.DCWXScroller.AnonymousClass6.AnonymousClass1 */

                        public void run() {
                            if (DCWXScroller.this.isLayoutRTL()) {
                                dCWXHorizontalScrollView.scrollTo(view.getMeasuredWidth(), this.getScrollY());
                                return;
                            }
                            dCWXHorizontalScrollView.scrollTo(0, this.getScrollY());
                        }
                    });
                    if (DCWXScroller.this.mRealView != null) {
                        DCWXScroller.this.mRealView.removeOnLayoutChangeListener(this);
                    }
                }
            };
            this.mRealView.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener() {
                /* class com.taobao.weex.ui.component.DCWXScroller.AnonymousClass7 */

                public void onViewAttachedToWindow(View view) {
                    view.addOnLayoutChangeListener(r10);
                }

                public void onViewDetachedFromWindow(View view) {
                    view.removeOnLayoutChangeListener(r10);
                }
            });
            dCBounceScrollerView = dCWXHorizontalScrollView;
            if (this.pageEnable) {
                this.mGestureDetector = new GestureDetector(new MyGestureDetector(dCWXHorizontalScrollView));
                dCWXHorizontalScrollView.setOnTouchListener(new View.OnTouchListener() {
                    /* class com.taobao.weex.ui.component.DCWXScroller.AnonymousClass8 */

                    public boolean onTouch(View view, MotionEvent motionEvent) {
                        if (DCWXScroller.this.pageSize == 0) {
                            DCWXScroller.this.pageSize = view.getMeasuredWidth();
                        }
                        if (DCWXScroller.this.mGestureDetector.onTouchEvent(motionEvent)) {
                            return true;
                        }
                        if (motionEvent.getAction() != 1 && motionEvent.getAction() != 3) {
                            return false;
                        }
                        int scrollX = DCWXScroller.this.getScrollX();
                        int i = DCWXScroller.this.pageSize;
                        DCWXScroller.this.mActiveFeature = (scrollX + (i / 2)) / i;
                        dCWXHorizontalScrollView.smoothScrollTo(DCWXScroller.this.mActiveFeature * i, 0);
                        return true;
                    }
                });
                dCBounceScrollerView = dCWXHorizontalScrollView;
            }
        } else {
            this.mOrientation = 1;
            DCBounceScrollerView dCBounceScrollerView2 = new DCBounceScrollerView(context, this.mOrientation, this);
            this.mRealView = new FrameLayout(context);
            DCWXScrollView dCWXScrollView = (DCWXScrollView) dCBounceScrollerView2.getInnerView();
            dCWXScrollView.addScrollViewListener(this);
            if (z3 || z) {
                dCWXScrollView.setScrollable(z2);
            } else {
                dCWXScrollView.setScrollable(false);
            }
            dCWXScrollView.addView(this.mRealView, new FrameLayout.LayoutParams(-1, -1));
            dCWXScrollView.setVerticalScrollBarEnabled(true);
            this.mScrollerView = dCWXScrollView;
            dCWXScrollView.setNestedScrollingEnabled(WXUtils.getBoolean(getAttrs().get(Constants.Name.NEST_SCROLLING_ENABLED), true).booleanValue());
            dCWXScrollView.addScrollViewListener(new DCWXScrollView.WXScrollViewListener() {
                /* class com.taobao.weex.ui.component.DCWXScroller.AnonymousClass9 */

                @Override // io.dcloud.feature.weex_scroller.view.DCWXScrollView.WXScrollViewListener
                public void onScrollChanged(DCWXScrollView dCWXScrollView, int i, int i2, int i3, int i4) {
                }

                @Override // io.dcloud.feature.weex_scroller.view.DCWXScrollView.WXScrollViewListener
                public void onScrollToBottom(DCWXScrollView dCWXScrollView, int i, int i2) {
                }

                @Override // io.dcloud.feature.weex_scroller.view.DCWXScrollView.WXScrollViewListener
                public void onScrollToTop(DCWXScrollView dCWXScrollView, int i, int i2) {
                }

                @Override // io.dcloud.feature.weex_scroller.view.DCWXScrollView.WXScrollViewListener
                public void onScrollStopped(DCWXScrollView dCWXScrollView, int i, int i2) {
                    if (DCWXScroller.this.getInstance() != null) {
                        List<OnWXScrollListener> wXScrollListeners = DCWXScroller.this.getInstance().getWXScrollListeners();
                        if (wXScrollListeners != null && wXScrollListeners.size() > 0) {
                            for (OnWXScrollListener onWXScrollListener : wXScrollListeners) {
                                if (onWXScrollListener != null) {
                                    onWXScrollListener.onScrollStateChanged(dCWXScrollView, i, i2, 0);
                                }
                            }
                        }
                        DCWXScroller.this.getScrollStartEndHelper().onScrollStateChanged(0);
                    }
                }

                @Override // io.dcloud.feature.weex_scroller.view.DCWXScrollView.WXScrollViewListener
                public void onScroll(DCWXScrollView dCWXScrollView, int i, int i2) {
                    List<OnWXScrollListener> wXScrollListeners;
                    if (!(DCWXScroller.this.getInstance() == null || (wXScrollListeners = DCWXScroller.this.getInstance().getWXScrollListeners()) == null || wXScrollListeners.size() <= 0)) {
                        for (OnWXScrollListener onWXScrollListener : wXScrollListeners) {
                            if (onWXScrollListener != null) {
                                if (!(onWXScrollListener instanceof ICheckBindingScroller)) {
                                    onWXScrollListener.onScrolled(dCWXScrollView, i, i2);
                                } else if (((ICheckBindingScroller) onWXScrollListener).isNeedScroller(DCWXScroller.this.getRef(), null)) {
                                    onWXScrollListener.onScrolled(dCWXScrollView, i, i2);
                                }
                            }
                        }
                    }
                }
            });
            dCBounceScrollerView = dCBounceScrollerView2;
        }
        dCBounceScrollerView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener() {
            /* class com.taobao.weex.ui.component.DCWXScroller.AnonymousClass10 */

            public void onGlobalLayout() {
                DCWXScroller.this.procAppear(0, 0, 0, 0);
                View hostView = DCWXScroller.this.getHostView();
                if (hostView != null && DCWXScroller.this.getInstance() != null) {
                    if (Build.VERSION.SDK_INT >= 16) {
                        hostView.getViewTreeObserver().removeOnGlobalLayoutListener(this);
                    } else {
                        hostView.getViewTreeObserver().removeGlobalOnLayoutListener(this);
                    }
                }
            }
        });
        AnonymousClass11 r102 = new View.OnAttachStateChangeListener() {
            /* class com.taobao.weex.ui.component.DCWXScroller.AnonymousClass11 */

            public void onViewAttachedToWindow(View view) {
                DCWXScroller.this.mIsHostAttachedToWindow = true;
                DCWXScroller dCWXScroller = DCWXScroller.this;
                dCWXScroller.procAppear(dCWXScroller.getScrollX(), DCWXScroller.this.getScrollY(), DCWXScroller.this.getScrollX(), DCWXScroller.this.getScrollY());
            }

            public void onViewDetachedFromWindow(View view) {
                DCWXScroller.this.mIsHostAttachedToWindow = false;
                DCWXScroller.this.dispatchDisappearEvent();
            }
        };
        this.mOnAttachStateChangeListener = r102;
        dCBounceScrollerView.addOnAttachStateChangeListener(r102);
        return dCBounceScrollerView;
    }

    @Override // com.taobao.weex.ui.component.Scrollable, com.taobao.weex.ui.component.WXBaseScroller
    public int getScrollY() {
        if (getInnerView() == null) {
            return 0;
        }
        return getInnerView().getScrollY();
    }

    @Override // com.taobao.weex.ui.component.Scrollable, com.taobao.weex.ui.component.WXBaseScroller
    public int getScrollX() {
        if (getInnerView() == null) {
            return 0;
        }
        return getInnerView().getScrollX();
    }

    @Override // com.taobao.weex.ui.component.Scrollable, com.taobao.weex.ui.component.WXBaseScroller
    public int getOrientation() {
        return this.mOrientation;
    }

    @Override // com.taobao.weex.ui.component.WXBaseScroller
    public Map<String, Map<String, WXComponent>> getStickMap() {
        return this.mStickyMap;
    }

    /* JADX INFO: Can't fix incorrect switch cases order, some code will duplicate */
    /* access modifiers changed from: protected */
    @Override // com.taobao.weex.ui.component.WXComponent
    public boolean setProperty(String str, Object obj) {
        str.hashCode();
        char c = 65535;
        switch (str.hashCode()) {
            case -223520855:
                if (str.equals(Constants.Name.SHOW_SCROLLBAR)) {
                    c = 0;
                    break;
                }
                break;
            case -101546095:
                if (str.equals("scrollWithAnimation")) {
                    c = 1;
                    break;
                }
                break;
            case -5620052:
                if (str.equals(Constants.Name.OFFSET_ACCURACY)) {
                    c = 2;
                    break;
                }
                break;
            case 66669991:
                if (str.equals(Constants.Name.SCROLLABLE)) {
                    c = 3;
                    break;
                }
                break;
            case 1926689579:
                if (str.equals("scrollX")) {
                    c = 4;
                    break;
                }
                break;
            case 1926689580:
                if (str.equals("scrollY")) {
                    c = 5;
                    break;
                }
                break;
        }
        switch (c) {
            case 0:
                Boolean bool = WXUtils.getBoolean(obj, null);
                if (bool != null) {
                    setShowScrollbar(bool.booleanValue());
                }
                return true;
            case 1:
                setScrollWithAnimation(WXUtils.getBoolean(obj, false).booleanValue());
                break;
            case 2:
                setOffsetAccuracy(WXUtils.getInteger(obj, 10).intValue());
                return true;
            case 3:
                setScrollable(WXUtils.getBoolean(obj, true).booleanValue());
                return true;
            case 4:
            case 5:
                setScrollable(!String.valueOf(obj).equals(AbsoluteConst.FALSE));
                return true;
        }
        return super.setProperty(str, obj);
    }

    @WXComponentProp(name = "scrollIntoView")
    public void setScrollIntoView(final String str) {
        if (!this.isViewLayoutFinished.get()) {
            getInnerView().getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener() {
                /* class com.taobao.weex.ui.component.DCWXScroller.AnonymousClass12 */

                public void onGlobalLayout() {
                    if (DCWXScroller.this.getInstance() != null) {
                        WXComponent wXComponentById = WXSDKManager.getInstance().getWXRenderManager().getWXComponentById(DCWXScroller.this.getInstanceId(), str);
                        if (wXComponentById != null) {
                            DCWXScroller.this.scrollTo(wXComponentById, JSONObject.parseObject("{'animated':false}"));
                        }
                        DCWXScroller.this.isViewLayoutFinished.set(true);
                        DCWXScroller.this.handler.postDelayed(new Runnable() {
                            /* class com.taobao.weex.ui.component.DCWXScroller.AnonymousClass12.AnonymousClass1 */

                            public void run() {
                                DCWXScroller.this.getInnerView().getViewTreeObserver().removeOnGlobalLayoutListener(this);
                            }
                        }, 100);
                    }
                }
            });
            return;
        }
        WXComponent wXComponentById = WXSDKManager.getInstance().getWXRenderManager().getWXComponentById(getInstanceId(), str);
        if (wXComponentById != null) {
            scrollTo(wXComponentById, JSONObject.parseObject(StringUtil.format("{'animated':%b}", Boolean.valueOf(this.isAnimation))));
        }
    }

    @JSMethod
    public void scrollTo(int i) {
        float realPxByWidth = WXViewUtils.getRealPxByWidth((float) i, getInstance().getInstanceViewPortWidth());
        if (getInnerView() instanceof DCWXScrollView) {
            ((DCWXScrollView) getInnerView()).smoothScrollTo(0, (int) realPxByWidth);
        } else if (getInnerView() instanceof DCWXHorizontalScrollView) {
            ((DCWXHorizontalScrollView) getInnerView()).smoothScrollTo((int) realPxByWidth, 0);
        }
    }

    @JSMethod
    public void scrollTo(String str, JSCallback jSCallback) {
        float realPxByWidth = WXViewUtils.getRealPxByWidth(WXUtils.getFloat(JSON.parseObject(str).getString(Constants.Name.SCROLL_TOP)), getInstance().getInstanceViewPortWidth());
        if (getInnerView() instanceof DCWXScrollView) {
            ((DCWXScrollView) getInnerView()).smoothScrollTo(0, (int) realPxByWidth);
        } else if (getInnerView() instanceof DCWXHorizontalScrollView) {
            ((DCWXHorizontalScrollView) getInnerView()).smoothScrollTo((int) realPxByWidth, 0);
        }
        if (jSCallback != null) {
            HashMap hashMap = new HashMap();
            hashMap.put("type", WXImage.SUCCEED);
            jSCallback.invoke(hashMap);
        }
    }

    private WXComponent getViewById(String str) {
        if (this.childens.containsKey(str)) {
            return this.childens.get(str);
        }
        for (WXComponent wXComponent : this.childens.values()) {
            if (wXComponent.getAttrs().containsKey("id") && wXComponent.getAttrs().get("id").equals(str)) {
                return wXComponent;
            }
        }
        return null;
    }

    @WXComponentProp(name = Constants.Name.SHOW_SCROLLBAR)
    public void setShowScrollbar(boolean z) {
        if (getInnerView() != null) {
            if (this.mOrientation == 1) {
                getInnerView().setVerticalScrollBarEnabled(z);
            } else {
                getInnerView().setHorizontalScrollBarEnabled(z);
            }
        }
    }

    @WXComponentProp(name = "scrollWithAnimation")
    public void setScrollWithAnimation(boolean z) {
        this.isAnimation = z;
    }

    @WXComponentProp(name = "upperThreshold")
    public void setUpperHeight(int i) {
        ViewGroup innerView = getInnerView();
        float realPxByWidth = WXViewUtils.getRealPxByWidth((float) i, getInstance().getInstanceViewPortWidth());
        if (innerView instanceof DCWXHorizontalScrollView) {
            ((DCWXHorizontalScrollView) innerView).setUpperLength(realPxByWidth);
        } else if (innerView instanceof DCWXScrollView) {
            ((DCWXScrollView) innerView).setUpperLength(realPxByWidth);
        }
    }

    @WXComponentProp(name = "enable-back-to-top")
    public void isEnableBackToTop(boolean z) {
        this.canScroll2Top = z;
    }

    @JSMethod
    public void scrollToTop() {
        if ((getInnerView() instanceof DCWXScrollView) && this.canScroll2Top) {
            ((DCWXScrollView) getInnerView()).smoothScrollTo(0, 0);
        }
    }

    @WXComponentProp(name = Constants.Name.SCROLL_TOP)
    public void setScrollTop(String str) {
        if (getInnerView() instanceof DCWXScrollView) {
            final float realPxByWidth = WXViewUtils.getRealPxByWidth(WXUtils.getFloat(str), getInstance().getInstanceViewPortWidth());
            if (!this.isViewLayoutFinished.get()) {
                getInnerView().getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener() {
                    /* class com.taobao.weex.ui.component.DCWXScroller.AnonymousClass13 */

                    public void onGlobalLayout() {
                        DCWXScroller.this.getInnerView().scrollTo(0, (int) realPxByWidth);
                        DCWXScroller.this.isViewLayoutFinished.set(true);
                        DCWXScroller.this.handler.postDelayed(new Runnable() {
                            /* class com.taobao.weex.ui.component.DCWXScroller.AnonymousClass13.AnonymousClass1 */

                            public void run() {
                                DCWXScroller.this.getInnerView().getViewTreeObserver().removeOnGlobalLayoutListener(this);
                            }
                        }, 100);
                    }
                });
                return;
            }
            if (this.isAnimation) {
                if (getInnerView() instanceof DCWXScrollView) {
                    ((DCWXScrollView) getInnerView()).stopScroll();
                }
                ObjectAnimator.ofInt(getInnerView(), "scrollY", getInnerView().getScrollY(), (int) realPxByWidth).setDuration(200L).start();
            } else {
                getInnerView().post(new Runnable() {
                    /* class com.taobao.weex.ui.component.DCWXScroller.AnonymousClass14 */

                    public void run() {
                        DCWXScroller.this.getInnerView().scrollTo(0, (int) realPxByWidth);
                    }
                });
            }
            this.isViewLayoutFinished.set(true);
        }
    }

    @WXComponentProp(name = Constants.Name.SCROLL_LEFT)
    public void setScrollLeft(String str) {
        if (getInnerView() instanceof DCWXHorizontalScrollView) {
            final float realPxByWidth = WXViewUtils.getRealPxByWidth(WXUtils.getFloat(str), getInstance().getInstanceViewPortWidth());
            if (!this.isViewLayoutFinished.get()) {
                getInnerView().getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener() {
                    /* class com.taobao.weex.ui.component.DCWXScroller.AnonymousClass15 */

                    public void onGlobalLayout() {
                        ObjectAnimator.ofInt(DCWXScroller.this.getInnerView(), "scrollX", DCWXScroller.this.getInnerView().getScrollX(), (int) realPxByWidth).setDuration(1L).start();
                        DCWXScroller.this.isViewLayoutFinished.set(true);
                        DCWXScroller.this.handler.postDelayed(new Runnable() {
                            /* class com.taobao.weex.ui.component.DCWXScroller.AnonymousClass15.AnonymousClass1 */

                            public void run() {
                                DCWXScroller.this.getInnerView().getViewTreeObserver().removeOnGlobalLayoutListener(this);
                            }
                        }, 100);
                    }
                });
                return;
            }
            if (this.isAnimation) {
                if (getInnerView() instanceof DCWXHorizontalScrollView) {
                    ((DCWXHorizontalScrollView) getInnerView()).stopScroll();
                }
                ObjectAnimator.ofInt(getInnerView(), "scrollX", getInnerView().getScrollX(), (int) realPxByWidth).setDuration(200L).start();
            } else {
                ((DCWXHorizontalScrollView) getInnerView()).smoothScrollTo((int) realPxByWidth, 0);
            }
            this.isViewLayoutFinished.set(true);
        }
    }

    @WXComponentProp(name = "lowerThreshold")
    public void setLowwerHeight(int i) {
        ViewGroup innerView = getInnerView();
        float realPxByWidth = WXViewUtils.getRealPxByWidth((float) i, getInstance().getInstanceViewPortWidth());
        if (innerView instanceof DCWXHorizontalScrollView) {
            ((DCWXHorizontalScrollView) innerView).setLowwerLength(realPxByWidth);
        } else if (innerView instanceof DCWXScrollView) {
            ((DCWXScrollView) innerView).setLowwerLength(realPxByWidth);
        }
    }

    /* access modifiers changed from: protected */
    @Override // com.taobao.weex.ui.component.WXComponent
    public void onFinishLayout() {
        super.onFinishLayout();
    }

    public void setScrollable(boolean z) {
        this.isScrollable = z;
        ViewGroup innerView = getInnerView();
        if (innerView instanceof DCWXHorizontalScrollView) {
            ((DCWXHorizontalScrollView) innerView).setScrollable(z);
        } else if (innerView instanceof DCWXScrollView) {
            ((DCWXScrollView) innerView).setScrollable(z);
        }
    }

    @WXComponentProp(name = Constants.Name.OFFSET_ACCURACY)
    public void setOffsetAccuracy(int i) {
        this.mOffsetAccuracy = (int) WXViewUtils.getRealPxByWidth((float) i, getInstance().getInstanceViewPortWidth());
    }

    @WXComponentProp(name = "decelerationRate")
    public void setDecelerationRate(float f) {
        if (getInnerView() instanceof DCWXScrollView) {
            ((DCWXScrollView) getInnerView()).setRate(f);
        }
    }

    @Override // com.taobao.weex.ui.component.Scrollable, com.taobao.weex.ui.component.WXBaseScroller
    public boolean isScrollable() {
        return this.isScrollable;
    }

    @Override // com.taobao.weex.ui.component.Scrollable, com.taobao.weex.ui.component.WXBaseScroller
    public void bindStickStyle(WXComponent wXComponent) {
        this.stickyHelper.bindStickStyle(wXComponent, this.mStickyMap);
    }

    @Override // com.taobao.weex.ui.component.Scrollable, com.taobao.weex.ui.component.WXBaseScroller
    public void unbindStickStyle(WXComponent wXComponent) {
        this.stickyHelper.unbindStickStyle(wXComponent, this.mStickyMap);
    }

    @Override // com.taobao.weex.ui.component.Scrollable, com.taobao.weex.ui.component.WXBaseScroller
    public void bindAppearEvent(WXComponent wXComponent) {
        setWatch(0, wXComponent, true);
    }

    private void setWatch(int i, WXComponent wXComponent, boolean z) {
        AppearanceHelper appearanceHelper = this.mAppearanceComponents.get(wXComponent.getRef());
        if (appearanceHelper == null) {
            appearanceHelper = new AppearanceHelper(wXComponent);
            this.mAppearanceComponents.put(wXComponent.getRef(), appearanceHelper);
        }
        appearanceHelper.setWatchEvent(i, z);
        procAppear(0, 0, 0, 0);
    }

    @Override // com.taobao.weex.ui.component.Scrollable, com.taobao.weex.ui.component.WXBaseScroller
    public void bindDisappearEvent(WXComponent wXComponent) {
        setWatch(1, wXComponent, true);
    }

    @Override // com.taobao.weex.ui.component.Scrollable, com.taobao.weex.ui.component.WXBaseScroller
    public void unbindAppearEvent(WXComponent wXComponent) {
        setWatch(0, wXComponent, false);
    }

    @Override // com.taobao.weex.ui.component.Scrollable, com.taobao.weex.ui.component.WXBaseScroller
    public void unbindDisappearEvent(WXComponent wXComponent) {
        setWatch(1, wXComponent, false);
    }

    @Override // com.taobao.weex.ui.component.Scrollable, com.taobao.weex.ui.component.WXBaseScroller
    public void scrollTo(WXComponent wXComponent, Map<String, Object> map) {
        int i;
        boolean z = true;
        float f = 0.0f;
        if (map != null) {
            String obj = map.get("offset") == null ? WXInstanceApm.VALUE_ERROR_CODE_DEFAULT : map.get("offset").toString();
            z = WXUtils.getBoolean(map.get(Constants.Name.ANIMATED), true).booleanValue();
            if (obj != null) {
                try {
                    f = WXViewUtils.getRealPxByWidth(Float.parseFloat(obj), getInstance().getInstanceViewPortWidth());
                } catch (Exception e) {
                    WXLogUtils.e("Float parseFloat error :" + e.getMessage());
                }
            }
        }
        if (this.pageEnable) {
            this.mActiveFeature = this.mChildren.indexOf(wXComponent);
        }
        int absoluteY = wXComponent.getAbsoluteY() - getAbsoluteY();
        if (isLayoutRTL()) {
            if (getInnerView().getChildCount() > 0) {
                i = (getInnerView().getChildAt(0).getWidth() - (wXComponent.getAbsoluteX() - getAbsoluteX())) - getInnerView().getMeasuredWidth();
            } else {
                i = wXComponent.getAbsoluteX() - getAbsoluteX();
            }
            f = -f;
        } else {
            i = wXComponent.getAbsoluteX() - getAbsoluteX();
        }
        int i2 = (int) f;
        scrollBy((i - getScrollX()) + i2, (absoluteY - getScrollY()) + i2, z);
    }

    public void scrollBy(int i, int i2) {
        scrollBy(i, i2, false);
    }

    public void scrollBy(final int i, final int i2, final boolean z) {
        if (getInnerView() != null) {
            getInnerView().postDelayed(new Runnable() {
                /* class com.taobao.weex.ui.component.DCWXScroller.AnonymousClass16 */

                public void run() {
                    if (DCWXScroller.this.mOrientation == 1) {
                        if (z) {
                            ((DCWXScrollView) DCWXScroller.this.getInnerView()).smoothScrollBy(0, i2);
                        } else {
                            ((DCWXScrollView) DCWXScroller.this.getInnerView()).scrollBy(0, i2);
                        }
                    } else if (z) {
                        ((DCWXHorizontalScrollView) DCWXScroller.this.getInnerView()).smoothScrollBy(i, 0);
                    } else {
                        ((DCWXHorizontalScrollView) DCWXScroller.this.getInnerView()).scrollBy(i, 0);
                    }
                    DCWXScroller.this.getInnerView().invalidate();
                }
            }, 16);
        }
    }

    @Override // io.dcloud.feature.weex_scroller.view.DCWXScrollView.WXScrollViewListener
    public void onScrollChanged(DCWXScrollView dCWXScrollView, int i, int i2, int i3, int i4) {
        procAppear(i, i2, i3, i4);
    }

    @Override // io.dcloud.feature.uniapp.ui.component.AbsVContainer, com.taobao.weex.ui.component.WXComponent
    public void notifyAppearStateChange(String str, String str2) {
        if (containsEvent(Constants.Event.APPEAR) || containsEvent(Constants.Event.DISAPPEAR)) {
            HashMap hashMap = new HashMap();
            hashMap.put("direction", str2);
            fireEvent(str, hashMap);
        }
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void procAppear(int i, int i2, int i3, int i4) {
        int appearStatus;
        if (this.mIsHostAttachedToWindow) {
            int i5 = i2 - i4;
            int i6 = i - i3;
            String str = i5 > 0 ? "up" : i5 < 0 ? "down" : null;
            if (this.mOrientation == 0 && i6 != 0) {
                str = i6 > 0 ? "right" : "left";
            }
            for (Map.Entry<String, AppearanceHelper> entry : this.mAppearanceComponents.entrySet()) {
                AppearanceHelper value = entry.getValue();
                if (value.isWatch() && (appearStatus = value.setAppearStatus(checkItemVisibleInScroller(value.getAwareChild()))) != 0) {
                    value.getAwareChild().notifyAppearStateChange(appearStatus == 1 ? Constants.Event.APPEAR : Constants.Event.DISAPPEAR, str);
                }
            }
        }
    }

    /* JADX WARNING: Code restructure failed: missing block: B:11:0x0034, code lost:
        if (r1 < getLayoutWidth()) goto L_0x0036;
     */
    /* JADX WARNING: Code restructure failed: missing block: B:17:0x0058, code lost:
        if (r1 < getLayoutHeight()) goto L_0x0036;
     */
    private boolean checkItemVisibleInScroller(WXComponent wXComponent) {
        boolean z = false;
        while (wXComponent != null && !(wXComponent instanceof DCWXScroller)) {
            if (wXComponent.getParent() instanceof DCWXScroller) {
                if (this.mOrientation == 0) {
                    float left = (float) (((int) wXComponent.getLayoutPosition().getLeft()) - getScrollX());
                    if (left > 0.0f - wXComponent.getLayoutWidth()) {
                    }
                    z = false;
                } else {
                    float top = (float) (((int) wXComponent.getLayoutPosition().getTop()) - getScrollY());
                    if (top > 0.0f - wXComponent.getLayoutHeight()) {
                    }
                    z = false;
                }
                z = true;
            }
            wXComponent = wXComponent.getParent();
        }
        return z;
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void dispatchDisappearEvent() {
        int appearStatus;
        for (Map.Entry<String, AppearanceHelper> entry : this.mAppearanceComponents.entrySet()) {
            AppearanceHelper value = entry.getValue();
            if (value.isWatch() && (appearStatus = value.setAppearStatus(false)) != 0) {
                value.getAwareChild().notifyAppearStateChange(appearStatus == 1 ? Constants.Event.APPEAR : Constants.Event.DISAPPEAR, "");
            }
        }
    }

    @Override // io.dcloud.feature.weex_scroller.view.DCWXScrollView.WXScrollViewListener
    public void onScroll(DCWXScrollView dCWXScrollView, int i, int i2) {
        onLoadMore(dCWXScrollView, i, i2);
    }

    /* access modifiers changed from: protected */
    public void onLoadMore(FrameLayout frameLayout, int i, int i2) {
        try {
            String loadMoreOffset = getAttrs().getLoadMoreOffset();
            if (!TextUtils.isEmpty(loadMoreOffset)) {
                int realPxByWidth = (int) WXViewUtils.getRealPxByWidth(Float.parseFloat(loadMoreOffset), getInstance().getInstanceViewPortWidth());
                if (frameLayout instanceof DCWXHorizontalScrollView) {
                    int width = frameLayout.getChildAt(0).getWidth();
                    if ((width - i) - frameLayout.getWidth() >= realPxByWidth) {
                        return;
                    }
                    if (this.mContentWidth != width || this.mForceLoadmoreNextTime) {
                        fireEvent(Constants.Event.LOADMORE);
                        this.mContentWidth = width;
                        this.mForceLoadmoreNextTime = false;
                        return;
                    }
                    return;
                }
                int height = frameLayout.getChildAt(0).getHeight();
                int height2 = (height - i2) - frameLayout.getHeight();
                if (height2 < realPxByWidth) {
                    if (WXEnvironment.isApkDebugable()) {
                        WXLogUtils.d("[WXScroller-onScroll] offScreenY :" + height2);
                    }
                    if (this.mContentHeight != height || this.mForceLoadmoreNextTime) {
                        fireEvent(Constants.Event.LOADMORE);
                        this.mContentHeight = height;
                        this.mForceLoadmoreNextTime = false;
                    }
                }
            }
        } catch (Exception e) {
            WXLogUtils.d("[DCWXScroller-onScroll] ", e);
        }
    }

    @JSMethod
    public void resetLoadmore() {
        this.mForceLoadmoreNextTime = true;
    }

    public ScrollStartEndHelper getScrollStartEndHelper() {
        if (this.mScrollStartEndHelper == null) {
            this.mScrollStartEndHelper = new ScrollStartEndHelper(this);
        }
        return this.mScrollStartEndHelper;
    }

    /* access modifiers changed from: package-private */
    public class MyGestureDetector extends GestureDetector.SimpleOnGestureListener {
        private final DCWXHorizontalScrollView scrollView;

        public DCWXHorizontalScrollView getScrollView() {
            return this.scrollView;
        }

        MyGestureDetector(DCWXHorizontalScrollView dCWXHorizontalScrollView) {
            this.scrollView = dCWXHorizontalScrollView;
        }

        public boolean onFling(MotionEvent motionEvent, MotionEvent motionEvent2, float f, float f2) {
            int size = DCWXScroller.this.mChildren.size();
            try {
                if (motionEvent.getX() - motionEvent2.getX() <= 5.0f || Math.abs(f) <= 300.0f) {
                    if (motionEvent2.getX() - motionEvent.getX() > 5.0f && Math.abs(f) > 300.0f) {
                        int i = DCWXScroller.this.pageSize;
                        DCWXScroller dCWXScroller = DCWXScroller.this;
                        dCWXScroller.mActiveFeature = dCWXScroller.mActiveFeature > 0 ? DCWXScroller.this.mActiveFeature - 1 : 0;
                        this.scrollView.smoothScrollTo(DCWXScroller.this.mActiveFeature * i, 0);
                        return true;
                    }
                    return false;
                }
                int i2 = DCWXScroller.this.pageSize;
                DCWXScroller dCWXScroller2 = DCWXScroller.this;
                int i3 = size - 1;
                if (dCWXScroller2.mActiveFeature < i3) {
                    i3 = DCWXScroller.this.mActiveFeature + 1;
                }
                dCWXScroller2.mActiveFeature = i3;
                this.scrollView.smoothScrollTo(DCWXScroller.this.mActiveFeature * i2, 0);
                return true;
            } catch (Exception e) {
                WXLogUtils.e("There was an error processing the Fling event:" + e.getMessage());
            }
        }
    }
}
