package com.taobao.weex.ui.component;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.text.Editable;
import android.text.InputFilter;
import android.text.SpannableString;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.method.PasswordTransformationMethod;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.BackgroundColorSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.StyleSpan;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.TextView;
import androidx.core.view.GravityCompat;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.alibaba.fastjson.JSONObject;
import com.facebook.common.callercontext.ContextChain;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.annotation.JSMethod;
import com.taobao.weex.bridge.JSCallback;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.common.Constants;
import com.taobao.weex.common.WXThread;
import com.taobao.weex.dom.CSSConstants;
import com.taobao.weex.dom.WXAttr;
import com.taobao.weex.dom.WXStyle;
import com.taobao.weex.layout.ContentBoxMeasurement;
import com.taobao.weex.performance.WXInstanceApm;
import com.taobao.weex.ui.action.BasicComponentData;
import com.taobao.weex.ui.action.GraphicSize;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.view.WXEditText;
import com.taobao.weex.utils.FontDO;
import com.taobao.weex.utils.TypefaceUtil;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXResourceUtils;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;
import io.dcloud.common.core.ui.DCKeyboardManager;
import io.dcloud.common.core.ui.keyboard.DCEditText;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.feature.uniapp.annotation.UniJSMethod;
import io.dcloud.feature.uniapp.common.UniConstants;
import io.dcloud.feature.uniapp.utils.UniUtils;
import io.dcloud.feature.uniapp.utils.UniViewUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class DCWXInput extends WXComponent<WXEditText> {
    private static final int MAX_TEXT_FORMAT_REPEAT = 3;
    final String ADJUST_POSITION = "adjustPosition";
    final String PASSWORD = Constants.Value.PASSWORD;
    private int cursor = -1;
    boolean isConfirmHold = false;
    private AtomicBoolean isLayoutFinished = new AtomicBoolean(false);
    public boolean isNeedConfirm = true;
    private boolean isPassword = false;
    float keyboardHeight = 0.0f;
    private String mBeforeText = "";
    private int mEditorAction = 6;
    private List<TextView.OnEditorActionListener> mEditorActionListeners;
    private String mFontFamily;
    private int mFormatRepeatCount = 0;
    private TextFormatter mFormatter = null;
    private WXSDKInstance.FrameViewEventListener mFrameViewEventListener;
    private boolean mIgnoreNextOnInputEvent = false;
    private final InputMethodManager mInputMethodManager;
    private int mLineHeight = -1;
    private boolean mListeningConfirm = false;
    private WXComponent.OnFocusChangeListener mOnFocusChangeListener = new WXComponent.OnFocusChangeListener() {
        /* class com.taobao.weex.ui.component.DCWXInput.AnonymousClass6 */
        int count = 0;

        @Override // com.taobao.weex.ui.component.WXComponent.OnFocusChangeListener
        public void onFocusChange(boolean z) {
            TextView textView = (TextView) DCWXInput.this.getHostView();
            if (textView != null) {
                HashMap hashMap = new HashMap(1);
                HashMap hashMap2 = new HashMap(1);
                hashMap2.put("value", textView.getText().toString());
                if (!z) {
                    hashMap.put("detail", hashMap2);
                    DCWXInput.this.fireEvent(Constants.Event.BLUR, hashMap);
                } else if (DCWXInput.this.keyboardHeight == 0.0f) {
                    fireEventForFocus(textView);
                } else {
                    hashMap2.put("height", Float.valueOf(DCWXInput.this.keyboardHeight));
                    hashMap2.put("value", textView.getText().toString());
                    hashMap.put("detail", hashMap2);
                    DCWXInput.this.fireEvent(Constants.Event.FOCUS, hashMap);
                }
            }
        }

        /* access modifiers changed from: private */
        /* access modifiers changed from: public */
        private void fireEventForFocus(final TextView textView) {
            ((WXEditText) DCWXInput.this.getHostView()).postDelayed(new Runnable() {
                /* class com.taobao.weex.ui.component.DCWXInput.AnonymousClass6.AnonymousClass1 */

                public void run() {
                    if (DCWXInput.this.keyboardHeight == 0.0f) {
                        AnonymousClass6.this.count++;
                        if (AnonymousClass6.this.count > 3) {
                            HashMap hashMap = new HashMap(1);
                            HashMap hashMap2 = new HashMap(1);
                            hashMap2.put("value", textView.getText().toString());
                            hashMap2.put("height", Float.valueOf(DCWXInput.this.keyboardHeight));
                            hashMap.put("detail", hashMap2);
                            DCWXInput.this.fireEvent(Constants.Event.FOCUS, hashMap);
                            return;
                        }
                        AnonymousClass6.this.fireEventForFocus(textView);
                        return;
                    }
                    AnonymousClass6.this.count = 0;
                    HashMap hashMap3 = new HashMap(1);
                    HashMap hashMap4 = new HashMap(1);
                    hashMap4.put("value", textView.getText().toString());
                    hashMap4.put("height", Float.valueOf(DCWXInput.this.keyboardHeight));
                    hashMap3.put("detail", hashMap4);
                    DCWXInput.this.fireEvent(Constants.Event.FOCUS, hashMap3);
                }
            }, 200);
        }
    };
    private TextPaint mPaint = new TextPaint();
    private String mReturnKeyType = null;
    private TextWatcher mTextChangedEventDispatcher;
    private List<TextWatcher> mTextChangedListeners;
    protected String mType = "text";
    private BroadcastReceiver mTypefaceObserver;
    private float measureHeight = -1.0f;
    private float measureWidht = -1.0f;
    private JSONObject placeholderStyle = new JSONObject();
    private String placeholderTextAlign;
    private int selectionEnd = Integer.MAX_VALUE;
    private int selectionStart = Integer.MAX_VALUE;
    private String textAlign = "left";

    private interface ReturnTypes {
        public static final String DEFAULT = "default";
        public static final String DONE = "done";
        public static final String GO = "go";
        public static final String NEXT = "next";
        public static final String SEARCH = "search";
        public static final String SEND = "send";
    }

    /* access modifiers changed from: protected */
    public int getVerticalGravity() {
        return 16;
    }

    public DCWXInput(WXSDKInstance wXSDKInstance, WXVContainer wXVContainer, boolean z, BasicComponentData basicComponentData) {
        super(wXSDKInstance, wXVContainer, z, basicComponentData);
        interceptFocusAndBlurEvent();
        this.mInputMethodManager = (InputMethodManager) getContext().getSystemService("input_method");
        setContentBoxMeasurement(new ContentBoxMeasurement() {
            /* class com.taobao.weex.ui.component.DCWXInput.AnonymousClass1 */

            @Override // com.taobao.weex.layout.ContentBoxMeasurement
            public void layoutAfter(float f, float f2) {
            }

            @Override // com.taobao.weex.layout.ContentBoxMeasurement
            public void measureInternal(float f, float f2, int i, int i2) {
                if (DCWXInput.this.getBasicComponentData().getStyles() == null || DCWXInput.this.getBasicComponentData().getStyles().size() == 0) {
                    DCWXInput.this.measureWidht = f;
                }
                if (CSSConstants.isUndefined(f2)) {
                    this.mMeasureHeight = WXViewUtils.getRealPxByWidth(((float) DCWXInput.this.getInstance().getDefaultFontSize()) * 1.4f, DCWXInput.this.getInstance().getInstanceViewPortWidthWithFloat());
                    DCWXInput.this.measureHeight = this.mMeasureHeight;
                }
            }

            @Override // com.taobao.weex.layout.ContentBoxMeasurement
            public void layoutBefore() {
                DCWXInput.this.updateStyleAndAttrs();
            }
        });
    }

    /* access modifiers changed from: protected */
    public void setHostLayoutParams(WXEditText wXEditText, int i, int i2, int i3, int i4, int i5, int i6) {
        super.setHostLayoutParams((View) wXEditText, i, i2, i3, i4, i5, i6);
    }

    /* access modifiers changed from: protected */
    @Override // io.dcloud.feature.uniapp.ui.component.AbsBasicComponent
    public void setLayoutSize(GraphicSize graphicSize) {
        super.setLayoutSize(graphicSize);
    }

    /* access modifiers changed from: protected */
    @Override // com.taobao.weex.ui.component.WXComponent
    public void layoutDirectionDidChanged(boolean z) {
        int textAlign2 = getTextAlign((String) getStyles().get(Constants.Name.TEXT_ALIGN));
        if (textAlign2 <= 0) {
            textAlign2 = GravityCompat.START;
        }
        if (getHostView() != null) {
            ((WXEditText) getHostView()).setGravity(textAlign2 | getVerticalGravity());
        }
    }

    /* access modifiers changed from: package-private */
    public final float getMeasuredLineHeight() {
        int i = this.mLineHeight;
        return (i == -1 || i <= 0) ? this.mPaint.getFontMetrics(null) : (float) i;
    }

    /* access modifiers changed from: protected */
    public float getMeasureHeight() {
        float f = 50.0f;
        if (getMeasuredLineHeight() >= 50.0f) {
            f = getMeasureHeight();
        }
        return WXViewUtils.getRealPxByWidth(f, getInstance().getInstanceViewPortWidthWithFloat());
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void updateStyleAndAttrs() {
        if (getStyles().size() > 0) {
            String str = null;
            int fontSize = getStyles().containsKey(Constants.Name.FONT_SIZE) ? WXStyle.getFontSize(getStyles(), getInstance().getDefaultFontSize(), (float) getViewPortWidth()) : -1;
            if (getStyles().containsKey(Constants.Name.FONT_FAMILY)) {
                str = WXStyle.getFontFamily(getStyles());
            }
            int fontStyle = getStyles().containsKey(Constants.Name.FONT_STYLE) ? WXStyle.getFontStyle(getStyles()) : -1;
            int fontWeight = getStyles().containsKey(Constants.Name.FONT_WEIGHT) ? WXStyle.getFontWeight(getStyles()) : -1;
            int lineHeight = WXStyle.getLineHeight(getStyles(), (float) getViewPortWidth());
            if (lineHeight != -1) {
                this.mLineHeight = lineHeight;
            }
            if (fontSize != -1) {
                this.mPaint.setTextSize((float) fontSize);
            }
            if (str != null) {
                TypefaceUtil.applyFontStyle(this.mPaint, fontStyle, fontWeight, str);
            }
        }
    }

    /* access modifiers changed from: protected */
    @Override // com.taobao.weex.ui.component.WXComponent
    public WXEditText initComponentHostView(Context context) {
        WXEditText wXEditText = new WXEditText(context, getInstanceId());
        appleStyleAfterCreated(wXEditText);
        wXEditText.setImeOptions(6);
        return wXEditText;
    }

    /* access modifiers changed from: protected */
    public void onHostViewInitialized(WXEditText wXEditText) {
        super.onHostViewInitialized((View) wXEditText);
        if (this.measureWidht > 0.0f) {
            WXBridgeManager.getInstance().setStyleWidth(getInstanceId(), getRef(), this.measureWidht);
        }
        if (this.measureHeight > 0.0f) {
            WXBridgeManager.getInstance().setStyleHeight(getInstanceId(), getRef(), this.measureHeight);
        }
        addFocusChangeListener(new WXComponent.OnFocusChangeListener() {
            /* class com.taobao.weex.ui.component.DCWXInput.AnonymousClass2 */

            @Override // com.taobao.weex.ui.component.WXComponent.OnFocusChangeListener
            public void onFocusChange(boolean z) {
                if (!z) {
                    DCWXInput.this.decideSoftKeyboard();
                }
                DCWXInput.this.setPseudoClassStatus(Constants.PSEUDO.FOCUS, z);
                if (z) {
                    DCWXInput dCWXInput = DCWXInput.this;
                    dCWXInput.setTextAlign(dCWXInput.textAlign);
                } else if (DCWXInput.this.getHostView() != null && PdrUtil.isEmpty(((WXEditText) DCWXInput.this.getHostView()).getText().toString())) {
                    DCWXInput dCWXInput2 = DCWXInput.this;
                    int textAlign = dCWXInput2.getTextAlign(dCWXInput2.placeholderTextAlign == null ? DCWXInput.this.textAlign : DCWXInput.this.placeholderTextAlign);
                    if (textAlign > 0) {
                        ((WXEditText) DCWXInput.this.getHostView()).setGravity(textAlign | DCWXInput.this.getVerticalGravity());
                    }
                }
            }
        });
        addKeyboardListener(wXEditText);
        if (this.isNeedConfirm) {
            addEditorChangeListener();
        }
    }

    private void addEditorChangeListener() {
        addEditorActionListener(new TextView.OnEditorActionListener() {
            /* class com.taobao.weex.ui.component.DCWXInput.AnonymousClass3 */

            public boolean onEditorAction(TextView textView, int i, KeyEvent keyEvent) {
                if (!DCWXInput.this.mListeningConfirm || i != DCWXInput.this.mEditorAction) {
                    return DCWXInput.this.isConfirmHold;
                }
                HashMap hashMap = new HashMap(1);
                HashMap hashMap2 = new HashMap(1);
                hashMap2.put("value", textView.getText().toString());
                hashMap.put("detail", hashMap2);
                DCWXInput.this.fireEvent("confirm", hashMap);
                if (!DCWXInput.this.isConfirmHold) {
                    DCWXInput.this.blur();
                }
                return true;
            }
        });
    }

    /* access modifiers changed from: protected */
    @Override // com.taobao.weex.ui.component.WXComponent
    public boolean isConsumeTouch() {
        return !isDisabled();
    }

    /* access modifiers changed from: protected */
    public void appleStyleAfterCreated(final WXEditText wXEditText) {
        int textAlign2 = getTextAlign((String) getStyles().get(Constants.Name.TEXT_ALIGN));
        if (textAlign2 <= 0) {
            textAlign2 = GravityCompat.START;
        }
        wXEditText.setGravity(textAlign2 | getVerticalGravity());
        int color = WXResourceUtils.getColor("#999999");
        if (color != Integer.MIN_VALUE) {
            wXEditText.setHintTextColor(color);
        }
        AnonymousClass4 r0 = new TextWatcher() {
            /* class com.taobao.weex.ui.component.DCWXInput.AnonymousClass4 */

            public void beforeTextChanged(CharSequence charSequence, int i, int i2, int i3) {
                if (DCWXInput.this.mTextChangedListeners != null) {
                    for (TextWatcher textWatcher : DCWXInput.this.mTextChangedListeners) {
                        textWatcher.beforeTextChanged(charSequence, i, i2, i3);
                    }
                }
            }

            public void onTextChanged(CharSequence charSequence, int i, int i2, int i3) {
                if (DCWXInput.this.mFormatter != null) {
                    String format = DCWXInput.this.mFormatter.format(DCWXInput.this.mFormatter.recover(charSequence.toString()));
                    if (format.equals(charSequence.toString()) || DCWXInput.this.mFormatRepeatCount >= 3) {
                        DCWXInput.this.mFormatRepeatCount = 0;
                    } else {
                        DCWXInput.this.mFormatRepeatCount++;
                        int length = DCWXInput.this.mFormatter.format(DCWXInput.this.mFormatter.recover(charSequence.subSequence(0, wXEditText.getSelectionStart()).toString())).length();
                        wXEditText.setText(format);
                        wXEditText.setSelection(length);
                        return;
                    }
                }
                if (DCWXInput.this.mTextChangedListeners != null) {
                    for (TextWatcher textWatcher : DCWXInput.this.mTextChangedListeners) {
                        textWatcher.onTextChanged(charSequence, i, i2, i3);
                    }
                }
            }

            public void afterTextChanged(Editable editable) {
                if (DCWXInput.this.mTextChangedListeners != null) {
                    for (TextWatcher textWatcher : DCWXInput.this.mTextChangedListeners) {
                        textWatcher.afterTextChanged(editable);
                    }
                }
            }
        };
        this.mTextChangedEventDispatcher = r0;
        wXEditText.addTextChangedListener(r0);
        wXEditText.setTextSize(0, (float) WXStyle.getFontSize(getStyles(), getInstance().getDefaultFontSize(), getInstance().getInstanceViewPortWidthWithFloat()));
        wXEditText.setSingleLine(true);
    }

    @Override // com.taobao.weex.ui.component.WXComponent
    public void addEvent(String str) {
        if (getHostView() != null && !TextUtils.isEmpty(str)) {
            if (str.equals("input")) {
                addTextChangedListener(new TextWatcher() {
                    /* class com.taobao.weex.ui.component.DCWXInput.AnonymousClass5 */

                    public void afterTextChanged(Editable editable) {
                    }

                    public void beforeTextChanged(CharSequence charSequence, int i, int i2, int i3) {
                    }

                    public void onTextChanged(CharSequence charSequence, int i, int i2, int i3) {
                        if (DCWXInput.this.mIgnoreNextOnInputEvent) {
                            DCWXInput.this.mIgnoreNextOnInputEvent = false;
                            DCWXInput.this.mBeforeText = charSequence.toString();
                            return;
                        }
                        HashMap hashMap = new HashMap(1);
                        HashMap hashMap2 = new HashMap(3);
                        hashMap2.put("value", charSequence.toString());
                        hashMap2.put("cursor", Integer.valueOf(((WXEditText) DCWXInput.this.getHostView()).getSelectionEnd()));
                        if (i2 == 0 && i3 != 0) {
                            try {
                                String charSequence2 = charSequence.subSequence(i, i3 + i).toString();
                                hashMap2.put("keyCode", Integer.valueOf(Character.codePointAt(charSequence2, charSequence2.length() - 1)));
                            } catch (Exception unused) {
                                hashMap2.put("keyCode", WXInstanceApm.VALUE_ERROR_CODE_DEFAULT);
                            }
                        } else if (i2 != 0 && i3 == 0) {
                            String charSequence3 = DCWXInput.this.mBeforeText.subSequence(i, i2 + i).toString();
                            hashMap2.put("keyCode", Integer.valueOf(Character.codePointAt(charSequence3, charSequence3.length() - 1)));
                        }
                        DCWXInput.this.mBeforeText = charSequence.toString();
                        hashMap.put("detail", hashMap2);
                        DCWXInput.this.fireEvent("input", hashMap);
                    }
                });
            }
            if ("confirm".equals(str)) {
                this.mListeningConfirm = true;
            }
            if (Constants.Event.FOCUS.equals(str) || Constants.Event.BLUR.equals(str)) {
                setFocusAndBlur();
            }
            super.addEvent(str);
        }
    }

    /* access modifiers changed from: protected */
    public void setFocusAndBlur() {
        if (!ismHasFocusChangeListener(this.mOnFocusChangeListener)) {
            addFocusChangeListener(this.mOnFocusChangeListener);
        }
    }

    /* JADX INFO: Can't fix incorrect switch cases order, some code will duplicate */
    /* access modifiers changed from: protected */
    /* JADX WARNING: Code restructure failed: missing block: B:67:0x0128, code lost:
        if (r6.equals(com.taobao.weex.common.Constants.Name.SELECTION_START) == false) goto L_0x0011;
     */
    @Override // com.taobao.weex.ui.component.WXComponent
    public boolean setProperty(String str, Object obj) {
        str.hashCode();
        char c = 0;
        switch (str.hashCode()) {
            case -2137753034:
                break;
            case -1898657397:
                if (str.equals(Constants.Name.KEEP_SELECTION_INDEX)) {
                    c = 1;
                    break;
                }
                c = 65535;
                break;
            case -1629051985:
                if (str.equals(Constants.Name.SELECTION_END)) {
                    c = 2;
                    break;
                }
                c = 65535;
                break;
            case -1576785488:
                if (str.equals(Constants.Name.PLACEHOLDER_COLOR)) {
                    c = 3;
                    break;
                }
                c = 65535;
                break;
            case -1349119146:
                if (str.equals("cursor")) {
                    c = 4;
                    break;
                }
                c = 65535;
                break;
            case -1224696685:
                if (str.equals(Constants.Name.FONT_FAMILY)) {
                    c = 5;
                    break;
                }
                c = 65535;
                break;
            case -1065511464:
                if (str.equals(Constants.Name.TEXT_ALIGN)) {
                    c = 6;
                    break;
                }
                c = 65535;
                break;
            case -791400086:
                if (str.equals(Constants.Name.MAX_LENGTH)) {
                    c = 7;
                    break;
                }
                c = 65535;
                break;
            case 107876:
                if (str.equals("max")) {
                    c = '\b';
                    break;
                }
                c = 65535;
                break;
            case 108114:
                if (str.equals(Constants.Name.MIN)) {
                    c = '\t';
                    break;
                }
                c = 65535;
                break;
            case 94842723:
                if (str.equals("color")) {
                    c = '\n';
                    break;
                }
                c = 65535;
                break;
            case 97604824:
                if (str.equals(Constants.Event.FOCUS)) {
                    c = 11;
                    break;
                }
                c = 65535;
                break;
            case 102977279:
                if (str.equals(Constants.Name.LINES)) {
                    c = '\f';
                    break;
                }
                c = 65535;
                break;
            case 124732746:
                if (str.equals(Constants.Name.MAXLENGTH)) {
                    c = '\r';
                    break;
                }
                c = 65535;
                break;
            case 270940796:
                if (str.equals(Constants.Name.DISABLED)) {
                    c = 14;
                    break;
                }
                c = 65535;
                break;
            case 344059807:
                if (str.equals("confirmHold")) {
                    c = 15;
                    break;
                }
                c = 65535;
                break;
            case 365601008:
                if (str.equals(Constants.Name.FONT_SIZE)) {
                    c = 16;
                    break;
                }
                c = 65535;
                break;
            case 598246771:
                if (str.equals(Constants.Name.PLACEHOLDER)) {
                    c = 17;
                    break;
                }
                c = 65535;
                break;
            case 914346044:
                if (str.equals(Constants.Name.SINGLELINE)) {
                    c = 18;
                    break;
                }
                c = 65535;
                break;
            case 947486441:
                if (str.equals(Constants.Name.RETURN_KEY_TYPE)) {
                    c = 19;
                    break;
                }
                c = 65535;
                break;
            case 1625554645:
                if (str.equals(Constants.Name.ALLOW_COPY_PASTE)) {
                    c = 20;
                    break;
                }
                c = 65535;
                break;
            case 1638055017:
                if (str.equals("autoFocus")) {
                    c = 21;
                    break;
                }
                c = 65535;
                break;
            default:
                c = 65535;
                break;
        }
        switch (c) {
            case 0:
                int intValue = WXUtils.getInteger(obj, Integer.MAX_VALUE).intValue();
                this.selectionStart = intValue;
                setSelectionRange(intValue, this.selectionEnd);
                return super.setProperty(str, obj);
            case 1:
                return true;
            case 2:
                int intValue2 = WXUtils.getInteger(obj, Integer.MAX_VALUE).intValue();
                this.selectionEnd = intValue2;
                setSelectionRange(this.selectionStart, intValue2);
                return super.setProperty(str, obj);
            case 3:
                String string = WXUtils.getString(obj, null);
                if (string != null) {
                    setPlaceholderColor(string);
                }
                return true;
            case 4:
                int i = WXUtils.getInt(obj);
                if (i > 0 && i <= ((WXEditText) getHostView()).getText().length()) {
                    ((WXEditText) getHostView()).setSelection(i);
                } else if (i > ((WXEditText) getHostView()).getText().length()) {
                    ((WXEditText) getHostView()).setSelection(((WXEditText) getHostView()).getText().length());
                }
                return true;
            case 5:
                if (obj != null) {
                    try {
                        FontDO fontDO = TypefaceUtil.getFontDO(obj.toString());
                        if (fontDO == null || fontDO.getTypeface() == null || getHostView() == null) {
                            registerTypefaceObserver(obj.toString());
                        } else {
                            ((WXEditText) getHostView()).setTypeface(fontDO.getTypeface());
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return true;
            case 6:
                String string2 = WXUtils.getString(obj, null);
                if (string2 != null) {
                    setTextAlign(string2);
                }
                return true;
            case 7:
                Integer integer = WXUtils.getInteger(obj, null);
                if (integer != null) {
                    setMaxLength(integer.intValue());
                }
                return true;
            case '\b':
            case '\t':
                return true;
            case '\n':
                String string3 = WXUtils.getString(obj, null);
                if (string3 != null) {
                    setColor(string3);
                }
                return true;
            case 11:
            case 21:
                setAutofocus(WXUtils.getBoolean(obj, false).booleanValue());
                return true;
            case '\f':
                Integer integer2 = WXUtils.getInteger(obj, null);
                if (integer2 != null) {
                    setLines(integer2.intValue());
                }
                return true;
            case '\r':
                Integer integer3 = WXUtils.getInteger(obj, null);
                if (integer3 != null) {
                    setMaxLength(integer3.intValue());
                }
                return true;
            case 14:
                Boolean bool = WXUtils.getBoolean(obj, false);
                ((WXEditText) getHostView()).setFocusable(!bool.booleanValue());
                ((WXEditText) getHostView()).setFocusableInTouchMode(!bool.booleanValue());
                ((WXEditText) getHostView()).setCursorVisible(!bool.booleanValue());
                return true;
            case 15:
                this.isConfirmHold = WXUtils.getBoolean(obj, false).booleanValue();
                return super.setProperty(str, obj);
            case 16:
                String string4 = WXUtils.getString(obj, null);
                if (string4 != null) {
                    setFontSize(string4);
                }
                return true;
            case 17:
                return true;
            case 18:
                Boolean bool2 = WXUtils.getBoolean(obj, null);
                if (bool2 != null) {
                    setSingleLine(bool2.booleanValue());
                }
                return true;
            case 19:
                setReturnKeyType(String.valueOf(obj));
                return true;
            case 20:
                boolean booleanValue = WXUtils.getBoolean(obj, true).booleanValue();
                if (getHostView() != null) {
                    ((WXEditText) getHostView()).setAllowCopyPaste(booleanValue);
                }
                return true;
            default:
                return super.setProperty(str, obj);
        }
    }

    private void registerTypefaceObserver(String str) {
        if (WXEnvironment.getApplication() == null) {
            WXLogUtils.w("WXText", "ApplicationContent is null on register typeface observer");
            return;
        }
        this.mFontFamily = str;
        if (this.mTypefaceObserver == null) {
            this.mTypefaceObserver = new BroadcastReceiver() {
                /* class com.taobao.weex.ui.component.DCWXInput.AnonymousClass7 */

                public void onReceive(Context context, Intent intent) {
                    FontDO fontDO;
                    String stringExtra = intent.getStringExtra(Constants.Name.FONT_FAMILY);
                    if (DCWXInput.this.mFontFamily.equals(stringExtra) && (fontDO = TypefaceUtil.getFontDO(stringExtra)) != null && fontDO.getTypeface() != null && DCWXInput.this.getHostView() != null) {
                        ((WXEditText) DCWXInput.this.getHostView()).setTypeface(fontDO.getTypeface());
                    }
                }
            };
            LocalBroadcastManager.getInstance(WXEnvironment.getApplication()).registerReceiver(this.mTypefaceObserver, new IntentFilter(TypefaceUtil.ACTION_TYPE_FACE_AVAILABLE));
        }
    }

    @WXComponentProp(name = Constants.Name.RETURN_KEY_TYPE)
    public void setReturnKeyType(String str) {
        if (getHostView() != null && !str.equals(this.mReturnKeyType)) {
            this.mReturnKeyType = str;
            str.hashCode();
            char c = 65535;
            switch (str.hashCode()) {
                case -906336856:
                    if (str.equals("search")) {
                        c = 0;
                        break;
                    }
                    break;
                case 3304:
                    if (str.equals("go")) {
                        c = 1;
                        break;
                    }
                    break;
                case 3089282:
                    if (str.equals("done")) {
                        c = 2;
                        break;
                    }
                    break;
                case 3377907:
                    if (str.equals("next")) {
                        c = 3;
                        break;
                    }
                    break;
                case 3526536:
                    if (str.equals("send")) {
                        c = 4;
                        break;
                    }
                    break;
                case 1544803905:
                    if (str.equals("default")) {
                        c = 5;
                        break;
                    }
                    break;
            }
            switch (c) {
                case 0:
                    this.mEditorAction = 3;
                    break;
                case 1:
                    this.mEditorAction = 2;
                    break;
                case 2:
                    this.mEditorAction = 6;
                    break;
                case 3:
                    this.mEditorAction = 5;
                    break;
                case 4:
                    this.mEditorAction = 4;
                    break;
                case 5:
                    this.mEditorAction = 0;
                    break;
            }
            blur();
            ((WXEditText) getHostView()).setImeOptions(this.mEditorAction);
        }
    }

    public void setPlaceholder(String str) {
        if (str != null && getHostView() != null) {
            ((WXEditText) getHostView()).setHint(str);
            setPlaceholderStyle(this.placeholderStyle);
        }
    }

    @WXComponentProp(name = Constants.Name.PLACEHOLDER_COLOR)
    public void setPlaceholderColor(String str) {
        int color;
        if (getHostView() != null && !TextUtils.isEmpty(str) && (color = WXResourceUtils.getColor(str)) != Integer.MIN_VALUE) {
            ((WXEditText) getHostView()).setHintTextColor(color);
        }
    }

    public void setType(String str) {
        Log.e("weex", "setType=" + str);
        if (str != null && getHostView() != null && !this.mType.equals(str)) {
            this.mType = str;
            ((EditText) getHostView()).setInputType(getInputType(this.mType));
        }
    }

    @WXComponentProp(name = Constants.Name.AUTOFOCUS)
    public void setAutofocus(final boolean z) {
        if (getHostView() != null) {
            final EditText editText = (EditText) getHostView();
            if (this.isLayoutFinished.get()) {
                if (z) {
                    hostViewFocus(editText);
                } else {
                    hideSoftKeyboard();
                }
                editText.clearFocus();
            } else if (getInstance().isFrameViewShow()) {
                ((WXEditText) getHostView()).getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener() {
                    /* class com.taobao.weex.ui.component.DCWXInput.AnonymousClass8 */

                    public void onGlobalLayout() {
                        if (DCWXInput.this.getInstance() != null) {
                            if (z) {
                                DCWXInput.this.isLayoutFinished.set(true);
                                DCWXInput.this.hostViewFocus(editText);
                                DCWXInput dCWXInput = DCWXInput.this;
                                dCWXInput.setSelectionRange(dCWXInput.selectionStart, DCWXInput.this.selectionEnd);
                            } else {
                                editText.clearFocus();
                            }
                            ((WXEditText) DCWXInput.this.getHostView()).getViewTreeObserver().removeOnGlobalLayoutListener(this);
                        }
                    }
                });
            } else {
                if (this.mFrameViewEventListener != null) {
                    getInstance().removeFrameViewEventListener(this.mFrameViewEventListener);
                }
                this.mFrameViewEventListener = new WXSDKInstance.FrameViewEventListener() {
                    /* class com.taobao.weex.ui.component.DCWXInput.AnonymousClass9 */

                    @Override // com.taobao.weex.WXSDKInstance.FrameViewEventListener
                    public void onShowAnimationEnd() {
                        if (DCWXInput.this.getInstance() != null) {
                            if (z) {
                                DCWXInput.this.isLayoutFinished.set(true);
                                DCWXInput.this.hostViewFocus(editText);
                                DCWXInput dCWXInput = DCWXInput.this;
                                dCWXInput.setSelectionRange(dCWXInput.selectionStart, DCWXInput.this.selectionEnd);
                            } else {
                                editText.clearFocus();
                            }
                            DCWXInput.this.getInstance().removeFrameViewEventListener(this);
                            DCWXInput.this.mFrameViewEventListener = null;
                        }
                    }
                };
                getInstance().addFrameViewEventListener(this.mFrameViewEventListener);
            }
        }
    }

    @WXComponentProp(name = "adjustPosition")
    public void setAdjustPosition(Object obj) {
        if (getHostView() != null) {
            ((WXEditText) getHostView()).setInputSoftMode(WXUtils.getBoolean(obj, true).booleanValue() ? DCKeyboardManager.SOFT_INPUT_MODE_ADJUST_PAN : DCKeyboardManager.SOFT_INPUT_MODE_ADJUST_NOTHING);
        }
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void hostViewFocus(EditText editText) {
        editText.setFocusable(true);
        editText.setFocusableInTouchMode(true);
        editText.setCursorVisible(true);
        editText.requestFocus();
        showSoftKeyboard();
    }

    @WXComponentProp(name = "value")
    public void setText(String str) {
        WXEditText wXEditText = (WXEditText) getHostView();
        if (wXEditText != null && !TextUtils.equals(wXEditText.getText(), str)) {
            this.mIgnoreNextOnInputEvent = true;
            wXEditText.setText(str);
            int i = this.cursor;
            if (i <= 0) {
                i = str.length();
            }
            if (str == null) {
                i = 0;
            }
            wXEditText.setSelection(i);
        }
    }

    @WXComponentProp(name = "color")
    public void setColor(String str) {
        int color;
        if (getHostView() != null && !TextUtils.isEmpty(str) && (color = WXResourceUtils.getColor(str)) != Integer.MIN_VALUE) {
            ((WXEditText) getHostView()).setTextColor(color);
        }
    }

    @WXComponentProp(name = Constants.Name.FONT_SIZE)
    public void setFontSize(String str) {
        if (getHostView() != null && str != null) {
            HashMap hashMap = new HashMap(1);
            hashMap.put(Constants.Name.FONT_SIZE, str);
            ((WXEditText) getHostView()).setTextSize(0, (float) WXStyle.getFontSize(hashMap, getInstance().getDefaultFontSize(), getInstance().getInstanceViewPortWidthWithFloat()));
        }
    }

    /* JADX INFO: Can't fix incorrect switch cases order, some code will duplicate */
    @WXComponentProp(name = "placeholderStyle")
    public void setPlaceholderStyle(JSONObject jSONObject) {
        char c;
        JSONObject jSONObject2 = this.placeholderStyle;
        if (!(jSONObject2 == null || jSONObject2.isEmpty())) {
            CharSequence hint = ((WXEditText) getHostView()).getHint();
            if (hint == null && getAttrs().containsKey(Constants.Name.PLACEHOLDER)) {
                hint = WXUtils.getString(getAttrs().get(Constants.Name.PLACEHOLDER), "");
            }
            SpannableString spannableString = new SpannableString(hint);
            AbsoluteSizeSpan absoluteSizeSpan = new AbsoluteSizeSpan((int) ((WXEditText) getHostView()).getTextSize());
            ForegroundColorSpan foregroundColorSpan = new ForegroundColorSpan(((WXEditText) getHostView()).getCurrentHintTextColor());
            BackgroundColorSpan backgroundColorSpan = null;
            StyleSpan styleSpan = null;
            for (Map.Entry<String, Object> entry : this.placeholderStyle.entrySet()) {
                String key = entry.getKey();
                key.hashCode();
                char c2 = 65535;
                switch (key.hashCode()) {
                    case -1586082113:
                        if (key.equals("font-size")) {
                            c = 0;
                            break;
                        }
                        c = 65535;
                        break;
                    case -1065511464:
                        if (key.equals(Constants.Name.TEXT_ALIGN)) {
                            c = 1;
                            break;
                        }
                        c = 65535;
                        break;
                    case -734428249:
                        if (key.equals(Constants.Name.FONT_WEIGHT)) {
                            c = 2;
                            break;
                        }
                        c = 65535;
                        break;
                    case 94842723:
                        if (key.equals("color")) {
                            c = 3;
                            break;
                        }
                        c = 65535;
                        break;
                    case 365601008:
                        if (key.equals(Constants.Name.FONT_SIZE)) {
                            c = 4;
                            break;
                        }
                        c = 65535;
                        break;
                    case 598800822:
                        if (key.equals("font-weight")) {
                            c = 5;
                            break;
                        }
                        c = 65535;
                        break;
                    case 605322756:
                        if (key.equals("background-color")) {
                            c = 6;
                            break;
                        }
                        c = 65535;
                        break;
                    case 746232421:
                        if (key.equals("text-align")) {
                            c = 7;
                            break;
                        }
                        c = 65535;
                        break;
                    case 1287124693:
                        if (key.equals("backgroundColor")) {
                            c = '\b';
                            break;
                        }
                        c = 65535;
                        break;
                    default:
                        c = 65535;
                        break;
                }
                switch (c) {
                    case 0:
                    case 4:
                        String valueOf = String.valueOf(entry.getValue());
                        if (valueOf.endsWith("px")) {
                            valueOf = valueOf.replaceAll("px", "");
                        } else if (valueOf.endsWith("wx")) {
                            valueOf = valueOf.replaceAll("wx", "");
                        }
                        HashMap hashMap = new HashMap(1);
                        hashMap.put(Constants.Name.FONT_SIZE, valueOf);
                        absoluteSizeSpan = new AbsoluteSizeSpan(WXUtils.getInteger(Integer.valueOf(WXStyle.getFontSize(hashMap, getInstance().getDefaultFontSize(), getInstance().getInstanceViewPortWidthWithFloat())), Integer.valueOf(getInstance().getDefaultFontSize())).intValue());
                        break;
                    case 1:
                    case 7:
                        this.placeholderTextAlign = String.valueOf(entry.getValue());
                        int textAlign2 = getTextAlign(String.valueOf(entry.getValue()));
                        if (textAlign2 > 0) {
                            ((WXEditText) getHostView()).setGravity(textAlign2 | getVerticalGravity());
                            break;
                        } else {
                            break;
                        }
                    case 2:
                    case 5:
                        String valueOf2 = String.valueOf(entry.getValue());
                        valueOf2.hashCode();
                        switch (valueOf2.hashCode()) {
                            case 53430:
                                if (valueOf2.equals("600")) {
                                    c2 = 0;
                                    break;
                                }
                                break;
                            case 54391:
                                if (valueOf2.equals("700")) {
                                    c2 = 1;
                                    break;
                                }
                                break;
                            case 55352:
                                if (valueOf2.equals("800")) {
                                    c2 = 2;
                                    break;
                                }
                                break;
                            case 56313:
                                if (valueOf2.equals("900")) {
                                    c2 = 3;
                                    break;
                                }
                                break;
                            case 3029637:
                                if (valueOf2.equals(Constants.Value.BOLD)) {
                                    c2 = 4;
                                    break;
                                }
                                break;
                        }
                        switch (c2) {
                            case 0:
                            case 1:
                            case 2:
                            case 3:
                            case 4:
                                styleSpan = new StyleSpan(1);
                                continue;
                            default:
                                styleSpan = new StyleSpan(0);
                                continue;
                        }
                    case 3:
                        int color = WXResourceUtils.getColor(String.valueOf(entry.getValue()));
                        if (color != Integer.MIN_VALUE) {
                            foregroundColorSpan = new ForegroundColorSpan(color);
                            break;
                        } else {
                            break;
                        }
                    case 6:
                    case '\b':
                        int color2 = WXResourceUtils.getColor(String.valueOf(entry.getValue()));
                        if (color2 != Integer.MIN_VALUE) {
                            backgroundColorSpan = new BackgroundColorSpan(color2);
                            break;
                        } else {
                            break;
                        }
                }
            }
            spannableString.setSpan(absoluteSizeSpan, 0, spannableString.length(), 33);
            if (backgroundColorSpan != null) {
                spannableString.setSpan(backgroundColorSpan, 0, spannableString.length(), 33);
            }
            if (styleSpan != null) {
                spannableString.setSpan(styleSpan, 0, spannableString.length(), 33);
            }
            spannableString.setSpan(foregroundColorSpan, 0, spannableString.length(), 33);
            ((WXEditText) getHostView()).setHint(spannableString);
        }
    }

    @WXComponentProp(name = "placeholderClass")
    public void setPlaceholderClass(JSONObject jSONObject) {
        setPlaceholderStyle(jSONObject);
    }

    @WXComponentProp(name = Constants.Name.TEXT_ALIGN)
    public void setTextAlign(String str) {
        this.textAlign = str;
        int textAlign2 = getTextAlign(str);
        if (textAlign2 > 0) {
            ((WXEditText) getHostView()).setGravity(textAlign2 | getVerticalGravity());
        }
    }

    @WXComponentProp(name = Constants.Name.SINGLELINE)
    public void setSingleLine(boolean z) {
        if (getHostView() != null) {
            ((WXEditText) getHostView()).setSingleLine(z);
        }
    }

    @WXComponentProp(name = Constants.Name.LINES)
    public void setLines(int i) {
        if (getHostView() != null) {
            ((WXEditText) getHostView()).setLines(i);
        }
    }

    @WXComponentProp(name = Constants.Name.MAX_LENGTH)
    public void setMaxLength(int i) {
        if (getHostView() != null) {
            if (i == -1) {
                i = Integer.MAX_VALUE;
            }
            ((WXEditText) getHostView()).setFilters(new InputFilter[]{new InputFilter.LengthFilter(i)});
        }
    }

    @WXComponentProp(name = Constants.Name.MAXLENGTH)
    @Deprecated
    public void setMaxlength(int i) {
        setMaxLength(i);
    }

    private int getInputType(String str) {
        str.hashCode();
        char c = 65535;
        switch (str.hashCode()) {
            case -1034364087:
                if (str.equals("number")) {
                    c = 0;
                    break;
                }
                break;
            case 114715:
                if (str.equals(Constants.Value.TEL)) {
                    c = 1;
                    break;
                }
                break;
            case 116079:
                if (str.equals("url")) {
                    c = 2;
                    break;
                }
                break;
            case 3076014:
                if (str.equals("date")) {
                    c = 3;
                    break;
                }
                break;
            case 3556653:
                if (str.equals("text")) {
                    c = 4;
                    break;
                }
                break;
            case 3560141:
                if (str.equals(Constants.Value.TIME)) {
                    c = 5;
                    break;
                }
                break;
            case 95582509:
                if (str.equals("digit")) {
                    c = 6;
                    break;
                }
                break;
            case 96619420:
                if (str.equals("email")) {
                    c = 7;
                    break;
                }
                break;
            case 1216985755:
                if (str.equals(Constants.Value.PASSWORD)) {
                    c = '\b';
                    break;
                }
                break;
            case 1793702779:
                if (str.equals(Constants.Value.DATETIME)) {
                    c = '\t';
                    break;
                }
                break;
        }
        switch (c) {
            case 0:
                return 2;
            case 1:
                return 3;
            case 2:
                return 17;
            case 3:
                ((WXEditText) getHostView()).setFocusable(false);
                break;
            case 4:
            default:
                return 1;
            case 5:
                if (getHostView() != null) {
                    ((WXEditText) getHostView()).setFocusable(false);
                    break;
                }
                break;
            case 6:
                return 8194;
            case 7:
                return 33;
            case '\b':
                if (getHostView() == null) {
                    return 129;
                }
                ((WXEditText) getHostView()).setTransformationMethod(PasswordTransformationMethod.getInstance());
                return 129;
            case '\t':
                return 4;
        }
        return 0;
    }

    @WXComponentProp(name = UniConstants.Name.CURSOR_SPACING)
    public void setCursorSpacing(String str) {
        if (getHostView() != null) {
            ((WXEditText) getHostView()).setCursorSpacing(UniViewUtils.getRealPxByWidth(UniUtils.getFloat(str), getInstance().getInstanceViewPortWidthWithFloat()));
        }
    }

    private void showSoftKeyboard() {
        if (getHostView() != null) {
            ((WXEditText) getHostView()).postDelayed(WXThread.secure(new Runnable() {
                /* class com.taobao.weex.ui.component.DCWXInput.AnonymousClass10 */

                public void run() {
                    DCWXInput.this.mInputMethodManager.showSoftInput(DCWXInput.this.getHostView(), 1);
                }
            }), 100);
        }
    }

    /* access modifiers changed from: package-private */
    public void hideSoftKeyboard() {
        if (getHostView() != null) {
            ((WXEditText) getHostView()).postDelayed(WXThread.secure(new Runnable() {
                /* class com.taobao.weex.ui.component.DCWXInput.AnonymousClass11 */

                public void run() {
                    DCWXInput.this.mInputMethodManager.hideSoftInputFromWindow(((WXEditText) DCWXInput.this.getHostView()).getWindowToken(), 0);
                }
            }), 16);
        }
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private int getTextAlign(String str) {
        int i = isLayoutRTL() ? GravityCompat.END : GravityCompat.START;
        if (TextUtils.isEmpty(str)) {
            return i;
        }
        str.hashCode();
        char c = 65535;
        switch (str.hashCode()) {
            case -1364013995:
                if (str.equals("center")) {
                    c = 0;
                    break;
                }
                break;
            case 3317767:
                if (str.equals("left")) {
                    c = 1;
                    break;
                }
                break;
            case 108511772:
                if (str.equals("right")) {
                    c = 2;
                    break;
                }
                break;
        }
        switch (c) {
            case 0:
                return 17;
            case 1:
                return GravityCompat.START;
            case 2:
                return GravityCompat.END;
            default:
                return i;
        }
    }

    @JSMethod
    public void blur() {
        WXEditText wXEditText = (WXEditText) getHostView();
        if (wXEditText != null && wXEditText.hasFocus()) {
            if (getParent() != null) {
                getParent().interceptFocus();
            }
            wXEditText.clearFocus();
            hideSoftKeyboard();
        }
    }

    public String getValue() {
        return ((WXEditText) getHostView()).getText().toString();
    }

    @JSMethod
    public void setValue(String str) {
        ((WXEditText) getHostView()).setText(str);
    }

    @JSMethod
    public void focus() {
        WXEditText wXEditText = (WXEditText) getHostView();
        if (wXEditText != null && !wXEditText.hasFocus()) {
            if (getParent() != null) {
                getParent().ignoreFocus();
            }
            wXEditText.requestFocus();
            wXEditText.setFocusable(true);
            wXEditText.setFocusableInTouchMode(true);
            showSoftKeyboard();
        }
    }

    /* access modifiers changed from: protected */
    @Override // com.taobao.weex.ui.component.WXComponent
    public Object convertEmptyProperty(String str, Object obj) {
        str.hashCode();
        if (str.equals("color")) {
            return "black";
        }
        if (!str.equals(Constants.Name.FONT_SIZE)) {
            return super.convertEmptyProperty(str, obj);
        }
        return Integer.valueOf(getInstance().getDefaultFontSize());
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void decideSoftKeyboard() {
        View hostView = getHostView();
        if (hostView != null) {
            final Context context = getContext();
            if (context instanceof Activity) {
                hostView.postDelayed(WXThread.secure(new Runnable() {
                    /* class com.taobao.weex.ui.component.DCWXInput.AnonymousClass12 */

                    public void run() {
                        View currentFocus = ((Activity) context).getCurrentFocus();
                        if (currentFocus != null && !(currentFocus instanceof EditText) && !currentFocus.isFocused()) {
                            DCWXInput.this.mInputMethodManager.hideSoftInputFromWindow(((WXEditText) DCWXInput.this.getHostView()).getWindowToken(), 0);
                        }
                    }
                }), 16);
            }
        }
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void setSelectionRange(int i, int i2) {
        EditText editText;
        if (i2 != Integer.MAX_VALUE && i != Integer.MAX_VALUE && (editText = (EditText) getHostView()) != null) {
            int length = ((WXEditText) getHostView()).length();
            if (i <= i2) {
                int i3 = 0;
                if (i < 0) {
                    i = 0;
                }
                if (i2 > length) {
                    i2 = length;
                }
                if (i2 >= 0) {
                    i3 = i2;
                }
                editText.setSelection(i, i3);
            }
        }
    }

    @UniJSMethod
    public void getSelectionRange(String str) {
        HashMap hashMap = new HashMap(2);
        EditText editText = (EditText) getHostView();
        if (editText != null) {
            int selectionStart2 = editText.getSelectionStart();
            int selectionEnd2 = editText.getSelectionEnd();
            if (!editText.hasFocus()) {
                selectionStart2 = 0;
                selectionEnd2 = 0;
            }
            hashMap.put(Constants.Name.SELECTION_START, Integer.valueOf(selectionStart2));
            hashMap.put(Constants.Name.SELECTION_END, Integer.valueOf(selectionEnd2));
        }
        WXBridgeManager.getInstance().callback(getInstanceId(), str, hashMap, false);
    }

    @UniJSMethod
    public void getCursor(JSCallback jSCallback) {
        HashMap hashMap = new HashMap(1);
        if (getHostView() == null || !((WXEditText) getHostView()).isFocused()) {
            hashMap.put("cursor", 0);
        } else {
            hashMap.put("cursor", Integer.valueOf(((WXEditText) getHostView()).getSelectionEnd()));
        }
        jSCallback.invoke(hashMap);
    }

    @JSMethod
    public void setTextFormatter(JSONObject jSONObject) {
        try {
            String string = jSONObject.getString("formatRule");
            String string2 = jSONObject.getString("formatReplace");
            String string3 = jSONObject.getString("recoverRule");
            String string4 = jSONObject.getString("recoverReplace");
            PatternWrapper parseToPattern = parseToPattern(string, string2);
            PatternWrapper parseToPattern2 = parseToPattern(string3, string4);
            if (parseToPattern != null && parseToPattern2 != null) {
                this.mFormatter = new TextFormatter(parseToPattern, parseToPattern2);
            }
        } catch (Throwable th) {
            th.printStackTrace();
        }
    }

    private final void addEditorActionListener(TextView.OnEditorActionListener onEditorActionListener) {
        TextView textView;
        if (onEditorActionListener != null && (textView = (TextView) getHostView()) != null) {
            if (this.mEditorActionListeners == null) {
                this.mEditorActionListeners = new ArrayList();
                textView.setOnEditorActionListener(new TextView.OnEditorActionListener() {
                    /* class com.taobao.weex.ui.component.DCWXInput.AnonymousClass13 */
                    private boolean handled = true;

                    public boolean onEditorAction(TextView textView, int i, KeyEvent keyEvent) {
                        for (TextView.OnEditorActionListener onEditorActionListener : DCWXInput.this.mEditorActionListeners) {
                            if (onEditorActionListener != null) {
                                this.handled = onEditorActionListener.onEditorAction(textView, i, keyEvent) & this.handled;
                            }
                        }
                        return this.handled;
                    }
                });
            }
            this.mEditorActionListeners.add(onEditorActionListener);
        }
    }

    /* access modifiers changed from: package-private */
    public void addTextChangedListener(TextWatcher textWatcher) {
        if (this.mTextChangedListeners == null) {
            this.mTextChangedListeners = new ArrayList();
        }
        this.mTextChangedListeners.add(textWatcher);
    }

    private void addKeyboardListener(final WXEditText wXEditText) {
        if (wXEditText != null && (wXEditText.getContext() instanceof Activity)) {
            ((WXEditText) getHostView()).setkeyBoardHeightChangeListener(new DCEditText.OnKeyboardHeightChangeListener() {
                /* class com.taobao.weex.ui.component.DCWXInput.AnonymousClass14 */

                @Override // io.dcloud.common.core.ui.keyboard.DCEditText.OnKeyboardHeightChangeListener
                public void onChange(boolean z, int i) {
                    if (DCWXInput.this.getInstance() != null && !DCWXInput.this.getInstance().isDestroy() && wXEditText != null) {
                        DCWXInput dCWXInput = DCWXInput.this;
                        dCWXInput.keyboardHeight = (float) ((int) WXViewUtils.getWebPxByWidth((float) i, dCWXInput.getInstance().getInstanceViewPortWidthWithFloat()));
                        HashMap hashMap = new HashMap(2);
                        hashMap.put("height", Float.valueOf(DCWXInput.this.keyboardHeight));
                        hashMap.put("duration", 0);
                        HashMap hashMap2 = new HashMap(1);
                        hashMap2.put("detail", hashMap);
                        DCWXInput.this.fireEvent("keyboardheightchange", hashMap2);
                        if (wXEditText.isFocused()) {
                            String str = DCWXInput.this.isPassword ? Constants.Value.PASSWORD : DCWXInput.this.mType;
                            if (!z && !DCWXInput.this.isConfirmHold && !str.equalsIgnoreCase(Constants.Value.PASSWORD) && !DCKeyboardManager.getInstance().getFrontInputType().equals(Constants.Value.PASSWORD)) {
                                DCWXInput.this.blur();
                            }
                            if (z) {
                                DCKeyboardManager.getInstance().setFrontInputType(str);
                            }
                        }
                        if (z) {
                            DCWXInput dCWXInput2 = DCWXInput.this;
                            dCWXInput2.keyboardHeight = dCWXInput2.keyboardHeight;
                        }
                    }
                }
            });
        }
    }

    @Override // com.taobao.weex.ui.component.WXComponent
    public void updateProperties(Map<String, Object> map) {
        String str;
        if (map != null && map.size() > 0) {
            setType(map.containsKey("type") ? String.valueOf(map.get("type")) : this.mType);
            String str2 = this.mType;
            if (str2 != null && str2.equals("text") && map.containsKey("confirmType")) {
                if (map.containsKey("confirmType")) {
                    str = String.valueOf(map.get("confirmType"));
                } else {
                    str = this.mReturnKeyType;
                    if (str == null) {
                        str = "done";
                    }
                }
                setReturnKeyType(str);
            }
            WXAttr attrs = getAttrs();
            String str3 = Constants.Value.PASSWORD;
            if (attrs.containsKey(str3)) {
                boolean booleanValue = WXUtils.getBoolean(getAttrs().get(str3), false).booleanValue();
                this.isPassword = booleanValue;
                if (!booleanValue) {
                    str3 = this.mType;
                }
                if (str3 != null && getHostView() != null) {
                    ((EditText) getHostView()).setInputType(getInputType(str3));
                } else {
                    return;
                }
            }
            if (map.containsKey("cursor")) {
                this.cursor = WXUtils.getInteger(map.get("cursor"), 0).intValue();
            }
            if (map.containsKey(Constants.Name.SELECTION_START)) {
                this.selectionStart = WXUtils.getInteger(map.get(Constants.Name.SELECTION_START), Integer.MAX_VALUE).intValue();
            }
            if (map.containsKey(Constants.Name.SELECTION_END)) {
                this.selectionEnd = WXUtils.getInteger(map.get(Constants.Name.SELECTION_END), Integer.MAX_VALUE).intValue();
            }
            if (map.containsKey(Constants.Name.PLACEHOLDER)) {
                setPlaceholder(WXUtils.getString(map.get(Constants.Name.PLACEHOLDER), ""));
            }
            if (map.containsKey("placeholderClass")) {
                this.placeholderStyle.putAll((JSONObject) JSONObject.parse(WXUtils.getString(map.get("placeholderClass"), "{}")));
            }
            if (map.containsKey("placeholderStyle")) {
                this.placeholderStyle.putAll((JSONObject) JSONObject.parse(WXUtils.getString(map.get("placeholderStyle"), "{}")));
            }
            if (map.containsKey("adjustPosition")) {
                setAdjustPosition(map.get("adjustPosition"));
            }
        }
        super.updateProperties(map);
    }

    @Override // com.taobao.weex.ui.component.WXComponent
    public void destroy() {
        super.destroy();
        List<TextView.OnEditorActionListener> list = this.mEditorActionListeners;
        if (list != null) {
            list.clear();
        }
        List<TextWatcher> list2 = this.mTextChangedListeners;
        if (list2 != null) {
            list2.clear();
        }
        if (this.mTextChangedEventDispatcher != null) {
            this.mTextChangedEventDispatcher = null;
        }
        if (getHostView() != null) {
            ((WXEditText) getHostView()).destroy();
        }
    }

    private PatternWrapper parseToPattern(String str, String str2) {
        Pattern pattern;
        if (str == null || str2 == null) {
            return null;
        }
        if (!Pattern.compile("/[\\S]+/[i]?[m]?[g]?").matcher(str).matches()) {
            WXLogUtils.w("WXInput", "Illegal js pattern syntax: " + str);
            return null;
        }
        int i = 0;
        String substring = str.substring(str.lastIndexOf("/") + 1);
        String substring2 = str.substring(str.indexOf("/") + 1, str.lastIndexOf("/"));
        if (substring.contains(ContextChain.TAG_INFRA)) {
            i = 2;
        }
        if (substring.contains(WXComponent.PROP_FS_MATCH_PARENT)) {
            i |= 32;
        }
        boolean contains = substring.contains("g");
        try {
            pattern = Pattern.compile(substring2, i);
        } catch (PatternSyntaxException unused) {
            WXLogUtils.w("WXInput", "Pattern syntax error: " + substring2);
            pattern = null;
        }
        if (pattern == null) {
            return null;
        }
        PatternWrapper patternWrapper = new PatternWrapper();
        patternWrapper.global = contains;
        patternWrapper.matcher = pattern;
        patternWrapper.replace = str2;
        return patternWrapper;
    }

    /* access modifiers changed from: private */
    public static class PatternWrapper {
        private boolean global;
        private Pattern matcher;
        private String replace;

        private PatternWrapper() {
            this.global = false;
        }
    }

    public static class TextFormatter {
        private PatternWrapper format;
        private PatternWrapper recover;

        private TextFormatter(PatternWrapper patternWrapper, PatternWrapper patternWrapper2) {
            this.format = patternWrapper;
            this.recover = patternWrapper2;
        }

        /* access modifiers changed from: package-private */
        public String format(String str) {
            try {
                PatternWrapper patternWrapper = this.format;
                if (patternWrapper != null) {
                    if (patternWrapper.global) {
                        return this.format.matcher.matcher(str).replaceAll(this.format.replace);
                    }
                    return this.format.matcher.matcher(str).replaceFirst(this.format.replace);
                }
            } catch (Throwable th) {
                WXLogUtils.w("WXInput", "[format] " + th.getMessage());
            }
            return str;
        }

        /* access modifiers changed from: package-private */
        public String recover(String str) {
            try {
                PatternWrapper patternWrapper = this.recover;
                if (patternWrapper != null) {
                    if (patternWrapper.global) {
                        return this.recover.matcher.matcher(str).replaceAll(this.recover.replace);
                    }
                    return this.recover.matcher.matcher(str).replaceFirst(this.recover.replace);
                }
            } catch (Throwable th) {
                WXLogUtils.w("WXInput", "[formatted] " + th.getMessage());
            }
            return str;
        }
    }
}
