package com.taobao.weex.ui;

import android.util.Log;
import android.util.Pair;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.annotation.Component;
import com.taobao.weex.annotation.JSMethod;
import com.taobao.weex.bridge.Invoker;
import com.taobao.weex.bridge.MethodInvoker;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.common.WXErrorCode;
import com.taobao.weex.common.WXRuntimeException;
import com.taobao.weex.ui.action.BasicComponentData;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.utils.WXExceptionUtils;
import com.taobao.weex.utils.WXLogUtils;
import io.dcloud.feature.uniapp.UniSDKInstance;
import io.dcloud.feature.uniapp.annotation.UniJSMethod;
import io.dcloud.feature.uniapp.ui.action.AbsComponentData;
import io.dcloud.feature.uniapp.ui.component.AbsVContainer;
import io.dcloud.feature.uniapp.ui.component.UniComponent;
import io.dcloud.feature.uniapp.ui.component.UniComponentProp;
import io.dcloud.feature.uniapp.ui.component.UniVContainer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SimpleComponentHolder implements IFComponentHolder {
    public static final String TAG = "SimpleComponentHolder";
    private final Class<? extends WXComponent> mClz;
    private ComponentCreator mCreator;
    private Map<String, Invoker> mMethodInvokers;
    private Map<String, Invoker> mPropertyInvokers;

    public static class ClazzComponentCreator implements ComponentCreator {
        private Constructor<? extends WXComponent> mAbsConstructor;
        private final Class<? extends WXComponent> mCompClz;
        private Constructor<? extends WXComponent> mConstructor;

        public ClazzComponentCreator(Class<? extends WXComponent> cls) {
            this.mCompClz = cls;
        }

        private Constructor<? extends WXComponent> getComponentConstructor(Boolean bool) {
            Class<?> cls;
            Class<?> cls2;
            Class<?> cls3;
            Class<? extends WXComponent> cls4 = this.mCompClz;
            if (bool.booleanValue()) {
                cls = UniSDKInstance.class;
                cls3 = AbsVContainer.class;
                cls2 = AbsComponentData.class;
            } else {
                cls = WXSDKInstance.class;
                cls3 = WXVContainer.class;
                cls2 = BasicComponentData.class;
            }
            try {
                return cls4.getConstructor(cls, cls3, cls2);
            } catch (NoSuchMethodException unused) {
                WXLogUtils.d("ClazzComponentCreator", "Use deprecated component constructor");
                try {
                    return cls4.getConstructor(cls, cls3, Boolean.TYPE, cls2);
                } catch (NoSuchMethodException unused2) {
                    try {
                        return cls4.getConstructor(cls, cls3, String.class, Boolean.TYPE, cls2);
                    } catch (NoSuchMethodException unused3) {
                        Log.e("shutao", "        " + cls4.getSuperclass().getSimpleName());
                        throw new WXRuntimeException("Can't find constructor of component.");
                    }
                }
            }
        }

        @Override // com.taobao.weex.ui.ComponentCreator
        public WXComponent createInstance(WXSDKInstance wXSDKInstance, WXVContainer wXVContainer, BasicComponentData basicComponentData) throws IllegalAccessException, InvocationTargetException, InstantiationException {
            Constructor<? extends WXComponent> constructor;
            boolean z = UniVContainer.class.isAssignableFrom(this.mCompClz) || UniComponent.class.isAssignableFrom(this.mCompClz);
            if (z) {
                if (this.mAbsConstructor == null) {
                    this.mAbsConstructor = getComponentConstructor(Boolean.valueOf(z));
                }
                constructor = this.mAbsConstructor;
            } else {
                if (this.mConstructor == null) {
                    this.mConstructor = getComponentConstructor(Boolean.valueOf(z));
                }
                constructor = this.mConstructor;
            }
            int length = constructor.getParameterTypes().length;
            if (length == 3) {
                return (WXComponent) constructor.newInstance(wXSDKInstance, wXVContainer, basicComponentData);
            } else if (length == 4) {
                return (WXComponent) constructor.newInstance(wXSDKInstance, wXVContainer, false, basicComponentData);
            } else {
                return (WXComponent) constructor.newInstance(wXSDKInstance, wXVContainer, wXSDKInstance.getInstanceId(), Boolean.valueOf(wXVContainer.isLazy()));
            }
        }
    }

    public SimpleComponentHolder(Class<? extends WXComponent> cls) {
        this(cls, new ClazzComponentCreator(cls));
    }

    public SimpleComponentHolder(Class<? extends WXComponent> cls, ComponentCreator componentCreator) {
        this.mClz = cls;
        this.mCreator = componentCreator;
    }

    @Override // io.dcloud.feature.uniapp.ui.AbsIComponentHolder
    public void loadIfNonLazy() {
        Annotation[] declaredAnnotations = this.mClz.getDeclaredAnnotations();
        for (Annotation annotation : declaredAnnotations) {
            if (annotation instanceof Component) {
                if (!((Component) annotation).lazyload() && this.mMethodInvokers == null) {
                    generate();
                    return;
                } else {
                    return;
                }
            }
        }
    }

    private synchronized void generate() {
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.d("SimpleComponentHolder", "Generate Component:" + this.mClz.getSimpleName());
        }
        Pair<Map<String, Invoker>, Map<String, Invoker>> methods = getMethods(this.mClz);
        this.mPropertyInvokers = (Map) methods.first;
        this.mMethodInvokers = (Map) methods.second;
    }

    public static Pair<Map<String, Invoker>, Map<String, Invoker>> getMethods(Class cls) {
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        try {
            Method[] methods = cls.getMethods();
            for (Method method : methods) {
                Annotation[] declaredAnnotations = method.getDeclaredAnnotations();
                int length = declaredAnnotations.length;
                int i = 0;
                while (true) {
                    if (i >= length) {
                        break;
                    }
                    Annotation annotation = declaredAnnotations[i];
                    if (annotation != null) {
                        if (annotation instanceof WXComponentProp) {
                            hashMap.put(((WXComponentProp) annotation).name(), new MethodInvoker(method, true));
                            break;
                        } else if (annotation instanceof JSMethod) {
                            try {
                                JSMethod jSMethod = (JSMethod) annotation;
                                String alias = jSMethod.alias();
                                if ("_".equals(alias)) {
                                    alias = method.getName();
                                }
                                hashMap2.put(alias, new MethodInvoker(method, jSMethod.uiThread()));
                            } catch (ArrayIndexOutOfBoundsException | IncompatibleClassChangeError unused) {
                            }
                        } else if (annotation instanceof UniComponentProp) {
                            hashMap.put(((UniComponentProp) annotation).name(), new MethodInvoker(method, true));
                            break;
                        } else if (annotation instanceof UniJSMethod) {
                            UniJSMethod uniJSMethod = (UniJSMethod) annotation;
                            String alias2 = uniJSMethod.alias();
                            if ("_".equals(alias2)) {
                                alias2 = method.getName();
                            }
                            hashMap2.put(alias2, new MethodInvoker(method, uniJSMethod.uiThread()));
                        }
                    }
                    i++;
                }
            }
        } catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        } catch (Exception e2) {
            WXLogUtils.e("SimpleComponentHolder", e2);
        }
        return new Pair<>(hashMap, hashMap2);
    }

    @Override // com.taobao.weex.ui.ComponentCreator
    public synchronized WXComponent createInstance(WXSDKInstance wXSDKInstance, WXVContainer wXVContainer, BasicComponentData basicComponentData) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        WXComponent createInstance;
        createInstance = this.mCreator.createInstance(wXSDKInstance, wXVContainer, basicComponentData);
        createInstance.bindHolder(this);
        return createInstance;
    }

    @Override // io.dcloud.feature.uniapp.ui.AbsIComponentHolder
    public synchronized Invoker getPropertyInvoker(String str) {
        if (this.mPropertyInvokers == null) {
            generate();
        }
        return this.mPropertyInvokers.get(str);
    }

    @Override // com.taobao.weex.bridge.JavascriptInvokable
    public Invoker getMethodInvoker(String str) {
        if (this.mMethodInvokers == null) {
            generate();
        }
        return this.mMethodInvokers.get(str);
    }

    @Override // com.taobao.weex.bridge.JavascriptInvokable
    public synchronized String[] getMethods() {
        Set<String> keySet;
        if (this.mMethodInvokers == null) {
            generate();
        }
        keySet = this.mMethodInvokers.keySet();
        try {
        } catch (Throwable unused) {
            Class<? extends WXComponent> cls = this.mClz;
            if (cls != null) {
                String name = cls.getName();
                WXExceptionUtils.commitCriticalExceptionRT(null, WXErrorCode.WX_KEY_EXCEPTION_INVOKE_REGISTER_COMPONENT, WXBridgeManager.METHOD_REGISTER_COMPONENTS, name + ": gen methods failed", null);
            }
            return new String[1];
        }
        return (String[]) keySet.toArray(new String[keySet.size()]);
    }
}
