package com.taobao.weex.el.parse;

import com.taobao.weex.WXEnvironment;
import com.taobao.weex.utils.WXLogUtils;
import java.util.ArrayList;

public class Parser {
    private String code;
    private ArrayStack<Symbol> operators = new ArrayStack<>();
    private int position = 0;
    private ArrayStack<Token> stacks = new ArrayStack<>();

    public Parser(String str) {
        this.code = str;
    }

    public final Token parse() {
        while (hasNextToken()) {
            scanNextToken();
        }
        while (!this.operators.isEmpty()) {
            doOperator(this.operators.pop());
        }
        if (this.stacks.size() == 1) {
            return this.stacks.pop();
        }
        return new Block(this.stacks.getList(), 6);
    }

    public static Token parse(String str) {
        try {
            return new Parser(str).parse();
        } catch (Exception e) {
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.e("code " + str, e);
            }
            return new Block(null, 6);
        }
    }

    /* access modifiers changed from: package-private */
    public final char scanNextToken() {
        char nextToken = nextToken();
        if (nextToken == '$') {
            this.position++;
            return nextToken;
        }
        if (Character.isJavaIdentifierStart(nextToken)) {
            scanIdentifier();
        } else if (nextToken == '(' || nextToken == '{') {
            scanBracket();
        } else if (nextToken == '[') {
            scanArray();
        } else if (nextToken == '\"' || nextToken == '\'') {
            scanString();
        } else if ((nextToken == '.' && Character.isDigit(this.code.charAt(this.position + 1))) || Character.isDigit(nextToken)) {
            scanNumber();
        } else if (nextToken == '?') {
            scanIf();
        } else if (nextToken == ':' || nextToken == ')' || nextToken == '}' || nextToken == ' ' || nextToken == ']') {
            this.position++;
            return nextToken;
        } else {
            scanOperator();
        }
        return nextToken;
    }

    /* access modifiers changed from: package-private */
    /* JADX WARNING: Removed duplicated region for block: B:9:0x0043  */
    public final void scanArray() {
        Token token;
        int size = this.stacks.size();
        int size2 = this.operators.size();
        int i = this.position;
        int i2 = (i + -1 < 0 || !Character.isJavaIdentifierPart(this.code.charAt(i - 1))) ? 7 : 0;
        this.operators.push(new Symbol(Operators.ARRAY_START_STR, this.stacks.size()));
        this.position++;
        while (hasNextToken() && scanNextToken() != ']') {
            while (hasNextToken()) {
                while (hasNextToken()) {
                }
            }
        }
        if (this.stacks.size() <= size) {
            while (this.operators.size() > size2) {
                this.operators.pop();
            }
            return;
        }
        while (this.operators.size() > size2) {
            Symbol pop = this.operators.pop();
            if (this.stacks.size() > size) {
                doOperator(pop);
            }
        }
        ArrayList arrayList = new ArrayList(4);
        for (int i3 = size; i3 < this.stacks.size(); i3++) {
            arrayList.add(this.stacks.get(i3));
        }
        while (this.stacks.size() > size) {
            this.stacks.pop();
        }
        if (i2 == 7 || this.stacks.size() == 0) {
            this.stacks.push(new Block(arrayList, 7));
            return;
        }
        Token pop2 = this.stacks.pop();
        if (arrayList.size() == 1) {
            token = (Token) arrayList.get(0);
        } else {
            token = new Block(arrayList, 6);
        }
        Operator operator = new Operator(Operators.DOT_STR, i2);
        operator.first = pop2;
        operator.second = token;
        this.stacks.push(operator);
    }

    /* access modifiers changed from: package-private */
    /* JADX WARNING: Removed duplicated region for block: B:10:0x005d  */
    /* JADX WARNING: Removed duplicated region for block: B:5:0x0037  */
    public void scanBracket() {
        int size = this.stacks.size();
        int size2 = this.operators.size();
        if (this.code.charAt(this.position) == '{') {
            this.operators.push(new Symbol(Operators.BLOCK_START_STR, this.stacks.size()));
            this.position++;
            while (hasNextToken() && scanNextToken() != '}') {
                while (hasNextToken()) {
                    while (hasNextToken()) {
                    }
                }
            }
        } else {
            this.operators.push(new Symbol(Operators.BRACKET_START_STR, this.stacks.size()));
            this.position++;
            while (hasNextToken() && scanNextToken() != ')') {
                while (hasNextToken()) {
                    while (hasNextToken()) {
                    }
                }
            }
        }
        if (this.stacks.size() <= size) {
            while (this.operators.size() > size2) {
                this.operators.pop();
            }
            return;
        }
        while (this.operators.size() > size2) {
            Symbol pop = this.operators.pop();
            if (this.stacks.size() > size) {
                doOperator(pop);
            }
        }
        ArrayList arrayList = new ArrayList(4);
        for (int i = size; i < this.stacks.size(); i++) {
            arrayList.add(this.stacks.get(i));
        }
        while (this.stacks.size() > size) {
            this.stacks.pop();
        }
        if (arrayList.size() == 1) {
            this.stacks.push((Token) arrayList.get(0));
            return;
        }
        this.stacks.push(new Block(arrayList, 6));
    }

    /* access modifiers changed from: package-private */
    public void scanOperator() {
        int i = this.position;
        String substring = this.code.substring(this.position, Math.min(i + 3, this.code.length()));
        if (substring.length() >= 3 && !Operators.OPERATORS_PRIORITY.containsKey(substring)) {
            substring = substring.substring(0, 2);
        }
        if (substring.length() >= 2 && !Operators.OPERATORS_PRIORITY.containsKey(substring)) {
            substring = substring.substring(0, 1);
        }
        if (!Operators.OPERATORS_PRIORITY.containsKey(substring)) {
            int min = Math.min(i + 1, this.code.length());
            WXLogUtils.e("weex", new IllegalArgumentException(this.code.substring(0, min) + " illegal code operator" + substring));
            this.position = this.position + substring.length();
            return;
        }
        if (!this.operators.isEmpty() && this.operators.peek() != null) {
            if (Operators.OPERATORS_PRIORITY.get(this.operators.peek().op).intValue() >= Operators.OPERATORS_PRIORITY.get(substring).intValue()) {
                doOperator(this.operators.pop());
            }
        }
        if (!Operators.isOpEnd(substring)) {
            this.operators.push(new Symbol(substring, this.stacks.size()));
        }
        this.position += substring.length();
    }

    /* access modifiers changed from: package-private */
    public void doOperator(Symbol symbol) {
        String str = symbol.op;
        if (!Operators.BRACKET_START_STR.equals(symbol.op) && !Operators.BLOCK_START_STR.equals(symbol.op) && !Operators.ARRAY_START_STR.equals(symbol.op) && !Operators.DOLLAR_STR.equals(symbol.op) && !Operators.BLOCK_START_STR.equals(symbol.op)) {
            int i = symbol.pos;
            int max = Math.max(symbol.pos - 1, 0);
            if (!this.operators.isEmpty()) {
                max = Math.max(max, this.operators.peek().pos);
            }
            Operator operator = new Operator(str, 5);
            if (Operators.AND_NOT.equals(str)) {
                if (this.stacks.size() > i) {
                    operator.self = this.stacks.remove(i);
                    this.stacks.add(i, operator);
                }
            } else if (this.stacks.size() > i) {
                operator.second = this.stacks.remove(i);
                if (this.stacks.size() > max) {
                    operator.first = this.stacks.remove(max);
                } else if (operator.second == null) {
                    return;
                }
                this.stacks.add(max, operator);
            }
        }
    }

    /* access modifiers changed from: package-private */
    /* JADX WARNING: Removed duplicated region for block: B:9:0x004c  */
    public void scanIf() {
        Operator operator = new Operator(Operators.CONDITION_IF_STRING, 5);
        int i = 0;
        doStackOperators(0);
        if (this.operators.size() > 0) {
            i = Math.max(this.operators.peek().pos, 0);
        }
        if (this.stacks.size() > i) {
            operator.self = this.stacks.pop();
        }
        int size = this.stacks.size();
        int size2 = this.operators.size();
        this.position++;
        while (hasNextToken() && scanNextToken() != ':') {
            while (hasNextToken()) {
                while (hasNextToken()) {
                }
            }
        }
        while (this.operators.size() > size2) {
            doOperator(this.operators.pop());
        }
        while (this.stacks.size() > size) {
            operator.first = this.stacks.pop();
        }
        int size3 = this.operators.size();
        while (hasNextToken()) {
            scanNextToken();
            if (hasNextToken()) {
                scanNextToken();
            }
            if (this.operators.size() <= size3) {
                break;
            }
        }
        doStackOperators(size3);
        while (this.stacks.size() > size) {
            operator.second = this.stacks.pop();
        }
        this.stacks.push(operator);
    }

    private final void doStackOperators(int i) {
        while (this.operators.size() > i) {
            doOperator(this.operators.pop());
        }
    }

    /* access modifiers changed from: package-private */
    public final void scanNumber() {
        Token token;
        int i = this.position;
        boolean z = (this.code.charAt(i) == 'e' || this.code.charAt(this.position) == '.') ? false : true;
        this.position++;
        while (hasNext()) {
            char charAt = this.code.charAt(this.position);
            if (!Character.isDigit(charAt) && charAt != '.' && charAt != 'e') {
                break;
            }
            if (charAt == 'e' || charAt == '.') {
                z = false;
            }
            this.position++;
        }
        String substring = this.code.substring(i, this.position);
        if (!Operators.DOT_STR.equals(substring)) {
            if (z) {
                token = new Token(substring, 1);
            } else {
                token = new Token(substring, 2);
            }
            this.stacks.push(token);
        }
    }

    /* access modifiers changed from: package-private */
    public final void scanString() {
        int i = this.position;
        ArrayStack arrayStack = new ArrayStack();
        char charAt = this.code.charAt(i);
        arrayStack.push(Character.valueOf(charAt));
        StringBuilder sb = new StringBuilder();
        while (true) {
            this.position = i + 1;
            if (this.position >= this.code.length()) {
                break;
            }
            char charAt2 = this.code.charAt(this.position);
            if (charAt2 != charAt) {
                sb.append(charAt2);
            } else if (this.code.charAt(this.position - 1) != '\\') {
                arrayStack.pop();
                if (arrayStack.size() == 0) {
                    this.position++;
                    break;
                }
            } else {
                sb.deleteCharAt(sb.length() - 1);
                sb.append(charAt2);
            }
            i = this.position;
        }
        this.stacks.push(new Token(sb.toString(), 3));
    }

    /* access modifiers changed from: package-private */
    public final void scanIdentifier() {
        int i = this.position;
        this.position = i + 1;
        while (hasNext() && Character.isJavaIdentifierPart(this.code.charAt(this.position))) {
            this.position++;
        }
        String substring = this.code.substring(i, this.position);
        if (substring.startsWith(Operators.DOLLAR_STR)) {
            if (substring.length() != 1) {
                substring = substring.substring(1);
            } else {
                return;
            }
        }
        int i2 = 0;
        if (Operators.KEYWORDS.containsKey(substring) && (this.operators.isEmpty() || !Operators.isDot(this.operators.peek().op))) {
            i2 = 4;
        }
        this.stacks.push(new Token(substring, i2));
    }

    /* access modifiers changed from: package-private */
    public final boolean hasNext() {
        return this.position < this.code.length();
    }

    /* access modifiers changed from: package-private */
    public final boolean hasNextToken() {
        while (hasNext()) {
            if (this.code.charAt(this.position) != ' ') {
                return true;
            }
            this.position++;
        }
        return false;
    }

    /* access modifiers changed from: package-private */
    public final char nextToken() {
        char charAt = this.code.charAt(this.position);
        while (charAt == ' ') {
            this.position++;
            int length = this.code.length();
            int i = this.position;
            if (length <= i) {
                break;
            }
            charAt = this.code.charAt(i);
        }
        return charAt;
    }
}
